import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface HealthcareHl7V2StoreConfig extends cdktf.TerraformMetaArguments {
    /**
     * Identifies the dataset addressed by this request. Must be in the format 'projects/{project}/locations/{location}/datasets/{dataset}'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store#dataset HealthcareHl7V2Store#dataset}
     *
     * @stability stable
     */
    readonly dataset: string;
    /**
     * User-supplied key-value pairs used to organize HL7v2 stores.
     *
     * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and must
     * conform to the following PCRE regular expression: [\p{Ll}\p{Lo}][\p{Ll}\p{Lo}\p{N}_-]{0,62}
     *
     * Label values are optional, must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128
     * bytes, and must conform to the following PCRE regular expression: [\p{Ll}\p{Lo}\p{N}_-]{0,63}
     *
     * No more than 64 labels can be associated with a given store.
     *
     * An object containing a list of "key": value pairs.
     * Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store#labels HealthcareHl7V2Store#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The resource name for the Hl7V2Store.
     *
     * * Changing this property may recreate the Hl7v2 store (removing all data) **
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store#name HealthcareHl7V2Store#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * notification_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store#notification_config HealthcareHl7V2Store#notification_config}
     *
     * @stability stable
     */
    readonly notificationConfig?: HealthcareHl7V2StoreNotificationConfig;
    /**
     * notification_configs block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store#notification_configs HealthcareHl7V2Store#notification_configs}
     *
     * @stability stable
     */
    readonly notificationConfigs?: HealthcareHl7V2StoreNotificationConfigs[];
    /**
     * parser_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store#parser_config HealthcareHl7V2Store#parser_config}
     *
     * @stability stable
     */
    readonly parserConfig?: HealthcareHl7V2StoreParserConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store#timeouts HealthcareHl7V2Store#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: HealthcareHl7V2StoreTimeouts;
}
/**
 * @stability stable
 */
export interface HealthcareHl7V2StoreNotificationConfig {
    /**
     * The Cloud Pub/Sub topic that notifications of changes are published on.
     *
     * Supplied by the client.
     * PubsubMessage.Data will contain the resource name. PubsubMessage.MessageId is the ID of this message.
     * It is guaranteed to be unique within the topic. PubsubMessage.PublishTime is the time at which the message
     * was published. Notifications are only sent if the topic is non-empty. Topic names must be scoped to a
     * project. service-PROJECT_NUMBER@gcp-sa-healthcare.iam.gserviceaccount.com must have publisher permissions on the given
     * Cloud Pub/Sub topic. Not having adequate permissions will cause the calls that send notifications to fail.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store#pubsub_topic HealthcareHl7V2Store#pubsub_topic}
     *
     * @stability stable
     */
    readonly pubsubTopic: string;
}
export declare function healthcareHl7V2StoreNotificationConfigToTerraform(struct?: HealthcareHl7V2StoreNotificationConfigOutputReference | HealthcareHl7V2StoreNotificationConfig): any;
/**
 * @stability stable
 */
export declare class HealthcareHl7V2StoreNotificationConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HealthcareHl7V2StoreNotificationConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HealthcareHl7V2StoreNotificationConfig | undefined);
    private _pubsubTopic?;
    /**
     * @stability stable
     */
    get pubsubTopic(): string;
    /**
     * @stability stable
     */
    set pubsubTopic(value: string);
    /**
     * @stability stable
     */
    get pubsubTopicInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HealthcareHl7V2StoreNotificationConfigs {
    /**
     * Restricts notifications sent for messages matching a filter. If this is empty, all messages are matched. Syntax: https://cloud.google.com/appengine/docs/standard/python/search/query_strings.
     *
     * Fields/functions available for filtering are:
     *
     * messageType, from the MSH-9.1 field. For example, NOT messageType = "ADT".
     * send_date or sendDate, the YYYY-MM-DD date the message was sent in the dataset's timeZone, from the MSH-7 segment. For example, send_date < "2017-01-02".
     * sendTime, the timestamp when the message was sent, using the RFC3339 time format for comparisons, from the MSH-7 segment. For example, sendTime < "2017-01-02T00:00:00-05:00".
     * sendFacility, the care center that the message came from, from the MSH-4 segment. For example, sendFacility = "ABC".
     * PatientId(value, type), which matches if the message lists a patient having an ID of the given value and type in the PID-2, PID-3, or PID-4 segments. For example, PatientId("123456", "MRN").
     * labels.x, a string value of the label with key x as set using the Message.labels map. For example, labels."priority"="high". The operator :* can be used to assert the existence of a label. For example, labels."priority":*.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store#filter HealthcareHl7V2Store#filter}
     *
     * @stability stable
     */
    readonly filter?: string;
    /**
     * The Cloud Pub/Sub topic that notifications of changes are published on.
     *
     * Supplied by the client.
     * PubsubMessage.Data will contain the resource name. PubsubMessage.MessageId is the ID of this message.
     * It is guaranteed to be unique within the topic. PubsubMessage.PublishTime is the time at which the message
     * was published. Notifications are only sent if the topic is non-empty. Topic names must be scoped to a
     * project. service-PROJECT_NUMBER@gcp-sa-healthcare.iam.gserviceaccount.com must have publisher permissions on the given
     * Cloud Pub/Sub topic. Not having adequate permissions will cause the calls that send notifications to fail.
     *
     * If a notification cannot be published to Cloud Pub/Sub, errors will be logged to Stackdriver
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store#pubsub_topic HealthcareHl7V2Store#pubsub_topic}
     *
     * @stability stable
     */
    readonly pubsubTopic: string;
}
export declare function healthcareHl7V2StoreNotificationConfigsToTerraform(struct?: HealthcareHl7V2StoreNotificationConfigs): any;
/**
 * @stability stable
 */
export interface HealthcareHl7V2StoreParserConfig {
    /**
     * Determines whether messages with no header are allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store#allow_null_header HealthcareHl7V2Store#allow_null_header}
     *
     * @stability stable
     */
    readonly allowNullHeader?: boolean | cdktf.IResolvable;
    /**
     * JSON encoded string for schemas used to parse messages in this store if schematized parsing is desired.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store#schema HealthcareHl7V2Store#schema}
     *
     * @stability stable
     */
    readonly schema?: string;
    /**
     * Byte(s) to be used as the segment terminator. If this is unset, '\r' will be used as segment terminator.
     *
     * A base64-encoded string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store#segment_terminator HealthcareHl7V2Store#segment_terminator}
     *
     * @stability stable
     */
    readonly segmentTerminator?: string;
    /**
     * The version of the unschematized parser to be used when a custom 'schema' is not set.
     *
     * Default value: "V1" Possible values: ["V1", "V2"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store#version HealthcareHl7V2Store#version}
     *
     * @stability stable
     */
    readonly version?: string;
}
export declare function healthcareHl7V2StoreParserConfigToTerraform(struct?: HealthcareHl7V2StoreParserConfigOutputReference | HealthcareHl7V2StoreParserConfig): any;
/**
 * @stability stable
 */
export declare class HealthcareHl7V2StoreParserConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HealthcareHl7V2StoreParserConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HealthcareHl7V2StoreParserConfig | undefined);
    private _allowNullHeader?;
    /**
     * @stability stable
     */
    get allowNullHeader(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowNullHeader(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAllowNullHeader(): void;
    /**
     * @stability stable
     */
    get allowNullHeaderInput(): boolean | cdktf.IResolvable | undefined;
    private _schema?;
    /**
     * @stability stable
     */
    get schema(): string;
    /**
     * @stability stable
     */
    set schema(value: string);
    /**
     * @stability stable
     */
    resetSchema(): void;
    /**
     * @stability stable
     */
    get schemaInput(): string | undefined;
    private _segmentTerminator?;
    /**
     * @stability stable
     */
    get segmentTerminator(): string;
    /**
     * @stability stable
     */
    set segmentTerminator(value: string);
    /**
     * @stability stable
     */
    resetSegmentTerminator(): void;
    /**
     * @stability stable
     */
    get segmentTerminatorInput(): string | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    set version(value: string);
    /**
     * @stability stable
     */
    resetVersion(): void;
    /**
     * @stability stable
     */
    get versionInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HealthcareHl7V2StoreTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store#create HealthcareHl7V2Store#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store#delete HealthcareHl7V2Store#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store#update HealthcareHl7V2Store#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function healthcareHl7V2StoreTimeoutsToTerraform(struct?: HealthcareHl7V2StoreTimeoutsOutputReference | HealthcareHl7V2StoreTimeouts): any;
/**
 * @stability stable
 */
export declare class HealthcareHl7V2StoreTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HealthcareHl7V2StoreTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HealthcareHl7V2StoreTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store google_healthcare_hl7_v2_store}.
 *
 * @stability stable
 */
export declare class HealthcareHl7V2Store extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store google_healthcare_hl7_v2_store} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: HealthcareHl7V2StoreConfig);
    private _dataset?;
    /**
     * @stability stable
     */
    get dataset(): string;
    /**
     * @stability stable
     */
    set dataset(value: string);
    /**
     * @stability stable
     */
    get datasetInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _notificationConfig;
    /**
     * @stability stable
     */
    get notificationConfig(): HealthcareHl7V2StoreNotificationConfigOutputReference;
    /**
     * @stability stable
     */
    putNotificationConfig(value: HealthcareHl7V2StoreNotificationConfig): void;
    /**
     * @stability stable
     */
    resetNotificationConfig(): void;
    /**
     * @stability stable
     */
    get notificationConfigInput(): HealthcareHl7V2StoreNotificationConfig | undefined;
    private _notificationConfigs?;
    /**
     * @stability stable
     */
    get notificationConfigs(): HealthcareHl7V2StoreNotificationConfigs[];
    /**
     * @stability stable
     */
    set notificationConfigs(value: HealthcareHl7V2StoreNotificationConfigs[]);
    /**
     * @stability stable
     */
    resetNotificationConfigs(): void;
    /**
     * @stability stable
     */
    get notificationConfigsInput(): HealthcareHl7V2StoreNotificationConfigs[] | undefined;
    private _parserConfig;
    /**
     * @stability stable
     */
    get parserConfig(): HealthcareHl7V2StoreParserConfigOutputReference;
    /**
     * @stability stable
     */
    putParserConfig(value: HealthcareHl7V2StoreParserConfig): void;
    /**
     * @stability stable
     */
    resetParserConfig(): void;
    /**
     * @stability stable
     */
    get parserConfigInput(): HealthcareHl7V2StoreParserConfig | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): HealthcareHl7V2StoreTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: HealthcareHl7V2StoreTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): HealthcareHl7V2StoreTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
