import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface IdentityPlatformTenantInboundSamlConfigConfig extends cdktf.TerraformMetaArguments {
    /**
     * Human friendly display name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config#display_name IdentityPlatformTenantInboundSamlConfig#display_name}
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * If this config allows users to sign in with the provider.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config#enabled IdentityPlatformTenantInboundSamlConfig#enabled}
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * The name of the InboundSamlConfig resource.
     *
     * Must start with 'saml.' and can only have alphanumeric characters,
     * hyphens, underscores or periods. The part after 'saml.' must also start with a lowercase letter, end with an
     * alphanumeric character, and have at least 2 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config#name IdentityPlatformTenantInboundSamlConfig#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config#project IdentityPlatformTenantInboundSamlConfig#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The name of the tenant where this inbound SAML config resource exists.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config#tenant IdentityPlatformTenantInboundSamlConfig#tenant}
     *
     * @stability stable
     */
    readonly tenant: string;
    /**
     * idp_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config#idp_config IdentityPlatformTenantInboundSamlConfig#idp_config}
     *
     * @stability stable
     */
    readonly idpConfig: IdentityPlatformTenantInboundSamlConfigIdpConfig;
    /**
     * sp_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config#sp_config IdentityPlatformTenantInboundSamlConfig#sp_config}
     *
     * @stability stable
     */
    readonly spConfig: IdentityPlatformTenantInboundSamlConfigSpConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config#timeouts IdentityPlatformTenantInboundSamlConfig#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: IdentityPlatformTenantInboundSamlConfigTimeouts;
}
/**
 * @stability stable
 */
export interface IdentityPlatformTenantInboundSamlConfigIdpConfigIdpCertificates {
    /**
     * The x509 certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config#x509_certificate IdentityPlatformTenantInboundSamlConfig#x509_certificate}
     *
     * @stability stable
     */
    readonly x509Certificate?: string;
}
export declare function identityPlatformTenantInboundSamlConfigIdpConfigIdpCertificatesToTerraform(struct?: IdentityPlatformTenantInboundSamlConfigIdpConfigIdpCertificates): any;
/**
 * @stability stable
 */
export interface IdentityPlatformTenantInboundSamlConfigIdpConfig {
    /**
     * Unique identifier for all SAML entities.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config#idp_entity_id IdentityPlatformTenantInboundSamlConfig#idp_entity_id}
     *
     * @stability stable
     */
    readonly idpEntityId: string;
    /**
     * Indicates if outbounding SAMLRequest should be signed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config#sign_request IdentityPlatformTenantInboundSamlConfig#sign_request}
     *
     * @stability stable
     */
    readonly signRequest?: boolean | cdktf.IResolvable;
    /**
     * URL to send Authentication request to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config#sso_url IdentityPlatformTenantInboundSamlConfig#sso_url}
     *
     * @stability stable
     */
    readonly ssoUrl: string;
    /**
     * idp_certificates block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config#idp_certificates IdentityPlatformTenantInboundSamlConfig#idp_certificates}
     *
     * @stability stable
     */
    readonly idpCertificates: IdentityPlatformTenantInboundSamlConfigIdpConfigIdpCertificates[];
}
export declare function identityPlatformTenantInboundSamlConfigIdpConfigToTerraform(struct?: IdentityPlatformTenantInboundSamlConfigIdpConfigOutputReference | IdentityPlatformTenantInboundSamlConfigIdpConfig): any;
/**
 * @stability stable
 */
export declare class IdentityPlatformTenantInboundSamlConfigIdpConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): IdentityPlatformTenantInboundSamlConfigIdpConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: IdentityPlatformTenantInboundSamlConfigIdpConfig | undefined);
    private _idpEntityId?;
    /**
     * @stability stable
     */
    get idpEntityId(): string;
    /**
     * @stability stable
     */
    set idpEntityId(value: string);
    /**
     * @stability stable
     */
    get idpEntityIdInput(): string | undefined;
    private _signRequest?;
    /**
     * @stability stable
     */
    get signRequest(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set signRequest(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSignRequest(): void;
    /**
     * @stability stable
     */
    get signRequestInput(): boolean | cdktf.IResolvable | undefined;
    private _ssoUrl?;
    /**
     * @stability stable
     */
    get ssoUrl(): string;
    /**
     * @stability stable
     */
    set ssoUrl(value: string);
    /**
     * @stability stable
     */
    get ssoUrlInput(): string | undefined;
    private _idpCertificates?;
    /**
     * @stability stable
     */
    get idpCertificates(): IdentityPlatformTenantInboundSamlConfigIdpConfigIdpCertificates[];
    /**
     * @stability stable
     */
    set idpCertificates(value: IdentityPlatformTenantInboundSamlConfigIdpConfigIdpCertificates[]);
    /**
     * @stability stable
     */
    get idpCertificatesInput(): IdentityPlatformTenantInboundSamlConfigIdpConfigIdpCertificates[] | undefined;
}
/**
 * @stability stable
 */
export interface IdentityPlatformTenantInboundSamlConfigSpConfig {
    /**
     * Callback URI where responses from IDP are handled. Must start with 'https://'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config#callback_uri IdentityPlatformTenantInboundSamlConfig#callback_uri}
     *
     * @stability stable
     */
    readonly callbackUri: string;
    /**
     * Unique identifier for all SAML entities.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config#sp_entity_id IdentityPlatformTenantInboundSamlConfig#sp_entity_id}
     *
     * @stability stable
     */
    readonly spEntityId: string;
}
export declare function identityPlatformTenantInboundSamlConfigSpConfigToTerraform(struct?: IdentityPlatformTenantInboundSamlConfigSpConfigOutputReference | IdentityPlatformTenantInboundSamlConfigSpConfig): any;
/**
 * @stability stable
 */
export declare class IdentityPlatformTenantInboundSamlConfigSpConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): IdentityPlatformTenantInboundSamlConfigSpConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: IdentityPlatformTenantInboundSamlConfigSpConfig | undefined);
    private _callbackUri?;
    /**
     * @stability stable
     */
    get callbackUri(): string;
    /**
     * @stability stable
     */
    set callbackUri(value: string);
    /**
     * @stability stable
     */
    get callbackUriInput(): string | undefined;
    private _spEntityId?;
    /**
     * @stability stable
     */
    get spEntityId(): string;
    /**
     * @stability stable
     */
    set spEntityId(value: string);
    /**
     * @stability stable
     */
    get spEntityIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface IdentityPlatformTenantInboundSamlConfigTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config#create IdentityPlatformTenantInboundSamlConfig#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config#delete IdentityPlatformTenantInboundSamlConfig#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config#update IdentityPlatformTenantInboundSamlConfig#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function identityPlatformTenantInboundSamlConfigTimeoutsToTerraform(struct?: IdentityPlatformTenantInboundSamlConfigTimeoutsOutputReference | IdentityPlatformTenantInboundSamlConfigTimeouts): any;
/**
 * @stability stable
 */
export declare class IdentityPlatformTenantInboundSamlConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): IdentityPlatformTenantInboundSamlConfigTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: IdentityPlatformTenantInboundSamlConfigTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config google_identity_platform_tenant_inbound_saml_config}.
 *
 * @stability stable
 */
export declare class IdentityPlatformTenantInboundSamlConfig extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config google_identity_platform_tenant_inbound_saml_config} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: IdentityPlatformTenantInboundSamlConfigConfig);
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _tenant?;
    /**
     * @stability stable
     */
    get tenant(): string;
    /**
     * @stability stable
     */
    set tenant(value: string);
    /**
     * @stability stable
     */
    get tenantInput(): string | undefined;
    private _idpConfig;
    /**
     * @stability stable
     */
    get idpConfig(): IdentityPlatformTenantInboundSamlConfigIdpConfigOutputReference;
    /**
     * @stability stable
     */
    putIdpConfig(value: IdentityPlatformTenantInboundSamlConfigIdpConfig): void;
    /**
     * @stability stable
     */
    get idpConfigInput(): IdentityPlatformTenantInboundSamlConfigIdpConfig | undefined;
    private _spConfig;
    /**
     * @stability stable
     */
    get spConfig(): IdentityPlatformTenantInboundSamlConfigSpConfigOutputReference;
    /**
     * @stability stable
     */
    putSpConfig(value: IdentityPlatformTenantInboundSamlConfigSpConfig): void;
    /**
     * @stability stable
     */
    get spConfigInput(): IdentityPlatformTenantInboundSamlConfigSpConfig | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): IdentityPlatformTenantInboundSamlConfigTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: IdentityPlatformTenantInboundSamlConfigTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): IdentityPlatformTenantInboundSamlConfigTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
