import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface NotebooksEnvironmentConfig extends cdktf.TerraformMetaArguments {
    /**
     * A brief description of this environment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment#description NotebooksEnvironment#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Display name of this environment for the UI.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment#display_name NotebooksEnvironment#display_name}
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * A reference to the zone where the machine resides.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment#location NotebooksEnvironment#location}
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * The name specified for the Environment instance. Format: projects/{project_id}/locations/{location}/environments/{environmentId}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment#name NotebooksEnvironment#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Path to a Bash script that automatically runs after a notebook instance fully boots up.
     *
     * The path must be a URL or Cloud Storage path. Example: "gs://path-to-file/file-name"
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment#post_startup_script NotebooksEnvironment#post_startup_script}
     *
     * @stability stable
     */
    readonly postStartupScript?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment#project NotebooksEnvironment#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * container_image block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment#container_image NotebooksEnvironment#container_image}
     *
     * @stability stable
     */
    readonly containerImage?: NotebooksEnvironmentContainerImage;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment#timeouts NotebooksEnvironment#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: NotebooksEnvironmentTimeouts;
    /**
     * vm_image block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment#vm_image NotebooksEnvironment#vm_image}
     *
     * @stability stable
     */
    readonly vmImage?: NotebooksEnvironmentVmImage;
}
/**
 * @stability stable
 */
export interface NotebooksEnvironmentContainerImage {
    /**
     * The path to the container image repository. For example: gcr.io/{project_id}/{imageName}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment#repository NotebooksEnvironment#repository}
     *
     * @stability stable
     */
    readonly repository: string;
    /**
     * The tag of the container image. If not specified, this defaults to the latest tag.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment#tag NotebooksEnvironment#tag}
     *
     * @stability stable
     */
    readonly tag?: string;
}
export declare function notebooksEnvironmentContainerImageToTerraform(struct?: NotebooksEnvironmentContainerImageOutputReference | NotebooksEnvironmentContainerImage): any;
/**
 * @stability stable
 */
export declare class NotebooksEnvironmentContainerImageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NotebooksEnvironmentContainerImage | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NotebooksEnvironmentContainerImage | undefined);
    private _repository?;
    /**
     * @stability stable
     */
    get repository(): string;
    /**
     * @stability stable
     */
    set repository(value: string);
    /**
     * @stability stable
     */
    get repositoryInput(): string | undefined;
    private _tag?;
    /**
     * @stability stable
     */
    get tag(): string;
    /**
     * @stability stable
     */
    set tag(value: string);
    /**
     * @stability stable
     */
    resetTag(): void;
    /**
     * @stability stable
     */
    get tagInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface NotebooksEnvironmentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment#create NotebooksEnvironment#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment#delete NotebooksEnvironment#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment#update NotebooksEnvironment#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function notebooksEnvironmentTimeoutsToTerraform(struct?: NotebooksEnvironmentTimeoutsOutputReference | NotebooksEnvironmentTimeouts): any;
/**
 * @stability stable
 */
export declare class NotebooksEnvironmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NotebooksEnvironmentTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NotebooksEnvironmentTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface NotebooksEnvironmentVmImage {
    /**
     * Use this VM image family to find the image; the newest image in this family will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment#image_family NotebooksEnvironment#image_family}
     *
     * @stability stable
     */
    readonly imageFamily?: string;
    /**
     * Use VM image name to find the image.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment#image_name NotebooksEnvironment#image_name}
     *
     * @stability stable
     */
    readonly imageName?: string;
    /**
     * The name of the Google Cloud project that this VM image belongs to. Format: projects/{project_id}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment#project NotebooksEnvironment#project}
     *
     * @stability stable
     */
    readonly project: string;
}
export declare function notebooksEnvironmentVmImageToTerraform(struct?: NotebooksEnvironmentVmImageOutputReference | NotebooksEnvironmentVmImage): any;
/**
 * @stability stable
 */
export declare class NotebooksEnvironmentVmImageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NotebooksEnvironmentVmImage | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NotebooksEnvironmentVmImage | undefined);
    private _imageFamily?;
    /**
     * @stability stable
     */
    get imageFamily(): string;
    /**
     * @stability stable
     */
    set imageFamily(value: string);
    /**
     * @stability stable
     */
    resetImageFamily(): void;
    /**
     * @stability stable
     */
    get imageFamilyInput(): string | undefined;
    private _imageName?;
    /**
     * @stability stable
     */
    get imageName(): string;
    /**
     * @stability stable
     */
    set imageName(value: string);
    /**
     * @stability stable
     */
    resetImageName(): void;
    /**
     * @stability stable
     */
    get imageNameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment google_notebooks_environment}.
 *
 * @stability stable
 */
export declare class NotebooksEnvironment extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment google_notebooks_environment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: NotebooksEnvironmentConfig);
    /**
     * @stability stable
     */
    get createTime(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _postStartupScript?;
    /**
     * @stability stable
     */
    get postStartupScript(): string;
    /**
     * @stability stable
     */
    set postStartupScript(value: string);
    /**
     * @stability stable
     */
    resetPostStartupScript(): void;
    /**
     * @stability stable
     */
    get postStartupScriptInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _containerImage;
    /**
     * @stability stable
     */
    get containerImage(): NotebooksEnvironmentContainerImageOutputReference;
    /**
     * @stability stable
     */
    putContainerImage(value: NotebooksEnvironmentContainerImage): void;
    /**
     * @stability stable
     */
    resetContainerImage(): void;
    /**
     * @stability stable
     */
    get containerImageInput(): NotebooksEnvironmentContainerImage | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): NotebooksEnvironmentTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: NotebooksEnvironmentTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): NotebooksEnvironmentTimeouts | undefined;
    private _vmImage;
    /**
     * @stability stable
     */
    get vmImage(): NotebooksEnvironmentVmImageOutputReference;
    /**
     * @stability stable
     */
    putVmImage(value: NotebooksEnvironmentVmImage): void;
    /**
     * @stability stable
     */
    resetVmImage(): void;
    /**
     * @stability stable
     */
    get vmImageInput(): NotebooksEnvironmentVmImage | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
