import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface OrganizationAccessApprovalSettingsConfig extends cdktf.TerraformMetaArguments {
    /**
     * A list of email addresses to which notifications relating to approval requests should be sent.
     *
     * Notifications relating to a resource will be sent to all emails in the settings of ancestor
     * resources of that resource. A maximum of 50 email addresses are allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_access_approval_settings#notification_emails OrganizationAccessApprovalSettings#notification_emails}
     *
     * @stability stable
     */
    readonly notificationEmails?: string[];
    /**
     * ID of the organization of the access approval settings.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_access_approval_settings#organization_id OrganizationAccessApprovalSettings#organization_id}
     *
     * @stability stable
     */
    readonly organizationId: string;
    /**
     * enrolled_services block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_access_approval_settings#enrolled_services OrganizationAccessApprovalSettings#enrolled_services}
     *
     * @stability stable
     */
    readonly enrolledServices: OrganizationAccessApprovalSettingsEnrolledServices[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_access_approval_settings#timeouts OrganizationAccessApprovalSettings#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: OrganizationAccessApprovalSettingsTimeouts;
}
/**
 * @stability stable
 */
export interface OrganizationAccessApprovalSettingsEnrolledServices {
    /**
     * The product for which Access Approval will be enrolled. Allowed values are listed (case-sensitive): all appengine.googleapis.com bigquery.googleapis.com bigtable.googleapis.com cloudkms.googleapis.com compute.googleapis.com dataflow.googleapis.com iam.googleapis.com pubsub.googleapis.com storage.googleapis.com.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_access_approval_settings#cloud_product OrganizationAccessApprovalSettings#cloud_product}
     *
     * @stability stable
     */
    readonly cloudProduct: string;
    /**
     * The enrollment level of the service. Default value: "BLOCK_ALL" Possible values: ["BLOCK_ALL"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_access_approval_settings#enrollment_level OrganizationAccessApprovalSettings#enrollment_level}
     *
     * @stability stable
     */
    readonly enrollmentLevel?: string;
}
export declare function organizationAccessApprovalSettingsEnrolledServicesToTerraform(struct?: OrganizationAccessApprovalSettingsEnrolledServices): any;
/**
 * @stability stable
 */
export interface OrganizationAccessApprovalSettingsTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_access_approval_settings#create OrganizationAccessApprovalSettings#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_access_approval_settings#delete OrganizationAccessApprovalSettings#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_access_approval_settings#update OrganizationAccessApprovalSettings#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function organizationAccessApprovalSettingsTimeoutsToTerraform(struct?: OrganizationAccessApprovalSettingsTimeoutsOutputReference | OrganizationAccessApprovalSettingsTimeouts): any;
/**
 * @stability stable
 */
export declare class OrganizationAccessApprovalSettingsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OrganizationAccessApprovalSettingsTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OrganizationAccessApprovalSettingsTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/organization_access_approval_settings google_organization_access_approval_settings}.
 *
 * @stability stable
 */
export declare class OrganizationAccessApprovalSettings extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/organization_access_approval_settings google_organization_access_approval_settings} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: OrganizationAccessApprovalSettingsConfig);
    /**
     * @stability stable
     */
    get enrolledAncestor(): any;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _notificationEmails?;
    /**
     * @stability stable
     */
    get notificationEmails(): string[];
    /**
     * @stability stable
     */
    set notificationEmails(value: string[]);
    /**
     * @stability stable
     */
    resetNotificationEmails(): void;
    /**
     * @stability stable
     */
    get notificationEmailsInput(): string[] | undefined;
    private _organizationId?;
    /**
     * @stability stable
     */
    get organizationId(): string;
    /**
     * @stability stable
     */
    set organizationId(value: string);
    /**
     * @stability stable
     */
    get organizationIdInput(): string | undefined;
    private _enrolledServices?;
    /**
     * @stability stable
     */
    get enrolledServices(): OrganizationAccessApprovalSettingsEnrolledServices[];
    /**
     * @stability stable
     */
    set enrolledServices(value: OrganizationAccessApprovalSettingsEnrolledServices[]);
    /**
     * @stability stable
     */
    get enrolledServicesInput(): OrganizationAccessApprovalSettingsEnrolledServices[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): OrganizationAccessApprovalSettingsTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: OrganizationAccessApprovalSettingsTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): OrganizationAccessApprovalSettingsTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
