import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface PrivatecaCaPoolIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool_iam_policy#ca_pool PrivatecaCaPoolIamPolicy#ca_pool}.
     *
     * @stability stable
     */
    readonly caPool: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool_iam_policy#location PrivatecaCaPoolIamPolicy#location}.
     *
     * @stability stable
     */
    readonly location?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool_iam_policy#policy_data PrivatecaCaPoolIamPolicy#policy_data}.
     *
     * @stability stable
     */
    readonly policyData: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool_iam_policy#project PrivatecaCaPoolIamPolicy#project}.
     *
     * @stability stable
     */
    readonly project?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool_iam_policy google_privateca_ca_pool_iam_policy}.
 *
 * @stability stable
 */
export declare class PrivatecaCaPoolIamPolicy extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool_iam_policy google_privateca_ca_pool_iam_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: PrivatecaCaPoolIamPolicyConfig);
    private _caPool?;
    /**
     * @stability stable
     */
    get caPool(): string;
    /**
     * @stability stable
     */
    set caPool(value: string);
    /**
     * @stability stable
     */
    get caPoolInput(): string | undefined;
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    resetLocation(): void;
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _policyData?;
    /**
     * @stability stable
     */
    get policyData(): string;
    /**
     * @stability stable
     */
    set policyData(value: string);
    /**
     * @stability stable
     */
    get policyDataInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
