import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SqlSslCertConfig extends cdktf.TerraformMetaArguments {
    /**
     * The common name to be used in the certificate to identify the client.
     *
     * Constrained to [a-zA-Z.-_ ]+. Changing this forces a new resource to be created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_ssl_cert#common_name SqlSslCert#common_name}
     *
     * @stability stable
     */
    readonly commonName: string;
    /**
     * The name of the Cloud SQL instance. Changing this forces a new resource to be created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_ssl_cert#instance SqlSslCert#instance}
     *
     * @stability stable
     */
    readonly instance: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_ssl_cert#project SqlSslCert#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_ssl_cert#timeouts SqlSslCert#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SqlSslCertTimeouts;
}
/**
 * @stability stable
 */
export interface SqlSslCertTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_ssl_cert#create SqlSslCert#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_ssl_cert#delete SqlSslCert#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
export declare function sqlSslCertTimeoutsToTerraform(struct?: SqlSslCertTimeoutsOutputReference | SqlSslCertTimeouts): any;
/**
 * @stability stable
 */
export declare class SqlSslCertTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SqlSslCertTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SqlSslCertTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/sql_ssl_cert google_sql_ssl_cert}.
 *
 * @stability stable
 */
export declare class SqlSslCert extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/sql_ssl_cert google_sql_ssl_cert} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SqlSslCertConfig);
    /**
     * @stability stable
     */
    get cert(): string;
    /**
     * @stability stable
     */
    get certSerialNumber(): string;
    private _commonName?;
    /**
     * @stability stable
     */
    get commonName(): string;
    /**
     * @stability stable
     */
    set commonName(value: string);
    /**
     * @stability stable
     */
    get commonNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get createTime(): string;
    /**
     * @stability stable
     */
    get expirationTime(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _instance?;
    /**
     * @stability stable
     */
    get instance(): string;
    /**
     * @stability stable
     */
    set instance(value: string);
    /**
     * @stability stable
     */
    get instanceInput(): string | undefined;
    /**
     * @stability stable
     */
    get privateKey(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get serverCaCert(): string;
    /**
     * @stability stable
     */
    get sha1Fingerprint(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SqlSslCertTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SqlSslCertTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SqlSslCertTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
