import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface StorageNotificationConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_notification#bucket StorageNotification#bucket}
     *
     * @stability stable
     */
    readonly bucket: string;
    /**
     * A set of key/value attribute pairs to attach to each Cloud Pub/Sub message published for this notification subscription.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_notification#custom_attributes StorageNotification#custom_attributes}
     *
     * @stability stable
     */
    readonly customAttributes?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * List of event type filters for this notification config.
     *
     * If not specified, Cloud Storage will send notifications for all event types. The valid types are: "OBJECT_FINALIZE", "OBJECT_METADATA_UPDATE", "OBJECT_DELETE", "OBJECT_ARCHIVE"
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_notification#event_types StorageNotification#event_types}
     *
     * @stability stable
     */
    readonly eventTypes?: string[];
    /**
     * Specifies a prefix path filter for this notification config.
     *
     * Cloud Storage will only send notifications for objects in this bucket whose names begin with the specified prefix.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_notification#object_name_prefix StorageNotification#object_name_prefix}
     *
     * @stability stable
     */
    readonly objectNamePrefix?: string;
    /**
     * The desired content of the Payload. One of "JSON_API_V1" or "NONE".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_notification#payload_format StorageNotification#payload_format}
     *
     * @stability stable
     */
    readonly payloadFormat: string;
    /**
     * The Cloud Pub/Sub topic to which this subscription publishes.
     *
     * Expects either the  topic name, assumed to belong to the default GCP provider project, or the project-level name,  i.e. projects/my-gcp-project/topics/my-topic or my-topic. If the project is not set in the provider, you will need to use the project-level name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_notification#topic StorageNotification#topic}
     *
     * @stability stable
     */
    readonly topic: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/storage_notification google_storage_notification}.
 *
 * @stability stable
 */
export declare class StorageNotification extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/storage_notification google_storage_notification} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: StorageNotificationConfig);
    private _bucket?;
    /**
     * @stability stable
     */
    get bucket(): string;
    /**
     * @stability stable
     */
    set bucket(value: string);
    /**
     * @stability stable
     */
    get bucketInput(): string | undefined;
    private _customAttributes?;
    /**
     * @stability stable
     */
    get customAttributes(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set customAttributes(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCustomAttributes(): void;
    /**
     * @stability stable
     */
    get customAttributesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _eventTypes?;
    /**
     * @stability stable
     */
    get eventTypes(): string[];
    /**
     * @stability stable
     */
    set eventTypes(value: string[]);
    /**
     * @stability stable
     */
    resetEventTypes(): void;
    /**
     * @stability stable
     */
    get eventTypesInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get notificationId(): string;
    private _objectNamePrefix?;
    /**
     * @stability stable
     */
    get objectNamePrefix(): string;
    /**
     * @stability stable
     */
    set objectNamePrefix(value: string);
    /**
     * @stability stable
     */
    resetObjectNamePrefix(): void;
    /**
     * @stability stable
     */
    get objectNamePrefixInput(): string | undefined;
    private _payloadFormat?;
    /**
     * @stability stable
     */
    get payloadFormat(): string;
    /**
     * @stability stable
     */
    set payloadFormat(value: string);
    /**
     * @stability stable
     */
    get payloadFormatInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _topic?;
    /**
     * @stability stable
     */
    get topic(): string;
    /**
     * @stability stable
     */
    set topic(value: string);
    /**
     * @stability stable
     */
    get topicInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
