#!/bin/bash

script_dir=$(cd $(dirname "${BASH_SOURCE[0]}") && pwd)
#echo "$script_dir"
cd $script_dir/..

set -a
source df.config
set +a

# Need CHANNEL_ID, PIPE_NAME, API_KEY
# Should all be found in df.config file

POST_DATA=$(cat <<-END
{
    "api_key":"$API_KEY",
    "id":$CHANNEL_ID,
    "config": {
        "mode": "sample"
    }
}
END
)

MERGED_JSON=$(echo "$POST_DATA" | cat - ./examples/call_channel.json | jq -s add)
#echo "$MERGED_JSON"

RESP=$(curl -s -k -d "$MERGED_JSON" $BLACKFIN_URL"v2/channel/get_function_input" -H "Content-Type: application/json")
#echo "Response of first leg of mock tunnel \n $RESP"

# Assumes jq util is installed # https://stedolan.github.io/jq/
echo "$RESP" > ./tmp/full_tunnel_resp_part_one.json
echo "$RESP" | jq '.pipes["'$PIPE_NAME'"].data_function_input_json' > ./tmp/mock_tunnel_part_one.json

python3 examples/mock_tunnel.py

if [ $? != 0 ]; then
    echo "Mock Tunnel Failed"
else
    echo "Mock Tunnel Success"
fi
