from collections.abc import Generator
from typing import Any

from pony.py23compat import PY38 as PY38
from pony.utils import HashableDict as HashableDict
from pony.utils import copy_ast as copy_ast
from pony.utils import throw as throw

class TranslationError(Exception): ...

pre_method_caches: Any
post_method_caches: Any

class ASTTranslator:
    def __init__(translator, tree: Any) -> None: ...
    def dispatch(translator, node: Any) -> None: ...
    def call(translator, method: Any, node: Any) -> Any: ...
    def default_pre(translator, node: Any) -> None: ...
    def default_post(translator, node: Any) -> None: ...

def priority(p: Any) -> Any: ...
def binop_src(op: Any, node: Any) -> Any: ...
def ast2src(tree: Any) -> Any: ...
def get_child_nodes(node: Any) -> Generator[Any, None, None]: ...

class PythonTranslator(ASTTranslator):
    def __init__(translator, tree: Any) -> None: ...
    def call(translator, method: Any, node: Any) -> None: ...
    def default_pre(translator, node: Any) -> Any: ...
    def default_post(translator, node: Any) -> None: ...
    def postGeneratorExp(translator, node: Any) -> Any: ...
    def postcomprehension(translator, node: Any) -> Any: ...
    def postGenExprIf(translator, node: Any) -> Any: ...
    def postExpr(translator, node: Any) -> Any: ...
    def postIfExp(translator, node: Any) -> Any: ...
    def postLambda(translator, node: Any) -> Any: ...
    def postarguments(translator, node: Any) -> Any: ...
    def postarg(translator, node: Any) -> Any: ...
    def postOr(translator, node: Any) -> Any: ...
    def postAnd(translator, node: Any) -> Any: ...
    def postNot(translator, node: Any) -> Any: ...
    def postCompare(translator, node: Any) -> Any: ...
    def postEq(translator, node: Any) -> Any: ...
    def postNotEq(translator, node: Any) -> Any: ...
    def postLt(translator, node: Any) -> Any: ...
    def postLtE(translator, node: Any) -> Any: ...
    def postGt(translator, node: Any) -> Any: ...
    def postGtE(translator, node: Any) -> Any: ...
    def postIs(translator, node: Any) -> Any: ...
    def postIsNot(translator, node: Any) -> Any: ...
    def postIn(translator, node: Any) -> Any: ...
    def postNotIn(translator, node: Any) -> Any: ...
    def postBitOr(translator, node: Any) -> Any: ...
    def postBitXor(translator, node: Any) -> Any: ...
    def postBitAnd(translator, node: Any) -> Any: ...
    def postLShift(translator, node: Any) -> Any: ...
    def postRShift(translator, node: Any) -> Any: ...
    def postAdd(translator, node: Any) -> Any: ...
    def postSub(translator, node: Any) -> Any: ...
    def postMult(translator, node: Any) -> Any: ...
    def postMatMult(translator, node: Any) -> None: ...
    def postDiv(translator, node: Any) -> Any: ...
    def postFloorDiv(translator, node: Any) -> Any: ...
    def postMod(translator, node: Any) -> Any: ...
    def postUSub(translator, node: Any) -> Any: ...
    def postUAdd(translator, node: Any) -> Any: ...
    def postInvert(translator, node: Any) -> Any: ...
    def postPow(translator, node: Any) -> Any: ...
    def postAttribute(translator, node: Any) -> Any: ...
    def postCall(translator, node: Any) -> Any: ...
    def postkeyword(translator, node: Any) -> Any: ...
    def postStarred(translator, node: Any) -> Any: ...
    def postSubscript(translator, node: Any) -> Any: ...
    def postIndex(translator, node: Any) -> Any: ...
    def postSlice(translator, node: Any) -> Any: ...
    def postConstant(translator, node: Any) -> Any: ...
    def postNameConstant(translator, node: Any) -> Any: ...
    def postNum(translator, node: Any) -> Any: ...
    def postStr(translator, node: Any) -> Any: ...
    def postBytes(translator, node: Any) -> Any: ...
    def postList(translator, node: Any) -> Any: ...
    def postTuple(translator, node: Any) -> Any: ...
    def postDict(translator, node: Any) -> Any: ...
    def postSet(translator, node: Any) -> Any: ...
    def postName(translator, node: Any) -> Any: ...
    def postJoinedStr(self, node: Any) -> Any: ...
    def postFormattedValue(self, node: Any) -> Any: ...

nonexternalizable_types: Any

class PreTranslator(ASTTranslator):
    def __init__(
        translator,
        tree: Any,
        globals: Any,
        locals: Any,
        special_functions: Any,
        const_functions: Any,
        outer_names: Any = ...,
    ) -> None: ...
    def dispatch(translator, node: Any) -> None: ...
    def preGeneratorExp(translator, node: Any) -> Any: ...
    def preLambda(translator, node: Any) -> Any: ...
    def postName(translator, node: Any) -> None: ...
    def postSlice(translator, node: Any) -> None: ...
    def postStarred(translator, node: Any) -> None: ...
    def postConstant(translator, node: Any) -> None: ...
    def postNum(translator, node: Any) -> None: ...
    def postStr(translator, node: Any) -> None: ...
    def postBytes(translator, node: Any) -> None: ...
    def postDict(translator, node: Any) -> None: ...
    def postList(translator, node: Any) -> None: ...
    def postkeyword(translator, node: Any) -> None: ...
    def postIndex(translator, node: Any) -> None: ...
    def postCall(translator, node: Any) -> None: ...
    def postCompare(translator, node: Any) -> None: ...
    def post_binop(translator, node: Any) -> None: ...
    postBitOr: Any
    postBitXor: Any
    postBitAnd: Any
    postLShift: Any
    postRShift: Any
    postAdd: Any
    postSub: Any
    postMult: Any
    postMatMult: Any
    postDiv: Any
    postFloorDiv: Any
    postMod: Any

extractors_cache: Any

def create_extractors(
    code_key: Any,
    tree: Any,
    globals: Any,
    locals: Any,
    special_functions: Any,
    const_functions: Any,
    outer_names: Any = ...,
) -> Any: ...
