import json
from typing import Any

from pony.converting import str2date as str2date
from pony.converting import str2datetime as str2datetime
from pony.converting import str2time as str2time
from pony.converting import str2timedelta as str2timedelta
from pony.orm.ormtypes import Array as Array
from pony.orm.ormtypes import Json as Json
from pony.orm.ormtypes import LongStr as LongStr
from pony.orm.ormtypes import LongUnicode as LongUnicode
from pony.orm.ormtypes import QueryType as QueryType
from pony.orm.ormtypes import RawSQLType as RawSQLType
from pony.orm.ormtypes import TrackedArray as TrackedArray
from pony.orm.ormtypes import TrackedValue as TrackedValue
from pony.py23compat import buffer as buffer
from pony.py23compat import int_types as int_types
from pony.utils import decorator as decorator
from pony.utils import deprecated as deprecated
from pony.utils import is_utf8 as is_utf8
from pony.utils import localbase as localbase
from pony.utils import throw as throw

class DBException(Exception):
    def __init__(exc, original_exc: Any, *args: Any) -> None: ...

class Warning(DBException): ...
class Error(DBException): ...
class InterfaceError(Error): ...
class DatabaseError(Error): ...
class DataError(DatabaseError): ...
class OperationalError(DatabaseError): ...
class IntegrityError(DatabaseError): ...
class InternalError(DatabaseError): ...
class ProgrammingError(DatabaseError): ...
class NotSupportedError(DatabaseError): ...

def wrap_dbapi_exceptions(
    func: Any, provider: Any, *args: Any, **kwargs: Any
) -> Any: ...
def unexpected_args(attr: Any, args: Any) -> None: ...

version_re: Any

def get_version_tuple(s: Any) -> Any: ...

class DBAPIProvider:
    paramstyle: str
    quote_char: str
    max_params_count: int
    max_name_len: int
    table_if_not_exists_syntax: bool
    index_if_not_exists_syntax: bool
    max_time_precision: int
    default_time_precision: int
    uint64_support: bool
    varchar_default_max_len: Any
    dialect: Any
    dbapi_module: Any
    dbschema_cls: Any
    translator_cls: Any
    sqlbuilder_cls: Any
    array_converter_cls: Any
    name_before_table: str
    default_schema_name: Any
    fk_types: Any
    def __init__(provider, _database: Any, *args: Any, **kwargs: Any) -> None: ...
    def inspect_connection(provider, connection: Any) -> None: ...
    def normalize_name(provider, name: Any) -> Any: ...
    def get_default_entity_table_name(provider, entity: Any) -> Any: ...
    def get_default_m2m_table_name(provider, attr: Any, reverse: Any) -> Any: ...
    def get_default_column_names(
        provider, attr: Any, reverse_pk_columns: Any | None = ...
    ) -> Any: ...
    def get_default_m2m_column_names(provider, entity: Any) -> Any: ...
    def get_default_index_name(
        provider,
        table_name: Any,
        column_names: Any,
        is_pk: bool = ...,
        is_unique: bool = ...,
        m2m: bool = ...,
    ) -> Any: ...
    def get_default_fk_name(
        provider, child_table_name: Any, parent_table_name: Any, child_column_names: Any
    ) -> Any: ...
    def split_table_name(provider, table_name: Any) -> Any: ...
    def base_name(provider, name: Any) -> Any: ...
    def quote_name(provider, name: Any) -> Any: ...
    def format_table_name(provider, name: Any) -> Any: ...
    def normalize_vars(provider, vars: Any, vartypes: Any) -> None: ...
    def ast2sql(provider, ast: Any) -> Any: ...
    def should_reconnect(provider, exc: Any) -> Any: ...
    def connect(provider) -> Any: ...
    def set_transaction_mode(provider, connection: Any, cache: Any) -> None: ...
    def commit(provider, connection: Any, cache: Any | None = ...) -> None: ...
    def rollback(provider, connection: Any, cache: Any | None = ...) -> None: ...
    def release(provider, connection: Any, cache: Any | None = ...) -> None: ...
    def drop(provider, connection: Any, cache: Any | None = ...) -> None: ...
    def disconnect(provider) -> None: ...
    def execute(
        provider,
        cursor: Any,
        sql: Any,
        arguments: Any | None = ...,
        returning_id: bool = ...,
    ) -> Any: ...
    converter_classes: Any
    def get_converter_by_py_type(provider, py_type: Any) -> Any: ...
    def get_converter_by_attr(provider, attr: Any) -> Any: ...
    def get_pool(provider, *args: Any, **kwargs: Any) -> Any: ...
    def table_exists(
        provider, connection: Any, table_name: Any, case_sensitive: bool = ...
    ) -> None: ...
    def index_exists(
        provider,
        connection: Any,
        table_name: Any,
        index_name: Any,
        case_sensitive: bool = ...,
    ) -> None: ...
    def fk_exists(
        provider,
        connection: Any,
        table_name: Any,
        fk_name: Any,
        case_sensitive: bool = ...,
    ) -> None: ...
    def table_has_data(provider, connection: Any, table_name: Any) -> Any: ...
    def disable_fk_checks(provider, connection: Any) -> None: ...
    def enable_fk_checks(provider, connection: Any, prev_state: Any) -> None: ...
    def drop_table(provider, connection: Any, table_name: Any) -> None: ...

class Pool(localbase):
    forked_connections: Any
    def __init__(pool, dbapi_module: Any, *args: Any, **kwargs: Any) -> None: ...
    def connect(pool) -> Any: ...
    def release(pool, con: Any) -> None: ...
    def drop(pool, con: Any) -> None: ...
    def disconnect(pool) -> None: ...

class Converter:
    EQ: str
    NE: str
    optimistic: bool
    def __deepcopy__(converter, memo: Any) -> Any: ...
    def __init__(
        converter, provider: Any, py_type: Any, attr: Any | None = ...
    ) -> None: ...
    def init(converter, kwargs: Any) -> None: ...
    def validate(converter, val: Any, obj: Any | None = ...) -> Any: ...
    def py2sql(converter, val: Any) -> Any: ...
    def sql2py(converter, val: Any) -> Any: ...
    def val2dbval(self, val: Any, obj: Any | None = ...) -> Any: ...
    def dbval2val(self, dbval: Any, obj: Any | None = ...) -> Any: ...
    def dbvals_equal(self, x: Any, y: Any) -> Any: ...
    def get_sql_type(converter, attr: Any | None = ...) -> Any: ...
    def get_fk_type(converter, sql_type: Any) -> Any: ...

class NoneConverter(Converter):
    def __init__(
        converter, provider: Any, py_type: Any, attr: Any | None = ...
    ) -> None: ...
    def get_sql_type(converter, attr: Any | None = ...) -> None: ...
    def get_fk_type(converter, sql_type: Any) -> None: ...

class BoolConverter(Converter):
    def validate(converter, val: Any, obj: Any | None = ...) -> Any: ...
    def sql2py(converter, val: Any) -> Any: ...
    def sql_type(converter) -> Any: ...

class StrConverter(Converter):
    def __init__(
        converter, provider: Any, py_type: Any, attr: Any | None = ...
    ) -> None: ...
    def init(converter, kwargs: Any) -> None: ...
    def validate(converter, val: Any, obj: Any | None = ...) -> Any: ...
    def sql_type(converter) -> Any: ...

class IntConverter(Converter):
    signed_types: Any
    unsigned_types: Any
    def init(converter, kwargs: Any) -> None: ...
    def validate(converter, val: Any, obj: Any | None = ...) -> Any: ...
    def sql2py(converter, val: Any) -> Any: ...
    def sql_type(converter) -> Any: ...

class RealConverter(Converter):
    EQ: str
    NE: str
    default_tolerance: float
    optimistic: bool
    def init(converter, kwargs: Any) -> None: ...
    def validate(converter, val: Any, obj: Any | None = ...) -> Any: ...
    def dbvals_equal(converter, x: Any, y: Any) -> Any: ...
    def sql2py(converter, val: Any) -> Any: ...
    def sql_type(converter) -> Any: ...

class DecimalConverter(Converter):
    def __init__(
        converter, provider: Any, py_type: Any, attr: Any | None = ...
    ) -> None: ...
    def init(converter, kwargs: Any) -> None: ...
    def validate(converter, val: Any, obj: Any | None = ...) -> Any: ...
    def sql2py(converter, val: Any) -> Any: ...
    def sql_type(converter) -> Any: ...

class BlobConverter(Converter):
    def validate(converter, val: Any, obj: Any | None = ...) -> Any: ...
    def sql2py(converter, val: Any) -> Any: ...
    def sql_type(converter) -> Any: ...

class DateConverter(Converter):
    def validate(converter, val: Any, obj: Any | None = ...) -> Any: ...
    def sql2py(converter, val: Any) -> Any: ...
    def sql_type(converter) -> Any: ...

class ConverterWithMicroseconds(Converter):
    def __init__(
        converter, provider: Any, py_type: Any, attr: Any | None = ...
    ) -> None: ...
    def init(converter, kwargs: Any) -> None: ...
    def round_microseconds_to_precision(
        converter, microseconds: Any, precision: Any
    ) -> Any: ...
    def sql_type(converter) -> Any: ...

class TimeConverter(ConverterWithMicroseconds):
    sql_type_name: str
    def validate(converter, val: Any, obj: Any | None = ...) -> Any: ...
    def sql2py(converter, val: Any) -> Any: ...

class TimedeltaConverter(ConverterWithMicroseconds):
    sql_type_name: str
    def validate(converter, val: Any, obj: Any | None = ...) -> Any: ...
    def sql2py(converter, val: Any) -> Any: ...

class DatetimeConverter(ConverterWithMicroseconds):
    sql_type_name: str
    def validate(converter, val: Any, obj: Any | None = ...) -> Any: ...
    def sql2py(converter, val: Any) -> Any: ...

class UuidConverter(Converter):
    def __init__(
        converter, provider: Any, py_type: Any, attr: Any | None = ...
    ) -> None: ...
    def validate(converter, val: Any, obj: Any | None = ...) -> Any: ...
    def py2sql(converter, val: Any) -> Any: ...
    sql2py: Any
    def sql_type(converter) -> Any: ...

class JsonConverter(Converter):
    json_kwargs: Any

    class JsonEncoder(json.JSONEncoder):
        def default(converter, obj: Any) -> Any: ...

    def validate(converter, val: Any, obj: Any | None = ...) -> Any: ...
    def val2dbval(converter, val: Any, obj: Any | None = ...) -> Any: ...
    def dbval2val(converter, dbval: Any, obj: Any | None = ...) -> Any: ...
    def dbvals_equal(converter, x: Any, y: Any) -> Any: ...
    def sql_type(converter) -> Any: ...

class ArrayConverter(Converter):
    array_types: Any
    def __init__(
        converter, provider: Any, py_type: Any, attr: Any | None = ...
    ) -> None: ...
    def validate(converter, val: Any, obj: Any | None = ...) -> Any: ...
    def dbval2val(converter, dbval: Any, obj: Any | None = ...) -> Any: ...
    def val2dbval(converter, val: Any, obj: Any | None = ...) -> Any: ...
    def sql_type(converter) -> Any: ...
