/// autogenerated analytical inverse kinematics code from ikfast program part of OpenRAVE
/// \author Rosen Diankov
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///     http://www.apache.org/licenses/LICENSE-2.0
/// 
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// ikfast version 0x1000004a generated on 2018-07-20 15:34:20.766183
/// Generated using solver transform6d
/// To compile with gcc:
///     gcc -lstdc++ ik.cpp
/// To compile without any main function as a shared object (might need -llapack):
///     gcc -fPIC -lstdc++ -DIKFAST_NO_MAIN -DIKFAST_CLIBRARY -shared -Wl,-soname,libik.so -o libik.so ik.cpp
#define IKFAST_HAS_LIBRARY
#include "ikfast.h" // found inside share/openrave-X.Y/python/ikfast.h
using namespace ikfast;

// check if the included ikfast version matches what this file was compiled with
#define IKFAST_COMPILE_ASSERT(x) extern int __dummy[(int)x]
IKFAST_COMPILE_ASSERT(IKFAST_VERSION==0x1000004a);

#include <cmath>
#include <vector>
#include <limits>
#include <algorithm>
#include <complex>

//// START
#include "python2.7/Python.h"
//// END

#ifndef IKFAST_ASSERT
#include <stdexcept>
#include <sstream>
#include <iostream>

#ifdef _MSC_VER
#ifndef __PRETTY_FUNCTION__
#define __PRETTY_FUNCTION__ __FUNCDNAME__
#endif
#endif

#ifndef __PRETTY_FUNCTION__
#define __PRETTY_FUNCTION__ __func__
#endif

#define IKFAST_ASSERT(b) { if( !(b) ) { std::stringstream ss; ss << "ikfast exception: " << __FILE__ << ":" << __LINE__ << ": " <<__PRETTY_FUNCTION__ << ": Assertion '" << #b << "' failed"; throw std::runtime_error(ss.str()); } }

#endif

#if defined(_MSC_VER)
#define IKFAST_ALIGNED16(x) __declspec(align(16)) x
#else
#define IKFAST_ALIGNED16(x) x __attribute((aligned(16)))
#endif

#define IK2PI  ((IkReal)6.28318530717959)
#define IKPI  ((IkReal)3.14159265358979)
#define IKPI_2  ((IkReal)1.57079632679490)

#ifdef _MSC_VER
#ifndef isnan
#define isnan _isnan
#endif
#ifndef isinf
#define isinf _isinf
#endif
//#ifndef isfinite
//#define isfinite _isfinite
//#endif
#endif // _MSC_VER

// lapack routines
extern "C" {
  void dgetrf_ (const int* m, const int* n, double* a, const int* lda, int* ipiv, int* info);
  void zgetrf_ (const int* m, const int* n, std::complex<double>* a, const int* lda, int* ipiv, int* info);
  void dgetri_(const int* n, const double* a, const int* lda, int* ipiv, double* work, const int* lwork, int* info);
  void dgesv_ (const int* n, const int* nrhs, double* a, const int* lda, int* ipiv, double* b, const int* ldb, int* info);
  void dgetrs_(const char *trans, const int *n, const int *nrhs, double *a, const int *lda, int *ipiv, double *b, const int *ldb, int *info);
  void dgeev_(const char *jobvl, const char *jobvr, const int *n, double *a, const int *lda, double *wr, double *wi,double *vl, const int *ldvl, double *vr, const int *ldvr, double *work, const int *lwork, int *info);
}

using namespace std; // necessary to get std math routines

#ifdef IKFAST_NAMESPACE
namespace IKFAST_NAMESPACE {
#endif

inline float IKabs(float f) { return fabsf(f); }
inline double IKabs(double f) { return fabs(f); }

inline float IKsqr(float f) { return f*f; }
inline double IKsqr(double f) { return f*f; }

inline float IKlog(float f) { return logf(f); }
inline double IKlog(double f) { return log(f); }

// allows asin and acos to exceed 1. has to be smaller than thresholds used for branch conds and evaluation
#ifndef IKFAST_SINCOS_THRESH
#define IKFAST_SINCOS_THRESH ((IkReal)1e-7)
#endif

// used to check input to atan2 for degenerate cases. has to be smaller than thresholds used for branch conds and evaluation
#ifndef IKFAST_ATAN2_MAGTHRESH
#define IKFAST_ATAN2_MAGTHRESH ((IkReal)1e-7)
#endif

// minimum distance of separate solutions
#ifndef IKFAST_SOLUTION_THRESH
#define IKFAST_SOLUTION_THRESH ((IkReal)1e-6)
#endif

// there are checkpoints in ikfast that are evaluated to make sure they are 0. This threshold speicfies by how much they can deviate
#ifndef IKFAST_EVALCOND_THRESH
#define IKFAST_EVALCOND_THRESH ((IkReal)0.00001)
#endif


inline float IKasin(float f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return float(-IKPI_2);
else if( f >= 1 ) return float(IKPI_2);
return asinf(f);
}
inline double IKasin(double f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return -IKPI_2;
else if( f >= 1 ) return IKPI_2;
return asin(f);
}

// return positive value in [0,y)
inline float IKfmod(float x, float y)
{
    while(x < 0) {
        x += y;
    }
    return fmodf(x,y);
}

// return positive value in [0,y)
inline double IKfmod(double x, double y)
{
    while(x < 0) {
        x += y;
    }
    return fmod(x,y);
}

inline float IKacos(float f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return float(IKPI);
else if( f >= 1 ) return float(0);
return acosf(f);
}
inline double IKacos(double f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return IKPI;
else if( f >= 1 ) return 0;
return acos(f);
}
inline float IKsin(float f) { return sinf(f); }
inline double IKsin(double f) { return sin(f); }
inline float IKcos(float f) { return cosf(f); }
inline double IKcos(double f) { return cos(f); }
inline float IKtan(float f) { return tanf(f); }
inline double IKtan(double f) { return tan(f); }
inline float IKsqrt(float f) { if( f <= 0.0f ) return 0.0f; return sqrtf(f); }
inline double IKsqrt(double f) { if( f <= 0.0 ) return 0.0; return sqrt(f); }
inline float IKatan2Simple(float fy, float fx) {
    return atan2f(fy,fx);
}
inline float IKatan2(float fy, float fx) {
    if( isnan(fy) ) {
        IKFAST_ASSERT(!isnan(fx)); // if both are nan, probably wrong value will be returned
        return float(IKPI_2);
    }
    else if( isnan(fx) ) {
        return 0;
    }
    return atan2f(fy,fx);
}
inline double IKatan2Simple(double fy, double fx) {
    return atan2(fy,fx);
}
inline double IKatan2(double fy, double fx) {
    if( isnan(fy) ) {
        IKFAST_ASSERT(!isnan(fx)); // if both are nan, probably wrong value will be returned
        return IKPI_2;
    }
    else if( isnan(fx) ) {
        return 0;
    }
    return atan2(fy,fx);
}

template <typename T>
struct CheckValue
{
    T value;
    bool valid;
};

template <typename T>
inline CheckValue<T> IKatan2WithCheck(T fy, T fx, T epsilon)
{
    CheckValue<T> ret;
    ret.valid = false;
    ret.value = 0;
    if( !isnan(fy) && !isnan(fx) ) {
        if( IKabs(fy) >= IKFAST_ATAN2_MAGTHRESH || IKabs(fx) > IKFAST_ATAN2_MAGTHRESH ) {
            ret.value = IKatan2Simple(fy,fx);
            ret.valid = true;
        }
    }
    return ret;
}

inline float IKsign(float f) {
    if( f > 0 ) {
        return float(1);
    }
    else if( f < 0 ) {
        return float(-1);
    }
    return 0;
}

inline double IKsign(double f) {
    if( f > 0 ) {
        return 1.0;
    }
    else if( f < 0 ) {
        return -1.0;
    }
    return 0;
}

template <typename T>
inline CheckValue<T> IKPowWithIntegerCheck(T f, int n)
{
    CheckValue<T> ret;
    ret.valid = true;
    if( n == 0 ) {
        ret.value = 1.0;
        return ret;
    }
    else if( n == 1 )
    {
        ret.value = f;
        return ret;
    }
    else if( n < 0 )
    {
        if( f == 0 )
        {
            ret.valid = false;
            ret.value = (T)1.0e30;
            return ret;
        }
        if( n == -1 ) {
            ret.value = T(1.0)/f;
            return ret;
        }
    }

    int num = n > 0 ? n : -n;
    if( num == 2 ) {
        ret.value = f*f;
    }
    else if( num == 3 ) {
        ret.value = f*f*f;
    }
    else {
        ret.value = 1.0;
        while(num>0) {
            if( num & 1 ) {
                ret.value *= f;
            }
            num >>= 1;
            f *= f;
        }
    }
    
    if( n < 0 ) {
        ret.value = T(1.0)/ret.value;
    }
    return ret;
}

/// solves the forward kinematics equations.
/// \param pfree is an array specifying the free joints of the chain.
IKFAST_API void ComputeFk(const IkReal* j, IkReal* eetrans, IkReal* eerot) {
IkReal x0,x1,x2,x3,x4,x5,x6,x7,x8,x9,x10,x11,x12,x13,x14,x15,x16,x17,x18,x19,x20,x21,x22,x23,x24,x25,x26,x27,x28,x29,x30,x31,x32,x33,x34,x36,x37,x38,x39,x41,x42,x43,x44,x45,x46,x47,x48,x49,x50,x51,x52,x54,x55,x56,x57,x58,x59,x60,x61,x62,x63,x64,x65,x66;
x0=IKcos(j[1]);
x1=IKcos(j[4]);
x2=IKcos(j[2]);
x3=IKsin(j[4]);
x4=IKsin(j[2]);
x5=IKsin(j[3]);
x6=IKcos(j[3]);
x7=IKsin(j[1]);
x8=IKcos(j[5]);
x9=IKsin(j[5]);
x10=IKsin(j[6]);
x11=IKcos(j[6]);
x12=IKsin(j[7]);
x13=IKcos(j[7]);
x14=((1.0)*x1);
x15=((1.0)*x3);
x16=((0.18)*x8);
x17=((1.0)*x6);
x18=((0.321)*x5);
x19=((1.0)*x8);
x20=((0.18)*x9);
x21=((0.18)*x3);
x22=((0.18)*x1);
x23=((0.321)*x1);
x24=((1.0)*x9);
x25=((1.0)*x10);
x26=((0.321)*x6);
x27=((1.0)*x11);
x28=(x2*x7);
x29=((-1.0)*x3);
x30=(x0*x4);
x31=(x2*x5);
x32=((-1.0)*x10);
x33=(x0*x2);
x34=((-1.0)*x1);
x36=((-1.0)*x11);
x37=(x5*x7);
x38=(x2*x6);
x39=(x4*x7);
x41=(x15*x33);
x42=(x14*x38);
x43=(((x30*x5))+(((-1.0)*x17*x7)));
x44=(((x0*x5))+(((-1.0)*x17*x39)));
x45=(((x0*x6))+((x37*x4)));
x46=((((-1.0)*x42))+((x3*x4)));
x47=(x42+(((-1.0)*x15*x4)));
x48=((((-1.0)*x37))+(((-1.0)*x17*x30)));
x49=(x43*x9);
x50=(((x14*x4))+((x15*x38)));
x51=(x45*x9);
x52=(x45*x8);
x54=(x47*x9);
x55=(x1*x48);
x56=(((x31*x9))+((x46*x8)));
x57=((((-1.0)*x14*x44))+((x15*x28)));
x58=(((x28*x29))+((x1*x44)));
x59=(((x29*x33))+x55);
x60=(x58*x8);
x61=(x57*x9);
x62=(x59*x8);
x63=(x51+x60);
x64=(x49+x62);
x65=((((-1.0)*x27*x56))+(((-1.0)*x25*x50)));
x66=(((x36*x63))+((x32*((((x29*x44))+((x28*x34)))))));
eerot[0]=(((x11*((((x3*x48))+((x1*x33))))))+((x10*((x49+((x8*(((((-1.0)*x41))+x55)))))))));
eerot[1]=(((x13*((((x9*((((x34*x48))+x41))))+((x43*x8))))))+(((-1.0)*x12*((((x27*x64))+((x25*(((((-1.0)*x15*x48))+(((-1.0)*x14*x33)))))))))));
eerot[2]=(((x13*((((x36*x64))+((x32*((((x29*x48))+((x33*x34))))))))))+(((-1.0)*x12*((((x24*(((((-1.0)*x14*x48))+x41))))+((x19*x43)))))));
eetrans[0]=((-0.05)+((x10*((((x20*x43))+((x16*x59))))))+((x23*x33))+(((0.1)*x0))+((x3*(((((-1.0)*x18*x7))+(((-1.0)*x26*x30))))))+(((0.4)*x33))+((x11*((((x22*x33))+((x21*x48)))))));
eerot[3]=(((x11*((((x1*x28))+((x3*x44))))))+((x10*x63)));
eerot[4]=(((x12*x66))+((x13*((x52+x61)))));
eerot[5]=(((x12*(((((-1.0)*x19*x45))+(((-1.0)*x24*x57))))))+((x13*x66)));
eetrans[1]=((-0.188)+(((0.1)*x7))+((x10*((((x20*x45))+((x16*x58))))))+((x23*x28))+(((0.4)*x28))+((x11*((((x22*x28))+((x21*x44))))))+((x3*((((x0*x18))+(((-1.0)*x26*x39)))))));
eerot[6]=((((-1.0)*x11*x50))+((x10*x56)));
eerot[7]=(((x13*((((x31*x8))+x54))))+((x12*x65)));
eerot[8]=(((x13*x65))+((x12*(((((-1.0)*x24*x47))+(((-1.0)*x19*x31)))))));
IkReal x67=((1.0)*x4);
eetrans[2]=((0.739675)+((x11*(((((-1.0)*x21*x38))+(((-1.0)*x22*x67))))))+((x10*((((x20*x31))+((x16*x46))))))+(((-1.0)*x2*x26*x3))+(((-1.0)*x23*x67))+(((-0.4)*x4))+j[0]);
}

IKFAST_API int GetNumFreeParameters() { return 2; }
IKFAST_API int* GetFreeParameters() { static int freeparams[] = {0, 3}; return freeparams; }
IKFAST_API int GetNumJoints() { return 8; }

IKFAST_API int GetIkRealSize() { return sizeof(IkReal); }

IKFAST_API int GetIkType() { return 0x67000001; }

class IKSolver {
public:
IkReal j27,cj27,sj27,htj27,j27mul,j28,cj28,sj28,htj28,j28mul,j30,cj30,sj30,htj30,j30mul,j31,cj31,sj31,htj31,j31mul,j32,cj32,sj32,htj32,j32mul,j33,cj33,sj33,htj33,j33mul,j12,cj12,sj12,htj12,j29,cj29,sj29,htj29,new_r00,r00,rxp0_0,new_r01,r01,rxp0_1,new_r02,r02,rxp0_2,new_r10,r10,rxp1_0,new_r11,r11,rxp1_1,new_r12,r12,rxp1_2,new_r20,r20,rxp2_0,new_r21,r21,rxp2_1,new_r22,r22,rxp2_2,new_px,px,npx,new_py,py,npy,new_pz,pz,npz,pp;
unsigned char _ij27[2], _nj27,_ij28[2], _nj28,_ij30[2], _nj30,_ij31[2], _nj31,_ij32[2], _nj32,_ij33[2], _nj33,_ij12[2], _nj12,_ij29[2], _nj29;

IkReal j100, cj100, sj100;
unsigned char _ij100[2], _nj100;
bool ComputeIk(const IkReal* eetrans, const IkReal* eerot, const IkReal* pfree, IkSolutionListBase<IkReal>& solutions) {
j27=numeric_limits<IkReal>::quiet_NaN(); _ij27[0] = -1; _ij27[1] = -1; _nj27 = -1; j28=numeric_limits<IkReal>::quiet_NaN(); _ij28[0] = -1; _ij28[1] = -1; _nj28 = -1; j30=numeric_limits<IkReal>::quiet_NaN(); _ij30[0] = -1; _ij30[1] = -1; _nj30 = -1; j31=numeric_limits<IkReal>::quiet_NaN(); _ij31[0] = -1; _ij31[1] = -1; _nj31 = -1; j32=numeric_limits<IkReal>::quiet_NaN(); _ij32[0] = -1; _ij32[1] = -1; _nj32 = -1; j33=numeric_limits<IkReal>::quiet_NaN(); _ij33[0] = -1; _ij33[1] = -1; _nj33 = -1;  _ij12[0] = -1; _ij12[1] = -1; _nj12 = 0;  _ij29[0] = -1; _ij29[1] = -1; _nj29 = 0; 
for(int dummyiter = 0; dummyiter < 1; ++dummyiter) {
    solutions.Clear();
j12=pfree[0]; cj12=cos(pfree[0]); sj12=sin(pfree[0]), htj12=tan(pfree[0]*0.5);
j29=pfree[1]; cj29=cos(pfree[1]); sj29=sin(pfree[1]), htj29=tan(pfree[1]*0.5);
r00 = eerot[0*3+0];
r01 = eerot[0*3+1];
r02 = eerot[0*3+2];
r10 = eerot[1*3+0];
r11 = eerot[1*3+1];
r12 = eerot[1*3+2];
r20 = eerot[2*3+0];
r21 = eerot[2*3+1];
r22 = eerot[2*3+2];
px = eetrans[0]; py = eetrans[1]; pz = eetrans[2];

new_r00=((-1.0)*r02);
new_r01=r01;
new_r02=r00;
new_px=((0.05)+(((-0.18)*r00))+px);
new_r10=((-1.0)*r12);
new_r11=r11;
new_r12=r10;
new_py=((0.188)+(((-0.18)*r10))+py);
new_r20=((-1.0)*r22);
new_r21=r21;
new_r22=r20;
new_pz=((-0.739675)+(((-1.0)*j12))+pz+(((-0.18)*r20)));
r00 = new_r00; r01 = new_r01; r02 = new_r02; r10 = new_r10; r11 = new_r11; r12 = new_r12; r20 = new_r20; r21 = new_r21; r22 = new_r22; px = new_px; py = new_py; pz = new_pz;
IkReal x68=((1.0)*px);
IkReal x69=((1.0)*pz);
IkReal x70=((1.0)*py);
pp=((px*px)+(py*py)+(pz*pz));
npx=(((px*r00))+((py*r10))+((pz*r20)));
npy=(((px*r01))+((py*r11))+((pz*r21)));
npz=(((px*r02))+((py*r12))+((pz*r22)));
rxp0_0=((((-1.0)*r20*x70))+((pz*r10)));
rxp0_1=(((px*r20))+(((-1.0)*r00*x69)));
rxp0_2=((((-1.0)*r10*x68))+((py*r00)));
rxp1_0=((((-1.0)*r21*x70))+((pz*r11)));
rxp1_1=(((px*r21))+(((-1.0)*r01*x69)));
rxp1_2=((((-1.0)*r11*x68))+((py*r01)));
rxp2_0=((((-1.0)*r22*x70))+((pz*r12)));
rxp2_1=(((px*r22))+(((-1.0)*r02*x69)));
rxp2_2=((((-1.0)*r12*x68))+((py*r02)));
IkReal op[8+1], zeror[8];
int numroots;
IkReal x71=((0.2)*px);
IkReal x72=((1.0)*pp);
IkReal x73=((0.509841)+(((-1.0)*x72))+x71);
IkReal x74=((-0.003759)+(((-1.0)*x72))+x71);
IkReal x75=(x72+x71);
IkReal x76=((0.509841)+(((-1.0)*x75)));
IkReal x77=((-0.003759)+(((-1.0)*x75)));
IkReal gconst0=x73;
IkReal gconst1=x74;
IkReal gconst2=x73;
IkReal gconst3=x74;
IkReal gconst4=x76;
IkReal gconst5=x77;
IkReal gconst6=x76;
IkReal gconst7=x77;
IkReal x78=py*py;
IkReal x79=sj29*sj29;
IkReal x80=px*px;
IkReal x81=((1.0)*gconst4);
IkReal x82=(gconst5*gconst7);
IkReal x83=(gconst0*gconst3);
IkReal x84=(gconst1*gconst2);
IkReal x85=((2.0)*gconst5);
IkReal x86=((1.0)*gconst0);
IkReal x87=(gconst1*gconst7);
IkReal x88=(gconst0*gconst6);
IkReal x89=(gconst1*gconst3);
IkReal x90=(gconst4*gconst7);
IkReal x91=((2.0)*gconst0);
IkReal x92=(gconst1*gconst6);
IkReal x93=(gconst0*gconst7);
IkReal x94=((2.0)*gconst4);
IkReal x95=(gconst3*gconst5);
IkReal x96=(gconst2*gconst5);
IkReal x97=(gconst3*gconst4);
IkReal x98=(gconst2*gconst4);
IkReal x99=(gconst4*gconst6);
IkReal x100=(gconst5*gconst6);
IkReal x101=(gconst0*gconst2);
IkReal x102=((1.05513984)*px*py);
IkReal x103=(gconst6*x78);
IkReal x104=((4.0)*px*py);
IkReal x105=((4.0)*x80);
IkReal x106=(gconst2*x78);
IkReal x107=(py*x79);
IkReal x108=((2.0)*x78);
IkReal x109=((1.0)*x78);
IkReal x110=((0.824328)*x79);
IkReal x111=((0.412164)*x79);
IkReal x112=(x78*x90);
IkReal x113=(x100*x78);
IkReal x114=(x78*x96);
IkReal x115=(x78*x97);
IkReal x116=(x78*x93);
IkReal x117=(x78*x92);
IkReal x118=((0.0834355125792)*x107);
IkReal x119=(x78*x84);
IkReal x120=(x78*x83);
IkReal x122=(x78*x79);
IkReal x123=(x109*x82);
IkReal x124=(x103*x81);
IkReal x125=(x100*x111);
IkReal x126=(x104*x98);
IkReal x127=(x104*x87);
IkReal x128=(x104*x95);
IkReal x129=(x104*x88);
IkReal x130=(x104*x97);
IkReal x131=(x104*x93);
IkReal x132=(x104*x96);
IkReal x133=(x104*x92);
IkReal x134=(x111*x96);
IkReal x135=((0.06594624)*x122);
IkReal x136=(x109*x87);
IkReal x137=(x106*x81);
IkReal x138=(x103*x86);
IkReal x139=(x111*x92);
IkReal x140=(x109*x95);
IkReal x141=((0.3297312)*pp*x107);
IkReal x142=((0.06594624)*px*x107);
IkReal x143=(x106*x86);
IkReal x144=(x111*x84);
IkReal x145=(x109*x89);
IkReal x146=(x120+x119);
IkReal x147=(x113+x112);
IkReal x148=(x143+x144+x145);
IkReal x149=(x124+x125+x123);
IkReal x150=(x117+x116+x115+x114);
IkReal x151=(x131+x130+x133+x132);
IkReal x152=(x126+x127+x128+x129);
IkReal x153=(x140+x135+x134+x137+x136+x139+x138);
op[0]=((((-1.0)*x149))+x147);
op[1]=((((-1.0)*x102))+(((-1.0)*x118))+x141+x142);
op[2]=((((-1.0)*x153))+(((-1.0)*x100*x110))+(((-1.0)*x103*x85))+((x103*x94))+(((-1.0)*x105*x82))+x150+(((-1.0)*x105*x99))+((x108*x82))+(((-1.0)*x108*x90))+((x105*x90))+((x100*x105)));
op[3]=((((-1.0)*x152))+(((-0.1648656)*gconst2*x107))+(((-1.0)*x100*x104))+(((-0.3297312)*gconst5*x107))+x151+(((-0.1648656)*gconst1*x107))+(((-0.3297312)*gconst6*x107))+((x104*x82))+((x104*x99))+(((-1.0)*x104*x90)));
op[4]=((((-1.0)*x149))+(((-1.0)*x148))+(((-0.13189248)*x122))+(((-1.0)*gconst3*x78*x94))+(((-1.0)*x105*x88))+(((-1.0)*x105*x87))+x146+x147+((gconst3*x78*x85))+(((-1.0)*x105*x95))+(((-1.0)*x105*x98))+((x106*x94))+(((-1.0)*x110*x92))+(((-1.0)*x110*x96))+((x108*x88))+((x108*x87))+(((-1.0)*gconst7*x78*x91))+(((-1.0)*x108*x92))+((x105*x93))+((x105*x97))+((x105*x96))+((x105*x92))+(((-1.0)*x106*x85)));
op[5]=((((-1.0)*x151))+(((-0.3297312)*gconst2*x107))+(((-1.0)*x101*x104))+x152+(((-0.1648656)*gconst5*x107))+(((-0.1648656)*gconst6*x107))+(((-0.3297312)*gconst1*x107))+((x104*x84))+((x104*x83))+(((-1.0)*x104*x89)));
op[6]=((((-1.0)*x153))+(((-1.0)*x101*x105))+(((-1.0)*x105*x89))+x150+((x106*x91))+(((-1.0)*x110*x84))+((x108*x89))+(((-1.0)*x108*x83))+(((-1.0)*x108*x84))+((x105*x84))+((x105*x83)));
op[7]=((((-1.0)*x142))+(((-1.0)*x118))+x141+x102);
op[8]=((((-1.0)*x148))+x146);
polyroots8(op,zeror,numroots);
IkReal j27array[8], cj27array[8], sj27array[8], tempj27array[1];
int numsolutions = 0;
for(int ij27 = 0; ij27 < numroots; ++ij27)
{
IkReal htj27 = zeror[ij27];
tempj27array[0]=((2.0)*(atan(htj27)));
for(int kj27 = 0; kj27 < 1; ++kj27)
{
j27array[numsolutions] = tempj27array[kj27];
if( j27array[numsolutions] > IKPI )
{
    j27array[numsolutions]-=IK2PI;
}
else if( j27array[numsolutions] < -IKPI )
{
    j27array[numsolutions]+=IK2PI;
}
sj27array[numsolutions] = IKsin(j27array[numsolutions]);
cj27array[numsolutions] = IKcos(j27array[numsolutions]);
numsolutions++;
}
}
bool j27valid[8]={true,true,true,true,true,true,true,true};
_nj27 = 8;
for(int ij27 = 0; ij27 < numsolutions; ++ij27)
    {
if( !j27valid[ij27] )
{
    continue;
}
    j27 = j27array[ij27]; cj27 = cj27array[ij27]; sj27 = sj27array[ij27];
htj27 = IKtan(j27/2);

_ij27[0] = ij27; _ij27[1] = -1;
for(int iij27 = ij27+1; iij27 < numsolutions; ++iij27)
{
if( j27valid[iij27] && IKabs(cj27array[ij27]-cj27array[iij27]) < IKFAST_SOLUTION_THRESH && IKabs(sj27array[ij27]-sj27array[iij27]) < IKFAST_SOLUTION_THRESH )
{
    j27valid[iij27]=false; _ij27[1] = iij27; break; 
}
}
{
IkReal j28eval[2];
IkReal x154=cj27*cj27;
IkReal x155=py*py;
IkReal x156=px*px;
IkReal x157=pz*pz;
IkReal x158=((100.0)*sj29);
IkReal x159=(py*sj27);
IkReal x160=((4.0)*sj29);
IkReal x161=(cj27*px*sj29);
IkReal x162=(x154*x156);
IkReal x163=(x155*x160);
j28eval[0]=((((-1.0)*x157*x158))+(((-1.0)*x158*x162))+((x154*x155*x158))+(((20.0)*x161))+(((-1.0)*sj29))+(((-1.0)*x155*x158))+(((-200.0)*x159*x161))+(((20.0)*sj29*x159)));
j28eval[1]=IKsign(((((-1.0)*x157*x160))+(((-1.0)*x163))+(((-8.0)*x159*x161))+(((0.8)*sj29*x159))+(((-1.0)*x160*x162))+((x154*x163))+(((0.8)*x161))+(((-0.04)*sj29))));
if( IKabs(j28eval[0]) < 0.0000010000000000  || IKabs(j28eval[1]) < 0.0000010000000000  )
{
{
IkReal j30eval[1];
j30eval[0]=sj29;
if( IKabs(j30eval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j29))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j30array[2], cj30array[2], sj30array[2];
bool j30valid[2]={false};
_nj30 = 2;
cj30array[0]=((-0.98536214953271)+(((3.89408099688474)*pp))+(((-0.778816199376947)*py*sj27))+(((-0.778816199376947)*cj27*px)));
if( cj30array[0] >= -1-IKFAST_SINCOS_THRESH && cj30array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j30valid[0] = j30valid[1] = true;
    j30array[0] = IKacos(cj30array[0]);
    sj30array[0] = IKsin(j30array[0]);
    cj30array[1] = cj30array[0];
    j30array[1] = -j30array[0];
    sj30array[1] = -sj30array[0];
}
else if( isnan(cj30array[0]) )
{
    // probably any value will work
    j30valid[0] = true;
    cj30array[0] = 1; sj30array[0] = 0; j30array[0] = 0;
}
for(int ij30 = 0; ij30 < 2; ++ij30)
{
if( !j30valid[ij30] )
{
    continue;
}
_ij30[0] = ij30; _ij30[1] = -1;
for(int iij30 = ij30+1; iij30 < 2; ++iij30)
{
if( j30valid[iij30] && IKabs(cj30array[ij30]-cj30array[iij30]) < IKFAST_SOLUTION_THRESH && IKabs(sj30array[ij30]-sj30array[iij30]) < IKFAST_SOLUTION_THRESH )
{
    j30valid[iij30]=false; _ij30[1] = iij30; break; 
}
}
j30 = j30array[ij30]; cj30 = cj30array[ij30]; sj30 = sj30array[ij30];

{
IkReal j28eval[3];
sj29=0;
cj29=1.0;
j29=0;
IkReal x164=((321000.0)*cj30);
IkReal x165=(py*sj27);
IkReal x166=((321000.0)*sj30);
IkReal x167=(cj27*px);
j28eval[0]=((1.02430295950156)+cj30);
j28eval[1]=((IKabs(((((-1.0)*x166*x167))+(((32100.0)*sj30))+(((-1.0)*pz*x164))+(((-400000.0)*pz))+(((-1.0)*x165*x166)))))+(IKabs(((-40000.0)+(((400000.0)*x165))+(((400000.0)*x167))+(((-32100.0)*cj30))+(((-1.0)*pz*x166))+((x164*x167))+((x164*x165))))));
j28eval[2]=IKsign(((263041.0)+(((256800.0)*cj30))));
if( IKabs(j28eval[0]) < 0.0000010000000000  || IKabs(j28eval[1]) < 0.0000010000000000  || IKabs(j28eval[2]) < 0.0000010000000000  )
{
{
IkReal j28eval[3];
sj29=0;
cj29=1.0;
j29=0;
IkReal x168=(pz*sj30);
IkReal x169=(cj27*px);
IkReal x170=(py*sj27);
IkReal x171=((10.0)*cj30);
IkReal x172=((321.0)*cj30);
IkReal x173=((1000.0)*pz);
j28eval[0]=((1.24610591900312)+(((-1.0)*x170*x171))+cj30+(((-12.4610591900312)*x170))+(((-1.0)*x169*x171))+(((-10.0)*x168))+(((-12.4610591900312)*x169)));
j28eval[1]=((IKabs(((-160.0)+((pz*x173))+(((-103.041)*(cj30*cj30)))+(((-256.8)*cj30)))))+(IKabs(((((-100.0)*pz))+((x169*x173))+(((128.4)*sj30))+((x170*x173))+(((103.041)*cj30*sj30))))));
j28eval[2]=IKsign(((40.0)+(((-400.0)*x169))+(((-400.0)*x170))+(((-1.0)*x170*x172))+(((-321.0)*x168))+(((-1.0)*x169*x172))+(((32.1)*cj30))));
if( IKabs(j28eval[0]) < 0.0000010000000000  || IKabs(j28eval[1]) < 0.0000010000000000  || IKabs(j28eval[2]) < 0.0000010000000000  )
{
{
IkReal j28eval[3];
sj29=0;
cj29=1.0;
j29=0;
IkReal x174=cj27*cj27;
IkReal x175=py*py;
IkReal x176=pz*pz;
IkReal x177=px*px;
IkReal x178=(cj27*px);
IkReal x179=((321.0)*sj30);
IkReal x180=(py*sj27);
IkReal x181=((321.0)*cj30);
IkReal x183=((200.0)*x180);
IkReal x184=(x174*x175);
IkReal x185=(x174*x177);
j28eval[0]=((-1.0)+(((-1.0)*x178*x183))+(((-100.0)*x175))+(((-100.0)*x176))+(((20.0)*x180))+(((-100.0)*x185))+(((20.0)*x178))+(((100.0)*x184)));
j28eval[1]=((IKabs(((40.0)+((pz*x179))+(((-1.0)*x178*x181))+(((-400.0)*x180))+(((-400.0)*x178))+(((-1.0)*x180*x181))+(((32.1)*cj30)))))+(IKabs((((pz*x181))+((x178*x179))+((x179*x180))+(((400.0)*pz))+(((-32.1)*sj30))))));
j28eval[2]=IKsign(((-10.0)+(((-2000.0)*x178*x180))+x183+(((-1000.0)*x185))+(((-1000.0)*x175))+(((-1000.0)*x176))+(((200.0)*x178))+(((1000.0)*x184))));
if( IKabs(j28eval[0]) < 0.0000010000000000  || IKabs(j28eval[1]) < 0.0000010000000000  || IKabs(j28eval[2]) < 0.0000010000000000  )
{
continue; // no branches [j28]

} else
{
{
IkReal j28array[1], cj28array[1], sj28array[1];
bool j28valid[1]={false};
_nj28 = 1;
IkReal x186=py*py;
IkReal x187=cj27*cj27;
IkReal x188=(cj27*px);
IkReal x189=(py*sj27);
IkReal x190=((321.0)*cj30);
IkReal x191=((321.0)*sj30);
IkReal x192=((1000.0)*x187);
CheckValue<IkReal> x193 = IKatan2WithCheck(IkReal((((x188*x191))+(((400.0)*pz))+((x189*x191))+(((-32.1)*sj30))+((pz*x190)))),IkReal(((40.0)+(((-400.0)*x189))+(((-400.0)*x188))+(((-1.0)*x188*x190))+(((-1.0)*x189*x190))+(((32.1)*cj30))+((pz*x191)))),IKFAST_ATAN2_MAGTHRESH);
if(!x193.valid){
continue;
}
CheckValue<IkReal> x194=IKPowWithIntegerCheck(IKsign(((-10.0)+((x186*x192))+(((-2000.0)*x188*x189))+(((-1000.0)*(pz*pz)))+(((-1000.0)*x186))+(((200.0)*x189))+(((200.0)*x188))+(((-1.0)*x192*(px*px))))),-1);
if(!x194.valid){
continue;
}
j28array[0]=((-1.5707963267949)+(x193.value)+(((1.5707963267949)*(x194.value))));
sj28array[0]=IKsin(j28array[0]);
cj28array[0]=IKcos(j28array[0]);
if( j28array[0] > IKPI )
{
    j28array[0]-=IK2PI;
}
else if( j28array[0] < -IKPI )
{    j28array[0]+=IK2PI;
}
j28valid[0] = true;
for(int ij28 = 0; ij28 < 1; ++ij28)
{
if( !j28valid[ij28] )
{
    continue;
}
_ij28[0] = ij28; _ij28[1] = -1;
for(int iij28 = ij28+1; iij28 < 1; ++iij28)
{
if( j28valid[iij28] && IKabs(cj28array[ij28]-cj28array[iij28]) < IKFAST_SOLUTION_THRESH && IKabs(sj28array[ij28]-sj28array[iij28]) < IKFAST_SOLUTION_THRESH )
{
    j28valid[iij28]=false; _ij28[1] = iij28; break; 
}
}
j28 = j28array[ij28]; cj28 = cj28array[ij28]; sj28 = sj28array[ij28];
{
IkReal evalcond[5];
IkReal x195=IKsin(j28);
IkReal x196=IKcos(j28);
IkReal x197=((0.321)*cj30);
IkReal x198=((0.321)*sj30);
IkReal x199=(cj27*px);
IkReal x200=(py*sj27);
IkReal x201=((1.0)*x200);
IkReal x202=(pz*x195);
IkReal x203=((0.8)*x196);
evalcond[0]=((((0.4)*x195))+((x196*x198))+((x195*x197))+pz);
evalcond[1]=(((x195*x200))+x198+((x195*x199))+(((-0.1)*x195))+((pz*x196)));
evalcond[2]=((0.1)+(((0.4)*x196))+(((-1.0)*x195*x198))+(((-1.0)*x199))+((x196*x197))+(((-1.0)*x201)));
evalcond[3]=((0.4)+(((0.1)*x196))+(((-1.0)*x196*x199))+x197+x202+(((-1.0)*x196*x201)));
evalcond[4]=((-0.066959)+(((0.2)*x200))+(((0.2)*x199))+((x200*x203))+(((-1.0)*pp))+(((-0.08)*x196))+((x199*x203))+(((-0.8)*x202)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j28array[1], cj28array[1], sj28array[1];
bool j28valid[1]={false};
_nj28 = 1;
IkReal x669=((321.0)*cj30);
IkReal x670=(py*sj27);
IkReal x671=(cj27*px);
IkReal x672=((1000.0)*pz);
CheckValue<IkReal> x673 = IKatan2WithCheck(IkReal(((((-100.0)*pz))+((x671*x672))+((x670*x672))+(((128.4)*sj30))+(((103.041)*cj30*sj30)))),IkReal(((-160.0)+((pz*x672))+(((-103.041)*(cj30*cj30)))+(((-256.8)*cj30)))),IKFAST_ATAN2_MAGTHRESH);
if(!x673.valid){
continue;
}
CheckValue<IkReal> x674=IKPowWithIntegerCheck(IKsign(((40.0)+(((-321.0)*pz*sj30))+(((-1.0)*x669*x671))+(((-1.0)*x669*x670))+(((32.1)*cj30))+(((-400.0)*x670))+(((-400.0)*x671)))),-1);
if(!x674.valid){
continue;
}
j28array[0]=((-1.5707963267949)+(x673.value)+(((1.5707963267949)*(x674.value))));
sj28array[0]=IKsin(j28array[0]);
cj28array[0]=IKcos(j28array[0]);
if( j28array[0] > IKPI )
{
    j28array[0]-=IK2PI;
}
else if( j28array[0] < -IKPI )
{    j28array[0]+=IK2PI;
}
j28valid[0] = true;
for(int ij28 = 0; ij28 < 1; ++ij28)
{
if( !j28valid[ij28] )
{
    continue;
}
_ij28[0] = ij28; _ij28[1] = -1;
for(int iij28 = ij28+1; iij28 < 1; ++iij28)
{
if( j28valid[iij28] && IKabs(cj28array[ij28]-cj28array[iij28]) < IKFAST_SOLUTION_THRESH && IKabs(sj28array[ij28]-sj28array[iij28]) < IKFAST_SOLUTION_THRESH )
{
    j28valid[iij28]=false; _ij28[1] = iij28; break; 
}
}
j28 = j28array[ij28]; cj28 = cj28array[ij28]; sj28 = sj28array[ij28];
{
IkReal evalcond[5];
IkReal x675=IKsin(j28);
IkReal x676=IKcos(j28);
IkReal x677=((0.321)*cj30);
IkReal x678=((0.321)*sj30);
IkReal x679=(cj27*px);
IkReal x680=(py*sj27);
IkReal x681=((1.0)*x680);
IkReal x682=(pz*x675);
IkReal x683=((0.8)*x676);
evalcond[0]=((((0.4)*x675))+((x676*x678))+pz+((x675*x677)));
evalcond[1]=(((pz*x676))+(((-0.1)*x675))+x678+((x675*x680))+((x675*x679)));
evalcond[2]=((0.1)+(((-1.0)*x675*x678))+(((0.4)*x676))+(((-1.0)*x681))+((x676*x677))+(((-1.0)*x679)));
evalcond[3]=((0.4)+(((0.1)*x676))+(((-1.0)*x676*x679))+x677+x682+(((-1.0)*x676*x681)));
evalcond[4]=((-0.066959)+(((-0.08)*x676))+(((0.2)*x680))+(((0.2)*x679))+(((-1.0)*pp))+((x679*x683))+((x680*x683))+(((-0.8)*x682)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j28array[1], cj28array[1], sj28array[1];
bool j28valid[1]={false};
_nj28 = 1;
IkReal x684=((321000.0)*cj30);
IkReal x685=(py*sj27);
IkReal x686=(cj27*px);
IkReal x687=((321000.0)*sj30);
CheckValue<IkReal> x688 = IKatan2WithCheck(IkReal(((((-1.0)*x685*x687))+(((32100.0)*sj30))+(((-1.0)*x686*x687))+(((-400000.0)*pz))+(((-1.0)*pz*x684)))),IkReal(((-40000.0)+(((-32100.0)*cj30))+(((400000.0)*x685))+(((400000.0)*x686))+((x684*x685))+((x684*x686))+(((-1.0)*pz*x687)))),IKFAST_ATAN2_MAGTHRESH);
if(!x688.valid){
continue;
}
CheckValue<IkReal> x689=IKPowWithIntegerCheck(IKsign(((263041.0)+(((256800.0)*cj30)))),-1);
if(!x689.valid){
continue;
}
j28array[0]=((-1.5707963267949)+(x688.value)+(((1.5707963267949)*(x689.value))));
sj28array[0]=IKsin(j28array[0]);
cj28array[0]=IKcos(j28array[0]);
if( j28array[0] > IKPI )
{
    j28array[0]-=IK2PI;
}
else if( j28array[0] < -IKPI )
{    j28array[0]+=IK2PI;
}
j28valid[0] = true;
for(int ij28 = 0; ij28 < 1; ++ij28)
{
if( !j28valid[ij28] )
{
    continue;
}
_ij28[0] = ij28; _ij28[1] = -1;
for(int iij28 = ij28+1; iij28 < 1; ++iij28)
{
if( j28valid[iij28] && IKabs(cj28array[ij28]-cj28array[iij28]) < IKFAST_SOLUTION_THRESH && IKabs(sj28array[ij28]-sj28array[iij28]) < IKFAST_SOLUTION_THRESH )
{
    j28valid[iij28]=false; _ij28[1] = iij28; break; 
}
}
j28 = j28array[ij28]; cj28 = cj28array[ij28]; sj28 = sj28array[ij28];
{
IkReal evalcond[5];
IkReal x690=IKsin(j28);
IkReal x691=IKcos(j28);
IkReal x692=((0.321)*cj30);
IkReal x693=((0.321)*sj30);
IkReal x694=(cj27*px);
IkReal x695=(py*sj27);
IkReal x696=((1.0)*x695);
IkReal x697=(pz*x690);
IkReal x698=((0.8)*x691);
evalcond[0]=(((x690*x692))+((x691*x693))+(((0.4)*x690))+pz);
evalcond[1]=(((x690*x695))+((x690*x694))+((pz*x691))+x693+(((-0.1)*x690)));
evalcond[2]=((0.1)+((x691*x692))+(((0.4)*x691))+(((-1.0)*x696))+(((-1.0)*x690*x693))+(((-1.0)*x694)));
evalcond[3]=((0.4)+(((-1.0)*x691*x694))+(((0.1)*x691))+x697+x692+(((-1.0)*x691*x696)));
evalcond[4]=((-0.066959)+((x695*x698))+((x694*x698))+(((-1.0)*pp))+(((-0.08)*x691))+(((-0.8)*x697))+(((0.2)*x695))+(((0.2)*x694)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j29)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j30array[2], cj30array[2], sj30array[2];
bool j30valid[2]={false};
_nj30 = 2;
cj30array[0]=((-0.98536214953271)+(((3.89408099688474)*pp))+(((-0.778816199376947)*py*sj27))+(((-0.778816199376947)*cj27*px)));
if( cj30array[0] >= -1-IKFAST_SINCOS_THRESH && cj30array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j30valid[0] = j30valid[1] = true;
    j30array[0] = IKacos(cj30array[0]);
    sj30array[0] = IKsin(j30array[0]);
    cj30array[1] = cj30array[0];
    j30array[1] = -j30array[0];
    sj30array[1] = -sj30array[0];
}
else if( isnan(cj30array[0]) )
{
    // probably any value will work
    j30valid[0] = true;
    cj30array[0] = 1; sj30array[0] = 0; j30array[0] = 0;
}
for(int ij30 = 0; ij30 < 2; ++ij30)
{
if( !j30valid[ij30] )
{
    continue;
}
_ij30[0] = ij30; _ij30[1] = -1;
for(int iij30 = ij30+1; iij30 < 2; ++iij30)
{
if( j30valid[iij30] && IKabs(cj30array[ij30]-cj30array[iij30]) < IKFAST_SOLUTION_THRESH && IKabs(sj30array[ij30]-sj30array[iij30]) < IKFAST_SOLUTION_THRESH )
{
    j30valid[iij30]=false; _ij30[1] = iij30; break; 
}
}
j30 = j30array[ij30]; cj30 = cj30array[ij30]; sj30 = sj30array[ij30];

{
IkReal j28eval[3];
sj29=0;
cj29=-1.0;
j29=3.14159265358979;
IkReal x699=((321000.0)*cj30);
IkReal x700=(py*sj27);
IkReal x701=((321000.0)*sj30);
IkReal x702=(cj27*px);
j28eval[0]=((-1.02430295950156)+(((-1.0)*cj30)));
j28eval[1]=IKsign(((-263041.0)+(((-256800.0)*cj30))));
j28eval[2]=((IKabs(((40000.0)+(((-1.0)*pz*x701))+(((-1.0)*x699*x702))+(((-1.0)*x699*x700))+(((32100.0)*cj30))+(((-400000.0)*x700))+(((-400000.0)*x702)))))+(IKabs(((((32100.0)*sj30))+((pz*x699))+(((400000.0)*pz))+(((-1.0)*x701*x702))+(((-1.0)*x700*x701))))));
if( IKabs(j28eval[0]) < 0.0000010000000000  || IKabs(j28eval[1]) < 0.0000010000000000  || IKabs(j28eval[2]) < 0.0000010000000000  )
{
{
IkReal j28eval[3];
sj29=0;
cj29=-1.0;
j29=3.14159265358979;
IkReal x703=(pz*sj30);
IkReal x704=(cj27*px);
IkReal x705=(py*sj27);
IkReal x706=((10.0)*cj30);
IkReal x707=((1000.0)*pz);
IkReal x708=((321.0)*cj30);
j28eval[0]=((-1.24610591900312)+(((12.4610591900312)*x704))+(((12.4610591900312)*x705))+(((-10.0)*x703))+(((-1.0)*cj30))+((x704*x706))+((x705*x706)));
j28eval[1]=((IKabs(((160.0)+(((-1.0)*pz*x707))+(((103.041)*(cj30*cj30)))+(((256.8)*cj30)))))+(IKabs(((((100.0)*pz))+(((128.4)*sj30))+(((-1.0)*x704*x707))+(((-1.0)*x705*x707))+(((103.041)*cj30*sj30))))));
j28eval[2]=IKsign(((-40.0)+(((-321.0)*x703))+(((400.0)*x705))+(((400.0)*x704))+((x704*x708))+((x705*x708))+(((-32.1)*cj30))));
if( IKabs(j28eval[0]) < 0.0000010000000000  || IKabs(j28eval[1]) < 0.0000010000000000  || IKabs(j28eval[2]) < 0.0000010000000000  )
{
{
IkReal j28eval[3];
sj29=0;
cj29=-1.0;
j29=3.14159265358979;
IkReal x709=cj27*cj27;
IkReal x710=py*py;
IkReal x711=pz*pz;
IkReal x712=px*px;
IkReal x713=(cj27*px);
IkReal x714=((321.0)*sj30);
IkReal x715=(py*sj27);
IkReal x716=((321.0)*cj30);
IkReal x718=((200.0)*x715);
IkReal x719=(x709*x710);
IkReal x720=(x709*x712);
j28eval[0]=((-1.0)+(((20.0)*x715))+(((20.0)*x713))+(((-100.0)*x720))+(((-100.0)*x711))+(((-100.0)*x710))+(((100.0)*x719))+(((-1.0)*x713*x718)));
j28eval[1]=((IKabs(((40.0)+(((-1.0)*pz*x714))+(((-400.0)*x715))+(((-400.0)*x713))+(((-1.0)*x713*x716))+(((32.1)*cj30))+(((-1.0)*x715*x716)))))+(IKabs(((((-1.0)*x714*x715))+(((400.0)*pz))+(((32.1)*sj30))+(((-1.0)*x713*x714))+((pz*x716))))));
j28eval[2]=IKsign(((-10.0)+(((1000.0)*x719))+(((-2000.0)*x713*x715))+(((-1000.0)*x711))+(((-1000.0)*x710))+x718+(((-1000.0)*x720))+(((200.0)*x713))));
if( IKabs(j28eval[0]) < 0.0000010000000000  || IKabs(j28eval[1]) < 0.0000010000000000  || IKabs(j28eval[2]) < 0.0000010000000000  )
{
continue; // no branches [j28]

} else
{
{
IkReal j28array[1], cj28array[1], sj28array[1];
bool j28valid[1]={false};
_nj28 = 1;
IkReal x721=py*py;
IkReal x722=cj27*cj27;
IkReal x723=(cj27*px);
IkReal x724=(py*sj27);
IkReal x725=((321.0)*cj30);
IkReal x726=((321.0)*sj30);
IkReal x727=((1000.0)*x722);
CheckValue<IkReal> x728=IKPowWithIntegerCheck(IKsign(((-10.0)+((x721*x727))+(((-1.0)*x727*(px*px)))+(((200.0)*x723))+(((200.0)*x724))+(((-1000.0)*(pz*pz)))+(((-2000.0)*x723*x724))+(((-1000.0)*x721)))),-1);
if(!x728.valid){
continue;
}
CheckValue<IkReal> x729 = IKatan2WithCheck(IkReal(((((-1.0)*x724*x726))+(((-1.0)*x723*x726))+(((400.0)*pz))+(((32.1)*sj30))+((pz*x725)))),IkReal(((40.0)+(((-1.0)*x724*x725))+(((-1.0)*x723*x725))+(((-400.0)*x724))+(((-400.0)*x723))+(((32.1)*cj30))+(((-1.0)*pz*x726)))),IKFAST_ATAN2_MAGTHRESH);
if(!x729.valid){
continue;
}
j28array[0]=((-1.5707963267949)+(((1.5707963267949)*(x728.value)))+(x729.value));
sj28array[0]=IKsin(j28array[0]);
cj28array[0]=IKcos(j28array[0]);
if( j28array[0] > IKPI )
{
    j28array[0]-=IK2PI;
}
else if( j28array[0] < -IKPI )
{    j28array[0]+=IK2PI;
}
j28valid[0] = true;
for(int ij28 = 0; ij28 < 1; ++ij28)
{
if( !j28valid[ij28] )
{
    continue;
}
_ij28[0] = ij28; _ij28[1] = -1;
for(int iij28 = ij28+1; iij28 < 1; ++iij28)
{
if( j28valid[iij28] && IKabs(cj28array[ij28]-cj28array[iij28]) < IKFAST_SOLUTION_THRESH && IKabs(sj28array[ij28]-sj28array[iij28]) < IKFAST_SOLUTION_THRESH )
{
    j28valid[iij28]=false; _ij28[1] = iij28; break; 
}
}
j28 = j28array[ij28]; cj28 = cj28array[ij28]; sj28 = sj28array[ij28];
{
IkReal evalcond[5];
IkReal x730=IKsin(j28);
IkReal x731=IKcos(j28);
IkReal x732=((0.321)*cj30);
IkReal x733=((0.321)*sj30);
IkReal x734=(py*sj27);
IkReal x735=(cj27*px);
IkReal x736=((1.0)*x734);
IkReal x737=(pz*x730);
IkReal x738=((1.0)*x731);
IkReal x739=((0.8)*x731);
evalcond[0]=((((0.4)*x730))+(((-1.0)*x731*x733))+pz+((x730*x732)));
evalcond[1]=((0.1)+(((0.4)*x731))+((x731*x732))+(((-1.0)*x735))+(((-1.0)*x736))+((x730*x733)));
evalcond[2]=((0.4)+(((-1.0)*x731*x736))+(((-1.0)*x735*x738))+(((0.1)*x731))+x737+x732);
evalcond[3]=((((-1.0)*x730*x735))+(((-1.0)*x730*x736))+(((0.1)*x730))+x733+(((-1.0)*pz*x738)));
evalcond[4]=((-0.066959)+(((-0.08)*x731))+((x735*x739))+((x734*x739))+(((-1.0)*pp))+(((-0.8)*x737))+(((0.2)*x735))+(((0.2)*x734)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j28array[1], cj28array[1], sj28array[1];
bool j28valid[1]={false};
_nj28 = 1;
IkReal x740=((321.0)*cj30);
IkReal x741=(py*sj27);
IkReal x742=(cj27*px);
IkReal x743=((1000.0)*pz);
CheckValue<IkReal> x744=IKPowWithIntegerCheck(IKsign(((-40.0)+(((-321.0)*pz*sj30))+(((400.0)*x742))+(((400.0)*x741))+((x740*x741))+((x740*x742))+(((-32.1)*cj30)))),-1);
if(!x744.valid){
continue;
}
CheckValue<IkReal> x745 = IKatan2WithCheck(IkReal(((((100.0)*pz))+(((-1.0)*x742*x743))+(((128.4)*sj30))+(((-1.0)*x741*x743))+(((103.041)*cj30*sj30)))),IkReal(((160.0)+(((-1.0)*pz*x743))+(((103.041)*(cj30*cj30)))+(((256.8)*cj30)))),IKFAST_ATAN2_MAGTHRESH);
if(!x745.valid){
continue;
}
j28array[0]=((-1.5707963267949)+(((1.5707963267949)*(x744.value)))+(x745.value));
sj28array[0]=IKsin(j28array[0]);
cj28array[0]=IKcos(j28array[0]);
if( j28array[0] > IKPI )
{
    j28array[0]-=IK2PI;
}
else if( j28array[0] < -IKPI )
{    j28array[0]+=IK2PI;
}
j28valid[0] = true;
for(int ij28 = 0; ij28 < 1; ++ij28)
{
if( !j28valid[ij28] )
{
    continue;
}
_ij28[0] = ij28; _ij28[1] = -1;
for(int iij28 = ij28+1; iij28 < 1; ++iij28)
{
if( j28valid[iij28] && IKabs(cj28array[ij28]-cj28array[iij28]) < IKFAST_SOLUTION_THRESH && IKabs(sj28array[ij28]-sj28array[iij28]) < IKFAST_SOLUTION_THRESH )
{
    j28valid[iij28]=false; _ij28[1] = iij28; break; 
}
}
j28 = j28array[ij28]; cj28 = cj28array[ij28]; sj28 = sj28array[ij28];
{
IkReal evalcond[5];
IkReal x746=IKsin(j28);
IkReal x747=IKcos(j28);
IkReal x748=((0.321)*cj30);
IkReal x749=((0.321)*sj30);
IkReal x750=(py*sj27);
IkReal x751=(cj27*px);
IkReal x752=((1.0)*x750);
IkReal x753=(pz*x746);
IkReal x754=((1.0)*x747);
IkReal x755=((0.8)*x747);
evalcond[0]=((((-1.0)*x747*x749))+((x746*x748))+pz+(((0.4)*x746)));
evalcond[1]=((0.1)+((x747*x748))+((x746*x749))+(((-1.0)*x751))+(((0.4)*x747))+(((-1.0)*x752)));
evalcond[2]=((0.4)+(((0.1)*x747))+(((-1.0)*x751*x754))+(((-1.0)*x747*x752))+x753+x748);
evalcond[3]=((((0.1)*x746))+(((-1.0)*x746*x752))+(((-1.0)*x746*x751))+x749+(((-1.0)*pz*x754)));
evalcond[4]=((-0.066959)+((x751*x755))+(((-0.08)*x747))+(((0.2)*x751))+(((0.2)*x750))+(((-1.0)*pp))+(((-0.8)*x753))+((x750*x755)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j28array[1], cj28array[1], sj28array[1];
bool j28valid[1]={false};
_nj28 = 1;
IkReal x756=(cj27*px);
IkReal x757=((321000.0)*cj30);
IkReal x758=((321000.0)*sj30);
CheckValue<IkReal> x760 = IKatan2WithCheck(IkReal((((pz*x757))+(((-1.0)*py*sj27*x758))+(((32100.0)*sj30))+(((400000.0)*pz))+(((-1.0)*x756*x758)))),IkReal(((40000.0)+(((-400000.0)*py*sj27))+(((-1.0)*py*sj27*x757))+(((-400000.0)*x756))+(((-1.0)*x756*x757))+(((32100.0)*cj30))+(((-1.0)*pz*x758)))),IKFAST_ATAN2_MAGTHRESH);
if(!x760.valid){
continue;
}
CheckValue<IkReal> x761=IKPowWithIntegerCheck(IKsign(((-263041.0)+(((-256800.0)*cj30)))),-1);
if(!x761.valid){
continue;
}
j28array[0]=((-1.5707963267949)+(x760.value)+(((1.5707963267949)*(x761.value))));
sj28array[0]=IKsin(j28array[0]);
cj28array[0]=IKcos(j28array[0]);
if( j28array[0] > IKPI )
{
    j28array[0]-=IK2PI;
}
else if( j28array[0] < -IKPI )
{    j28array[0]+=IK2PI;
}
j28valid[0] = true;
for(int ij28 = 0; ij28 < 1; ++ij28)
{
if( !j28valid[ij28] )
{
    continue;
}
_ij28[0] = ij28; _ij28[1] = -1;
for(int iij28 = ij28+1; iij28 < 1; ++iij28)
{
if( j28valid[iij28] && IKabs(cj28array[ij28]-cj28array[iij28]) < IKFAST_SOLUTION_THRESH && IKabs(sj28array[ij28]-sj28array[iij28]) < IKFAST_SOLUTION_THRESH )
{
    j28valid[iij28]=false; _ij28[1] = iij28; break; 
}
}
j28 = j28array[ij28]; cj28 = cj28array[ij28]; sj28 = sj28array[ij28];
{
IkReal evalcond[5];
IkReal x762=IKsin(j28);
IkReal x763=IKcos(j28);
IkReal x764=((0.321)*cj30);
IkReal x765=((0.321)*sj30);
IkReal x766=(py*sj27);
IkReal x767=(cj27*px);
IkReal x768=((1.0)*x766);
IkReal x769=(pz*x762);
IkReal x770=((1.0)*x763);
IkReal x771=((0.8)*x763);
evalcond[0]=((((-1.0)*x763*x765))+((x762*x764))+pz+(((0.4)*x762)));
evalcond[1]=((0.1)+(((-1.0)*x768))+((x763*x764))+((x762*x765))+(((-1.0)*x767))+(((0.4)*x763)));
evalcond[2]=((0.4)+(((-1.0)*x763*x768))+(((0.1)*x763))+(((-1.0)*x767*x770))+x769+x764);
evalcond[3]=((((-1.0)*x762*x768))+(((0.1)*x762))+(((-1.0)*pz*x770))+(((-1.0)*x762*x767))+x765);
evalcond[4]=((-0.066959)+(((-0.08)*x763))+(((0.2)*x766))+(((0.2)*x767))+((x767*x771))+(((-1.0)*pp))+((x766*x771))+(((-0.8)*x769)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j28, j30]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}

} else
{
{
IkReal j30array[1], cj30array[1], sj30array[1];
bool j30valid[1]={false};
_nj30 = 1;
CheckValue<IkReal> x772=IKPowWithIntegerCheck(sj29,-1);
if(!x772.valid){
continue;
}
if( IKabs(((0.00311526479750779)*(x772.value)*(((((1000.0)*cj27*py))+(((-1000.0)*px*sj27)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-0.98536214953271)+(((3.89408099688474)*pp))+(((-0.778816199376947)*py*sj27))+(((-0.778816199376947)*cj27*px)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((0.00311526479750779)*(x772.value)*(((((1000.0)*cj27*py))+(((-1000.0)*px*sj27))))))+IKsqr(((-0.98536214953271)+(((3.89408099688474)*pp))+(((-0.778816199376947)*py*sj27))+(((-0.778816199376947)*cj27*px))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j30array[0]=IKatan2(((0.00311526479750779)*(x772.value)*(((((1000.0)*cj27*py))+(((-1000.0)*px*sj27))))), ((-0.98536214953271)+(((3.89408099688474)*pp))+(((-0.778816199376947)*py*sj27))+(((-0.778816199376947)*cj27*px))));
sj30array[0]=IKsin(j30array[0]);
cj30array[0]=IKcos(j30array[0]);
if( j30array[0] > IKPI )
{
    j30array[0]-=IK2PI;
}
else if( j30array[0] < -IKPI )
{    j30array[0]+=IK2PI;
}
j30valid[0] = true;
for(int ij30 = 0; ij30 < 1; ++ij30)
{
if( !j30valid[ij30] )
{
    continue;
}
_ij30[0] = ij30; _ij30[1] = -1;
for(int iij30 = ij30+1; iij30 < 1; ++iij30)
{
if( j30valid[iij30] && IKabs(cj30array[ij30]-cj30array[iij30]) < IKFAST_SOLUTION_THRESH && IKabs(sj30array[ij30]-sj30array[iij30]) < IKFAST_SOLUTION_THRESH )
{
    j30valid[iij30]=false; _ij30[1] = iij30; break; 
}
}
j30 = j30array[ij30]; cj30 = cj30array[ij30]; sj30 = sj30array[ij30];
{
IkReal evalcond[2];
evalcond[0]=((((-1.0)*cj27*py))+((px*sj27))+(((0.321)*sj29*(IKsin(j30)))));
evalcond[1]=((0.253041)+(((0.2568)*(IKcos(j30))))+(((-1.0)*pp))+(((0.2)*py*sj27))+(((0.2)*cj27*px)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
IkReal j28eval[3];
IkReal x773=(py*sj27);
IkReal x774=(cj29*sj30);
IkReal x775=(cj27*px);
IkReal x776=((10.0)*cj30);
IkReal x777=((1000.0)*pz);
IkReal x778=((321.0)*cj30);
j28eval[0]=((-1.24610591900312)+((x773*x776))+(((10.0)*pz*x774))+(((-1.0)*cj30))+(((12.4610591900312)*x773))+(((12.4610591900312)*x775))+((x775*x776)));
j28eval[1]=IKsign(((-40.0)+((x773*x778))+(((400.0)*x773))+(((400.0)*x775))+(((321.0)*pz*x774))+(((-32.1)*cj30))+((x775*x778))));
j28eval[2]=((IKabs(((160.0)+(((-1.0)*pz*x777))+(((103.041)*(cj30*cj30)))+(((256.8)*cj30)))))+(IKabs(((((-103.041)*cj30*x774))+(((100.0)*pz))+(((-128.4)*x774))+(((-1.0)*x775*x777))+(((-1.0)*x773*x777))))));
if( IKabs(j28eval[0]) < 0.0000010000000000  || IKabs(j28eval[1]) < 0.0000010000000000  || IKabs(j28eval[2]) < 0.0000010000000000  )
{
{
IkReal j28eval[3];
IkReal x779=cj29*cj29;
IkReal x780=cj30*cj30;
IkReal x781=(cj27*px);
IkReal x782=((321000.0)*cj30);
IkReal x783=(py*sj27);
IkReal x784=((321000.0)*cj29*sj30);
IkReal x785=((103041.0)*x780);
j28eval[0]=((1.5527799613746)+x779+x780+(((2.49221183800623)*cj30))+(((-1.0)*x779*x780)));
j28eval[1]=IKsign(((160000.0)+(((256800.0)*cj30))+(((103041.0)*x779))+x785+(((-1.0)*x779*x785))));
j28eval[2]=((IKabs(((((32100.0)*cj29*sj30))+(((-1.0)*x781*x784))+(((-400000.0)*pz))+(((-1.0)*pz*x782))+(((-1.0)*x783*x784)))))+(IKabs(((-40000.0)+((x781*x782))+(((-32100.0)*cj30))+((x782*x783))+(((400000.0)*x783))+(((400000.0)*x781))+(((-1.0)*pz*x784))))));
if( IKabs(j28eval[0]) < 0.0000010000000000  || IKabs(j28eval[1]) < 0.0000010000000000  || IKabs(j28eval[2]) < 0.0000010000000000  )
{
{
IkReal j28eval[2];
IkReal x786=(cj29*sj30);
IkReal x787=(py*sj27);
IkReal x788=(cj30*pz);
IkReal x789=(cj27*px);
j28eval[0]=((((-10.0)*x786*x787))+(((-10.0)*x786*x789))+x786+(((10.0)*x788))+(((12.4610591900312)*pz)));
j28eval[1]=IKsign(((((400.0)*pz))+(((321.0)*x788))+(((-321.0)*x786*x787))+(((-321.0)*x786*x789))+(((32.1)*x786))));
if( IKabs(j28eval[0]) < 0.0000010000000000  || IKabs(j28eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(pz))+(IKabs(((-3.14159265358979)+(IKfmod(((1.5707963267949)+j29), 6.28318530717959))))));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j28eval[1];
IkReal x790=((-1.0)*py);
pz=0;
j29=1.5707963267949;
sj29=1.0;
cj29=0;
pp=((px*px)+(py*py));
npx=(((px*r00))+((py*r10)));
npy=(((px*r01))+((py*r11)));
npz=(((px*r02))+((py*r12)));
rxp0_0=(r20*x790);
rxp0_1=(px*r20);
rxp1_0=(r21*x790);
rxp1_1=(px*r21);
rxp2_0=(r22*x790);
rxp2_1=(px*r22);
j28eval[0]=((1.0)+(((-10.0)*cj27*px))+(((-10.0)*py*sj27)));
if( IKabs(j28eval[0]) < 0.0000010000000000  )
{
{
IkReal j28eval[1];
IkReal x791=((-1.0)*py);
pz=0;
j29=1.5707963267949;
sj29=1.0;
cj29=0;
pp=((px*px)+(py*py));
npx=(((px*r00))+((py*r10)));
npy=(((px*r01))+((py*r11)));
npz=(((px*r02))+((py*r12)));
rxp0_0=(r20*x791);
rxp0_1=(px*r20);
rxp1_0=(r21*x791);
rxp1_1=(px*r21);
rxp2_0=(r22*x791);
rxp2_1=(px*r22);
j28eval[0]=((1.24610591900312)+cj30);
if( IKabs(j28eval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
IkReal x792=((((100.0)*(px*px)))+(((100.0)*(py*py))));
if((x792) < -0.00001)
continue;
IkReal x793=IKabs(IKsqrt(x792));
IkReal x799 = x792;
if(IKabs(x799)==0){
continue;
}
IkReal x794=pow(x799,-0.5);
CheckValue<IkReal> x800=IKPowWithIntegerCheck(x793,-1);
if(!x800.valid){
continue;
}
IkReal x795=x800.value;
IkReal x796=((10.0)*px*x794);
IkReal x797=((10.0)*py*x794);
if((((1.0)+(((-1.0)*(x795*x795))))) < -0.00001)
continue;
IkReal x798=IKsqrt(((1.0)+(((-1.0)*(x795*x795)))));
if( (x795) < -1-IKFAST_SINCOS_THRESH || (x795) > 1+IKFAST_SINCOS_THRESH )
    continue;
CheckValue<IkReal> x801 = IKatan2WithCheck(IkReal(((-10.0)*px)),IkReal(((-10.0)*py)),IKFAST_ATAN2_MAGTHRESH);
if(!x801.valid){
continue;
}
IkReal gconst25=(((x796*x798))+((x795*x797)));
IkReal gconst26=((((-1.0)*x797*x798))+((x795*x796)));
if((((((100.0)*(px*px)))+(((100.0)*(py*py))))) < -0.00001)
continue;
CheckValue<IkReal> x802=IKPowWithIntegerCheck(IKabs(IKsqrt(((((100.0)*(px*px)))+(((100.0)*(py*py)))))),-1);
if(!x802.valid){
continue;
}
if( (x802.value) < -1-IKFAST_SINCOS_THRESH || (x802.value) > 1+IKFAST_SINCOS_THRESH )
    continue;
CheckValue<IkReal> x803 = IKatan2WithCheck(IkReal(((-10.0)*px)),IkReal(((-10.0)*py)),IKFAST_ATAN2_MAGTHRESH);
if(!x803.valid){
continue;
}
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((IKasin(x802.value))+j27+(x803.value))))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j28array[2], cj28array[2], sj28array[2];
bool j28valid[2]={false};
_nj28 = 2;
CheckValue<IkReal> x805=IKPowWithIntegerCheck(((0.1)+(((-1.0)*gconst25*py))+(((-1.0)*gconst26*px))),-1);
if(!x805.valid){
continue;
}
IkReal x804=x805.value;
cj28array[0]=((((-0.4)*x804))+(((-0.321)*cj30*x804)));
if( cj28array[0] >= -1-IKFAST_SINCOS_THRESH && cj28array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j28valid[0] = j28valid[1] = true;
    j28array[0] = IKacos(cj28array[0]);
    sj28array[0] = IKsin(j28array[0]);
    cj28array[1] = cj28array[0];
    j28array[1] = -j28array[0];
    sj28array[1] = -sj28array[0];
}
else if( isnan(cj28array[0]) )
{
    // probably any value will work
    j28valid[0] = true;
    cj28array[0] = 1; sj28array[0] = 0; j28array[0] = 0;
}
for(int ij28 = 0; ij28 < 2; ++ij28)
{
if( !j28valid[ij28] )
{
    continue;
}
_ij28[0] = ij28; _ij28[1] = -1;
for(int iij28 = ij28+1; iij28 < 2; ++iij28)
{
if( j28valid[iij28] && IKabs(cj28array[ij28]-cj28array[iij28]) < IKFAST_SOLUTION_THRESH && IKabs(sj28array[ij28]-sj28array[iij28]) < IKFAST_SOLUTION_THRESH )
{
    j28valid[iij28]=false; _ij28[1] = iij28; break; 
}
}
j28 = j28array[ij28]; cj28 = cj28array[ij28]; sj28 = sj28array[ij28];
{
IkReal evalcond[4];
IkReal x806=IKsin(j28);
IkReal x807=IKcos(j28);
IkReal x808=(gconst25*py);
IkReal x809=(gconst26*px);
IkReal x810=((0.321)*cj30);
IkReal x811=((1.0)*x806);
IkReal x812=((0.8)*x807);
evalcond[0]=(((x806*x810))+(((0.4)*x806)));
evalcond[1]=((((-1.0)*x808*x811))+(((0.1)*x806))+(((-1.0)*x809*x811)));
evalcond[2]=((0.1)+(((-1.0)*x808))+(((-1.0)*x809))+((x807*x810))+(((0.4)*x807)));
evalcond[3]=((-0.32)+((x809*x812))+((x808*x812))+(((-0.08)*x807))+(((-0.2568)*cj30)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
IkReal x813=((((100.0)*(px*px)))+(((100.0)*(py*py))));
IkReal x820 = x813;
if(IKabs(x820)==0){
continue;
}
IkReal x814=pow(x820,-0.5);
if((x813) < -0.00001)
continue;
IkReal x815=IKabs(IKsqrt(x813));
CheckValue<IkReal> x821=IKPowWithIntegerCheck(x815,-1);
if(!x821.valid){
continue;
}
IkReal x816=x821.value;
IkReal x817=((10.0)*px*x814);
IkReal x818=((10.0)*py*x814);
if((((1.0)+(((-1.0)*(x816*x816))))) < -0.00001)
continue;
IkReal x819=IKsqrt(((1.0)+(((-1.0)*(x816*x816)))));
if( (x816) < -1-IKFAST_SINCOS_THRESH || (x816) > 1+IKFAST_SINCOS_THRESH )
    continue;
CheckValue<IkReal> x822 = IKatan2WithCheck(IkReal(((-10.0)*px)),IkReal(((-10.0)*py)),IKFAST_ATAN2_MAGTHRESH);
if(!x822.valid){
continue;
}
IkReal gconst28=(((x816*x818))+(((-1.0)*x817*x819)));
IkReal gconst29=(((x816*x817))+((x818*x819)));
if((((((100.0)*(px*px)))+(((100.0)*(py*py))))) < -0.00001)
continue;
CheckValue<IkReal> x823=IKPowWithIntegerCheck(IKabs(IKsqrt(((((100.0)*(px*px)))+(((100.0)*(py*py)))))),-1);
if(!x823.valid){
continue;
}
if( (x823.value) < -1-IKFAST_SINCOS_THRESH || (x823.value) > 1+IKFAST_SINCOS_THRESH )
    continue;
CheckValue<IkReal> x824 = IKatan2WithCheck(IkReal(((-10.0)*px)),IkReal(((-10.0)*py)),IKFAST_ATAN2_MAGTHRESH);
if(!x824.valid){
continue;
}
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+(((-1.0)*(IKasin(x823.value))))+j27+(x824.value))))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j28array[2], cj28array[2], sj28array[2];
bool j28valid[2]={false};
_nj28 = 2;
CheckValue<IkReal> x826=IKPowWithIntegerCheck(((0.1)+(((-1.0)*gconst29*px))+(((-1.0)*gconst28*py))),-1);
if(!x826.valid){
continue;
}
IkReal x825=x826.value;
cj28array[0]=((((-0.4)*x825))+(((-0.321)*cj30*x825)));
if( cj28array[0] >= -1-IKFAST_SINCOS_THRESH && cj28array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j28valid[0] = j28valid[1] = true;
    j28array[0] = IKacos(cj28array[0]);
    sj28array[0] = IKsin(j28array[0]);
    cj28array[1] = cj28array[0];
    j28array[1] = -j28array[0];
    sj28array[1] = -sj28array[0];
}
else if( isnan(cj28array[0]) )
{
    // probably any value will work
    j28valid[0] = true;
    cj28array[0] = 1; sj28array[0] = 0; j28array[0] = 0;
}
for(int ij28 = 0; ij28 < 2; ++ij28)
{
if( !j28valid[ij28] )
{
    continue;
}
_ij28[0] = ij28; _ij28[1] = -1;
for(int iij28 = ij28+1; iij28 < 2; ++iij28)
{
if( j28valid[iij28] && IKabs(cj28array[ij28]-cj28array[iij28]) < IKFAST_SOLUTION_THRESH && IKabs(sj28array[ij28]-sj28array[iij28]) < IKFAST_SOLUTION_THRESH )
{
    j28valid[iij28]=false; _ij28[1] = iij28; break; 
}
}
j28 = j28array[ij28]; cj28 = cj28array[ij28]; sj28 = sj28array[ij28];
{
IkReal evalcond[4];
IkReal x827=IKsin(j28);
IkReal x828=IKcos(j28);
IkReal x829=(gconst28*py);
IkReal x830=((0.321)*cj30);
IkReal x831=((0.8)*x828);
IkReal x832=((1.0)*gconst29*px);
evalcond[0]=(((x827*x830))+(((0.4)*x827)));
evalcond[1]=((((0.1)*x827))+(((-1.0)*x827*x832))+(((-1.0)*x827*x829)));
evalcond[2]=((0.1)+(((0.4)*x828))+(((-1.0)*x829))+(((-1.0)*x832))+((x828*x830)));
evalcond[3]=((-0.32)+(((-0.08)*x828))+((x829*x831))+((gconst29*px*x831))+(((-0.2568)*cj30)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j28]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}

} else
{
{
IkReal j28array[2], cj28array[2], sj28array[2];
bool j28valid[2]={false};
_nj28 = 2;
CheckValue<IkReal> x834=IKPowWithIntegerCheck(((0.4)+(((0.321)*cj30))),-1);
if(!x834.valid){
continue;
}
IkReal x833=x834.value;
cj28array[0]=(((cj27*px*x833))+(((-0.1)*x833))+((py*sj27*x833)));
if( cj28array[0] >= -1-IKFAST_SINCOS_THRESH && cj28array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j28valid[0] = j28valid[1] = true;
    j28array[0] = IKacos(cj28array[0]);
    sj28array[0] = IKsin(j28array[0]);
    cj28array[1] = cj28array[0];
    j28array[1] = -j28array[0];
    sj28array[1] = -sj28array[0];
}
else if( isnan(cj28array[0]) )
{
    // probably any value will work
    j28valid[0] = true;
    cj28array[0] = 1; sj28array[0] = 0; j28array[0] = 0;
}
for(int ij28 = 0; ij28 < 2; ++ij28)
{
if( !j28valid[ij28] )
{
    continue;
}
_ij28[0] = ij28; _ij28[1] = -1;
for(int iij28 = ij28+1; iij28 < 2; ++iij28)
{
if( j28valid[iij28] && IKabs(cj28array[ij28]-cj28array[iij28]) < IKFAST_SOLUTION_THRESH && IKabs(sj28array[ij28]-sj28array[iij28]) < IKFAST_SOLUTION_THRESH )
{
    j28valid[iij28]=false; _ij28[1] = iij28; break; 
}
}
j28 = j28array[ij28]; cj28 = cj28array[ij28]; sj28 = sj28array[ij28];
{
IkReal evalcond[4];
IkReal x835=IKsin(j28);
IkReal x836=IKcos(j28);
IkReal x837=((0.321)*cj30);
IkReal x838=(cj27*px);
IkReal x839=((1.0)*x835);
IkReal x840=(py*sj27*x836);
evalcond[0]=((((0.4)*x835))+((x835*x837)));
evalcond[1]=((((-1.0)*py*sj27*x839))+(((-1.0)*x838*x839))+(((0.1)*x835)));
evalcond[2]=((0.4)+(((-1.0)*x836*x838))+(((0.1)*x836))+(((-1.0)*x840))+x837);
evalcond[3]=((-0.32)+(((0.8)*x836*x838))+(((-0.08)*x836))+(((0.8)*x840))+(((-0.2568)*cj30)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j28array[2], cj28array[2], sj28array[2];
bool j28valid[2]={false};
_nj28 = 2;
CheckValue<IkReal> x842=IKPowWithIntegerCheck(((0.1)+(((-1.0)*py*sj27))+(((-1.0)*cj27*px))),-1);
if(!x842.valid){
continue;
}
IkReal x841=x842.value;
cj28array[0]=((((-0.4)*x841))+(((-0.321)*cj30*x841)));
if( cj28array[0] >= -1-IKFAST_SINCOS_THRESH && cj28array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j28valid[0] = j28valid[1] = true;
    j28array[0] = IKacos(cj28array[0]);
    sj28array[0] = IKsin(j28array[0]);
    cj28array[1] = cj28array[0];
    j28array[1] = -j28array[0];
    sj28array[1] = -sj28array[0];
}
else if( isnan(cj28array[0]) )
{
    // probably any value will work
    j28valid[0] = true;
    cj28array[0] = 1; sj28array[0] = 0; j28array[0] = 0;
}
for(int ij28 = 0; ij28 < 2; ++ij28)
{
if( !j28valid[ij28] )
{
    continue;
}
_ij28[0] = ij28; _ij28[1] = -1;
for(int iij28 = ij28+1; iij28 < 2; ++iij28)
{
if( j28valid[iij28] && IKabs(cj28array[ij28]-cj28array[iij28]) < IKFAST_SOLUTION_THRESH && IKabs(sj28array[ij28]-sj28array[iij28]) < IKFAST_SOLUTION_THRESH )
{
    j28valid[iij28]=false; _ij28[1] = iij28; break; 
}
}
j28 = j28array[ij28]; cj28 = cj28array[ij28]; sj28 = sj28array[ij28];
{
IkReal evalcond[4];
IkReal x843=IKsin(j28);
IkReal x844=IKcos(j28);
IkReal x845=(py*sj27);
IkReal x846=(cj27*px);
IkReal x847=((0.321)*cj30);
IkReal x848=((0.8)*x844);
IkReal x849=((1.0)*x843);
evalcond[0]=((((0.4)*x843))+((x843*x847)));
evalcond[1]=((((-1.0)*x846*x849))+(((0.1)*x843))+(((-1.0)*x845*x849)));
evalcond[2]=((0.1)+(((0.4)*x844))+(((-1.0)*x846))+(((-1.0)*x845))+((x844*x847)));
evalcond[3]=((-0.32)+(((-0.08)*x844))+((x846*x848))+(((-0.2568)*cj30))+((x845*x848)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(pz))+(IKabs(((-3.14159265358979)+(IKfmod(((4.71238898038469)+j29), 6.28318530717959))))));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j28eval[1];
IkReal x850=((-1.0)*py);
pz=0;
j29=-1.5707963267949;
sj29=-1.0;
cj29=0;
pp=((px*px)+(py*py));
npx=(((px*r00))+((py*r10)));
npy=(((px*r01))+((py*r11)));
npz=(((px*r02))+((py*r12)));
rxp0_0=(r20*x850);
rxp0_1=(px*r20);
rxp1_0=(r21*x850);
rxp1_1=(px*r21);
rxp2_0=(r22*x850);
rxp2_1=(px*r22);
j28eval[0]=((1.0)+(((-10.0)*cj27*px))+(((-10.0)*py*sj27)));
if( IKabs(j28eval[0]) < 0.0000010000000000  )
{
{
IkReal j28eval[1];
IkReal x851=((-1.0)*py);
pz=0;
j29=-1.5707963267949;
sj29=-1.0;
cj29=0;
pp=((px*px)+(py*py));
npx=(((px*r00))+((py*r10)));
npy=(((px*r01))+((py*r11)));
npz=(((px*r02))+((py*r12)));
rxp0_0=(r20*x851);
rxp0_1=(px*r20);
rxp1_0=(r21*x851);
rxp1_1=(px*r21);
rxp2_0=(r22*x851);
rxp2_1=(px*r22);
j28eval[0]=((1.24610591900312)+cj30);
if( IKabs(j28eval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
IkReal x852=((((100.0)*(px*px)))+(((100.0)*(py*py))));
if((x852) < -0.00001)
continue;
IkReal x853=IKabs(IKsqrt(x852));
IkReal x859 = x852;
if(IKabs(x859)==0){
continue;
}
IkReal x854=pow(x859,-0.5);
CheckValue<IkReal> x860=IKPowWithIntegerCheck(x853,-1);
if(!x860.valid){
continue;
}
IkReal x855=x860.value;
IkReal x856=((10.0)*px*x854);
IkReal x857=((10.0)*py*x854);
if((((1.0)+(((-1.0)*(x855*x855))))) < -0.00001)
continue;
IkReal x858=IKsqrt(((1.0)+(((-1.0)*(x855*x855)))));
if( (x855) < -1-IKFAST_SINCOS_THRESH || (x855) > 1+IKFAST_SINCOS_THRESH )
    continue;
CheckValue<IkReal> x861 = IKatan2WithCheck(IkReal(((-10.0)*px)),IkReal(((-10.0)*py)),IKFAST_ATAN2_MAGTHRESH);
if(!x861.valid){
continue;
}
IkReal gconst31=(((x855*x857))+((x856*x858)));
IkReal gconst32=(((x855*x856))+(((-1.0)*x857*x858)));
if((((((100.0)*(px*px)))+(((100.0)*(py*py))))) < -0.00001)
continue;
CheckValue<IkReal> x862=IKPowWithIntegerCheck(IKabs(IKsqrt(((((100.0)*(px*px)))+(((100.0)*(py*py)))))),-1);
if(!x862.valid){
continue;
}
if( (x862.value) < -1-IKFAST_SINCOS_THRESH || (x862.value) > 1+IKFAST_SINCOS_THRESH )
    continue;
CheckValue<IkReal> x863 = IKatan2WithCheck(IkReal(((-10.0)*px)),IkReal(((-10.0)*py)),IKFAST_ATAN2_MAGTHRESH);
if(!x863.valid){
continue;
}
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((IKasin(x862.value))+j27+(x863.value))))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j28array[2], cj28array[2], sj28array[2];
bool j28valid[2]={false};
_nj28 = 2;
CheckValue<IkReal> x865=IKPowWithIntegerCheck(((0.1)+(((-1.0)*gconst32*px))+(((-1.0)*gconst31*py))),-1);
if(!x865.valid){
continue;
}
IkReal x864=x865.value;
cj28array[0]=((((-0.4)*x864))+(((-0.321)*cj30*x864)));
if( cj28array[0] >= -1-IKFAST_SINCOS_THRESH && cj28array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j28valid[0] = j28valid[1] = true;
    j28array[0] = IKacos(cj28array[0]);
    sj28array[0] = IKsin(j28array[0]);
    cj28array[1] = cj28array[0];
    j28array[1] = -j28array[0];
    sj28array[1] = -sj28array[0];
}
else if( isnan(cj28array[0]) )
{
    // probably any value will work
    j28valid[0] = true;
    cj28array[0] = 1; sj28array[0] = 0; j28array[0] = 0;
}
for(int ij28 = 0; ij28 < 2; ++ij28)
{
if( !j28valid[ij28] )
{
    continue;
}
_ij28[0] = ij28; _ij28[1] = -1;
for(int iij28 = ij28+1; iij28 < 2; ++iij28)
{
if( j28valid[iij28] && IKabs(cj28array[ij28]-cj28array[iij28]) < IKFAST_SOLUTION_THRESH && IKabs(sj28array[ij28]-sj28array[iij28]) < IKFAST_SOLUTION_THRESH )
{
    j28valid[iij28]=false; _ij28[1] = iij28; break; 
}
}
j28 = j28array[ij28]; cj28 = cj28array[ij28]; sj28 = sj28array[ij28];
{
IkReal evalcond[4];
IkReal x866=IKsin(j28);
IkReal x867=IKcos(j28);
IkReal x868=(gconst31*py);
IkReal x869=(gconst32*px);
IkReal x870=((0.321)*cj30);
IkReal x871=((0.8)*x867);
evalcond[0]=(((x866*x870))+(((0.4)*x866)));
evalcond[1]=((((-0.1)*x866))+((x866*x869))+((x866*x868)));
evalcond[2]=((0.1)+((x867*x870))+(((-1.0)*x869))+(((-1.0)*x868))+(((0.4)*x867)));
evalcond[3]=((-0.32)+((x868*x871))+(((-0.2568)*cj30))+((x869*x871))+(((-0.08)*x867)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
IkReal x872=((((100.0)*(px*px)))+(((100.0)*(py*py))));
IkReal x879 = x872;
if(IKabs(x879)==0){
continue;
}
IkReal x873=pow(x879,-0.5);
if((x872) < -0.00001)
continue;
IkReal x874=IKabs(IKsqrt(x872));
CheckValue<IkReal> x880=IKPowWithIntegerCheck(x874,-1);
if(!x880.valid){
continue;
}
IkReal x875=x880.value;
IkReal x876=((10.0)*px*x873);
IkReal x877=((10.0)*py*x873);
if((((1.0)+(((-1.0)*(x875*x875))))) < -0.00001)
continue;
IkReal x878=IKsqrt(((1.0)+(((-1.0)*(x875*x875)))));
if( (x875) < -1-IKFAST_SINCOS_THRESH || (x875) > 1+IKFAST_SINCOS_THRESH )
    continue;
CheckValue<IkReal> x881 = IKatan2WithCheck(IkReal(((-10.0)*px)),IkReal(((-10.0)*py)),IKFAST_ATAN2_MAGTHRESH);
if(!x881.valid){
continue;
}
IkReal gconst34=((((-1.0)*x876*x878))+((x875*x877)));
IkReal gconst35=(((x875*x876))+((x877*x878)));
if((((((100.0)*(px*px)))+(((100.0)*(py*py))))) < -0.00001)
continue;
CheckValue<IkReal> x882=IKPowWithIntegerCheck(IKabs(IKsqrt(((((100.0)*(px*px)))+(((100.0)*(py*py)))))),-1);
if(!x882.valid){
continue;
}
if( (x882.value) < -1-IKFAST_SINCOS_THRESH || (x882.value) > 1+IKFAST_SINCOS_THRESH )
    continue;
CheckValue<IkReal> x883 = IKatan2WithCheck(IkReal(((-10.0)*px)),IkReal(((-10.0)*py)),IKFAST_ATAN2_MAGTHRESH);
if(!x883.valid){
continue;
}
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+(((-1.0)*(IKasin(x882.value))))+j27+(x883.value))))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j28array[2], cj28array[2], sj28array[2];
bool j28valid[2]={false};
_nj28 = 2;
CheckValue<IkReal> x885=IKPowWithIntegerCheck(((0.1)+(((-1.0)*gconst34*py))+(((-1.0)*gconst35*px))),-1);
if(!x885.valid){
continue;
}
IkReal x884=x885.value;
cj28array[0]=((((-0.4)*x884))+(((-0.321)*cj30*x884)));
if( cj28array[0] >= -1-IKFAST_SINCOS_THRESH && cj28array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j28valid[0] = j28valid[1] = true;
    j28array[0] = IKacos(cj28array[0]);
    sj28array[0] = IKsin(j28array[0]);
    cj28array[1] = cj28array[0];
    j28array[1] = -j28array[0];
    sj28array[1] = -sj28array[0];
}
else if( isnan(cj28array[0]) )
{
    // probably any value will work
    j28valid[0] = true;
    cj28array[0] = 1; sj28array[0] = 0; j28array[0] = 0;
}
for(int ij28 = 0; ij28 < 2; ++ij28)
{
if( !j28valid[ij28] )
{
    continue;
}
_ij28[0] = ij28; _ij28[1] = -1;
for(int iij28 = ij28+1; iij28 < 2; ++iij28)
{
if( j28valid[iij28] && IKabs(cj28array[ij28]-cj28array[iij28]) < IKFAST_SOLUTION_THRESH && IKabs(sj28array[ij28]-sj28array[iij28]) < IKFAST_SOLUTION_THRESH )
{
    j28valid[iij28]=false; _ij28[1] = iij28; break; 
}
}
j28 = j28array[ij28]; cj28 = cj28array[ij28]; sj28 = sj28array[ij28];
{
IkReal evalcond[4];
IkReal x886=IKsin(j28);
IkReal x887=IKcos(j28);
IkReal x888=(gconst34*py);
IkReal x889=(gconst35*px);
IkReal x890=((0.321)*cj30);
IkReal x891=((0.8)*x887);
evalcond[0]=(((x886*x890))+(((0.4)*x886)));
evalcond[1]=(((x886*x888))+((x886*x889))+(((-0.1)*x886)));
evalcond[2]=((0.1)+(((-1.0)*x889))+(((-1.0)*x888))+(((0.4)*x887))+((x887*x890)));
evalcond[3]=((-0.32)+(((-0.2568)*cj30))+((x889*x891))+((x888*x891))+(((-0.08)*x887)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j28]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}

} else
{
{
IkReal j28array[2], cj28array[2], sj28array[2];
bool j28valid[2]={false};
_nj28 = 2;
CheckValue<IkReal> x893=IKPowWithIntegerCheck(((0.4)+(((0.321)*cj30))),-1);
if(!x893.valid){
continue;
}
IkReal x892=x893.value;
cj28array[0]=((((-0.1)*x892))+((cj27*px*x892))+((py*sj27*x892)));
if( cj28array[0] >= -1-IKFAST_SINCOS_THRESH && cj28array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j28valid[0] = j28valid[1] = true;
    j28array[0] = IKacos(cj28array[0]);
    sj28array[0] = IKsin(j28array[0]);
    cj28array[1] = cj28array[0];
    j28array[1] = -j28array[0];
    sj28array[1] = -sj28array[0];
}
else if( isnan(cj28array[0]) )
{
    // probably any value will work
    j28valid[0] = true;
    cj28array[0] = 1; sj28array[0] = 0; j28array[0] = 0;
}
for(int ij28 = 0; ij28 < 2; ++ij28)
{
if( !j28valid[ij28] )
{
    continue;
}
_ij28[0] = ij28; _ij28[1] = -1;
for(int iij28 = ij28+1; iij28 < 2; ++iij28)
{
if( j28valid[iij28] && IKabs(cj28array[ij28]-cj28array[iij28]) < IKFAST_SOLUTION_THRESH && IKabs(sj28array[ij28]-sj28array[iij28]) < IKFAST_SOLUTION_THRESH )
{
    j28valid[iij28]=false; _ij28[1] = iij28; break; 
}
}
j28 = j28array[ij28]; cj28 = cj28array[ij28]; sj28 = sj28array[ij28];
{
IkReal evalcond[4];
IkReal x894=IKsin(j28);
IkReal x895=IKcos(j28);
IkReal x896=((0.321)*cj30);
IkReal x897=(py*sj27*x895);
IkReal x898=(cj27*px*x895);
evalcond[0]=(((x894*x896))+(((0.4)*x894)));
evalcond[1]=((((-0.1)*x894))+((cj27*px*x894))+((py*sj27*x894)));
evalcond[2]=((0.4)+(((-1.0)*x898))+(((-1.0)*x897))+x896+(((0.1)*x895)));
evalcond[3]=((-0.32)+(((0.8)*x897))+(((0.8)*x898))+(((-0.2568)*cj30))+(((-0.08)*x895)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j28array[2], cj28array[2], sj28array[2];
bool j28valid[2]={false};
_nj28 = 2;
CheckValue<IkReal> x900=IKPowWithIntegerCheck(((0.1)+(((-1.0)*py*sj27))+(((-1.0)*cj27*px))),-1);
if(!x900.valid){
continue;
}
IkReal x899=x900.value;
cj28array[0]=((((-0.4)*x899))+(((-0.321)*cj30*x899)));
if( cj28array[0] >= -1-IKFAST_SINCOS_THRESH && cj28array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j28valid[0] = j28valid[1] = true;
    j28array[0] = IKacos(cj28array[0]);
    sj28array[0] = IKsin(j28array[0]);
    cj28array[1] = cj28array[0];
    j28array[1] = -j28array[0];
    sj28array[1] = -sj28array[0];
}
else if( isnan(cj28array[0]) )
{
    // probably any value will work
    j28valid[0] = true;
    cj28array[0] = 1; sj28array[0] = 0; j28array[0] = 0;
}
for(int ij28 = 0; ij28 < 2; ++ij28)
{
if( !j28valid[ij28] )
{
    continue;
}
_ij28[0] = ij28; _ij28[1] = -1;
for(int iij28 = ij28+1; iij28 < 2; ++iij28)
{
if( j28valid[iij28] && IKabs(cj28array[ij28]-cj28array[iij28]) < IKFAST_SOLUTION_THRESH && IKabs(sj28array[ij28]-sj28array[iij28]) < IKFAST_SOLUTION_THRESH )
{
    j28valid[iij28]=false; _ij28[1] = iij28; break; 
}
}
j28 = j28array[ij28]; cj28 = cj28array[ij28]; sj28 = sj28array[ij28];
{
IkReal evalcond[4];
IkReal x901=IKsin(j28);
IkReal x902=IKcos(j28);
IkReal x903=(py*sj27);
IkReal x904=(cj27*px);
IkReal x905=((0.321)*cj30);
IkReal x906=((0.8)*x902);
evalcond[0]=(((x901*x905))+(((0.4)*x901)));
evalcond[1]=(((x901*x904))+((x901*x903))+(((-0.1)*x901)));
evalcond[2]=((0.1)+((x902*x905))+(((0.4)*x902))+(((-1.0)*x903))+(((-1.0)*x904)));
evalcond[3]=((-0.32)+((x903*x906))+(((-0.08)*x902))+(((-0.2568)*cj30))+((x904*x906)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(pz))+(IKabs(((-3.14159265358979)+(IKfmod(((3.14159265358979)+j30), 6.28318530717959))))));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j28array[2], cj28array[2], sj28array[2];
bool j28valid[2]={false};
_nj28 = 2;
cj28array[0]=((-0.13869625520111)+(((1.3869625520111)*py*sj27))+(((1.3869625520111)*cj27*px)));
if( cj28array[0] >= -1-IKFAST_SINCOS_THRESH && cj28array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j28valid[0] = j28valid[1] = true;
    j28array[0] = IKacos(cj28array[0]);
    sj28array[0] = IKsin(j28array[0]);
    cj28array[1] = cj28array[0];
    j28array[1] = -j28array[0];
    sj28array[1] = -sj28array[0];
}
else if( isnan(cj28array[0]) )
{
    // probably any value will work
    j28valid[0] = true;
    cj28array[0] = 1; sj28array[0] = 0; j28array[0] = 0;
}
for(int ij28 = 0; ij28 < 2; ++ij28)
{
if( !j28valid[ij28] )
{
    continue;
}
_ij28[0] = ij28; _ij28[1] = -1;
for(int iij28 = ij28+1; iij28 < 2; ++iij28)
{
if( j28valid[iij28] && IKabs(cj28array[ij28]-cj28array[iij28]) < IKFAST_SOLUTION_THRESH && IKabs(sj28array[ij28]-sj28array[iij28]) < IKFAST_SOLUTION_THRESH )
{
    j28valid[iij28]=false; _ij28[1] = iij28; break; 
}
}
j28 = j28array[ij28]; cj28 = cj28array[ij28]; sj28 = sj28array[ij28];
{
IkReal evalcond[5];
IkReal x907=IKcos(j28);
IkReal x908=px*px;
CheckValue<IkReal> x917=IKPowWithIntegerCheck(py,-1);
if(!x917.valid){
continue;
}
IkReal x909=x917.value;
IkReal x910=IKsin(j28);
IkReal x911=(py*sj27);
IkReal x912=(x908*x909);
IkReal x913=((1.0)*x907);
IkReal x914=(sj29*x910);
IkReal x915=(cj29*x910);
IkReal x916=((0.8)*sj27*x907);
evalcond[0]=((0.721)*x910);
evalcond[1]=((0.721)+(((-1.0)*cj27*px*x913))+(((-1.0)*x911*x913))+(((0.1)*x907)));
evalcond[2]=((-0.5768)+(((-0.08)*x907))+((x912*x916))+(((0.8)*x907*x911)));
evalcond[3]=(((x911*x915))+((sj27*x912*x915))+(((-0.1)*x915)));
evalcond[4]=((((-1.0)*sj27*x912*x914))+(((-1.0)*x911*x914))+(((0.1)*x914)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(pz))+(IKabs(((-3.14159265358979)+(IKfmod(j30, 6.28318530717959))))));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j28array[2], cj28array[2], sj28array[2];
bool j28valid[2]={false};
_nj28 = 2;
cj28array[0]=((-1.26582278481013)+(((12.6582278481013)*py*sj27))+(((12.6582278481013)*cj27*px)));
if( cj28array[0] >= -1-IKFAST_SINCOS_THRESH && cj28array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j28valid[0] = j28valid[1] = true;
    j28array[0] = IKacos(cj28array[0]);
    sj28array[0] = IKsin(j28array[0]);
    cj28array[1] = cj28array[0];
    j28array[1] = -j28array[0];
    sj28array[1] = -sj28array[0];
}
else if( isnan(cj28array[0]) )
{
    // probably any value will work
    j28valid[0] = true;
    cj28array[0] = 1; sj28array[0] = 0; j28array[0] = 0;
}
for(int ij28 = 0; ij28 < 2; ++ij28)
{
if( !j28valid[ij28] )
{
    continue;
}
_ij28[0] = ij28; _ij28[1] = -1;
for(int iij28 = ij28+1; iij28 < 2; ++iij28)
{
if( j28valid[iij28] && IKabs(cj28array[ij28]-cj28array[iij28]) < IKFAST_SOLUTION_THRESH && IKabs(sj28array[ij28]-sj28array[iij28]) < IKFAST_SOLUTION_THRESH )
{
    j28valid[iij28]=false; _ij28[1] = iij28; break; 
}
}
j28 = j28array[ij28]; cj28 = cj28array[ij28]; sj28 = sj28array[ij28];
{
IkReal evalcond[5];
IkReal x918=IKcos(j28);
IkReal x919=px*px;
CheckValue<IkReal> x928=IKPowWithIntegerCheck(py,-1);
if(!x928.valid){
continue;
}
IkReal x920=x928.value;
IkReal x921=IKsin(j28);
IkReal x922=(py*sj27);
IkReal x923=(x919*x920);
IkReal x924=((1.0)*x918);
IkReal x925=(sj29*x921);
IkReal x926=(cj29*x921);
IkReal x927=((0.8)*sj27*x918);
evalcond[0]=((0.079)*x921);
evalcond[1]=((0.079)+(((0.1)*x918))+(((-1.0)*cj27*px*x924))+(((-1.0)*x922*x924)));
evalcond[2]=((-0.0632)+(((-0.08)*x918))+(((0.8)*x918*x922))+((x923*x927)));
evalcond[3]=((((-0.1)*x926))+((sj27*x923*x926))+((x922*x926)));
evalcond[4]=((((0.1)*x925))+(((-1.0)*sj27*x923*x925))+(((-1.0)*x922*x925)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j28]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}

} else
{
{
IkReal j28array[1], cj28array[1], sj28array[1];
bool j28valid[1]={false};
_nj28 = 1;
IkReal x929=cj27*cj27;
IkReal x930=py*py;
IkReal x931=(cj27*px);
IkReal x932=(cj29*sj30);
IkReal x933=(py*sj27);
IkReal x934=((1000.0)*pz);
IkReal x935=((1000.0)*x929);
CheckValue<IkReal> x936=IKPowWithIntegerCheck(IKsign(((((32.1)*x932))+(((321.0)*cj30*pz))+(((-321.0)*x932*x933))+(((400.0)*pz))+(((-321.0)*x931*x932)))),-1);
if(!x936.valid){
continue;
}
CheckValue<IkReal> x937 = IKatan2WithCheck(IkReal(((-150.0)+((x935*(px*px)))+(((-1.0)*x930*x935))+(((-200.0)*x931))+(((-200.0)*x933))+(((2000.0)*x931*x933))+(((1000.0)*x930))+(((-103.041)*(cj30*cj30)))+(((-256.8)*cj30)))),IkReal(((((-100.0)*pz))+(((-103.041)*cj30*x932))+(((-128.4)*x932))+((x931*x934))+((x933*x934)))),IKFAST_ATAN2_MAGTHRESH);
if(!x937.valid){
continue;
}
j28array[0]=((-1.5707963267949)+(((1.5707963267949)*(x936.value)))+(x937.value));
sj28array[0]=IKsin(j28array[0]);
cj28array[0]=IKcos(j28array[0]);
if( j28array[0] > IKPI )
{
    j28array[0]-=IK2PI;
}
else if( j28array[0] < -IKPI )
{    j28array[0]+=IK2PI;
}
j28valid[0] = true;
for(int ij28 = 0; ij28 < 1; ++ij28)
{
if( !j28valid[ij28] )
{
    continue;
}
_ij28[0] = ij28; _ij28[1] = -1;
for(int iij28 = ij28+1; iij28 < 1; ++iij28)
{
if( j28valid[iij28] && IKabs(cj28array[ij28]-cj28array[iij28]) < IKFAST_SOLUTION_THRESH && IKabs(sj28array[ij28]-sj28array[iij28]) < IKFAST_SOLUTION_THRESH )
{
    j28valid[iij28]=false; _ij28[1] = iij28; break; 
}
}
j28 = j28array[ij28]; cj28 = cj28array[ij28]; sj28 = sj28array[ij28];
{
IkReal evalcond[6];
IkReal x938=IKsin(j28);
IkReal x939=IKcos(j28);
IkReal x940=((0.321)*cj30);
IkReal x941=(py*sj27);
IkReal x942=((0.321)*sj30);
IkReal x943=((1.0)*sj29);
IkReal x944=(px*sj27);
IkReal x945=(cj27*px);
IkReal x946=(cj27*py);
IkReal x947=((1.0)*x941);
IkReal x948=(pz*x938);
IkReal x949=(cj29*x938);
IkReal x950=(pz*x939);
IkReal x951=((0.8)*x939);
IkReal x952=(sj29*x938);
evalcond[0]=(((x938*x940))+((cj29*x939*x942))+pz+(((0.4)*x938)));
evalcond[1]=((0.1)+(((-1.0)*x947))+(((-1.0)*x942*x949))+((x939*x940))+(((-1.0)*x945))+(((0.4)*x939)));
evalcond[2]=((0.4)+(((0.1)*x939))+(((-1.0)*x939*x947))+(((-1.0)*x939*x945))+x948+x940);
evalcond[3]=((-0.066959)+(((-0.08)*x939))+(((-0.8)*x948))+(((0.2)*x945))+(((0.2)*x941))+((x941*x951))+(((-1.0)*pp))+((x945*x951)));
evalcond[4]=((((0.1)*x952))+(((-1.0)*cj29*x946))+(((-1.0)*x943*x950))+(((-1.0)*x938*x941*x943))+((cj29*x944))+(((-1.0)*x938*x943*x945)));
evalcond[5]=(((sj29*x944))+((x945*x949))+((x941*x949))+((cj29*x950))+(((-1.0)*x943*x946))+(((-0.1)*x949))+x942);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j28array[1], cj28array[1], sj28array[1];
bool j28valid[1]={false};
_nj28 = 1;
IkReal x953=cj29*cj29;
IkReal x954=cj30*cj30;
IkReal x955=(cj27*px);
IkReal x956=((321000.0)*cj30);
IkReal x957=(py*sj27);
IkReal x958=((321000.0)*cj29*sj30);
IkReal x959=((103041.0)*x953);
CheckValue<IkReal> x960=IKPowWithIntegerCheck(IKsign(((160000.0)+(((256800.0)*cj30))+(((-1.0)*x954*x959))+(((103041.0)*x954))+x959)),-1);
if(!x960.valid){
continue;
}
CheckValue<IkReal> x961 = IKatan2WithCheck(IkReal(((((-1.0)*pz*x956))+(((32100.0)*cj29*sj30))+(((-1.0)*x957*x958))+(((-400000.0)*pz))+(((-1.0)*x955*x958)))),IkReal(((-40000.0)+((x955*x956))+(((-1.0)*pz*x958))+(((-32100.0)*cj30))+((x956*x957))+(((400000.0)*x957))+(((400000.0)*x955)))),IKFAST_ATAN2_MAGTHRESH);
if(!x961.valid){
continue;
}
j28array[0]=((-1.5707963267949)+(((1.5707963267949)*(x960.value)))+(x961.value));
sj28array[0]=IKsin(j28array[0]);
cj28array[0]=IKcos(j28array[0]);
if( j28array[0] > IKPI )
{
    j28array[0]-=IK2PI;
}
else if( j28array[0] < -IKPI )
{    j28array[0]+=IK2PI;
}
j28valid[0] = true;
for(int ij28 = 0; ij28 < 1; ++ij28)
{
if( !j28valid[ij28] )
{
    continue;
}
_ij28[0] = ij28; _ij28[1] = -1;
for(int iij28 = ij28+1; iij28 < 1; ++iij28)
{
if( j28valid[iij28] && IKabs(cj28array[ij28]-cj28array[iij28]) < IKFAST_SOLUTION_THRESH && IKabs(sj28array[ij28]-sj28array[iij28]) < IKFAST_SOLUTION_THRESH )
{
    j28valid[iij28]=false; _ij28[1] = iij28; break; 
}
}
j28 = j28array[ij28]; cj28 = cj28array[ij28]; sj28 = sj28array[ij28];
{
IkReal evalcond[6];
IkReal x962=IKsin(j28);
IkReal x963=IKcos(j28);
IkReal x964=((0.321)*cj30);
IkReal x965=(py*sj27);
IkReal x966=((0.321)*sj30);
IkReal x967=((1.0)*sj29);
IkReal x968=(px*sj27);
IkReal x969=(cj27*px);
IkReal x970=(cj27*py);
IkReal x971=((1.0)*x965);
IkReal x972=(pz*x962);
IkReal x973=(cj29*x962);
IkReal x974=(pz*x963);
IkReal x975=((0.8)*x963);
IkReal x976=(sj29*x962);
evalcond[0]=(((x962*x964))+((cj29*x963*x966))+pz+(((0.4)*x962)));
evalcond[1]=((0.1)+(((-1.0)*x969))+(((-1.0)*x966*x973))+((x963*x964))+(((0.4)*x963))+(((-1.0)*x971)));
evalcond[2]=((0.4)+(((-1.0)*x963*x971))+(((-1.0)*x963*x969))+(((0.1)*x963))+x972+x964);
evalcond[3]=((-0.066959)+((x969*x975))+(((-0.8)*x972))+((x965*x975))+(((-1.0)*pp))+(((0.2)*x965))+(((0.2)*x969))+(((-0.08)*x963)));
evalcond[4]=((((-1.0)*x962*x965*x967))+(((0.1)*x976))+(((-1.0)*cj29*x970))+(((-1.0)*x962*x967*x969))+((cj29*x968))+(((-1.0)*x967*x974)));
evalcond[5]=(((x969*x973))+((sj29*x968))+(((-0.1)*x973))+((x965*x973))+(((-1.0)*x967*x970))+((cj29*x974))+x966);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j28array[1], cj28array[1], sj28array[1];
bool j28valid[1]={false};
_nj28 = 1;
IkReal x977=(py*sj27);
IkReal x978=(cj29*sj30);
IkReal x979=((321.0)*cj30);
IkReal x980=(cj27*px);
IkReal x981=((1000.0)*pz);
CheckValue<IkReal> x982=IKPowWithIntegerCheck(IKsign(((-40.0)+(((321.0)*pz*x978))+((x977*x979))+((x979*x980))+(((400.0)*x977))+(((400.0)*x980))+(((-32.1)*cj30)))),-1);
if(!x982.valid){
continue;
}
CheckValue<IkReal> x983 = IKatan2WithCheck(IkReal(((((100.0)*pz))+(((-128.4)*x978))+(((-1.0)*x977*x981))+(((-1.0)*x980*x981))+(((-103.041)*cj30*x978)))),IkReal(((160.0)+(((-1.0)*pz*x981))+(((103.041)*(cj30*cj30)))+(((256.8)*cj30)))),IKFAST_ATAN2_MAGTHRESH);
if(!x983.valid){
continue;
}
j28array[0]=((-1.5707963267949)+(((1.5707963267949)*(x982.value)))+(x983.value));
sj28array[0]=IKsin(j28array[0]);
cj28array[0]=IKcos(j28array[0]);
if( j28array[0] > IKPI )
{
    j28array[0]-=IK2PI;
}
else if( j28array[0] < -IKPI )
{    j28array[0]+=IK2PI;
}
j28valid[0] = true;
for(int ij28 = 0; ij28 < 1; ++ij28)
{
if( !j28valid[ij28] )
{
    continue;
}
_ij28[0] = ij28; _ij28[1] = -1;
for(int iij28 = ij28+1; iij28 < 1; ++iij28)
{
if( j28valid[iij28] && IKabs(cj28array[ij28]-cj28array[iij28]) < IKFAST_SOLUTION_THRESH && IKabs(sj28array[ij28]-sj28array[iij28]) < IKFAST_SOLUTION_THRESH )
{
    j28valid[iij28]=false; _ij28[1] = iij28; break; 
}
}
j28 = j28array[ij28]; cj28 = cj28array[ij28]; sj28 = sj28array[ij28];
{
IkReal evalcond[6];
IkReal x984=IKsin(j28);
IkReal x985=IKcos(j28);
IkReal x986=((0.321)*cj30);
IkReal x987=(py*sj27);
IkReal x988=((0.321)*sj30);
IkReal x989=((1.0)*sj29);
IkReal x990=(px*sj27);
IkReal x991=(cj27*px);
IkReal x992=(cj27*py);
IkReal x993=((1.0)*x987);
IkReal x994=(pz*x984);
IkReal x995=(cj29*x984);
IkReal x996=(pz*x985);
IkReal x997=((0.8)*x985);
IkReal x998=(sj29*x984);
evalcond[0]=((((0.4)*x984))+pz+((cj29*x985*x988))+((x984*x986)));
evalcond[1]=((0.1)+(((-1.0)*x991))+(((0.4)*x985))+(((-1.0)*x993))+((x985*x986))+(((-1.0)*x988*x995)));
evalcond[2]=((0.4)+(((-1.0)*x985*x991))+(((0.1)*x985))+(((-1.0)*x985*x993))+x994+x986);
evalcond[3]=((-0.066959)+(((-0.8)*x994))+((x991*x997))+(((-1.0)*pp))+(((0.2)*x987))+((x987*x997))+(((-0.08)*x985))+(((0.2)*x991)));
evalcond[4]=(((cj29*x990))+(((-1.0)*x984*x989*x991))+(((0.1)*x998))+(((-1.0)*x989*x996))+(((-1.0)*x984*x987*x989))+(((-1.0)*cj29*x992)));
evalcond[5]=(((x991*x995))+((cj29*x996))+((sj29*x990))+(((-0.1)*x995))+((x987*x995))+(((-1.0)*x989*x992))+x988);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}
}
}

}

}

} else
{
{
IkReal j28array[1], cj28array[1], sj28array[1];
bool j28valid[1]={false};
_nj28 = 1;
IkReal x999=cj27*cj27;
IkReal x1000=px*px;
IkReal x1001=py*py;
IkReal x1002=((1.0)*pz);
IkReal x1003=(cj27*px);
IkReal x1004=((5.0)*pp);
IkReal x1005=(cj29*py);
IkReal x1006=((4.0)*cj27);
IkReal x1007=(pz*sj29);
IkReal x1008=(cj29*sj27);
IkReal x1009=(py*sj27*sj29);
IkReal x1011=(sj29*x999);
IkReal x1012=((4.0)*x1001);
CheckValue<IkReal> x1013=IKPowWithIntegerCheck(IKsign(((((0.8)*sj29*x1003))+(((-0.04)*sj29))+(((-4.0)*x1000*x1011))+(((-1.0)*sj29*x1012))+(((0.8)*x1009))+((x1011*x1012))+(((-8.0)*x1003*x1009))+(((-4.0)*pz*x1007)))),-1);
if(!x1013.valid){
continue;
}
CheckValue<IkReal> x1014 = IKatan2WithCheck(IkReal(((((-0.4)*cj27*x1005))+((x1001*x1006*x1008))+((x1004*x1007))+(((-1.0)*x1002*x1009))+(((-1.0)*x1000*x1006*x1008))+(((-1.0)*sj29*x1002*x1003))+(((8.0)*px*x1005*x999))+(((-4.0)*px*x1005))+(((0.334795)*x1007))+(((0.4)*px*x1008)))),IkReal(((((0.5)*pp*sj29))+((pz*x1005*x1006))+(((-4.0)*px*pz*x1008))+((x1000*x1011))+(((0.0334795)*sj29))+(((-1.0)*x1001*x1011))+(((2.0)*x1003*x1009))+(((-1.0)*sj29*x1003*x1004))+(((-1.0)*x1004*x1009))+((sj29*x1001))+(((-0.434795)*x1009))+(((-0.434795)*sj29*x1003)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1014.valid){
continue;
}
j28array[0]=((-1.5707963267949)+(((1.5707963267949)*(x1013.value)))+(x1014.value));
sj28array[0]=IKsin(j28array[0]);
cj28array[0]=IKcos(j28array[0]);
if( j28array[0] > IKPI )
{
    j28array[0]-=IK2PI;
}
else if( j28array[0] < -IKPI )
{    j28array[0]+=IK2PI;
}
j28valid[0] = true;
for(int ij28 = 0; ij28 < 1; ++ij28)
{
if( !j28valid[ij28] )
{
    continue;
}
_ij28[0] = ij28; _ij28[1] = -1;
for(int iij28 = ij28+1; iij28 < 1; ++iij28)
{
if( j28valid[iij28] && IKabs(cj28array[ij28]-cj28array[iij28]) < IKFAST_SOLUTION_THRESH && IKabs(sj28array[ij28]-sj28array[iij28]) < IKFAST_SOLUTION_THRESH )
{
    j28valid[iij28]=false; _ij28[1] = iij28; break; 
}
}
j28 = j28array[ij28]; cj28 = cj28array[ij28]; sj28 = sj28array[ij28];
{
IkReal evalcond[2];
IkReal x1015=IKcos(j28);
IkReal x1016=IKsin(j28);
IkReal x1017=(py*sj27);
IkReal x1018=((1.0)*cj27);
IkReal x1019=(cj27*px);
IkReal x1020=((0.8)*x1015);
IkReal x1021=(sj29*x1016);
evalcond[0]=((-0.066959)+(((-0.8)*pz*x1016))+((x1017*x1020))+(((-0.08)*x1015))+(((-1.0)*pp))+((x1019*x1020))+(((0.2)*x1019))+(((0.2)*x1017)));
evalcond[1]=(((cj29*px*sj27))+(((-1.0)*pz*sj29*x1015))+(((-1.0)*cj29*py*x1018))+(((-1.0)*px*x1018*x1021))+(((0.1)*x1021))+(((-1.0)*x1017*x1021)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
IkReal j30eval[1];
j30eval[0]=sj29;
if( IKabs(j30eval[0]) < 0.0000010000000000  )
{
{
IkReal j30eval[2];
j30eval[0]=cj28;
j30eval[1]=cj29;
if( IKabs(j30eval[0]) < 0.0000010000000000  || IKabs(j30eval[1]) < 0.0000010000000000  )
{
{
IkReal j30eval[2];
j30eval[0]=sj29;
j30eval[1]=sj28;
if( IKabs(j30eval[0]) < 0.0000010000000000  || IKabs(j30eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j29))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j30array[1], cj30array[1], sj30array[1];
bool j30valid[1]={false};
_nj30 = 1;
IkReal x1022=((3.11526479750779)*cj28);
IkReal x1023=(py*sj27);
IkReal x1024=((3.11526479750779)*sj28);
IkReal x1025=(cj27*px);
if( IKabs(((((-1.0)*pz*x1022))+(((-1.0)*x1023*x1024))+(((0.311526479750779)*sj28))+(((-1.0)*x1024*x1025)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.24610591900312)+(((-0.311526479750779)*cj28))+(((-1.0)*pz*x1024))+((x1022*x1025))+((x1022*x1023)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*pz*x1022))+(((-1.0)*x1023*x1024))+(((0.311526479750779)*sj28))+(((-1.0)*x1024*x1025))))+IKsqr(((-1.24610591900312)+(((-0.311526479750779)*cj28))+(((-1.0)*pz*x1024))+((x1022*x1025))+((x1022*x1023))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j30array[0]=IKatan2(((((-1.0)*pz*x1022))+(((-1.0)*x1023*x1024))+(((0.311526479750779)*sj28))+(((-1.0)*x1024*x1025))), ((-1.24610591900312)+(((-0.311526479750779)*cj28))+(((-1.0)*pz*x1024))+((x1022*x1025))+((x1022*x1023))));
sj30array[0]=IKsin(j30array[0]);
cj30array[0]=IKcos(j30array[0]);
if( j30array[0] > IKPI )
{
    j30array[0]-=IK2PI;
}
else if( j30array[0] < -IKPI )
{    j30array[0]+=IK2PI;
}
j30valid[0] = true;
for(int ij30 = 0; ij30 < 1; ++ij30)
{
if( !j30valid[ij30] )
{
    continue;
}
_ij30[0] = ij30; _ij30[1] = -1;
for(int iij30 = ij30+1; iij30 < 1; ++iij30)
{
if( j30valid[iij30] && IKabs(cj30array[ij30]-cj30array[iij30]) < IKFAST_SOLUTION_THRESH && IKabs(sj30array[ij30]-sj30array[iij30]) < IKFAST_SOLUTION_THRESH )
{
    j30valid[iij30]=false; _ij30[1] = iij30; break; 
}
}
j30 = j30array[ij30]; cj30 = cj30array[ij30]; sj30 = sj30array[ij30];
{
IkReal evalcond[5];
IkReal x1026=IKcos(j30);
IkReal x1027=IKsin(j30);
IkReal x1028=(py*sj27);
IkReal x1029=(cj27*px);
IkReal x1030=((0.321)*x1026);
IkReal x1031=((0.321)*x1027);
evalcond[0]=((((0.4)*sj28))+((cj28*x1031))+pz+((sj28*x1030)));
evalcond[1]=((0.253041)+(((0.2568)*x1026))+(((-1.0)*pp))+(((0.2)*x1028))+(((0.2)*x1029)));
evalcond[2]=(x1031+((cj28*pz))+((sj28*x1028))+((sj28*x1029))+(((-0.1)*sj28)));
CheckValue<IkReal> x1032=IKPowWithIntegerCheck(py,-1);
if(!x1032.valid){
continue;
}
evalcond[3]=((0.31630125)+x1030+(((-1.25)*pp))+(((0.25)*x1028))+(((0.25)*sj27*(px*px)*(x1032.value))));
evalcond[4]=((0.1)+((cj28*x1030))+(((-1.0)*x1029))+(((-1.0)*x1028))+(((0.4)*cj28))+(((-1.0)*sj28*x1031)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j29)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j30array[1], cj30array[1], sj30array[1];
bool j30valid[1]={false};
_nj30 = 1;
IkReal x1033=((3.11526479750779)*cj28);
IkReal x1034=(py*sj27);
IkReal x1035=((3.11526479750779)*sj28);
IkReal x1036=(cj27*px);
if( IKabs((((pz*x1033))+(((-0.311526479750779)*sj28))+((x1034*x1035))+((x1035*x1036)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.24610591900312)+(((-0.311526479750779)*cj28))+(((-1.0)*pz*x1035))+((x1033*x1036))+((x1033*x1034)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((((pz*x1033))+(((-0.311526479750779)*sj28))+((x1034*x1035))+((x1035*x1036))))+IKsqr(((-1.24610591900312)+(((-0.311526479750779)*cj28))+(((-1.0)*pz*x1035))+((x1033*x1036))+((x1033*x1034))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j30array[0]=IKatan2((((pz*x1033))+(((-0.311526479750779)*sj28))+((x1034*x1035))+((x1035*x1036))), ((-1.24610591900312)+(((-0.311526479750779)*cj28))+(((-1.0)*pz*x1035))+((x1033*x1036))+((x1033*x1034))));
sj30array[0]=IKsin(j30array[0]);
cj30array[0]=IKcos(j30array[0]);
if( j30array[0] > IKPI )
{
    j30array[0]-=IK2PI;
}
else if( j30array[0] < -IKPI )
{    j30array[0]+=IK2PI;
}
j30valid[0] = true;
for(int ij30 = 0; ij30 < 1; ++ij30)
{
if( !j30valid[ij30] )
{
    continue;
}
_ij30[0] = ij30; _ij30[1] = -1;
for(int iij30 = ij30+1; iij30 < 1; ++iij30)
{
if( j30valid[iij30] && IKabs(cj30array[ij30]-cj30array[iij30]) < IKFAST_SOLUTION_THRESH && IKabs(sj30array[ij30]-sj30array[iij30]) < IKFAST_SOLUTION_THRESH )
{
    j30valid[iij30]=false; _ij30[1] = iij30; break; 
}
}
j30 = j30array[ij30]; cj30 = cj30array[ij30]; sj30 = sj30array[ij30];
{
IkReal evalcond[5];
IkReal x1037=IKcos(j30);
IkReal x1038=IKsin(j30);
IkReal x1039=(cj27*px);
IkReal x1040=((1.0)*sj28);
IkReal x1041=((0.25)*sj27);
IkReal x1042=(py*sj27);
IkReal x1043=((0.321)*x1037);
IkReal x1044=((0.321)*x1038);
evalcond[0]=((((0.4)*sj28))+((sj28*x1043))+pz+(((-1.0)*cj28*x1044)));
evalcond[1]=((0.253041)+(((0.2)*x1042))+(((0.2568)*x1037))+(((-1.0)*pp))+(((0.2)*x1039)));
CheckValue<IkReal> x1045=IKPowWithIntegerCheck(py,-1);
if(!x1045.valid){
continue;
}
evalcond[2]=((0.31630125)+x1043+(((-1.25)*pp))+((x1041*(px*px)*(x1045.value)))+((py*x1041)));
evalcond[3]=(x1044+(((-1.0)*x1039*x1040))+(((0.1)*sj28))+(((-1.0)*x1040*x1042))+(((-1.0)*cj28*pz)));
evalcond[4]=((0.1)+((sj28*x1044))+(((-1.0)*x1039))+(((0.4)*cj28))+(((-1.0)*x1042))+((cj28*x1043)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j28))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j30eval[1];
sj28=0;
cj28=1.0;
j28=0;
j30eval[0]=cj29;
if( IKabs(j30eval[0]) < 0.0000010000000000  )
{
{
IkReal j30eval[1];
sj28=0;
cj28=1.0;
j28=0;
j30eval[0]=sj29;
if( IKabs(j30eval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[2];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j29))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j30array[1], cj30array[1], sj30array[1];
bool j30valid[1]={false};
_nj30 = 1;
if( IKabs(((-3.11526479750779)*pz)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.09981619937695)+(((3.11526479750779)*pp)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-3.11526479750779)*pz))+IKsqr(((-1.09981619937695)+(((3.11526479750779)*pp))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j30array[0]=IKatan2(((-3.11526479750779)*pz), ((-1.09981619937695)+(((3.11526479750779)*pp))));
sj30array[0]=IKsin(j30array[0]);
cj30array[0]=IKcos(j30array[0]);
if( j30array[0] > IKPI )
{
    j30array[0]-=IK2PI;
}
else if( j30array[0] < -IKPI )
{    j30array[0]+=IK2PI;
}
j30valid[0] = true;
for(int ij30 = 0; ij30 < 1; ++ij30)
{
if( !j30valid[ij30] )
{
    continue;
}
_ij30[0] = ij30; _ij30[1] = -1;
for(int iij30 = ij30+1; iij30 < 1; ++iij30)
{
if( j30valid[iij30] && IKabs(cj30array[ij30]-cj30array[iij30]) < IKFAST_SOLUTION_THRESH && IKabs(sj30array[ij30]-sj30array[iij30]) < IKFAST_SOLUTION_THRESH )
{
    j30valid[iij30]=false; _ij30[1] = iij30; break; 
}
}
j30 = j30array[ij30]; cj30 = cj30array[ij30]; sj30 = sj30array[ij30];
{
IkReal evalcond[3];
IkReal x1046=IKcos(j30);
evalcond[0]=(pz+(((0.321)*(IKsin(j30)))));
evalcond[1]=((0.2824328)+(((-0.8)*pp))+(((0.2568)*x1046)));
evalcond[2]=((0.353041)+(((0.321)*x1046))+(((-1.0)*pp)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j29)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j30array[1], cj30array[1], sj30array[1];
bool j30valid[1]={false};
_nj30 = 1;
if( IKabs(((3.11526479750779)*pz)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.09981619937695)+(((3.11526479750779)*pp)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((3.11526479750779)*pz))+IKsqr(((-1.09981619937695)+(((3.11526479750779)*pp))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j30array[0]=IKatan2(((3.11526479750779)*pz), ((-1.09981619937695)+(((3.11526479750779)*pp))));
sj30array[0]=IKsin(j30array[0]);
cj30array[0]=IKcos(j30array[0]);
if( j30array[0] > IKPI )
{
    j30array[0]-=IK2PI;
}
else if( j30array[0] < -IKPI )
{    j30array[0]+=IK2PI;
}
j30valid[0] = true;
for(int ij30 = 0; ij30 < 1; ++ij30)
{
if( !j30valid[ij30] )
{
    continue;
}
_ij30[0] = ij30; _ij30[1] = -1;
for(int iij30 = ij30+1; iij30 < 1; ++iij30)
{
if( j30valid[iij30] && IKabs(cj30array[ij30]-cj30array[iij30]) < IKFAST_SOLUTION_THRESH && IKabs(sj30array[ij30]-sj30array[iij30]) < IKFAST_SOLUTION_THRESH )
{
    j30valid[iij30]=false; _ij30[1] = iij30; break; 
}
}
j30 = j30array[ij30]; cj30 = cj30array[ij30]; sj30 = sj30array[ij30];
{
IkReal evalcond[3];
IkReal x1047=IKcos(j30);
evalcond[0]=((((-0.321)*(IKsin(j30))))+pz);
evalcond[1]=((0.2824328)+(((-0.8)*pp))+(((0.2568)*x1047)));
evalcond[2]=((0.353041)+(((0.321)*x1047))+(((-1.0)*pp)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j29)))), 6.28318530717959)));
evalcond[1]=pz;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j30array[1], cj30array[1], sj30array[1];
bool j30valid[1]={false};
_nj30 = 1;
if( IKabs(((((3.11526479750779)*cj27*py))+(((-3.11526479750779)*px*sj27)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.09981619937695)+(((3.11526479750779)*pp)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((3.11526479750779)*cj27*py))+(((-3.11526479750779)*px*sj27))))+IKsqr(((-1.09981619937695)+(((3.11526479750779)*pp))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j30array[0]=IKatan2(((((3.11526479750779)*cj27*py))+(((-3.11526479750779)*px*sj27))), ((-1.09981619937695)+(((3.11526479750779)*pp))));
sj30array[0]=IKsin(j30array[0]);
cj30array[0]=IKcos(j30array[0]);
if( j30array[0] > IKPI )
{
    j30array[0]-=IK2PI;
}
else if( j30array[0] < -IKPI )
{    j30array[0]+=IK2PI;
}
j30valid[0] = true;
for(int ij30 = 0; ij30 < 1; ++ij30)
{
if( !j30valid[ij30] )
{
    continue;
}
_ij30[0] = ij30; _ij30[1] = -1;
for(int iij30 = ij30+1; iij30 < 1; ++iij30)
{
if( j30valid[iij30] && IKabs(cj30array[ij30]-cj30array[iij30]) < IKFAST_SOLUTION_THRESH && IKabs(sj30array[ij30]-sj30array[iij30]) < IKFAST_SOLUTION_THRESH )
{
    j30valid[iij30]=false; _ij30[1] = iij30; break; 
}
}
j30 = j30array[ij30]; cj30 = cj30array[ij30]; sj30 = sj30array[ij30];
{
IkReal evalcond[3];
IkReal x1048=IKcos(j30);
evalcond[0]=((0.2824328)+(((-0.8)*pp))+(((0.2568)*x1048)));
evalcond[1]=((0.353041)+(((0.321)*x1048))+(((-1.0)*pp)));
evalcond[2]=((((-1.0)*cj27*py))+((px*sj27))+(((0.321)*(IKsin(j30)))));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j29)))), 6.28318530717959)));
evalcond[1]=pz;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j30array[1], cj30array[1], sj30array[1];
bool j30valid[1]={false};
_nj30 = 1;
if( IKabs(((((-3.11526479750779)*cj27*py))+(((3.11526479750779)*px*sj27)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.09981619937695)+(((3.11526479750779)*pp)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-3.11526479750779)*cj27*py))+(((3.11526479750779)*px*sj27))))+IKsqr(((-1.09981619937695)+(((3.11526479750779)*pp))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j30array[0]=IKatan2(((((-3.11526479750779)*cj27*py))+(((3.11526479750779)*px*sj27))), ((-1.09981619937695)+(((3.11526479750779)*pp))));
sj30array[0]=IKsin(j30array[0]);
cj30array[0]=IKcos(j30array[0]);
if( j30array[0] > IKPI )
{
    j30array[0]-=IK2PI;
}
else if( j30array[0] < -IKPI )
{    j30array[0]+=IK2PI;
}
j30valid[0] = true;
for(int ij30 = 0; ij30 < 1; ++ij30)
{
if( !j30valid[ij30] )
{
    continue;
}
_ij30[0] = ij30; _ij30[1] = -1;
for(int iij30 = ij30+1; iij30 < 1; ++iij30)
{
if( j30valid[iij30] && IKabs(cj30array[ij30]-cj30array[iij30]) < IKFAST_SOLUTION_THRESH && IKabs(sj30array[ij30]-sj30array[iij30]) < IKFAST_SOLUTION_THRESH )
{
    j30valid[iij30]=false; _ij30[1] = iij30; break; 
}
}
j30 = j30array[ij30]; cj30 = cj30array[ij30]; sj30 = sj30array[ij30];
{
IkReal evalcond[3];
IkReal x1049=IKcos(j30);
evalcond[0]=((0.2824328)+(((-0.8)*pp))+(((0.2568)*x1049)));
evalcond[1]=((0.353041)+(((0.321)*x1049))+(((-1.0)*pp)));
evalcond[2]=((((-1.0)*cj27*py))+(((-0.321)*(IKsin(j30))))+((px*sj27)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j30]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}

} else
{
{
IkReal j30array[1], cj30array[1], sj30array[1];
bool j30valid[1]={false};
_nj30 = 1;
CheckValue<IkReal> x1050=IKPowWithIntegerCheck(sj29,-1);
if(!x1050.valid){
continue;
}
if( IKabs(((0.00311526479750779)*(x1050.value)*(((((1000.0)*cj27*py))+(((-1000.0)*px*sj27)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.09981619937695)+(((3.11526479750779)*pp)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((0.00311526479750779)*(x1050.value)*(((((1000.0)*cj27*py))+(((-1000.0)*px*sj27))))))+IKsqr(((-1.09981619937695)+(((3.11526479750779)*pp))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j30array[0]=IKatan2(((0.00311526479750779)*(x1050.value)*(((((1000.0)*cj27*py))+(((-1000.0)*px*sj27))))), ((-1.09981619937695)+(((3.11526479750779)*pp))));
sj30array[0]=IKsin(j30array[0]);
cj30array[0]=IKcos(j30array[0]);
if( j30array[0] > IKPI )
{
    j30array[0]-=IK2PI;
}
else if( j30array[0] < -IKPI )
{    j30array[0]+=IK2PI;
}
j30valid[0] = true;
for(int ij30 = 0; ij30 < 1; ++ij30)
{
if( !j30valid[ij30] )
{
    continue;
}
_ij30[0] = ij30; _ij30[1] = -1;
for(int iij30 = ij30+1; iij30 < 1; ++iij30)
{
if( j30valid[iij30] && IKabs(cj30array[ij30]-cj30array[iij30]) < IKFAST_SOLUTION_THRESH && IKabs(sj30array[ij30]-sj30array[iij30]) < IKFAST_SOLUTION_THRESH )
{
    j30valid[iij30]=false; _ij30[1] = iij30; break; 
}
}
j30 = j30array[ij30]; cj30 = cj30array[ij30]; sj30 = sj30array[ij30];
{
IkReal evalcond[5];
IkReal x1051=IKcos(j30);
IkReal x1052=IKsin(j30);
IkReal x1053=(px*sj27);
IkReal x1054=((1.0)*cj27*py);
IkReal x1055=((0.321)*x1052);
evalcond[0]=(pz+((cj29*x1055)));
evalcond[1]=((0.2824328)+(((-0.8)*pp))+(((0.2568)*x1051)));
evalcond[2]=((0.353041)+(((0.321)*x1051))+(((-1.0)*pp)));
evalcond[3]=((((-1.0)*x1054))+x1053+((sj29*x1055)));
evalcond[4]=(x1055+((cj29*pz))+(((-1.0)*sj29*x1054))+((sj29*x1053)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j30array[1], cj30array[1], sj30array[1];
bool j30valid[1]={false};
_nj30 = 1;
CheckValue<IkReal> x1056=IKPowWithIntegerCheck(cj29,-1);
if(!x1056.valid){
continue;
}
if( IKabs(((-3.11526479750779)*pz*(x1056.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.09981619937695)+(((3.11526479750779)*pp)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-3.11526479750779)*pz*(x1056.value)))+IKsqr(((-1.09981619937695)+(((3.11526479750779)*pp))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j30array[0]=IKatan2(((-3.11526479750779)*pz*(x1056.value)), ((-1.09981619937695)+(((3.11526479750779)*pp))));
sj30array[0]=IKsin(j30array[0]);
cj30array[0]=IKcos(j30array[0]);
if( j30array[0] > IKPI )
{
    j30array[0]-=IK2PI;
}
else if( j30array[0] < -IKPI )
{    j30array[0]+=IK2PI;
}
j30valid[0] = true;
for(int ij30 = 0; ij30 < 1; ++ij30)
{
if( !j30valid[ij30] )
{
    continue;
}
_ij30[0] = ij30; _ij30[1] = -1;
for(int iij30 = ij30+1; iij30 < 1; ++iij30)
{
if( j30valid[iij30] && IKabs(cj30array[ij30]-cj30array[iij30]) < IKFAST_SOLUTION_THRESH && IKabs(sj30array[ij30]-sj30array[iij30]) < IKFAST_SOLUTION_THRESH )
{
    j30valid[iij30]=false; _ij30[1] = iij30; break; 
}
}
j30 = j30array[ij30]; cj30 = cj30array[ij30]; sj30 = sj30array[ij30];
{
IkReal evalcond[5];
IkReal x1057=IKcos(j30);
IkReal x1058=IKsin(j30);
IkReal x1059=(px*sj27);
IkReal x1060=((1.0)*cj27*py);
IkReal x1061=((0.321)*x1058);
evalcond[0]=(pz+((cj29*x1061)));
evalcond[1]=((0.2824328)+(((-0.8)*pp))+(((0.2568)*x1057)));
evalcond[2]=((0.353041)+(((0.321)*x1057))+(((-1.0)*pp)));
evalcond[3]=(x1059+(((-1.0)*x1060))+((sj29*x1061)));
evalcond[4]=(x1061+(((-1.0)*sj29*x1060))+((cj29*pz))+((sj29*x1059)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j28)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j30eval[1];
sj28=0;
cj28=-1.0;
j28=3.14159265358979;
j30eval[0]=cj29;
if( IKabs(j30eval[0]) < 0.0000010000000000  )
{
{
IkReal j30eval[1];
sj28=0;
cj28=-1.0;
j28=3.14159265358979;
j30eval[0]=sj29;
if( IKabs(j30eval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[2];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j29))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j30array[1], cj30array[1], sj30array[1];
bool j30valid[1]={false};
_nj30 = 1;
if( IKabs(((3.11526479750779)*pz)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.00228971962617)+(((5.19210799584631)*pp)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((3.11526479750779)*pz))+IKsqr(((-1.00228971962617)+(((5.19210799584631)*pp))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j30array[0]=IKatan2(((3.11526479750779)*pz), ((-1.00228971962617)+(((5.19210799584631)*pp))));
sj30array[0]=IKsin(j30array[0]);
cj30array[0]=IKcos(j30array[0]);
if( j30array[0] > IKPI )
{
    j30array[0]-=IK2PI;
}
else if( j30array[0] < -IKPI )
{    j30array[0]+=IK2PI;
}
j30valid[0] = true;
for(int ij30 = 0; ij30 < 1; ++ij30)
{
if( !j30valid[ij30] )
{
    continue;
}
_ij30[0] = ij30; _ij30[1] = -1;
for(int iij30 = ij30+1; iij30 < 1; ++iij30)
{
if( j30valid[iij30] && IKabs(cj30array[ij30]-cj30array[iij30]) < IKFAST_SOLUTION_THRESH && IKabs(sj30array[ij30]-sj30array[iij30]) < IKFAST_SOLUTION_THRESH )
{
    j30valid[iij30]=false; _ij30[1] = iij30; break; 
}
}
j30 = j30array[ij30]; cj30 = cj30array[ij30]; sj30 = sj30array[ij30];
{
IkReal evalcond[3];
IkReal x1062=IKcos(j30);
evalcond[0]=((((-0.321)*(IKsin(j30))))+pz);
evalcond[1]=((0.257388)+(((0.2568)*x1062))+(((-1.33333333333333)*pp)));
evalcond[2]=((0.321735)+(((0.321)*x1062))+(((-1.66666666666667)*pp)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j29)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j30array[1], cj30array[1], sj30array[1];
bool j30valid[1]={false};
_nj30 = 1;
if( IKabs(((-3.11526479750779)*pz)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.00228971962617)+(((5.19210799584631)*pp)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-3.11526479750779)*pz))+IKsqr(((-1.00228971962617)+(((5.19210799584631)*pp))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j30array[0]=IKatan2(((-3.11526479750779)*pz), ((-1.00228971962617)+(((5.19210799584631)*pp))));
sj30array[0]=IKsin(j30array[0]);
cj30array[0]=IKcos(j30array[0]);
if( j30array[0] > IKPI )
{
    j30array[0]-=IK2PI;
}
else if( j30array[0] < -IKPI )
{    j30array[0]+=IK2PI;
}
j30valid[0] = true;
for(int ij30 = 0; ij30 < 1; ++ij30)
{
if( !j30valid[ij30] )
{
    continue;
}
_ij30[0] = ij30; _ij30[1] = -1;
for(int iij30 = ij30+1; iij30 < 1; ++iij30)
{
if( j30valid[iij30] && IKabs(cj30array[ij30]-cj30array[iij30]) < IKFAST_SOLUTION_THRESH && IKabs(sj30array[ij30]-sj30array[iij30]) < IKFAST_SOLUTION_THRESH )
{
    j30valid[iij30]=false; _ij30[1] = iij30; break; 
}
}
j30 = j30array[ij30]; cj30 = cj30array[ij30]; sj30 = sj30array[ij30];
{
IkReal evalcond[3];
IkReal x1063=IKcos(j30);
evalcond[0]=(pz+(((0.321)*(IKsin(j30)))));
evalcond[1]=((0.257388)+(((0.2568)*x1063))+(((-1.33333333333333)*pp)));
evalcond[2]=((0.321735)+(((0.321)*x1063))+(((-1.66666666666667)*pp)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j29)))), 6.28318530717959)));
evalcond[1]=pz;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j30array[1], cj30array[1], sj30array[1];
bool j30valid[1]={false};
_nj30 = 1;
if( IKabs(((((3.11526479750779)*cj27*py))+(((-3.11526479750779)*px*sj27)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.00228971962617)+(((5.19210799584631)*pp)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((3.11526479750779)*cj27*py))+(((-3.11526479750779)*px*sj27))))+IKsqr(((-1.00228971962617)+(((5.19210799584631)*pp))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j30array[0]=IKatan2(((((3.11526479750779)*cj27*py))+(((-3.11526479750779)*px*sj27))), ((-1.00228971962617)+(((5.19210799584631)*pp))));
sj30array[0]=IKsin(j30array[0]);
cj30array[0]=IKcos(j30array[0]);
if( j30array[0] > IKPI )
{
    j30array[0]-=IK2PI;
}
else if( j30array[0] < -IKPI )
{    j30array[0]+=IK2PI;
}
j30valid[0] = true;
for(int ij30 = 0; ij30 < 1; ++ij30)
{
if( !j30valid[ij30] )
{
    continue;
}
_ij30[0] = ij30; _ij30[1] = -1;
for(int iij30 = ij30+1; iij30 < 1; ++iij30)
{
if( j30valid[iij30] && IKabs(cj30array[ij30]-cj30array[iij30]) < IKFAST_SOLUTION_THRESH && IKabs(sj30array[ij30]-sj30array[iij30]) < IKFAST_SOLUTION_THRESH )
{
    j30valid[iij30]=false; _ij30[1] = iij30; break; 
}
}
j30 = j30array[ij30]; cj30 = cj30array[ij30]; sj30 = sj30array[ij30];
{
IkReal evalcond[3];
IkReal x1064=IKcos(j30);
evalcond[0]=((0.257388)+(((0.2568)*x1064))+(((-1.33333333333333)*pp)));
evalcond[1]=((0.321735)+(((0.321)*x1064))+(((-1.66666666666667)*pp)));
evalcond[2]=((((-1.0)*cj27*py))+((px*sj27))+(((0.321)*(IKsin(j30)))));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j29)))), 6.28318530717959)));
evalcond[1]=pz;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j30array[1], cj30array[1], sj30array[1];
bool j30valid[1]={false};
_nj30 = 1;
if( IKabs(((((-3.11526479750779)*cj27*py))+(((3.11526479750779)*px*sj27)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.00228971962617)+(((5.19210799584631)*pp)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-3.11526479750779)*cj27*py))+(((3.11526479750779)*px*sj27))))+IKsqr(((-1.00228971962617)+(((5.19210799584631)*pp))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j30array[0]=IKatan2(((((-3.11526479750779)*cj27*py))+(((3.11526479750779)*px*sj27))), ((-1.00228971962617)+(((5.19210799584631)*pp))));
sj30array[0]=IKsin(j30array[0]);
cj30array[0]=IKcos(j30array[0]);
if( j30array[0] > IKPI )
{
    j30array[0]-=IK2PI;
}
else if( j30array[0] < -IKPI )
{    j30array[0]+=IK2PI;
}
j30valid[0] = true;
for(int ij30 = 0; ij30 < 1; ++ij30)
{
if( !j30valid[ij30] )
{
    continue;
}
_ij30[0] = ij30; _ij30[1] = -1;
for(int iij30 = ij30+1; iij30 < 1; ++iij30)
{
if( j30valid[iij30] && IKabs(cj30array[ij30]-cj30array[iij30]) < IKFAST_SOLUTION_THRESH && IKabs(sj30array[ij30]-sj30array[iij30]) < IKFAST_SOLUTION_THRESH )
{
    j30valid[iij30]=false; _ij30[1] = iij30; break; 
}
}
j30 = j30array[ij30]; cj30 = cj30array[ij30]; sj30 = sj30array[ij30];
{
IkReal evalcond[3];
IkReal x1065=IKcos(j30);
evalcond[0]=((0.257388)+(((0.2568)*x1065))+(((-1.33333333333333)*pp)));
evalcond[1]=((0.321735)+(((0.321)*x1065))+(((-1.66666666666667)*pp)));
evalcond[2]=((((-1.0)*cj27*py))+(((-0.321)*(IKsin(j30))))+((px*sj27)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j30]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}

} else
{
{
IkReal j30array[1], cj30array[1], sj30array[1];
bool j30valid[1]={false};
_nj30 = 1;
CheckValue<IkReal> x1066=IKPowWithIntegerCheck(sj29,-1);
if(!x1066.valid){
continue;
}
if( IKabs(((0.00311526479750779)*(x1066.value)*(((((1000.0)*cj27*py))+(((-1000.0)*px*sj27)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.00228971962617)+(((5.19210799584631)*pp)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((0.00311526479750779)*(x1066.value)*(((((1000.0)*cj27*py))+(((-1000.0)*px*sj27))))))+IKsqr(((-1.00228971962617)+(((5.19210799584631)*pp))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j30array[0]=IKatan2(((0.00311526479750779)*(x1066.value)*(((((1000.0)*cj27*py))+(((-1000.0)*px*sj27))))), ((-1.00228971962617)+(((5.19210799584631)*pp))));
sj30array[0]=IKsin(j30array[0]);
cj30array[0]=IKcos(j30array[0]);
if( j30array[0] > IKPI )
{
    j30array[0]-=IK2PI;
}
else if( j30array[0] < -IKPI )
{    j30array[0]+=IK2PI;
}
j30valid[0] = true;
for(int ij30 = 0; ij30 < 1; ++ij30)
{
if( !j30valid[ij30] )
{
    continue;
}
_ij30[0] = ij30; _ij30[1] = -1;
for(int iij30 = ij30+1; iij30 < 1; ++iij30)
{
if( j30valid[iij30] && IKabs(cj30array[ij30]-cj30array[iij30]) < IKFAST_SOLUTION_THRESH && IKabs(sj30array[ij30]-sj30array[iij30]) < IKFAST_SOLUTION_THRESH )
{
    j30valid[iij30]=false; _ij30[1] = iij30; break; 
}
}
j30 = j30array[ij30]; cj30 = cj30array[ij30]; sj30 = sj30array[ij30];
{
IkReal evalcond[5];
IkReal x1067=IKcos(j30);
IkReal x1068=IKsin(j30);
IkReal x1069=(px*sj27);
IkReal x1070=((1.0)*cj27*py);
IkReal x1071=((0.321)*x1068);
evalcond[0]=(pz+(((-1.0)*cj29*x1071)));
evalcond[1]=((0.257388)+(((0.2568)*x1067))+(((-1.33333333333333)*pp)));
evalcond[2]=((0.321735)+(((0.321)*x1067))+(((-1.66666666666667)*pp)));
evalcond[3]=(x1069+((sj29*x1071))+(((-1.0)*x1070)));
evalcond[4]=((((-1.0)*sj29*x1070))+x1071+(((-1.0)*cj29*pz))+((sj29*x1069)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j30array[1], cj30array[1], sj30array[1];
bool j30valid[1]={false};
_nj30 = 1;
CheckValue<IkReal> x1072=IKPowWithIntegerCheck(cj29,-1);
if(!x1072.valid){
continue;
}
if( IKabs(((3.11526479750779)*pz*(x1072.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.00228971962617)+(((5.19210799584631)*pp)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((3.11526479750779)*pz*(x1072.value)))+IKsqr(((-1.00228971962617)+(((5.19210799584631)*pp))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j30array[0]=IKatan2(((3.11526479750779)*pz*(x1072.value)), ((-1.00228971962617)+(((5.19210799584631)*pp))));
sj30array[0]=IKsin(j30array[0]);
cj30array[0]=IKcos(j30array[0]);
if( j30array[0] > IKPI )
{
    j30array[0]-=IK2PI;
}
else if( j30array[0] < -IKPI )
{    j30array[0]+=IK2PI;
}
j30valid[0] = true;
for(int ij30 = 0; ij30 < 1; ++ij30)
{
if( !j30valid[ij30] )
{
    continue;
}
_ij30[0] = ij30; _ij30[1] = -1;
for(int iij30 = ij30+1; iij30 < 1; ++iij30)
{
if( j30valid[iij30] && IKabs(cj30array[ij30]-cj30array[iij30]) < IKFAST_SOLUTION_THRESH && IKabs(sj30array[ij30]-sj30array[iij30]) < IKFAST_SOLUTION_THRESH )
{
    j30valid[iij30]=false; _ij30[1] = iij30; break; 
}
}
j30 = j30array[ij30]; cj30 = cj30array[ij30]; sj30 = sj30array[ij30];
{
IkReal evalcond[5];
IkReal x1073=IKcos(j30);
IkReal x1074=IKsin(j30);
IkReal x1075=(px*sj27);
IkReal x1076=((1.0)*cj27*py);
IkReal x1077=((0.321)*x1074);
evalcond[0]=(pz+(((-1.0)*cj29*x1077)));
evalcond[1]=((0.257388)+(((0.2568)*x1073))+(((-1.33333333333333)*pp)));
evalcond[2]=((0.321735)+(((0.321)*x1073))+(((-1.66666666666667)*pp)));
evalcond[3]=(x1075+((sj29*x1077))+(((-1.0)*x1076)));
evalcond[4]=((((-1.0)*sj29*x1076))+x1077+(((-1.0)*cj29*pz))+((sj29*x1075)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j28)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j30eval[1];
sj28=1.0;
cj28=0;
j28=1.5707963267949;
j30eval[0]=sj29;
if( IKabs(j30eval[0]) < 0.0000010000000000  )
{
{
IkReal j30eval[1];
sj28=1.0;
cj28=0;
j28=1.5707963267949;
j30eval[0]=cj29;
if( IKabs(j30eval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j29)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j30array[1], cj30array[1], sj30array[1];
bool j30valid[1]={false};
_nj30 = 1;
if( IKabs(((((3.11526479750779)*cj27*py))+(((-3.11526479750779)*px*sj27)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.24610591900312)+(((-3.11526479750779)*pz)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((3.11526479750779)*cj27*py))+(((-3.11526479750779)*px*sj27))))+IKsqr(((-1.24610591900312)+(((-3.11526479750779)*pz))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j30array[0]=IKatan2(((((3.11526479750779)*cj27*py))+(((-3.11526479750779)*px*sj27))), ((-1.24610591900312)+(((-3.11526479750779)*pz))));
sj30array[0]=IKsin(j30array[0]);
cj30array[0]=IKcos(j30array[0]);
if( j30array[0] > IKPI )
{
    j30array[0]-=IK2PI;
}
else if( j30array[0] < -IKPI )
{    j30array[0]+=IK2PI;
}
j30valid[0] = true;
for(int ij30 = 0; ij30 < 1; ++ij30)
{
if( !j30valid[ij30] )
{
    continue;
}
_ij30[0] = ij30; _ij30[1] = -1;
for(int iij30 = ij30+1; iij30 < 1; ++iij30)
{
if( j30valid[iij30] && IKabs(cj30array[ij30]-cj30array[iij30]) < IKFAST_SOLUTION_THRESH && IKabs(sj30array[ij30]-sj30array[iij30]) < IKFAST_SOLUTION_THRESH )
{
    j30valid[iij30]=false; _ij30[1] = iij30; break; 
}
}
j30 = j30array[ij30]; cj30 = cj30array[ij30]; sj30 = sj30array[ij30];
{
IkReal evalcond[3];
IkReal x1078=IKcos(j30);
evalcond[0]=((0.4)+(((0.321)*x1078))+pz);
evalcond[1]=((0.32)+(((0.8)*pz))+(((0.2568)*x1078)));
evalcond[2]=((((-1.0)*cj27*py))+((px*sj27))+(((0.321)*(IKsin(j30)))));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j29)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j30array[1], cj30array[1], sj30array[1];
bool j30valid[1]={false};
_nj30 = 1;
if( IKabs(((((-3.11526479750779)*cj27*py))+(((3.11526479750779)*px*sj27)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.24610591900312)+(((-3.11526479750779)*pz)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-3.11526479750779)*cj27*py))+(((3.11526479750779)*px*sj27))))+IKsqr(((-1.24610591900312)+(((-3.11526479750779)*pz))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j30array[0]=IKatan2(((((-3.11526479750779)*cj27*py))+(((3.11526479750779)*px*sj27))), ((-1.24610591900312)+(((-3.11526479750779)*pz))));
sj30array[0]=IKsin(j30array[0]);
cj30array[0]=IKcos(j30array[0]);
if( j30array[0] > IKPI )
{
    j30array[0]-=IK2PI;
}
else if( j30array[0] < -IKPI )
{    j30array[0]+=IK2PI;
}
j30valid[0] = true;
for(int ij30 = 0; ij30 < 1; ++ij30)
{
if( !j30valid[ij30] )
{
    continue;
}
_ij30[0] = ij30; _ij30[1] = -1;
for(int iij30 = ij30+1; iij30 < 1; ++iij30)
{
if( j30valid[iij30] && IKabs(cj30array[ij30]-cj30array[iij30]) < IKFAST_SOLUTION_THRESH && IKabs(sj30array[ij30]-sj30array[iij30]) < IKFAST_SOLUTION_THRESH )
{
    j30valid[iij30]=false; _ij30[1] = iij30; break; 
}
}
j30 = j30array[ij30]; cj30 = cj30array[ij30]; sj30 = sj30array[ij30];
{
IkReal evalcond[3];
IkReal x1079=IKcos(j30);
evalcond[0]=((0.4)+(((0.321)*x1079))+pz);
evalcond[1]=((0.32)+(((0.8)*pz))+(((0.2568)*x1079)));
evalcond[2]=((((-1.0)*cj27*py))+(((-0.321)*(IKsin(j30))))+((px*sj27)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j29))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j30array[1], cj30array[1], sj30array[1];
bool j30valid[1]={false};
_nj30 = 1;
if( IKabs(((0.311526479750779)+(((-3.11526479750779)*cj27*px))+(((-3.11526479750779)*py*sj27)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.24610591900312)+(((-3.11526479750779)*pz)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((0.311526479750779)+(((-3.11526479750779)*cj27*px))+(((-3.11526479750779)*py*sj27))))+IKsqr(((-1.24610591900312)+(((-3.11526479750779)*pz))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j30array[0]=IKatan2(((0.311526479750779)+(((-3.11526479750779)*cj27*px))+(((-3.11526479750779)*py*sj27))), ((-1.24610591900312)+(((-3.11526479750779)*pz))));
sj30array[0]=IKsin(j30array[0]);
cj30array[0]=IKcos(j30array[0]);
if( j30array[0] > IKPI )
{
    j30array[0]-=IK2PI;
}
else if( j30array[0] < -IKPI )
{    j30array[0]+=IK2PI;
}
j30valid[0] = true;
for(int ij30 = 0; ij30 < 1; ++ij30)
{
if( !j30valid[ij30] )
{
    continue;
}
_ij30[0] = ij30; _ij30[1] = -1;
for(int iij30 = ij30+1; iij30 < 1; ++iij30)
{
if( j30valid[iij30] && IKabs(cj30array[ij30]-cj30array[iij30]) < IKFAST_SOLUTION_THRESH && IKabs(sj30array[ij30]-sj30array[iij30]) < IKFAST_SOLUTION_THRESH )
{
    j30valid[iij30]=false; _ij30[1] = iij30; break; 
}
}
j30 = j30array[ij30]; cj30 = cj30array[ij30]; sj30 = sj30array[ij30];
{
IkReal evalcond[3];
IkReal x1080=IKcos(j30);
evalcond[0]=((0.4)+(((0.321)*x1080))+pz);
evalcond[1]=((0.32)+(((0.8)*pz))+(((0.2568)*x1080)));
evalcond[2]=((0.1)+(((-1.0)*py*sj27))+(((-1.0)*cj27*px))+(((-0.321)*(IKsin(j30)))));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j29)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j30array[1], cj30array[1], sj30array[1];
bool j30valid[1]={false};
_nj30 = 1;
if( IKabs(((-0.311526479750779)+(((3.11526479750779)*cj27*px))+(((3.11526479750779)*py*sj27)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.24610591900312)+(((-3.11526479750779)*pz)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-0.311526479750779)+(((3.11526479750779)*cj27*px))+(((3.11526479750779)*py*sj27))))+IKsqr(((-1.24610591900312)+(((-3.11526479750779)*pz))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j30array[0]=IKatan2(((-0.311526479750779)+(((3.11526479750779)*cj27*px))+(((3.11526479750779)*py*sj27))), ((-1.24610591900312)+(((-3.11526479750779)*pz))));
sj30array[0]=IKsin(j30array[0]);
cj30array[0]=IKcos(j30array[0]);
if( j30array[0] > IKPI )
{
    j30array[0]-=IK2PI;
}
else if( j30array[0] < -IKPI )
{    j30array[0]+=IK2PI;
}
j30valid[0] = true;
for(int ij30 = 0; ij30 < 1; ++ij30)
{
if( !j30valid[ij30] )
{
    continue;
}
_ij30[0] = ij30; _ij30[1] = -1;
for(int iij30 = ij30+1; iij30 < 1; ++iij30)
{
if( j30valid[iij30] && IKabs(cj30array[ij30]-cj30array[iij30]) < IKFAST_SOLUTION_THRESH && IKabs(sj30array[ij30]-sj30array[iij30]) < IKFAST_SOLUTION_THRESH )
{
    j30valid[iij30]=false; _ij30[1] = iij30; break; 
}
}
j30 = j30array[ij30]; cj30 = cj30array[ij30]; sj30 = sj30array[ij30];
{
IkReal evalcond[3];
IkReal x1081=IKcos(j30);
evalcond[0]=((0.4)+(((0.321)*x1081))+pz);
evalcond[1]=((0.32)+(((0.8)*pz))+(((0.2568)*x1081)));
evalcond[2]=((0.1)+(((-1.0)*py*sj27))+(((-1.0)*cj27*px))+(((0.321)*(IKsin(j30)))));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j30]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}

} else
{
{
IkReal j30array[1], cj30array[1], sj30array[1];
bool j30valid[1]={false};
_nj30 = 1;
CheckValue<IkReal> x1082=IKPowWithIntegerCheck(cj29,-1);
if(!x1082.valid){
continue;
}
if( IKabs(((0.00311526479750779)*(x1082.value)*(((100.0)+(((-1000.0)*cj27*px))+(((-1000.0)*py*sj27)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.24610591900312)+(((-3.11526479750779)*pz)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((0.00311526479750779)*(x1082.value)*(((100.0)+(((-1000.0)*cj27*px))+(((-1000.0)*py*sj27))))))+IKsqr(((-1.24610591900312)+(((-3.11526479750779)*pz))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j30array[0]=IKatan2(((0.00311526479750779)*(x1082.value)*(((100.0)+(((-1000.0)*cj27*px))+(((-1000.0)*py*sj27))))), ((-1.24610591900312)+(((-3.11526479750779)*pz))));
sj30array[0]=IKsin(j30array[0]);
cj30array[0]=IKcos(j30array[0]);
if( j30array[0] > IKPI )
{
    j30array[0]-=IK2PI;
}
else if( j30array[0] < -IKPI )
{    j30array[0]+=IK2PI;
}
j30valid[0] = true;
for(int ij30 = 0; ij30 < 1; ++ij30)
{
if( !j30valid[ij30] )
{
    continue;
}
_ij30[0] = ij30; _ij30[1] = -1;
for(int iij30 = ij30+1; iij30 < 1; ++iij30)
{
if( j30valid[iij30] && IKabs(cj30array[ij30]-cj30array[iij30]) < IKFAST_SOLUTION_THRESH && IKabs(sj30array[ij30]-sj30array[iij30]) < IKFAST_SOLUTION_THRESH )
{
    j30valid[iij30]=false; _ij30[1] = iij30; break; 
}
}
j30 = j30array[ij30]; cj30 = cj30array[ij30]; sj30 = sj30array[ij30];
{
IkReal evalcond[5];
IkReal x1083=IKcos(j30);
IkReal x1084=IKsin(j30);
IkReal x1085=((1.0)*py);
IkReal x1086=(cj27*px);
IkReal x1087=(px*sj27);
IkReal x1088=((0.321)*x1084);
evalcond[0]=((0.4)+(((0.321)*x1083))+pz);
evalcond[1]=((0.32)+(((0.8)*pz))+(((0.2568)*x1083)));
evalcond[2]=(x1087+((sj29*x1088))+(((-1.0)*cj27*x1085)));
evalcond[3]=((0.1)+(((-1.0)*x1086))+(((-1.0)*sj27*x1085))+(((-1.0)*cj29*x1088)));
evalcond[4]=(((cj29*py*sj27))+x1088+((sj29*x1087))+(((-1.0)*cj27*sj29*x1085))+((cj29*x1086))+(((-0.1)*cj29)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j30array[1], cj30array[1], sj30array[1];
bool j30valid[1]={false};
_nj30 = 1;
CheckValue<IkReal> x1089=IKPowWithIntegerCheck(sj29,-1);
if(!x1089.valid){
continue;
}
if( IKabs(((0.00311526479750779)*(x1089.value)*(((((1000.0)*cj27*py))+(((-1000.0)*px*sj27)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.24610591900312)+(((-3.11526479750779)*pz)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((0.00311526479750779)*(x1089.value)*(((((1000.0)*cj27*py))+(((-1000.0)*px*sj27))))))+IKsqr(((-1.24610591900312)+(((-3.11526479750779)*pz))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j30array[0]=IKatan2(((0.00311526479750779)*(x1089.value)*(((((1000.0)*cj27*py))+(((-1000.0)*px*sj27))))), ((-1.24610591900312)+(((-3.11526479750779)*pz))));
sj30array[0]=IKsin(j30array[0]);
cj30array[0]=IKcos(j30array[0]);
if( j30array[0] > IKPI )
{
    j30array[0]-=IK2PI;
}
else if( j30array[0] < -IKPI )
{    j30array[0]+=IK2PI;
}
j30valid[0] = true;
for(int ij30 = 0; ij30 < 1; ++ij30)
{
if( !j30valid[ij30] )
{
    continue;
}
_ij30[0] = ij30; _ij30[1] = -1;
for(int iij30 = ij30+1; iij30 < 1; ++iij30)
{
if( j30valid[iij30] && IKabs(cj30array[ij30]-cj30array[iij30]) < IKFAST_SOLUTION_THRESH && IKabs(sj30array[ij30]-sj30array[iij30]) < IKFAST_SOLUTION_THRESH )
{
    j30valid[iij30]=false; _ij30[1] = iij30; break; 
}
}
j30 = j30array[ij30]; cj30 = cj30array[ij30]; sj30 = sj30array[ij30];
{
IkReal evalcond[5];
IkReal x1090=IKcos(j30);
IkReal x1091=IKsin(j30);
IkReal x1092=((1.0)*py);
IkReal x1093=(cj27*px);
IkReal x1094=(px*sj27);
IkReal x1095=((0.321)*x1091);
evalcond[0]=((0.4)+pz+(((0.321)*x1090)));
evalcond[1]=((0.32)+(((0.2568)*x1090))+(((0.8)*pz)));
evalcond[2]=(x1094+((sj29*x1095))+(((-1.0)*cj27*x1092)));
evalcond[3]=((0.1)+(((-1.0)*x1093))+(((-1.0)*cj29*x1095))+(((-1.0)*sj27*x1092)));
evalcond[4]=(((cj29*py*sj27))+x1095+((cj29*x1093))+((sj29*x1094))+(((-1.0)*cj27*sj29*x1092))+(((-0.1)*cj29)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j28)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j30eval[1];
sj28=-1.0;
cj28=0;
j28=-1.5707963267949;
j30eval[0]=sj29;
if( IKabs(j30eval[0]) < 0.0000010000000000  )
{
{
IkReal j30eval[1];
sj28=-1.0;
cj28=0;
j28=-1.5707963267949;
j30eval[0]=cj29;
if( IKabs(j30eval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j29)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j30array[1], cj30array[1], sj30array[1];
bool j30valid[1]={false};
_nj30 = 1;
if( IKabs(((((3.11526479750779)*cj27*py))+(((-3.11526479750779)*px*sj27)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.24610591900312)+(((3.11526479750779)*pz)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((3.11526479750779)*cj27*py))+(((-3.11526479750779)*px*sj27))))+IKsqr(((-1.24610591900312)+(((3.11526479750779)*pz))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j30array[0]=IKatan2(((((3.11526479750779)*cj27*py))+(((-3.11526479750779)*px*sj27))), ((-1.24610591900312)+(((3.11526479750779)*pz))));
sj30array[0]=IKsin(j30array[0]);
cj30array[0]=IKcos(j30array[0]);
if( j30array[0] > IKPI )
{
    j30array[0]-=IK2PI;
}
else if( j30array[0] < -IKPI )
{    j30array[0]+=IK2PI;
}
j30valid[0] = true;
for(int ij30 = 0; ij30 < 1; ++ij30)
{
if( !j30valid[ij30] )
{
    continue;
}
_ij30[0] = ij30; _ij30[1] = -1;
for(int iij30 = ij30+1; iij30 < 1; ++iij30)
{
if( j30valid[iij30] && IKabs(cj30array[ij30]-cj30array[iij30]) < IKFAST_SOLUTION_THRESH && IKabs(sj30array[ij30]-sj30array[iij30]) < IKFAST_SOLUTION_THRESH )
{
    j30valid[iij30]=false; _ij30[1] = iij30; break; 
}
}
j30 = j30array[ij30]; cj30 = cj30array[ij30]; sj30 = sj30array[ij30];
{
IkReal evalcond[3];
IkReal x1096=IKcos(j30);
evalcond[0]=((-0.4)+(((-0.321)*x1096))+pz);
evalcond[1]=((0.32)+(((0.2568)*x1096))+(((-0.8)*pz)));
evalcond[2]=((((-1.0)*cj27*py))+((px*sj27))+(((0.321)*(IKsin(j30)))));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j29)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j30array[1], cj30array[1], sj30array[1];
bool j30valid[1]={false};
_nj30 = 1;
if( IKabs(((((-3.11526479750779)*cj27*py))+(((3.11526479750779)*px*sj27)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.24610591900312)+(((3.11526479750779)*pz)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-3.11526479750779)*cj27*py))+(((3.11526479750779)*px*sj27))))+IKsqr(((-1.24610591900312)+(((3.11526479750779)*pz))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j30array[0]=IKatan2(((((-3.11526479750779)*cj27*py))+(((3.11526479750779)*px*sj27))), ((-1.24610591900312)+(((3.11526479750779)*pz))));
sj30array[0]=IKsin(j30array[0]);
cj30array[0]=IKcos(j30array[0]);
if( j30array[0] > IKPI )
{
    j30array[0]-=IK2PI;
}
else if( j30array[0] < -IKPI )
{    j30array[0]+=IK2PI;
}
j30valid[0] = true;
for(int ij30 = 0; ij30 < 1; ++ij30)
{
if( !j30valid[ij30] )
{
    continue;
}
_ij30[0] = ij30; _ij30[1] = -1;
for(int iij30 = ij30+1; iij30 < 1; ++iij30)
{
if( j30valid[iij30] && IKabs(cj30array[ij30]-cj30array[iij30]) < IKFAST_SOLUTION_THRESH && IKabs(sj30array[ij30]-sj30array[iij30]) < IKFAST_SOLUTION_THRESH )
{
    j30valid[iij30]=false; _ij30[1] = iij30; break; 
}
}
j30 = j30array[ij30]; cj30 = cj30array[ij30]; sj30 = sj30array[ij30];
{
IkReal evalcond[3];
IkReal x1097=IKcos(j30);
evalcond[0]=((-0.4)+(((-0.321)*x1097))+pz);
evalcond[1]=((0.32)+(((0.2568)*x1097))+(((-0.8)*pz)));
evalcond[2]=((((-1.0)*cj27*py))+(((-0.321)*(IKsin(j30))))+((px*sj27)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j29))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j30array[1], cj30array[1], sj30array[1];
bool j30valid[1]={false};
_nj30 = 1;
if( IKabs(((-0.311526479750779)+(((3.11526479750779)*cj27*px))+(((3.11526479750779)*py*sj27)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.24610591900312)+(((3.11526479750779)*pz)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-0.311526479750779)+(((3.11526479750779)*cj27*px))+(((3.11526479750779)*py*sj27))))+IKsqr(((-1.24610591900312)+(((3.11526479750779)*pz))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j30array[0]=IKatan2(((-0.311526479750779)+(((3.11526479750779)*cj27*px))+(((3.11526479750779)*py*sj27))), ((-1.24610591900312)+(((3.11526479750779)*pz))));
sj30array[0]=IKsin(j30array[0]);
cj30array[0]=IKcos(j30array[0]);
if( j30array[0] > IKPI )
{
    j30array[0]-=IK2PI;
}
else if( j30array[0] < -IKPI )
{    j30array[0]+=IK2PI;
}
j30valid[0] = true;
for(int ij30 = 0; ij30 < 1; ++ij30)
{
if( !j30valid[ij30] )
{
    continue;
}
_ij30[0] = ij30; _ij30[1] = -1;
for(int iij30 = ij30+1; iij30 < 1; ++iij30)
{
if( j30valid[iij30] && IKabs(cj30array[ij30]-cj30array[iij30]) < IKFAST_SOLUTION_THRESH && IKabs(sj30array[ij30]-sj30array[iij30]) < IKFAST_SOLUTION_THRESH )
{
    j30valid[iij30]=false; _ij30[1] = iij30; break; 
}
}
j30 = j30array[ij30]; cj30 = cj30array[ij30]; sj30 = sj30array[ij30];
{
IkReal evalcond[3];
IkReal x1098=IKcos(j30);
evalcond[0]=((-0.4)+(((-0.321)*x1098))+pz);
evalcond[1]=((0.32)+(((0.2568)*x1098))+(((-0.8)*pz)));
evalcond[2]=((0.1)+(((-1.0)*py*sj27))+(((-1.0)*cj27*px))+(((0.321)*(IKsin(j30)))));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j29)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j30array[1], cj30array[1], sj30array[1];
bool j30valid[1]={false};
_nj30 = 1;
if( IKabs(((0.311526479750779)+(((-3.11526479750779)*cj27*px))+(((-3.11526479750779)*py*sj27)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.24610591900312)+(((3.11526479750779)*pz)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((0.311526479750779)+(((-3.11526479750779)*cj27*px))+(((-3.11526479750779)*py*sj27))))+IKsqr(((-1.24610591900312)+(((3.11526479750779)*pz))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j30array[0]=IKatan2(((0.311526479750779)+(((-3.11526479750779)*cj27*px))+(((-3.11526479750779)*py*sj27))), ((-1.24610591900312)+(((3.11526479750779)*pz))));
sj30array[0]=IKsin(j30array[0]);
cj30array[0]=IKcos(j30array[0]);
if( j30array[0] > IKPI )
{
    j30array[0]-=IK2PI;
}
else if( j30array[0] < -IKPI )
{    j30array[0]+=IK2PI;
}
j30valid[0] = true;
for(int ij30 = 0; ij30 < 1; ++ij30)
{
if( !j30valid[ij30] )
{
    continue;
}
_ij30[0] = ij30; _ij30[1] = -1;
for(int iij30 = ij30+1; iij30 < 1; ++iij30)
{
if( j30valid[iij30] && IKabs(cj30array[ij30]-cj30array[iij30]) < IKFAST_SOLUTION_THRESH && IKabs(sj30array[ij30]-sj30array[iij30]) < IKFAST_SOLUTION_THRESH )
{
    j30valid[iij30]=false; _ij30[1] = iij30; break; 
}
}
j30 = j30array[ij30]; cj30 = cj30array[ij30]; sj30 = sj30array[ij30];
{
IkReal evalcond[3];
IkReal x1099=IKcos(j30);
evalcond[0]=((-0.4)+(((-0.321)*x1099))+pz);
evalcond[1]=((0.32)+(((0.2568)*x1099))+(((-0.8)*pz)));
evalcond[2]=((0.1)+(((-1.0)*py*sj27))+(((-1.0)*cj27*px))+(((-0.321)*(IKsin(j30)))));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j30]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}

} else
{
{
IkReal j30array[1], cj30array[1], sj30array[1];
bool j30valid[1]={false};
_nj30 = 1;
CheckValue<IkReal> x1100=IKPowWithIntegerCheck(cj29,-1);
if(!x1100.valid){
continue;
}
if( IKabs(((0.00311526479750779)*(x1100.value)*(((-100.0)+(((1000.0)*cj27*px))+(((1000.0)*py*sj27)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.24610591900312)+(((3.11526479750779)*pz)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((0.00311526479750779)*(x1100.value)*(((-100.0)+(((1000.0)*cj27*px))+(((1000.0)*py*sj27))))))+IKsqr(((-1.24610591900312)+(((3.11526479750779)*pz))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j30array[0]=IKatan2(((0.00311526479750779)*(x1100.value)*(((-100.0)+(((1000.0)*cj27*px))+(((1000.0)*py*sj27))))), ((-1.24610591900312)+(((3.11526479750779)*pz))));
sj30array[0]=IKsin(j30array[0]);
cj30array[0]=IKcos(j30array[0]);
if( j30array[0] > IKPI )
{
    j30array[0]-=IK2PI;
}
else if( j30array[0] < -IKPI )
{    j30array[0]+=IK2PI;
}
j30valid[0] = true;
for(int ij30 = 0; ij30 < 1; ++ij30)
{
if( !j30valid[ij30] )
{
    continue;
}
_ij30[0] = ij30; _ij30[1] = -1;
for(int iij30 = ij30+1; iij30 < 1; ++iij30)
{
if( j30valid[iij30] && IKabs(cj30array[ij30]-cj30array[iij30]) < IKFAST_SOLUTION_THRESH && IKabs(sj30array[ij30]-sj30array[iij30]) < IKFAST_SOLUTION_THRESH )
{
    j30valid[iij30]=false; _ij30[1] = iij30; break; 
}
}
j30 = j30array[ij30]; cj30 = cj30array[ij30]; sj30 = sj30array[ij30];
{
IkReal evalcond[5];
IkReal x1101=IKcos(j30);
IkReal x1102=IKsin(j30);
IkReal x1103=((1.0)*py);
IkReal x1104=(px*sj27);
IkReal x1105=((1.0)*cj27*px);
IkReal x1106=((0.321)*x1102);
evalcond[0]=((-0.4)+(((-0.321)*x1101))+pz);
evalcond[1]=((0.32)+(((-0.8)*pz))+(((0.2568)*x1101)));
evalcond[2]=(x1104+(((-1.0)*cj27*x1103))+((sj29*x1106)));
evalcond[3]=((0.1)+((cj29*x1106))+(((-1.0)*sj27*x1103))+(((-1.0)*x1105)));
evalcond[4]=(x1106+(((-1.0)*cj27*sj29*x1103))+((sj29*x1104))+(((0.1)*cj29))+(((-1.0)*cj29*x1105))+(((-1.0)*cj29*sj27*x1103)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j30array[1], cj30array[1], sj30array[1];
bool j30valid[1]={false};
_nj30 = 1;
CheckValue<IkReal> x1107=IKPowWithIntegerCheck(sj29,-1);
if(!x1107.valid){
continue;
}
if( IKabs(((0.00311526479750779)*(x1107.value)*(((((1000.0)*cj27*py))+(((-1000.0)*px*sj27)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.24610591900312)+(((3.11526479750779)*pz)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((0.00311526479750779)*(x1107.value)*(((((1000.0)*cj27*py))+(((-1000.0)*px*sj27))))))+IKsqr(((-1.24610591900312)+(((3.11526479750779)*pz))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j30array[0]=IKatan2(((0.00311526479750779)*(x1107.value)*(((((1000.0)*cj27*py))+(((-1000.0)*px*sj27))))), ((-1.24610591900312)+(((3.11526479750779)*pz))));
sj30array[0]=IKsin(j30array[0]);
cj30array[0]=IKcos(j30array[0]);
if( j30array[0] > IKPI )
{
    j30array[0]-=IK2PI;
}
else if( j30array[0] < -IKPI )
{    j30array[0]+=IK2PI;
}
j30valid[0] = true;
for(int ij30 = 0; ij30 < 1; ++ij30)
{
if( !j30valid[ij30] )
{
    continue;
}
_ij30[0] = ij30; _ij30[1] = -1;
for(int iij30 = ij30+1; iij30 < 1; ++iij30)
{
if( j30valid[iij30] && IKabs(cj30array[ij30]-cj30array[iij30]) < IKFAST_SOLUTION_THRESH && IKabs(sj30array[ij30]-sj30array[iij30]) < IKFAST_SOLUTION_THRESH )
{
    j30valid[iij30]=false; _ij30[1] = iij30; break; 
}
}
j30 = j30array[ij30]; cj30 = cj30array[ij30]; sj30 = sj30array[ij30];
{
IkReal evalcond[5];
IkReal x1108=IKcos(j30);
IkReal x1109=IKsin(j30);
IkReal x1110=((1.0)*py);
IkReal x1111=(px*sj27);
IkReal x1112=((1.0)*cj27*px);
IkReal x1113=((0.321)*x1109);
evalcond[0]=((-0.4)+(((-0.321)*x1108))+pz);
evalcond[1]=((0.32)+(((-0.8)*pz))+(((0.2568)*x1108)));
evalcond[2]=(x1111+(((-1.0)*cj27*x1110))+((sj29*x1113)));
evalcond[3]=((0.1)+(((-1.0)*sj27*x1110))+(((-1.0)*x1112))+((cj29*x1113)));
evalcond[4]=(x1113+(((-1.0)*cj27*sj29*x1110))+((sj29*x1111))+(((-1.0)*cj29*x1112))+(((0.1)*cj29))+(((-1.0)*cj29*sj27*x1110)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j29)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j30array[1], cj30array[1], sj30array[1];
bool j30valid[1]={false};
_nj30 = 1;
if( IKabs(((((3.11526479750779)*cj27*py))+(((-3.11526479750779)*px*sj27)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-0.98536214953271)+(((3.89408099688474)*pp))+(((-0.778816199376947)*py*sj27))+(((-0.778816199376947)*cj27*px)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((3.11526479750779)*cj27*py))+(((-3.11526479750779)*px*sj27))))+IKsqr(((-0.98536214953271)+(((3.89408099688474)*pp))+(((-0.778816199376947)*py*sj27))+(((-0.778816199376947)*cj27*px))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j30array[0]=IKatan2(((((3.11526479750779)*cj27*py))+(((-3.11526479750779)*px*sj27))), ((-0.98536214953271)+(((3.89408099688474)*pp))+(((-0.778816199376947)*py*sj27))+(((-0.778816199376947)*cj27*px))));
sj30array[0]=IKsin(j30array[0]);
cj30array[0]=IKcos(j30array[0]);
if( j30array[0] > IKPI )
{
    j30array[0]-=IK2PI;
}
else if( j30array[0] < -IKPI )
{    j30array[0]+=IK2PI;
}
j30valid[0] = true;
for(int ij30 = 0; ij30 < 1; ++ij30)
{
if( !j30valid[ij30] )
{
    continue;
}
_ij30[0] = ij30; _ij30[1] = -1;
for(int iij30 = ij30+1; iij30 < 1; ++iij30)
{
if( j30valid[iij30] && IKabs(cj30array[ij30]-cj30array[iij30]) < IKFAST_SOLUTION_THRESH && IKabs(sj30array[ij30]-sj30array[iij30]) < IKFAST_SOLUTION_THRESH )
{
    j30valid[iij30]=false; _ij30[1] = iij30; break; 
}
}
j30 = j30array[ij30]; cj30 = cj30array[ij30]; sj30 = sj30array[ij30];
{
IkReal evalcond[5];
IkReal x1114=IKcos(j30);
IkReal x1115=((1.0)*py);
IkReal x1116=(cj27*px);
IkReal x1117=((0.321)*x1114);
evalcond[0]=((((0.4)*sj28))+((sj28*x1117))+pz);
evalcond[1]=((((-1.0)*cj27*x1115))+((px*sj27))+(((0.321)*(IKsin(j30)))));
evalcond[2]=((0.253041)+(((-1.0)*pp))+(((0.2)*py*sj27))+(((0.2)*x1116))+(((0.2568)*x1114)));
evalcond[3]=((0.1)+((cj28*x1117))+(((-1.0)*sj27*x1115))+(((0.4)*cj28))+(((-1.0)*x1116)));
evalcond[4]=((0.4)+(((-1.0)*cj28*x1116))+(((-1.0)*cj28*sj27*x1115))+x1117+(((0.1)*cj28))+((pz*sj28)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j29)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j30array[1], cj30array[1], sj30array[1];
bool j30valid[1]={false};
_nj30 = 1;
if( IKabs(((((-3.11526479750779)*cj27*py))+(((3.11526479750779)*px*sj27)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-0.98536214953271)+(((3.89408099688474)*pp))+(((-0.778816199376947)*py*sj27))+(((-0.778816199376947)*cj27*px)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-3.11526479750779)*cj27*py))+(((3.11526479750779)*px*sj27))))+IKsqr(((-0.98536214953271)+(((3.89408099688474)*pp))+(((-0.778816199376947)*py*sj27))+(((-0.778816199376947)*cj27*px))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j30array[0]=IKatan2(((((-3.11526479750779)*cj27*py))+(((3.11526479750779)*px*sj27))), ((-0.98536214953271)+(((3.89408099688474)*pp))+(((-0.778816199376947)*py*sj27))+(((-0.778816199376947)*cj27*px))));
sj30array[0]=IKsin(j30array[0]);
cj30array[0]=IKcos(j30array[0]);
if( j30array[0] > IKPI )
{
    j30array[0]-=IK2PI;
}
else if( j30array[0] < -IKPI )
{    j30array[0]+=IK2PI;
}
j30valid[0] = true;
for(int ij30 = 0; ij30 < 1; ++ij30)
{
if( !j30valid[ij30] )
{
    continue;
}
_ij30[0] = ij30; _ij30[1] = -1;
for(int iij30 = ij30+1; iij30 < 1; ++iij30)
{
if( j30valid[iij30] && IKabs(cj30array[ij30]-cj30array[iij30]) < IKFAST_SOLUTION_THRESH && IKabs(sj30array[ij30]-sj30array[iij30]) < IKFAST_SOLUTION_THRESH )
{
    j30valid[iij30]=false; _ij30[1] = iij30; break; 
}
}
j30 = j30array[ij30]; cj30 = cj30array[ij30]; sj30 = sj30array[ij30];
{
IkReal evalcond[5];
IkReal x1118=IKcos(j30);
IkReal x1119=((1.0)*py);
IkReal x1120=(cj27*px);
IkReal x1121=((0.321)*x1118);
evalcond[0]=((((0.4)*sj28))+((sj28*x1121))+pz);
evalcond[1]=((((-1.0)*cj27*x1119))+(((-0.321)*(IKsin(j30))))+((px*sj27)));
evalcond[2]=((0.253041)+(((-1.0)*pp))+(((0.2)*x1120))+(((0.2)*py*sj27))+(((0.2568)*x1118)));
evalcond[3]=((0.1)+(((-1.0)*sj27*x1119))+(((0.4)*cj28))+(((-1.0)*x1120))+((cj28*x1121)));
evalcond[4]=((0.4)+(((-1.0)*cj28*sj27*x1119))+x1121+(((-1.0)*cj28*x1120))+(((0.1)*cj28))+((pz*sj28)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j30]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}
}
}
}

} else
{
{
IkReal j30array[1], cj30array[1], sj30array[1];
bool j30valid[1]={false};
_nj30 = 1;
CheckValue<IkReal> x1127=IKPowWithIntegerCheck(sj29,-1);
if(!x1127.valid){
continue;
}
IkReal x1122=x1127.value;
IkReal x1123=((0.00311526479750779)*x1122);
IkReal x1124=(cj28*cj29);
IkReal x1125=((1000.0)*cj27*py);
IkReal x1126=((1000.0)*px*sj27);
CheckValue<IkReal> x1128=IKPowWithIntegerCheck(sj28,-1);
if(!x1128.valid){
continue;
}
if( IKabs((x1123*((x1125+(((-1.0)*x1126)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs((x1123*(x1128.value)*(((((-400.0)*sj28*sj29))+((x1124*x1126))+(((-1000.0)*pz*sj29))+(((-1.0)*x1124*x1125)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((x1123*((x1125+(((-1.0)*x1126))))))+IKsqr((x1123*(x1128.value)*(((((-400.0)*sj28*sj29))+((x1124*x1126))+(((-1000.0)*pz*sj29))+(((-1.0)*x1124*x1125))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j30array[0]=IKatan2((x1123*((x1125+(((-1.0)*x1126))))), (x1123*(x1128.value)*(((((-400.0)*sj28*sj29))+((x1124*x1126))+(((-1000.0)*pz*sj29))+(((-1.0)*x1124*x1125))))));
sj30array[0]=IKsin(j30array[0]);
cj30array[0]=IKcos(j30array[0]);
if( j30array[0] > IKPI )
{
    j30array[0]-=IK2PI;
}
else if( j30array[0] < -IKPI )
{    j30array[0]+=IK2PI;
}
j30valid[0] = true;
for(int ij30 = 0; ij30 < 1; ++ij30)
{
if( !j30valid[ij30] )
{
    continue;
}
_ij30[0] = ij30; _ij30[1] = -1;
for(int iij30 = ij30+1; iij30 < 1; ++iij30)
{
if( j30valid[iij30] && IKabs(cj30array[ij30]-cj30array[iij30]) < IKFAST_SOLUTION_THRESH && IKabs(sj30array[ij30]-sj30array[iij30]) < IKFAST_SOLUTION_THRESH )
{
    j30valid[iij30]=false; _ij30[1] = iij30; break; 
}
}
j30 = j30array[ij30]; cj30 = cj30array[ij30]; sj30 = sj30array[ij30];
{
IkReal evalcond[6];
IkReal x1129=IKsin(j30);
IkReal x1130=IKcos(j30);
IkReal x1131=((1.0)*py);
IkReal x1132=(cj29*sj28);
IkReal x1133=(cj27*px);
IkReal x1134=(cj28*cj29);
IkReal x1135=(py*sj27);
IkReal x1136=(px*sj27);
IkReal x1137=((0.321)*x1129);
IkReal x1138=((0.321)*x1130);
evalcond[0]=(x1136+((sj29*x1137))+(((-1.0)*cj27*x1131)));
evalcond[1]=((0.253041)+(((-1.0)*pp))+(((0.2)*x1133))+(((0.2)*x1135))+(((0.2568)*x1130)));
evalcond[2]=((((0.4)*sj28))+((sj28*x1138))+((x1134*x1137))+pz);
evalcond[3]=((0.4)+x1138+(((-1.0)*cj28*x1133))+(((0.1)*cj28))+((pz*sj28))+(((-1.0)*cj28*sj27*x1131)));
evalcond[4]=((0.1)+(((0.4)*cj28))+(((-1.0)*x1132*x1137))+(((-1.0)*sj27*x1131))+(((-1.0)*x1133))+((cj28*x1138)));
evalcond[5]=(x1137+((sj29*x1136))+(((-0.1)*x1132))+((pz*x1134))+(((-1.0)*cj27*sj29*x1131))+((x1132*x1135))+((x1132*x1133)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j30array[1], cj30array[1], sj30array[1];
bool j30valid[1]={false};
_nj30 = 1;
IkReal x1139=((250.0)*sj28);
IkReal x1140=(py*sj27);
IkReal x1141=(cj27*px);
CheckValue<IkReal> x1142=IKPowWithIntegerCheck(cj28,-1);
if(!x1142.valid){
continue;
}
CheckValue<IkReal> x1143=IKPowWithIntegerCheck(cj29,-1);
if(!x1143.valid){
continue;
}
if( IKabs(((0.00311526479750779)*(x1142.value)*(x1143.value)*(((((-1000.0)*pz))+(((-83.69875)*sj28))+(((-1250.0)*pp*sj28))+((x1139*x1141))+((x1139*x1140)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-0.98536214953271)+(((3.89408099688474)*pp))+(((-0.778816199376947)*x1140))+(((-0.778816199376947)*x1141)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((0.00311526479750779)*(x1142.value)*(x1143.value)*(((((-1000.0)*pz))+(((-83.69875)*sj28))+(((-1250.0)*pp*sj28))+((x1139*x1141))+((x1139*x1140))))))+IKsqr(((-0.98536214953271)+(((3.89408099688474)*pp))+(((-0.778816199376947)*x1140))+(((-0.778816199376947)*x1141))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j30array[0]=IKatan2(((0.00311526479750779)*(x1142.value)*(x1143.value)*(((((-1000.0)*pz))+(((-83.69875)*sj28))+(((-1250.0)*pp*sj28))+((x1139*x1141))+((x1139*x1140))))), ((-0.98536214953271)+(((3.89408099688474)*pp))+(((-0.778816199376947)*x1140))+(((-0.778816199376947)*x1141))));
sj30array[0]=IKsin(j30array[0]);
cj30array[0]=IKcos(j30array[0]);
if( j30array[0] > IKPI )
{
    j30array[0]-=IK2PI;
}
else if( j30array[0] < -IKPI )
{    j30array[0]+=IK2PI;
}
j30valid[0] = true;
for(int ij30 = 0; ij30 < 1; ++ij30)
{
if( !j30valid[ij30] )
{
    continue;
}
_ij30[0] = ij30; _ij30[1] = -1;
for(int iij30 = ij30+1; iij30 < 1; ++iij30)
{
if( j30valid[iij30] && IKabs(cj30array[ij30]-cj30array[iij30]) < IKFAST_SOLUTION_THRESH && IKabs(sj30array[ij30]-sj30array[iij30]) < IKFAST_SOLUTION_THRESH )
{
    j30valid[iij30]=false; _ij30[1] = iij30; break; 
}
}
j30 = j30array[ij30]; cj30 = cj30array[ij30]; sj30 = sj30array[ij30];
{
IkReal evalcond[6];
IkReal x1144=IKsin(j30);
IkReal x1145=IKcos(j30);
IkReal x1146=((1.0)*py);
IkReal x1147=(cj29*sj28);
IkReal x1148=(cj27*px);
IkReal x1149=(cj28*cj29);
IkReal x1150=(py*sj27);
IkReal x1151=(px*sj27);
IkReal x1152=((0.321)*x1144);
IkReal x1153=((0.321)*x1145);
evalcond[0]=(x1151+((sj29*x1152))+(((-1.0)*cj27*x1146)));
evalcond[1]=((0.253041)+(((0.2)*x1150))+(((-1.0)*pp))+(((0.2)*x1148))+(((0.2568)*x1145)));
evalcond[2]=((((0.4)*sj28))+((x1149*x1152))+((sj28*x1153))+pz);
evalcond[3]=((0.4)+x1153+(((-1.0)*cj28*sj27*x1146))+(((-1.0)*cj28*x1148))+(((0.1)*cj28))+((pz*sj28)));
evalcond[4]=((0.1)+(((0.4)*cj28))+((cj28*x1153))+(((-1.0)*x1148))+(((-1.0)*x1147*x1152))+(((-1.0)*sj27*x1146)));
evalcond[5]=(x1152+((pz*x1149))+((sj29*x1151))+(((-1.0)*cj27*sj29*x1146))+(((-0.1)*x1147))+((x1147*x1150))+((x1147*x1148)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j30array[1], cj30array[1], sj30array[1];
bool j30valid[1]={false};
_nj30 = 1;
CheckValue<IkReal> x1154=IKPowWithIntegerCheck(sj29,-1);
if(!x1154.valid){
continue;
}
if( IKabs(((0.00311526479750779)*(x1154.value)*(((((1000.0)*cj27*py))+(((-1000.0)*px*sj27)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-0.98536214953271)+(((3.89408099688474)*pp))+(((-0.778816199376947)*py*sj27))+(((-0.778816199376947)*cj27*px)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((0.00311526479750779)*(x1154.value)*(((((1000.0)*cj27*py))+(((-1000.0)*px*sj27))))))+IKsqr(((-0.98536214953271)+(((3.89408099688474)*pp))+(((-0.778816199376947)*py*sj27))+(((-0.778816199376947)*cj27*px))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j30array[0]=IKatan2(((0.00311526479750779)*(x1154.value)*(((((1000.0)*cj27*py))+(((-1000.0)*px*sj27))))), ((-0.98536214953271)+(((3.89408099688474)*pp))+(((-0.778816199376947)*py*sj27))+(((-0.778816199376947)*cj27*px))));
sj30array[0]=IKsin(j30array[0]);
cj30array[0]=IKcos(j30array[0]);
if( j30array[0] > IKPI )
{
    j30array[0]-=IK2PI;
}
else if( j30array[0] < -IKPI )
{    j30array[0]+=IK2PI;
}
j30valid[0] = true;
for(int ij30 = 0; ij30 < 1; ++ij30)
{
if( !j30valid[ij30] )
{
    continue;
}
_ij30[0] = ij30; _ij30[1] = -1;
for(int iij30 = ij30+1; iij30 < 1; ++iij30)
{
if( j30valid[iij30] && IKabs(cj30array[ij30]-cj30array[iij30]) < IKFAST_SOLUTION_THRESH && IKabs(sj30array[ij30]-sj30array[iij30]) < IKFAST_SOLUTION_THRESH )
{
    j30valid[iij30]=false; _ij30[1] = iij30; break; 
}
}
j30 = j30array[ij30]; cj30 = cj30array[ij30]; sj30 = sj30array[ij30];
{
IkReal evalcond[6];
IkReal x1155=IKsin(j30);
IkReal x1156=IKcos(j30);
IkReal x1157=((1.0)*py);
IkReal x1158=(cj29*sj28);
IkReal x1159=(cj27*px);
IkReal x1160=(cj28*cj29);
IkReal x1161=(py*sj27);
IkReal x1162=(px*sj27);
IkReal x1163=((0.321)*x1155);
IkReal x1164=((0.321)*x1156);
evalcond[0]=(x1162+(((-1.0)*cj27*x1157))+((sj29*x1163)));
evalcond[1]=((0.253041)+(((0.2)*x1159))+(((0.2568)*x1156))+(((-1.0)*pp))+(((0.2)*x1161)));
evalcond[2]=((((0.4)*sj28))+pz+((x1160*x1163))+((sj28*x1164)));
evalcond[3]=((0.4)+x1164+(((-1.0)*cj28*sj27*x1157))+(((-1.0)*cj28*x1159))+(((0.1)*cj28))+((pz*sj28)));
evalcond[4]=((0.1)+(((-1.0)*sj27*x1157))+(((-1.0)*x1158*x1163))+(((0.4)*cj28))+(((-1.0)*x1159))+((cj28*x1164)));
evalcond[5]=(x1163+((x1158*x1159))+(((-1.0)*cj27*sj29*x1157))+(((-0.1)*x1158))+((pz*x1160))+((x1158*x1161))+((sj29*x1162)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}
}
}

}

}
    }
}
return solutions.GetNumSolutions()>0;
}
inline void rotationfunction0(IkSolutionListBase<IkReal>& solutions) {
for(int rotationiter = 0; rotationiter < 1; ++rotationiter) {
IkReal x204=(sj27*sj29);
IkReal x205=(cj27*sj29);
IkReal x206=(cj28*sj29);
IkReal x207=(cj28*cj30);
IkReal x208=((1.0)*sj30);
IkReal x209=((1.0)*cj29);
IkReal x210=(cj29*x208);
IkReal x211=((1.0)*cj30*sj28);
IkReal x212=((((-1.0)*x207*x209))+((sj28*sj30)));
IkReal x213=((((-1.0)*sj27*x209))+((sj28*x205)));
IkReal x214=(((sj28*x204))+((cj27*cj29)));
IkReal x215=(x207+(((-1.0)*sj28*x210)));
IkReal x216=(cj27*x215);
IkReal x217=((((-1.0)*cj30*sj28*x209))+(((-1.0)*cj28*x208)));
IkReal x218=((((-1.0)*cj28*x210))+(((-1.0)*x211)));
IkReal x219=(cj27*x217);
IkReal x220=(((sj27*x215))+((sj30*x205)));
IkReal x221=(x216+(((-1.0)*sj30*x204)));
IkReal x222=(((sj27*x217))+((cj30*x205)));
IkReal x223=(x219+(((-1.0)*cj30*x204)));
new_r00=(((r10*x222))+((r00*((x219+(((-1.0)*cj30*x204))))))+((r20*x212)));
new_r01=(((r21*x212))+((r01*x223))+((r11*x222)));
new_r02=(((r12*x222))+((r22*x212))+((r02*x223)));
new_r10=(((r20*x206))+((r00*x213))+((r10*x214)));
new_r11=(((r11*x214))+((r21*x206))+((r01*x213)));
new_r12=(((r22*x206))+((r12*x214))+((r02*x213)));
new_r20=(((r00*x221))+((r10*x220))+((r20*x218)));
new_r21=(((r21*x218))+((r01*x221))+((r11*x220)));
new_r22=(((r12*x220))+((r02*(((((-1.0)*x204*x208))+x216))))+((r22*x218)));
{
IkReal j32array[2], cj32array[2], sj32array[2];
bool j32valid[2]={false};
_nj32 = 2;
cj32array[0]=new_r22;
if( cj32array[0] >= -1-IKFAST_SINCOS_THRESH && cj32array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j32valid[0] = j32valid[1] = true;
    j32array[0] = IKacos(cj32array[0]);
    sj32array[0] = IKsin(j32array[0]);
    cj32array[1] = cj32array[0];
    j32array[1] = -j32array[0];
    sj32array[1] = -sj32array[0];
}
else if( isnan(cj32array[0]) )
{
    // probably any value will work
    j32valid[0] = true;
    cj32array[0] = 1; sj32array[0] = 0; j32array[0] = 0;
}
for(int ij32 = 0; ij32 < 2; ++ij32)
{
if( !j32valid[ij32] )
{
    continue;
}
_ij32[0] = ij32; _ij32[1] = -1;
for(int iij32 = ij32+1; iij32 < 2; ++iij32)
{
if( j32valid[iij32] && IKabs(cj32array[ij32]-cj32array[iij32]) < IKFAST_SOLUTION_THRESH && IKabs(sj32array[ij32]-sj32array[iij32]) < IKFAST_SOLUTION_THRESH )
{
    j32valid[iij32]=false; _ij32[1] = iij32; break; 
}
}
j32 = j32array[ij32]; cj32 = cj32array[ij32]; sj32 = sj32array[ij32];

{
IkReal j31eval[3];
j31eval[0]=sj32;
j31eval[1]=IKsign(sj32);
j31eval[2]=((IKabs(new_r12))+(IKabs(new_r02)));
if( IKabs(j31eval[0]) < 0.0000010000000000  || IKabs(j31eval[1]) < 0.0000010000000000  || IKabs(j31eval[2]) < 0.0000010000000000  )
{
{
IkReal j33eval[3];
j33eval[0]=sj32;
j33eval[1]=IKsign(sj32);
j33eval[2]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(j33eval[0]) < 0.0000010000000000  || IKabs(j33eval[1]) < 0.0000010000000000  || IKabs(j33eval[2]) < 0.0000010000000000  )
{
{
IkReal j31eval[2];
j31eval[0]=new_r12;
j31eval[1]=sj32;
if( IKabs(j31eval[0]) < 0.0000010000000000  || IKabs(j31eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j32))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r12;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
IkReal j33mul = 1;
j33=0;
j31mul=-1.0;
if( IKabs(((-1.0)*new_r01)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r00) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r01))+IKsqr(new_r00)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j31=IKatan2(((-1.0)*new_r01), new_r00);
{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].fmul = j31mul;
vinfos[5].freeind = 0;
vinfos[5].maxsolutions = 0;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].fmul = j33mul;
vinfos[7].freeind = 0;
vinfos[7].maxsolutions = 0;
std::vector<int> vfree(1);
vfree[0] = 7;
solutions.AddSolution(vinfos,vfree);
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j32)))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r12;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
IkReal j33mul = 1;
j33=0;
j31mul=1.0;
if( IKabs(((-1.0)*new_r01)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r00)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r01))+IKsqr(((-1.0)*new_r00))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j31=IKatan2(((-1.0)*new_r01), ((-1.0)*new_r00));
{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].fmul = j31mul;
vinfos[5].freeind = 0;
vinfos[5].maxsolutions = 0;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].fmul = j33mul;
vinfos[7].freeind = 0;
vinfos[7].maxsolutions = 0;
std::vector<int> vfree(1);
vfree[0] = 7;
solutions.AddSolution(vinfos,vfree);
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r12))+(IKabs(new_r02)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j31eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
IkReal x224=new_r22*new_r22;
IkReal x225=((16.0)*new_r10);
IkReal x226=((16.0)*new_r01);
IkReal x227=((16.0)*new_r22);
IkReal x228=((8.0)*new_r11);
IkReal x229=((8.0)*new_r00);
IkReal x230=(x224*x225);
IkReal x231=(x224*x226);
j31eval[0]=((IKabs((((new_r11*x227))+(((16.0)*new_r00))+(((-32.0)*new_r00*x224)))))+(IKabs(((((32.0)*new_r11))+(((-16.0)*new_r11*x224))+(((-1.0)*new_r00*x227)))))+(IKabs(((((-1.0)*x231))+x226)))+(IKabs(((((-1.0)*x230))+x225)))+(IKabs((((x224*x228))+(((-1.0)*new_r22*x229)))))+(IKabs((x231+(((-1.0)*x226)))))+(IKabs((x230+(((-1.0)*x225)))))+(IKabs((((new_r22*x228))+(((-1.0)*x229))))));
if( IKabs(j31eval[0]) < 0.0000000100000000  )
{
continue; // no branches [j31, j33]

} else
{
IkReal op[4+1], zeror[4];
int numroots;
IkReal j31evalpoly[1];
IkReal x232=new_r22*new_r22;
IkReal x233=((16.0)*new_r10);
IkReal x234=(new_r11*new_r22);
IkReal x235=(x232*x233);
IkReal x236=((((8.0)*x234))+(((-8.0)*new_r00)));
op[0]=x236;
op[1]=((((-1.0)*x235))+x233);
op[2]=((((16.0)*new_r00))+(((16.0)*x234))+(((-32.0)*new_r00*x232)));
op[3]=((((-1.0)*x233))+x235);
op[4]=x236;
polyroots4(op,zeror,numroots);
IkReal j31array[4], cj31array[4], sj31array[4], tempj31array[1];
int numsolutions = 0;
for(int ij31 = 0; ij31 < numroots; ++ij31)
{
IkReal htj31 = zeror[ij31];
tempj31array[0]=((2.0)*(atan(htj31)));
for(int kj31 = 0; kj31 < 1; ++kj31)
{
j31array[numsolutions] = tempj31array[kj31];
if( j31array[numsolutions] > IKPI )
{
    j31array[numsolutions]-=IK2PI;
}
else if( j31array[numsolutions] < -IKPI )
{
    j31array[numsolutions]+=IK2PI;
}
sj31array[numsolutions] = IKsin(j31array[numsolutions]);
cj31array[numsolutions] = IKcos(j31array[numsolutions]);
numsolutions++;
}
}
bool j31valid[4]={true,true,true,true};
_nj31 = 4;
for(int ij31 = 0; ij31 < numsolutions; ++ij31)
    {
if( !j31valid[ij31] )
{
    continue;
}
    j31 = j31array[ij31]; cj31 = cj31array[ij31]; sj31 = sj31array[ij31];
htj31 = IKtan(j31/2);

IkReal x237=((16.0)*new_r01);
IkReal x238=new_r22*new_r22;
IkReal x239=(new_r00*new_r22);
IkReal x240=((8.0)*x239);
IkReal x241=(new_r11*x238);
IkReal x242=(x237*x238);
IkReal x243=((8.0)*x241);
j31evalpoly[0]=((((htj31*htj31)*(((((32.0)*new_r11))+(((-16.0)*x241))+(((-16.0)*x239))))))+(((htj31*htj31*htj31*htj31)*((x243+(((-1.0)*x240))))))+x243+(((-1.0)*x240))+(((htj31*htj31*htj31)*(((((-1.0)*x237))+x242))))+((htj31*((x237+(((-1.0)*x242)))))));
if( IKabs(j31evalpoly[0]) > 0.0000001000000000  )
{
    continue;
}
_ij31[0] = ij31; _ij31[1] = -1;
for(int iij31 = ij31+1; iij31 < numsolutions; ++iij31)
{
if( j31valid[iij31] && IKabs(cj31array[ij31]-cj31array[iij31]) < IKFAST_SOLUTION_THRESH && IKabs(sj31array[ij31]-sj31array[iij31]) < IKFAST_SOLUTION_THRESH )
{
    j31valid[iij31]=false; _ij31[1] = iij31; break; 
}
}
{
IkReal j33eval[3];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
IkReal x244=cj31*cj31;
IkReal x245=(cj31*new_r22);
IkReal x246=((-1.0)+(((-1.0)*x244*(new_r22*new_r22)))+x244);
j33eval[0]=x246;
j33eval[1]=IKsign(x246);
j33eval[2]=((IKabs(((((-1.0)*new_r00*x245))+((new_r01*sj31)))))+(IKabs((((new_r00*sj31))+((new_r01*x245))))));
if( IKabs(j33eval[0]) < 0.0000010000000000  || IKabs(j33eval[1]) < 0.0000010000000000  || IKabs(j33eval[2]) < 0.0000010000000000  )
{
{
IkReal j33eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
j33eval[0]=new_r22;
if( IKabs(j33eval[0]) < 0.0000010000000000  )
{
{
IkReal j33eval[2];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
IkReal x247=new_r22*new_r22;
j33eval[0]=((((-1.0)*cj31))+((cj31*x247)));
j33eval[1]=(((sj31*x247))+(((-1.0)*sj31)));
if( IKabs(j33eval[0]) < 0.0000010000000000  || IKabs(j33eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j31)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
if( IKabs(((-1.0)*new_r00)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r01)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r00))+IKsqr(((-1.0)*new_r01))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j33array[0]=IKatan2(((-1.0)*new_r00), ((-1.0)*new_r01));
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[4];
IkReal x248=IKsin(j33);
IkReal x249=IKcos(j33);
evalcond[0]=x248;
evalcond[1]=((-1.0)*x249);
evalcond[2]=((((-1.0)*x248))+(((-1.0)*new_r00)));
evalcond[3]=((((-1.0)*x249))+(((-1.0)*new_r01)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j31)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
if( IKabs(new_r00) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r01) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r00)+IKsqr(new_r01)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j33array[0]=IKatan2(new_r00, new_r01);
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[4];
IkReal x250=IKsin(j33);
IkReal x251=IKcos(j33);
evalcond[0]=x250;
evalcond[1]=((-1.0)*x251);
evalcond[2]=(new_r00+(((-1.0)*x250)));
evalcond[3]=(new_r01+(((-1.0)*x251)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j31))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
if( IKabs(new_r10) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r11) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r10)+IKsqr(new_r11)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j33array[0]=IKatan2(new_r10, new_r11);
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[4];
IkReal x252=IKsin(j33);
IkReal x253=IKcos(j33);
evalcond[0]=x252;
evalcond[1]=((-1.0)*x253);
evalcond[2]=(new_r10+(((-1.0)*x252)));
evalcond[3]=(new_r11+(((-1.0)*x253)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j31)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
if( IKabs(((-1.0)*new_r10)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r10))+IKsqr(((-1.0)*new_r11))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j33array[0]=IKatan2(((-1.0)*new_r10), ((-1.0)*new_r11));
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[4];
IkReal x254=IKsin(j33);
IkReal x255=IKcos(j33);
evalcond[0]=x254;
evalcond[1]=((-1.0)*x255);
evalcond[2]=((((-1.0)*new_r10))+(((-1.0)*x254)));
evalcond[3]=((((-1.0)*new_r11))+(((-1.0)*x255)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
CheckValue<IkReal> x256=IKPowWithIntegerCheck(((1.0)+(((-1.0)*(new_r22*new_r22)))),-1);
if(!x256.valid){
continue;
}
if((x256.value) < -0.00001)
continue;
IkReal gconst36=((-1.0)*(IKsqrt(x256.value)));
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.0)+(IKsign(sj31)))))+(IKabs((cj31+(((-1.0)*gconst36)))))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j33eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
if((((1.0)+(((-1.0)*(gconst36*gconst36))))) < -0.00001)
continue;
sj31=IKsqrt(((1.0)+(((-1.0)*(gconst36*gconst36)))));
cj31=gconst36;
if( (gconst36) < -1-IKFAST_SINCOS_THRESH || (gconst36) > 1+IKFAST_SINCOS_THRESH )
    continue;
j31=IKacos(gconst36);
CheckValue<IkReal> x257=IKPowWithIntegerCheck(((1.0)+(((-1.0)*(new_r22*new_r22)))),-1);
if(!x257.valid){
continue;
}
if((x257.value) < -0.00001)
continue;
IkReal gconst36=((-1.0)*(IKsqrt(x257.value)));
j33eval[0]=((IKabs(new_r11))+(IKabs(new_r10)));
if( IKabs(j33eval[0]) < 0.0000010000000000  )
{
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
if((((1.0)+(((-1.0)*(gconst36*gconst36))))) < -0.00001)
continue;
CheckValue<IkReal> x258=IKPowWithIntegerCheck(gconst36,-1);
if(!x258.valid){
continue;
}
if( IKabs((((gconst36*new_r10))+(((-1.0)*new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst36*gconst36)))))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs((new_r11*(x258.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((((gconst36*new_r10))+(((-1.0)*new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst36*gconst36))))))))))+IKsqr((new_r11*(x258.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j33array[0]=IKatan2((((gconst36*new_r10))+(((-1.0)*new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst36*gconst36))))))))), (new_r11*(x258.value)));
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[8];
IkReal x259=IKcos(j33);
IkReal x260=IKsin(j33);
IkReal x261=((1.0)*x259);
IkReal x262=((1.0)*x260);
if((((1.0)+(((-1.0)*(gconst36*gconst36))))) < -0.00001)
continue;
IkReal x263=IKsqrt(((1.0)+(((-1.0)*(gconst36*gconst36)))));
IkReal x264=((1.0)*x263);
evalcond[0]=x260;
evalcond[1]=((-1.0)*x259);
evalcond[2]=((((-1.0)*gconst36*x261))+new_r11);
evalcond[3]=((((-1.0)*gconst36*x262))+new_r10);
evalcond[4]=(((x259*x263))+new_r01);
evalcond[5]=(((x260*x263))+new_r00);
evalcond[6]=((((-1.0)*new_r00*x264))+((gconst36*new_r10))+(((-1.0)*x262)));
evalcond[7]=((((-1.0)*new_r01*x264))+((gconst36*new_r11))+(((-1.0)*x261)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
CheckValue<IkReal> x265 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x265.valid){
continue;
}
CheckValue<IkReal> x266=IKPowWithIntegerCheck(IKsign(gconst36),-1);
if(!x266.valid){
continue;
}
j33array[0]=((-1.5707963267949)+(x265.value)+(((1.5707963267949)*(x266.value))));
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[8];
IkReal x267=IKcos(j33);
IkReal x268=IKsin(j33);
IkReal x269=((1.0)*x267);
IkReal x270=((1.0)*x268);
if((((1.0)+(((-1.0)*(gconst36*gconst36))))) < -0.00001)
continue;
IkReal x271=IKsqrt(((1.0)+(((-1.0)*(gconst36*gconst36)))));
IkReal x272=((1.0)*x271);
evalcond[0]=x268;
evalcond[1]=((-1.0)*x267);
evalcond[2]=((((-1.0)*gconst36*x269))+new_r11);
evalcond[3]=((((-1.0)*gconst36*x270))+new_r10);
evalcond[4]=(new_r01+((x267*x271)));
evalcond[5]=(new_r00+((x268*x271)));
evalcond[6]=((((-1.0)*new_r00*x272))+((gconst36*new_r10))+(((-1.0)*x270)));
evalcond[7]=((((-1.0)*new_r01*x272))+((gconst36*new_r11))+(((-1.0)*x269)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
CheckValue<IkReal> x273=IKPowWithIntegerCheck(((1.0)+(((-1.0)*(new_r22*new_r22)))),-1);
if(!x273.valid){
continue;
}
if((x273.value) < -0.00001)
continue;
IkReal gconst36=((-1.0)*(IKsqrt(x273.value)));
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.0)+(IKsign(sj31)))))+(IKabs((cj31+(((-1.0)*gconst36)))))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j33eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
if((((1.0)+(((-1.0)*(gconst36*gconst36))))) < -0.00001)
continue;
sj31=((-1.0)*(IKsqrt(((1.0)+(((-1.0)*(gconst36*gconst36)))))));
cj31=gconst36;
if( (gconst36) < -1-IKFAST_SINCOS_THRESH || (gconst36) > 1+IKFAST_SINCOS_THRESH )
    continue;
j31=((-1.0)*(IKacos(gconst36)));
CheckValue<IkReal> x274=IKPowWithIntegerCheck(((1.0)+(((-1.0)*(new_r22*new_r22)))),-1);
if(!x274.valid){
continue;
}
if((x274.value) < -0.00001)
continue;
IkReal gconst36=((-1.0)*(IKsqrt(x274.value)));
j33eval[0]=((IKabs(new_r11))+(IKabs(new_r10)));
if( IKabs(j33eval[0]) < 0.0000010000000000  )
{
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
if((((1.0)+(((-1.0)*(gconst36*gconst36))))) < -0.00001)
continue;
CheckValue<IkReal> x275=IKPowWithIntegerCheck(gconst36,-1);
if(!x275.valid){
continue;
}
if( IKabs((((new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst36*gconst36))))))))+((gconst36*new_r10)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((new_r11*(x275.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((((new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst36*gconst36))))))))+((gconst36*new_r10))))+IKsqr((new_r11*(x275.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j33array[0]=IKatan2((((new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst36*gconst36))))))))+((gconst36*new_r10))), (new_r11*(x275.value)));
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[8];
IkReal x276=IKcos(j33);
IkReal x277=IKsin(j33);
IkReal x278=((1.0)*x277);
IkReal x279=((1.0)*x276);
if((((1.0)+(((-1.0)*(gconst36*gconst36))))) < -0.00001)
continue;
IkReal x280=IKsqrt(((1.0)+(((-1.0)*(gconst36*gconst36)))));
evalcond[0]=x277;
evalcond[1]=((-1.0)*x276);
evalcond[2]=((((-1.0)*gconst36*x279))+new_r11);
evalcond[3]=((((-1.0)*gconst36*x278))+new_r10);
evalcond[4]=(new_r01+(((-1.0)*x279*x280)));
evalcond[5]=(new_r00+(((-1.0)*x278*x280)));
evalcond[6]=(((gconst36*new_r10))+(((-1.0)*x278))+((new_r00*x280)));
evalcond[7]=(((gconst36*new_r11))+(((-1.0)*x279))+((new_r01*x280)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
CheckValue<IkReal> x281 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x281.valid){
continue;
}
CheckValue<IkReal> x282=IKPowWithIntegerCheck(IKsign(gconst36),-1);
if(!x282.valid){
continue;
}
j33array[0]=((-1.5707963267949)+(x281.value)+(((1.5707963267949)*(x282.value))));
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[8];
IkReal x283=IKcos(j33);
IkReal x284=IKsin(j33);
IkReal x285=((1.0)*x284);
IkReal x286=((1.0)*x283);
if((((1.0)+(((-1.0)*(gconst36*gconst36))))) < -0.00001)
continue;
IkReal x287=IKsqrt(((1.0)+(((-1.0)*(gconst36*gconst36)))));
evalcond[0]=x284;
evalcond[1]=((-1.0)*x283);
evalcond[2]=((((-1.0)*gconst36*x286))+new_r11);
evalcond[3]=((((-1.0)*gconst36*x285))+new_r10);
evalcond[4]=(new_r01+(((-1.0)*x286*x287)));
evalcond[5]=((((-1.0)*x285*x287))+new_r00);
evalcond[6]=(((gconst36*new_r10))+(((-1.0)*x285))+((new_r00*x287)));
evalcond[7]=(((gconst36*new_r11))+(((-1.0)*x286))+((new_r01*x287)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
CheckValue<IkReal> x288=IKPowWithIntegerCheck(((1.0)+(((-1.0)*(new_r22*new_r22)))),-1);
if(!x288.valid){
continue;
}
if((x288.value) < -0.00001)
continue;
IkReal gconst37=IKsqrt(x288.value);
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.0)+(IKsign(sj31)))))+(IKabs((cj31+(((-1.0)*gconst37)))))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j33eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
if((((1.0)+(((-1.0)*(gconst37*gconst37))))) < -0.00001)
continue;
sj31=IKsqrt(((1.0)+(((-1.0)*(gconst37*gconst37)))));
cj31=gconst37;
if( (gconst37) < -1-IKFAST_SINCOS_THRESH || (gconst37) > 1+IKFAST_SINCOS_THRESH )
    continue;
j31=IKacos(gconst37);
CheckValue<IkReal> x289=IKPowWithIntegerCheck(((1.0)+(((-1.0)*(new_r22*new_r22)))),-1);
if(!x289.valid){
continue;
}
if((x289.value) < -0.00001)
continue;
IkReal gconst37=IKsqrt(x289.value);
j33eval[0]=((IKabs(new_r11))+(IKabs(new_r10)));
if( IKabs(j33eval[0]) < 0.0000010000000000  )
{
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
if((((1.0)+(((-1.0)*(gconst37*gconst37))))) < -0.00001)
continue;
CheckValue<IkReal> x290=IKPowWithIntegerCheck(gconst37,-1);
if(!x290.valid){
continue;
}
if( IKabs(((((-1.0)*new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst37*gconst37))))))))+((gconst37*new_r10)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((new_r11*(x290.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst37*gconst37))))))))+((gconst37*new_r10))))+IKsqr((new_r11*(x290.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j33array[0]=IKatan2(((((-1.0)*new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst37*gconst37))))))))+((gconst37*new_r10))), (new_r11*(x290.value)));
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[8];
IkReal x291=IKcos(j33);
IkReal x292=IKsin(j33);
IkReal x293=((1.0)*x292);
IkReal x294=((1.0)*x291);
if((((1.0)+(((-1.0)*(gconst37*gconst37))))) < -0.00001)
continue;
IkReal x295=IKsqrt(((1.0)+(((-1.0)*(gconst37*gconst37)))));
IkReal x296=((1.0)*x295);
evalcond[0]=x292;
evalcond[1]=((-1.0)*x291);
evalcond[2]=((((-1.0)*gconst37*x294))+new_r11);
evalcond[3]=((((-1.0)*gconst37*x293))+new_r10);
evalcond[4]=(((x291*x295))+new_r01);
evalcond[5]=(new_r00+((x292*x295)));
evalcond[6]=((((-1.0)*x293))+((gconst37*new_r10))+(((-1.0)*new_r00*x296)));
evalcond[7]=((((-1.0)*new_r01*x296))+(((-1.0)*x294))+((gconst37*new_r11)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
CheckValue<IkReal> x297=IKPowWithIntegerCheck(IKsign(gconst37),-1);
if(!x297.valid){
continue;
}
CheckValue<IkReal> x298 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x298.valid){
continue;
}
j33array[0]=((-1.5707963267949)+(((1.5707963267949)*(x297.value)))+(x298.value));
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[8];
IkReal x299=IKcos(j33);
IkReal x300=IKsin(j33);
IkReal x301=((1.0)*x300);
IkReal x302=((1.0)*x299);
if((((1.0)+(((-1.0)*(gconst37*gconst37))))) < -0.00001)
continue;
IkReal x303=IKsqrt(((1.0)+(((-1.0)*(gconst37*gconst37)))));
IkReal x304=((1.0)*x303);
evalcond[0]=x300;
evalcond[1]=((-1.0)*x299);
evalcond[2]=(new_r11+(((-1.0)*gconst37*x302)));
evalcond[3]=(new_r10+(((-1.0)*gconst37*x301)));
evalcond[4]=(((x299*x303))+new_r01);
evalcond[5]=(new_r00+((x300*x303)));
evalcond[6]=(((gconst37*new_r10))+(((-1.0)*new_r00*x304))+(((-1.0)*x301)));
evalcond[7]=((((-1.0)*new_r01*x304))+((gconst37*new_r11))+(((-1.0)*x302)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
CheckValue<IkReal> x305=IKPowWithIntegerCheck(((1.0)+(((-1.0)*(new_r22*new_r22)))),-1);
if(!x305.valid){
continue;
}
if((x305.value) < -0.00001)
continue;
IkReal gconst37=IKsqrt(x305.value);
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.0)+(IKsign(sj31)))))+(IKabs((cj31+(((-1.0)*gconst37)))))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j33eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
if((((1.0)+(((-1.0)*(gconst37*gconst37))))) < -0.00001)
continue;
sj31=((-1.0)*(IKsqrt(((1.0)+(((-1.0)*(gconst37*gconst37)))))));
cj31=gconst37;
if( (gconst37) < -1-IKFAST_SINCOS_THRESH || (gconst37) > 1+IKFAST_SINCOS_THRESH )
    continue;
j31=((-1.0)*(IKacos(gconst37)));
CheckValue<IkReal> x306=IKPowWithIntegerCheck(((1.0)+(((-1.0)*(new_r22*new_r22)))),-1);
if(!x306.valid){
continue;
}
if((x306.value) < -0.00001)
continue;
IkReal gconst37=IKsqrt(x306.value);
j33eval[0]=((IKabs(new_r11))+(IKabs(new_r10)));
if( IKabs(j33eval[0]) < 0.0000010000000000  )
{
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
if((((1.0)+(((-1.0)*(gconst37*gconst37))))) < -0.00001)
continue;
CheckValue<IkReal> x307=IKPowWithIntegerCheck(gconst37,-1);
if(!x307.valid){
continue;
}
if( IKabs((((gconst37*new_r10))+((new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst37*gconst37)))))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs((new_r11*(x307.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((((gconst37*new_r10))+((new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst37*gconst37))))))))))+IKsqr((new_r11*(x307.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j33array[0]=IKatan2((((gconst37*new_r10))+((new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst37*gconst37))))))))), (new_r11*(x307.value)));
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[8];
IkReal x308=IKcos(j33);
IkReal x309=IKsin(j33);
IkReal x310=((1.0)*x309);
IkReal x311=((1.0)*x308);
if((((1.0)+(((-1.0)*(gconst37*gconst37))))) < -0.00001)
continue;
IkReal x312=IKsqrt(((1.0)+(((-1.0)*(gconst37*gconst37)))));
evalcond[0]=x309;
evalcond[1]=((-1.0)*x308);
evalcond[2]=((((-1.0)*gconst37*x311))+new_r11);
evalcond[3]=((((-1.0)*gconst37*x310))+new_r10);
evalcond[4]=(new_r01+(((-1.0)*x311*x312)));
evalcond[5]=((((-1.0)*x310*x312))+new_r00);
evalcond[6]=(((new_r00*x312))+(((-1.0)*x310))+((gconst37*new_r10)));
evalcond[7]=(((new_r01*x312))+(((-1.0)*x311))+((gconst37*new_r11)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
CheckValue<IkReal> x313=IKPowWithIntegerCheck(IKsign(gconst37),-1);
if(!x313.valid){
continue;
}
CheckValue<IkReal> x314 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x314.valid){
continue;
}
j33array[0]=((-1.5707963267949)+(((1.5707963267949)*(x313.value)))+(x314.value));
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[8];
IkReal x315=IKcos(j33);
IkReal x316=IKsin(j33);
IkReal x317=((1.0)*x316);
IkReal x318=((1.0)*x315);
if((((1.0)+(((-1.0)*(gconst37*gconst37))))) < -0.00001)
continue;
IkReal x319=IKsqrt(((1.0)+(((-1.0)*(gconst37*gconst37)))));
evalcond[0]=x316;
evalcond[1]=((-1.0)*x315);
evalcond[2]=((((-1.0)*gconst37*x318))+new_r11);
evalcond[3]=((((-1.0)*gconst37*x317))+new_r10);
evalcond[4]=((((-1.0)*x318*x319))+new_r01);
evalcond[5]=(new_r00+(((-1.0)*x317*x319)));
evalcond[6]=(((new_r00*x319))+(((-1.0)*x317))+((gconst37*new_r10)));
evalcond[7]=(((new_r01*x319))+(((-1.0)*x318))+((gconst37*new_r11)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j33]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}
}
}
}

} else
{
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
IkReal x320=new_r22*new_r22;
CheckValue<IkReal> x321=IKPowWithIntegerCheck(((((-1.0)*cj31))+((cj31*x320))),-1);
if(!x321.valid){
continue;
}
CheckValue<IkReal> x322=IKPowWithIntegerCheck((((sj31*x320))+(((-1.0)*sj31))),-1);
if(!x322.valid){
continue;
}
if( IKabs(((x321.value)*(((((-1.0)*new_r01*new_r22))+(((-1.0)*new_r10)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((x322.value)*((((new_r10*new_r22))+new_r01)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x321.value)*(((((-1.0)*new_r01*new_r22))+(((-1.0)*new_r10))))))+IKsqr(((x322.value)*((((new_r10*new_r22))+new_r01))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j33array[0]=IKatan2(((x321.value)*(((((-1.0)*new_r01*new_r22))+(((-1.0)*new_r10))))), ((x322.value)*((((new_r10*new_r22))+new_r01))));
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[10];
IkReal x323=IKsin(j33);
IkReal x324=IKcos(j33);
IkReal x325=((1.0)*cj31);
IkReal x326=(new_r22*sj31);
IkReal x327=((1.0)*sj31);
IkReal x328=(cj31*new_r00);
IkReal x329=(cj31*new_r01);
IkReal x330=((1.0)*x324);
IkReal x331=(new_r22*x324);
IkReal x332=(new_r22*x323);
evalcond[0]=(((new_r11*sj31))+x332+x329);
evalcond[1]=(((new_r22*x329))+x323+((new_r11*x326)));
evalcond[2]=(((cj31*new_r10))+(((-1.0)*x323))+(((-1.0)*new_r00*x327)));
evalcond[3]=(((cj31*new_r11))+(((-1.0)*new_r01*x327))+(((-1.0)*x330)));
evalcond[4]=(((sj31*x324))+((cj31*x332))+new_r01);
evalcond[5]=((((-1.0)*new_r22*x330))+x328+((new_r10*sj31)));
evalcond[6]=(((sj31*x323))+new_r00+(((-1.0)*x325*x331)));
evalcond[7]=(((x323*x326))+new_r11+(((-1.0)*x324*x325)));
evalcond[8]=(((new_r22*x328))+(((-1.0)*x330))+((new_r10*x326)));
evalcond[9]=((((-1.0)*x323*x325))+new_r10+(((-1.0)*x326*x330)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
IkReal x333=((1.0)*new_r01);
CheckValue<IkReal> x334=IKPowWithIntegerCheck(new_r22,-1);
if(!x334.valid){
continue;
}
if( IKabs(((x334.value)*(((((-1.0)*new_r11*sj31))+(((-1.0)*cj31*x333)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs((((cj31*new_r11))+(((-1.0)*sj31*x333)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x334.value)*(((((-1.0)*new_r11*sj31))+(((-1.0)*cj31*x333))))))+IKsqr((((cj31*new_r11))+(((-1.0)*sj31*x333))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j33array[0]=IKatan2(((x334.value)*(((((-1.0)*new_r11*sj31))+(((-1.0)*cj31*x333))))), (((cj31*new_r11))+(((-1.0)*sj31*x333))));
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[10];
IkReal x335=IKsin(j33);
IkReal x336=IKcos(j33);
IkReal x337=((1.0)*cj31);
IkReal x338=(new_r22*sj31);
IkReal x339=((1.0)*sj31);
IkReal x340=(cj31*new_r00);
IkReal x341=(cj31*new_r01);
IkReal x342=((1.0)*x336);
IkReal x343=(new_r22*x336);
IkReal x344=(new_r22*x335);
evalcond[0]=(((new_r11*sj31))+x341+x344);
evalcond[1]=(((new_r22*x341))+((new_r11*x338))+x335);
evalcond[2]=(((cj31*new_r10))+(((-1.0)*x335))+(((-1.0)*new_r00*x339)));
evalcond[3]=(((cj31*new_r11))+(((-1.0)*x342))+(((-1.0)*new_r01*x339)));
evalcond[4]=(((sj31*x336))+new_r01+((cj31*x344)));
evalcond[5]=(x340+((new_r10*sj31))+(((-1.0)*new_r22*x342)));
evalcond[6]=(((sj31*x335))+(((-1.0)*x337*x343))+new_r00);
evalcond[7]=(((x335*x338))+new_r11+(((-1.0)*x336*x337)));
evalcond[8]=(((new_r22*x340))+((new_r10*x338))+(((-1.0)*x342)));
evalcond[9]=(new_r10+(((-1.0)*x338*x342))+(((-1.0)*x335*x337)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
IkReal x345=cj31*cj31;
IkReal x346=(cj31*new_r22);
CheckValue<IkReal> x347 = IKatan2WithCheck(IkReal((((new_r00*sj31))+((new_r01*x346)))),IkReal((((new_r01*sj31))+(((-1.0)*new_r00*x346)))),IKFAST_ATAN2_MAGTHRESH);
if(!x347.valid){
continue;
}
CheckValue<IkReal> x348=IKPowWithIntegerCheck(IKsign(((-1.0)+(((-1.0)*x345*(new_r22*new_r22)))+x345)),-1);
if(!x348.valid){
continue;
}
j33array[0]=((-1.5707963267949)+(x347.value)+(((1.5707963267949)*(x348.value))));
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[10];
IkReal x349=IKsin(j33);
IkReal x350=IKcos(j33);
IkReal x351=((1.0)*cj31);
IkReal x352=(new_r22*sj31);
IkReal x353=((1.0)*sj31);
IkReal x354=(cj31*new_r00);
IkReal x355=(cj31*new_r01);
IkReal x356=((1.0)*x350);
IkReal x357=(new_r22*x350);
IkReal x358=(new_r22*x349);
evalcond[0]=(((new_r11*sj31))+x355+x358);
evalcond[1]=(((new_r22*x355))+x349+((new_r11*x352)));
evalcond[2]=(((cj31*new_r10))+(((-1.0)*new_r00*x353))+(((-1.0)*x349)));
evalcond[3]=(((cj31*new_r11))+(((-1.0)*x356))+(((-1.0)*new_r01*x353)));
evalcond[4]=(((sj31*x350))+((cj31*x358))+new_r01);
evalcond[5]=((((-1.0)*new_r22*x356))+x354+((new_r10*sj31)));
evalcond[6]=(((sj31*x349))+(((-1.0)*x351*x357))+new_r00);
evalcond[7]=(((x349*x352))+new_r11+(((-1.0)*x350*x351)));
evalcond[8]=(((new_r22*x354))+(((-1.0)*x356))+((new_r10*x352)));
evalcond[9]=((((-1.0)*x349*x351))+new_r10+(((-1.0)*x352*x356)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
    }

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j31, j33]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}

} else
{
{
IkReal j31array[1], cj31array[1], sj31array[1];
bool j31valid[1]={false};
_nj31 = 1;
CheckValue<IkReal> x360=IKPowWithIntegerCheck(sj32,-1);
if(!x360.valid){
continue;
}
IkReal x359=x360.value;
CheckValue<IkReal> x361=IKPowWithIntegerCheck(new_r12,-1);
if(!x361.valid){
continue;
}
if( IKabs((x359*(x361.value)*(((1.0)+(((-1.0)*(new_r02*new_r02)))+(((-1.0)*(cj32*cj32))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs((new_r02*x359)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((x359*(x361.value)*(((1.0)+(((-1.0)*(new_r02*new_r02)))+(((-1.0)*(cj32*cj32)))))))+IKsqr((new_r02*x359))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j31array[0]=IKatan2((x359*(x361.value)*(((1.0)+(((-1.0)*(new_r02*new_r02)))+(((-1.0)*(cj32*cj32)))))), (new_r02*x359));
sj31array[0]=IKsin(j31array[0]);
cj31array[0]=IKcos(j31array[0]);
if( j31array[0] > IKPI )
{
    j31array[0]-=IK2PI;
}
else if( j31array[0] < -IKPI )
{    j31array[0]+=IK2PI;
}
j31valid[0] = true;
for(int ij31 = 0; ij31 < 1; ++ij31)
{
if( !j31valid[ij31] )
{
    continue;
}
_ij31[0] = ij31; _ij31[1] = -1;
for(int iij31 = ij31+1; iij31 < 1; ++iij31)
{
if( j31valid[iij31] && IKabs(cj31array[ij31]-cj31array[iij31]) < IKFAST_SOLUTION_THRESH && IKabs(sj31array[ij31]-sj31array[iij31]) < IKFAST_SOLUTION_THRESH )
{
    j31valid[iij31]=false; _ij31[1] = iij31; break; 
}
}
j31 = j31array[ij31]; cj31 = cj31array[ij31]; sj31 = sj31array[ij31];
{
IkReal evalcond[8];
IkReal x362=IKcos(j31);
IkReal x363=IKsin(j31);
IkReal x364=((1.0)*sj32);
IkReal x365=(new_r02*x362);
IkReal x366=(new_r12*x363);
IkReal x367=(sj32*x362);
IkReal x368=(sj32*x363);
evalcond[0]=((((-1.0)*x362*x364))+new_r02);
evalcond[1]=((((-1.0)*x363*x364))+new_r12);
evalcond[2]=((((-1.0)*new_r02*x363))+((new_r12*x362)));
evalcond[3]=((((-1.0)*x364))+x365+x366);
evalcond[4]=(((new_r00*x367))+((cj32*new_r20))+((new_r10*x368)));
evalcond[5]=(((new_r01*x367))+((cj32*new_r21))+((new_r11*x368)));
evalcond[6]=((-1.0)+((sj32*x365))+((sj32*x366))+((cj32*new_r22)));
evalcond[7]=((((-1.0)*new_r22*x364))+((cj32*x365))+((cj32*x366)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
IkReal j33eval[3];
j33eval[0]=sj32;
j33eval[1]=IKsign(sj32);
j33eval[2]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(j33eval[0]) < 0.0000010000000000  || IKabs(j33eval[1]) < 0.0000010000000000  || IKabs(j33eval[2]) < 0.0000010000000000  )
{
{
IkReal j33eval[2];
j33eval[0]=sj32;
j33eval[1]=sj31;
if( IKabs(j33eval[0]) < 0.0000010000000000  || IKabs(j33eval[1]) < 0.0000010000000000  )
{
{
IkReal j33eval[3];
j33eval[0]=cj32;
j33eval[1]=sj31;
j33eval[2]=sj32;
if( IKabs(j33eval[0]) < 0.0000010000000000  || IKabs(j33eval[1]) < 0.0000010000000000  || IKabs(j33eval[2]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j32)))), 6.28318530717959)));
evalcond[1]=new_r22;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
if( IKabs(new_r21) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r21)+IKsqr(((-1.0)*new_r20))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j33array[0]=IKatan2(new_r21, ((-1.0)*new_r20));
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[8];
IkReal x369=IKcos(j33);
IkReal x370=IKsin(j33);
IkReal x371=((1.0)*sj31);
IkReal x372=((1.0)*x370);
IkReal x373=((1.0)*x369);
evalcond[0]=(x369+new_r20);
evalcond[1]=((((-1.0)*x372))+new_r21);
evalcond[2]=(new_r01+((sj31*x369)));
evalcond[3]=(((sj31*x370))+new_r00);
evalcond[4]=((((-1.0)*cj31*x373))+new_r11);
evalcond[5]=((((-1.0)*cj31*x372))+new_r10);
evalcond[6]=((((-1.0)*new_r00*x371))+((cj31*new_r10))+(((-1.0)*x372)));
evalcond[7]=(((cj31*new_r11))+(((-1.0)*x373))+(((-1.0)*new_r01*x371)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j32)))), 6.28318530717959)));
evalcond[1]=new_r22;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
if( IKabs(((-1.0)*new_r21)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r20) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r21))+IKsqr(new_r20)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j33array[0]=IKatan2(((-1.0)*new_r21), new_r20);
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[8];
IkReal x374=IKcos(j33);
IkReal x375=IKsin(j33);
IkReal x376=((1.0)*sj31);
IkReal x377=((1.0)*x374);
IkReal x378=((1.0)*x375);
evalcond[0]=(x375+new_r21);
evalcond[1]=((((-1.0)*x377))+new_r20);
evalcond[2]=(((sj31*x374))+new_r01);
evalcond[3]=(((sj31*x375))+new_r00);
evalcond[4]=((((-1.0)*cj31*x377))+new_r11);
evalcond[5]=((((-1.0)*cj31*x378))+new_r10);
evalcond[6]=((((-1.0)*new_r00*x376))+((cj31*new_r10))+(((-1.0)*x378)));
evalcond[7]=(((cj31*new_r11))+(((-1.0)*x377))+(((-1.0)*new_r01*x376)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j31))), 6.28318530717959)));
evalcond[1]=new_r12;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
if( IKabs(new_r10) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r11) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r10)+IKsqr(new_r11)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j33array[0]=IKatan2(new_r10, new_r11);
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[8];
IkReal x379=IKcos(j33);
IkReal x380=IKsin(j33);
IkReal x381=((1.0)*sj32);
IkReal x382=((1.0)*x379);
evalcond[0]=(new_r20+((sj32*x379)));
evalcond[1]=((((-1.0)*x380))+new_r10);
evalcond[2]=((((-1.0)*x382))+new_r11);
evalcond[3]=(new_r01+((cj32*x380)));
evalcond[4]=((((-1.0)*x380*x381))+new_r21);
evalcond[5]=((((-1.0)*cj32*x382))+new_r00);
evalcond[6]=(((cj32*new_r01))+x380+(((-1.0)*new_r21*x381)));
evalcond[7]=(((cj32*new_r00))+(((-1.0)*new_r20*x381))+(((-1.0)*x382)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j31)))), 6.28318530717959)));
evalcond[1]=new_r12;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j33eval[3];
sj31=0;
cj31=-1.0;
j31=3.14159265358979;
j33eval[0]=sj32;
j33eval[1]=IKsign(sj32);
j33eval[2]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(j33eval[0]) < 0.0000010000000000  || IKabs(j33eval[1]) < 0.0000010000000000  || IKabs(j33eval[2]) < 0.0000010000000000  )
{
{
IkReal j33eval[1];
sj31=0;
cj31=-1.0;
j31=3.14159265358979;
j33eval[0]=sj32;
if( IKabs(j33eval[0]) < 0.0000010000000000  )
{
{
IkReal j33eval[2];
sj31=0;
cj31=-1.0;
j31=3.14159265358979;
j33eval[0]=cj32;
j33eval[1]=sj32;
if( IKabs(j33eval[0]) < 0.0000010000000000  || IKabs(j33eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[4];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j32)))), 6.28318530717959)));
evalcond[1]=new_r22;
evalcond[2]=new_r01;
evalcond[3]=new_r00;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
if( IKabs(new_r21) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r21)+IKsqr(((-1.0)*new_r20))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j33array[0]=IKatan2(new_r21, ((-1.0)*new_r20));
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[4];
IkReal x383=IKcos(j33);
IkReal x384=((1.0)*(IKsin(j33)));
evalcond[0]=(x383+new_r20);
evalcond[1]=((((-1.0)*x384))+new_r21);
evalcond[2]=((((-1.0)*x384))+(((-1.0)*new_r10)));
evalcond[3]=((((-1.0)*x383))+(((-1.0)*new_r11)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j32)))), 6.28318530717959)));
evalcond[1]=new_r22;
evalcond[2]=new_r01;
evalcond[3]=new_r00;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
if( IKabs(((-1.0)*new_r21)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r20) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r21))+IKsqr(new_r20)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j33array[0]=IKatan2(((-1.0)*new_r21), new_r20);
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[4];
IkReal x385=IKsin(j33);
IkReal x386=((1.0)*(IKcos(j33)));
evalcond[0]=(x385+new_r21);
evalcond[1]=((((-1.0)*x386))+new_r20);
evalcond[2]=((((-1.0)*x385))+(((-1.0)*new_r10)));
evalcond[3]=((((-1.0)*x386))+(((-1.0)*new_r11)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j32))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
if( IKabs(new_r01) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r01)+IKsqr(((-1.0)*new_r11))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j33array[0]=IKatan2(new_r01, ((-1.0)*new_r11));
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[4];
IkReal x387=IKsin(j33);
IkReal x388=((1.0)*(IKcos(j33)));
evalcond[0]=(x387+(((-1.0)*new_r01)));
evalcond[1]=((((-1.0)*x387))+(((-1.0)*new_r10)));
evalcond[2]=((((-1.0)*x388))+(((-1.0)*new_r11)));
evalcond[3]=((((-1.0)*x388))+(((-1.0)*new_r00)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j32)))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
if( IKabs(((-1.0)*new_r10)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r00) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r10))+IKsqr(new_r00)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j33array[0]=IKatan2(((-1.0)*new_r10), new_r00);
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[4];
IkReal x389=IKcos(j33);
IkReal x390=((1.0)*(IKsin(j33)));
evalcond[0]=(x389+(((-1.0)*new_r00)));
evalcond[1]=((((-1.0)*x390))+(((-1.0)*new_r10)));
evalcond[2]=((((-1.0)*x389))+(((-1.0)*new_r11)));
evalcond[3]=((((-1.0)*x390))+(((-1.0)*new_r01)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
if( IKabs(((-1.0)*new_r10)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r10))+IKsqr(((-1.0)*new_r11))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j33array[0]=IKatan2(((-1.0)*new_r10), ((-1.0)*new_r11));
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[6];
IkReal x391=IKsin(j33);
IkReal x392=IKcos(j33);
IkReal x393=((-1.0)*x392);
evalcond[0]=x391;
evalcond[1]=(new_r22*x391);
evalcond[2]=x393;
evalcond[3]=(new_r22*x393);
evalcond[4]=((((-1.0)*x391))+(((-1.0)*new_r10)));
evalcond[5]=((((-1.0)*x392))+(((-1.0)*new_r11)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j33]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}

} else
{
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
CheckValue<IkReal> x394=IKPowWithIntegerCheck(cj32,-1);
if(!x394.valid){
continue;
}
CheckValue<IkReal> x395=IKPowWithIntegerCheck(sj32,-1);
if(!x395.valid){
continue;
}
if( IKabs((new_r01*(x394.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20*(x395.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((new_r01*(x394.value)))+IKsqr(((-1.0)*new_r20*(x395.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j33array[0]=IKatan2((new_r01*(x394.value)), ((-1.0)*new_r20*(x395.value)));
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[8];
IkReal x396=IKsin(j33);
IkReal x397=IKcos(j33);
IkReal x398=((1.0)*new_r00);
IkReal x399=((1.0)*sj32);
IkReal x400=((1.0)*new_r01);
IkReal x401=((1.0)*x397);
evalcond[0]=(((sj32*x397))+new_r20);
evalcond[1]=((((-1.0)*x396*x399))+new_r21);
evalcond[2]=((((-1.0)*x396))+(((-1.0)*new_r10)));
evalcond[3]=((((-1.0)*new_r11))+(((-1.0)*x401)));
evalcond[4]=(((cj32*x396))+(((-1.0)*x400)));
evalcond[5]=((((-1.0)*x398))+(((-1.0)*cj32*x401)));
evalcond[6]=((((-1.0)*new_r21*x399))+x396+(((-1.0)*cj32*x400)));
evalcond[7]=((((-1.0)*cj32*x398))+(((-1.0)*x401))+(((-1.0)*new_r20*x399)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
CheckValue<IkReal> x402=IKPowWithIntegerCheck(sj32,-1);
if(!x402.valid){
continue;
}
if( IKabs((new_r21*(x402.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((new_r21*(x402.value)))+IKsqr(((-1.0)*new_r11))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j33array[0]=IKatan2((new_r21*(x402.value)), ((-1.0)*new_r11));
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[8];
IkReal x403=IKsin(j33);
IkReal x404=IKcos(j33);
IkReal x405=((1.0)*new_r00);
IkReal x406=((1.0)*sj32);
IkReal x407=((1.0)*new_r01);
IkReal x408=((1.0)*x404);
evalcond[0]=(new_r20+((sj32*x404)));
evalcond[1]=((((-1.0)*x403*x406))+new_r21);
evalcond[2]=((((-1.0)*new_r10))+(((-1.0)*x403)));
evalcond[3]=((((-1.0)*new_r11))+(((-1.0)*x408)));
evalcond[4]=(((cj32*x403))+(((-1.0)*x407)));
evalcond[5]=((((-1.0)*cj32*x408))+(((-1.0)*x405)));
evalcond[6]=(x403+(((-1.0)*new_r21*x406))+(((-1.0)*cj32*x407)));
evalcond[7]=((((-1.0)*new_r20*x406))+(((-1.0)*cj32*x405))+(((-1.0)*x408)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
CheckValue<IkReal> x409=IKPowWithIntegerCheck(IKsign(sj32),-1);
if(!x409.valid){
continue;
}
CheckValue<IkReal> x410 = IKatan2WithCheck(IkReal(new_r21),IkReal(((-1.0)*new_r20)),IKFAST_ATAN2_MAGTHRESH);
if(!x410.valid){
continue;
}
j33array[0]=((-1.5707963267949)+(((1.5707963267949)*(x409.value)))+(x410.value));
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[8];
IkReal x411=IKsin(j33);
IkReal x412=IKcos(j33);
IkReal x413=((1.0)*new_r00);
IkReal x414=((1.0)*sj32);
IkReal x415=((1.0)*new_r01);
IkReal x416=((1.0)*x412);
evalcond[0]=(((sj32*x412))+new_r20);
evalcond[1]=((((-1.0)*x411*x414))+new_r21);
evalcond[2]=((((-1.0)*new_r10))+(((-1.0)*x411)));
evalcond[3]=((((-1.0)*new_r11))+(((-1.0)*x416)));
evalcond[4]=(((cj32*x411))+(((-1.0)*x415)));
evalcond[5]=((((-1.0)*cj32*x416))+(((-1.0)*x413)));
evalcond[6]=(x411+(((-1.0)*new_r21*x414))+(((-1.0)*cj32*x415)));
evalcond[7]=((((-1.0)*new_r20*x414))+(((-1.0)*cj32*x413))+(((-1.0)*x416)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j32))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r12;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
IkReal x417=((1.0)*sj31);
if( IKabs(((((-1.0)*cj31*new_r01))+(((-1.0)*new_r00*x417)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((((cj31*new_r00))+(((-1.0)*new_r01*x417)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*cj31*new_r01))+(((-1.0)*new_r00*x417))))+IKsqr((((cj31*new_r00))+(((-1.0)*new_r01*x417))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j33array[0]=IKatan2(((((-1.0)*cj31*new_r01))+(((-1.0)*new_r00*x417))), (((cj31*new_r00))+(((-1.0)*new_r01*x417))));
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[8];
IkReal x418=IKsin(j33);
IkReal x419=IKcos(j33);
IkReal x420=((1.0)*sj31);
IkReal x421=((1.0)*x419);
IkReal x422=(sj31*x418);
IkReal x423=((1.0)*x418);
IkReal x424=(cj31*x421);
evalcond[0]=(((cj31*new_r01))+((new_r11*sj31))+x418);
evalcond[1]=(((sj31*x419))+((cj31*x418))+new_r01);
evalcond[2]=(((cj31*new_r00))+(((-1.0)*x421))+((new_r10*sj31)));
evalcond[3]=(((cj31*new_r10))+(((-1.0)*new_r00*x420))+(((-1.0)*x423)));
evalcond[4]=(((cj31*new_r11))+(((-1.0)*x421))+(((-1.0)*new_r01*x420)));
evalcond[5]=((((-1.0)*x424))+x422+new_r00);
evalcond[6]=((((-1.0)*x424))+x422+new_r11);
evalcond[7]=((((-1.0)*cj31*x423))+(((-1.0)*x419*x420))+new_r10);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j32)))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r12;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
IkReal x425=((1.0)*sj31);
if( IKabs(((((-1.0)*new_r00*x425))+((cj31*new_r01)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((-1.0)*cj31*new_r00))+(((-1.0)*new_r01*x425)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*new_r00*x425))+((cj31*new_r01))))+IKsqr(((((-1.0)*cj31*new_r00))+(((-1.0)*new_r01*x425))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j33array[0]=IKatan2(((((-1.0)*new_r00*x425))+((cj31*new_r01))), ((((-1.0)*cj31*new_r00))+(((-1.0)*new_r01*x425))));
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[8];
IkReal x426=IKsin(j33);
IkReal x427=IKcos(j33);
IkReal x428=((1.0)*sj31);
IkReal x429=((1.0)*x426);
IkReal x430=(sj31*x427);
IkReal x431=((1.0)*x427);
IkReal x432=(cj31*x429);
evalcond[0]=(((cj31*new_r00))+((new_r10*sj31))+x427);
evalcond[1]=(((cj31*new_r01))+(((-1.0)*x429))+((new_r11*sj31)));
evalcond[2]=(((cj31*x427))+((sj31*x426))+new_r00);
evalcond[3]=(((cj31*new_r10))+(((-1.0)*new_r00*x428))+(((-1.0)*x429)));
evalcond[4]=((((-1.0)*x431))+((cj31*new_r11))+(((-1.0)*new_r01*x428)));
evalcond[5]=((((-1.0)*x432))+x430+new_r01);
evalcond[6]=((((-1.0)*x432))+x430+new_r10);
evalcond[7]=((((-1.0)*cj31*x431))+(((-1.0)*x426*x428))+new_r11);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j33eval[1];
new_r21=0;
new_r20=0;
new_r02=0;
new_r12=0;
j33eval[0]=1.0;
if( IKabs(j33eval[0]) < 0.0000000100000000  )
{
continue; // no branches [j33]

} else
{
IkReal op[2+1], zeror[2];
int numroots;
op[0]=1.0;
op[1]=0;
op[2]=-1.0;
polyroots2(op,zeror,numroots);
IkReal j33array[2], cj33array[2], sj33array[2], tempj33array[1];
int numsolutions = 0;
for(int ij33 = 0; ij33 < numroots; ++ij33)
{
IkReal htj33 = zeror[ij33];
tempj33array[0]=((2.0)*(atan(htj33)));
for(int kj33 = 0; kj33 < 1; ++kj33)
{
j33array[numsolutions] = tempj33array[kj33];
if( j33array[numsolutions] > IKPI )
{
    j33array[numsolutions]-=IK2PI;
}
else if( j33array[numsolutions] < -IKPI )
{
    j33array[numsolutions]+=IK2PI;
}
sj33array[numsolutions] = IKsin(j33array[numsolutions]);
cj33array[numsolutions] = IKcos(j33array[numsolutions]);
numsolutions++;
}
}
bool j33valid[2]={true,true};
_nj33 = 2;
for(int ij33 = 0; ij33 < numsolutions; ++ij33)
    {
if( !j33valid[ij33] )
{
    continue;
}
    j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
htj33 = IKtan(j33/2);

_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < numsolutions; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
    }

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j33]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}
}
}

} else
{
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
CheckValue<IkReal> x434=IKPowWithIntegerCheck(sj32,-1);
if(!x434.valid){
continue;
}
IkReal x433=x434.value;
CheckValue<IkReal> x435=IKPowWithIntegerCheck(cj32,-1);
if(!x435.valid){
continue;
}
CheckValue<IkReal> x436=IKPowWithIntegerCheck(sj31,-1);
if(!x436.valid){
continue;
}
if( IKabs((x433*(x435.value)*(x436.value)*(((((-1.0)*new_r11*sj32))+(((-1.0)*cj31*new_r20)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20*x433)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((x433*(x435.value)*(x436.value)*(((((-1.0)*new_r11*sj32))+(((-1.0)*cj31*new_r20))))))+IKsqr(((-1.0)*new_r20*x433))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j33array[0]=IKatan2((x433*(x435.value)*(x436.value)*(((((-1.0)*new_r11*sj32))+(((-1.0)*cj31*new_r20))))), ((-1.0)*new_r20*x433));
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[12];
IkReal x437=IKsin(j33);
IkReal x438=IKcos(j33);
IkReal x439=(cj31*cj32);
IkReal x440=((1.0)*sj31);
IkReal x441=(new_r11*sj31);
IkReal x442=(new_r10*sj31);
IkReal x443=((1.0)*sj32);
IkReal x444=((1.0)*x438);
IkReal x445=((1.0)*x437);
IkReal x446=(sj31*x437);
evalcond[0]=(((sj32*x438))+new_r20);
evalcond[1]=((((-1.0)*x437*x443))+new_r21);
evalcond[2]=(((cj31*new_r01))+((cj32*x437))+x441);
evalcond[3]=((((-1.0)*x445))+(((-1.0)*new_r00*x440))+((cj31*new_r10)));
evalcond[4]=((((-1.0)*x444))+((cj31*new_r11))+(((-1.0)*new_r01*x440)));
evalcond[5]=(((sj31*x438))+new_r01+((x437*x439)));
evalcond[6]=(((cj31*new_r00))+x442+(((-1.0)*cj32*x444)));
evalcond[7]=((((-1.0)*x439*x444))+x446+new_r00);
evalcond[8]=(((cj32*x446))+(((-1.0)*cj31*x444))+new_r11);
evalcond[9]=((((-1.0)*cj32*x438*x440))+(((-1.0)*cj31*x445))+new_r10);
evalcond[10]=(((new_r01*x439))+((cj32*x441))+x437+(((-1.0)*new_r21*x443)));
evalcond[11]=((((-1.0)*x444))+((new_r00*x439))+((cj32*x442))+(((-1.0)*new_r20*x443)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
CheckValue<IkReal> x448=IKPowWithIntegerCheck(sj32,-1);
if(!x448.valid){
continue;
}
IkReal x447=x448.value;
CheckValue<IkReal> x449=IKPowWithIntegerCheck(sj31,-1);
if(!x449.valid){
continue;
}
if( IKabs((new_r21*x447)) < IKFAST_ATAN2_MAGTHRESH && IKabs((x447*(x449.value)*(((((-1.0)*cj31*cj32*new_r21))+(((-1.0)*new_r01*sj32)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((new_r21*x447))+IKsqr((x447*(x449.value)*(((((-1.0)*cj31*cj32*new_r21))+(((-1.0)*new_r01*sj32))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j33array[0]=IKatan2((new_r21*x447), (x447*(x449.value)*(((((-1.0)*cj31*cj32*new_r21))+(((-1.0)*new_r01*sj32))))));
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[12];
IkReal x450=IKsin(j33);
IkReal x451=IKcos(j33);
IkReal x452=(cj31*cj32);
IkReal x453=((1.0)*sj31);
IkReal x454=(new_r11*sj31);
IkReal x455=(new_r10*sj31);
IkReal x456=((1.0)*sj32);
IkReal x457=((1.0)*x451);
IkReal x458=((1.0)*x450);
IkReal x459=(sj31*x450);
evalcond[0]=(((sj32*x451))+new_r20);
evalcond[1]=((((-1.0)*x450*x456))+new_r21);
evalcond[2]=(((cj31*new_r01))+x454+((cj32*x450)));
evalcond[3]=(((cj31*new_r10))+(((-1.0)*new_r00*x453))+(((-1.0)*x458)));
evalcond[4]=(((cj31*new_r11))+(((-1.0)*new_r01*x453))+(((-1.0)*x457)));
evalcond[5]=(((x450*x452))+new_r01+((sj31*x451)));
evalcond[6]=((((-1.0)*cj32*x457))+((cj31*new_r00))+x455);
evalcond[7]=(x459+(((-1.0)*x452*x457))+new_r00);
evalcond[8]=(new_r11+((cj32*x459))+(((-1.0)*cj31*x457)));
evalcond[9]=((((-1.0)*cj32*x451*x453))+new_r10+(((-1.0)*cj31*x458)));
evalcond[10]=((((-1.0)*new_r21*x456))+((new_r01*x452))+x450+((cj32*x454)));
evalcond[11]=((((-1.0)*new_r20*x456))+((new_r00*x452))+(((-1.0)*x457))+((cj32*x455)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
CheckValue<IkReal> x460=IKPowWithIntegerCheck(IKsign(sj32),-1);
if(!x460.valid){
continue;
}
CheckValue<IkReal> x461 = IKatan2WithCheck(IkReal(new_r21),IkReal(((-1.0)*new_r20)),IKFAST_ATAN2_MAGTHRESH);
if(!x461.valid){
continue;
}
j33array[0]=((-1.5707963267949)+(((1.5707963267949)*(x460.value)))+(x461.value));
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[12];
IkReal x462=IKsin(j33);
IkReal x463=IKcos(j33);
IkReal x464=(cj31*cj32);
IkReal x465=((1.0)*sj31);
IkReal x466=(new_r11*sj31);
IkReal x467=(new_r10*sj31);
IkReal x468=((1.0)*sj32);
IkReal x469=((1.0)*x463);
IkReal x470=((1.0)*x462);
IkReal x471=(sj31*x462);
evalcond[0]=(((sj32*x463))+new_r20);
evalcond[1]=((((-1.0)*x462*x468))+new_r21);
evalcond[2]=(((cj31*new_r01))+x466+((cj32*x462)));
evalcond[3]=(((cj31*new_r10))+(((-1.0)*x470))+(((-1.0)*new_r00*x465)));
evalcond[4]=(((cj31*new_r11))+(((-1.0)*new_r01*x465))+(((-1.0)*x469)));
evalcond[5]=(((sj31*x463))+new_r01+((x462*x464)));
evalcond[6]=(((cj31*new_r00))+(((-1.0)*cj32*x469))+x467);
evalcond[7]=((((-1.0)*x464*x469))+x471+new_r00);
evalcond[8]=(((cj32*x471))+new_r11+(((-1.0)*cj31*x469)));
evalcond[9]=((((-1.0)*cj32*x463*x465))+(((-1.0)*cj31*x470))+new_r10);
evalcond[10]=((((-1.0)*new_r21*x468))+((new_r01*x464))+x462+((cj32*x466)));
evalcond[11]=(((new_r00*x464))+(((-1.0)*new_r20*x468))+(((-1.0)*x469))+((cj32*x467)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
CheckValue<IkReal> x472=IKPowWithIntegerCheck(IKsign(sj32),-1);
if(!x472.valid){
continue;
}
CheckValue<IkReal> x473 = IKatan2WithCheck(IkReal(new_r21),IkReal(((-1.0)*new_r20)),IKFAST_ATAN2_MAGTHRESH);
if(!x473.valid){
continue;
}
j33array[0]=((-1.5707963267949)+(((1.5707963267949)*(x472.value)))+(x473.value));
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[2];
evalcond[0]=(((sj32*(IKcos(j33))))+new_r20);
evalcond[1]=((((-1.0)*sj32*(IKsin(j33))))+new_r21);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
IkReal j31eval[3];
j31eval[0]=sj32;
j31eval[1]=IKsign(sj32);
j31eval[2]=((IKabs(new_r12))+(IKabs(new_r02)));
if( IKabs(j31eval[0]) < 0.0000010000000000  || IKabs(j31eval[1]) < 0.0000010000000000  || IKabs(j31eval[2]) < 0.0000010000000000  )
{
{
IkReal j31eval[2];
j31eval[0]=cj33;
j31eval[1]=sj32;
if( IKabs(j31eval[0]) < 0.0000010000000000  || IKabs(j31eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j33)))), 6.28318530717959)));
evalcond[1]=new_r20;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j31array[1], cj31array[1], sj31array[1];
bool j31valid[1]={false};
_nj31 = 1;
if( IKabs(((-1.0)*new_r00)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r10) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r00))+IKsqr(new_r10)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j31array[0]=IKatan2(((-1.0)*new_r00), new_r10);
sj31array[0]=IKsin(j31array[0]);
cj31array[0]=IKcos(j31array[0]);
if( j31array[0] > IKPI )
{
    j31array[0]-=IK2PI;
}
else if( j31array[0] < -IKPI )
{    j31array[0]+=IK2PI;
}
j31valid[0] = true;
for(int ij31 = 0; ij31 < 1; ++ij31)
{
if( !j31valid[ij31] )
{
    continue;
}
_ij31[0] = ij31; _ij31[1] = -1;
for(int iij31 = ij31+1; iij31 < 1; ++iij31)
{
if( j31valid[iij31] && IKabs(cj31array[ij31]-cj31array[iij31]) < IKFAST_SOLUTION_THRESH && IKabs(sj31array[ij31]-sj31array[iij31]) < IKFAST_SOLUTION_THRESH )
{
    j31valid[iij31]=false; _ij31[1] = iij31; break; 
}
}
j31 = j31array[ij31]; cj31 = cj31array[ij31]; sj31 = sj31array[ij31];
{
IkReal evalcond[18];
IkReal x474=IKsin(j31);
IkReal x475=IKcos(j31);
IkReal x476=((1.0)*new_r21);
IkReal x477=(new_r21*x474);
IkReal x478=(new_r22*x474);
IkReal x479=(new_r00*x475);
IkReal x480=(new_r02*x475);
IkReal x481=((1.0)*x474);
IkReal x482=(new_r01*x475);
IkReal x483=((1.0)*x475);
evalcond[0]=(x474+new_r00);
evalcond[1]=(((new_r22*x475))+new_r01);
evalcond[2]=(x478+new_r11);
evalcond[3]=((((-1.0)*x483))+new_r10);
evalcond[4]=((((-1.0)*x475*x476))+new_r02);
evalcond[5]=(new_r12+(((-1.0)*x474*x476)));
evalcond[6]=(((new_r10*x474))+x479);
evalcond[7]=(((new_r12*x475))+(((-1.0)*new_r02*x481)));
evalcond[8]=((((-1.0)*new_r01*x481))+((new_r11*x475)));
evalcond[9]=(((new_r11*x474))+x482+new_r22);
evalcond[10]=((-1.0)+(((-1.0)*new_r00*x481))+((new_r10*x475)));
evalcond[11]=(((new_r10*x477))+((new_r21*x479)));
evalcond[12]=(((new_r10*x478))+((new_r22*x479)));
evalcond[13]=(((new_r12*x474))+(((-1.0)*x476))+x480);
evalcond[14]=(((new_r11*x477))+((new_r21*x482))+((new_r21*new_r22)));
evalcond[15]=((-1.0)+(new_r22*new_r22)+((new_r12*x477))+((new_r21*x480)));
evalcond[16]=(((new_r12*x478))+(((-1.0)*new_r22*x476))+((new_r22*x480)));
evalcond[17]=((1.0)+(((-1.0)*new_r21*x476))+((new_r11*x478))+((new_r22*x482)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[12]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[13]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[14]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[15]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[16]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[17]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j33)))), 6.28318530717959)));
evalcond[1]=new_r20;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j31array[1], cj31array[1], sj31array[1];
bool j31valid[1]={false};
_nj31 = 1;
if( IKabs(new_r00) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r10)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r00)+IKsqr(((-1.0)*new_r10))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j31array[0]=IKatan2(new_r00, ((-1.0)*new_r10));
sj31array[0]=IKsin(j31array[0]);
cj31array[0]=IKcos(j31array[0]);
if( j31array[0] > IKPI )
{
    j31array[0]-=IK2PI;
}
else if( j31array[0] < -IKPI )
{    j31array[0]+=IK2PI;
}
j31valid[0] = true;
for(int ij31 = 0; ij31 < 1; ++ij31)
{
if( !j31valid[ij31] )
{
    continue;
}
_ij31[0] = ij31; _ij31[1] = -1;
for(int iij31 = ij31+1; iij31 < 1; ++iij31)
{
if( j31valid[iij31] && IKabs(cj31array[ij31]-cj31array[iij31]) < IKFAST_SOLUTION_THRESH && IKabs(sj31array[ij31]-sj31array[iij31]) < IKFAST_SOLUTION_THRESH )
{
    j31valid[iij31]=false; _ij31[1] = iij31; break; 
}
}
j31 = j31array[ij31]; cj31 = cj31array[ij31]; sj31 = sj31array[ij31];
{
IkReal evalcond[18];
IkReal x484=IKcos(j31);
IkReal x485=IKsin(j31);
IkReal x486=(new_r21*new_r22);
IkReal x487=((1.0)*x484);
IkReal x488=((1.0)*x485);
IkReal x489=(new_r22*x485);
IkReal x490=(new_r22*x484);
evalcond[0]=(x484+new_r10);
evalcond[1]=(((new_r21*x484))+new_r02);
evalcond[2]=(((new_r21*x485))+new_r12);
evalcond[3]=((((-1.0)*x488))+new_r00);
evalcond[4]=(new_r01+(((-1.0)*new_r22*x487)));
evalcond[5]=(new_r11+(((-1.0)*new_r22*x488)));
evalcond[6]=(((new_r10*x485))+((new_r00*x484)));
evalcond[7]=(((new_r12*x484))+(((-1.0)*new_r02*x488)));
evalcond[8]=(((new_r02*x484))+((new_r12*x485))+new_r21);
evalcond[9]=((((-1.0)*new_r01*x488))+((new_r11*x484)));
evalcond[10]=((1.0)+(((-1.0)*new_r00*x488))+((new_r10*x484)));
evalcond[11]=(((new_r10*x489))+((new_r00*x490)));
evalcond[12]=(((new_r11*x485))+(((-1.0)*new_r22))+((new_r01*x484)));
evalcond[13]=((((-1.0)*new_r10*new_r21*x488))+(((-1.0)*new_r00*new_r21*x487)));
evalcond[14]=(((new_r02*x490))+((new_r12*x489))+x486);
evalcond[15]=((-1.0)+((new_r11*x489))+(new_r21*new_r21)+((new_r01*x490)));
evalcond[16]=((((-1.0)*new_r01*new_r21*x487))+x486+(((-1.0)*new_r11*new_r21*x488)));
evalcond[17]=((-1.0)+(new_r22*new_r22)+(((-1.0)*new_r12*new_r21*x488))+(((-1.0)*new_r02*new_r21*x487)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[12]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[13]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[14]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[15]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[16]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[17]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j32))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r12;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j31array[1], cj31array[1], sj31array[1];
bool j31valid[1]={false};
_nj31 = 1;
IkReal x491=((1.0)*new_r01);
if( IKabs(((((-1.0)*new_r00*sj33))+(((-1.0)*cj33*x491)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((((cj33*new_r00))+(((-1.0)*sj33*x491)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*new_r00*sj33))+(((-1.0)*cj33*x491))))+IKsqr((((cj33*new_r00))+(((-1.0)*sj33*x491))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j31array[0]=IKatan2(((((-1.0)*new_r00*sj33))+(((-1.0)*cj33*x491))), (((cj33*new_r00))+(((-1.0)*sj33*x491))));
sj31array[0]=IKsin(j31array[0]);
cj31array[0]=IKcos(j31array[0]);
if( j31array[0] > IKPI )
{
    j31array[0]-=IK2PI;
}
else if( j31array[0] < -IKPI )
{    j31array[0]+=IK2PI;
}
j31valid[0] = true;
for(int ij31 = 0; ij31 < 1; ++ij31)
{
if( !j31valid[ij31] )
{
    continue;
}
_ij31[0] = ij31; _ij31[1] = -1;
for(int iij31 = ij31+1; iij31 < 1; ++iij31)
{
if( j31valid[iij31] && IKabs(cj31array[ij31]-cj31array[iij31]) < IKFAST_SOLUTION_THRESH && IKabs(sj31array[ij31]-sj31array[iij31]) < IKFAST_SOLUTION_THRESH )
{
    j31valid[iij31]=false; _ij31[1] = iij31; break; 
}
}
j31 = j31array[ij31]; cj31 = cj31array[ij31]; sj31 = sj31array[ij31];
{
IkReal evalcond[8];
IkReal x492=IKsin(j31);
IkReal x493=IKcos(j31);
IkReal x494=((1.0)*cj33);
IkReal x495=((1.0)*sj33);
IkReal x496=(sj33*x492);
IkReal x497=((1.0)*x492);
IkReal x498=(x493*x494);
evalcond[0]=(((new_r11*x492))+sj33+((new_r01*x493)));
evalcond[1]=(((sj33*x493))+((cj33*x492))+new_r01);
evalcond[2]=((((-1.0)*x498))+x496+new_r00);
evalcond[3]=((((-1.0)*x498))+x496+new_r11);
evalcond[4]=((((-1.0)*x494))+((new_r10*x492))+((new_r00*x493)));
evalcond[5]=((((-1.0)*x493*x495))+new_r10+(((-1.0)*x492*x494)));
evalcond[6]=((((-1.0)*new_r00*x497))+(((-1.0)*x495))+((new_r10*x493)));
evalcond[7]=((((-1.0)*x494))+(((-1.0)*new_r01*x497))+((new_r11*x493)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j32)))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r12;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j31array[1], cj31array[1], sj31array[1];
bool j31valid[1]={false};
_nj31 = 1;
IkReal x499=((1.0)*cj33);
if( IKabs(((((-1.0)*new_r01*x499))+(((-1.0)*new_r00*sj33)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((-1.0)*new_r00*x499))+((new_r01*sj33)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*new_r01*x499))+(((-1.0)*new_r00*sj33))))+IKsqr(((((-1.0)*new_r00*x499))+((new_r01*sj33))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j31array[0]=IKatan2(((((-1.0)*new_r01*x499))+(((-1.0)*new_r00*sj33))), ((((-1.0)*new_r00*x499))+((new_r01*sj33))));
sj31array[0]=IKsin(j31array[0]);
cj31array[0]=IKcos(j31array[0]);
if( j31array[0] > IKPI )
{
    j31array[0]-=IK2PI;
}
else if( j31array[0] < -IKPI )
{    j31array[0]+=IK2PI;
}
j31valid[0] = true;
for(int ij31 = 0; ij31 < 1; ++ij31)
{
if( !j31valid[ij31] )
{
    continue;
}
_ij31[0] = ij31; _ij31[1] = -1;
for(int iij31 = ij31+1; iij31 < 1; ++iij31)
{
if( j31valid[iij31] && IKabs(cj31array[ij31]-cj31array[iij31]) < IKFAST_SOLUTION_THRESH && IKabs(sj31array[ij31]-sj31array[iij31]) < IKFAST_SOLUTION_THRESH )
{
    j31valid[iij31]=false; _ij31[1] = iij31; break; 
}
}
j31 = j31array[ij31]; cj31 = cj31array[ij31]; sj31 = sj31array[ij31];
{
IkReal evalcond[8];
IkReal x500=IKcos(j31);
IkReal x501=IKsin(j31);
IkReal x502=((1.0)*sj33);
IkReal x503=(cj33*x501);
IkReal x504=(cj33*x500);
IkReal x505=((1.0)*x501);
IkReal x506=(x500*x502);
evalcond[0]=(cj33+((new_r10*x501))+((new_r00*x500)));
evalcond[1]=(((sj33*x501))+x504+new_r00);
evalcond[2]=((((-1.0)*x506))+x503+new_r01);
evalcond[3]=((((-1.0)*x506))+x503+new_r10);
evalcond[4]=((((-1.0)*x502))+((new_r11*x501))+((new_r01*x500)));
evalcond[5]=((((-1.0)*x501*x502))+new_r11+(((-1.0)*x504)));
evalcond[6]=((((-1.0)*new_r00*x505))+(((-1.0)*x502))+((new_r10*x500)));
evalcond[7]=((((-1.0)*new_r01*x505))+(((-1.0)*cj33))+((new_r11*x500)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r12))+(IKabs(new_r02)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j31eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
j31eval[0]=((IKabs(new_r11))+(IKabs(new_r01)));
if( IKabs(j31eval[0]) < 0.0000010000000000  )
{
{
IkReal j31eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
j31eval[0]=((IKabs(new_r10))+(IKabs(new_r00)));
if( IKabs(j31eval[0]) < 0.0000010000000000  )
{
{
IkReal j31eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
j31eval[0]=((IKabs((new_r11*new_r22)))+(IKabs((new_r01*new_r22))));
if( IKabs(j31eval[0]) < 0.0000010000000000  )
{
continue; // no branches [j31]

} else
{
{
IkReal j31array[2], cj31array[2], sj31array[2];
bool j31valid[2]={false};
_nj31 = 2;
CheckValue<IkReal> x508 = IKatan2WithCheck(IkReal((new_r01*new_r22)),IkReal((new_r11*new_r22)),IKFAST_ATAN2_MAGTHRESH);
if(!x508.valid){
continue;
}
IkReal x507=x508.value;
j31array[0]=((-1.0)*x507);
sj31array[0]=IKsin(j31array[0]);
cj31array[0]=IKcos(j31array[0]);
j31array[1]=((3.14159265358979)+(((-1.0)*x507)));
sj31array[1]=IKsin(j31array[1]);
cj31array[1]=IKcos(j31array[1]);
if( j31array[0] > IKPI )
{
    j31array[0]-=IK2PI;
}
else if( j31array[0] < -IKPI )
{    j31array[0]+=IK2PI;
}
j31valid[0] = true;
if( j31array[1] > IKPI )
{
    j31array[1]-=IK2PI;
}
else if( j31array[1] < -IKPI )
{    j31array[1]+=IK2PI;
}
j31valid[1] = true;
for(int ij31 = 0; ij31 < 2; ++ij31)
{
if( !j31valid[ij31] )
{
    continue;
}
_ij31[0] = ij31; _ij31[1] = -1;
for(int iij31 = ij31+1; iij31 < 2; ++iij31)
{
if( j31valid[iij31] && IKabs(cj31array[ij31]-cj31array[iij31]) < IKFAST_SOLUTION_THRESH && IKabs(sj31array[ij31]-sj31array[iij31]) < IKFAST_SOLUTION_THRESH )
{
    j31valid[iij31]=false; _ij31[1] = iij31; break; 
}
}
j31 = j31array[ij31]; cj31 = cj31array[ij31]; sj31 = sj31array[ij31];
{
IkReal evalcond[5];
IkReal x509=IKsin(j31);
IkReal x510=IKcos(j31);
IkReal x511=(new_r00*x510);
IkReal x512=(new_r10*x509);
IkReal x513=((1.0)*x509);
evalcond[0]=(((new_r01*x510))+((new_r11*x509)));
evalcond[1]=(x512+x511);
evalcond[2]=(((new_r10*x510))+(((-1.0)*new_r00*x513)));
evalcond[3]=(((new_r11*x510))+(((-1.0)*new_r01*x513)));
evalcond[4]=(((new_r22*x511))+((new_r22*x512)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j31array[2], cj31array[2], sj31array[2];
bool j31valid[2]={false};
_nj31 = 2;
CheckValue<IkReal> x515 = IKatan2WithCheck(IkReal(new_r00),IkReal(new_r10),IKFAST_ATAN2_MAGTHRESH);
if(!x515.valid){
continue;
}
IkReal x514=x515.value;
j31array[0]=((-1.0)*x514);
sj31array[0]=IKsin(j31array[0]);
cj31array[0]=IKcos(j31array[0]);
j31array[1]=((3.14159265358979)+(((-1.0)*x514)));
sj31array[1]=IKsin(j31array[1]);
cj31array[1]=IKcos(j31array[1]);
if( j31array[0] > IKPI )
{
    j31array[0]-=IK2PI;
}
else if( j31array[0] < -IKPI )
{    j31array[0]+=IK2PI;
}
j31valid[0] = true;
if( j31array[1] > IKPI )
{
    j31array[1]-=IK2PI;
}
else if( j31array[1] < -IKPI )
{    j31array[1]+=IK2PI;
}
j31valid[1] = true;
for(int ij31 = 0; ij31 < 2; ++ij31)
{
if( !j31valid[ij31] )
{
    continue;
}
_ij31[0] = ij31; _ij31[1] = -1;
for(int iij31 = ij31+1; iij31 < 2; ++iij31)
{
if( j31valid[iij31] && IKabs(cj31array[ij31]-cj31array[iij31]) < IKFAST_SOLUTION_THRESH && IKabs(sj31array[ij31]-sj31array[iij31]) < IKFAST_SOLUTION_THRESH )
{
    j31valid[iij31]=false; _ij31[1] = iij31; break; 
}
}
j31 = j31array[ij31]; cj31 = cj31array[ij31]; sj31 = sj31array[ij31];
{
IkReal evalcond[5];
IkReal x516=IKcos(j31);
IkReal x517=IKsin(j31);
IkReal x518=(new_r22*x517);
IkReal x519=(new_r01*x516);
IkReal x520=((1.0)*x517);
evalcond[0]=(((new_r11*x517))+x519);
evalcond[1]=(((new_r10*x516))+(((-1.0)*new_r00*x520)));
evalcond[2]=(((new_r11*x516))+(((-1.0)*new_r01*x520)));
evalcond[3]=(((new_r11*x518))+((new_r22*x519)));
evalcond[4]=(((new_r10*x518))+((new_r00*new_r22*x516)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j31array[2], cj31array[2], sj31array[2];
bool j31valid[2]={false};
_nj31 = 2;
CheckValue<IkReal> x522 = IKatan2WithCheck(IkReal(new_r01),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x522.valid){
continue;
}
IkReal x521=x522.value;
j31array[0]=((-1.0)*x521);
sj31array[0]=IKsin(j31array[0]);
cj31array[0]=IKcos(j31array[0]);
j31array[1]=((3.14159265358979)+(((-1.0)*x521)));
sj31array[1]=IKsin(j31array[1]);
cj31array[1]=IKcos(j31array[1]);
if( j31array[0] > IKPI )
{
    j31array[0]-=IK2PI;
}
else if( j31array[0] < -IKPI )
{    j31array[0]+=IK2PI;
}
j31valid[0] = true;
if( j31array[1] > IKPI )
{
    j31array[1]-=IK2PI;
}
else if( j31array[1] < -IKPI )
{    j31array[1]+=IK2PI;
}
j31valid[1] = true;
for(int ij31 = 0; ij31 < 2; ++ij31)
{
if( !j31valid[ij31] )
{
    continue;
}
_ij31[0] = ij31; _ij31[1] = -1;
for(int iij31 = ij31+1; iij31 < 2; ++iij31)
{
if( j31valid[iij31] && IKabs(cj31array[ij31]-cj31array[iij31]) < IKFAST_SOLUTION_THRESH && IKabs(sj31array[ij31]-sj31array[iij31]) < IKFAST_SOLUTION_THRESH )
{
    j31valid[iij31]=false; _ij31[1] = iij31; break; 
}
}
j31 = j31array[ij31]; cj31 = cj31array[ij31]; sj31 = sj31array[ij31];
{
IkReal evalcond[5];
IkReal x523=IKcos(j31);
IkReal x524=IKsin(j31);
IkReal x525=(new_r22*x524);
IkReal x526=(new_r22*x523);
IkReal x527=((1.0)*x524);
evalcond[0]=(((new_r10*x524))+((new_r00*x523)));
evalcond[1]=((((-1.0)*new_r00*x527))+((new_r10*x523)));
evalcond[2]=(((new_r11*x523))+(((-1.0)*new_r01*x527)));
evalcond[3]=(((new_r01*x526))+((new_r11*x525)));
evalcond[4]=(((new_r10*x525))+((new_r00*x526)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j31]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}

} else
{
{
IkReal j31array[1], cj31array[1], sj31array[1];
bool j31valid[1]={false};
_nj31 = 1;
CheckValue<IkReal> x529=IKPowWithIntegerCheck(sj32,-1);
if(!x529.valid){
continue;
}
IkReal x528=x529.value;
CheckValue<IkReal> x530=IKPowWithIntegerCheck(cj33,-1);
if(!x530.valid){
continue;
}
if( IKabs((x528*(x530.value)*(((((-1.0)*cj32*new_r02*sj33))+(((-1.0)*new_r01*sj32)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs((new_r02*x528)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((x528*(x530.value)*(((((-1.0)*cj32*new_r02*sj33))+(((-1.0)*new_r01*sj32))))))+IKsqr((new_r02*x528))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j31array[0]=IKatan2((x528*(x530.value)*(((((-1.0)*cj32*new_r02*sj33))+(((-1.0)*new_r01*sj32))))), (new_r02*x528));
sj31array[0]=IKsin(j31array[0]);
cj31array[0]=IKcos(j31array[0]);
if( j31array[0] > IKPI )
{
    j31array[0]-=IK2PI;
}
else if( j31array[0] < -IKPI )
{    j31array[0]+=IK2PI;
}
j31valid[0] = true;
for(int ij31 = 0; ij31 < 1; ++ij31)
{
if( !j31valid[ij31] )
{
    continue;
}
_ij31[0] = ij31; _ij31[1] = -1;
for(int iij31 = ij31+1; iij31 < 1; ++iij31)
{
if( j31valid[iij31] && IKabs(cj31array[ij31]-cj31array[iij31]) < IKFAST_SOLUTION_THRESH && IKabs(sj31array[ij31]-sj31array[iij31]) < IKFAST_SOLUTION_THRESH )
{
    j31valid[iij31]=false; _ij31[1] = iij31; break; 
}
}
j31 = j31array[ij31]; cj31 = cj31array[ij31]; sj31 = sj31array[ij31];
{
IkReal evalcond[18];
IkReal x531=IKcos(j31);
IkReal x532=IKsin(j31);
IkReal x533=((1.0)*cj33);
IkReal x534=((1.0)*sj33);
IkReal x535=(cj32*sj33);
IkReal x536=((1.0)*sj32);
IkReal x537=(new_r10*x532);
IkReal x538=(cj32*x531);
IkReal x539=(sj32*x531);
IkReal x540=(new_r11*x532);
IkReal x541=(new_r12*x532);
IkReal x542=((1.0)*x532);
evalcond[0]=((((-1.0)*x531*x536))+new_r02);
evalcond[1]=((((-1.0)*x532*x536))+new_r12);
evalcond[2]=(((new_r12*x531))+(((-1.0)*new_r02*x542)));
evalcond[3]=(((cj33*x532))+((x531*x535))+new_r01);
evalcond[4]=(((new_r02*x531))+(((-1.0)*x536))+x541);
evalcond[5]=(((new_r01*x531))+x540+x535);
evalcond[6]=(((sj33*x532))+(((-1.0)*x533*x538))+new_r00);
evalcond[7]=((((-1.0)*x531*x533))+new_r11+((x532*x535)));
evalcond[8]=((((-1.0)*new_r00*x542))+(((-1.0)*x534))+((new_r10*x531)));
evalcond[9]=(((new_r11*x531))+(((-1.0)*x533))+(((-1.0)*new_r01*x542)));
evalcond[10]=((((-1.0)*cj32*x533))+x537+((new_r00*x531)));
evalcond[11]=((((-1.0)*x531*x534))+(((-1.0)*cj32*x532*x533))+new_r10);
evalcond[12]=(((sj32*x537))+((cj32*new_r20))+((new_r00*x539)));
evalcond[13]=(((new_r01*x539))+((sj32*x540))+((cj32*new_r21)));
evalcond[14]=((-1.0)+((new_r02*x539))+((sj32*x541))+((cj32*new_r22)));
evalcond[15]=(((new_r02*x538))+(((-1.0)*new_r22*x536))+((cj32*x541)));
evalcond[16]=(((new_r01*x538))+((cj32*x540))+(((-1.0)*new_r21*x536))+sj33);
evalcond[17]=(((cj32*x537))+(((-1.0)*x533))+(((-1.0)*new_r20*x536))+((new_r00*x538)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[12]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[13]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[14]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[15]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[16]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[17]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j31array[1], cj31array[1], sj31array[1];
bool j31valid[1]={false};
_nj31 = 1;
CheckValue<IkReal> x543=IKPowWithIntegerCheck(IKsign(sj32),-1);
if(!x543.valid){
continue;
}
CheckValue<IkReal> x544 = IKatan2WithCheck(IkReal(new_r12),IkReal(new_r02),IKFAST_ATAN2_MAGTHRESH);
if(!x544.valid){
continue;
}
j31array[0]=((-1.5707963267949)+(((1.5707963267949)*(x543.value)))+(x544.value));
sj31array[0]=IKsin(j31array[0]);
cj31array[0]=IKcos(j31array[0]);
if( j31array[0] > IKPI )
{
    j31array[0]-=IK2PI;
}
else if( j31array[0] < -IKPI )
{    j31array[0]+=IK2PI;
}
j31valid[0] = true;
for(int ij31 = 0; ij31 < 1; ++ij31)
{
if( !j31valid[ij31] )
{
    continue;
}
_ij31[0] = ij31; _ij31[1] = -1;
for(int iij31 = ij31+1; iij31 < 1; ++iij31)
{
if( j31valid[iij31] && IKabs(cj31array[ij31]-cj31array[iij31]) < IKFAST_SOLUTION_THRESH && IKabs(sj31array[ij31]-sj31array[iij31]) < IKFAST_SOLUTION_THRESH )
{
    j31valid[iij31]=false; _ij31[1] = iij31; break; 
}
}
j31 = j31array[ij31]; cj31 = cj31array[ij31]; sj31 = sj31array[ij31];
{
IkReal evalcond[18];
IkReal x545=IKcos(j31);
IkReal x546=IKsin(j31);
IkReal x547=((1.0)*cj33);
IkReal x548=((1.0)*sj33);
IkReal x549=(cj32*sj33);
IkReal x550=((1.0)*sj32);
IkReal x551=(new_r10*x546);
IkReal x552=(cj32*x545);
IkReal x553=(sj32*x545);
IkReal x554=(new_r11*x546);
IkReal x555=(new_r12*x546);
IkReal x556=((1.0)*x546);
evalcond[0]=((((-1.0)*x545*x550))+new_r02);
evalcond[1]=(new_r12+(((-1.0)*x546*x550)));
evalcond[2]=(((new_r12*x545))+(((-1.0)*new_r02*x556)));
evalcond[3]=(((cj33*x546))+new_r01+((x545*x549)));
evalcond[4]=(((new_r02*x545))+(((-1.0)*x550))+x555);
evalcond[5]=(x554+x549+((new_r01*x545)));
evalcond[6]=(((sj33*x546))+(((-1.0)*x547*x552))+new_r00);
evalcond[7]=((((-1.0)*x545*x547))+new_r11+((x546*x549)));
evalcond[8]=(((new_r10*x545))+(((-1.0)*x548))+(((-1.0)*new_r00*x556)));
evalcond[9]=((((-1.0)*new_r01*x556))+((new_r11*x545))+(((-1.0)*x547)));
evalcond[10]=(((new_r00*x545))+(((-1.0)*cj32*x547))+x551);
evalcond[11]=((((-1.0)*x545*x548))+(((-1.0)*cj32*x546*x547))+new_r10);
evalcond[12]=(((sj32*x551))+((cj32*new_r20))+((new_r00*x553)));
evalcond[13]=(((sj32*x554))+((cj32*new_r21))+((new_r01*x553)));
evalcond[14]=((-1.0)+((sj32*x555))+((new_r02*x553))+((cj32*new_r22)));
evalcond[15]=(((new_r02*x552))+(((-1.0)*new_r22*x550))+((cj32*x555)));
evalcond[16]=(((cj32*x554))+(((-1.0)*new_r21*x550))+sj33+((new_r01*x552)));
evalcond[17]=(((cj32*x551))+(((-1.0)*x547))+(((-1.0)*new_r20*x550))+((new_r00*x552)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[12]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[13]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[14]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[15]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[16]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[17]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j31array[1], cj31array[1], sj31array[1];
bool j31valid[1]={false};
_nj31 = 1;
CheckValue<IkReal> x557=IKPowWithIntegerCheck(IKsign(sj32),-1);
if(!x557.valid){
continue;
}
CheckValue<IkReal> x558 = IKatan2WithCheck(IkReal(new_r12),IkReal(new_r02),IKFAST_ATAN2_MAGTHRESH);
if(!x558.valid){
continue;
}
j31array[0]=((-1.5707963267949)+(((1.5707963267949)*(x557.value)))+(x558.value));
sj31array[0]=IKsin(j31array[0]);
cj31array[0]=IKcos(j31array[0]);
if( j31array[0] > IKPI )
{
    j31array[0]-=IK2PI;
}
else if( j31array[0] < -IKPI )
{    j31array[0]+=IK2PI;
}
j31valid[0] = true;
for(int ij31 = 0; ij31 < 1; ++ij31)
{
if( !j31valid[ij31] )
{
    continue;
}
_ij31[0] = ij31; _ij31[1] = -1;
for(int iij31 = ij31+1; iij31 < 1; ++iij31)
{
if( j31valid[iij31] && IKabs(cj31array[ij31]-cj31array[iij31]) < IKFAST_SOLUTION_THRESH && IKabs(sj31array[ij31]-sj31array[iij31]) < IKFAST_SOLUTION_THRESH )
{
    j31valid[iij31]=false; _ij31[1] = iij31; break; 
}
}
j31 = j31array[ij31]; cj31 = cj31array[ij31]; sj31 = sj31array[ij31];
{
IkReal evalcond[8];
IkReal x559=IKcos(j31);
IkReal x560=IKsin(j31);
IkReal x561=((1.0)*sj32);
IkReal x562=(new_r02*x559);
IkReal x563=(new_r12*x560);
IkReal x564=(sj32*x559);
IkReal x565=(sj32*x560);
evalcond[0]=((((-1.0)*x559*x561))+new_r02);
evalcond[1]=((((-1.0)*x560*x561))+new_r12);
evalcond[2]=((((-1.0)*new_r02*x560))+((new_r12*x559)));
evalcond[3]=(x562+x563+(((-1.0)*x561)));
evalcond[4]=(((new_r00*x564))+((cj32*new_r20))+((new_r10*x565)));
evalcond[5]=(((new_r01*x564))+((cj32*new_r21))+((new_r11*x565)));
evalcond[6]=((-1.0)+((sj32*x562))+((sj32*x563))+((cj32*new_r22)));
evalcond[7]=((((-1.0)*new_r22*x561))+((cj32*x563))+((cj32*x562)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
IkReal j33eval[3];
j33eval[0]=sj32;
j33eval[1]=IKsign(sj32);
j33eval[2]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(j33eval[0]) < 0.0000010000000000  || IKabs(j33eval[1]) < 0.0000010000000000  || IKabs(j33eval[2]) < 0.0000010000000000  )
{
{
IkReal j33eval[2];
j33eval[0]=sj32;
j33eval[1]=sj31;
if( IKabs(j33eval[0]) < 0.0000010000000000  || IKabs(j33eval[1]) < 0.0000010000000000  )
{
{
IkReal j33eval[3];
j33eval[0]=cj32;
j33eval[1]=sj31;
j33eval[2]=sj32;
if( IKabs(j33eval[0]) < 0.0000010000000000  || IKabs(j33eval[1]) < 0.0000010000000000  || IKabs(j33eval[2]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j32)))), 6.28318530717959)));
evalcond[1]=new_r22;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
if( IKabs(new_r21) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r21)+IKsqr(((-1.0)*new_r20))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j33array[0]=IKatan2(new_r21, ((-1.0)*new_r20));
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[8];
IkReal x566=IKcos(j33);
IkReal x567=IKsin(j33);
IkReal x568=((1.0)*sj31);
IkReal x569=((1.0)*x567);
IkReal x570=((1.0)*x566);
evalcond[0]=(x566+new_r20);
evalcond[1]=(new_r21+(((-1.0)*x569)));
evalcond[2]=(((sj31*x566))+new_r01);
evalcond[3]=(((sj31*x567))+new_r00);
evalcond[4]=(new_r11+(((-1.0)*cj31*x570)));
evalcond[5]=((((-1.0)*cj31*x569))+new_r10);
evalcond[6]=((((-1.0)*new_r00*x568))+((cj31*new_r10))+(((-1.0)*x569)));
evalcond[7]=(((cj31*new_r11))+(((-1.0)*x570))+(((-1.0)*new_r01*x568)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j32)))), 6.28318530717959)));
evalcond[1]=new_r22;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
if( IKabs(((-1.0)*new_r21)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r20) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r21))+IKsqr(new_r20)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j33array[0]=IKatan2(((-1.0)*new_r21), new_r20);
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[8];
IkReal x571=IKcos(j33);
IkReal x572=IKsin(j33);
IkReal x573=((1.0)*sj31);
IkReal x574=((1.0)*x571);
IkReal x575=((1.0)*x572);
evalcond[0]=(x572+new_r21);
evalcond[1]=((((-1.0)*x574))+new_r20);
evalcond[2]=(new_r01+((sj31*x571)));
evalcond[3]=(new_r00+((sj31*x572)));
evalcond[4]=(new_r11+(((-1.0)*cj31*x574)));
evalcond[5]=(new_r10+(((-1.0)*cj31*x575)));
evalcond[6]=(((cj31*new_r10))+(((-1.0)*x575))+(((-1.0)*new_r00*x573)));
evalcond[7]=(((cj31*new_r11))+(((-1.0)*x574))+(((-1.0)*new_r01*x573)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j31))), 6.28318530717959)));
evalcond[1]=new_r12;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
if( IKabs(new_r10) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r11) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r10)+IKsqr(new_r11)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j33array[0]=IKatan2(new_r10, new_r11);
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[8];
IkReal x576=IKcos(j33);
IkReal x577=IKsin(j33);
IkReal x578=((1.0)*sj32);
IkReal x579=((1.0)*x576);
evalcond[0]=(((sj32*x576))+new_r20);
evalcond[1]=((((-1.0)*x577))+new_r10);
evalcond[2]=((((-1.0)*x579))+new_r11);
evalcond[3]=(((cj32*x577))+new_r01);
evalcond[4]=((((-1.0)*x577*x578))+new_r21);
evalcond[5]=((((-1.0)*cj32*x579))+new_r00);
evalcond[6]=(((cj32*new_r01))+x577+(((-1.0)*new_r21*x578)));
evalcond[7]=(((cj32*new_r00))+(((-1.0)*x579))+(((-1.0)*new_r20*x578)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j31)))), 6.28318530717959)));
evalcond[1]=new_r12;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j33eval[3];
sj31=0;
cj31=-1.0;
j31=3.14159265358979;
j33eval[0]=sj32;
j33eval[1]=IKsign(sj32);
j33eval[2]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(j33eval[0]) < 0.0000010000000000  || IKabs(j33eval[1]) < 0.0000010000000000  || IKabs(j33eval[2]) < 0.0000010000000000  )
{
{
IkReal j33eval[1];
sj31=0;
cj31=-1.0;
j31=3.14159265358979;
j33eval[0]=sj32;
if( IKabs(j33eval[0]) < 0.0000010000000000  )
{
{
IkReal j33eval[2];
sj31=0;
cj31=-1.0;
j31=3.14159265358979;
j33eval[0]=cj32;
j33eval[1]=sj32;
if( IKabs(j33eval[0]) < 0.0000010000000000  || IKabs(j33eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[4];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j32)))), 6.28318530717959)));
evalcond[1]=new_r22;
evalcond[2]=new_r01;
evalcond[3]=new_r00;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
if( IKabs(new_r21) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r21)+IKsqr(((-1.0)*new_r20))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j33array[0]=IKatan2(new_r21, ((-1.0)*new_r20));
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[4];
IkReal x580=IKcos(j33);
IkReal x581=((1.0)*(IKsin(j33)));
evalcond[0]=(x580+new_r20);
evalcond[1]=(new_r21+(((-1.0)*x581)));
evalcond[2]=((((-1.0)*new_r10))+(((-1.0)*x581)));
evalcond[3]=((((-1.0)*x580))+(((-1.0)*new_r11)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j32)))), 6.28318530717959)));
evalcond[1]=new_r22;
evalcond[2]=new_r01;
evalcond[3]=new_r00;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
if( IKabs(((-1.0)*new_r21)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r20) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r21))+IKsqr(new_r20)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j33array[0]=IKatan2(((-1.0)*new_r21), new_r20);
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[4];
IkReal x582=IKsin(j33);
IkReal x583=((1.0)*(IKcos(j33)));
evalcond[0]=(x582+new_r21);
evalcond[1]=(new_r20+(((-1.0)*x583)));
evalcond[2]=((((-1.0)*x582))+(((-1.0)*new_r10)));
evalcond[3]=((((-1.0)*new_r11))+(((-1.0)*x583)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j32))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
if( IKabs(new_r01) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r01)+IKsqr(((-1.0)*new_r11))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j33array[0]=IKatan2(new_r01, ((-1.0)*new_r11));
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[4];
IkReal x584=IKsin(j33);
IkReal x585=((1.0)*(IKcos(j33)));
evalcond[0]=(x584+(((-1.0)*new_r01)));
evalcond[1]=((((-1.0)*x584))+(((-1.0)*new_r10)));
evalcond[2]=((((-1.0)*new_r11))+(((-1.0)*x585)));
evalcond[3]=((((-1.0)*new_r00))+(((-1.0)*x585)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j32)))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
if( IKabs(((-1.0)*new_r10)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r00) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r10))+IKsqr(new_r00)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j33array[0]=IKatan2(((-1.0)*new_r10), new_r00);
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[4];
IkReal x586=IKcos(j33);
IkReal x587=((1.0)*(IKsin(j33)));
evalcond[0]=(x586+(((-1.0)*new_r00)));
evalcond[1]=((((-1.0)*new_r10))+(((-1.0)*x587)));
evalcond[2]=((((-1.0)*x586))+(((-1.0)*new_r11)));
evalcond[3]=((((-1.0)*new_r01))+(((-1.0)*x587)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
if( IKabs(((-1.0)*new_r10)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r10))+IKsqr(((-1.0)*new_r11))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j33array[0]=IKatan2(((-1.0)*new_r10), ((-1.0)*new_r11));
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[6];
IkReal x588=IKsin(j33);
IkReal x589=IKcos(j33);
IkReal x590=((-1.0)*x589);
evalcond[0]=x588;
evalcond[1]=(new_r22*x588);
evalcond[2]=x590;
evalcond[3]=(new_r22*x590);
evalcond[4]=((((-1.0)*x588))+(((-1.0)*new_r10)));
evalcond[5]=((((-1.0)*x589))+(((-1.0)*new_r11)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j33]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}

} else
{
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
CheckValue<IkReal> x591=IKPowWithIntegerCheck(cj32,-1);
if(!x591.valid){
continue;
}
CheckValue<IkReal> x592=IKPowWithIntegerCheck(sj32,-1);
if(!x592.valid){
continue;
}
if( IKabs((new_r01*(x591.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20*(x592.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((new_r01*(x591.value)))+IKsqr(((-1.0)*new_r20*(x592.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j33array[0]=IKatan2((new_r01*(x591.value)), ((-1.0)*new_r20*(x592.value)));
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[8];
IkReal x593=IKsin(j33);
IkReal x594=IKcos(j33);
IkReal x595=((1.0)*new_r00);
IkReal x596=((1.0)*sj32);
IkReal x597=((1.0)*new_r01);
IkReal x598=((1.0)*x594);
evalcond[0]=(((sj32*x594))+new_r20);
evalcond[1]=((((-1.0)*x593*x596))+new_r21);
evalcond[2]=((((-1.0)*x593))+(((-1.0)*new_r10)));
evalcond[3]=((((-1.0)*x598))+(((-1.0)*new_r11)));
evalcond[4]=(((cj32*x593))+(((-1.0)*x597)));
evalcond[5]=((((-1.0)*cj32*x598))+(((-1.0)*x595)));
evalcond[6]=((((-1.0)*new_r21*x596))+(((-1.0)*cj32*x597))+x593);
evalcond[7]=((((-1.0)*new_r20*x596))+(((-1.0)*cj32*x595))+(((-1.0)*x598)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
CheckValue<IkReal> x599=IKPowWithIntegerCheck(sj32,-1);
if(!x599.valid){
continue;
}
if( IKabs((new_r21*(x599.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((new_r21*(x599.value)))+IKsqr(((-1.0)*new_r11))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j33array[0]=IKatan2((new_r21*(x599.value)), ((-1.0)*new_r11));
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[8];
IkReal x600=IKsin(j33);
IkReal x601=IKcos(j33);
IkReal x602=((1.0)*new_r00);
IkReal x603=((1.0)*sj32);
IkReal x604=((1.0)*new_r01);
IkReal x605=((1.0)*x601);
evalcond[0]=(((sj32*x601))+new_r20);
evalcond[1]=((((-1.0)*x600*x603))+new_r21);
evalcond[2]=((((-1.0)*x600))+(((-1.0)*new_r10)));
evalcond[3]=((((-1.0)*new_r11))+(((-1.0)*x605)));
evalcond[4]=(((cj32*x600))+(((-1.0)*x604)));
evalcond[5]=((((-1.0)*cj32*x605))+(((-1.0)*x602)));
evalcond[6]=((((-1.0)*cj32*x604))+x600+(((-1.0)*new_r21*x603)));
evalcond[7]=((((-1.0)*new_r20*x603))+(((-1.0)*cj32*x602))+(((-1.0)*x605)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
CheckValue<IkReal> x606=IKPowWithIntegerCheck(IKsign(sj32),-1);
if(!x606.valid){
continue;
}
CheckValue<IkReal> x607 = IKatan2WithCheck(IkReal(new_r21),IkReal(((-1.0)*new_r20)),IKFAST_ATAN2_MAGTHRESH);
if(!x607.valid){
continue;
}
j33array[0]=((-1.5707963267949)+(((1.5707963267949)*(x606.value)))+(x607.value));
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[8];
IkReal x608=IKsin(j33);
IkReal x609=IKcos(j33);
IkReal x610=((1.0)*new_r00);
IkReal x611=((1.0)*sj32);
IkReal x612=((1.0)*new_r01);
IkReal x613=((1.0)*x609);
evalcond[0]=(((sj32*x609))+new_r20);
evalcond[1]=(new_r21+(((-1.0)*x608*x611)));
evalcond[2]=((((-1.0)*x608))+(((-1.0)*new_r10)));
evalcond[3]=((((-1.0)*x613))+(((-1.0)*new_r11)));
evalcond[4]=(((cj32*x608))+(((-1.0)*x612)));
evalcond[5]=((((-1.0)*cj32*x613))+(((-1.0)*x610)));
evalcond[6]=((((-1.0)*new_r21*x611))+(((-1.0)*cj32*x612))+x608);
evalcond[7]=((((-1.0)*cj32*x610))+(((-1.0)*x613))+(((-1.0)*new_r20*x611)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j32))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r12;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
IkReal x614=((1.0)*sj31);
if( IKabs(((((-1.0)*cj31*new_r01))+(((-1.0)*new_r00*x614)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((((cj31*new_r00))+(((-1.0)*new_r01*x614)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*cj31*new_r01))+(((-1.0)*new_r00*x614))))+IKsqr((((cj31*new_r00))+(((-1.0)*new_r01*x614))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j33array[0]=IKatan2(((((-1.0)*cj31*new_r01))+(((-1.0)*new_r00*x614))), (((cj31*new_r00))+(((-1.0)*new_r01*x614))));
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[8];
IkReal x615=IKsin(j33);
IkReal x616=IKcos(j33);
IkReal x617=((1.0)*sj31);
IkReal x618=((1.0)*x616);
IkReal x619=(sj31*x615);
IkReal x620=((1.0)*x615);
IkReal x621=(cj31*x618);
evalcond[0]=(((cj31*new_r01))+((new_r11*sj31))+x615);
evalcond[1]=(((cj31*x615))+((sj31*x616))+new_r01);
evalcond[2]=(((cj31*new_r00))+((new_r10*sj31))+(((-1.0)*x618)));
evalcond[3]=(((cj31*new_r10))+(((-1.0)*x620))+(((-1.0)*new_r00*x617)));
evalcond[4]=(((cj31*new_r11))+(((-1.0)*x618))+(((-1.0)*new_r01*x617)));
evalcond[5]=((((-1.0)*x621))+x619+new_r00);
evalcond[6]=((((-1.0)*x621))+x619+new_r11);
evalcond[7]=(new_r10+(((-1.0)*cj31*x620))+(((-1.0)*x616*x617)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j32)))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r12;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
IkReal x622=((1.0)*sj31);
if( IKabs(((((-1.0)*new_r00*x622))+((cj31*new_r01)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((-1.0)*new_r01*x622))+(((-1.0)*cj31*new_r00)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*new_r00*x622))+((cj31*new_r01))))+IKsqr(((((-1.0)*new_r01*x622))+(((-1.0)*cj31*new_r00))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j33array[0]=IKatan2(((((-1.0)*new_r00*x622))+((cj31*new_r01))), ((((-1.0)*new_r01*x622))+(((-1.0)*cj31*new_r00))));
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[8];
IkReal x623=IKsin(j33);
IkReal x624=IKcos(j33);
IkReal x625=((1.0)*sj31);
IkReal x626=((1.0)*x623);
IkReal x627=(sj31*x624);
IkReal x628=((1.0)*x624);
IkReal x629=(cj31*x626);
evalcond[0]=(((cj31*new_r00))+((new_r10*sj31))+x624);
evalcond[1]=(((cj31*new_r01))+(((-1.0)*x626))+((new_r11*sj31)));
evalcond[2]=(((sj31*x623))+((cj31*x624))+new_r00);
evalcond[3]=((((-1.0)*new_r00*x625))+((cj31*new_r10))+(((-1.0)*x626)));
evalcond[4]=((((-1.0)*new_r01*x625))+((cj31*new_r11))+(((-1.0)*x628)));
evalcond[5]=((((-1.0)*x629))+x627+new_r01);
evalcond[6]=((((-1.0)*x629))+x627+new_r10);
evalcond[7]=((((-1.0)*x623*x625))+new_r11+(((-1.0)*cj31*x628)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j33eval[1];
new_r21=0;
new_r20=0;
new_r02=0;
new_r12=0;
j33eval[0]=1.0;
if( IKabs(j33eval[0]) < 0.0000000100000000  )
{
continue; // no branches [j33]

} else
{
IkReal op[2+1], zeror[2];
int numroots;
op[0]=1.0;
op[1]=0;
op[2]=-1.0;
polyroots2(op,zeror,numroots);
IkReal j33array[2], cj33array[2], sj33array[2], tempj33array[1];
int numsolutions = 0;
for(int ij33 = 0; ij33 < numroots; ++ij33)
{
IkReal htj33 = zeror[ij33];
tempj33array[0]=((2.0)*(atan(htj33)));
for(int kj33 = 0; kj33 < 1; ++kj33)
{
j33array[numsolutions] = tempj33array[kj33];
if( j33array[numsolutions] > IKPI )
{
    j33array[numsolutions]-=IK2PI;
}
else if( j33array[numsolutions] < -IKPI )
{
    j33array[numsolutions]+=IK2PI;
}
sj33array[numsolutions] = IKsin(j33array[numsolutions]);
cj33array[numsolutions] = IKcos(j33array[numsolutions]);
numsolutions++;
}
}
bool j33valid[2]={true,true};
_nj33 = 2;
for(int ij33 = 0; ij33 < numsolutions; ++ij33)
    {
if( !j33valid[ij33] )
{
    continue;
}
    j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
htj33 = IKtan(j33/2);

_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < numsolutions; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
    }

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j33]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}
}
}

} else
{
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
CheckValue<IkReal> x631=IKPowWithIntegerCheck(sj32,-1);
if(!x631.valid){
continue;
}
IkReal x630=x631.value;
CheckValue<IkReal> x632=IKPowWithIntegerCheck(cj32,-1);
if(!x632.valid){
continue;
}
CheckValue<IkReal> x633=IKPowWithIntegerCheck(sj31,-1);
if(!x633.valid){
continue;
}
if( IKabs((x630*(x632.value)*(x633.value)*(((((-1.0)*new_r11*sj32))+(((-1.0)*cj31*new_r20)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20*x630)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((x630*(x632.value)*(x633.value)*(((((-1.0)*new_r11*sj32))+(((-1.0)*cj31*new_r20))))))+IKsqr(((-1.0)*new_r20*x630))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j33array[0]=IKatan2((x630*(x632.value)*(x633.value)*(((((-1.0)*new_r11*sj32))+(((-1.0)*cj31*new_r20))))), ((-1.0)*new_r20*x630));
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[12];
IkReal x634=IKsin(j33);
IkReal x635=IKcos(j33);
IkReal x636=(cj31*cj32);
IkReal x637=((1.0)*sj31);
IkReal x638=(new_r11*sj31);
IkReal x639=(new_r10*sj31);
IkReal x640=((1.0)*sj32);
IkReal x641=((1.0)*x635);
IkReal x642=((1.0)*x634);
IkReal x643=(sj31*x634);
evalcond[0]=(((sj32*x635))+new_r20);
evalcond[1]=(new_r21+(((-1.0)*x634*x640)));
evalcond[2]=(((cj31*new_r01))+x638+((cj32*x634)));
evalcond[3]=(((cj31*new_r10))+(((-1.0)*new_r00*x637))+(((-1.0)*x642)));
evalcond[4]=((((-1.0)*new_r01*x637))+((cj31*new_r11))+(((-1.0)*x641)));
evalcond[5]=(((x634*x636))+((sj31*x635))+new_r01);
evalcond[6]=(((cj31*new_r00))+(((-1.0)*cj32*x641))+x639);
evalcond[7]=(x643+(((-1.0)*x636*x641))+new_r00);
evalcond[8]=(((cj32*x643))+new_r11+(((-1.0)*cj31*x641)));
evalcond[9]=((((-1.0)*cj32*x635*x637))+new_r10+(((-1.0)*cj31*x642)));
evalcond[10]=(((new_r01*x636))+(((-1.0)*new_r21*x640))+x634+((cj32*x638)));
evalcond[11]=(((new_r00*x636))+(((-1.0)*x641))+((cj32*x639))+(((-1.0)*new_r20*x640)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
CheckValue<IkReal> x645=IKPowWithIntegerCheck(sj32,-1);
if(!x645.valid){
continue;
}
IkReal x644=x645.value;
CheckValue<IkReal> x646=IKPowWithIntegerCheck(sj31,-1);
if(!x646.valid){
continue;
}
if( IKabs((new_r21*x644)) < IKFAST_ATAN2_MAGTHRESH && IKabs((x644*(x646.value)*(((((-1.0)*cj31*cj32*new_r21))+(((-1.0)*new_r01*sj32)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((new_r21*x644))+IKsqr((x644*(x646.value)*(((((-1.0)*cj31*cj32*new_r21))+(((-1.0)*new_r01*sj32))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j33array[0]=IKatan2((new_r21*x644), (x644*(x646.value)*(((((-1.0)*cj31*cj32*new_r21))+(((-1.0)*new_r01*sj32))))));
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[12];
IkReal x647=IKsin(j33);
IkReal x648=IKcos(j33);
IkReal x649=(cj31*cj32);
IkReal x650=((1.0)*sj31);
IkReal x651=(new_r11*sj31);
IkReal x652=(new_r10*sj31);
IkReal x653=((1.0)*sj32);
IkReal x654=((1.0)*x648);
IkReal x655=((1.0)*x647);
IkReal x656=(sj31*x647);
evalcond[0]=(new_r20+((sj32*x648)));
evalcond[1]=((((-1.0)*x647*x653))+new_r21);
evalcond[2]=(((cj32*x647))+((cj31*new_r01))+x651);
evalcond[3]=(((cj31*new_r10))+(((-1.0)*new_r00*x650))+(((-1.0)*x655)));
evalcond[4]=(((cj31*new_r11))+(((-1.0)*x654))+(((-1.0)*new_r01*x650)));
evalcond[5]=(((sj31*x648))+new_r01+((x647*x649)));
evalcond[6]=(((cj31*new_r00))+(((-1.0)*cj32*x654))+x652);
evalcond[7]=(x656+(((-1.0)*x649*x654))+new_r00);
evalcond[8]=(((cj32*x656))+(((-1.0)*cj31*x654))+new_r11);
evalcond[9]=((((-1.0)*cj31*x655))+(((-1.0)*cj32*x648*x650))+new_r10);
evalcond[10]=(((cj32*x651))+((new_r01*x649))+x647+(((-1.0)*new_r21*x653)));
evalcond[11]=(((cj32*x652))+(((-1.0)*x654))+(((-1.0)*new_r20*x653))+((new_r00*x649)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j33array[1], cj33array[1], sj33array[1];
bool j33valid[1]={false};
_nj33 = 1;
CheckValue<IkReal> x657=IKPowWithIntegerCheck(IKsign(sj32),-1);
if(!x657.valid){
continue;
}
CheckValue<IkReal> x658 = IKatan2WithCheck(IkReal(new_r21),IkReal(((-1.0)*new_r20)),IKFAST_ATAN2_MAGTHRESH);
if(!x658.valid){
continue;
}
j33array[0]=((-1.5707963267949)+(((1.5707963267949)*(x657.value)))+(x658.value));
sj33array[0]=IKsin(j33array[0]);
cj33array[0]=IKcos(j33array[0]);
if( j33array[0] > IKPI )
{
    j33array[0]-=IK2PI;
}
else if( j33array[0] < -IKPI )
{    j33array[0]+=IK2PI;
}
j33valid[0] = true;
for(int ij33 = 0; ij33 < 1; ++ij33)
{
if( !j33valid[ij33] )
{
    continue;
}
_ij33[0] = ij33; _ij33[1] = -1;
for(int iij33 = ij33+1; iij33 < 1; ++iij33)
{
if( j33valid[iij33] && IKabs(cj33array[ij33]-cj33array[iij33]) < IKFAST_SOLUTION_THRESH && IKabs(sj33array[ij33]-sj33array[iij33]) < IKFAST_SOLUTION_THRESH )
{
    j33valid[iij33]=false; _ij33[1] = iij33; break; 
}
}
j33 = j33array[ij33]; cj33 = cj33array[ij33]; sj33 = sj33array[ij33];
{
IkReal evalcond[12];
IkReal x659=IKsin(j33);
IkReal x660=IKcos(j33);
IkReal x661=(cj31*cj32);
IkReal x662=((1.0)*sj31);
IkReal x663=(new_r11*sj31);
IkReal x664=(new_r10*sj31);
IkReal x665=((1.0)*sj32);
IkReal x666=((1.0)*x660);
IkReal x667=((1.0)*x659);
IkReal x668=(sj31*x659);
evalcond[0]=(((sj32*x660))+new_r20);
evalcond[1]=((((-1.0)*x659*x665))+new_r21);
evalcond[2]=(((cj32*x659))+((cj31*new_r01))+x663);
evalcond[3]=(((cj31*new_r10))+(((-1.0)*x667))+(((-1.0)*new_r00*x662)));
evalcond[4]=(((cj31*new_r11))+(((-1.0)*x666))+(((-1.0)*new_r01*x662)));
evalcond[5]=(((sj31*x660))+((x659*x661))+new_r01);
evalcond[6]=(((cj31*new_r00))+(((-1.0)*cj32*x666))+x664);
evalcond[7]=((((-1.0)*x661*x666))+x668+new_r00);
evalcond[8]=((((-1.0)*cj31*x666))+((cj32*x668))+new_r11);
evalcond[9]=((((-1.0)*cj31*x667))+(((-1.0)*cj32*x660*x662))+new_r10);
evalcond[10]=((((-1.0)*new_r21*x665))+((cj32*x663))+x659+((new_r01*x661)));
evalcond[11]=(((cj32*x664))+(((-1.0)*x666))+((new_r00*x661))+(((-1.0)*new_r20*x665)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(8);
vinfos[0].jointtype = 17;
vinfos[0].foffset = j12;
vinfos[0].indices[0] = _ij12[0];
vinfos[0].indices[1] = _ij12[1];
vinfos[0].maxsolutions = _nj12;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j27;
vinfos[1].indices[0] = _ij27[0];
vinfos[1].indices[1] = _ij27[1];
vinfos[1].maxsolutions = _nj27;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j28;
vinfos[2].indices[0] = _ij28[0];
vinfos[2].indices[1] = _ij28[1];
vinfos[2].maxsolutions = _nj28;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j29;
vinfos[3].indices[0] = _ij29[0];
vinfos[3].indices[1] = _ij29[1];
vinfos[3].maxsolutions = _nj29;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j30;
vinfos[4].indices[0] = _ij30[0];
vinfos[4].indices[1] = _ij30[1];
vinfos[4].maxsolutions = _nj30;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j31;
vinfos[5].indices[0] = _ij31[0];
vinfos[5].indices[1] = _ij31[1];
vinfos[5].maxsolutions = _nj31;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j32;
vinfos[6].indices[0] = _ij32[0];
vinfos[6].indices[1] = _ij32[1];
vinfos[6].maxsolutions = _nj32;
vinfos[7].jointtype = 1;
vinfos[7].foffset = j33;
vinfos[7].indices[0] = _ij33[0];
vinfos[7].indices[1] = _ij33[1];
vinfos[7].maxsolutions = _nj33;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}
}
}
}
}static inline void polyroots3(IkReal rawcoeffs[3+1], IkReal rawroots[3], int& numroots)
{
    using std::complex;
    if( rawcoeffs[0] == 0 ) {
        // solve with one reduced degree
        polyroots2(&rawcoeffs[1], &rawroots[0], numroots);
        return;
    }
    IKFAST_ASSERT(rawcoeffs[0] != 0);
    const IkReal tol = 128.0*std::numeric_limits<IkReal>::epsilon();
    const IkReal tolsqrt = sqrt(std::numeric_limits<IkReal>::epsilon());
    complex<IkReal> coeffs[3];
    const int maxsteps = 110;
    for(int i = 0; i < 3; ++i) {
        coeffs[i] = complex<IkReal>(rawcoeffs[i+1]/rawcoeffs[0]);
    }
    complex<IkReal> roots[3];
    IkReal err[3];
    roots[0] = complex<IkReal>(1,0);
    roots[1] = complex<IkReal>(0.4,0.9); // any complex number not a root of unity works
    err[0] = 1.0;
    err[1] = 1.0;
    for(int i = 2; i < 3; ++i) {
        roots[i] = roots[i-1]*roots[1];
        err[i] = 1.0;
    }
    for(int step = 0; step < maxsteps; ++step) {
        bool changed = false;
        for(int i = 0; i < 3; ++i) {
            if ( err[i] >= tol ) {
                changed = true;
                // evaluate
                complex<IkReal> x = roots[i] + coeffs[0];
                for(int j = 1; j < 3; ++j) {
                    x = roots[i] * x + coeffs[j];
                }
                for(int j = 0; j < 3; ++j) {
                    if( i != j ) {
                        if( roots[i] != roots[j] ) {
                            x /= (roots[i] - roots[j]);
                        }
                    }
                }
                roots[i] -= x;
                err[i] = abs(x);
            }
        }
        if( !changed ) {
            break;
        }
    }

    numroots = 0;
    bool visited[3] = {false};
    for(int i = 0; i < 3; ++i) {
        if( !visited[i] ) {
            // might be a multiple root, in which case it will have more error than the other roots
            // find any neighboring roots, and take the average
            complex<IkReal> newroot=roots[i];
            int n = 1;
            for(int j = i+1; j < 3; ++j) {
                // care about error in real much more than imaginary
                if( abs(real(roots[i])-real(roots[j])) < tolsqrt && abs(imag(roots[i])-imag(roots[j])) < 0.002 ) {
                    newroot += roots[j];
                    n += 1;
                    visited[j] = true;
                }
            }
            if( n > 1 ) {
                newroot /= n;
            }
            // there are still cases where even the mean is not accurate enough, until a better multi-root algorithm is used, need to use the sqrt
            if( IKabs(imag(newroot)) < tolsqrt ) {
                rawroots[numroots++] = real(newroot);
            }
        }
    }
}
static inline void polyroots2(IkReal rawcoeffs[2+1], IkReal rawroots[2], int& numroots) {
    IkReal det = rawcoeffs[1]*rawcoeffs[1]-4*rawcoeffs[0]*rawcoeffs[2];
    if( det < 0 ) {
        numroots=0;
    }
    else if( det == 0 ) {
        rawroots[0] = -0.5*rawcoeffs[1]/rawcoeffs[0];
        numroots = 1;
    }
    else {
        det = IKsqrt(det);
        rawroots[0] = (-rawcoeffs[1]+det)/(2*rawcoeffs[0]);
        rawroots[1] = (-rawcoeffs[1]-det)/(2*rawcoeffs[0]);//rawcoeffs[2]/(rawcoeffs[0]*rawroots[0]);
        numroots = 2;
    }
}
static inline void polyroots5(IkReal rawcoeffs[5+1], IkReal rawroots[5], int& numroots)
{
    using std::complex;
    if( rawcoeffs[0] == 0 ) {
        // solve with one reduced degree
        polyroots4(&rawcoeffs[1], &rawroots[0], numroots);
        return;
    }
    IKFAST_ASSERT(rawcoeffs[0] != 0);
    const IkReal tol = 128.0*std::numeric_limits<IkReal>::epsilon();
    const IkReal tolsqrt = sqrt(std::numeric_limits<IkReal>::epsilon());
    complex<IkReal> coeffs[5];
    const int maxsteps = 110;
    for(int i = 0; i < 5; ++i) {
        coeffs[i] = complex<IkReal>(rawcoeffs[i+1]/rawcoeffs[0]);
    }
    complex<IkReal> roots[5];
    IkReal err[5];
    roots[0] = complex<IkReal>(1,0);
    roots[1] = complex<IkReal>(0.4,0.9); // any complex number not a root of unity works
    err[0] = 1.0;
    err[1] = 1.0;
    for(int i = 2; i < 5; ++i) {
        roots[i] = roots[i-1]*roots[1];
        err[i] = 1.0;
    }
    for(int step = 0; step < maxsteps; ++step) {
        bool changed = false;
        for(int i = 0; i < 5; ++i) {
            if ( err[i] >= tol ) {
                changed = true;
                // evaluate
                complex<IkReal> x = roots[i] + coeffs[0];
                for(int j = 1; j < 5; ++j) {
                    x = roots[i] * x + coeffs[j];
                }
                for(int j = 0; j < 5; ++j) {
                    if( i != j ) {
                        if( roots[i] != roots[j] ) {
                            x /= (roots[i] - roots[j]);
                        }
                    }
                }
                roots[i] -= x;
                err[i] = abs(x);
            }
        }
        if( !changed ) {
            break;
        }
    }

    numroots = 0;
    bool visited[5] = {false};
    for(int i = 0; i < 5; ++i) {
        if( !visited[i] ) {
            // might be a multiple root, in which case it will have more error than the other roots
            // find any neighboring roots, and take the average
            complex<IkReal> newroot=roots[i];
            int n = 1;
            for(int j = i+1; j < 5; ++j) {
                // care about error in real much more than imaginary
                if( abs(real(roots[i])-real(roots[j])) < tolsqrt && abs(imag(roots[i])-imag(roots[j])) < 0.002 ) {
                    newroot += roots[j];
                    n += 1;
                    visited[j] = true;
                }
            }
            if( n > 1 ) {
                newroot /= n;
            }
            // there are still cases where even the mean is not accurate enough, until a better multi-root algorithm is used, need to use the sqrt
            if( IKabs(imag(newroot)) < tolsqrt ) {
                rawroots[numroots++] = real(newroot);
            }
        }
    }
}
static inline void polyroots4(IkReal rawcoeffs[4+1], IkReal rawroots[4], int& numroots)
{
    using std::complex;
    if( rawcoeffs[0] == 0 ) {
        // solve with one reduced degree
        polyroots3(&rawcoeffs[1], &rawroots[0], numroots);
        return;
    }
    IKFAST_ASSERT(rawcoeffs[0] != 0);
    const IkReal tol = 128.0*std::numeric_limits<IkReal>::epsilon();
    const IkReal tolsqrt = sqrt(std::numeric_limits<IkReal>::epsilon());
    complex<IkReal> coeffs[4];
    const int maxsteps = 110;
    for(int i = 0; i < 4; ++i) {
        coeffs[i] = complex<IkReal>(rawcoeffs[i+1]/rawcoeffs[0]);
    }
    complex<IkReal> roots[4];
    IkReal err[4];
    roots[0] = complex<IkReal>(1,0);
    roots[1] = complex<IkReal>(0.4,0.9); // any complex number not a root of unity works
    err[0] = 1.0;
    err[1] = 1.0;
    for(int i = 2; i < 4; ++i) {
        roots[i] = roots[i-1]*roots[1];
        err[i] = 1.0;
    }
    for(int step = 0; step < maxsteps; ++step) {
        bool changed = false;
        for(int i = 0; i < 4; ++i) {
            if ( err[i] >= tol ) {
                changed = true;
                // evaluate
                complex<IkReal> x = roots[i] + coeffs[0];
                for(int j = 1; j < 4; ++j) {
                    x = roots[i] * x + coeffs[j];
                }
                for(int j = 0; j < 4; ++j) {
                    if( i != j ) {
                        if( roots[i] != roots[j] ) {
                            x /= (roots[i] - roots[j]);
                        }
                    }
                }
                roots[i] -= x;
                err[i] = abs(x);
            }
        }
        if( !changed ) {
            break;
        }
    }

    numroots = 0;
    bool visited[4] = {false};
    for(int i = 0; i < 4; ++i) {
        if( !visited[i] ) {
            // might be a multiple root, in which case it will have more error than the other roots
            // find any neighboring roots, and take the average
            complex<IkReal> newroot=roots[i];
            int n = 1;
            for(int j = i+1; j < 4; ++j) {
                // care about error in real much more than imaginary
                if( abs(real(roots[i])-real(roots[j])) < tolsqrt && abs(imag(roots[i])-imag(roots[j])) < 0.002 ) {
                    newroot += roots[j];
                    n += 1;
                    visited[j] = true;
                }
            }
            if( n > 1 ) {
                newroot /= n;
            }
            // there are still cases where even the mean is not accurate enough, until a better multi-root algorithm is used, need to use the sqrt
            if( IKabs(imag(newroot)) < tolsqrt ) {
                rawroots[numroots++] = real(newroot);
            }
        }
    }
}
static inline void polyroots7(IkReal rawcoeffs[7+1], IkReal rawroots[7], int& numroots)
{
    using std::complex;
    if( rawcoeffs[0] == 0 ) {
        // solve with one reduced degree
        polyroots6(&rawcoeffs[1], &rawroots[0], numroots);
        return;
    }
    IKFAST_ASSERT(rawcoeffs[0] != 0);
    const IkReal tol = 128.0*std::numeric_limits<IkReal>::epsilon();
    const IkReal tolsqrt = sqrt(std::numeric_limits<IkReal>::epsilon());
    complex<IkReal> coeffs[7];
    const int maxsteps = 110;
    for(int i = 0; i < 7; ++i) {
        coeffs[i] = complex<IkReal>(rawcoeffs[i+1]/rawcoeffs[0]);
    }
    complex<IkReal> roots[7];
    IkReal err[7];
    roots[0] = complex<IkReal>(1,0);
    roots[1] = complex<IkReal>(0.4,0.9); // any complex number not a root of unity works
    err[0] = 1.0;
    err[1] = 1.0;
    for(int i = 2; i < 7; ++i) {
        roots[i] = roots[i-1]*roots[1];
        err[i] = 1.0;
    }
    for(int step = 0; step < maxsteps; ++step) {
        bool changed = false;
        for(int i = 0; i < 7; ++i) {
            if ( err[i] >= tol ) {
                changed = true;
                // evaluate
                complex<IkReal> x = roots[i] + coeffs[0];
                for(int j = 1; j < 7; ++j) {
                    x = roots[i] * x + coeffs[j];
                }
                for(int j = 0; j < 7; ++j) {
                    if( i != j ) {
                        if( roots[i] != roots[j] ) {
                            x /= (roots[i] - roots[j]);
                        }
                    }
                }
                roots[i] -= x;
                err[i] = abs(x);
            }
        }
        if( !changed ) {
            break;
        }
    }

    numroots = 0;
    bool visited[7] = {false};
    for(int i = 0; i < 7; ++i) {
        if( !visited[i] ) {
            // might be a multiple root, in which case it will have more error than the other roots
            // find any neighboring roots, and take the average
            complex<IkReal> newroot=roots[i];
            int n = 1;
            for(int j = i+1; j < 7; ++j) {
                // care about error in real much more than imaginary
                if( abs(real(roots[i])-real(roots[j])) < tolsqrt && abs(imag(roots[i])-imag(roots[j])) < 0.002 ) {
                    newroot += roots[j];
                    n += 1;
                    visited[j] = true;
                }
            }
            if( n > 1 ) {
                newroot /= n;
            }
            // there are still cases where even the mean is not accurate enough, until a better multi-root algorithm is used, need to use the sqrt
            if( IKabs(imag(newroot)) < tolsqrt ) {
                rawroots[numroots++] = real(newroot);
            }
        }
    }
}
static inline void polyroots6(IkReal rawcoeffs[6+1], IkReal rawroots[6], int& numroots)
{
    using std::complex;
    if( rawcoeffs[0] == 0 ) {
        // solve with one reduced degree
        polyroots5(&rawcoeffs[1], &rawroots[0], numroots);
        return;
    }
    IKFAST_ASSERT(rawcoeffs[0] != 0);
    const IkReal tol = 128.0*std::numeric_limits<IkReal>::epsilon();
    const IkReal tolsqrt = sqrt(std::numeric_limits<IkReal>::epsilon());
    complex<IkReal> coeffs[6];
    const int maxsteps = 110;
    for(int i = 0; i < 6; ++i) {
        coeffs[i] = complex<IkReal>(rawcoeffs[i+1]/rawcoeffs[0]);
    }
    complex<IkReal> roots[6];
    IkReal err[6];
    roots[0] = complex<IkReal>(1,0);
    roots[1] = complex<IkReal>(0.4,0.9); // any complex number not a root of unity works
    err[0] = 1.0;
    err[1] = 1.0;
    for(int i = 2; i < 6; ++i) {
        roots[i] = roots[i-1]*roots[1];
        err[i] = 1.0;
    }
    for(int step = 0; step < maxsteps; ++step) {
        bool changed = false;
        for(int i = 0; i < 6; ++i) {
            if ( err[i] >= tol ) {
                changed = true;
                // evaluate
                complex<IkReal> x = roots[i] + coeffs[0];
                for(int j = 1; j < 6; ++j) {
                    x = roots[i] * x + coeffs[j];
                }
                for(int j = 0; j < 6; ++j) {
                    if( i != j ) {
                        if( roots[i] != roots[j] ) {
                            x /= (roots[i] - roots[j]);
                        }
                    }
                }
                roots[i] -= x;
                err[i] = abs(x);
            }
        }
        if( !changed ) {
            break;
        }
    }

    numroots = 0;
    bool visited[6] = {false};
    for(int i = 0; i < 6; ++i) {
        if( !visited[i] ) {
            // might be a multiple root, in which case it will have more error than the other roots
            // find any neighboring roots, and take the average
            complex<IkReal> newroot=roots[i];
            int n = 1;
            for(int j = i+1; j < 6; ++j) {
                // care about error in real much more than imaginary
                if( abs(real(roots[i])-real(roots[j])) < tolsqrt && abs(imag(roots[i])-imag(roots[j])) < 0.002 ) {
                    newroot += roots[j];
                    n += 1;
                    visited[j] = true;
                }
            }
            if( n > 1 ) {
                newroot /= n;
            }
            // there are still cases where even the mean is not accurate enough, until a better multi-root algorithm is used, need to use the sqrt
            if( IKabs(imag(newroot)) < tolsqrt ) {
                rawroots[numroots++] = real(newroot);
            }
        }
    }
}
static inline void polyroots8(IkReal rawcoeffs[8+1], IkReal rawroots[8], int& numroots)
{
    using std::complex;
    if( rawcoeffs[0] == 0 ) {
        // solve with one reduced degree
        polyroots7(&rawcoeffs[1], &rawroots[0], numroots);
        return;
    }
    IKFAST_ASSERT(rawcoeffs[0] != 0);
    const IkReal tol = 128.0*std::numeric_limits<IkReal>::epsilon();
    const IkReal tolsqrt = sqrt(std::numeric_limits<IkReal>::epsilon());
    complex<IkReal> coeffs[8];
    const int maxsteps = 110;
    for(int i = 0; i < 8; ++i) {
        coeffs[i] = complex<IkReal>(rawcoeffs[i+1]/rawcoeffs[0]);
    }
    complex<IkReal> roots[8];
    IkReal err[8];
    roots[0] = complex<IkReal>(1,0);
    roots[1] = complex<IkReal>(0.4,0.9); // any complex number not a root of unity works
    err[0] = 1.0;
    err[1] = 1.0;
    for(int i = 2; i < 8; ++i) {
        roots[i] = roots[i-1]*roots[1];
        err[i] = 1.0;
    }
    for(int step = 0; step < maxsteps; ++step) {
        bool changed = false;
        for(int i = 0; i < 8; ++i) {
            if ( err[i] >= tol ) {
                changed = true;
                // evaluate
                complex<IkReal> x = roots[i] + coeffs[0];
                for(int j = 1; j < 8; ++j) {
                    x = roots[i] * x + coeffs[j];
                }
                for(int j = 0; j < 8; ++j) {
                    if( i != j ) {
                        if( roots[i] != roots[j] ) {
                            x /= (roots[i] - roots[j]);
                        }
                    }
                }
                roots[i] -= x;
                err[i] = abs(x);
            }
        }
        if( !changed ) {
            break;
        }
    }

    numroots = 0;
    bool visited[8] = {false};
    for(int i = 0; i < 8; ++i) {
        if( !visited[i] ) {
            // might be a multiple root, in which case it will have more error than the other roots
            // find any neighboring roots, and take the average
            complex<IkReal> newroot=roots[i];
            int n = 1;
            for(int j = i+1; j < 8; ++j) {
                // care about error in real much more than imaginary
                if( abs(real(roots[i])-real(roots[j])) < tolsqrt && abs(imag(roots[i])-imag(roots[j])) < 0.002 ) {
                    newroot += roots[j];
                    n += 1;
                    visited[j] = true;
                }
            }
            if( n > 1 ) {
                newroot /= n;
            }
            // there are still cases where even the mean is not accurate enough, until a better multi-root algorithm is used, need to use the sqrt
            if( IKabs(imag(newroot)) < tolsqrt ) {
                rawroots[numroots++] = real(newroot);
            }
        }
    }
}
};


/// solves the inverse kinematics equations.
/// \param pfree is an array specifying the free joints of the chain.
IKFAST_API bool ComputeIk(const IkReal* eetrans, const IkReal* eerot, const IkReal* pfree, IkSolutionListBase<IkReal>& solutions) {
IKSolver solver;
return solver.ComputeIk(eetrans,eerot,pfree,solutions);
}

IKFAST_API bool ComputeIk2(const IkReal* eetrans, const IkReal* eerot, const IkReal* pfree, IkSolutionListBase<IkReal>& solutions, void* pOpenRAVEManip) {
IKSolver solver;
return solver.ComputeIk(eetrans,eerot,pfree,solutions);
}

IKFAST_API const char* GetKinematicsHash() { return ""; }

IKFAST_API const char* GetIkFastVersion() { return "0x1000004a"; }

#ifdef IKFAST_NAMESPACE
} // end namespace
#endif

#ifndef IKFAST_NO_MAIN
#include <stdio.h>
#include <stdlib.h>
#ifdef IKFAST_NAMESPACE
using namespace IKFAST_NAMESPACE;
#endif
int main(int argc, char** argv)
{
    if( argc != 12+GetNumFreeParameters()+1 ) {
        printf("\nUsage: ./ik r00 r01 r02 t0 r10 r11 r12 t1 r20 r21 r22 t2 free0 ...\n\n"
               "Returns the ik solutions given the transformation of the end effector specified by\n"
               "a 3x3 rotation R (rXX), and a 3x1 translation (tX).\n"
               "There are %d free parameters that have to be specified.\n\n",GetNumFreeParameters());
        return 1;
    }

    IkSolutionList<IkReal> solutions;
    std::vector<IkReal> vfree(GetNumFreeParameters());
    IkReal eerot[9],eetrans[3];
    eerot[0] = atof(argv[1]); eerot[1] = atof(argv[2]); eerot[2] = atof(argv[3]); eetrans[0] = atof(argv[4]);
    eerot[3] = atof(argv[5]); eerot[4] = atof(argv[6]); eerot[5] = atof(argv[7]); eetrans[1] = atof(argv[8]);
    eerot[6] = atof(argv[9]); eerot[7] = atof(argv[10]); eerot[8] = atof(argv[11]); eetrans[2] = atof(argv[12]);
    for(std::size_t i = 0; i < vfree.size(); ++i)
        vfree[i] = atof(argv[13+i]);
    bool bSuccess = ComputeIk(eetrans, eerot, vfree.size() > 0 ? &vfree[0] : NULL, solutions);

    if( !bSuccess ) {
        fprintf(stderr,"Failed to get ik solution\n");
        return -1;
    }

    printf("Found %d ik solutions:\n", (int)solutions.GetNumSolutions());
    std::vector<IkReal> solvalues(GetNumJoints());
    for(std::size_t i = 0; i < solutions.GetNumSolutions(); ++i) {
        const IkSolutionBase<IkReal>& sol = solutions.GetSolution(i);
        printf("sol%d (free=%d): ", (int)i, (int)sol.GetFree().size());
        std::vector<IkReal> vsolfree(sol.GetFree().size());
        sol.GetSolution(&solvalues[0],vsolfree.size()>0?&vsolfree[0]:NULL);
        for( std::size_t j = 0; j < solvalues.size(); ++j)
            printf("%.15f, ", solvalues[j]);
        printf("\n");
    }
    return 0;
}

#endif

//// START
static PyObject *right_arm_ik(PyObject *self, PyObject *args) {
    IkSolutionList<IkReal> solutions;

    // Should only have two free parameters (torso and upper arm)
    std::vector<IkReal> vfree(GetNumFreeParameters());
    IkReal eerot[9], eetrans[3];


    // First list if 3x3 rotation matrix, easier to compute in Python.
    // Next list is [x, y, z] translation matrix.
    // Last list is free joints (torso and upper arm roll (in that order)).
    PyObject *rotList; // 3x3 rotation matrix
    PyObject *transList; // [x,y,z]
    PyObject *freeList; // [torso, upper arm]

    if(!PyArg_ParseTuple(args, "O!O!O!", &PyList_Type, &rotList, &PyList_Type, &transList, &PyList_Type, &freeList)) {
        return NULL;
    }

    for(std::size_t i = 0; i < 3; ++i) {
        eetrans[i] = PyFloat_AsDouble(PyList_GetItem(transList, i));

        PyObject* rowList = PyList_GetItem(rotList, i);
        for( std::size_t j = 0; j < 3; ++j){
            eerot[3*i + j] = PyFloat_AsDouble(PyList_GetItem(rowList, j));
        }
    }

    for(int i = 0; i < GetNumFreeParameters(); ++i) {
        vfree[i] = PyFloat_AsDouble(PyList_GetItem(freeList, i));
    }

    // I don't understand why we pass &vfree[0] instead of just vfree.
    // Clearly ComputeIk takes an IkReal* parameter there, but it treats that parameter like an array.
    // It probably does work because the computeIk call in main specifically makes this change.
    // So it's hopefully right, and I don't understand because I don't know C++.
    bool bSuccess = ComputeIk(eetrans, eerot, &vfree[0], solutions);

    if (!bSuccess) {
        return Py_BuildValue(""); // Equivalent to returning None
    }

    // There are 8 joints in each solution (torso + 7 arm joints).
    std::vector<IkReal> solvalues(GetNumJoints());
    PyObject *solutionList = PyList_New(solutions.GetNumSolutions());

    for(std::size_t i = 0; i < solutions.GetNumSolutions(); ++i) {
        const IkSolutionBase<IkReal>& sol = solutions.GetSolution(i);
        std::vector<IkReal> vsolfree(sol.GetFree().size());
        sol.GetSolution(&solvalues[0],vsolfree.size()>0?&vsolfree[0]:NULL);

        PyObject *individualSolution = PyList_New(GetNumJoints());
        for( std::size_t j = 0; j < solvalues.size(); ++j){
            // I think IkReal is just a wrapper for double. So this should work.
            PyList_SetItem(individualSolution, j, PyFloat_FromDouble(solvalues[j]));
        }
        PyList_SetItem(solutionList, i, individualSolution);
    }
    return solutionList;
}

static PyObject *right_arm_fk(PyObject *self, PyObject *args) {
    std::vector<IkReal> joints(8);
    IkReal eerot[9], eetrans[3];

    // First double is torso height. Next 7 doubles are arm joints
    PyObject *jointList;
    if(!PyArg_ParseTuple(args, "O!", &PyList_Type, &jointList)) {
        return NULL;
    }

    for(std::size_t i = 0; i < 8; ++i){
        joints[i] = PyFloat_AsDouble(PyList_GetItem(jointList, i));
    }

    ComputeFk(&joints[0], eetrans, eerot);

    PyObject *pose = PyList_New(2);
    PyObject *pos = PyList_New(3);
    PyObject *rot = PyList_New(3);

    for(std::size_t i = 0; i < 3; ++i) {
        PyList_SetItem(pos, i, PyFloat_FromDouble(eetrans[i]));

        PyObject *row = PyList_New(3);
        for( std::size_t j = 0; j < 3; ++j){
            PyList_SetItem(row, j, PyFloat_FromDouble(eerot[3*i + j]));
        }
        PyList_SetItem(rot, i, row);
    }

    PyList_SetItem(pose, 0, pos);
    PyList_SetItem(pose, 1, rot);

    return pose;
}

static PyMethodDef ikRightMethods[] = {
    {"rightIK", right_arm_ik, METH_VARARGS, "Compute IK for the PR2's right arm."},
    {"rightFK", right_arm_fk, METH_VARARGS, "Compute FK for the PR2's right arm."},
    {NULL, NULL, 0, NULL} // Not sure why/if this is needed. It shows up in the examples though(something about Sentinel).
};

PyMODINIT_FUNC initikRight(void) {
    (void) Py_InitModule("ikRight", ikRightMethods);
}
//// END