################
# iG Semantics #
################
rooms = [
    "bathroom",
    "bedroom",
    "childs_room",
    "closet",
    "corridor",
    "dining_room",
    "empty_room",
    "exercise_room",
    "garage",
    "home_office",
    "kitchen",
    "living_room",
    "lobby",
    "pantry_room",
    "playroom",
    "staircase",
    "storage_room",
    "television_room",
    "utility_room",
    "balcony",
    "library",
    "auditorium",
    "undefined",
]


#####################
# cubicasa mappings #
#####################
cubi_to_skip = {
    "SaunaStove Round",
    "Fireplace",
    "BaseCabinetTriangle",
    "CoatRack",
    "SaunaStove",
    "FireplaceRound",
    "ShowerCab",
    "ShowerScreen",
    "PlaceForFireplaceCorner",
    "GEARound",
    "Chimney",
    "Fan",
    "ShowerPlatform",
    "PlaceForFireplaceRound",
    "Misc",
    "SaunaStoveRound",
    "ShowerScreenRoundLeft",
    "FireplaceCorner",
    "PlaceForFireplace",
    "Housing",
    "GeneralAppliance",
    "ShowerScreenRoundRight",
    "SpaceForAppliance",
    "SpaceForAppliance2",
}

cubi_cat_mapping = {
    "IntegratedStove": "stove",
    "GasStove": "stove",
    "WoodStove": "stove",
    "Stove": "stove",
    "IntegratedStoveSmall": "stove",
    "Refrigerator": "fridge",
    "DoubleRefrigerator": "fridge",
    "Sink": "sink",
    "DoubleSink": "sink",
    "WaterTap": "sink",
    "SideSink": "sink",
    "CornerSink": "sink",
    "DoubleSinkRight": "sink",
    "RoundSink": "sink",
    "WallCabinet": "top_cabinet",
    "Shower": "shower_head",
    "Toilet": "toilet",
    "Dishwasher": "dishwasher",
    "CounterTop": "counter",
    "Bathtub": "bathtub",
    "WashingMachine": "washer",
    "SaunaBenchHigh": "bench",
    "SaunaBenchMid": "bench",
    "SaunaBenchLow": "bench",
    "SaunaBench": "bench",
    "Jacuzzi": "bathtub",
    "BathtubRound": "bathtub",
    "Urinal": "toilet",
    "TumbleDryer": "dryer",
    "HighHeater": "heater",
    "Heater": "heater",
    "ClosetTriangle": "bottom_cabinet",
    "CoatCloset": "bottom_cabinet",
    "ClosetRound": "bottom_cabinet",
    "BaseCabinetRound": "bottom_cabinet",
    "BaseCabinet": "bottom_cabinet",
    "Closet": "bottom_cabinet",
}

cubi_all_rooms = {
    "Background": "undefined",
    "Alcove": "lobby",
    "Attic": "empty_room",
    "Ballroom": "undefined",
    "Bar": "undefined",
    "Basement": "utility_room",
    "Bath": "bathroom",
    "Bedroom": "bedroom",
    "Below150cm": "undefined",
    "CarPort": "garage",
    "Church": "undefined",
    "Closet": "closet",
    "ConferenceRoom": "undefined",
    "Conservatory": "undefined",
    "Counter": "undefined",
    "Den": "undefined",
    "Dining": "dining_room",
    "DraughtLobby": "lobby",
    "DressingRoom": "closet",
    "EatingArea": "dining_room",
    "Elevated": "undefined",
    "Elevator": "undefined",
    "Entry": "lobby",
    "ExerciseRoom": "exercise_room",
    "Garage": "garage",
    "Garbage": "undefined",
    "Hall": "corridor",
    "HallWay": "corridor",
    "HotTub": "bathroom",
    "Kitchen": "kitchen",
    "Library": "home_office",
    "LivingRoom": "living_room",
    "Loft": "undefined",
    "Lounge": "living_room",
    "MediaRoom": "television_room",
    "MeetingRoom": "home_office",
    "Museum": "undefined",
    "Nook": "undefined",
    "Office": "home_office",
    "OpenToBelow": "undefined",
    "Outdoor": "undefined",
    "Pantry": "pantry_room",
    "Reception": "lobby",
    "RecreationRoom": "playroom",
    "RetailSpace": "undefined",
    "Room": "undefined",
    "Sanctuary": "undefined",
    "Sauna": "bathroom",
    "ServiceRoom": "undefined",
    "ServingArea": "undefined",
    "Skylights": "undefined",
    "Stable": "undefined",
    "Stage": "undefined",
    "StairWell": "undefined",
    "Storage": "storage_room",
    "SunRoom": "undefined",
    "SwimmingPool": "undefined",
    "TechnicalRoom": "utility_room",
    "Theatre": "television_room",
    "Undefined": "undefined",
    "UserDefined": "undefined",
    "Utility": "utility_room",
    "Wall": "undefined",
    "Railing": "undefined",
    "Stairs": "undefined",
}

#####################
# 3D-Front mappings #
#####################

front_all_rooms = {
    "Balcony": "balcony",
    "CloakRoom": "closet",
    "LivingRoom": "living_room",
    "Bathroom": "bathroom",
    "DiningRoom": "dining_room",
    "StorageRoom": "storage_room",
    "LivingDiningRoom": "dining_room",
    "Corridor": "corridor",
    "ElderlyRoom": "bedroom",
    "SecondBedroom": "bedroom",
    "Garage": "garage",
    "Hallway": "corridor",
    "Library": "library",
    "MasterBedroom": "bedroom",
    "SecondBathroom": "bathroom",
    "KidsRoom": "childs_room",
    "Auditorium": "auditorium",
    "Aisle": "corridor",
    "NannyRoom": "bedroom",
    "Stairwell": "corridor",
    "Kitchen": "kitchen",
    "Lounge": "living_room",
    "Bedroom": "bedroom",
    "MasterBathroom": "bathroom",
    "LaundryRoom": "utility_room",
    "EquipmentRoom": "storage_room",
    "Courtyard": "undefined",
    "none": "undefined",
    "non": "undefined",
    "Terrace": "undefined",
}

front_to_skip = ["CustomizedFixedFurniture", "CustomizedFurniture", "CustomizedPersonalizedModel", "CustomizedPlatform"]

wall_cats = [
    "Baseboard",
    "BayWindow",
    "Column",
    "CustomizedBackgroundModel",
    "CustomizedFeatureWall",
    "Flue",
    "Pocket",
    "WallBottom",
    "WallInner",
    "WallOuter",
    "WallTop",
]
ceiling_cats = ["Beam", "Cornice", "CustomizedCeiling", "SewerPipe", "SmartCustomizedCeiling", "Ceiling"]
floor_cats = ["Floor"]

front_cat_mapping = {
    "Children Cabinet": "bottom_cabinet",
    "Nightstand": "bottom_cabinet",
    "Bookcase / jewelry Armoire": "shelf",
    "Wardrobe": "bottom_cabinet",
    "Coffee Table": "coffee_table",
    "Corner/Side Table": "coffee_table",
    "Sideboard / Side Cabinet / Console Table": "console_table",
    "Wine Cabinet": "bottom_cabinet",
    "TV Stand": "bottom_cabinet",
    "Drawer Chest / Corner cabinet": "bottom_cabinet",
    "Shelf": "shelf",
    "Round End Table": "table",
    "King-size Bed": "bed",
    "Bunk Bed": "bed",
    "Bed Frame": "bed",
    "Single bed": "bed",
    "Kids Bed": "bed",
    "Dining Chair": "chair",
    "Lounge Chair / Cafe Chair / Office Chair": "chair",
    "Dressing Chair": "chair",
    "Classic Chinese Chair": "chair",
    "Barstool": "stool",
    "Dressing Table": "table",
    "Dining Table": "table",
    "Desk": "table",
    "Three-Seat / Multi-seat Sofa": "sofa",
    "Three-Seat / Multi-set sofa": "sofa",
    "armchair": "sofa_chair",
    "Loveseat Sofa": "sofa",
    "L-shaped Sofa": "sofa",
    "Lazy Sofa": "sofa",
    "Chaise Longue Sofa": "sofa",
    "Footstool / Sofastool / Bed End Stool / Stool": "stool",
    "Pendant Lamp": "ceiling_lamp",
    "Ceiling Lamp": "ceiling_lamp",
    "Cabinet/Shelf/Desk": "shelf",
    "Sofa": "sofa",
    "Table": "table",
}
