# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'source/packages'}

packages = \
['akit',
 'akit.activation',
 'akit.cli',
 'akit.cli.cmdtree',
 'akit.cli.cmdtree.databases',
 'akit.cli.cmdtree.generators',
 'akit.cli.cmdtree.network',
 'akit.cli.cmdtree.servers',
 'akit.cli.cmdtree.testing',
 'akit.coupling',
 'akit.datum',
 'akit.environment',
 'akit.interfaces',
 'akit.interop',
 'akit.interop.agents',
 'akit.interop.clients',
 'akit.interop.cluster',
 'akit.interop.concurrency',
 'akit.interop.coordinators',
 'akit.interop.credentials',
 'akit.interop.dns',
 'akit.interop.eventsinking',
 'akit.interop.landscaping',
 'akit.interop.landscaping.layers',
 'akit.interop.serial',
 'akit.interop.upnp',
 'akit.interop.upnp.content',
 'akit.interop.upnp.devices',
 'akit.interop.upnp.extensions',
 'akit.interop.upnp.extensions.dynamic',
 'akit.interop.upnp.extensions.dynamic.embeddeddevices',
 'akit.interop.upnp.extensions.dynamic.rootdevices',
 'akit.interop.upnp.extensions.dynamic.services',
 'akit.interop.upnp.extensions.dynamic.services.MicrosoftCorporation',
 'akit.interop.upnp.extensions.dynamic.services.NETGEAR',
 'akit.interop.upnp.extensions.dynamic.services.NETGEARInc',
 'akit.interop.upnp.extensions.dynamic.services.SonosInc',
 'akit.interop.upnp.extensions.standard.embeddeddevices',
 'akit.interop.upnp.extensions.standard.rootdevices',
 'akit.interop.upnp.extensions.standard.rootdevices.sonos',
 'akit.interop.upnp.extensions.standard.services',
 'akit.interop.upnp.extensions.standard.services.UPnP',
 'akit.interop.upnp.generator',
 'akit.interop.upnp.generator.dynamic',
 'akit.interop.upnp.services',
 'akit.interop.upnp.xml',
 'akit.interop.wireless',
 'akit.monitoring',
 'akit.networking',
 'akit.readers',
 'akit.readers.linux',
 'akit.readers.linux.command',
 'akit.templates',
 'akit.testing',
 'akit.testing.testplus',
 'akit.testing.testplus.registration',
 'akit.wellknown',
 'akit.workflow',
 'akit.workflow.tasks',
 'akit.xcryptography',
 'akit.xlogging',
 'akit.xml',
 'akit.xmultiprocessing',
 'akit.xregex',
 'akit.xthreading']

package_data = \
{'': ['*'],
 'akit.interop': ['soap/*'],
 'akit.interop.upnp.generator': ['standard/embeddeddevices/UPnP/*',
                                 'standard/services/UPnP/*'],
 'akit.interop.upnp.generator.dynamic': ['embeddeddevices/NETGEAR/*',
                                         'embeddeddevices/SonosInc/*',
                                         'rootdevices/MicrosoftCorporation/*',
                                         'rootdevices/NETGEAR/*',
                                         'rootdevices/NETGEARInc/*',
                                         'rootdevices/SonosInc/*',
                                         'services/MicrosoftCorporation/*',
                                         'services/NETGEAR/*',
                                         'services/NETGEARInc/*',
                                         'services/SonosInc/*'],
 'akit.monitoring': ['scripts/platforms/linux/*', 'templates/*'],
 'akit.templates': ['static/v0/*', 'tabs/*']}

install_requires = \
['click>=8.1.3,<9.0.0',
 'coverage>=7.0.4,<8.0.0',
 'debugpy>=1.6.5,<2.0.0',
 'dlipower>=1.0.176,<2.0.0',
 'flask-migrate>=4.0.1,<5.0.0',
 'flask-restx>=1.0.3,<2.0.0',
 'flask>=2.2.2,<3.0.0',
 'gunicorn>=20.1.0,<21.0.0',
 'ipython>=8.8.0,<9.0.0',
 'netifaces>=0.11.0,<0.12.0',
 'nmcli>=1.1.2,<2.0.0',
 'paramiko>=2.12.0,<3.0.0',
 'pycrunch-trace>=0.2,<0.3',
 'pylint>=2.15.9,<3.0.0',
 'pyreadline3>=3.4.1,<4.0.0',
 'pyserial>=3.5,<4.0',
 'pyyaml>=6.0,<7.0',
 'requests>=2.28.1,<3.0.0',
 'rich>=13.0.1,<14.0.0',
 'rope>=1.6.0,<2.0.0',
 'ssdp>=1.1.1,<2.0.0',
 'werkzeug>=2.2.2,<3.0.0',
 'zeroconf>=0.47.1,<0.48.0']

setup_kwargs = {
    'name': 'automationkit',
    'version': '0.3.60',
    'description': 'Automation Kit Test Framework',
    'long_description': '# Automation Kit Repository\n\nWelcome to the Automation Kit repository!\n\n\n*Note:* This package is progressing quickly but is not yet ready for full production environments.\n\n# Description\nThe **Automation Kit** is a python toolkit for building distributed automated task and testing systems.  It goes beyond the capabilities of other task and test automation frameworks by providing a hybrid approach that allows for dependency injection, similar to pytest, combined with and object oriented framework that can be utilized to easily customize the orchestration of tasks and tests across a collection of integrated resources.  Because the **Automation Kit** is built from the start with distributed automation in mind, it can help you quickly get distributed automated systems up and running that are based on a tested and proven set of object patterns and APIs.\n\n# Design Philosophies\nThis section covers some of the important design features of the **Automation Kit** framework.\n\n## Large Scale\nThe **Automation Kit** is designed for enterprise level distributed automation *"at scale"*.  The term *"at scale"* refers not only to a larger collection of enterprise resources but also refers to the fact that the **Automation Kit** helps to setup patterns that will support working in a very large code base.  The size of a code base that you might see associated with large enterprise level projects.  The **Automation Kit** supports working in large code bases by helping to establish good code organizational patterns and abstractions that support characteristics that:\n\n* make it easier to learn and work in the code base\n* make the code base easier to maintain\n* make it easier to share and reuse code\n\n## Faster Classification of Issues\nOne of the key philosophies behind the **Automation Kit** design is one of being able quickly and efficiently identify the nature of issues that come up during automation runs.  The **Automation Kit** initially classifies errors into one of four categories:\n\n* **Configuration** - We identify configuration issues quickly and classify them so as to ensure that resources are not waisted troubleshooting configuration related issues and that eronious test results or noise is not generated due to configuration related issues. We also want automation runs to fail out quickly if the automation configuration is not setup correctly, before waisting additional testing resources.\n* **Environment** - The **Automation Kit** performs an initial diagnostic scan of the automation landscape and all the resources declared to be necessary to run a series of tasks or tests in order to provide indications of environmental failures as early as possible.  This is important to ensure that we do not generate noise in automation results that are not related to the automation tasks or tests that might fail.  Just as with configuration, we want automation runs to fail out quickly if the automation environment is not setup correctly.\n* **Error** - The **Automation Kit** classifies un-expected errors, or errors that are not founded in an expectation of a result, as an **Error** condition.  This helps to ensure these errors are given an appropriate initial direction or indication that the issues is a problem in the automation code and not an issue in the code that is the target of the automation run.\n* **Failure** - The **AutomationKit** classifies failures that are associated with an expectation of behavior from a target under test as failures.  This allows for the proper initial classification of an issue as being a problem that is likely a failure in the code being targeted by the automation and the behavior or result it should have exhibited.\n\nHaving the initial classification of issues fall into one of these four categories helps to ensure that issues are easier to triage and assign to the appropriate party for investigation and resolution. It also helps to establish categories that can be used for data collection in order to better analyse the performance of test infrastructure, test code and product code.\n\n## Integration and Distributed Automation Support\nThe **Automation Kit** comes with enterprise level integration and distributed automation capabilities.  The framework utilizes a customize-able set of classes that guides enterprise users through a process of creating a very robust integration object model based on the roles that enterprise resources play in an automation landscape.\n\nThe declaration of a custom automation landscape is as simple as setting an environment variable or passing a command line flag declaring the python module that contains a custom landscape derived class.  The *Landscape* and *LandscapeDescription* derived classes work together to provide the **Automation Kit** with a description of the customized roles and integration mixin(s) that provide the connection between the tasks and test automation code.\n\n## Task and Test Integration Declaration and Assurance\nThe **Automation Kit** utilizes its object model to allow tasks and tests to provide information about their associated integration points and scopes of execution to the automation framework.  This integration declaration mechanism allows the automation framework to provide an early scan of the integration pathways and provide levels of assurance as to the stability of the automation landscape early in the automation process.  This is vitally important as it eliminates the waist and noise that are often associated with automation runs that are performed against an automation Landscape that has broken, mis-configured or missing resources.\n\n## Automation Job, Scope and Flow Control \nThe **Automation Kit** allows enterprise users to organize and customize the ordering of automation scope engagements and the flow of an automation job.  This provides the automation engineer the ability to control the engagement of automation scopes of execution and allows for optimal use of time and overlapping of scopes of execution in a test run.\n\n# Table of Contents\n1. [Automation Software Stack](http://automationmojo.com/automationkit/docs/usermanual/10-automation-software-stack.html)\n2. [Getting Started](http://automationmojo.com/automationkit/docs/usermanual/20-getting-started.html)\n3. [Automation Configuration](http://automationmojo.com/automationkit/docs/usermanual/30-automation-configuration.html)\n    1. [Landscape File](http://automationmojo.com/automationkit/docs/usermanual/31-landscape-file.html)\n    2. [Topology File](http://automationmojo.com/automationkit/docs/usermanual/32-topology-file.html)\n    2. [Runtime File](http://automationmojo.com/automationkit/docs/usermanual/33-runtime-file.html)\n    3. [Credentials File](http://automationmojo.com/automationkit/docs/usermanual/34-credentials-file.html)\n4. [TestRun Sequencing](http://automationmojo.com/automationkit/docs/usermanual/40-testrun-sequencing.html)\n    1. [Integration Couplings](http://automationmojo.com/automationkit/docs/usermanual/41-integration-couplings.html)\n    2. [Scope Couplings](http://automationmojo.com/automationkit/docs/usermanual/42-scope-couplings.html)\n5. [Functional Description](http://automationmojo.com/automationkit/docs/usermanual/50-functional-description.html)\n    1. [Activation and Startup](http://automationmojo.com/automationkit/docs/usermanual/51-activation-and-startup.html)\n    2. [Inter-Operability](http://automationmojo.com/automationkit/docs/usermanual/52-inter-operability.html)\n    3. [SSH Coordinator and Agent](http://automationmojo.com/automationkit/docs/usermanual/53-ssh-coordinator-and-agent.html)\n    4. [UPNP Coordinator and Agent](http://automationmojo.com/automationkit/docs/usermanual/54-upnp-coordinator-and-agent.html)\n6. [Workflow Orchestration](http://automationmojo.com/automationkit/docs/usermanual/60-workflow-orchestration.html)\n7. [Enterprise Extensibility](http://automationmojo.com/automationkit/docs/usermanual/70-enterprise-extensibility.html)\n8. [Command Line](http://automationmojo.com/automationkit/docs/usermanual/80-command-line.html)\n9. [Code Organization and Conventions](http://automationmojo.com/automationkit/docs/usermanual/90-code-organization-and-conventions.html)\n10. [Coding Standards](http://automationmojo.com/automationkit/docs/usermanual/100-coding-standards.html)\n',
    'author': 'Myron Walker',
    'author_email': 'myron.walker@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
