"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnEipEndpoint = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const _util_1 = require("./_util");
/**
 * Use an EC2 Instance as a Global Accelerator Endpoint
 */
class CfnEipEndpoint {
    constructor(eip, options = {}) {
        this.eip = eip;
        this.options = options;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_globalaccelerator_endpoints_CfnEipEndpointProps(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnEipEndpoint);
            }
            throw error;
        }
        _util_1.validateWeight(options.weight);
        this.region = core_1.Stack.of(eip).region;
    }
    renderEndpointConfiguration() {
        return {
            endpointId: this.eip.attrAllocationId,
            weight: this.options.weight,
        };
    }
}
exports.CfnEipEndpoint = CfnEipEndpoint;
_a = JSII_RTTI_SYMBOL_1;
CfnEipEndpoint[_a] = { fqn: "@aws-cdk/aws-globalaccelerator-endpoints.CfnEipEndpoint", version: "1.175.0" };
//# sourceMappingURL=data:application/json;base64,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