"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstanceEndpoint = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _util_1 = require("./_util");
/**
 * Use an EC2 Instance as a Global Accelerator Endpoint
 */
class InstanceEndpoint {
    constructor(instance, options = {}) {
        this.instance = instance;
        this.options = options;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_globalaccelerator_endpoints_InstanceEndpointProps(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, InstanceEndpoint);
            }
            throw error;
        }
        _util_1.validateWeight(options.weight);
        this.region = instance.env.region;
    }
    renderEndpointConfiguration() {
        return {
            endpointId: this.instance.instanceId,
            weight: this.options.weight,
            clientIpPreservationEnabled: this.options.preserveClientIp,
        };
    }
}
exports.InstanceEndpoint = InstanceEndpoint;
_a = JSII_RTTI_SYMBOL_1;
InstanceEndpoint[_a] = { fqn: "@aws-cdk/aws-globalaccelerator-endpoints.InstanceEndpoint", version: "1.175.0" };
//# sourceMappingURL=data:application/json;base64,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