"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NetworkLoadBalancerEndpoint = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _util_1 = require("./_util");
/**
 * Use a Network Load Balancer as a Global Accelerator Endpoint
 */
class NetworkLoadBalancerEndpoint {
    constructor(loadBalancer, options = {}) {
        this.loadBalancer = loadBalancer;
        this.options = options;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_globalaccelerator_endpoints_NetworkLoadBalancerEndpointProps(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, NetworkLoadBalancerEndpoint);
            }
            throw error;
        }
        _util_1.validateWeight(options.weight);
        this.region = loadBalancer.env.region;
    }
    renderEndpointConfiguration() {
        return {
            endpointId: this.loadBalancer.loadBalancerArn,
            weight: this.options.weight,
        };
    }
}
exports.NetworkLoadBalancerEndpoint = NetworkLoadBalancerEndpoint;
_a = JSII_RTTI_SYMBOL_1;
NetworkLoadBalancerEndpoint[_a] = { fqn: "@aws-cdk/aws-globalaccelerator-endpoints.NetworkLoadBalancerEndpoint", version: "1.175.0" };
//# sourceMappingURL=data:application/json;base64,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