from heaobject.registry import Resource
from heaobject.volume import DEFAULT_FILE_SYSTEM

from ..testcase.dockermongo import DockerMongoManager
from .microservicetestcase import get_test_case_cls_default as _get_test_case_cls_default
from .testenv import DockerContainerConfig
from .dockermongo import RealRegistryContainerConfig
from functools import partial

HEASERVER_REGISTRY_IMAGE = 'registry.gitlab.com/huntsman-cancer-institute/risr/hea/heaserver-registry:1.0.0a24'
HEASERVER_VOLUMES_IMAGE = 'registry.gitlab.com/huntsman-cancer-institute/risr/hea/heaserver-volumes:1.0.0a10'
HEASERVER_KEYCHAIN_IMAGE = 'registry.gitlab.com/huntsman-cancer-institute/risr/hea/heaserver-keychain:1.0.0a4'
volume_microservice = DockerContainerConfig(image=HEASERVER_VOLUMES_IMAGE, port=8080, check_path='/volumes',
                                            resources=[Resource(resource_type_name='heaobject.volume.Volume',
                                                                base_path='/volumes',
                                                                file_system_name=DEFAULT_FILE_SYSTEM),
                                                       Resource(resource_type_name='heaobject.volume.FileSystem',
                                                                base_path='/filesystems',
                                                                file_system_name=DEFAULT_FILE_SYSTEM)],
                                            db_manager_cls=DockerMongoManager)
keychain_microservice = DockerContainerConfig(image=HEASERVER_KEYCHAIN_IMAGE, port=8080, check_path='/credentials',
                                              resources=[
                                                  Resource(resource_type_name='heaobject.keychain.Credentials',
                                                           base_path='/credentials',
                                                           file_system_name=DEFAULT_FILE_SYSTEM)],
                                              db_manager_cls=DockerMongoManager)


get_test_case_cls_default = partial(_get_test_case_cls_default,
                                    registry_docker_image=RealRegistryContainerConfig(HEASERVER_REGISTRY_IMAGE),
                                    other_docker_images=[volume_microservice, keychain_microservice])

get_test_case_cls_default.__doc__ = """
    Create a test case class for testing an AWS S3-based HEA microservice. The test environment will provide images
    of the HEA Registry Microservice (1.0.0a24), HEA Volumes Microservice (1.0.0a10), and HEA Keychain Microservice
    (1.0.0a4) on port 8080 using DockerMongoManager. Test case classes generated by this function should only be used
    for integration tests.

    :param coll: the name of the collection that the microservice uses (required).
    :param fixtures: HEA desktop objects to load into the database, as a map of collection keys ->
    list of desktop object dicts (required).
    :param duplicate_action_name: the name of the duplication action for this microservice (required).
    :param db_manager_cls: the type of the database manager that will be used as the default for collection keys that
    are strings. Under typical circumstances, this should be used by the collection specified in coll. You should
    always use MockS3Manager. Defaults to MockMongoManager.
    :param wstl_package: the name of the package containing the WeSTL data package, in standard module format
    (foo.bar).
    :param content: a mapping of collection keys -> HEA object IDs -> content that will be included with the
    objects inserted into the database. If None, objects will not have content.
    :param content_type: the MIME type of the content included with the objects (e.g., text/plain; charset=utf-8).
    Must be specified if content_type is specified.
    :param put_content_status: the expected HTTP response code for updating the content of the HEA object. Normally
    should be 204 if the content is updatable and 405 if not. Default is None, which will cause associated tests to be
    skipped.
    :param include_root: this parameter has been deprecated since version 1.0.0a71 and is no longer used. Will be
    removed in a future version of HEA Server Framework.
    :param get_actions: the list of actions associated with the GET one route of the microservice.
    :param get_all_actions: the list of actions associated with the GET all route of the microservice.
    :param expected_opener: The expected URL of the resource that does the opening, including a list of HTML rel
    values.
    :param href: the resource being tested. If None, uses http://localhost:{port}/{coll}/, where {coll} is the
    collection name, and {port} is the port ultimately used by this test case. Typical AWS hrefs are in volumes.
    :param port: the port number to run aiohttp. If None, a random available port will be chosen.
    :param sub: the user from which the requests will be sent. It should be set to heaobject.user.TEST_USER for
    permissions testing. Defaults to heaobject.user.NONE_USER.
    :param exclude: a list of expected value names to exclude from test case class creation. Tests that need any
    expected value you specify here will be skipped.
"""
