"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReceiptRuleSet = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const receipt_rule_1 = require("./receipt-rule");
const ses_generated_1 = require("./ses.generated");
/**
 * A new or imported receipt rule set.
 */
class ReceiptRuleSetBase extends core_1.Resource {
    /**
     * Adds a new receipt rule in this rule set. The new rule is added after
     * the last added rule unless `after` is specified.
     */
    addRule(id, options) {
        var _b;
        this.lastAddedRule = new receipt_rule_1.ReceiptRule(this, id, {
            after: (_b = this.lastAddedRule) !== null && _b !== void 0 ? _b : undefined,
            ruleSet: this,
            ...options,
        });
        return this.lastAddedRule;
    }
    /**
     * Adds a drop spam rule
     */
    addDropSpamRule() {
        const dropSpam = new receipt_rule_1.DropSpamReceiptRule(this, 'DropSpam', {
            ruleSet: this,
        });
        this.lastAddedRule = dropSpam.rule;
    }
}
/**
 * A new receipt rule set.
 */
class ReceiptRuleSet extends ReceiptRuleSetBase {
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.receiptRuleSetName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_ses_ReceiptRuleSetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const resource = new ses_generated_1.CfnReceiptRuleSet(this, 'Resource', {
            ruleSetName: this.physicalName,
        });
        this.receiptRuleSetName = resource.ref;
        if (props) {
            if (props.dropSpam) {
                this.addDropSpamRule();
            }
            const rules = props.rules || [];
            rules.forEach((ruleOption, idx) => this.addRule(`Rule${idx}`, ruleOption));
        }
    }
    /**
     * Import an exported receipt rule set.
     */
    static fromReceiptRuleSetName(scope, id, receiptRuleSetName) {
        class Import extends ReceiptRuleSetBase {
            constructor() {
                super(...arguments);
                this.receiptRuleSetName = receiptRuleSetName;
            }
        }
        return new Import(scope, id);
    }
}
exports.ReceiptRuleSet = ReceiptRuleSet;
_a = JSII_RTTI_SYMBOL_1;
ReceiptRuleSet[_a] = { fqn: "@aws-cdk/aws-ses.ReceiptRuleSet", version: "1.159.0" };
//# sourceMappingURL=data:application/json;base64,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