# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from tator.api_client import ApiClient
from tator.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class TatorApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def algorithm_launch(self, project, **kwargs):  # noqa: E501
        """algorithm_launch  # noqa: E501

        Create state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.algorithm_launch(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param algorithm_launch_spec:
        :type algorithm_launch_spec: AlgorithmLaunchSpec
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AlgorithmLaunch
        """
        kwargs['_return_http_data_only'] = True
        return self.algorithm_launch_with_http_info(project, **kwargs)  # noqa: E501

    def algorithm_launch_with_http_info(self, project, **kwargs):  # noqa: E501
        """algorithm_launch  # noqa: E501

        Create state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.algorithm_launch_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param algorithm_launch_spec:
        :type algorithm_launch_spec: AlgorithmLaunchSpec
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AlgorithmLaunch, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'project',
            'algorithm_launch_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method algorithm_launch" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `algorithm_launch`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'algorithm_launch_spec' in local_var_params:
            body_params = local_var_params['algorithm_launch_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/AlgorithmLaunch/{project}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AlgorithmLaunch',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_analysis(self, project, **kwargs):  # noqa: E501
        """create_analysis  # noqa: E501

        Create state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_analysis(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param analysis_spec:
        :type analysis_spec: AnalysisSpec
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CreateResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.create_analysis_with_http_info(project, **kwargs)  # noqa: E501

    def create_analysis_with_http_info(self, project, **kwargs):  # noqa: E501
        """create_analysis  # noqa: E501

        Create state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_analysis_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param analysis_spec:
        :type analysis_spec: AnalysisSpec
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CreateResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'project',
            'analysis_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_analysis" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `create_analysis`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'analysis_spec' in local_var_params:
            body_params = local_var_params['analysis_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Analyses/{project}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_leaf_list(self, project, **kwargs):  # noqa: E501
        """create_leaf_list  # noqa: E501

        Create state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_leaf_list(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param leaf_spec:
        :type leaf_spec: list[LeafSpec]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CreateListResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.create_leaf_list_with_http_info(project, **kwargs)  # noqa: E501

    def create_leaf_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """create_leaf_list  # noqa: E501

        Create state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_leaf_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param leaf_spec:
        :type leaf_spec: list[LeafSpec]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CreateListResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'project',
            'leaf_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_leaf_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `create_leaf_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'leaf_spec' in local_var_params:
            body_params = local_var_params['leaf_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Leaves/{project}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_leaf_type(self, project, **kwargs):  # noqa: E501
        """create_leaf_type  # noqa: E501

        Create state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_leaf_type(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param leaf_type_spec:
        :type leaf_type_spec: LeafTypeSpec
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CreateResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.create_leaf_type_with_http_info(project, **kwargs)  # noqa: E501

    def create_leaf_type_with_http_info(self, project, **kwargs):  # noqa: E501
        """create_leaf_type  # noqa: E501

        Create state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_leaf_type_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param leaf_type_spec:
        :type leaf_type_spec: LeafTypeSpec
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CreateResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'project',
            'leaf_type_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_leaf_type" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `create_leaf_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'leaf_type_spec' in local_var_params:
            body_params = local_var_params['leaf_type_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/LeafTypes/{project}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_localization_list(self, project, **kwargs):  # noqa: E501
        """create_localization_list  # noqa: E501

        Create state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_localization_list(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param localization_spec:
        :type localization_spec: list[LocalizationSpec]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CreateListResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.create_localization_list_with_http_info(project, **kwargs)  # noqa: E501

    def create_localization_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """create_localization_list  # noqa: E501

        Create state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_localization_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param localization_spec:
        :type localization_spec: list[LocalizationSpec]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CreateListResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'project',
            'localization_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_localization_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `create_localization_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'localization_spec' in local_var_params:
            body_params = local_var_params['localization_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Localizations/{project}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_localization_type(self, project, **kwargs):  # noqa: E501
        """create_localization_type  # noqa: E501

        Create state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_localization_type(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param localization_type_spec:
        :type localization_type_spec: LocalizationTypeSpec
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CreateResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.create_localization_type_with_http_info(project, **kwargs)  # noqa: E501

    def create_localization_type_with_http_info(self, project, **kwargs):  # noqa: E501
        """create_localization_type  # noqa: E501

        Create state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_localization_type_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param localization_type_spec:
        :type localization_type_spec: LocalizationTypeSpec
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CreateResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'project',
            'localization_type_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_localization_type" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `create_localization_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'localization_type_spec' in local_var_params:
            body_params = local_var_params['localization_type_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/LocalizationTypes/{project}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_media_type(self, project, **kwargs):  # noqa: E501
        """create_media_type  # noqa: E501

        Create state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_media_type(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param media_type_spec:
        :type media_type_spec: MediaTypeSpec
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CreateResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.create_media_type_with_http_info(project, **kwargs)  # noqa: E501

    def create_media_type_with_http_info(self, project, **kwargs):  # noqa: E501
        """create_media_type  # noqa: E501

        Create state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_media_type_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param media_type_spec:
        :type media_type_spec: MediaTypeSpec
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CreateResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'project',
            'media_type_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_media_type" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `create_media_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'media_type_spec' in local_var_params:
            body_params = local_var_params['media_type_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/MediaTypes/{project}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_membership(self, project, **kwargs):  # noqa: E501
        """create_membership  # noqa: E501

        Create state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_membership(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param membership_spec:
        :type membership_spec: MembershipSpec
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CreateResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.create_membership_with_http_info(project, **kwargs)  # noqa: E501

    def create_membership_with_http_info(self, project, **kwargs):  # noqa: E501
        """create_membership  # noqa: E501

        Create state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_membership_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param membership_spec:
        :type membership_spec: MembershipSpec
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CreateResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'project',
            'membership_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_membership" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `create_membership`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'membership_spec' in local_var_params:
            body_params = local_var_params['membership_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Memberships/{project}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_obtain_auth_token(self, **kwargs):  # noqa: E501
        """create_obtain_auth_token  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_obtain_auth_token(async_req=True)
        >>> result = thread.get()

        :param credentials:
        :type credentials: Credentials
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Token
        """
        kwargs['_return_http_data_only'] = True
        return self.create_obtain_auth_token_with_http_info(**kwargs)  # noqa: E501

    def create_obtain_auth_token_with_http_info(self, **kwargs):  # noqa: E501
        """create_obtain_auth_token  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_obtain_auth_token_with_http_info(async_req=True)
        >>> result = thread.get()

        :param credentials:
        :type credentials: Credentials
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Token, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'credentials'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_obtain_auth_token" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'credentials' in local_var_params:
            body_params = local_var_params['credentials']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Token', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Token',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_progress_summary_api(self, project, **kwargs):  # noqa: E501
        """create_progress_summary_api  # noqa: E501

        Create state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_progress_summary_api(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param progress_summary_spec:
        :type progress_summary_spec: ProgressSummarySpec
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MessageResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.create_progress_summary_api_with_http_info(project, **kwargs)  # noqa: E501

    def create_progress_summary_api_with_http_info(self, project, **kwargs):  # noqa: E501
        """create_progress_summary_api  # noqa: E501

        Create state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_progress_summary_api_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param progress_summary_spec:
        :type progress_summary_spec: ProgressSummarySpec
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MessageResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'project',
            'progress_summary_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_progress_summary_api" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `create_progress_summary_api`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'progress_summary_spec' in local_var_params:
            body_params = local_var_params['progress_summary_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/ProgressSummary/{project}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_project(self, **kwargs):  # noqa: E501
        """create_project  # noqa: E501

        Create state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_project(async_req=True)
        >>> result = thread.get()

        :param project_spec:
        :type project_spec: ProjectSpec
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CreateResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.create_project_with_http_info(**kwargs)  # noqa: E501

    def create_project_with_http_info(self, **kwargs):  # noqa: E501
        """create_project  # noqa: E501

        Create state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_project_with_http_info(async_req=True)
        >>> result = thread.get()

        :param project_spec:
        :type project_spec: ProjectSpec
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CreateResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'project_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_project" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'project_spec' in local_var_params:
            body_params = local_var_params['project_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Projects', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_state_list(self, project, **kwargs):  # noqa: E501
        """create_state_list  # noqa: E501

        Create state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_state_list(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param state_spec:
        :type state_spec: list[StateSpec]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CreateListResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.create_state_list_with_http_info(project, **kwargs)  # noqa: E501

    def create_state_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """create_state_list  # noqa: E501

        Create state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_state_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param state_spec:
        :type state_spec: list[StateSpec]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CreateListResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'project',
            'state_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_state_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `create_state_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'state_spec' in local_var_params:
            body_params = local_var_params['state_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/States/{project}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_state_type(self, project, **kwargs):  # noqa: E501
        """create_state_type  # noqa: E501

        Create state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_state_type(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param state_type_spec:
        :type state_type_spec: StateTypeSpec
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CreateResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.create_state_type_with_http_info(project, **kwargs)  # noqa: E501

    def create_state_type_with_http_info(self, project, **kwargs):  # noqa: E501
        """create_state_type  # noqa: E501

        Create state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_state_type_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param state_type_spec:
        :type state_type_spec: StateTypeSpec
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CreateResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'project',
            'state_type_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_state_type" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `create_state_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'state_type_spec' in local_var_params:
            body_params = local_var_params['state_type_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/StateTypes/{project}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_temporary_file(self, project, **kwargs):  # noqa: E501
        """create_temporary_file  # noqa: E501

        Create state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_temporary_file(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param temporary_file_spec:
        :type temporary_file_spec: TemporaryFileSpec
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CreateResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.create_temporary_file_with_http_info(project, **kwargs)  # noqa: E501

    def create_temporary_file_with_http_info(self, project, **kwargs):  # noqa: E501
        """create_temporary_file  # noqa: E501

        Create state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_temporary_file_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param temporary_file_spec:
        :type temporary_file_spec: TemporaryFileSpec
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CreateResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'project',
            'temporary_file_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_temporary_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `create_temporary_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'temporary_file_spec' in local_var_params:
            body_params = local_var_params['temporary_file_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/TemporaryFiles/{project}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_version(self, project, **kwargs):  # noqa: E501
        """create_version  # noqa: E501

        Create state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_version(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param version_spec:
        :type version_spec: VersionSpec
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CreateResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.create_version_with_http_info(project, **kwargs)  # noqa: E501

    def create_version_with_http_info(self, project, **kwargs):  # noqa: E501
        """create_version  # noqa: E501

        Create state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_version_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param version_spec:
        :type version_spec: VersionSpec
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CreateResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'project',
            'version_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_version" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `create_version`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'version_spec' in local_var_params:
            body_params = local_var_params['version_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Versions/{project}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_job(self, run_uid, **kwargs):  # noqa: E501
        """delete_job  # noqa: E501

        Delete state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_job(run_uid, async_req=True)
        >>> result = thread.get()

        :param run_uid: A uuid1 string identifying to single Job. (required)
        :type run_uid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MessageResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_job_with_http_info(run_uid, **kwargs)  # noqa: E501

    def delete_job_with_http_info(self, run_uid, **kwargs):  # noqa: E501
        """delete_job  # noqa: E501

        Delete state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_job_with_http_info(run_uid, async_req=True)
        >>> result = thread.get()

        :param run_uid: A uuid1 string identifying to single Job. (required)
        :type run_uid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MessageResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'run_uid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'run_uid' is set
        if self.api_client.client_side_validation and ('run_uid' not in local_var_params or  # noqa: E501
                                                        local_var_params['run_uid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `run_uid` when calling `delete_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'run_uid' in local_var_params:
            path_params['run_uid'] = local_var_params['run_uid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Job/{run_uid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_job_group(self, group_id, **kwargs):  # noqa: E501
        """delete_job_group  # noqa: E501

        Delete state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_job_group(group_id, async_req=True)
        >>> result = thread.get()

        :param group_id: A uuid1 string identifying a group of jobs. (required)
        :type group_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MessageResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_job_group_with_http_info(group_id, **kwargs)  # noqa: E501

    def delete_job_group_with_http_info(self, group_id, **kwargs):  # noqa: E501
        """delete_job_group  # noqa: E501

        Delete state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_job_group_with_http_info(group_id, async_req=True)
        >>> result = thread.get()

        :param group_id: A uuid1 string identifying a group of jobs. (required)
        :type group_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MessageResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'group_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_job_group" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'group_id' is set
        if self.api_client.client_side_validation and ('group_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['group_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `group_id` when calling `delete_job_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'group_id' in local_var_params:
            path_params['group_id'] = local_var_params['group_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/JobGroup/{group_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_leaf(self, id, **kwargs):  # noqa: E501
        """delete_leaf  # noqa: E501

        Delete state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_leaf(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a leaf. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_leaf_with_http_info(id, **kwargs)  # noqa: E501

    def delete_leaf_with_http_info(self, id, **kwargs):  # noqa: E501
        """delete_leaf  # noqa: E501

        Delete state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_leaf_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a leaf. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_leaf" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_leaf`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Leaf/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_leaf_list(self, project, **kwargs):  # noqa: E501
        """delete_leaf_list  # noqa: E501

        Delete state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_leaf_list(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param ancestor: Get descendents of a leaf element (inclusive), by path (i.e. ITIS.Animalia).
        :type ancestor: str
        :param type: Unique integer identifying a leaf type.
        :type type: int
        :param name: Name of the leaf element.
        :type name: str
        :param attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute: str
        :param attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lt: str
        :param attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lte: str
        :param attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gt: str
        :param attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gte: str
        :param attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_contains: str
        :param attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :type attribute_distance: str
        :param attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :type attribute_null: str
        :param operation: Set to \"count\" to return a count of objects instead of the objects.
        :type operation: str
        :param start: Pagination start index. Index of the first item in a larger list to return.
        :type start: int
        :param stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :type stop: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MessageResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_leaf_list_with_http_info(project, **kwargs)  # noqa: E501

    def delete_leaf_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """delete_leaf_list  # noqa: E501

        Delete state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_leaf_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param ancestor: Get descendents of a leaf element (inclusive), by path (i.e. ITIS.Animalia).
        :type ancestor: str
        :param type: Unique integer identifying a leaf type.
        :type type: int
        :param name: Name of the leaf element.
        :type name: str
        :param attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute: str
        :param attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lt: str
        :param attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lte: str
        :param attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gt: str
        :param attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gte: str
        :param attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_contains: str
        :param attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :type attribute_distance: str
        :param attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :type attribute_null: str
        :param operation: Set to \"count\" to return a count of objects instead of the objects.
        :type operation: str
        :param start: Pagination start index. Index of the first item in a larger list to return.
        :type start: int
        :param stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :type stop: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MessageResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'project',
            'ancestor',
            'type',
            'name',
            'attribute',
            'attribute_lt',
            'attribute_lte',
            'attribute_gt',
            'attribute_gte',
            'attribute_contains',
            'attribute_distance',
            'attribute_null',
            'operation',
            'start',
            'stop'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_leaf_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `delete_leaf_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'ancestor' in local_var_params and local_var_params['ancestor'] is not None:  # noqa: E501
            query_params.append(('ancestor', local_var_params['ancestor']))  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'attribute' in local_var_params and local_var_params['attribute'] is not None:  # noqa: E501
            query_params.append(('attribute', local_var_params['attribute']))  # noqa: E501
        if 'attribute_lt' in local_var_params and local_var_params['attribute_lt'] is not None:  # noqa: E501
            query_params.append(('attribute_lt', local_var_params['attribute_lt']))  # noqa: E501
        if 'attribute_lte' in local_var_params and local_var_params['attribute_lte'] is not None:  # noqa: E501
            query_params.append(('attribute_lte', local_var_params['attribute_lte']))  # noqa: E501
        if 'attribute_gt' in local_var_params and local_var_params['attribute_gt'] is not None:  # noqa: E501
            query_params.append(('attribute_gt', local_var_params['attribute_gt']))  # noqa: E501
        if 'attribute_gte' in local_var_params and local_var_params['attribute_gte'] is not None:  # noqa: E501
            query_params.append(('attribute_gte', local_var_params['attribute_gte']))  # noqa: E501
        if 'attribute_contains' in local_var_params and local_var_params['attribute_contains'] is not None:  # noqa: E501
            query_params.append(('attribute_contains', local_var_params['attribute_contains']))  # noqa: E501
        if 'attribute_distance' in local_var_params and local_var_params['attribute_distance'] is not None:  # noqa: E501
            query_params.append(('attribute_distance', local_var_params['attribute_distance']))  # noqa: E501
        if 'attribute_null' in local_var_params and local_var_params['attribute_null'] is not None:  # noqa: E501
            query_params.append(('attribute_null', local_var_params['attribute_null']))  # noqa: E501
        if 'operation' in local_var_params and local_var_params['operation'] is not None:  # noqa: E501
            query_params.append(('operation', local_var_params['operation']))  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'stop' in local_var_params and local_var_params['stop'] is not None:  # noqa: E501
            query_params.append(('stop', local_var_params['stop']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Leaves/{project}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_leaf_type(self, id, **kwargs):  # noqa: E501
        """delete_leaf_type  # noqa: E501

        Delete state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_leaf_type(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying an leaf type. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MessageResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_leaf_type_with_http_info(id, **kwargs)  # noqa: E501

    def delete_leaf_type_with_http_info(self, id, **kwargs):  # noqa: E501
        """delete_leaf_type  # noqa: E501

        Delete state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_leaf_type_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying an leaf type. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MessageResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_leaf_type" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_leaf_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/LeafType/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_localization(self, id, **kwargs):  # noqa: E501
        """delete_localization  # noqa: E501

        Delete state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_localization(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a localization. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MessageResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_localization_with_http_info(id, **kwargs)  # noqa: E501

    def delete_localization_with_http_info(self, id, **kwargs):  # noqa: E501
        """delete_localization  # noqa: E501

        Delete state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_localization_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a localization. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MessageResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_localization" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_localization`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Localization/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_localization_list(self, project, **kwargs):  # noqa: E501
        """delete_localization_list  # noqa: E501

        Delete state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_localization_list(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param media_query: Query string used to filter media IDs. If supplied, media_id will be ignored.
        :type media_query: str
        :param media_id: Comma-separated list of media IDs.
        :type media_id: list[int]
        :param type: Unique integer identifying a annotation type.
        :type type: int
        :param version: List of integers representing versions to fetch
        :type version: list[int]
        :param modified: Whether to return original or modified annotations, 0 or 1.
        :type modified: int
        :param after: If given, all results returned will be after the localization with this ID. The `start` and `stop` parameters are relative to this modified range.
        :type after: int
        :param search: Lucene query syntax string for use with Elasticsearch. See `reference <https://lucene.apache.org/core/2_9_4/queryparsersyntax.html>`_.
        :type search: str
        :param attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute: str
        :param attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lt: str
        :param attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lte: str
        :param attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gt: str
        :param attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gte: str
        :param attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_contains: str
        :param attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :type attribute_distance: str
        :param attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :type attribute_null: str
        :param operation: Set to \"count\" to return a count of objects instead of the objects.
        :type operation: str
        :param start: Pagination start index. Index of the first item in a larger list to return.
        :type start: int
        :param stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :type stop: int
        :param exclude_parents: If a clone is present, do not send parent. (0 or 1)
        :type exclude_parents: int
        :param frame: Frame number of this localization if it is in a video.
        :type frame: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MessageResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_localization_list_with_http_info(project, **kwargs)  # noqa: E501

    def delete_localization_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """delete_localization_list  # noqa: E501

        Delete state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_localization_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param media_query: Query string used to filter media IDs. If supplied, media_id will be ignored.
        :type media_query: str
        :param media_id: Comma-separated list of media IDs.
        :type media_id: list[int]
        :param type: Unique integer identifying a annotation type.
        :type type: int
        :param version: List of integers representing versions to fetch
        :type version: list[int]
        :param modified: Whether to return original or modified annotations, 0 or 1.
        :type modified: int
        :param after: If given, all results returned will be after the localization with this ID. The `start` and `stop` parameters are relative to this modified range.
        :type after: int
        :param search: Lucene query syntax string for use with Elasticsearch. See `reference <https://lucene.apache.org/core/2_9_4/queryparsersyntax.html>`_.
        :type search: str
        :param attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute: str
        :param attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lt: str
        :param attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lte: str
        :param attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gt: str
        :param attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gte: str
        :param attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_contains: str
        :param attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :type attribute_distance: str
        :param attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :type attribute_null: str
        :param operation: Set to \"count\" to return a count of objects instead of the objects.
        :type operation: str
        :param start: Pagination start index. Index of the first item in a larger list to return.
        :type start: int
        :param stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :type stop: int
        :param exclude_parents: If a clone is present, do not send parent. (0 or 1)
        :type exclude_parents: int
        :param frame: Frame number of this localization if it is in a video.
        :type frame: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MessageResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'project',
            'media_query',
            'media_id',
            'type',
            'version',
            'modified',
            'after',
            'search',
            'attribute',
            'attribute_lt',
            'attribute_lte',
            'attribute_gt',
            'attribute_gte',
            'attribute_contains',
            'attribute_distance',
            'attribute_null',
            'operation',
            'start',
            'stop',
            'exclude_parents',
            'frame'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_localization_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `delete_localization_list`")  # noqa: E501

        if self.api_client.client_side_validation and 'exclude_parents' in local_var_params and local_var_params['exclude_parents'] > 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `exclude_parents` when calling `delete_localization_list`, must be a value less than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'exclude_parents' in local_var_params and local_var_params['exclude_parents'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `exclude_parents` when calling `delete_localization_list`, must be a value greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'frame' in local_var_params and local_var_params['frame'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `frame` when calling `delete_localization_list`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'media_query' in local_var_params and local_var_params['media_query'] is not None:  # noqa: E501
            query_params.append(('media_query', local_var_params['media_query']))  # noqa: E501
        if 'media_id' in local_var_params and local_var_params['media_id'] is not None:  # noqa: E501
            query_params.append(('media_id', local_var_params['media_id']))  # noqa: E501
            collection_formats['media_id'] = 'csv'  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'version' in local_var_params and local_var_params['version'] is not None:  # noqa: E501
            query_params.append(('version', local_var_params['version']))  # noqa: E501
            collection_formats['version'] = 'csv'  # noqa: E501
        if 'modified' in local_var_params and local_var_params['modified'] is not None:  # noqa: E501
            query_params.append(('modified', local_var_params['modified']))  # noqa: E501
        if 'after' in local_var_params and local_var_params['after'] is not None:  # noqa: E501
            query_params.append(('after', local_var_params['after']))  # noqa: E501
        if 'search' in local_var_params and local_var_params['search'] is not None:  # noqa: E501
            query_params.append(('search', local_var_params['search']))  # noqa: E501
        if 'attribute' in local_var_params and local_var_params['attribute'] is not None:  # noqa: E501
            query_params.append(('attribute', local_var_params['attribute']))  # noqa: E501
        if 'attribute_lt' in local_var_params and local_var_params['attribute_lt'] is not None:  # noqa: E501
            query_params.append(('attribute_lt', local_var_params['attribute_lt']))  # noqa: E501
        if 'attribute_lte' in local_var_params and local_var_params['attribute_lte'] is not None:  # noqa: E501
            query_params.append(('attribute_lte', local_var_params['attribute_lte']))  # noqa: E501
        if 'attribute_gt' in local_var_params and local_var_params['attribute_gt'] is not None:  # noqa: E501
            query_params.append(('attribute_gt', local_var_params['attribute_gt']))  # noqa: E501
        if 'attribute_gte' in local_var_params and local_var_params['attribute_gte'] is not None:  # noqa: E501
            query_params.append(('attribute_gte', local_var_params['attribute_gte']))  # noqa: E501
        if 'attribute_contains' in local_var_params and local_var_params['attribute_contains'] is not None:  # noqa: E501
            query_params.append(('attribute_contains', local_var_params['attribute_contains']))  # noqa: E501
        if 'attribute_distance' in local_var_params and local_var_params['attribute_distance'] is not None:  # noqa: E501
            query_params.append(('attribute_distance', local_var_params['attribute_distance']))  # noqa: E501
        if 'attribute_null' in local_var_params and local_var_params['attribute_null'] is not None:  # noqa: E501
            query_params.append(('attribute_null', local_var_params['attribute_null']))  # noqa: E501
        if 'operation' in local_var_params and local_var_params['operation'] is not None:  # noqa: E501
            query_params.append(('operation', local_var_params['operation']))  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'stop' in local_var_params and local_var_params['stop'] is not None:  # noqa: E501
            query_params.append(('stop', local_var_params['stop']))  # noqa: E501
        if 'exclude_parents' in local_var_params and local_var_params['exclude_parents'] is not None:  # noqa: E501
            query_params.append(('excludeParents', local_var_params['exclude_parents']))  # noqa: E501
        if 'frame' in local_var_params and local_var_params['frame'] is not None:  # noqa: E501
            query_params.append(('frame', local_var_params['frame']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Localizations/{project}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_localization_type(self, id, **kwargs):  # noqa: E501
        """delete_localization_type  # noqa: E501

        Delete state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_localization_type(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying an localization type. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MessageResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_localization_type_with_http_info(id, **kwargs)  # noqa: E501

    def delete_localization_type_with_http_info(self, id, **kwargs):  # noqa: E501
        """delete_localization_type  # noqa: E501

        Delete state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_localization_type_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying an localization type. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MessageResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_localization_type" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_localization_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/LocalizationType/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_media(self, id, **kwargs):  # noqa: E501
        """delete_media  # noqa: E501

        Delete state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_media(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a media. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MessageResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_media_with_http_info(id, **kwargs)  # noqa: E501

    def delete_media_with_http_info(self, id, **kwargs):  # noqa: E501
        """delete_media  # noqa: E501

        Delete state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_media_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a media. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MessageResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_media" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_media`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Media/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_media_list(self, project, **kwargs):  # noqa: E501
        """delete_media_list  # noqa: E501

        Delete state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_media_list(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param media_id: List of integers identifying media.
        :type media_id: list[int]
        :param type: Unique integer identifying media type.
        :type type: int
        :param name: Name of the media to filter on.
        :type name: str
        :param md5: MD5 sum of the media file.
        :type md5: str
        :param after: If given, all results returned will be after the file with this filename. The `start` and `stop` parameters are relative to this modified range.
        :type after: str
        :param search: Lucene query syntax string for use with Elasticsearch. See `reference <https://lucene.apache.org/core/2_9_4/queryparsersyntax.html>`_.
        :type search: str
        :param attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute: str
        :param attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lt: str
        :param attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lte: str
        :param attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gt: str
        :param attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gte: str
        :param attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_contains: str
        :param attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :type attribute_distance: str
        :param attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :type attribute_null: str
        :param operation: Set to \"count\" to return a count of objects instead of the objects.
        :type operation: str
        :param start: Pagination start index. Index of the first item in a larger list to return.
        :type start: int
        :param stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :type stop: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MessageResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_media_list_with_http_info(project, **kwargs)  # noqa: E501

    def delete_media_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """delete_media_list  # noqa: E501

        Delete state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_media_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param media_id: List of integers identifying media.
        :type media_id: list[int]
        :param type: Unique integer identifying media type.
        :type type: int
        :param name: Name of the media to filter on.
        :type name: str
        :param md5: MD5 sum of the media file.
        :type md5: str
        :param after: If given, all results returned will be after the file with this filename. The `start` and `stop` parameters are relative to this modified range.
        :type after: str
        :param search: Lucene query syntax string for use with Elasticsearch. See `reference <https://lucene.apache.org/core/2_9_4/queryparsersyntax.html>`_.
        :type search: str
        :param attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute: str
        :param attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lt: str
        :param attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lte: str
        :param attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gt: str
        :param attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gte: str
        :param attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_contains: str
        :param attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :type attribute_distance: str
        :param attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :type attribute_null: str
        :param operation: Set to \"count\" to return a count of objects instead of the objects.
        :type operation: str
        :param start: Pagination start index. Index of the first item in a larger list to return.
        :type start: int
        :param stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :type stop: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MessageResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'project',
            'media_id',
            'type',
            'name',
            'md5',
            'after',
            'search',
            'attribute',
            'attribute_lt',
            'attribute_lte',
            'attribute_gt',
            'attribute_gte',
            'attribute_contains',
            'attribute_distance',
            'attribute_null',
            'operation',
            'start',
            'stop'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_media_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `delete_media_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'media_id' in local_var_params and local_var_params['media_id'] is not None:  # noqa: E501
            query_params.append(('media_id', local_var_params['media_id']))  # noqa: E501
            collection_formats['media_id'] = 'csv'  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'md5' in local_var_params and local_var_params['md5'] is not None:  # noqa: E501
            query_params.append(('md5', local_var_params['md5']))  # noqa: E501
        if 'after' in local_var_params and local_var_params['after'] is not None:  # noqa: E501
            query_params.append(('after', local_var_params['after']))  # noqa: E501
        if 'search' in local_var_params and local_var_params['search'] is not None:  # noqa: E501
            query_params.append(('search', local_var_params['search']))  # noqa: E501
        if 'attribute' in local_var_params and local_var_params['attribute'] is not None:  # noqa: E501
            query_params.append(('attribute', local_var_params['attribute']))  # noqa: E501
        if 'attribute_lt' in local_var_params and local_var_params['attribute_lt'] is not None:  # noqa: E501
            query_params.append(('attribute_lt', local_var_params['attribute_lt']))  # noqa: E501
        if 'attribute_lte' in local_var_params and local_var_params['attribute_lte'] is not None:  # noqa: E501
            query_params.append(('attribute_lte', local_var_params['attribute_lte']))  # noqa: E501
        if 'attribute_gt' in local_var_params and local_var_params['attribute_gt'] is not None:  # noqa: E501
            query_params.append(('attribute_gt', local_var_params['attribute_gt']))  # noqa: E501
        if 'attribute_gte' in local_var_params and local_var_params['attribute_gte'] is not None:  # noqa: E501
            query_params.append(('attribute_gte', local_var_params['attribute_gte']))  # noqa: E501
        if 'attribute_contains' in local_var_params and local_var_params['attribute_contains'] is not None:  # noqa: E501
            query_params.append(('attribute_contains', local_var_params['attribute_contains']))  # noqa: E501
        if 'attribute_distance' in local_var_params and local_var_params['attribute_distance'] is not None:  # noqa: E501
            query_params.append(('attribute_distance', local_var_params['attribute_distance']))  # noqa: E501
        if 'attribute_null' in local_var_params and local_var_params['attribute_null'] is not None:  # noqa: E501
            query_params.append(('attribute_null', local_var_params['attribute_null']))  # noqa: E501
        if 'operation' in local_var_params and local_var_params['operation'] is not None:  # noqa: E501
            query_params.append(('operation', local_var_params['operation']))  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'stop' in local_var_params and local_var_params['stop'] is not None:  # noqa: E501
            query_params.append(('stop', local_var_params['stop']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Medias/{project}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_media_type(self, id, **kwargs):  # noqa: E501
        """delete_media_type  # noqa: E501

        Delete state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_media_type(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying an media type. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MessageResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_media_type_with_http_info(id, **kwargs)  # noqa: E501

    def delete_media_type_with_http_info(self, id, **kwargs):  # noqa: E501
        """delete_media_type  # noqa: E501

        Delete state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_media_type_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying an media type. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MessageResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_media_type" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_media_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/MediaType/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_membership(self, id, **kwargs):  # noqa: E501
        """delete_membership  # noqa: E501

        Delete state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_membership(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a membership. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MessageResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_membership_with_http_info(id, **kwargs)  # noqa: E501

    def delete_membership_with_http_info(self, id, **kwargs):  # noqa: E501
        """delete_membership  # noqa: E501

        Delete state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_membership_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a membership. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MessageResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_membership" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_membership`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Membership/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_project(self, id, **kwargs):  # noqa: E501
        """delete_project  # noqa: E501

        Delete state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_project(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a project. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MessageResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_project_with_http_info(id, **kwargs)  # noqa: E501

    def delete_project_with_http_info(self, id, **kwargs):  # noqa: E501
        """delete_project  # noqa: E501

        Delete state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_project_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a project. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MessageResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_project" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Project/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_state(self, id, **kwargs):  # noqa: E501
        """delete_state  # noqa: E501

        Delete state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_state(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a state. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MessageResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_state_with_http_info(id, **kwargs)  # noqa: E501

    def delete_state_with_http_info(self, id, **kwargs):  # noqa: E501
        """delete_state  # noqa: E501

        Delete state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_state_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a state. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MessageResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_state" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_state`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/State/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_state_list(self, project, **kwargs):  # noqa: E501
        """delete_state_list  # noqa: E501

        Delete state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_state_list(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param media_query: Query string used to filter media IDs. If supplied, media_id will be ignored.
        :type media_query: str
        :param media_id: Comma-separated list of media IDs.
        :type media_id: list[int]
        :param type: Unique integer identifying a annotation type.
        :type type: int
        :param version: List of integers representing versions to fetch
        :type version: list[int]
        :param modified: Whether to return original or modified annotations, 0 or 1.
        :type modified: int
        :param after: If given, all results returned will be after the localization with this ID. The `start` and `stop` parameters are relative to this modified range.
        :type after: int
        :param search: Lucene query syntax string for use with Elasticsearch. See `reference <https://lucene.apache.org/core/2_9_4/queryparsersyntax.html>`_.
        :type search: str
        :param attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute: str
        :param attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lt: str
        :param attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lte: str
        :param attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gt: str
        :param attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gte: str
        :param attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_contains: str
        :param attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :type attribute_distance: str
        :param attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :type attribute_null: str
        :param operation: Set to \"count\" to return a count of objects instead of the objects.
        :type operation: str
        :param start: Pagination start index. Index of the first item in a larger list to return.
        :type start: int
        :param stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :type stop: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MessageResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_state_list_with_http_info(project, **kwargs)  # noqa: E501

    def delete_state_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """delete_state_list  # noqa: E501

        Delete state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_state_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param media_query: Query string used to filter media IDs. If supplied, media_id will be ignored.
        :type media_query: str
        :param media_id: Comma-separated list of media IDs.
        :type media_id: list[int]
        :param type: Unique integer identifying a annotation type.
        :type type: int
        :param version: List of integers representing versions to fetch
        :type version: list[int]
        :param modified: Whether to return original or modified annotations, 0 or 1.
        :type modified: int
        :param after: If given, all results returned will be after the localization with this ID. The `start` and `stop` parameters are relative to this modified range.
        :type after: int
        :param search: Lucene query syntax string for use with Elasticsearch. See `reference <https://lucene.apache.org/core/2_9_4/queryparsersyntax.html>`_.
        :type search: str
        :param attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute: str
        :param attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lt: str
        :param attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lte: str
        :param attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gt: str
        :param attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gte: str
        :param attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_contains: str
        :param attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :type attribute_distance: str
        :param attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :type attribute_null: str
        :param operation: Set to \"count\" to return a count of objects instead of the objects.
        :type operation: str
        :param start: Pagination start index. Index of the first item in a larger list to return.
        :type start: int
        :param stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :type stop: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MessageResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'project',
            'media_query',
            'media_id',
            'type',
            'version',
            'modified',
            'after',
            'search',
            'attribute',
            'attribute_lt',
            'attribute_lte',
            'attribute_gt',
            'attribute_gte',
            'attribute_contains',
            'attribute_distance',
            'attribute_null',
            'operation',
            'start',
            'stop'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_state_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `delete_state_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'media_query' in local_var_params and local_var_params['media_query'] is not None:  # noqa: E501
            query_params.append(('media_query', local_var_params['media_query']))  # noqa: E501
        if 'media_id' in local_var_params and local_var_params['media_id'] is not None:  # noqa: E501
            query_params.append(('media_id', local_var_params['media_id']))  # noqa: E501
            collection_formats['media_id'] = 'csv'  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'version' in local_var_params and local_var_params['version'] is not None:  # noqa: E501
            query_params.append(('version', local_var_params['version']))  # noqa: E501
            collection_formats['version'] = 'csv'  # noqa: E501
        if 'modified' in local_var_params and local_var_params['modified'] is not None:  # noqa: E501
            query_params.append(('modified', local_var_params['modified']))  # noqa: E501
        if 'after' in local_var_params and local_var_params['after'] is not None:  # noqa: E501
            query_params.append(('after', local_var_params['after']))  # noqa: E501
        if 'search' in local_var_params and local_var_params['search'] is not None:  # noqa: E501
            query_params.append(('search', local_var_params['search']))  # noqa: E501
        if 'attribute' in local_var_params and local_var_params['attribute'] is not None:  # noqa: E501
            query_params.append(('attribute', local_var_params['attribute']))  # noqa: E501
        if 'attribute_lt' in local_var_params and local_var_params['attribute_lt'] is not None:  # noqa: E501
            query_params.append(('attribute_lt', local_var_params['attribute_lt']))  # noqa: E501
        if 'attribute_lte' in local_var_params and local_var_params['attribute_lte'] is not None:  # noqa: E501
            query_params.append(('attribute_lte', local_var_params['attribute_lte']))  # noqa: E501
        if 'attribute_gt' in local_var_params and local_var_params['attribute_gt'] is not None:  # noqa: E501
            query_params.append(('attribute_gt', local_var_params['attribute_gt']))  # noqa: E501
        if 'attribute_gte' in local_var_params and local_var_params['attribute_gte'] is not None:  # noqa: E501
            query_params.append(('attribute_gte', local_var_params['attribute_gte']))  # noqa: E501
        if 'attribute_contains' in local_var_params and local_var_params['attribute_contains'] is not None:  # noqa: E501
            query_params.append(('attribute_contains', local_var_params['attribute_contains']))  # noqa: E501
        if 'attribute_distance' in local_var_params and local_var_params['attribute_distance'] is not None:  # noqa: E501
            query_params.append(('attribute_distance', local_var_params['attribute_distance']))  # noqa: E501
        if 'attribute_null' in local_var_params and local_var_params['attribute_null'] is not None:  # noqa: E501
            query_params.append(('attribute_null', local_var_params['attribute_null']))  # noqa: E501
        if 'operation' in local_var_params and local_var_params['operation'] is not None:  # noqa: E501
            query_params.append(('operation', local_var_params['operation']))  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'stop' in local_var_params and local_var_params['stop'] is not None:  # noqa: E501
            query_params.append(('stop', local_var_params['stop']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/States/{project}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_state_type(self, id, **kwargs):  # noqa: E501
        """delete_state_type  # noqa: E501

        Delete state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_state_type(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a state type. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MessageResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_state_type_with_http_info(id, **kwargs)  # noqa: E501

    def delete_state_type_with_http_info(self, id, **kwargs):  # noqa: E501
        """delete_state_type  # noqa: E501

        Delete state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_state_type_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a state type. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MessageResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_state_type" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_state_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/StateType/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_temporary_file(self, id, **kwargs):  # noqa: E501
        """delete_temporary_file  # noqa: E501

        Delete state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_temporary_file(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a temporary file. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MessageResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_temporary_file_with_http_info(id, **kwargs)  # noqa: E501

    def delete_temporary_file_with_http_info(self, id, **kwargs):  # noqa: E501
        """delete_temporary_file  # noqa: E501

        Delete state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_temporary_file_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a temporary file. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MessageResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_temporary_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_temporary_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/TemporaryFile/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_temporary_file_list(self, project, **kwargs):  # noqa: E501
        """delete_temporary_file_list  # noqa: E501

        Delete state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_temporary_file_list(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param expired: If greater than 0 will return only expired files
        :type expired: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_temporary_file_list_with_http_info(project, **kwargs)  # noqa: E501

    def delete_temporary_file_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """delete_temporary_file_list  # noqa: E501

        Delete state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_temporary_file_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param expired: If greater than 0 will return only expired files
        :type expired: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'project',
            'expired'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_temporary_file_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `delete_temporary_file_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'expired' in local_var_params and local_var_params['expired'] is not None:  # noqa: E501
            query_params.append(('expired', local_var_params['expired']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/TemporaryFiles/{project}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_version(self, id, **kwargs):  # noqa: E501
        """delete_version  # noqa: E501

        Delete state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_version(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a version. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MessageResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_version_with_http_info(id, **kwargs)  # noqa: E501

    def delete_version_with_http_info(self, id, **kwargs):  # noqa: E501
        """delete_version  # noqa: E501

        Delete state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_version_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a version. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MessageResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_version" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_version`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Version/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_algorithm_list(self, project, **kwargs):  # noqa: E501
        """get_algorithm_list  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_algorithm_list(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[Algorithm]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_algorithm_list_with_http_info(project, **kwargs)  # noqa: E501

    def get_algorithm_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """get_algorithm_list  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_algorithm_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[Algorithm], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'project'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_algorithm_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_algorithm_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Algorithms/{project}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Algorithm]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_analysis_list(self, project, **kwargs):  # noqa: E501
        """get_analysis_list  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_analysis_list(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[Analysis]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_analysis_list_with_http_info(project, **kwargs)  # noqa: E501

    def get_analysis_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """get_analysis_list  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_analysis_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[Analysis], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'project'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_analysis_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_analysis_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Analyses/{project}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Analysis]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_clip(self, id, frame_ranges, **kwargs):  # noqa: E501
        """get_clip  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_clip(id, frame_ranges, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a media object. (required)
        :type id: int
        :param frame_ranges: Comma-seperated list of frame ranges to capture. (required)
        :type frame_ranges: list[str]
        :param quality: Source resolution to use (default to highest quality)
        :type quality: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: file
        """
        kwargs['_return_http_data_only'] = True
        return self.get_clip_with_http_info(id, frame_ranges, **kwargs)  # noqa: E501

    def get_clip_with_http_info(self, id, frame_ranges, **kwargs):  # noqa: E501
        """get_clip  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_clip_with_http_info(id, frame_ranges, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a media object. (required)
        :type id: int
        :param frame_ranges: Comma-seperated list of frame ranges to capture. (required)
        :type frame_ranges: list[str]
        :param quality: Source resolution to use (default to highest quality)
        :type quality: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(file, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id',
            'frame_ranges',
            'quality'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_clip" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_clip`")  # noqa: E501
        # verify the required parameter 'frame_ranges' is set
        if self.api_client.client_side_validation and ('frame_ranges' not in local_var_params or  # noqa: E501
                                                        local_var_params['frame_ranges'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `frame_ranges` when calling `get_clip`")  # noqa: E501

        if self.api_client.client_side_validation and 'quality' in local_var_params and local_var_params['quality'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `quality` when calling `get_clip`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'frame_ranges' in local_var_params and local_var_params['frame_ranges'] is not None:  # noqa: E501
            query_params.append(('frameRanges', local_var_params['frame_ranges']))  # noqa: E501
            collection_formats['frameRanges'] = 'csv'  # noqa: E501
        if 'quality' in local_var_params and local_var_params['quality'] is not None:  # noqa: E501
            query_params.append(('quality', local_var_params['quality']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['video/*', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/GetClip/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_frame(self, id, **kwargs):  # noqa: E501
        """get_frame  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_frame(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a media object. (required)
        :type id: int
        :param frames: Comma-seperated list of frames to capture.
        :type frames: list[int]
        :param tile: wxh, if not supplied is made as squarish as possible.
        :type tile: str
        :param roi: w:h:x:y, optionally crop each frame to a given roi in relative coordinates.
        :type roi: str
        :param animate: If not tiling, animate each frame at a given fps in a gif.
        :type animate: int
        :param quality: Source resolution to use (default to highest quality)
        :type quality: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: file
        """
        kwargs['_return_http_data_only'] = True
        return self.get_frame_with_http_info(id, **kwargs)  # noqa: E501

    def get_frame_with_http_info(self, id, **kwargs):  # noqa: E501
        """get_frame  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_frame_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a media object. (required)
        :type id: int
        :param frames: Comma-seperated list of frames to capture.
        :type frames: list[int]
        :param tile: wxh, if not supplied is made as squarish as possible.
        :type tile: str
        :param roi: w:h:x:y, optionally crop each frame to a given roi in relative coordinates.
        :type roi: str
        :param animate: If not tiling, animate each frame at a given fps in a gif.
        :type animate: int
        :param quality: Source resolution to use (default to highest quality)
        :type quality: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(file, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id',
            'frames',
            'tile',
            'roi',
            'animate',
            'quality'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_frame" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_frame`")  # noqa: E501

        if self.api_client.client_side_validation and ('frames' in local_var_params and  # noqa: E501
                                                        len(local_var_params['frames']) > 32):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `frames` when calling `get_frame`, length must be less than or equal to `32`")  # noqa: E501
        if self.api_client.client_side_validation and 'animate' in local_var_params and local_var_params['animate'] > 15:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `animate` when calling `get_frame`, must be a value less than or equal to `15`")  # noqa: E501
        if self.api_client.client_side_validation and 'animate' in local_var_params and local_var_params['animate'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `animate` when calling `get_frame`, must be a value greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'quality' in local_var_params and local_var_params['quality'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `quality` when calling `get_frame`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'frames' in local_var_params and local_var_params['frames'] is not None:  # noqa: E501
            query_params.append(('frames', local_var_params['frames']))  # noqa: E501
            collection_formats['frames'] = 'csv'  # noqa: E501
        if 'tile' in local_var_params and local_var_params['tile'] is not None:  # noqa: E501
            query_params.append(('tile', local_var_params['tile']))  # noqa: E501
        if 'roi' in local_var_params and local_var_params['roi'] is not None:  # noqa: E501
            query_params.append(('roi', local_var_params['roi']))  # noqa: E501
        if 'animate' in local_var_params and local_var_params['animate'] is not None:  # noqa: E501
            query_params.append(('animate', local_var_params['animate']))  # noqa: E501
        if 'quality' in local_var_params and local_var_params['quality'] is not None:  # noqa: E501
            query_params.append(('quality', local_var_params['quality']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['image/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/GetFrame/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_leaf(self, id, **kwargs):  # noqa: E501
        """get_leaf  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_leaf(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a leaf. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Leaf
        """
        kwargs['_return_http_data_only'] = True
        return self.get_leaf_with_http_info(id, **kwargs)  # noqa: E501

    def get_leaf_with_http_info(self, id, **kwargs):  # noqa: E501
        """get_leaf  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_leaf_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a leaf. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Leaf, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_leaf" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_leaf`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Leaf/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Leaf',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_leaf_list(self, project, **kwargs):  # noqa: E501
        """get_leaf_list  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_leaf_list(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param ancestor: Get descendents of a leaf element (inclusive), by path (i.e. ITIS.Animalia).
        :type ancestor: str
        :param type: Unique integer identifying a leaf type.
        :type type: int
        :param name: Name of the leaf element.
        :type name: str
        :param attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute: str
        :param attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lt: str
        :param attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lte: str
        :param attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gt: str
        :param attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gte: str
        :param attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_contains: str
        :param attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :type attribute_distance: str
        :param attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :type attribute_null: str
        :param operation: Set to \"count\" to return a count of objects instead of the objects.
        :type operation: str
        :param start: Pagination start index. Index of the first item in a larger list to return.
        :type start: int
        :param stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :type stop: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[Leaf]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_leaf_list_with_http_info(project, **kwargs)  # noqa: E501

    def get_leaf_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """get_leaf_list  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_leaf_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param ancestor: Get descendents of a leaf element (inclusive), by path (i.e. ITIS.Animalia).
        :type ancestor: str
        :param type: Unique integer identifying a leaf type.
        :type type: int
        :param name: Name of the leaf element.
        :type name: str
        :param attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute: str
        :param attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lt: str
        :param attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lte: str
        :param attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gt: str
        :param attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gte: str
        :param attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_contains: str
        :param attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :type attribute_distance: str
        :param attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :type attribute_null: str
        :param operation: Set to \"count\" to return a count of objects instead of the objects.
        :type operation: str
        :param start: Pagination start index. Index of the first item in a larger list to return.
        :type start: int
        :param stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :type stop: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[Leaf], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'project',
            'ancestor',
            'type',
            'name',
            'attribute',
            'attribute_lt',
            'attribute_lte',
            'attribute_gt',
            'attribute_gte',
            'attribute_contains',
            'attribute_distance',
            'attribute_null',
            'operation',
            'start',
            'stop'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_leaf_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_leaf_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'ancestor' in local_var_params and local_var_params['ancestor'] is not None:  # noqa: E501
            query_params.append(('ancestor', local_var_params['ancestor']))  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'attribute' in local_var_params and local_var_params['attribute'] is not None:  # noqa: E501
            query_params.append(('attribute', local_var_params['attribute']))  # noqa: E501
        if 'attribute_lt' in local_var_params and local_var_params['attribute_lt'] is not None:  # noqa: E501
            query_params.append(('attribute_lt', local_var_params['attribute_lt']))  # noqa: E501
        if 'attribute_lte' in local_var_params and local_var_params['attribute_lte'] is not None:  # noqa: E501
            query_params.append(('attribute_lte', local_var_params['attribute_lte']))  # noqa: E501
        if 'attribute_gt' in local_var_params and local_var_params['attribute_gt'] is not None:  # noqa: E501
            query_params.append(('attribute_gt', local_var_params['attribute_gt']))  # noqa: E501
        if 'attribute_gte' in local_var_params and local_var_params['attribute_gte'] is not None:  # noqa: E501
            query_params.append(('attribute_gte', local_var_params['attribute_gte']))  # noqa: E501
        if 'attribute_contains' in local_var_params and local_var_params['attribute_contains'] is not None:  # noqa: E501
            query_params.append(('attribute_contains', local_var_params['attribute_contains']))  # noqa: E501
        if 'attribute_distance' in local_var_params and local_var_params['attribute_distance'] is not None:  # noqa: E501
            query_params.append(('attribute_distance', local_var_params['attribute_distance']))  # noqa: E501
        if 'attribute_null' in local_var_params and local_var_params['attribute_null'] is not None:  # noqa: E501
            query_params.append(('attribute_null', local_var_params['attribute_null']))  # noqa: E501
        if 'operation' in local_var_params and local_var_params['operation'] is not None:  # noqa: E501
            query_params.append(('operation', local_var_params['operation']))  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'stop' in local_var_params and local_var_params['stop'] is not None:  # noqa: E501
            query_params.append(('stop', local_var_params['stop']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Leaves/{project}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Leaf]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_leaf_type(self, id, **kwargs):  # noqa: E501
        """get_leaf_type  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_leaf_type(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying an leaf type. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: LeafType
        """
        kwargs['_return_http_data_only'] = True
        return self.get_leaf_type_with_http_info(id, **kwargs)  # noqa: E501

    def get_leaf_type_with_http_info(self, id, **kwargs):  # noqa: E501
        """get_leaf_type  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_leaf_type_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying an leaf type. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(LeafType, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_leaf_type" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_leaf_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/LeafType/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LeafType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_leaf_type_list(self, project, **kwargs):  # noqa: E501
        """get_leaf_type_list  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_leaf_type_list(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[LeafType]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_leaf_type_list_with_http_info(project, **kwargs)  # noqa: E501

    def get_leaf_type_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """get_leaf_type_list  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_leaf_type_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[LeafType], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'project'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_leaf_type_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_leaf_type_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/LeafTypes/{project}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[LeafType]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_localization(self, id, **kwargs):  # noqa: E501
        """get_localization  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_localization(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a localization. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Localization
        """
        kwargs['_return_http_data_only'] = True
        return self.get_localization_with_http_info(id, **kwargs)  # noqa: E501

    def get_localization_with_http_info(self, id, **kwargs):  # noqa: E501
        """get_localization  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_localization_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a localization. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Localization, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_localization" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_localization`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Localization/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Localization',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_localization_list(self, project, **kwargs):  # noqa: E501
        """get_localization_list  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_localization_list(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param media_query: Query string used to filter media IDs. If supplied, media_id will be ignored.
        :type media_query: str
        :param media_id: Comma-separated list of media IDs.
        :type media_id: list[int]
        :param type: Unique integer identifying a annotation type.
        :type type: int
        :param version: List of integers representing versions to fetch
        :type version: list[int]
        :param modified: Whether to return original or modified annotations, 0 or 1.
        :type modified: int
        :param after: If given, all results returned will be after the localization with this ID. The `start` and `stop` parameters are relative to this modified range.
        :type after: int
        :param search: Lucene query syntax string for use with Elasticsearch. See `reference <https://lucene.apache.org/core/2_9_4/queryparsersyntax.html>`_.
        :type search: str
        :param attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute: str
        :param attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lt: str
        :param attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lte: str
        :param attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gt: str
        :param attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gte: str
        :param attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_contains: str
        :param attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :type attribute_distance: str
        :param attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :type attribute_null: str
        :param operation: Set to \"count\" to return a count of objects instead of the objects.
        :type operation: str
        :param start: Pagination start index. Index of the first item in a larger list to return.
        :type start: int
        :param stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :type stop: int
        :param exclude_parents: If a clone is present, do not send parent. (0 or 1)
        :type exclude_parents: int
        :param frame: Frame number of this localization if it is in a video.
        :type frame: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[Localization]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_localization_list_with_http_info(project, **kwargs)  # noqa: E501

    def get_localization_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """get_localization_list  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_localization_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param media_query: Query string used to filter media IDs. If supplied, media_id will be ignored.
        :type media_query: str
        :param media_id: Comma-separated list of media IDs.
        :type media_id: list[int]
        :param type: Unique integer identifying a annotation type.
        :type type: int
        :param version: List of integers representing versions to fetch
        :type version: list[int]
        :param modified: Whether to return original or modified annotations, 0 or 1.
        :type modified: int
        :param after: If given, all results returned will be after the localization with this ID. The `start` and `stop` parameters are relative to this modified range.
        :type after: int
        :param search: Lucene query syntax string for use with Elasticsearch. See `reference <https://lucene.apache.org/core/2_9_4/queryparsersyntax.html>`_.
        :type search: str
        :param attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute: str
        :param attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lt: str
        :param attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lte: str
        :param attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gt: str
        :param attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gte: str
        :param attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_contains: str
        :param attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :type attribute_distance: str
        :param attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :type attribute_null: str
        :param operation: Set to \"count\" to return a count of objects instead of the objects.
        :type operation: str
        :param start: Pagination start index. Index of the first item in a larger list to return.
        :type start: int
        :param stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :type stop: int
        :param exclude_parents: If a clone is present, do not send parent. (0 or 1)
        :type exclude_parents: int
        :param frame: Frame number of this localization if it is in a video.
        :type frame: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[Localization], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'project',
            'media_query',
            'media_id',
            'type',
            'version',
            'modified',
            'after',
            'search',
            'attribute',
            'attribute_lt',
            'attribute_lte',
            'attribute_gt',
            'attribute_gte',
            'attribute_contains',
            'attribute_distance',
            'attribute_null',
            'operation',
            'start',
            'stop',
            'exclude_parents',
            'frame'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_localization_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_localization_list`")  # noqa: E501

        if self.api_client.client_side_validation and 'exclude_parents' in local_var_params and local_var_params['exclude_parents'] > 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `exclude_parents` when calling `get_localization_list`, must be a value less than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'exclude_parents' in local_var_params and local_var_params['exclude_parents'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `exclude_parents` when calling `get_localization_list`, must be a value greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'frame' in local_var_params and local_var_params['frame'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `frame` when calling `get_localization_list`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'media_query' in local_var_params and local_var_params['media_query'] is not None:  # noqa: E501
            query_params.append(('media_query', local_var_params['media_query']))  # noqa: E501
        if 'media_id' in local_var_params and local_var_params['media_id'] is not None:  # noqa: E501
            query_params.append(('media_id', local_var_params['media_id']))  # noqa: E501
            collection_formats['media_id'] = 'csv'  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'version' in local_var_params and local_var_params['version'] is not None:  # noqa: E501
            query_params.append(('version', local_var_params['version']))  # noqa: E501
            collection_formats['version'] = 'csv'  # noqa: E501
        if 'modified' in local_var_params and local_var_params['modified'] is not None:  # noqa: E501
            query_params.append(('modified', local_var_params['modified']))  # noqa: E501
        if 'after' in local_var_params and local_var_params['after'] is not None:  # noqa: E501
            query_params.append(('after', local_var_params['after']))  # noqa: E501
        if 'search' in local_var_params and local_var_params['search'] is not None:  # noqa: E501
            query_params.append(('search', local_var_params['search']))  # noqa: E501
        if 'attribute' in local_var_params and local_var_params['attribute'] is not None:  # noqa: E501
            query_params.append(('attribute', local_var_params['attribute']))  # noqa: E501
        if 'attribute_lt' in local_var_params and local_var_params['attribute_lt'] is not None:  # noqa: E501
            query_params.append(('attribute_lt', local_var_params['attribute_lt']))  # noqa: E501
        if 'attribute_lte' in local_var_params and local_var_params['attribute_lte'] is not None:  # noqa: E501
            query_params.append(('attribute_lte', local_var_params['attribute_lte']))  # noqa: E501
        if 'attribute_gt' in local_var_params and local_var_params['attribute_gt'] is not None:  # noqa: E501
            query_params.append(('attribute_gt', local_var_params['attribute_gt']))  # noqa: E501
        if 'attribute_gte' in local_var_params and local_var_params['attribute_gte'] is not None:  # noqa: E501
            query_params.append(('attribute_gte', local_var_params['attribute_gte']))  # noqa: E501
        if 'attribute_contains' in local_var_params and local_var_params['attribute_contains'] is not None:  # noqa: E501
            query_params.append(('attribute_contains', local_var_params['attribute_contains']))  # noqa: E501
        if 'attribute_distance' in local_var_params and local_var_params['attribute_distance'] is not None:  # noqa: E501
            query_params.append(('attribute_distance', local_var_params['attribute_distance']))  # noqa: E501
        if 'attribute_null' in local_var_params and local_var_params['attribute_null'] is not None:  # noqa: E501
            query_params.append(('attribute_null', local_var_params['attribute_null']))  # noqa: E501
        if 'operation' in local_var_params and local_var_params['operation'] is not None:  # noqa: E501
            query_params.append(('operation', local_var_params['operation']))  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'stop' in local_var_params and local_var_params['stop'] is not None:  # noqa: E501
            query_params.append(('stop', local_var_params['stop']))  # noqa: E501
        if 'exclude_parents' in local_var_params and local_var_params['exclude_parents'] is not None:  # noqa: E501
            query_params.append(('excludeParents', local_var_params['exclude_parents']))  # noqa: E501
        if 'frame' in local_var_params and local_var_params['frame'] is not None:  # noqa: E501
            query_params.append(('frame', local_var_params['frame']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Localizations/{project}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Localization]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_localization_type(self, id, **kwargs):  # noqa: E501
        """get_localization_type  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_localization_type(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying an localization type. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: LocalizationType
        """
        kwargs['_return_http_data_only'] = True
        return self.get_localization_type_with_http_info(id, **kwargs)  # noqa: E501

    def get_localization_type_with_http_info(self, id, **kwargs):  # noqa: E501
        """get_localization_type  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_localization_type_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying an localization type. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(LocalizationType, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_localization_type" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_localization_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/LocalizationType/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LocalizationType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_localization_type_list(self, project, **kwargs):  # noqa: E501
        """get_localization_type_list  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_localization_type_list(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param media_id: List of unique integers identifying a media.
        :type media_id: list[int]
        :param type: Deprecated. Use `LocalizationType` endpoint to retrieve individual localization type by ID.
        :type type: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[LocalizationType]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_localization_type_list_with_http_info(project, **kwargs)  # noqa: E501

    def get_localization_type_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """get_localization_type_list  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_localization_type_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param media_id: List of unique integers identifying a media.
        :type media_id: list[int]
        :param type: Deprecated. Use `LocalizationType` endpoint to retrieve individual localization type by ID.
        :type type: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[LocalizationType], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'project',
            'media_id',
            'type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_localization_type_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_localization_type_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'media_id' in local_var_params and local_var_params['media_id'] is not None:  # noqa: E501
            query_params.append(('media_id', local_var_params['media_id']))  # noqa: E501
            collection_formats['media_id'] = 'csv'  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/LocalizationTypes/{project}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[LocalizationType]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_media(self, id, **kwargs):  # noqa: E501
        """get_media  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_media(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a media. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Media
        """
        kwargs['_return_http_data_only'] = True
        return self.get_media_with_http_info(id, **kwargs)  # noqa: E501

    def get_media_with_http_info(self, id, **kwargs):  # noqa: E501
        """get_media  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_media_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a media. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Media, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_media" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_media`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Media/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Media',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_media_list(self, project, **kwargs):  # noqa: E501
        """get_media_list  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_media_list(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param media_id: List of integers identifying media.
        :type media_id: list[int]
        :param type: Unique integer identifying media type.
        :type type: int
        :param name: Name of the media to filter on.
        :type name: str
        :param md5: MD5 sum of the media file.
        :type md5: str
        :param after: If given, all results returned will be after the file with this filename. The `start` and `stop` parameters are relative to this modified range.
        :type after: str
        :param search: Lucene query syntax string for use with Elasticsearch. See `reference <https://lucene.apache.org/core/2_9_4/queryparsersyntax.html>`_.
        :type search: str
        :param attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute: str
        :param attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lt: str
        :param attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lte: str
        :param attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gt: str
        :param attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gte: str
        :param attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_contains: str
        :param attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :type attribute_distance: str
        :param attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :type attribute_null: str
        :param operation: Set to \"count\" to return a count of objects instead of the objects.
        :type operation: str
        :param start: Pagination start index. Index of the first item in a larger list to return.
        :type start: int
        :param stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :type stop: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[Media]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_media_list_with_http_info(project, **kwargs)  # noqa: E501

    def get_media_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """get_media_list  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_media_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param media_id: List of integers identifying media.
        :type media_id: list[int]
        :param type: Unique integer identifying media type.
        :type type: int
        :param name: Name of the media to filter on.
        :type name: str
        :param md5: MD5 sum of the media file.
        :type md5: str
        :param after: If given, all results returned will be after the file with this filename. The `start` and `stop` parameters are relative to this modified range.
        :type after: str
        :param search: Lucene query syntax string for use with Elasticsearch. See `reference <https://lucene.apache.org/core/2_9_4/queryparsersyntax.html>`_.
        :type search: str
        :param attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute: str
        :param attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lt: str
        :param attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lte: str
        :param attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gt: str
        :param attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gte: str
        :param attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_contains: str
        :param attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :type attribute_distance: str
        :param attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :type attribute_null: str
        :param operation: Set to \"count\" to return a count of objects instead of the objects.
        :type operation: str
        :param start: Pagination start index. Index of the first item in a larger list to return.
        :type start: int
        :param stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :type stop: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[Media], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'project',
            'media_id',
            'type',
            'name',
            'md5',
            'after',
            'search',
            'attribute',
            'attribute_lt',
            'attribute_lte',
            'attribute_gt',
            'attribute_gte',
            'attribute_contains',
            'attribute_distance',
            'attribute_null',
            'operation',
            'start',
            'stop'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_media_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_media_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'media_id' in local_var_params and local_var_params['media_id'] is not None:  # noqa: E501
            query_params.append(('media_id', local_var_params['media_id']))  # noqa: E501
            collection_formats['media_id'] = 'csv'  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'md5' in local_var_params and local_var_params['md5'] is not None:  # noqa: E501
            query_params.append(('md5', local_var_params['md5']))  # noqa: E501
        if 'after' in local_var_params and local_var_params['after'] is not None:  # noqa: E501
            query_params.append(('after', local_var_params['after']))  # noqa: E501
        if 'search' in local_var_params and local_var_params['search'] is not None:  # noqa: E501
            query_params.append(('search', local_var_params['search']))  # noqa: E501
        if 'attribute' in local_var_params and local_var_params['attribute'] is not None:  # noqa: E501
            query_params.append(('attribute', local_var_params['attribute']))  # noqa: E501
        if 'attribute_lt' in local_var_params and local_var_params['attribute_lt'] is not None:  # noqa: E501
            query_params.append(('attribute_lt', local_var_params['attribute_lt']))  # noqa: E501
        if 'attribute_lte' in local_var_params and local_var_params['attribute_lte'] is not None:  # noqa: E501
            query_params.append(('attribute_lte', local_var_params['attribute_lte']))  # noqa: E501
        if 'attribute_gt' in local_var_params and local_var_params['attribute_gt'] is not None:  # noqa: E501
            query_params.append(('attribute_gt', local_var_params['attribute_gt']))  # noqa: E501
        if 'attribute_gte' in local_var_params and local_var_params['attribute_gte'] is not None:  # noqa: E501
            query_params.append(('attribute_gte', local_var_params['attribute_gte']))  # noqa: E501
        if 'attribute_contains' in local_var_params and local_var_params['attribute_contains'] is not None:  # noqa: E501
            query_params.append(('attribute_contains', local_var_params['attribute_contains']))  # noqa: E501
        if 'attribute_distance' in local_var_params and local_var_params['attribute_distance'] is not None:  # noqa: E501
            query_params.append(('attribute_distance', local_var_params['attribute_distance']))  # noqa: E501
        if 'attribute_null' in local_var_params and local_var_params['attribute_null'] is not None:  # noqa: E501
            query_params.append(('attribute_null', local_var_params['attribute_null']))  # noqa: E501
        if 'operation' in local_var_params and local_var_params['operation'] is not None:  # noqa: E501
            query_params.append(('operation', local_var_params['operation']))  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'stop' in local_var_params and local_var_params['stop'] is not None:  # noqa: E501
            query_params.append(('stop', local_var_params['stop']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Medias/{project}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Media]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_media_next(self, id, **kwargs):  # noqa: E501
        """get_media_next  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_media_next(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a media object. (required)
        :type id: int
        :param media_id: List of integers identifying media.
        :type media_id: list[int]
        :param type: Unique integer identifying media type.
        :type type: int
        :param name: Name of the media to filter on.
        :type name: str
        :param md5: MD5 sum of the media file.
        :type md5: str
        :param after: If given, all results returned will be after the file with this filename. The `start` and `stop` parameters are relative to this modified range.
        :type after: str
        :param search: Lucene query syntax string for use with Elasticsearch. See `reference <https://lucene.apache.org/core/2_9_4/queryparsersyntax.html>`_.
        :type search: str
        :param attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute: str
        :param attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lt: str
        :param attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lte: str
        :param attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gt: str
        :param attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gte: str
        :param attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_contains: str
        :param attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :type attribute_distance: str
        :param attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :type attribute_null: str
        :param operation: Set to \"count\" to return a count of objects instead of the objects.
        :type operation: str
        :param start: Pagination start index. Index of the first item in a larger list to return.
        :type start: int
        :param stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :type stop: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MediaNext
        """
        kwargs['_return_http_data_only'] = True
        return self.get_media_next_with_http_info(id, **kwargs)  # noqa: E501

    def get_media_next_with_http_info(self, id, **kwargs):  # noqa: E501
        """get_media_next  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_media_next_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a media object. (required)
        :type id: int
        :param media_id: List of integers identifying media.
        :type media_id: list[int]
        :param type: Unique integer identifying media type.
        :type type: int
        :param name: Name of the media to filter on.
        :type name: str
        :param md5: MD5 sum of the media file.
        :type md5: str
        :param after: If given, all results returned will be after the file with this filename. The `start` and `stop` parameters are relative to this modified range.
        :type after: str
        :param search: Lucene query syntax string for use with Elasticsearch. See `reference <https://lucene.apache.org/core/2_9_4/queryparsersyntax.html>`_.
        :type search: str
        :param attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute: str
        :param attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lt: str
        :param attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lte: str
        :param attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gt: str
        :param attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gte: str
        :param attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_contains: str
        :param attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :type attribute_distance: str
        :param attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :type attribute_null: str
        :param operation: Set to \"count\" to return a count of objects instead of the objects.
        :type operation: str
        :param start: Pagination start index. Index of the first item in a larger list to return.
        :type start: int
        :param stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :type stop: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MediaNext, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id',
            'media_id',
            'type',
            'name',
            'md5',
            'after',
            'search',
            'attribute',
            'attribute_lt',
            'attribute_lte',
            'attribute_gt',
            'attribute_gte',
            'attribute_contains',
            'attribute_distance',
            'attribute_null',
            'operation',
            'start',
            'stop'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_media_next" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_media_next`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'media_id' in local_var_params and local_var_params['media_id'] is not None:  # noqa: E501
            query_params.append(('media_id', local_var_params['media_id']))  # noqa: E501
            collection_formats['media_id'] = 'csv'  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'md5' in local_var_params and local_var_params['md5'] is not None:  # noqa: E501
            query_params.append(('md5', local_var_params['md5']))  # noqa: E501
        if 'after' in local_var_params and local_var_params['after'] is not None:  # noqa: E501
            query_params.append(('after', local_var_params['after']))  # noqa: E501
        if 'search' in local_var_params and local_var_params['search'] is not None:  # noqa: E501
            query_params.append(('search', local_var_params['search']))  # noqa: E501
        if 'attribute' in local_var_params and local_var_params['attribute'] is not None:  # noqa: E501
            query_params.append(('attribute', local_var_params['attribute']))  # noqa: E501
        if 'attribute_lt' in local_var_params and local_var_params['attribute_lt'] is not None:  # noqa: E501
            query_params.append(('attribute_lt', local_var_params['attribute_lt']))  # noqa: E501
        if 'attribute_lte' in local_var_params and local_var_params['attribute_lte'] is not None:  # noqa: E501
            query_params.append(('attribute_lte', local_var_params['attribute_lte']))  # noqa: E501
        if 'attribute_gt' in local_var_params and local_var_params['attribute_gt'] is not None:  # noqa: E501
            query_params.append(('attribute_gt', local_var_params['attribute_gt']))  # noqa: E501
        if 'attribute_gte' in local_var_params and local_var_params['attribute_gte'] is not None:  # noqa: E501
            query_params.append(('attribute_gte', local_var_params['attribute_gte']))  # noqa: E501
        if 'attribute_contains' in local_var_params and local_var_params['attribute_contains'] is not None:  # noqa: E501
            query_params.append(('attribute_contains', local_var_params['attribute_contains']))  # noqa: E501
        if 'attribute_distance' in local_var_params and local_var_params['attribute_distance'] is not None:  # noqa: E501
            query_params.append(('attribute_distance', local_var_params['attribute_distance']))  # noqa: E501
        if 'attribute_null' in local_var_params and local_var_params['attribute_null'] is not None:  # noqa: E501
            query_params.append(('attribute_null', local_var_params['attribute_null']))  # noqa: E501
        if 'operation' in local_var_params and local_var_params['operation'] is not None:  # noqa: E501
            query_params.append(('operation', local_var_params['operation']))  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'stop' in local_var_params and local_var_params['stop'] is not None:  # noqa: E501
            query_params.append(('stop', local_var_params['stop']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/MediaNext/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MediaNext',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_media_prev(self, id, **kwargs):  # noqa: E501
        """get_media_prev  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_media_prev(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a media object. (required)
        :type id: int
        :param media_id: List of integers identifying media.
        :type media_id: list[int]
        :param type: Unique integer identifying media type.
        :type type: int
        :param name: Name of the media to filter on.
        :type name: str
        :param md5: MD5 sum of the media file.
        :type md5: str
        :param after: If given, all results returned will be after the file with this filename. The `start` and `stop` parameters are relative to this modified range.
        :type after: str
        :param search: Lucene query syntax string for use with Elasticsearch. See `reference <https://lucene.apache.org/core/2_9_4/queryparsersyntax.html>`_.
        :type search: str
        :param attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute: str
        :param attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lt: str
        :param attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lte: str
        :param attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gt: str
        :param attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gte: str
        :param attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_contains: str
        :param attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :type attribute_distance: str
        :param attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :type attribute_null: str
        :param operation: Set to \"count\" to return a count of objects instead of the objects.
        :type operation: str
        :param start: Pagination start index. Index of the first item in a larger list to return.
        :type start: int
        :param stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :type stop: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MediaPrev
        """
        kwargs['_return_http_data_only'] = True
        return self.get_media_prev_with_http_info(id, **kwargs)  # noqa: E501

    def get_media_prev_with_http_info(self, id, **kwargs):  # noqa: E501
        """get_media_prev  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_media_prev_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a media object. (required)
        :type id: int
        :param media_id: List of integers identifying media.
        :type media_id: list[int]
        :param type: Unique integer identifying media type.
        :type type: int
        :param name: Name of the media to filter on.
        :type name: str
        :param md5: MD5 sum of the media file.
        :type md5: str
        :param after: If given, all results returned will be after the file with this filename. The `start` and `stop` parameters are relative to this modified range.
        :type after: str
        :param search: Lucene query syntax string for use with Elasticsearch. See `reference <https://lucene.apache.org/core/2_9_4/queryparsersyntax.html>`_.
        :type search: str
        :param attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute: str
        :param attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lt: str
        :param attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lte: str
        :param attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gt: str
        :param attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gte: str
        :param attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_contains: str
        :param attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :type attribute_distance: str
        :param attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :type attribute_null: str
        :param operation: Set to \"count\" to return a count of objects instead of the objects.
        :type operation: str
        :param start: Pagination start index. Index of the first item in a larger list to return.
        :type start: int
        :param stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :type stop: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MediaPrev, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id',
            'media_id',
            'type',
            'name',
            'md5',
            'after',
            'search',
            'attribute',
            'attribute_lt',
            'attribute_lte',
            'attribute_gt',
            'attribute_gte',
            'attribute_contains',
            'attribute_distance',
            'attribute_null',
            'operation',
            'start',
            'stop'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_media_prev" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_media_prev`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'media_id' in local_var_params and local_var_params['media_id'] is not None:  # noqa: E501
            query_params.append(('media_id', local_var_params['media_id']))  # noqa: E501
            collection_formats['media_id'] = 'csv'  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'md5' in local_var_params and local_var_params['md5'] is not None:  # noqa: E501
            query_params.append(('md5', local_var_params['md5']))  # noqa: E501
        if 'after' in local_var_params and local_var_params['after'] is not None:  # noqa: E501
            query_params.append(('after', local_var_params['after']))  # noqa: E501
        if 'search' in local_var_params and local_var_params['search'] is not None:  # noqa: E501
            query_params.append(('search', local_var_params['search']))  # noqa: E501
        if 'attribute' in local_var_params and local_var_params['attribute'] is not None:  # noqa: E501
            query_params.append(('attribute', local_var_params['attribute']))  # noqa: E501
        if 'attribute_lt' in local_var_params and local_var_params['attribute_lt'] is not None:  # noqa: E501
            query_params.append(('attribute_lt', local_var_params['attribute_lt']))  # noqa: E501
        if 'attribute_lte' in local_var_params and local_var_params['attribute_lte'] is not None:  # noqa: E501
            query_params.append(('attribute_lte', local_var_params['attribute_lte']))  # noqa: E501
        if 'attribute_gt' in local_var_params and local_var_params['attribute_gt'] is not None:  # noqa: E501
            query_params.append(('attribute_gt', local_var_params['attribute_gt']))  # noqa: E501
        if 'attribute_gte' in local_var_params and local_var_params['attribute_gte'] is not None:  # noqa: E501
            query_params.append(('attribute_gte', local_var_params['attribute_gte']))  # noqa: E501
        if 'attribute_contains' in local_var_params and local_var_params['attribute_contains'] is not None:  # noqa: E501
            query_params.append(('attribute_contains', local_var_params['attribute_contains']))  # noqa: E501
        if 'attribute_distance' in local_var_params and local_var_params['attribute_distance'] is not None:  # noqa: E501
            query_params.append(('attribute_distance', local_var_params['attribute_distance']))  # noqa: E501
        if 'attribute_null' in local_var_params and local_var_params['attribute_null'] is not None:  # noqa: E501
            query_params.append(('attribute_null', local_var_params['attribute_null']))  # noqa: E501
        if 'operation' in local_var_params and local_var_params['operation'] is not None:  # noqa: E501
            query_params.append(('operation', local_var_params['operation']))  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'stop' in local_var_params and local_var_params['stop'] is not None:  # noqa: E501
            query_params.append(('stop', local_var_params['stop']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/MediaPrev/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MediaPrev',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_media_sections(self, project, **kwargs):  # noqa: E501
        """get_media_sections  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_media_sections(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param media_id: List of integers identifying media.
        :type media_id: list[int]
        :param type: Unique integer identifying media type.
        :type type: int
        :param name: Name of the media to filter on.
        :type name: str
        :param md5: MD5 sum of the media file.
        :type md5: str
        :param after: If given, all results returned will be after the file with this filename. The `start` and `stop` parameters are relative to this modified range.
        :type after: str
        :param search: Lucene query syntax string for use with Elasticsearch. See `reference <https://lucene.apache.org/core/2_9_4/queryparsersyntax.html>`_.
        :type search: str
        :param attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute: str
        :param attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lt: str
        :param attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lte: str
        :param attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gt: str
        :param attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gte: str
        :param attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_contains: str
        :param attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :type attribute_distance: str
        :param attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :type attribute_null: str
        :param operation: Set to \"count\" to return a count of objects instead of the objects.
        :type operation: str
        :param start: Pagination start index. Index of the first item in a larger list to return.
        :type start: int
        :param stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :type stop: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: dict(str, object)
        """
        kwargs['_return_http_data_only'] = True
        return self.get_media_sections_with_http_info(project, **kwargs)  # noqa: E501

    def get_media_sections_with_http_info(self, project, **kwargs):  # noqa: E501
        """get_media_sections  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_media_sections_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param media_id: List of integers identifying media.
        :type media_id: list[int]
        :param type: Unique integer identifying media type.
        :type type: int
        :param name: Name of the media to filter on.
        :type name: str
        :param md5: MD5 sum of the media file.
        :type md5: str
        :param after: If given, all results returned will be after the file with this filename. The `start` and `stop` parameters are relative to this modified range.
        :type after: str
        :param search: Lucene query syntax string for use with Elasticsearch. See `reference <https://lucene.apache.org/core/2_9_4/queryparsersyntax.html>`_.
        :type search: str
        :param attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute: str
        :param attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lt: str
        :param attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lte: str
        :param attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gt: str
        :param attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gte: str
        :param attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_contains: str
        :param attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :type attribute_distance: str
        :param attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :type attribute_null: str
        :param operation: Set to \"count\" to return a count of objects instead of the objects.
        :type operation: str
        :param start: Pagination start index. Index of the first item in a larger list to return.
        :type start: int
        :param stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :type stop: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(dict(str, object), status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'project',
            'media_id',
            'type',
            'name',
            'md5',
            'after',
            'search',
            'attribute',
            'attribute_lt',
            'attribute_lte',
            'attribute_gt',
            'attribute_gte',
            'attribute_contains',
            'attribute_distance',
            'attribute_null',
            'operation',
            'start',
            'stop'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_media_sections" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_media_sections`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'media_id' in local_var_params and local_var_params['media_id'] is not None:  # noqa: E501
            query_params.append(('media_id', local_var_params['media_id']))  # noqa: E501
            collection_formats['media_id'] = 'csv'  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'md5' in local_var_params and local_var_params['md5'] is not None:  # noqa: E501
            query_params.append(('md5', local_var_params['md5']))  # noqa: E501
        if 'after' in local_var_params and local_var_params['after'] is not None:  # noqa: E501
            query_params.append(('after', local_var_params['after']))  # noqa: E501
        if 'search' in local_var_params and local_var_params['search'] is not None:  # noqa: E501
            query_params.append(('search', local_var_params['search']))  # noqa: E501
        if 'attribute' in local_var_params and local_var_params['attribute'] is not None:  # noqa: E501
            query_params.append(('attribute', local_var_params['attribute']))  # noqa: E501
        if 'attribute_lt' in local_var_params and local_var_params['attribute_lt'] is not None:  # noqa: E501
            query_params.append(('attribute_lt', local_var_params['attribute_lt']))  # noqa: E501
        if 'attribute_lte' in local_var_params and local_var_params['attribute_lte'] is not None:  # noqa: E501
            query_params.append(('attribute_lte', local_var_params['attribute_lte']))  # noqa: E501
        if 'attribute_gt' in local_var_params and local_var_params['attribute_gt'] is not None:  # noqa: E501
            query_params.append(('attribute_gt', local_var_params['attribute_gt']))  # noqa: E501
        if 'attribute_gte' in local_var_params and local_var_params['attribute_gte'] is not None:  # noqa: E501
            query_params.append(('attribute_gte', local_var_params['attribute_gte']))  # noqa: E501
        if 'attribute_contains' in local_var_params and local_var_params['attribute_contains'] is not None:  # noqa: E501
            query_params.append(('attribute_contains', local_var_params['attribute_contains']))  # noqa: E501
        if 'attribute_distance' in local_var_params and local_var_params['attribute_distance'] is not None:  # noqa: E501
            query_params.append(('attribute_distance', local_var_params['attribute_distance']))  # noqa: E501
        if 'attribute_null' in local_var_params and local_var_params['attribute_null'] is not None:  # noqa: E501
            query_params.append(('attribute_null', local_var_params['attribute_null']))  # noqa: E501
        if 'operation' in local_var_params and local_var_params['operation'] is not None:  # noqa: E501
            query_params.append(('operation', local_var_params['operation']))  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'stop' in local_var_params and local_var_params['stop'] is not None:  # noqa: E501
            query_params.append(('stop', local_var_params['stop']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/MediaSections/{project}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, object)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_media_type(self, id, **kwargs):  # noqa: E501
        """get_media_type  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_media_type(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying an media type. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MediaType
        """
        kwargs['_return_http_data_only'] = True
        return self.get_media_type_with_http_info(id, **kwargs)  # noqa: E501

    def get_media_type_with_http_info(self, id, **kwargs):  # noqa: E501
        """get_media_type  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_media_type_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying an media type. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MediaType, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_media_type" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_media_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/MediaType/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MediaType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_media_type_list(self, project, **kwargs):  # noqa: E501
        """get_media_type_list  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_media_type_list(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[MediaType]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_media_type_list_with_http_info(project, **kwargs)  # noqa: E501

    def get_media_type_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """get_media_type_list  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_media_type_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[MediaType], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'project'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_media_type_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_media_type_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/MediaTypes/{project}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[MediaType]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_membership(self, id, **kwargs):  # noqa: E501
        """get_membership  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_membership(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a membership. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Membership
        """
        kwargs['_return_http_data_only'] = True
        return self.get_membership_with_http_info(id, **kwargs)  # noqa: E501

    def get_membership_with_http_info(self, id, **kwargs):  # noqa: E501
        """get_membership  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_membership_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a membership. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Membership, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_membership" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_membership`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Membership/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Membership',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_membership_list(self, project, **kwargs):  # noqa: E501
        """get_membership_list  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_membership_list(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[Membership]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_membership_list_with_http_info(project, **kwargs)  # noqa: E501

    def get_membership_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """get_membership_list  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_membership_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[Membership], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'project'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_membership_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_membership_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Memberships/{project}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Membership]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_project(self, id, **kwargs):  # noqa: E501
        """get_project  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_project(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a project. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Project
        """
        kwargs['_return_http_data_only'] = True
        return self.get_project_with_http_info(id, **kwargs)  # noqa: E501

    def get_project_with_http_info(self, id, **kwargs):  # noqa: E501
        """get_project  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_project_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a project. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Project, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Project/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Project',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_project_list(self, **kwargs):  # noqa: E501
        """get_project_list  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_project_list(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[Project]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_project_list_with_http_info(**kwargs)  # noqa: E501

    def get_project_list_with_http_info(self, **kwargs):  # noqa: E501
        """get_project_list  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_project_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[Project], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Projects', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Project]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_section_analysis(self, project, **kwargs):  # noqa: E501
        """get_section_analysis  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_section_analysis(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param media_id: Unique integer identifying a media. Use this to do analyis on a single file instead of sections.
        :type media_id: list[int]
        :param search: Lucene query syntax string for use with Elasticsearch. See `reference <https://lucene.apache.org/core/2_9_4/queryparsersyntax.html>`_.
        :type search: str
        :param attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute: str
        :param attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lt: str
        :param attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lte: str
        :param attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gt: str
        :param attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gte: str
        :param attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_contains: str
        :param attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :type attribute_distance: str
        :param attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :type attribute_null: str
        :param operation: Set to \"count\" to return a count of objects instead of the objects.
        :type operation: str
        :param start: Pagination start index. Index of the first item in a larger list to return.
        :type start: int
        :param stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :type stop: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: dict(str, object)
        """
        kwargs['_return_http_data_only'] = True
        return self.get_section_analysis_with_http_info(project, **kwargs)  # noqa: E501

    def get_section_analysis_with_http_info(self, project, **kwargs):  # noqa: E501
        """get_section_analysis  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_section_analysis_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param media_id: Unique integer identifying a media. Use this to do analyis on a single file instead of sections.
        :type media_id: list[int]
        :param search: Lucene query syntax string for use with Elasticsearch. See `reference <https://lucene.apache.org/core/2_9_4/queryparsersyntax.html>`_.
        :type search: str
        :param attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute: str
        :param attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lt: str
        :param attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lte: str
        :param attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gt: str
        :param attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gte: str
        :param attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_contains: str
        :param attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :type attribute_distance: str
        :param attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :type attribute_null: str
        :param operation: Set to \"count\" to return a count of objects instead of the objects.
        :type operation: str
        :param start: Pagination start index. Index of the first item in a larger list to return.
        :type start: int
        :param stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :type stop: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(dict(str, object), status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'project',
            'media_id',
            'search',
            'attribute',
            'attribute_lt',
            'attribute_lte',
            'attribute_gt',
            'attribute_gte',
            'attribute_contains',
            'attribute_distance',
            'attribute_null',
            'operation',
            'start',
            'stop'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_section_analysis" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_section_analysis`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'media_id' in local_var_params and local_var_params['media_id'] is not None:  # noqa: E501
            query_params.append(('media_id', local_var_params['media_id']))  # noqa: E501
            collection_formats['media_id'] = 'csv'  # noqa: E501
        if 'search' in local_var_params and local_var_params['search'] is not None:  # noqa: E501
            query_params.append(('search', local_var_params['search']))  # noqa: E501
        if 'attribute' in local_var_params and local_var_params['attribute'] is not None:  # noqa: E501
            query_params.append(('attribute', local_var_params['attribute']))  # noqa: E501
        if 'attribute_lt' in local_var_params and local_var_params['attribute_lt'] is not None:  # noqa: E501
            query_params.append(('attribute_lt', local_var_params['attribute_lt']))  # noqa: E501
        if 'attribute_lte' in local_var_params and local_var_params['attribute_lte'] is not None:  # noqa: E501
            query_params.append(('attribute_lte', local_var_params['attribute_lte']))  # noqa: E501
        if 'attribute_gt' in local_var_params and local_var_params['attribute_gt'] is not None:  # noqa: E501
            query_params.append(('attribute_gt', local_var_params['attribute_gt']))  # noqa: E501
        if 'attribute_gte' in local_var_params and local_var_params['attribute_gte'] is not None:  # noqa: E501
            query_params.append(('attribute_gte', local_var_params['attribute_gte']))  # noqa: E501
        if 'attribute_contains' in local_var_params and local_var_params['attribute_contains'] is not None:  # noqa: E501
            query_params.append(('attribute_contains', local_var_params['attribute_contains']))  # noqa: E501
        if 'attribute_distance' in local_var_params and local_var_params['attribute_distance'] is not None:  # noqa: E501
            query_params.append(('attribute_distance', local_var_params['attribute_distance']))  # noqa: E501
        if 'attribute_null' in local_var_params and local_var_params['attribute_null'] is not None:  # noqa: E501
            query_params.append(('attribute_null', local_var_params['attribute_null']))  # noqa: E501
        if 'operation' in local_var_params and local_var_params['operation'] is not None:  # noqa: E501
            query_params.append(('operation', local_var_params['operation']))  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'stop' in local_var_params and local_var_params['stop'] is not None:  # noqa: E501
            query_params.append(('stop', local_var_params['stop']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/SectionAnalysis/{project}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, object)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_state(self, id, **kwargs):  # noqa: E501
        """get_state  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_state(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a state. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.get_state_with_http_info(id, **kwargs)  # noqa: E501

    def get_state_with_http_info(self, id, **kwargs):  # noqa: E501
        """get_state  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_state_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a state. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_state" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_state`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/State/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_state_graphic(self, id, **kwargs):  # noqa: E501
        """get_state_graphic  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_state_graphic(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a state. (required)
        :type id: int
        :param mode: Whether to animate or tile.
        :type mode: str
        :param fps: Frame rate if `mode` is `animate`.
        :type fps: float
        :param force_scale: wxh to force each tile prior to stich
        :type force_scale: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: file
        """
        kwargs['_return_http_data_only'] = True
        return self.get_state_graphic_with_http_info(id, **kwargs)  # noqa: E501

    def get_state_graphic_with_http_info(self, id, **kwargs):  # noqa: E501
        """get_state_graphic  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_state_graphic_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a state. (required)
        :type id: int
        :param mode: Whether to animate or tile.
        :type mode: str
        :param fps: Frame rate if `mode` is `animate`.
        :type fps: float
        :param force_scale: wxh to force each tile prior to stich
        :type force_scale: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(file, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id',
            'mode',
            'fps',
            'force_scale'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_state_graphic" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_state_graphic`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'mode' in local_var_params and local_var_params['mode'] is not None:  # noqa: E501
            query_params.append(('mode', local_var_params['mode']))  # noqa: E501
        if 'fps' in local_var_params and local_var_params['fps'] is not None:  # noqa: E501
            query_params.append(('fps', local_var_params['fps']))  # noqa: E501
        if 'force_scale' in local_var_params and local_var_params['force_scale'] is not None:  # noqa: E501
            query_params.append(('forceScale', local_var_params['force_scale']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['image/*', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/StateGraphic/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_state_list(self, project, **kwargs):  # noqa: E501
        """get_state_list  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_state_list(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param media_query: Query string used to filter media IDs. If supplied, media_id will be ignored.
        :type media_query: str
        :param media_id: Comma-separated list of media IDs.
        :type media_id: list[int]
        :param type: Unique integer identifying a annotation type.
        :type type: int
        :param version: List of integers representing versions to fetch
        :type version: list[int]
        :param modified: Whether to return original or modified annotations, 0 or 1.
        :type modified: int
        :param after: If given, all results returned will be after the localization with this ID. The `start` and `stop` parameters are relative to this modified range.
        :type after: int
        :param search: Lucene query syntax string for use with Elasticsearch. See `reference <https://lucene.apache.org/core/2_9_4/queryparsersyntax.html>`_.
        :type search: str
        :param attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute: str
        :param attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lt: str
        :param attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lte: str
        :param attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gt: str
        :param attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gte: str
        :param attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_contains: str
        :param attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :type attribute_distance: str
        :param attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :type attribute_null: str
        :param operation: Set to \"count\" to return a count of objects instead of the objects.
        :type operation: str
        :param start: Pagination start index. Index of the first item in a larger list to return.
        :type start: int
        :param stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :type stop: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[State]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_state_list_with_http_info(project, **kwargs)  # noqa: E501

    def get_state_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """get_state_list  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_state_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param media_query: Query string used to filter media IDs. If supplied, media_id will be ignored.
        :type media_query: str
        :param media_id: Comma-separated list of media IDs.
        :type media_id: list[int]
        :param type: Unique integer identifying a annotation type.
        :type type: int
        :param version: List of integers representing versions to fetch
        :type version: list[int]
        :param modified: Whether to return original or modified annotations, 0 or 1.
        :type modified: int
        :param after: If given, all results returned will be after the localization with this ID. The `start` and `stop` parameters are relative to this modified range.
        :type after: int
        :param search: Lucene query syntax string for use with Elasticsearch. See `reference <https://lucene.apache.org/core/2_9_4/queryparsersyntax.html>`_.
        :type search: str
        :param attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute: str
        :param attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lt: str
        :param attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lte: str
        :param attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gt: str
        :param attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gte: str
        :param attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_contains: str
        :param attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :type attribute_distance: str
        :param attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :type attribute_null: str
        :param operation: Set to \"count\" to return a count of objects instead of the objects.
        :type operation: str
        :param start: Pagination start index. Index of the first item in a larger list to return.
        :type start: int
        :param stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :type stop: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[State], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'project',
            'media_query',
            'media_id',
            'type',
            'version',
            'modified',
            'after',
            'search',
            'attribute',
            'attribute_lt',
            'attribute_lte',
            'attribute_gt',
            'attribute_gte',
            'attribute_contains',
            'attribute_distance',
            'attribute_null',
            'operation',
            'start',
            'stop'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_state_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_state_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'media_query' in local_var_params and local_var_params['media_query'] is not None:  # noqa: E501
            query_params.append(('media_query', local_var_params['media_query']))  # noqa: E501
        if 'media_id' in local_var_params and local_var_params['media_id'] is not None:  # noqa: E501
            query_params.append(('media_id', local_var_params['media_id']))  # noqa: E501
            collection_formats['media_id'] = 'csv'  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'version' in local_var_params and local_var_params['version'] is not None:  # noqa: E501
            query_params.append(('version', local_var_params['version']))  # noqa: E501
            collection_formats['version'] = 'csv'  # noqa: E501
        if 'modified' in local_var_params and local_var_params['modified'] is not None:  # noqa: E501
            query_params.append(('modified', local_var_params['modified']))  # noqa: E501
        if 'after' in local_var_params and local_var_params['after'] is not None:  # noqa: E501
            query_params.append(('after', local_var_params['after']))  # noqa: E501
        if 'search' in local_var_params and local_var_params['search'] is not None:  # noqa: E501
            query_params.append(('search', local_var_params['search']))  # noqa: E501
        if 'attribute' in local_var_params and local_var_params['attribute'] is not None:  # noqa: E501
            query_params.append(('attribute', local_var_params['attribute']))  # noqa: E501
        if 'attribute_lt' in local_var_params and local_var_params['attribute_lt'] is not None:  # noqa: E501
            query_params.append(('attribute_lt', local_var_params['attribute_lt']))  # noqa: E501
        if 'attribute_lte' in local_var_params and local_var_params['attribute_lte'] is not None:  # noqa: E501
            query_params.append(('attribute_lte', local_var_params['attribute_lte']))  # noqa: E501
        if 'attribute_gt' in local_var_params and local_var_params['attribute_gt'] is not None:  # noqa: E501
            query_params.append(('attribute_gt', local_var_params['attribute_gt']))  # noqa: E501
        if 'attribute_gte' in local_var_params and local_var_params['attribute_gte'] is not None:  # noqa: E501
            query_params.append(('attribute_gte', local_var_params['attribute_gte']))  # noqa: E501
        if 'attribute_contains' in local_var_params and local_var_params['attribute_contains'] is not None:  # noqa: E501
            query_params.append(('attribute_contains', local_var_params['attribute_contains']))  # noqa: E501
        if 'attribute_distance' in local_var_params and local_var_params['attribute_distance'] is not None:  # noqa: E501
            query_params.append(('attribute_distance', local_var_params['attribute_distance']))  # noqa: E501
        if 'attribute_null' in local_var_params and local_var_params['attribute_null'] is not None:  # noqa: E501
            query_params.append(('attribute_null', local_var_params['attribute_null']))  # noqa: E501
        if 'operation' in local_var_params and local_var_params['operation'] is not None:  # noqa: E501
            query_params.append(('operation', local_var_params['operation']))  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'stop' in local_var_params and local_var_params['stop'] is not None:  # noqa: E501
            query_params.append(('stop', local_var_params['stop']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/States/{project}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[State]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_state_type(self, id, **kwargs):  # noqa: E501
        """get_state_type  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_state_type(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a state type. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StateType
        """
        kwargs['_return_http_data_only'] = True
        return self.get_state_type_with_http_info(id, **kwargs)  # noqa: E501

    def get_state_type_with_http_info(self, id, **kwargs):  # noqa: E501
        """get_state_type  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_state_type_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a state type. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StateType, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_state_type" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_state_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/StateType/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StateType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_state_type_list(self, project, **kwargs):  # noqa: E501
        """get_state_type_list  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_state_type_list(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param media_id: List of unique integers identifying a media.
        :type media_id: list[int]
        :param type: Deprecated. Use `LocalizationType` endpoint to retrieve individual localization type by ID.
        :type type: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[StateType]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_state_type_list_with_http_info(project, **kwargs)  # noqa: E501

    def get_state_type_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """get_state_type_list  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_state_type_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param media_id: List of unique integers identifying a media.
        :type media_id: list[int]
        :param type: Deprecated. Use `LocalizationType` endpoint to retrieve individual localization type by ID.
        :type type: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[StateType], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'project',
            'media_id',
            'type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_state_type_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_state_type_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'media_id' in local_var_params and local_var_params['media_id'] is not None:  # noqa: E501
            query_params.append(('media_id', local_var_params['media_id']))  # noqa: E501
            collection_formats['media_id'] = 'csv'  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/StateTypes/{project}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[StateType]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_temporary_file(self, id, **kwargs):  # noqa: E501
        """get_temporary_file  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_temporary_file(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a temporary file. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TemporaryFile
        """
        kwargs['_return_http_data_only'] = True
        return self.get_temporary_file_with_http_info(id, **kwargs)  # noqa: E501

    def get_temporary_file_with_http_info(self, id, **kwargs):  # noqa: E501
        """get_temporary_file  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_temporary_file_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a temporary file. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TemporaryFile, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_temporary_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_temporary_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/TemporaryFile/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TemporaryFile',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_temporary_file_list(self, project, **kwargs):  # noqa: E501
        """get_temporary_file_list  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_temporary_file_list(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param expired: If greater than 0 will return only expired files
        :type expired: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[TemporaryFile]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_temporary_file_list_with_http_info(project, **kwargs)  # noqa: E501

    def get_temporary_file_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """get_temporary_file_list  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_temporary_file_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param expired: If greater than 0 will return only expired files
        :type expired: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[TemporaryFile], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'project',
            'expired'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_temporary_file_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_temporary_file_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'expired' in local_var_params and local_var_params['expired'] is not None:  # noqa: E501
            query_params.append(('expired', local_var_params['expired']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/TemporaryFiles/{project}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[TemporaryFile]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_user(self, id, **kwargs):  # noqa: E501
        """get_user  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_user(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a localization association. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: User
        """
        kwargs['_return_http_data_only'] = True
        return self.get_user_with_http_info(id, **kwargs)  # noqa: E501

    def get_user_with_http_info(self, id, **kwargs):  # noqa: E501
        """get_user  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_user_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a localization association. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(User, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/User/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='User',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_version(self, id, **kwargs):  # noqa: E501
        """get_version  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_version(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a version. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Version
        """
        kwargs['_return_http_data_only'] = True
        return self.get_version_with_http_info(id, **kwargs)  # noqa: E501

    def get_version_with_http_info(self, id, **kwargs):  # noqa: E501
        """get_version  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_version_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a version. (required)
        :type id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Version, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_version" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_version`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Version/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Version',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_version_list(self, project, **kwargs):  # noqa: E501
        """get_version_list  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_version_list(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param media_id: Unique integer identifying a media.
        :type media_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[Version]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_version_list_with_http_info(project, **kwargs)  # noqa: E501

    def get_version_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """get_version_list  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_version_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param media_id: Unique integer identifying a media.
        :type media_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[Version], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'project',
            'media_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_version_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `get_version_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'media_id' in local_var_params and local_var_params['media_id'] is not None:  # noqa: E501
            query_params.append(('media_id', local_var_params['media_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Versions/{project}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Version]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def leaf_suggestion(self, project, ancestor, query, **kwargs):  # noqa: E501
        """leaf_suggestion  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.leaf_suggestion(project, ancestor, query, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param ancestor: Get descendents of a leaf element (inclusive), by path (i.e. ITIS.Animalia). (required)
        :type ancestor: str
        :param query: String to search for matching names. (required)
        :type query: str
        :param min_level: Integer specifying level of results that may be returned. For example, 2 refers to grandchildren of the level specified by the `ancestor` parameter.
        :type min_level: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[LeafSuggestion]
        """
        kwargs['_return_http_data_only'] = True
        return self.leaf_suggestion_with_http_info(project, ancestor, query, **kwargs)  # noqa: E501

    def leaf_suggestion_with_http_info(self, project, ancestor, query, **kwargs):  # noqa: E501
        """leaf_suggestion  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.leaf_suggestion_with_http_info(project, ancestor, query, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param ancestor: Get descendents of a leaf element (inclusive), by path (i.e. ITIS.Animalia). (required)
        :type ancestor: str
        :param query: String to search for matching names. (required)
        :type query: str
        :param min_level: Integer specifying level of results that may be returned. For example, 2 refers to grandchildren of the level specified by the `ancestor` parameter.
        :type min_level: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[LeafSuggestion], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'project',
            'ancestor',
            'query',
            'min_level'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method leaf_suggestion" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `leaf_suggestion`")  # noqa: E501
        # verify the required parameter 'ancestor' is set
        if self.api_client.client_side_validation and ('ancestor' not in local_var_params or  # noqa: E501
                                                        local_var_params['ancestor'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ancestor` when calling `leaf_suggestion`")  # noqa: E501
        # verify the required parameter 'query' is set
        if self.api_client.client_side_validation and ('query' not in local_var_params or  # noqa: E501
                                                        local_var_params['query'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `query` when calling `leaf_suggestion`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501
        if 'ancestor' in local_var_params:
            path_params['ancestor'] = local_var_params['ancestor']  # noqa: E501

        query_params = []
        if 'min_level' in local_var_params and local_var_params['min_level'] is not None:  # noqa: E501
            query_params.append(('minLevel', local_var_params['min_level']))  # noqa: E501
        if 'query' in local_var_params and local_var_params['query'] is not None:  # noqa: E501
            query_params.append(('query', local_var_params['query']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Leaves/Suggestion/{ancestor}/{project}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[LeafSuggestion]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def notify(self, **kwargs):  # noqa: E501
        """notify  # noqa: E501

        Send a notification to administrators.  Uses the Slack API to send a notification to system administrators. This endpoint can only be used by system administrators and must be configured in a Tator deployment's settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.notify(async_req=True)
        >>> result = thread.get()

        :param notify_spec:
        :type notify_spec: NotifySpec
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.notify_with_http_info(**kwargs)  # noqa: E501

    def notify_with_http_info(self, **kwargs):  # noqa: E501
        """notify  # noqa: E501

        Send a notification to administrators.  Uses the Slack API to send a notification to system administrators. This endpoint can only be used by system administrators and must be configured in a Tator deployment's settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.notify_with_http_info(async_req=True)
        >>> result = thread.get()

        :param notify_spec:
        :type notify_spec: NotifySpec
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'notify_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method notify" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'notify_spec' in local_var_params:
            body_params = local_var_params['notify_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Notify', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def progress(self, project, **kwargs):  # noqa: E501
        """progress  # noqa: E501

        Create state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.progress(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param progress_spec:
        :type progress_spec: list[ProgressSpec]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MessageResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.progress_with_http_info(project, **kwargs)  # noqa: E501

    def progress_with_http_info(self, project, **kwargs):  # noqa: E501
        """progress  # noqa: E501

        Create state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.progress_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param progress_spec:
        :type progress_spec: list[ProgressSpec]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MessageResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'project',
            'progress_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method progress" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `progress`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'progress_spec' in local_var_params:
            body_params = local_var_params['progress_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Progress/{project}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def save_image(self, project, **kwargs):  # noqa: E501
        """save_image  # noqa: E501

        Create state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.save_image(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param image_spec:
        :type image_spec: ImageSpec
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CreateResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.save_image_with_http_info(project, **kwargs)  # noqa: E501

    def save_image_with_http_info(self, project, **kwargs):  # noqa: E501
        """save_image  # noqa: E501

        Create state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.save_image_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param image_spec:
        :type image_spec: ImageSpec
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CreateResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'project',
            'image_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method save_image" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `save_image`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'image_spec' in local_var_params:
            body_params = local_var_params['image_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/SaveImage/{project}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def save_video(self, project, **kwargs):  # noqa: E501
        """save_video  # noqa: E501

        Create state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.save_video(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param video_spec:
        :type video_spec: VideoSpec
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CreateResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.save_video_with_http_info(project, **kwargs)  # noqa: E501

    def save_video_with_http_info(self, project, **kwargs):  # noqa: E501
        """save_video  # noqa: E501

        Create state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.save_video_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param video_spec:
        :type video_spec: VideoSpec
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CreateResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'project',
            'video_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method save_video" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `save_video`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'video_spec' in local_var_params:
            body_params = local_var_params['video_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/SaveVideo/{project}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def transcode(self, project, **kwargs):  # noqa: E501
        """transcode  # noqa: E501

        Create state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.transcode(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param transcode_spec:
        :type transcode_spec: TranscodeSpec
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Transcode
        """
        kwargs['_return_http_data_only'] = True
        return self.transcode_with_http_info(project, **kwargs)  # noqa: E501

    def transcode_with_http_info(self, project, **kwargs):  # noqa: E501
        """transcode  # noqa: E501

        Create state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.transcode_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param transcode_spec:
        :type transcode_spec: TranscodeSpec
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Transcode, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'project',
            'transcode_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method transcode" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `transcode`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'transcode_spec' in local_var_params:
            body_params = local_var_params['transcode_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Transcode/{project}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Transcode',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_leaf(self, id, **kwargs):  # noqa: E501
        """update_leaf  # noqa: E501

        Update state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_leaf(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a leaf. (required)
        :type id: int
        :param leaf_update:
        :type leaf_update: LeafUpdate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MessageResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.update_leaf_with_http_info(id, **kwargs)  # noqa: E501

    def update_leaf_with_http_info(self, id, **kwargs):  # noqa: E501
        """update_leaf  # noqa: E501

        Update state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_leaf_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a leaf. (required)
        :type id: int
        :param leaf_update:
        :type leaf_update: LeafUpdate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MessageResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id',
            'leaf_update'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_leaf" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `update_leaf`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'leaf_update' in local_var_params:
            body_params = local_var_params['leaf_update']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Leaf/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_leaf_list(self, project, **kwargs):  # noqa: E501
        """update_leaf_list  # noqa: E501

        Update state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_leaf_list(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param ancestor: Get descendents of a leaf element (inclusive), by path (i.e. ITIS.Animalia).
        :type ancestor: str
        :param type: Unique integer identifying a leaf type.
        :type type: int
        :param name: Name of the leaf element.
        :type name: str
        :param attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute: str
        :param attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lt: str
        :param attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lte: str
        :param attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gt: str
        :param attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gte: str
        :param attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_contains: str
        :param attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :type attribute_distance: str
        :param attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :type attribute_null: str
        :param operation: Set to \"count\" to return a count of objects instead of the objects.
        :type operation: str
        :param start: Pagination start index. Index of the first item in a larger list to return.
        :type start: int
        :param stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :type stop: int
        :param attribute_bulk_update:
        :type attribute_bulk_update: AttributeBulkUpdate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MessageResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.update_leaf_list_with_http_info(project, **kwargs)  # noqa: E501

    def update_leaf_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """update_leaf_list  # noqa: E501

        Update state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_leaf_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param ancestor: Get descendents of a leaf element (inclusive), by path (i.e. ITIS.Animalia).
        :type ancestor: str
        :param type: Unique integer identifying a leaf type.
        :type type: int
        :param name: Name of the leaf element.
        :type name: str
        :param attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute: str
        :param attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lt: str
        :param attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lte: str
        :param attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gt: str
        :param attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gte: str
        :param attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_contains: str
        :param attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :type attribute_distance: str
        :param attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :type attribute_null: str
        :param operation: Set to \"count\" to return a count of objects instead of the objects.
        :type operation: str
        :param start: Pagination start index. Index of the first item in a larger list to return.
        :type start: int
        :param stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :type stop: int
        :param attribute_bulk_update:
        :type attribute_bulk_update: AttributeBulkUpdate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MessageResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'project',
            'ancestor',
            'type',
            'name',
            'attribute',
            'attribute_lt',
            'attribute_lte',
            'attribute_gt',
            'attribute_gte',
            'attribute_contains',
            'attribute_distance',
            'attribute_null',
            'operation',
            'start',
            'stop',
            'attribute_bulk_update'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_leaf_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `update_leaf_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'ancestor' in local_var_params and local_var_params['ancestor'] is not None:  # noqa: E501
            query_params.append(('ancestor', local_var_params['ancestor']))  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'attribute' in local_var_params and local_var_params['attribute'] is not None:  # noqa: E501
            query_params.append(('attribute', local_var_params['attribute']))  # noqa: E501
        if 'attribute_lt' in local_var_params and local_var_params['attribute_lt'] is not None:  # noqa: E501
            query_params.append(('attribute_lt', local_var_params['attribute_lt']))  # noqa: E501
        if 'attribute_lte' in local_var_params and local_var_params['attribute_lte'] is not None:  # noqa: E501
            query_params.append(('attribute_lte', local_var_params['attribute_lte']))  # noqa: E501
        if 'attribute_gt' in local_var_params and local_var_params['attribute_gt'] is not None:  # noqa: E501
            query_params.append(('attribute_gt', local_var_params['attribute_gt']))  # noqa: E501
        if 'attribute_gte' in local_var_params and local_var_params['attribute_gte'] is not None:  # noqa: E501
            query_params.append(('attribute_gte', local_var_params['attribute_gte']))  # noqa: E501
        if 'attribute_contains' in local_var_params and local_var_params['attribute_contains'] is not None:  # noqa: E501
            query_params.append(('attribute_contains', local_var_params['attribute_contains']))  # noqa: E501
        if 'attribute_distance' in local_var_params and local_var_params['attribute_distance'] is not None:  # noqa: E501
            query_params.append(('attribute_distance', local_var_params['attribute_distance']))  # noqa: E501
        if 'attribute_null' in local_var_params and local_var_params['attribute_null'] is not None:  # noqa: E501
            query_params.append(('attribute_null', local_var_params['attribute_null']))  # noqa: E501
        if 'operation' in local_var_params and local_var_params['operation'] is not None:  # noqa: E501
            query_params.append(('operation', local_var_params['operation']))  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'stop' in local_var_params and local_var_params['stop'] is not None:  # noqa: E501
            query_params.append(('stop', local_var_params['stop']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'attribute_bulk_update' in local_var_params:
            body_params = local_var_params['attribute_bulk_update']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Leaves/{project}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_leaf_type(self, id, **kwargs):  # noqa: E501
        """update_leaf_type  # noqa: E501

        Update state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_leaf_type(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying an leaf type. (required)
        :type id: int
        :param leaf_type_update:
        :type leaf_type_update: LeafTypeUpdate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MessageResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.update_leaf_type_with_http_info(id, **kwargs)  # noqa: E501

    def update_leaf_type_with_http_info(self, id, **kwargs):  # noqa: E501
        """update_leaf_type  # noqa: E501

        Update state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_leaf_type_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying an leaf type. (required)
        :type id: int
        :param leaf_type_update:
        :type leaf_type_update: LeafTypeUpdate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MessageResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id',
            'leaf_type_update'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_leaf_type" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `update_leaf_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'leaf_type_update' in local_var_params:
            body_params = local_var_params['leaf_type_update']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/LeafType/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_localization(self, id, **kwargs):  # noqa: E501
        """update_localization  # noqa: E501

        Update state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_localization(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a localization. (required)
        :type id: int
        :param localization_update:
        :type localization_update: LocalizationUpdate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MessageResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.update_localization_with_http_info(id, **kwargs)  # noqa: E501

    def update_localization_with_http_info(self, id, **kwargs):  # noqa: E501
        """update_localization  # noqa: E501

        Update state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_localization_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a localization. (required)
        :type id: int
        :param localization_update:
        :type localization_update: LocalizationUpdate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MessageResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id',
            'localization_update'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_localization" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `update_localization`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'localization_update' in local_var_params:
            body_params = local_var_params['localization_update']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Localization/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_localization_list(self, project, **kwargs):  # noqa: E501
        """update_localization_list  # noqa: E501

        Update state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_localization_list(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param media_query: Query string used to filter media IDs. If supplied, media_id will be ignored.
        :type media_query: str
        :param media_id: Comma-separated list of media IDs.
        :type media_id: list[int]
        :param type: Unique integer identifying a annotation type.
        :type type: int
        :param version: List of integers representing versions to fetch
        :type version: list[int]
        :param modified: Whether to return original or modified annotations, 0 or 1.
        :type modified: int
        :param after: If given, all results returned will be after the localization with this ID. The `start` and `stop` parameters are relative to this modified range.
        :type after: int
        :param search: Lucene query syntax string for use with Elasticsearch. See `reference <https://lucene.apache.org/core/2_9_4/queryparsersyntax.html>`_.
        :type search: str
        :param attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute: str
        :param attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lt: str
        :param attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lte: str
        :param attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gt: str
        :param attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gte: str
        :param attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_contains: str
        :param attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :type attribute_distance: str
        :param attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :type attribute_null: str
        :param operation: Set to \"count\" to return a count of objects instead of the objects.
        :type operation: str
        :param start: Pagination start index. Index of the first item in a larger list to return.
        :type start: int
        :param stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :type stop: int
        :param exclude_parents: If a clone is present, do not send parent. (0 or 1)
        :type exclude_parents: int
        :param frame: Frame number of this localization if it is in a video.
        :type frame: int
        :param attribute_bulk_update:
        :type attribute_bulk_update: AttributeBulkUpdate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MessageResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.update_localization_list_with_http_info(project, **kwargs)  # noqa: E501

    def update_localization_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """update_localization_list  # noqa: E501

        Update state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_localization_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param media_query: Query string used to filter media IDs. If supplied, media_id will be ignored.
        :type media_query: str
        :param media_id: Comma-separated list of media IDs.
        :type media_id: list[int]
        :param type: Unique integer identifying a annotation type.
        :type type: int
        :param version: List of integers representing versions to fetch
        :type version: list[int]
        :param modified: Whether to return original or modified annotations, 0 or 1.
        :type modified: int
        :param after: If given, all results returned will be after the localization with this ID. The `start` and `stop` parameters are relative to this modified range.
        :type after: int
        :param search: Lucene query syntax string for use with Elasticsearch. See `reference <https://lucene.apache.org/core/2_9_4/queryparsersyntax.html>`_.
        :type search: str
        :param attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute: str
        :param attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lt: str
        :param attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lte: str
        :param attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gt: str
        :param attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gte: str
        :param attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_contains: str
        :param attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :type attribute_distance: str
        :param attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :type attribute_null: str
        :param operation: Set to \"count\" to return a count of objects instead of the objects.
        :type operation: str
        :param start: Pagination start index. Index of the first item in a larger list to return.
        :type start: int
        :param stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :type stop: int
        :param exclude_parents: If a clone is present, do not send parent. (0 or 1)
        :type exclude_parents: int
        :param frame: Frame number of this localization if it is in a video.
        :type frame: int
        :param attribute_bulk_update:
        :type attribute_bulk_update: AttributeBulkUpdate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MessageResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'project',
            'media_query',
            'media_id',
            'type',
            'version',
            'modified',
            'after',
            'search',
            'attribute',
            'attribute_lt',
            'attribute_lte',
            'attribute_gt',
            'attribute_gte',
            'attribute_contains',
            'attribute_distance',
            'attribute_null',
            'operation',
            'start',
            'stop',
            'exclude_parents',
            'frame',
            'attribute_bulk_update'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_localization_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `update_localization_list`")  # noqa: E501

        if self.api_client.client_side_validation and 'exclude_parents' in local_var_params and local_var_params['exclude_parents'] > 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `exclude_parents` when calling `update_localization_list`, must be a value less than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'exclude_parents' in local_var_params and local_var_params['exclude_parents'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `exclude_parents` when calling `update_localization_list`, must be a value greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'frame' in local_var_params and local_var_params['frame'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `frame` when calling `update_localization_list`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'media_query' in local_var_params and local_var_params['media_query'] is not None:  # noqa: E501
            query_params.append(('media_query', local_var_params['media_query']))  # noqa: E501
        if 'media_id' in local_var_params and local_var_params['media_id'] is not None:  # noqa: E501
            query_params.append(('media_id', local_var_params['media_id']))  # noqa: E501
            collection_formats['media_id'] = 'csv'  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'version' in local_var_params and local_var_params['version'] is not None:  # noqa: E501
            query_params.append(('version', local_var_params['version']))  # noqa: E501
            collection_formats['version'] = 'csv'  # noqa: E501
        if 'modified' in local_var_params and local_var_params['modified'] is not None:  # noqa: E501
            query_params.append(('modified', local_var_params['modified']))  # noqa: E501
        if 'after' in local_var_params and local_var_params['after'] is not None:  # noqa: E501
            query_params.append(('after', local_var_params['after']))  # noqa: E501
        if 'search' in local_var_params and local_var_params['search'] is not None:  # noqa: E501
            query_params.append(('search', local_var_params['search']))  # noqa: E501
        if 'attribute' in local_var_params and local_var_params['attribute'] is not None:  # noqa: E501
            query_params.append(('attribute', local_var_params['attribute']))  # noqa: E501
        if 'attribute_lt' in local_var_params and local_var_params['attribute_lt'] is not None:  # noqa: E501
            query_params.append(('attribute_lt', local_var_params['attribute_lt']))  # noqa: E501
        if 'attribute_lte' in local_var_params and local_var_params['attribute_lte'] is not None:  # noqa: E501
            query_params.append(('attribute_lte', local_var_params['attribute_lte']))  # noqa: E501
        if 'attribute_gt' in local_var_params and local_var_params['attribute_gt'] is not None:  # noqa: E501
            query_params.append(('attribute_gt', local_var_params['attribute_gt']))  # noqa: E501
        if 'attribute_gte' in local_var_params and local_var_params['attribute_gte'] is not None:  # noqa: E501
            query_params.append(('attribute_gte', local_var_params['attribute_gte']))  # noqa: E501
        if 'attribute_contains' in local_var_params and local_var_params['attribute_contains'] is not None:  # noqa: E501
            query_params.append(('attribute_contains', local_var_params['attribute_contains']))  # noqa: E501
        if 'attribute_distance' in local_var_params and local_var_params['attribute_distance'] is not None:  # noqa: E501
            query_params.append(('attribute_distance', local_var_params['attribute_distance']))  # noqa: E501
        if 'attribute_null' in local_var_params and local_var_params['attribute_null'] is not None:  # noqa: E501
            query_params.append(('attribute_null', local_var_params['attribute_null']))  # noqa: E501
        if 'operation' in local_var_params and local_var_params['operation'] is not None:  # noqa: E501
            query_params.append(('operation', local_var_params['operation']))  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'stop' in local_var_params and local_var_params['stop'] is not None:  # noqa: E501
            query_params.append(('stop', local_var_params['stop']))  # noqa: E501
        if 'exclude_parents' in local_var_params and local_var_params['exclude_parents'] is not None:  # noqa: E501
            query_params.append(('excludeParents', local_var_params['exclude_parents']))  # noqa: E501
        if 'frame' in local_var_params and local_var_params['frame'] is not None:  # noqa: E501
            query_params.append(('frame', local_var_params['frame']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'attribute_bulk_update' in local_var_params:
            body_params = local_var_params['attribute_bulk_update']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Localizations/{project}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_localization_type(self, id, **kwargs):  # noqa: E501
        """update_localization_type  # noqa: E501

        Update state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_localization_type(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying an localization type. (required)
        :type id: int
        :param localization_type_update:
        :type localization_type_update: LocalizationTypeUpdate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MessageResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.update_localization_type_with_http_info(id, **kwargs)  # noqa: E501

    def update_localization_type_with_http_info(self, id, **kwargs):  # noqa: E501
        """update_localization_type  # noqa: E501

        Update state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_localization_type_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying an localization type. (required)
        :type id: int
        :param localization_type_update:
        :type localization_type_update: LocalizationTypeUpdate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MessageResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id',
            'localization_type_update'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_localization_type" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `update_localization_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'localization_type_update' in local_var_params:
            body_params = local_var_params['localization_type_update']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/LocalizationType/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_media(self, id, **kwargs):  # noqa: E501
        """update_media  # noqa: E501

        Update state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_media(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a media. (required)
        :type id: int
        :param media_update:
        :type media_update: MediaUpdate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MessageResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.update_media_with_http_info(id, **kwargs)  # noqa: E501

    def update_media_with_http_info(self, id, **kwargs):  # noqa: E501
        """update_media  # noqa: E501

        Update state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_media_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a media. (required)
        :type id: int
        :param media_update:
        :type media_update: MediaUpdate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MessageResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id',
            'media_update'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_media" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `update_media`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'media_update' in local_var_params:
            body_params = local_var_params['media_update']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Media/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_media_list(self, project, **kwargs):  # noqa: E501
        """update_media_list  # noqa: E501

        Update state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_media_list(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param media_id: List of integers identifying media.
        :type media_id: list[int]
        :param type: Unique integer identifying media type.
        :type type: int
        :param name: Name of the media to filter on.
        :type name: str
        :param md5: MD5 sum of the media file.
        :type md5: str
        :param after: If given, all results returned will be after the file with this filename. The `start` and `stop` parameters are relative to this modified range.
        :type after: str
        :param search: Lucene query syntax string for use with Elasticsearch. See `reference <https://lucene.apache.org/core/2_9_4/queryparsersyntax.html>`_.
        :type search: str
        :param attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute: str
        :param attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lt: str
        :param attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lte: str
        :param attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gt: str
        :param attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gte: str
        :param attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_contains: str
        :param attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :type attribute_distance: str
        :param attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :type attribute_null: str
        :param operation: Set to \"count\" to return a count of objects instead of the objects.
        :type operation: str
        :param start: Pagination start index. Index of the first item in a larger list to return.
        :type start: int
        :param stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :type stop: int
        :param attribute_bulk_update:
        :type attribute_bulk_update: AttributeBulkUpdate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MessageResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.update_media_list_with_http_info(project, **kwargs)  # noqa: E501

    def update_media_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """update_media_list  # noqa: E501

        Update state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_media_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param media_id: List of integers identifying media.
        :type media_id: list[int]
        :param type: Unique integer identifying media type.
        :type type: int
        :param name: Name of the media to filter on.
        :type name: str
        :param md5: MD5 sum of the media file.
        :type md5: str
        :param after: If given, all results returned will be after the file with this filename. The `start` and `stop` parameters are relative to this modified range.
        :type after: str
        :param search: Lucene query syntax string for use with Elasticsearch. See `reference <https://lucene.apache.org/core/2_9_4/queryparsersyntax.html>`_.
        :type search: str
        :param attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute: str
        :param attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lt: str
        :param attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lte: str
        :param attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gt: str
        :param attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gte: str
        :param attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_contains: str
        :param attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :type attribute_distance: str
        :param attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :type attribute_null: str
        :param operation: Set to \"count\" to return a count of objects instead of the objects.
        :type operation: str
        :param start: Pagination start index. Index of the first item in a larger list to return.
        :type start: int
        :param stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :type stop: int
        :param attribute_bulk_update:
        :type attribute_bulk_update: AttributeBulkUpdate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MessageResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'project',
            'media_id',
            'type',
            'name',
            'md5',
            'after',
            'search',
            'attribute',
            'attribute_lt',
            'attribute_lte',
            'attribute_gt',
            'attribute_gte',
            'attribute_contains',
            'attribute_distance',
            'attribute_null',
            'operation',
            'start',
            'stop',
            'attribute_bulk_update'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_media_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `update_media_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'media_id' in local_var_params and local_var_params['media_id'] is not None:  # noqa: E501
            query_params.append(('media_id', local_var_params['media_id']))  # noqa: E501
            collection_formats['media_id'] = 'csv'  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'md5' in local_var_params and local_var_params['md5'] is not None:  # noqa: E501
            query_params.append(('md5', local_var_params['md5']))  # noqa: E501
        if 'after' in local_var_params and local_var_params['after'] is not None:  # noqa: E501
            query_params.append(('after', local_var_params['after']))  # noqa: E501
        if 'search' in local_var_params and local_var_params['search'] is not None:  # noqa: E501
            query_params.append(('search', local_var_params['search']))  # noqa: E501
        if 'attribute' in local_var_params and local_var_params['attribute'] is not None:  # noqa: E501
            query_params.append(('attribute', local_var_params['attribute']))  # noqa: E501
        if 'attribute_lt' in local_var_params and local_var_params['attribute_lt'] is not None:  # noqa: E501
            query_params.append(('attribute_lt', local_var_params['attribute_lt']))  # noqa: E501
        if 'attribute_lte' in local_var_params and local_var_params['attribute_lte'] is not None:  # noqa: E501
            query_params.append(('attribute_lte', local_var_params['attribute_lte']))  # noqa: E501
        if 'attribute_gt' in local_var_params and local_var_params['attribute_gt'] is not None:  # noqa: E501
            query_params.append(('attribute_gt', local_var_params['attribute_gt']))  # noqa: E501
        if 'attribute_gte' in local_var_params and local_var_params['attribute_gte'] is not None:  # noqa: E501
            query_params.append(('attribute_gte', local_var_params['attribute_gte']))  # noqa: E501
        if 'attribute_contains' in local_var_params and local_var_params['attribute_contains'] is not None:  # noqa: E501
            query_params.append(('attribute_contains', local_var_params['attribute_contains']))  # noqa: E501
        if 'attribute_distance' in local_var_params and local_var_params['attribute_distance'] is not None:  # noqa: E501
            query_params.append(('attribute_distance', local_var_params['attribute_distance']))  # noqa: E501
        if 'attribute_null' in local_var_params and local_var_params['attribute_null'] is not None:  # noqa: E501
            query_params.append(('attribute_null', local_var_params['attribute_null']))  # noqa: E501
        if 'operation' in local_var_params and local_var_params['operation'] is not None:  # noqa: E501
            query_params.append(('operation', local_var_params['operation']))  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'stop' in local_var_params and local_var_params['stop'] is not None:  # noqa: E501
            query_params.append(('stop', local_var_params['stop']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'attribute_bulk_update' in local_var_params:
            body_params = local_var_params['attribute_bulk_update']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Medias/{project}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_media_type(self, id, **kwargs):  # noqa: E501
        """update_media_type  # noqa: E501

        Update state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_media_type(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying an media type. (required)
        :type id: int
        :param media_type_update:
        :type media_type_update: MediaTypeUpdate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MessageResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.update_media_type_with_http_info(id, **kwargs)  # noqa: E501

    def update_media_type_with_http_info(self, id, **kwargs):  # noqa: E501
        """update_media_type  # noqa: E501

        Update state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_media_type_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying an media type. (required)
        :type id: int
        :param media_type_update:
        :type media_type_update: MediaTypeUpdate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MessageResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id',
            'media_type_update'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_media_type" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `update_media_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'media_type_update' in local_var_params:
            body_params = local_var_params['media_type_update']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/MediaType/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_membership(self, id, **kwargs):  # noqa: E501
        """update_membership  # noqa: E501

        Update state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_membership(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a membership. (required)
        :type id: int
        :param membership_update:
        :type membership_update: MembershipUpdate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MessageResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.update_membership_with_http_info(id, **kwargs)  # noqa: E501

    def update_membership_with_http_info(self, id, **kwargs):  # noqa: E501
        """update_membership  # noqa: E501

        Update state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_membership_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a membership. (required)
        :type id: int
        :param membership_update:
        :type membership_update: MembershipUpdate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MessageResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id',
            'membership_update'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_membership" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `update_membership`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'membership_update' in local_var_params:
            body_params = local_var_params['membership_update']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Membership/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_project(self, id, **kwargs):  # noqa: E501
        """update_project  # noqa: E501

        Update state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_project(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a project. (required)
        :type id: int
        :param project_spec:
        :type project_spec: ProjectSpec
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MessageResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.update_project_with_http_info(id, **kwargs)  # noqa: E501

    def update_project_with_http_info(self, id, **kwargs):  # noqa: E501
        """update_project  # noqa: E501

        Update state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_project_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a project. (required)
        :type id: int
        :param project_spec:
        :type project_spec: ProjectSpec
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MessageResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id',
            'project_spec'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_project" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `update_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'project_spec' in local_var_params:
            body_params = local_var_params['project_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Project/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_state(self, id, **kwargs):  # noqa: E501
        """update_state  # noqa: E501

        Update state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_state(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a state. (required)
        :type id: int
        :param state_update:
        :type state_update: StateUpdate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MessageResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.update_state_with_http_info(id, **kwargs)  # noqa: E501

    def update_state_with_http_info(self, id, **kwargs):  # noqa: E501
        """update_state  # noqa: E501

        Update state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_state_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a state. (required)
        :type id: int
        :param state_update:
        :type state_update: StateUpdate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MessageResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id',
            'state_update'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_state" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `update_state`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'state_update' in local_var_params:
            body_params = local_var_params['state_update']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/State/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_state_list(self, project, **kwargs):  # noqa: E501
        """update_state_list  # noqa: E501

        Update state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_state_list(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param media_query: Query string used to filter media IDs. If supplied, media_id will be ignored.
        :type media_query: str
        :param media_id: Comma-separated list of media IDs.
        :type media_id: list[int]
        :param type: Unique integer identifying a annotation type.
        :type type: int
        :param version: List of integers representing versions to fetch
        :type version: list[int]
        :param modified: Whether to return original or modified annotations, 0 or 1.
        :type modified: int
        :param after: If given, all results returned will be after the localization with this ID. The `start` and `stop` parameters are relative to this modified range.
        :type after: int
        :param search: Lucene query syntax string for use with Elasticsearch. See `reference <https://lucene.apache.org/core/2_9_4/queryparsersyntax.html>`_.
        :type search: str
        :param attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute: str
        :param attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lt: str
        :param attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lte: str
        :param attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gt: str
        :param attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gte: str
        :param attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_contains: str
        :param attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :type attribute_distance: str
        :param attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :type attribute_null: str
        :param operation: Set to \"count\" to return a count of objects instead of the objects.
        :type operation: str
        :param start: Pagination start index. Index of the first item in a larger list to return.
        :type start: int
        :param stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :type stop: int
        :param attribute_bulk_update:
        :type attribute_bulk_update: AttributeBulkUpdate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MessageResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.update_state_list_with_http_info(project, **kwargs)  # noqa: E501

    def update_state_list_with_http_info(self, project, **kwargs):  # noqa: E501
        """update_state_list  # noqa: E501

        Update state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_state_list_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param media_query: Query string used to filter media IDs. If supplied, media_id will be ignored.
        :type media_query: str
        :param media_id: Comma-separated list of media IDs.
        :type media_id: list[int]
        :param type: Unique integer identifying a annotation type.
        :type type: int
        :param version: List of integers representing versions to fetch
        :type version: list[int]
        :param modified: Whether to return original or modified annotations, 0 or 1.
        :type modified: int
        :param after: If given, all results returned will be after the localization with this ID. The `start` and `stop` parameters are relative to this modified range.
        :type after: int
        :param search: Lucene query syntax string for use with Elasticsearch. See `reference <https://lucene.apache.org/core/2_9_4/queryparsersyntax.html>`_.
        :type search: str
        :param attribute: Attribute equality filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute: str
        :param attribute_lt: Attribute less than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lt: str
        :param attribute_lte: Attribute less than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_lte: str
        :param attribute_gt: Attribute greater than filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gt: str
        :param attribute_gte: Attribute greater than or equal filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_gte: str
        :param attribute_contains: Attribute contains filter. Format is attribute1::value1,[attribute2::value2].
        :type attribute_contains: str
        :param attribute_distance: Range filter for geoposition attributes. Format is attribute1::distance_km2::lat2::lon2,[attribute2::distancekm2::lat2::lon2].
        :type attribute_distance: str
        :param attribute_null: Attribute null filter. Returns elements for which a given attribute is not defined.
        :type attribute_null: str
        :param operation: Set to \"count\" to return a count of objects instead of the objects.
        :type operation: str
        :param start: Pagination start index. Index of the first item in a larger list to return.
        :type start: int
        :param stop: Pagination start index. Non-inclusive ndex of the last item in a larger list to return.
        :type stop: int
        :param attribute_bulk_update:
        :type attribute_bulk_update: AttributeBulkUpdate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MessageResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'project',
            'media_query',
            'media_id',
            'type',
            'version',
            'modified',
            'after',
            'search',
            'attribute',
            'attribute_lt',
            'attribute_lte',
            'attribute_gt',
            'attribute_gte',
            'attribute_contains',
            'attribute_distance',
            'attribute_null',
            'operation',
            'start',
            'stop',
            'attribute_bulk_update'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_state_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `update_state_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []
        if 'media_query' in local_var_params and local_var_params['media_query'] is not None:  # noqa: E501
            query_params.append(('media_query', local_var_params['media_query']))  # noqa: E501
        if 'media_id' in local_var_params and local_var_params['media_id'] is not None:  # noqa: E501
            query_params.append(('media_id', local_var_params['media_id']))  # noqa: E501
            collection_formats['media_id'] = 'csv'  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'version' in local_var_params and local_var_params['version'] is not None:  # noqa: E501
            query_params.append(('version', local_var_params['version']))  # noqa: E501
            collection_formats['version'] = 'csv'  # noqa: E501
        if 'modified' in local_var_params and local_var_params['modified'] is not None:  # noqa: E501
            query_params.append(('modified', local_var_params['modified']))  # noqa: E501
        if 'after' in local_var_params and local_var_params['after'] is not None:  # noqa: E501
            query_params.append(('after', local_var_params['after']))  # noqa: E501
        if 'search' in local_var_params and local_var_params['search'] is not None:  # noqa: E501
            query_params.append(('search', local_var_params['search']))  # noqa: E501
        if 'attribute' in local_var_params and local_var_params['attribute'] is not None:  # noqa: E501
            query_params.append(('attribute', local_var_params['attribute']))  # noqa: E501
        if 'attribute_lt' in local_var_params and local_var_params['attribute_lt'] is not None:  # noqa: E501
            query_params.append(('attribute_lt', local_var_params['attribute_lt']))  # noqa: E501
        if 'attribute_lte' in local_var_params and local_var_params['attribute_lte'] is not None:  # noqa: E501
            query_params.append(('attribute_lte', local_var_params['attribute_lte']))  # noqa: E501
        if 'attribute_gt' in local_var_params and local_var_params['attribute_gt'] is not None:  # noqa: E501
            query_params.append(('attribute_gt', local_var_params['attribute_gt']))  # noqa: E501
        if 'attribute_gte' in local_var_params and local_var_params['attribute_gte'] is not None:  # noqa: E501
            query_params.append(('attribute_gte', local_var_params['attribute_gte']))  # noqa: E501
        if 'attribute_contains' in local_var_params and local_var_params['attribute_contains'] is not None:  # noqa: E501
            query_params.append(('attribute_contains', local_var_params['attribute_contains']))  # noqa: E501
        if 'attribute_distance' in local_var_params and local_var_params['attribute_distance'] is not None:  # noqa: E501
            query_params.append(('attribute_distance', local_var_params['attribute_distance']))  # noqa: E501
        if 'attribute_null' in local_var_params and local_var_params['attribute_null'] is not None:  # noqa: E501
            query_params.append(('attribute_null', local_var_params['attribute_null']))  # noqa: E501
        if 'operation' in local_var_params and local_var_params['operation'] is not None:  # noqa: E501
            query_params.append(('operation', local_var_params['operation']))  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'stop' in local_var_params and local_var_params['stop'] is not None:  # noqa: E501
            query_params.append(('stop', local_var_params['stop']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'attribute_bulk_update' in local_var_params:
            body_params = local_var_params['attribute_bulk_update']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/States/{project}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_state_type(self, id, **kwargs):  # noqa: E501
        """update_state_type  # noqa: E501

        Update state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_state_type(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a state type. (required)
        :type id: int
        :param state_type_update:
        :type state_type_update: StateTypeUpdate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MessageResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.update_state_type_with_http_info(id, **kwargs)  # noqa: E501

    def update_state_type_with_http_info(self, id, **kwargs):  # noqa: E501
        """update_state_type  # noqa: E501

        Update state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_state_type_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a state type. (required)
        :type id: int
        :param state_type_update:
        :type state_type_update: StateTypeUpdate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MessageResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id',
            'state_type_update'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_state_type" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `update_state_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'state_type_update' in local_var_params:
            body_params = local_var_params['state_type_update']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/StateType/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_user(self, id, **kwargs):  # noqa: E501
        """update_user  # noqa: E501

        Update state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_user(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a localization association. (required)
        :type id: int
        :param user_update:
        :type user_update: UserUpdate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.update_user_with_http_info(id, **kwargs)  # noqa: E501

    def update_user_with_http_info(self, id, **kwargs):  # noqa: E501
        """update_user  # noqa: E501

        Update state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_user_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a localization association. (required)
        :type id: int
        :param user_update:
        :type user_update: UserUpdate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'id',
            'user_update'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_user" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `update_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'user_update' in local_var_params:
            body_params = local_var_params['user_update']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/User/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_version(self, id, **kwargs):  # noqa: E501
        """update_version  # noqa: E501

        Update state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_version(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a version. (required)
        :type id: int
        :param version_update:
        :type version_update: VersionUpdate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MessageResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.update_version_with_http_info(id, **kwargs)  # noqa: E501

    def update_version_with_http_info(self, id, **kwargs):  # noqa: E501
        """update_version  # noqa: E501

        Update state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_version_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: A unique integer identifying a version. (required)
        :type id: int
        :param version_update:
        :type version_update: VersionUpdate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MessageResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id',
            'version_update'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_version" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `update_version`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'version_update' in local_var_params:
            body_params = local_var_params['version_update']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/Version/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_video(self, project, **kwargs):  # noqa: E501
        """update_video  # noqa: E501

        Update state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_video(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param video_update:
        :type video_update: VideoUpdate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.update_video_with_http_info(project, **kwargs)  # noqa: E501

    def update_video_with_http_info(self, project, **kwargs):  # noqa: E501
        """update_video  # noqa: E501

        Update state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_video_with_http_info(project, async_req=True)
        >>> result = thread.get()

        :param project: A unique integer identifying a project. (required)
        :type project: int
        :param video_update:
        :type video_update: VideoUpdate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'project',
            'video_update'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_video" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project' is set
        if self.api_client.client_side_validation and ('project' not in local_var_params or  # noqa: E501
                                                        local_var_params['project'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project` when calling `update_video`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in local_var_params:
            path_params['project'] = local_var_params['project']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'video_update' in local_var_params:
            body_params = local_var_params['video_update']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/SaveVideo/{project}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def whoami(self, **kwargs):  # noqa: E501
        """whoami  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.whoami(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: User
        """
        kwargs['_return_http_data_only'] = True
        return self.whoami_with_http_info(**kwargs)  # noqa: E501

    def whoami_with_http_info(self, **kwargs):  # noqa: E501
        """whoami  # noqa: E501

        Retrieve state type.  A state type is the metadata definition object for a state. It includes association type, name, description, and (like other entity types) may have any number of attribute types associated with it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.whoami_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(User, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method whoami" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['TokenAuth']  # noqa: E501

        return self.api_client.call_api(
            '/rest/User/GetCurrent', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='User',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
