# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from tator.configuration import Configuration


class AttributeType(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'autocomplete': 'AutocompleteService',
        'choices': 'list[str]',
        'default': 'object',
        'description': 'str',
        'dtype': 'str',
        'labels': 'list[str]',
        'maximum': 'float',
        'minimum': 'float',
        'name': 'str',
        'order': 'int',
        'required': 'bool',
        'use_current': 'bool'
    }

    attribute_map = {
        'autocomplete': 'autocomplete',
        'choices': 'choices',
        'default': 'default',
        'description': 'description',
        'dtype': 'dtype',
        'labels': 'labels',
        'maximum': 'maximum',
        'minimum': 'minimum',
        'name': 'name',
        'order': 'order',
        'required': 'required',
        'use_current': 'use_current'
    }

    def __init__(self, autocomplete=None, choices=None, default=None, description='', dtype=None, labels=None, maximum=None, minimum=None, name=None, order=0, required=False, use_current=None, local_vars_configuration=None):  # noqa: E501
        """AttributeType - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._autocomplete = None
        self._choices = None
        self._default = None
        self._description = None
        self._dtype = None
        self._labels = None
        self._maximum = None
        self._minimum = None
        self._name = None
        self._order = None
        self._required = None
        self._use_current = None
        self.discriminator = None

        if autocomplete is not None:
            self.autocomplete = autocomplete
        if choices is not None:
            self.choices = choices
        self.default = default
        if description is not None:
            self.description = description
        if dtype is not None:
            self.dtype = dtype
        if labels is not None:
            self.labels = labels
        if maximum is not None:
            self.maximum = maximum
        if minimum is not None:
            self.minimum = minimum
        if name is not None:
            self.name = name
        if order is not None:
            self.order = order
        if required is not None:
            self.required = required
        if use_current is not None:
            self.use_current = use_current

    @property
    def autocomplete(self):
        """Gets the autocomplete of this AttributeType.  # noqa: E501


        :return: The autocomplete of this AttributeType.  # noqa: E501
        :rtype: AutocompleteService
        """
        return self._autocomplete

    @autocomplete.setter
    def autocomplete(self, autocomplete):
        """Sets the autocomplete of this AttributeType.


        :param autocomplete: The autocomplete of this AttributeType.  # noqa: E501
        :type autocomplete: AutocompleteService
        """

        self._autocomplete = autocomplete

    @property
    def choices(self):
        """Gets the choices of this AttributeType.  # noqa: E501

        Array of possible values for enum dtype.  # noqa: E501

        :return: The choices of this AttributeType.  # noqa: E501
        :rtype: list[str]
        """
        return self._choices

    @choices.setter
    def choices(self, choices):
        """Sets the choices of this AttributeType.

        Array of possible values for enum dtype.  # noqa: E501

        :param choices: The choices of this AttributeType.  # noqa: E501
        :type choices: list[str]
        """

        self._choices = choices

    @property
    def default(self):
        """Gets the default of this AttributeType.  # noqa: E501

        Boolean, integer, float, string, datetime, or [lon, lat].  # noqa: E501

        :return: The default of this AttributeType.  # noqa: E501
        :rtype: object
        """
        return self._default

    @default.setter
    def default(self, default):
        """Sets the default of this AttributeType.

        Boolean, integer, float, string, datetime, or [lon, lat].  # noqa: E501

        :param default: The default of this AttributeType.  # noqa: E501
        :type default: object
        """

        self._default = default

    @property
    def description(self):
        """Gets the description of this AttributeType.  # noqa: E501

        Description of the attribute.  # noqa: E501

        :return: The description of this AttributeType.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this AttributeType.

        Description of the attribute.  # noqa: E501

        :param description: The description of this AttributeType.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def dtype(self):
        """Gets the dtype of this AttributeType.  # noqa: E501

        Data type of the attribute.  # noqa: E501

        :return: The dtype of this AttributeType.  # noqa: E501
        :rtype: str
        """
        return self._dtype

    @dtype.setter
    def dtype(self, dtype):
        """Sets the dtype of this AttributeType.

        Data type of the attribute.  # noqa: E501

        :param dtype: The dtype of this AttributeType.  # noqa: E501
        :type dtype: str
        """
        allowed_values = ["bool", "int", "float", "enum", "string", "datetime", "geopos"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and dtype not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `dtype` ({0}), must be one of {1}"  # noqa: E501
                .format(dtype, allowed_values)
            )

        self._dtype = dtype

    @property
    def labels(self):
        """Gets the labels of this AttributeType.  # noqa: E501

        Array of labels for enum dtype.  # noqa: E501

        :return: The labels of this AttributeType.  # noqa: E501
        :rtype: list[str]
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this AttributeType.

        Array of labels for enum dtype.  # noqa: E501

        :param labels: The labels of this AttributeType.  # noqa: E501
        :type labels: list[str]
        """

        self._labels = labels

    @property
    def maximum(self):
        """Gets the maximum of this AttributeType.  # noqa: E501

        Upper bound for int or float dtype.  # noqa: E501

        :return: The maximum of this AttributeType.  # noqa: E501
        :rtype: float
        """
        return self._maximum

    @maximum.setter
    def maximum(self, maximum):
        """Sets the maximum of this AttributeType.

        Upper bound for int or float dtype.  # noqa: E501

        :param maximum: The maximum of this AttributeType.  # noqa: E501
        :type maximum: float
        """

        self._maximum = maximum

    @property
    def minimum(self):
        """Gets the minimum of this AttributeType.  # noqa: E501

        Lower bound for int or float dtype.  # noqa: E501

        :return: The minimum of this AttributeType.  # noqa: E501
        :rtype: float
        """
        return self._minimum

    @minimum.setter
    def minimum(self, minimum):
        """Sets the minimum of this AttributeType.

        Lower bound for int or float dtype.  # noqa: E501

        :param minimum: The minimum of this AttributeType.  # noqa: E501
        :type minimum: float
        """

        self._minimum = minimum

    @property
    def name(self):
        """Gets the name of this AttributeType.  # noqa: E501

        Name of the attribute.  # noqa: E501

        :return: The name of this AttributeType.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this AttributeType.

        Name of the attribute.  # noqa: E501

        :param name: The name of this AttributeType.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def order(self):
        """Gets the order of this AttributeType.  # noqa: E501

        Integer specifying relative order this attribute is displayed in the UI. Negative values are hidden by default.  # noqa: E501

        :return: The order of this AttributeType.  # noqa: E501
        :rtype: int
        """
        return self._order

    @order.setter
    def order(self, order):
        """Sets the order of this AttributeType.

        Integer specifying relative order this attribute is displayed in the UI. Negative values are hidden by default.  # noqa: E501

        :param order: The order of this AttributeType.  # noqa: E501
        :type order: int
        """

        self._order = order

    @property
    def required(self):
        """Gets the required of this AttributeType.  # noqa: E501

        True if this attribute is required for POST requests.  # noqa: E501

        :return: The required of this AttributeType.  # noqa: E501
        :rtype: bool
        """
        return self._required

    @required.setter
    def required(self, required):
        """Sets the required of this AttributeType.

        True if this attribute is required for POST requests.  # noqa: E501

        :param required: The required of this AttributeType.  # noqa: E501
        :type required: bool
        """

        self._required = required

    @property
    def use_current(self):
        """Gets the use_current of this AttributeType.  # noqa: E501

        True to use current datetime as default for datetime dtype.  # noqa: E501

        :return: The use_current of this AttributeType.  # noqa: E501
        :rtype: bool
        """
        return self._use_current

    @use_current.setter
    def use_current(self, use_current):
        """Sets the use_current of this AttributeType.

        True to use current datetime as default for datetime dtype.  # noqa: E501

        :param use_current: The use_current of this AttributeType.  # noqa: E501
        :type use_current: bool
        """

        self._use_current = use_current

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AttributeType):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AttributeType):
            return True

        return self.to_dict() != other.to_dict()
