# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from tator.configuration import Configuration


class MediaUpdate(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'attributes': 'dict(str, object)',
        'last_edit_end': 'datetime',
        'last_edit_start': 'datetime',
        'media_files': 'list[str]',
        'name': 'str'
    }

    attribute_map = {
        'attributes': 'attributes',
        'last_edit_end': 'last_edit_end',
        'last_edit_start': 'last_edit_start',
        'media_files': 'media_files',
        'name': 'name'
    }

    def __init__(self, attributes=None, last_edit_end=None, last_edit_start=None, media_files=None, name=None, local_vars_configuration=None):  # noqa: E501
        """MediaUpdate - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._attributes = None
        self._last_edit_end = None
        self._last_edit_start = None
        self._media_files = None
        self._name = None
        self.discriminator = None

        if attributes is not None:
            self.attributes = attributes
        if last_edit_end is not None:
            self.last_edit_end = last_edit_end
        if last_edit_start is not None:
            self.last_edit_start = last_edit_start
        if media_files is not None:
            self.media_files = media_files
        if name is not None:
            self.name = name

    @property
    def attributes(self):
        """Gets the attributes of this MediaUpdate.  # noqa: E501

        Object containing attribute values.  # noqa: E501

        :return: The attributes of this MediaUpdate.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._attributes

    @attributes.setter
    def attributes(self, attributes):
        """Sets the attributes of this MediaUpdate.

        Object containing attribute values.  # noqa: E501

        :param attributes: The attributes of this MediaUpdate.  # noqa: E501
        :type attributes: dict(str, object)
        """

        self._attributes = attributes

    @property
    def last_edit_end(self):
        """Gets the last_edit_end of this MediaUpdate.  # noqa: E501

        Datetime of the end of the session when this media or its annotations were last edited.  # noqa: E501

        :return: The last_edit_end of this MediaUpdate.  # noqa: E501
        :rtype: datetime
        """
        return self._last_edit_end

    @last_edit_end.setter
    def last_edit_end(self, last_edit_end):
        """Sets the last_edit_end of this MediaUpdate.

        Datetime of the end of the session when this media or its annotations were last edited.  # noqa: E501

        :param last_edit_end: The last_edit_end of this MediaUpdate.  # noqa: E501
        :type last_edit_end: datetime
        """

        self._last_edit_end = last_edit_end

    @property
    def last_edit_start(self):
        """Gets the last_edit_start of this MediaUpdate.  # noqa: E501

        Datetime of the start of the session when this media or its annotations were last edited.  # noqa: E501

        :return: The last_edit_start of this MediaUpdate.  # noqa: E501
        :rtype: datetime
        """
        return self._last_edit_start

    @last_edit_start.setter
    def last_edit_start(self, last_edit_start):
        """Sets the last_edit_start of this MediaUpdate.

        Datetime of the start of the session when this media or its annotations were last edited.  # noqa: E501

        :param last_edit_start: The last_edit_start of this MediaUpdate.  # noqa: E501
        :type last_edit_start: datetime
        """

        self._last_edit_start = last_edit_start

    @property
    def media_files(self):
        """Gets the media_files of this MediaUpdate.  # noqa: E501

        Object containing upload urls for the transcoded file and corresponding `VideoDefinition`.  # noqa: E501

        :return: The media_files of this MediaUpdate.  # noqa: E501
        :rtype: list[str]
        """
        return self._media_files

    @media_files.setter
    def media_files(self, media_files):
        """Sets the media_files of this MediaUpdate.

        Object containing upload urls for the transcoded file and corresponding `VideoDefinition`.  # noqa: E501

        :param media_files: The media_files of this MediaUpdate.  # noqa: E501
        :type media_files: list[str]
        """

        self._media_files = media_files

    @property
    def name(self):
        """Gets the name of this MediaUpdate.  # noqa: E501

        Name of the media.  # noqa: E501

        :return: The name of this MediaUpdate.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this MediaUpdate.

        Name of the media.  # noqa: E501

        :param name: The name of this MediaUpdate.  # noqa: E501
        :type name: str
        """

        self._name = name

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MediaUpdate):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MediaUpdate):
            return True

        return self.to_dict() != other.to_dict()
