# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from tator.configuration import Configuration


class Project(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'name': 'str',
        'num_files': 'int',
        'permission': 'str',
        'size': 'int',
        'summary': 'str',
        'thumb': 'str',
        'usernames': 'list[str]'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'num_files': 'num_files',
        'permission': 'permission',
        'size': 'size',
        'summary': 'summary',
        'thumb': 'thumb',
        'usernames': 'usernames'
    }

    def __init__(self, id=None, name=None, num_files=None, permission=None, size=None, summary='', thumb=None, usernames=None, local_vars_configuration=None):  # noqa: E501
        """Project - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._name = None
        self._num_files = None
        self._permission = None
        self._size = None
        self._summary = None
        self._thumb = None
        self._usernames = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if name is not None:
            self.name = name
        if num_files is not None:
            self.num_files = num_files
        if permission is not None:
            self.permission = permission
        if size is not None:
            self.size = size
        if summary is not None:
            self.summary = summary
        if thumb is not None:
            self.thumb = thumb
        if usernames is not None:
            self.usernames = usernames

    @property
    def id(self):
        """Gets the id of this Project.  # noqa: E501

        Unique integer identifying the project.  # noqa: E501

        :return: The id of this Project.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Project.

        Unique integer identifying the project.  # noqa: E501

        :param id: The id of this Project.  # noqa: E501
        :type id: int
        """

        self._id = id

    @property
    def name(self):
        """Gets the name of this Project.  # noqa: E501

        Name of the project.  # noqa: E501

        :return: The name of this Project.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Project.

        Name of the project.  # noqa: E501

        :param name: The name of this Project.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def num_files(self):
        """Gets the num_files of this Project.  # noqa: E501

        Number of files in the project.  # noqa: E501

        :return: The num_files of this Project.  # noqa: E501
        :rtype: int
        """
        return self._num_files

    @num_files.setter
    def num_files(self, num_files):
        """Sets the num_files of this Project.

        Number of files in the project.  # noqa: E501

        :param num_files: The num_files of this Project.  # noqa: E501
        :type num_files: int
        """

        self._num_files = num_files

    @property
    def permission(self):
        """Gets the permission of this Project.  # noqa: E501

        Permission level of user making request.  # noqa: E501

        :return: The permission of this Project.  # noqa: E501
        :rtype: str
        """
        return self._permission

    @permission.setter
    def permission(self, permission):
        """Sets the permission of this Project.

        Permission level of user making request.  # noqa: E501

        :param permission: The permission of this Project.  # noqa: E501
        :type permission: str
        """

        self._permission = permission

    @property
    def size(self):
        """Gets the size of this Project.  # noqa: E501

        Size of the project in bytes.  # noqa: E501

        :return: The size of this Project.  # noqa: E501
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this Project.

        Size of the project in bytes.  # noqa: E501

        :param size: The size of this Project.  # noqa: E501
        :type size: int
        """

        self._size = size

    @property
    def summary(self):
        """Gets the summary of this Project.  # noqa: E501

        Summary of the project.  # noqa: E501

        :return: The summary of this Project.  # noqa: E501
        :rtype: str
        """
        return self._summary

    @summary.setter
    def summary(self, summary):
        """Sets the summary of this Project.

        Summary of the project.  # noqa: E501

        :param summary: The summary of this Project.  # noqa: E501
        :type summary: str
        """

        self._summary = summary

    @property
    def thumb(self):
        """Gets the thumb of this Project.  # noqa: E501

        URL of thumbnail used to represent the project.  # noqa: E501

        :return: The thumb of this Project.  # noqa: E501
        :rtype: str
        """
        return self._thumb

    @thumb.setter
    def thumb(self, thumb):
        """Sets the thumb of this Project.

        URL of thumbnail used to represent the project.  # noqa: E501

        :param thumb: The thumb of this Project.  # noqa: E501
        :type thumb: str
        """

        self._thumb = thumb

    @property
    def usernames(self):
        """Gets the usernames of this Project.  # noqa: E501

        List of usernames of project members.  # noqa: E501

        :return: The usernames of this Project.  # noqa: E501
        :rtype: list[str]
        """
        return self._usernames

    @usernames.setter
    def usernames(self, usernames):
        """Sets the usernames of this Project.

        List of usernames of project members.  # noqa: E501

        :param usernames: The usernames of this Project.  # noqa: E501
        :type usernames: list[str]
        """

        self._usernames = usernames

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Project):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Project):
            return True

        return self.to_dict() != other.to_dict()
