# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from tator.configuration import Configuration


class State(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'attributes': 'dict(str, object)',
        'frame': 'int',
        'id': 'int',
        'localizations': 'list[int]',
        'media': 'list[int]',
        'meta': 'int',
        'modified': 'bool',
        'version': 'int'
    }

    attribute_map = {
        'attributes': 'attributes',
        'frame': 'frame',
        'id': 'id',
        'localizations': 'localizations',
        'media': 'media',
        'meta': 'meta',
        'modified': 'modified',
        'version': 'version'
    }

    def __init__(self, attributes=None, frame=None, id=None, localizations=None, media=None, meta=None, modified=None, version=None, local_vars_configuration=None):  # noqa: E501
        """State - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._attributes = None
        self._frame = None
        self._id = None
        self._localizations = None
        self._media = None
        self._meta = None
        self._modified = None
        self._version = None
        self.discriminator = None

        if attributes is not None:
            self.attributes = attributes
        if frame is not None:
            self.frame = frame
        if id is not None:
            self.id = id
        if localizations is not None:
            self.localizations = localizations
        if media is not None:
            self.media = media
        if meta is not None:
            self.meta = meta
        self.modified = modified
        if version is not None:
            self.version = version

    @property
    def attributes(self):
        """Gets the attributes of this State.  # noqa: E501

        Object containing attribute values.  # noqa: E501

        :return: The attributes of this State.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._attributes

    @attributes.setter
    def attributes(self, attributes):
        """Sets the attributes of this State.

        Object containing attribute values.  # noqa: E501

        :param attributes: The attributes of this State.  # noqa: E501
        :type attributes: dict(str, object)
        """

        self._attributes = attributes

    @property
    def frame(self):
        """Gets the frame of this State.  # noqa: E501

        Frame number this state applies to.  # noqa: E501

        :return: The frame of this State.  # noqa: E501
        :rtype: int
        """
        return self._frame

    @frame.setter
    def frame(self, frame):
        """Sets the frame of this State.

        Frame number this state applies to.  # noqa: E501

        :param frame: The frame of this State.  # noqa: E501
        :type frame: int
        """

        self._frame = frame

    @property
    def id(self):
        """Gets the id of this State.  # noqa: E501

        Unique integer identifying the state.  # noqa: E501

        :return: The id of this State.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this State.

        Unique integer identifying the state.  # noqa: E501

        :param id: The id of this State.  # noqa: E501
        :type id: int
        """

        self._id = id

    @property
    def localizations(self):
        """Gets the localizations of this State.  # noqa: E501

        List of localization IDs that this state applies to.  # noqa: E501

        :return: The localizations of this State.  # noqa: E501
        :rtype: list[int]
        """
        return self._localizations

    @localizations.setter
    def localizations(self, localizations):
        """Sets the localizations of this State.

        List of localization IDs that this state applies to.  # noqa: E501

        :param localizations: The localizations of this State.  # noqa: E501
        :type localizations: list[int]
        """

        self._localizations = localizations

    @property
    def media(self):
        """Gets the media of this State.  # noqa: E501

        List of media IDs that this state applies to.  # noqa: E501

        :return: The media of this State.  # noqa: E501
        :rtype: list[int]
        """
        return self._media

    @media.setter
    def media(self, media):
        """Sets the media of this State.

        List of media IDs that this state applies to.  # noqa: E501

        :param media: The media of this State.  # noqa: E501
        :type media: list[int]
        """

        self._media = media

    @property
    def meta(self):
        """Gets the meta of this State.  # noqa: E501

        Unique integer identifying the entity type.  # noqa: E501

        :return: The meta of this State.  # noqa: E501
        :rtype: int
        """
        return self._meta

    @meta.setter
    def meta(self, meta):
        """Sets the meta of this State.

        Unique integer identifying the entity type.  # noqa: E501

        :param meta: The meta of this State.  # noqa: E501
        :type meta: int
        """

        self._meta = meta

    @property
    def modified(self):
        """Gets the modified of this State.  # noqa: E501

        Whether this state was created in the web UI.  # noqa: E501

        :return: The modified of this State.  # noqa: E501
        :rtype: bool
        """
        return self._modified

    @modified.setter
    def modified(self, modified):
        """Sets the modified of this State.

        Whether this state was created in the web UI.  # noqa: E501

        :param modified: The modified of this State.  # noqa: E501
        :type modified: bool
        """

        self._modified = modified

    @property
    def version(self):
        """Gets the version of this State.  # noqa: E501

        Unique integer identifying the version.  # noqa: E501

        :return: The version of this State.  # noqa: E501
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this State.

        Unique integer identifying the version.  # noqa: E501

        :param version: The version of this State.  # noqa: E501
        :type version: int
        """

        self._version = version

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, State):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, State):
            return True

        return self.to_dict() != other.to_dict()
