# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from tator.configuration import Configuration


class StateSpec(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'frame': 'int',
        'localization_ids': 'list[int]',
        'media_ids': 'list[int]',
        'modified': 'bool',
        'type': 'int',
        'version': 'int'
    }

    attribute_map = {
        'frame': 'frame',
        'localization_ids': 'localization_ids',
        'media_ids': 'media_ids',
        'modified': 'modified',
        'type': 'type',
        'version': 'version'
    }

    def __init__(self, frame=None, localization_ids=None, media_ids=None, modified=None, type=None, version=None, local_vars_configuration=None):  # noqa: E501
        """StateSpec - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._frame = None
        self._localization_ids = None
        self._media_ids = None
        self._modified = None
        self._type = None
        self._version = None
        self.discriminator = None

        if frame is not None:
            self.frame = frame
        if localization_ids is not None:
            self.localization_ids = localization_ids
        self.media_ids = media_ids
        self.modified = modified
        self.type = type
        if version is not None:
            self.version = version

    @property
    def frame(self):
        """Gets the frame of this StateSpec.  # noqa: E501

        Frame number this state applies to.  # noqa: E501

        :return: The frame of this StateSpec.  # noqa: E501
        :rtype: int
        """
        return self._frame

    @frame.setter
    def frame(self, frame):
        """Sets the frame of this StateSpec.

        Frame number this state applies to.  # noqa: E501

        :param frame: The frame of this StateSpec.  # noqa: E501
        :type frame: int
        """

        self._frame = frame

    @property
    def localization_ids(self):
        """Gets the localization_ids of this StateSpec.  # noqa: E501

        List of localization IDs that this state applies to.  # noqa: E501

        :return: The localization_ids of this StateSpec.  # noqa: E501
        :rtype: list[int]
        """
        return self._localization_ids

    @localization_ids.setter
    def localization_ids(self, localization_ids):
        """Sets the localization_ids of this StateSpec.

        List of localization IDs that this state applies to.  # noqa: E501

        :param localization_ids: The localization_ids of this StateSpec.  # noqa: E501
        :type localization_ids: list[int]
        """

        self._localization_ids = localization_ids

    @property
    def media_ids(self):
        """Gets the media_ids of this StateSpec.  # noqa: E501

        List of media IDs that this state applies to.  # noqa: E501

        :return: The media_ids of this StateSpec.  # noqa: E501
        :rtype: list[int]
        """
        return self._media_ids

    @media_ids.setter
    def media_ids(self, media_ids):
        """Sets the media_ids of this StateSpec.

        List of media IDs that this state applies to.  # noqa: E501

        :param media_ids: The media_ids of this StateSpec.  # noqa: E501
        :type media_ids: list[int]
        """
        if self.local_vars_configuration.client_side_validation and media_ids is None:  # noqa: E501
            raise ValueError("Invalid value for `media_ids`, must not be `None`")  # noqa: E501

        self._media_ids = media_ids

    @property
    def modified(self):
        """Gets the modified of this StateSpec.  # noqa: E501

        Whether this state was created in the web UI.  # noqa: E501

        :return: The modified of this StateSpec.  # noqa: E501
        :rtype: bool
        """
        return self._modified

    @modified.setter
    def modified(self, modified):
        """Sets the modified of this StateSpec.

        Whether this state was created in the web UI.  # noqa: E501

        :param modified: The modified of this StateSpec.  # noqa: E501
        :type modified: bool
        """

        self._modified = modified

    @property
    def type(self):
        """Gets the type of this StateSpec.  # noqa: E501

        Unique integer identifying a state type.  # noqa: E501

        :return: The type of this StateSpec.  # noqa: E501
        :rtype: int
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this StateSpec.

        Unique integer identifying a state type.  # noqa: E501

        :param type: The type of this StateSpec.  # noqa: E501
        :type type: int
        """
        if self.local_vars_configuration.client_side_validation and type is None:  # noqa: E501
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    @property
    def version(self):
        """Gets the version of this StateSpec.  # noqa: E501

        Unique integer identifying the version.  # noqa: E501

        :return: The version of this StateSpec.  # noqa: E501
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this StateSpec.

        Unique integer identifying the version.  # noqa: E501

        :param version: The version of this StateSpec.  # noqa: E501
        :type version: int
        """

        self._version = version

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, StateSpec):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, StateSpec):
            return True

        return self.to_dict() != other.to_dict()
