# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from tator.configuration import Configuration


class VideoSpec(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'codec': 'str',
        'fps': 'float',
        'gid': 'str',
        'height': 'int',
        'md5': 'str',
        'media_files': 'list[str]',
        'name': 'str',
        'num_frames': 'int',
        'progress_name': 'str',
        'section': 'str',
        'thumbnail_gif_url': 'str',
        'thumbnail_url': 'str',
        'type': 'int',
        'uid': 'str',
        'width': 'int'
    }

    attribute_map = {
        'codec': 'codec',
        'fps': 'fps',
        'gid': 'gid',
        'height': 'height',
        'md5': 'md5',
        'media_files': 'media_files',
        'name': 'name',
        'num_frames': 'num_frames',
        'progress_name': 'progressName',
        'section': 'section',
        'thumbnail_gif_url': 'thumbnail_gif_url',
        'thumbnail_url': 'thumbnail_url',
        'type': 'type',
        'uid': 'uid',
        'width': 'width'
    }

    def __init__(self, codec=None, fps=None, gid=None, height=None, md5=None, media_files=None, name=None, num_frames=None, progress_name=None, section=None, thumbnail_gif_url=None, thumbnail_url=None, type=None, uid=None, width=None, local_vars_configuration=None):  # noqa: E501
        """VideoSpec - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._codec = None
        self._fps = None
        self._gid = None
        self._height = None
        self._md5 = None
        self._media_files = None
        self._name = None
        self._num_frames = None
        self._progress_name = None
        self._section = None
        self._thumbnail_gif_url = None
        self._thumbnail_url = None
        self._type = None
        self._uid = None
        self._width = None
        self.discriminator = None

        self.codec = codec
        self.fps = fps
        self.gid = gid
        self.height = height
        self.md5 = md5
        self.media_files = media_files
        self.name = name
        self.num_frames = num_frames
        if progress_name is not None:
            self.progress_name = progress_name
        self.section = section
        self.thumbnail_gif_url = thumbnail_gif_url
        self.thumbnail_url = thumbnail_url
        self.type = type
        self.uid = uid
        self.width = width

    @property
    def codec(self):
        """Gets the codec of this VideoSpec.  # noqa: E501

        Codec of the original video.  # noqa: E501

        :return: The codec of this VideoSpec.  # noqa: E501
        :rtype: str
        """
        return self._codec

    @codec.setter
    def codec(self, codec):
        """Sets the codec of this VideoSpec.

        Codec of the original video.  # noqa: E501

        :param codec: The codec of this VideoSpec.  # noqa: E501
        :type codec: str
        """
        if self.local_vars_configuration.client_side_validation and codec is None:  # noqa: E501
            raise ValueError("Invalid value for `codec`, must not be `None`")  # noqa: E501

        self._codec = codec

    @property
    def fps(self):
        """Gets the fps of this VideoSpec.  # noqa: E501

        Frame rate of the video.  # noqa: E501

        :return: The fps of this VideoSpec.  # noqa: E501
        :rtype: float
        """
        return self._fps

    @fps.setter
    def fps(self, fps):
        """Sets the fps of this VideoSpec.

        Frame rate of the video.  # noqa: E501

        :param fps: The fps of this VideoSpec.  # noqa: E501
        :type fps: float
        """
        if self.local_vars_configuration.client_side_validation and fps is None:  # noqa: E501
            raise ValueError("Invalid value for `fps`, must not be `None`")  # noqa: E501

        self._fps = fps

    @property
    def gid(self):
        """Gets the gid of this VideoSpec.  # noqa: E501

        UUID generated for the job group. This value is returned in the response of the `AlgorithmLaunch` and `Transcode` endpoints.  # noqa: E501

        :return: The gid of this VideoSpec.  # noqa: E501
        :rtype: str
        """
        return self._gid

    @gid.setter
    def gid(self, gid):
        """Sets the gid of this VideoSpec.

        UUID generated for the job group. This value is returned in the response of the `AlgorithmLaunch` and `Transcode` endpoints.  # noqa: E501

        :param gid: The gid of this VideoSpec.  # noqa: E501
        :type gid: str
        """
        if self.local_vars_configuration.client_side_validation and gid is None:  # noqa: E501
            raise ValueError("Invalid value for `gid`, must not be `None`")  # noqa: E501

        self._gid = gid

    @property
    def height(self):
        """Gets the height of this VideoSpec.  # noqa: E501

        Pixel height of the video.  # noqa: E501

        :return: The height of this VideoSpec.  # noqa: E501
        :rtype: int
        """
        return self._height

    @height.setter
    def height(self, height):
        """Sets the height of this VideoSpec.

        Pixel height of the video.  # noqa: E501

        :param height: The height of this VideoSpec.  # noqa: E501
        :type height: int
        """
        if self.local_vars_configuration.client_side_validation and height is None:  # noqa: E501
            raise ValueError("Invalid value for `height`, must not be `None`")  # noqa: E501

        self._height = height

    @property
    def md5(self):
        """Gets the md5 of this VideoSpec.  # noqa: E501

        MD5 sum of the media file.  # noqa: E501

        :return: The md5 of this VideoSpec.  # noqa: E501
        :rtype: str
        """
        return self._md5

    @md5.setter
    def md5(self, md5):
        """Sets the md5 of this VideoSpec.

        MD5 sum of the media file.  # noqa: E501

        :param md5: The md5 of this VideoSpec.  # noqa: E501
        :type md5: str
        """
        if self.local_vars_configuration.client_side_validation and md5 is None:  # noqa: E501
            raise ValueError("Invalid value for `md5`, must not be `None`")  # noqa: E501

        self._md5 = md5

    @property
    def media_files(self):
        """Gets the media_files of this VideoSpec.  # noqa: E501

        Object containing upload urls for the transcoded file and corresponding `VideoDefinition`.  # noqa: E501

        :return: The media_files of this VideoSpec.  # noqa: E501
        :rtype: list[str]
        """
        return self._media_files

    @media_files.setter
    def media_files(self, media_files):
        """Sets the media_files of this VideoSpec.

        Object containing upload urls for the transcoded file and corresponding `VideoDefinition`.  # noqa: E501

        :param media_files: The media_files of this VideoSpec.  # noqa: E501
        :type media_files: list[str]
        """
        if self.local_vars_configuration.client_side_validation and media_files is None:  # noqa: E501
            raise ValueError("Invalid value for `media_files`, must not be `None`")  # noqa: E501

        self._media_files = media_files

    @property
    def name(self):
        """Gets the name of this VideoSpec.  # noqa: E501

        Name of the file.  # noqa: E501

        :return: The name of this VideoSpec.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this VideoSpec.

        Name of the file.  # noqa: E501

        :param name: The name of this VideoSpec.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def num_frames(self):
        """Gets the num_frames of this VideoSpec.  # noqa: E501

        Number of frames in the video.  # noqa: E501

        :return: The num_frames of this VideoSpec.  # noqa: E501
        :rtype: int
        """
        return self._num_frames

    @num_frames.setter
    def num_frames(self, num_frames):
        """Sets the num_frames of this VideoSpec.

        Number of frames in the video.  # noqa: E501

        :param num_frames: The num_frames of this VideoSpec.  # noqa: E501
        :type num_frames: int
        """
        if self.local_vars_configuration.client_side_validation and num_frames is None:  # noqa: E501
            raise ValueError("Invalid value for `num_frames`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                num_frames is not None and num_frames < 0):  # noqa: E501
            raise ValueError("Invalid value for `num_frames`, must be a value greater than or equal to `0`")  # noqa: E501

        self._num_frames = num_frames

    @property
    def progress_name(self):
        """Gets the progress_name of this VideoSpec.  # noqa: E501

        Name to use for progress update.  # noqa: E501

        :return: The progress_name of this VideoSpec.  # noqa: E501
        :rtype: str
        """
        return self._progress_name

    @progress_name.setter
    def progress_name(self, progress_name):
        """Sets the progress_name of this VideoSpec.

        Name to use for progress update.  # noqa: E501

        :param progress_name: The progress_name of this VideoSpec.  # noqa: E501
        :type progress_name: str
        """

        self._progress_name = progress_name

    @property
    def section(self):
        """Gets the section of this VideoSpec.  # noqa: E501

        Media section name.  # noqa: E501

        :return: The section of this VideoSpec.  # noqa: E501
        :rtype: str
        """
        return self._section

    @section.setter
    def section(self, section):
        """Sets the section of this VideoSpec.

        Media section name.  # noqa: E501

        :param section: The section of this VideoSpec.  # noqa: E501
        :type section: str
        """
        if self.local_vars_configuration.client_side_validation and section is None:  # noqa: E501
            raise ValueError("Invalid value for `section`, must not be `None`")  # noqa: E501

        self._section = section

    @property
    def thumbnail_gif_url(self):
        """Gets the thumbnail_gif_url of this VideoSpec.  # noqa: E501

        Upload URL for the thumbnail gif.  # noqa: E501

        :return: The thumbnail_gif_url of this VideoSpec.  # noqa: E501
        :rtype: str
        """
        return self._thumbnail_gif_url

    @thumbnail_gif_url.setter
    def thumbnail_gif_url(self, thumbnail_gif_url):
        """Sets the thumbnail_gif_url of this VideoSpec.

        Upload URL for the thumbnail gif.  # noqa: E501

        :param thumbnail_gif_url: The thumbnail_gif_url of this VideoSpec.  # noqa: E501
        :type thumbnail_gif_url: str
        """
        if self.local_vars_configuration.client_side_validation and thumbnail_gif_url is None:  # noqa: E501
            raise ValueError("Invalid value for `thumbnail_gif_url`, must not be `None`")  # noqa: E501

        self._thumbnail_gif_url = thumbnail_gif_url

    @property
    def thumbnail_url(self):
        """Gets the thumbnail_url of this VideoSpec.  # noqa: E501

        Upload URL for the thumbnail.  # noqa: E501

        :return: The thumbnail_url of this VideoSpec.  # noqa: E501
        :rtype: str
        """
        return self._thumbnail_url

    @thumbnail_url.setter
    def thumbnail_url(self, thumbnail_url):
        """Sets the thumbnail_url of this VideoSpec.

        Upload URL for the thumbnail.  # noqa: E501

        :param thumbnail_url: The thumbnail_url of this VideoSpec.  # noqa: E501
        :type thumbnail_url: str
        """
        if self.local_vars_configuration.client_side_validation and thumbnail_url is None:  # noqa: E501
            raise ValueError("Invalid value for `thumbnail_url`, must not be `None`")  # noqa: E501

        self._thumbnail_url = thumbnail_url

    @property
    def type(self):
        """Gets the type of this VideoSpec.  # noqa: E501

        Unique integer identifying a video type. Use -1 to automatically select the video type if only one video type exists in a project.  # noqa: E501

        :return: The type of this VideoSpec.  # noqa: E501
        :rtype: int
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this VideoSpec.

        Unique integer identifying a video type. Use -1 to automatically select the video type if only one video type exists in a project.  # noqa: E501

        :param type: The type of this VideoSpec.  # noqa: E501
        :type type: int
        """
        if self.local_vars_configuration.client_side_validation and type is None:  # noqa: E501
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                type is not None and type < -1):  # noqa: E501
            raise ValueError("Invalid value for `type`, must be a value greater than or equal to `-1`")  # noqa: E501

        self._type = type

    @property
    def uid(self):
        """Gets the uid of this VideoSpec.  # noqa: E501

        UUID generated for the individual job. This value is returned in the response of the `AlgorithmLaunch` and `Transcode` endpoints.  # noqa: E501

        :return: The uid of this VideoSpec.  # noqa: E501
        :rtype: str
        """
        return self._uid

    @uid.setter
    def uid(self, uid):
        """Sets the uid of this VideoSpec.

        UUID generated for the individual job. This value is returned in the response of the `AlgorithmLaunch` and `Transcode` endpoints.  # noqa: E501

        :param uid: The uid of this VideoSpec.  # noqa: E501
        :type uid: str
        """
        if self.local_vars_configuration.client_side_validation and uid is None:  # noqa: E501
            raise ValueError("Invalid value for `uid`, must not be `None`")  # noqa: E501

        self._uid = uid

    @property
    def width(self):
        """Gets the width of this VideoSpec.  # noqa: E501

        Pixel width of the video.  # noqa: E501

        :return: The width of this VideoSpec.  # noqa: E501
        :rtype: int
        """
        return self._width

    @width.setter
    def width(self, width):
        """Sets the width of this VideoSpec.

        Pixel width of the video.  # noqa: E501

        :param width: The width of this VideoSpec.  # noqa: E501
        :type width: int
        """
        if self.local_vars_configuration.client_side_validation and width is None:  # noqa: E501
            raise ValueError("Invalid value for `width`, must not be `None`")  # noqa: E501

        self._width = width

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VideoSpec):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VideoSpec):
            return True

        return self.to_dict() != other.to_dict()
