# -*- coding: UTF-8 -*-
# Code generated by lark suite oapi sdk gen

from typing import *

from ....api import Request, Response, set_timeout, set_tenant_key, set_user_access_token, set_path_params, \
    set_query_params, set_response_stream, set_is_response_stream, FormData, FormDataFile
from ....config import Config
from ....consts import ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_APP
from .model import *


class Service(object):
    def __init__(self, conf):
        # type: (Config) -> None
        self.conf = conf
        self.users = UserService(self)
        self.user_groups = UserGroupService(self)
        self.departments = DepartmentService(self)
        self.scopes = ScopeService(self)
        self.custom_attr_events = CustomAttrEventService(self)
        self.employee_type_enums = EmployeeTypeEnumService(self)
        



class UserService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def delete(self, body, tenant_key=None, timeout=None):
        # type: (UserDeleteReqBody, str, int) -> UserDeleteReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return UserDeleteReqCall(self, body, request_opts=request_opts)

    def update(self, body, tenant_key=None, timeout=None):
        # type: (User, str, int) -> UserUpdateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return UserUpdateReqCall(self, body, request_opts=request_opts)

    def create(self, body, tenant_key=None, timeout=None):
        # type: (User, str, int) -> UserCreateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return UserCreateReqCall(self, body, request_opts=request_opts)

    def patch(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (User, str, str, int) -> UserPatchReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return UserPatchReqCall(self, body, request_opts=request_opts)

    def get(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> UserGetReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return UserGetReqCall(self, request_opts=request_opts)

    def list(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> UserListReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return UserListReqCall(self, request_opts=request_opts)


class UserGroupService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service


class DepartmentService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def get(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> DepartmentGetReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return DepartmentGetReqCall(self, request_opts=request_opts)

    def list(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> DepartmentListReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return DepartmentListReqCall(self, request_opts=request_opts)

    def patch(self, body, tenant_key=None, timeout=None):
        # type: (Department, str, int) -> DepartmentPatchReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return DepartmentPatchReqCall(self, body, request_opts=request_opts)

    def create(self, body, tenant_key=None, timeout=None):
        # type: (Department, str, int) -> DepartmentCreateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return DepartmentCreateReqCall(self, body, request_opts=request_opts)

    def delete(self, tenant_key=None, timeout=None):
        # type: (str, int) -> DepartmentDeleteReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return DepartmentDeleteReqCall(self, request_opts=request_opts)

    def update(self, body, tenant_key=None, timeout=None):
        # type: (Department, str, int) -> DepartmentUpdateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return DepartmentUpdateReqCall(self, body, request_opts=request_opts)

    def parent(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> DepartmentParentReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return DepartmentParentReqCall(self, request_opts=request_opts)

    def search(self, body, user_access_token=None, timeout=None):
        # type: (DepartmentSearchReqBody, str, int) -> DepartmentSearchReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return DepartmentSearchReqCall(self, body, request_opts=request_opts)


class ScopeService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service


class CustomAttrEventService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service


class EmployeeTypeEnumService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service



class DepartmentGetReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (DepartmentService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_department_id(self, department_id):
        # type: (str) -> DepartmentGetReqCall
        self.path_params['department_id'] = department_id
        return self

    def set_user_id_type(self, user_id_type):
        # type: (str) -> DepartmentGetReqCall
        self.query_params['user_id_type'] = user_id_type
        return self

    def set_department_id_type(self, department_id_type):
        # type: (str) -> DepartmentGetReqCall
        self.query_params['department_id_type'] = department_id_type
        return self

    def do(self):
        # type: () -> Response[DepartmentGetResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('contact/v3/departments/:department_id', 'GET', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                      None, output_class=DepartmentGetResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class UserDeleteReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (UserService, UserDeleteReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_user_id(self, user_id):
        # type: (str) -> UserDeleteReqCall
        self.path_params['user_id'] = user_id
        return self

    def set_user_id_type(self, user_id_type):
        # type: (str) -> UserDeleteReqCall
        self.query_params['user_id_type'] = user_id_type
        return self

    def do(self):
        # type: () -> Response[None]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('contact/v3/users/:user_id', 'DELETE', [ACCESS_TOKEN_TYPE_TENANT],
                      self.body, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class DepartmentListReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (DepartmentService, List[Any]) -> None

        self.service = service
        
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_user_id_type(self, user_id_type):
        # type: (str) -> DepartmentListReqCall
        self.query_params['user_id_type'] = user_id_type
        return self

    def set_department_id_type(self, department_id_type):
        # type: (str) -> DepartmentListReqCall
        self.query_params['department_id_type'] = department_id_type
        return self

    def set_parent_department_id(self, parent_department_id):
        # type: (str) -> DepartmentListReqCall
        self.query_params['parent_department_id'] = parent_department_id
        return self

    def set_fetch_child(self, fetch_child):
        # type: (bool) -> DepartmentListReqCall
        self.query_params['fetch_child'] = fetch_child
        return self

    def set_page_token(self, page_token):
        # type: (str) -> DepartmentListReqCall
        self.query_params['page_token'] = page_token
        return self

    def set_page_size(self, page_size):
        # type: (int) -> DepartmentListReqCall
        self.query_params['page_size'] = page_size
        return self

    def do(self):
        # type: () -> Response[DepartmentListResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('contact/v3/departments', 'GET', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                      None, output_class=DepartmentListResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class DepartmentPatchReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (DepartmentService, Department, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_department_id(self, department_id):
        # type: (str) -> DepartmentPatchReqCall
        self.path_params['department_id'] = department_id
        return self

    def set_user_id_type(self, user_id_type):
        # type: (str) -> DepartmentPatchReqCall
        self.query_params['user_id_type'] = user_id_type
        return self

    def set_department_id_type(self, department_id_type):
        # type: (str) -> DepartmentPatchReqCall
        self.query_params['department_id_type'] = department_id_type
        return self

    def do(self):
        # type: () -> Response[DepartmentPatchResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('contact/v3/departments/:department_id', 'PATCH', [ACCESS_TOKEN_TYPE_TENANT],
                      self.body, output_class=DepartmentPatchResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class UserUpdateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (UserService, User, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_user_id(self, user_id):
        # type: (str) -> UserUpdateReqCall
        self.path_params['user_id'] = user_id
        return self

    def set_user_id_type(self, user_id_type):
        # type: (str) -> UserUpdateReqCall
        self.query_params['user_id_type'] = user_id_type
        return self

    def set_department_id_type(self, department_id_type):
        # type: (str) -> UserUpdateReqCall
        self.query_params['department_id_type'] = department_id_type
        return self

    def do(self):
        # type: () -> Response[UserUpdateResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('contact/v3/users/:user_id', 'PUT', [ACCESS_TOKEN_TYPE_TENANT],
                      self.body, output_class=UserUpdateResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class UserCreateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (UserService, User, List[Any]) -> None

        self.service = service
        self.body = body
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_user_id_type(self, user_id_type):
        # type: (str) -> UserCreateReqCall
        self.query_params['user_id_type'] = user_id_type
        return self

    def set_department_id_type(self, department_id_type):
        # type: (str) -> UserCreateReqCall
        self.query_params['department_id_type'] = department_id_type
        return self

    def set_client_token(self, client_token):
        # type: (str) -> UserCreateReqCall
        self.query_params['client_token'] = client_token
        return self

    def do(self):
        # type: () -> Response[UserCreateResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('contact/v3/users', 'POST', [ACCESS_TOKEN_TYPE_TENANT],
                      self.body, output_class=UserCreateResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class UserPatchReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (UserService, User, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_user_id(self, user_id):
        # type: (str) -> UserPatchReqCall
        self.path_params['user_id'] = user_id
        return self

    def set_user_id_type(self, user_id_type):
        # type: (str) -> UserPatchReqCall
        self.query_params['user_id_type'] = user_id_type
        return self

    def set_department_id_type(self, department_id_type):
        # type: (str) -> UserPatchReqCall
        self.query_params['department_id_type'] = department_id_type
        return self

    def do(self):
        # type: () -> Response[UserPatchResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('contact/v3/users/:user_id', 'PATCH', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                      self.body, output_class=UserPatchResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class DepartmentCreateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (DepartmentService, Department, List[Any]) -> None

        self.service = service
        self.body = body
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_user_id_type(self, user_id_type):
        # type: (str) -> DepartmentCreateReqCall
        self.query_params['user_id_type'] = user_id_type
        return self

    def set_department_id_type(self, department_id_type):
        # type: (str) -> DepartmentCreateReqCall
        self.query_params['department_id_type'] = department_id_type
        return self

    def set_client_token(self, client_token):
        # type: (str) -> DepartmentCreateReqCall
        self.query_params['client_token'] = client_token
        return self

    def do(self):
        # type: () -> Response[DepartmentCreateResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('contact/v3/departments', 'POST', [ACCESS_TOKEN_TYPE_TENANT],
                      self.body, output_class=DepartmentCreateResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class DepartmentDeleteReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (DepartmentService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_department_id(self, department_id):
        # type: (str) -> DepartmentDeleteReqCall
        self.path_params['department_id'] = department_id
        return self

    def set_department_id_type(self, department_id_type):
        # type: (str) -> DepartmentDeleteReqCall
        self.query_params['department_id_type'] = department_id_type
        return self

    def do(self):
        # type: () -> Response[None]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('contact/v3/departments/:department_id', 'DELETE', [ACCESS_TOKEN_TYPE_TENANT],
                      None, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class UserGetReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (UserService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_user_id(self, user_id):
        # type: (str) -> UserGetReqCall
        self.path_params['user_id'] = user_id
        return self

    def set_user_id_type(self, user_id_type):
        # type: (str) -> UserGetReqCall
        self.query_params['user_id_type'] = user_id_type
        return self

    def set_department_id_type(self, department_id_type):
        # type: (str) -> UserGetReqCall
        self.query_params['department_id_type'] = department_id_type
        return self

    def do(self):
        # type: () -> Response[UserGetResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('contact/v3/users/:user_id', 'GET', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                      None, output_class=UserGetResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class DepartmentUpdateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (DepartmentService, Department, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_department_id(self, department_id):
        # type: (str) -> DepartmentUpdateReqCall
        self.path_params['department_id'] = department_id
        return self

    def set_user_id_type(self, user_id_type):
        # type: (str) -> DepartmentUpdateReqCall
        self.query_params['user_id_type'] = user_id_type
        return self

    def set_department_id_type(self, department_id_type):
        # type: (str) -> DepartmentUpdateReqCall
        self.query_params['department_id_type'] = department_id_type
        return self

    def do(self):
        # type: () -> Response[DepartmentUpdateResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('contact/v3/departments/:department_id', 'PUT', [ACCESS_TOKEN_TYPE_TENANT],
                      self.body, output_class=DepartmentUpdateResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class UserListReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (UserService, List[Any]) -> None

        self.service = service
        
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_user_id_type(self, user_id_type):
        # type: (str) -> UserListReqCall
        self.query_params['user_id_type'] = user_id_type
        return self

    def set_department_id_type(self, department_id_type):
        # type: (str) -> UserListReqCall
        self.query_params['department_id_type'] = department_id_type
        return self

    def set_department_id(self, department_id):
        # type: (str) -> UserListReqCall
        self.query_params['department_id'] = department_id
        return self

    def set_page_token(self, page_token):
        # type: (str) -> UserListReqCall
        self.query_params['page_token'] = page_token
        return self

    def set_page_size(self, page_size):
        # type: (int) -> UserListReqCall
        self.query_params['page_size'] = page_size
        return self

    def do(self):
        # type: () -> Response[UserListResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('contact/v3/users', 'GET', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                      None, output_class=UserListResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class DepartmentParentReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (DepartmentService, List[Any]) -> None

        self.service = service
        
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_user_id_type(self, user_id_type):
        # type: (str) -> DepartmentParentReqCall
        self.query_params['user_id_type'] = user_id_type
        return self

    def set_department_id_type(self, department_id_type):
        # type: (str) -> DepartmentParentReqCall
        self.query_params['department_id_type'] = department_id_type
        return self

    def set_department_id(self, department_id):
        # type: (str) -> DepartmentParentReqCall
        self.query_params['department_id'] = department_id
        return self

    def set_page_token(self, page_token):
        # type: (str) -> DepartmentParentReqCall
        self.query_params['page_token'] = page_token
        return self

    def set_page_size(self, page_size):
        # type: (int) -> DepartmentParentReqCall
        self.query_params['page_size'] = page_size
        return self

    def do(self):
        # type: () -> Response[DepartmentParentResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('contact/v3/departments/parent', 'GET', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                      None, output_class=DepartmentParentResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class DepartmentSearchReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (DepartmentService, DepartmentSearchReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_user_id_type(self, user_id_type):
        # type: (str) -> DepartmentSearchReqCall
        self.query_params['user_id_type'] = user_id_type
        return self

    def set_department_id_type(self, department_id_type):
        # type: (str) -> DepartmentSearchReqCall
        self.query_params['department_id_type'] = department_id_type
        return self

    def set_page_token(self, page_token):
        # type: (str) -> DepartmentSearchReqCall
        self.query_params['page_token'] = page_token
        return self

    def set_page_size(self, page_size):
        # type: (int) -> DepartmentSearchReqCall
        self.query_params['page_size'] = page_size
        return self

    def do(self):
        # type: () -> Response[DepartmentSearchResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('contact/v3/departments/search', 'POST', [ACCESS_TOKEN_TYPE_USER],
                      self.body, output_class=DepartmentSearchResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp

