# -*- coding: UTF-8 -*-
# Code generated by lark suite oapi sdk gen

from typing import *

from ....api import Request, Response, set_timeout, set_tenant_key, set_user_access_token, set_path_params, \
    set_query_params, set_response_stream, set_is_response_stream, FormData, FormDataFile
from ....config import Config
from ....consts import ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_APP
from .model import *


class Service(object):
    def __init__(self, conf):
        # type: (Config) -> None
        self.conf = conf
        self.docs = DocService(self)
        



class DocService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def batch_update(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (DocBatchUpdateReqBody, str, str, int) -> DocBatchUpdateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return DocBatchUpdateReqCall(self, body, request_opts=request_opts)

    def content(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> DocContentReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return DocContentReqCall(self, request_opts=request_opts)

    def create(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (DocCreateReqBody, str, str, int) -> DocCreateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return DocCreateReqCall(self, body, request_opts=request_opts)

    def meta(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> DocMetaReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return DocMetaReqCall(self, request_opts=request_opts)

    def raw_content(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> DocRawContentReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return DocRawContentReqCall(self, request_opts=request_opts)



class DocBatchUpdateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (DocService, DocBatchUpdateReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_docToken(self, doc_token):
        # type: (str) -> DocBatchUpdateReqCall
        self.path_params['docToken'] = doc_token
        return self

    def do(self):
        # type: () -> Response[None]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = Request('/open-apis/doc/v2/:docToken/batch_update', 'POST', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                      self.body, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class DocContentReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (DocService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_docToken(self, doc_token):
        # type: (str) -> DocContentReqCall
        self.path_params['docToken'] = doc_token
        return self

    def do(self):
        # type: () -> Response[DocContentResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = Request('/open-apis/doc/v2/:docToken/content', 'GET', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                      None, output_class=DocContentResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class DocCreateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (DocService, DocCreateReqBody, List[Any]) -> None

        self.service = service
        self.body = body

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> Response[DocCreateResult]
        root_service = self.service.service

        conf = root_service.conf
        req = Request('/open-apis/doc/v2/create', 'POST', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                      self.body, output_class=DocCreateResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class DocMetaReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (DocService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_docToken(self, doc_token):
        # type: (str) -> DocMetaReqCall
        self.path_params['docToken'] = doc_token
        return self

    def do(self):
        # type: () -> Response[DocMetaResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = Request('/open-apis/doc/v2/meta/:docToken', 'GET', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                      None, output_class=DocMetaResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class DocRawContentReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (DocService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_docToken(self, doc_token):
        # type: (str) -> DocRawContentReqCall
        self.path_params['docToken'] = doc_token
        return self

    def do(self):
        # type: () -> Response[DocRawContentResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = Request('/open-apis/doc/v2/:docToken/raw_content', 'GET', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                      None, output_class=DocRawContentResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp

