# -*- coding: UTF-8 -*-
# Code generated by lark suite oapi sdk gen

from typing import *

from ....api import Request, Response, set_timeout, set_tenant_key, set_user_access_token, set_path_params, \
    set_query_params, set_response_stream, set_is_response_stream, FormData, FormDataFile
from ....config import Config
from ....consts import ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_APP
from .model import *


class Service(object):
    def __init__(self, conf):
        # type: (Config) -> None
        self.conf = conf
        self.tenants = TenantService(self)
        



class TenantService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def query(self, tenant_key=None, timeout=None):
        # type: (str, int) -> TenantQueryReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return TenantQueryReqCall(self, request_opts=request_opts)



class TenantQueryReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (TenantService, List[Any]) -> None

        self.service = service
        

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> Response[TenantQueryResult]
        root_service = self.service.service

        conf = root_service.conf
        req = Request('/open-apis/tenant/v2/tenant/query', 'GET', [ACCESS_TOKEN_TYPE_TENANT],
                      None, output_class=TenantQueryResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp

