# flake8: noqa
# generated by 'xml2py',
# flags '-kdefst -d -c -o _ftd2xx_linux.py ftd2xx_linux.xml -l libftd2xx.so'
# from ctypes import CDLL, c_char_p, c_char,
from ctypes import (
    CFUNCTYPE,
    POINTER,
    Structure,
    CDLL,
    c_char,
    c_char_p,
    c_int,
    c_uint,
    c_short,
    c_ubyte,
    c_long,
    c_ulong,
    c_longlong,
    c_ulonglong,
    c_ushort,
    c_void_p,
)
from typing import List

_libraries = {}
_libraries["libftd2xx.so"] = CDLL("libftd2xx.so")
STRING = c_char_p

FT_DEVICE_BM = 0
FT_DEVICE_AM = 1
FT_DEVICE_100AX = 2
FT_DEVICE_UNKNOWN = 3
FT_DEVICE_2232C = 4
FT_DEVICE_232R = 5

FT_OK = 0
FT_INVALID_HANDLE = 1
FT_DEVICE_NOT_FOUND = 2
FT_DEVICE_NOT_OPENED = 3
FT_IO_ERROR = 4
FT_INSUFFICIENT_RESOURCES = 5
FT_INVALID_PARAMETER = 6
FT_INVALID_BAUD_RATE = 7
FT_DEVICE_NOT_OPENED_FOR_ERASE = 8
FT_DEVICE_NOT_OPENED_FOR_WRITE = 9
FT_FAILED_TO_WRITE_DEVICE = 10
FT_EEPROM_READ_FAILED = 11
FT_EEPROM_WRITE_FAILED = 12
FT_EEPROM_ERASE_FAILED = 13
FT_EEPROM_NOT_PRESENT = 14
FT_EEPROM_NOT_PROGRAMMED = 15
FT_INVALID_ARGS = 16
FT_NOT_SUPPORTED = 17
FT_OTHER_ERROR = 18


# /usr/include/bits/pthreadtypes.h 27


class _pthread_fastlock(Structure):
    _fields_ = [
        # /usr/include/bits/pthreadtypes.h 27
        ("__status", c_long),
        ("__spinlock", c_int),
    ]


# /usr/include/bits/pthreadtypes.h 35


class _pthread_descr_struct(Structure):
    _fields_: List[tuple] = [
        # /usr/include/bits/pthreadtypes.h 35
    ]


_pthread_descr = POINTER(_pthread_descr_struct)
# /usr/include/bits/pthreadtypes.h 42


# /usr/include/bits/pthreadtypes.h 70


class pthread_cond_t(Structure):
    _fields_ = [
        # /usr/include/bits/pthreadtypes.h 70
        ("__c_lock", _pthread_fastlock),
        ("__c_waiting", _pthread_descr),
        ("__padding", c_char * 16),
        ("__align", c_longlong),
    ]


pthread_key_t = c_uint
# /usr/include/bits/pthreadtypes.h 93


class pthread_mutex_t(Structure):
    _fields_ = [
        # /usr/include/bits/pthreadtypes.h 93
        ("__m_reserved", c_int),
        ("__m_count", c_int),
        ("__m_owner", _pthread_descr),
        ("__m_kind", c_int),
        ("__m_lock", _pthread_fastlock),
    ]


DWORD = c_ulong
ULONG = c_ulong
USHORT = c_ushort
SHORT = c_short
UCHAR = c_ubyte
WORD = c_ushort
BYTE = c_ubyte
LPBYTE = POINTER(c_ubyte)
BOOL = c_int
BOOLEAN = c_char
CHAR = c_char
LPBOOL = POINTER(c_int)
PUCHAR = POINTER(c_ubyte)
LPCSTR = STRING
PCHAR = STRING
PVOID = c_void_p
HANDLE = c_void_p
LONG = c_long
INT = c_int
UINT = c_uint
LPSTR = STRING
LPTSTR = STRING
LPDWORD = POINTER(DWORD)
LPWORD = POINTER(WORD)
PULONG = POINTER(ULONG)
LPVOID = PVOID
VOID: None = None
ULONGLONG = c_ulonglong
# WinTypes.h 38


class _OVERLAPPED(Structure):
    _fields_ = [
        # WinTypes.h 38
        ("Internal", DWORD),
        ("InternalHigh", DWORD),
        ("Offset", DWORD),
        ("OffsetHigh", DWORD),
        ("hEvent", HANDLE),
    ]


LPOVERLAPPED = POINTER(_OVERLAPPED)
OVERLAPPED = _OVERLAPPED
# WinTypes.h 46


class _SECURITY_ATTRIBUTES(Structure):
    _fields_ = [
        # WinTypes.h 46
        ("nLength", DWORD),
        ("lpSecurityDescriptor", LPVOID),
        ("bInheritHandle", BOOL),
    ]


LPSECURITY_ATTRIBUTES = POINTER(_SECURITY_ATTRIBUTES)
SECURITY_ATTRIBUTES = _SECURITY_ATTRIBUTES
# WinTypes.h 52


class _EVENT_HANDLE(Structure):
    _fields_ = [
        # ftd2xx_linux.h 63
        ("eCondVar", pthread_cond_t),
        ("eMutex", pthread_mutex_t),
        ("iVar", c_int),
    ]


EVENT_HANDLE = _EVENT_HANDLE
FT_HANDLE = POINTER(DWORD)
FT_STATUS = ULONG

# values for unnamed enumeration
PFT_EVENT_HANDLER = CFUNCTYPE(None, c_ulong, c_ulong)
FT_DEVICE = ULONG

# values for unnamed enumeration
# ftd2xx_linux.h 220
FT_Open = _libraries["libftd2xx.so"].FT_Open
FT_Open.restype = FT_STATUS
# FT_Open(deviceNumber, pHandle)
FT_Open.argtypes = [c_int, POINTER(FT_HANDLE)]
FT_Open.__doc__ = """FT_STATUS FT_Open(int deviceNumber, FT_HANDLE * pHandle)
ftd2xx_linux.h:220"""
# ftd2xx_linux.h 227
FT_OpenEx = _libraries["libftd2xx.so"].FT_OpenEx
FT_OpenEx.restype = FT_STATUS
# FT_OpenEx(pArg1, Flags, pHandle)
FT_OpenEx.argtypes = [PVOID, DWORD, POINTER(FT_HANDLE)]
FT_OpenEx.__doc__ = """FT_STATUS FT_OpenEx(PVOID pArg1, DWORD Flags, FT_HANDLE * pHandle)
ftd2xx_linux.h:227"""
# ftd2xx_linux.h 234
FT_ListDevices = _libraries["libftd2xx.so"].FT_ListDevices
FT_ListDevices.restype = FT_STATUS
# FT_ListDevices(pArg1, pArg2, Flags)
FT_ListDevices.argtypes = [PVOID, PVOID, DWORD]
FT_ListDevices.__doc__ = """FT_STATUS FT_ListDevices(PVOID pArg1, PVOID pArg2, DWORD Flags)
ftd2xx_linux.h:234"""
# ftd2xx_linux.h 240
FT_SetVIDPID = _libraries["libftd2xx.so"].FT_SetVIDPID
FT_SetVIDPID.restype = FT_STATUS
# FT_SetVIDPID(dwVID, dwPID)
FT_SetVIDPID.argtypes = [DWORD, DWORD]
FT_SetVIDPID.__doc__ = """FT_STATUS FT_SetVIDPID(DWORD dwVID, DWORD dwPID)
ftd2xx_linux.h:240"""
# ftd2xx_linux.h 246
FT_GetVIDPID = _libraries["libftd2xx.so"].FT_GetVIDPID
FT_GetVIDPID.restype = FT_STATUS
# FT_GetVIDPID(pdwVID, pdwPID)
FT_GetVIDPID.argtypes = [POINTER(DWORD), POINTER(DWORD)]
FT_GetVIDPID.__doc__ = """FT_STATUS FT_GetVIDPID(DWORD * pdwVID, DWORD * pdwPID)
ftd2xx_linux.h:246"""
# ftd2xx_linux.h 251
FT_Close = _libraries["libftd2xx.so"].FT_Close
FT_Close.restype = FT_STATUS
# FT_Close(ftHandle)
FT_Close.argtypes = [FT_HANDLE]
FT_Close.__doc__ = """FT_STATUS FT_Close(FT_HANDLE ftHandle)
ftd2xx_linux.h:251"""
# ftd2xx_linux.h 259
FT_Read = _libraries["libftd2xx.so"].FT_Read
FT_Read.restype = FT_STATUS
# FT_Read(ftHandle, lpBuffer, nBufferSize, lpBytesReturned)
FT_Read.argtypes = [FT_HANDLE, LPVOID, DWORD, LPDWORD]
FT_Read.__doc__ = """FT_STATUS FT_Read(FT_HANDLE ftHandle, LPVOID lpBuffer, DWORD nBufferSize, LPDWORD lpBytesReturned)
ftd2xx_linux.h:259"""
# ftd2xx_linux.h 267
FT_Write = _libraries["libftd2xx.so"].FT_Write
FT_Write.restype = FT_STATUS
# FT_Write(ftHandle, lpBuffer, nBufferSize, lpBytesWritten)
FT_Write.argtypes = [FT_HANDLE, LPVOID, DWORD, LPDWORD]
FT_Write.__doc__ = """FT_STATUS FT_Write(FT_HANDLE ftHandle, LPVOID lpBuffer, DWORD nBufferSize, LPDWORD lpBytesWritten)
ftd2xx_linux.h:267"""
# ftd2xx_linux.h 279
FT_IoCtl = _libraries["libftd2xx.so"].FT_IoCtl
FT_IoCtl.restype = FT_STATUS
# FT_IoCtl(ftHandle, dwIoControlCode, lpInBuf, nInBufSize, lpOutBuf, nOutBufSize, lpBytesReturned, lpOverlapped)
FT_IoCtl.argtypes = [
    FT_HANDLE,
    DWORD,
    LPVOID,
    DWORD,
    LPVOID,
    DWORD,
    LPDWORD,
    LPOVERLAPPED,
]
FT_IoCtl.__doc__ = """FT_STATUS FT_IoCtl(FT_HANDLE ftHandle, DWORD dwIoControlCode, LPVOID lpInBuf, DWORD nInBufSize, LPVOID lpOutBuf, DWORD nOutBufSize, LPDWORD lpBytesReturned, LPOVERLAPPED lpOverlapped)
ftd2xx_linux.h:279"""
# ftd2xx_linux.h 285
FT_SetBaudRate = _libraries["libftd2xx.so"].FT_SetBaudRate
FT_SetBaudRate.restype = FT_STATUS
# FT_SetBaudRate(ftHandle, BaudRate)
FT_SetBaudRate.argtypes = [FT_HANDLE, ULONG]
FT_SetBaudRate.__doc__ = """FT_STATUS FT_SetBaudRate(FT_HANDLE ftHandle, ULONG BaudRate)
ftd2xx_linux.h:285"""
# ftd2xx_linux.h 291
FT_SetDivisor = _libraries["libftd2xx.so"].FT_SetDivisor
FT_SetDivisor.restype = FT_STATUS
# FT_SetDivisor(ftHandle, Divisor)
FT_SetDivisor.argtypes = [FT_HANDLE, USHORT]
FT_SetDivisor.__doc__ = """FT_STATUS FT_SetDivisor(FT_HANDLE ftHandle, USHORT Divisor)
ftd2xx_linux.h:291"""
# ftd2xx_linux.h 299
FT_SetDataCharacteristics = _libraries["libftd2xx.so"].FT_SetDataCharacteristics
FT_SetDataCharacteristics.restype = FT_STATUS
# FT_SetDataCharacteristics(ftHandle, WordLength, StopBits, Parity)
FT_SetDataCharacteristics.argtypes = [FT_HANDLE, UCHAR, UCHAR, UCHAR]
FT_SetDataCharacteristics.__doc__ = """FT_STATUS FT_SetDataCharacteristics(FT_HANDLE ftHandle, UCHAR WordLength, UCHAR StopBits, UCHAR Parity)
ftd2xx_linux.h:299"""
# ftd2xx_linux.h 307
FT_SetFlowControl = _libraries["libftd2xx.so"].FT_SetFlowControl
FT_SetFlowControl.restype = FT_STATUS
# FT_SetFlowControl(ftHandle, FlowControl, XonChar, XoffChar)
FT_SetFlowControl.argtypes = [FT_HANDLE, USHORT, UCHAR, UCHAR]
FT_SetFlowControl.__doc__ = """FT_STATUS FT_SetFlowControl(FT_HANDLE ftHandle, USHORT FlowControl, UCHAR XonChar, UCHAR XoffChar)
ftd2xx_linux.h:307"""
# ftd2xx_linux.h 312
FT_ResetDevice = _libraries["libftd2xx.so"].FT_ResetDevice
FT_ResetDevice.restype = FT_STATUS
# FT_ResetDevice(ftHandle)
FT_ResetDevice.argtypes = [FT_HANDLE]
FT_ResetDevice.__doc__ = """FT_STATUS FT_ResetDevice(FT_HANDLE ftHandle)
ftd2xx_linux.h:312"""
# ftd2xx_linux.h 317
FT_SetDtr = _libraries["libftd2xx.so"].FT_SetDtr
FT_SetDtr.restype = FT_STATUS
# FT_SetDtr(ftHandle)
FT_SetDtr.argtypes = [FT_HANDLE]
FT_SetDtr.__doc__ = """FT_STATUS FT_SetDtr(FT_HANDLE ftHandle)
ftd2xx_linux.h:317"""
# ftd2xx_linux.h 322
FT_ClrDtr = _libraries["libftd2xx.so"].FT_ClrDtr
FT_ClrDtr.restype = FT_STATUS
# FT_ClrDtr(ftHandle)
FT_ClrDtr.argtypes = [FT_HANDLE]
FT_ClrDtr.__doc__ = """FT_STATUS FT_ClrDtr(FT_HANDLE ftHandle)
ftd2xx_linux.h:322"""
# ftd2xx_linux.h 327
FT_SetRts = _libraries["libftd2xx.so"].FT_SetRts
FT_SetRts.restype = FT_STATUS
# FT_SetRts(ftHandle)
FT_SetRts.argtypes = [FT_HANDLE]
FT_SetRts.__doc__ = """FT_STATUS FT_SetRts(FT_HANDLE ftHandle)
ftd2xx_linux.h:327"""
# ftd2xx_linux.h 332
FT_ClrRts = _libraries["libftd2xx.so"].FT_ClrRts
FT_ClrRts.restype = FT_STATUS
# FT_ClrRts(ftHandle)
FT_ClrRts.argtypes = [FT_HANDLE]
FT_ClrRts.__doc__ = """FT_STATUS FT_ClrRts(FT_HANDLE ftHandle)
ftd2xx_linux.h:332"""
# ftd2xx_linux.h 338
FT_GetModemStatus = _libraries["libftd2xx.so"].FT_GetModemStatus
FT_GetModemStatus.restype = FT_STATUS
# FT_GetModemStatus(ftHandle, pModemStatus)
FT_GetModemStatus.argtypes = [FT_HANDLE, POINTER(ULONG)]
FT_GetModemStatus.__doc__ = """FT_STATUS FT_GetModemStatus(FT_HANDLE ftHandle, ULONG * pModemStatus)
ftd2xx_linux.h:338"""
# ftd2xx_linux.h 347
FT_SetChars = _libraries["libftd2xx.so"].FT_SetChars
FT_SetChars.restype = FT_STATUS
# FT_SetChars(ftHandle, EventChar, EventCharEnabled, ErrorChar, ErrorCharEnabled)
FT_SetChars.argtypes = [FT_HANDLE, UCHAR, UCHAR, UCHAR, UCHAR]
FT_SetChars.__doc__ = """FT_STATUS FT_SetChars(FT_HANDLE ftHandle, UCHAR EventChar, UCHAR EventCharEnabled, UCHAR ErrorChar, UCHAR ErrorCharEnabled)
ftd2xx_linux.h:347"""
# ftd2xx_linux.h 353
FT_Purge = _libraries["libftd2xx.so"].FT_Purge
FT_Purge.restype = FT_STATUS
# FT_Purge(ftHandle, Mask)
FT_Purge.argtypes = [FT_HANDLE, ULONG]
FT_Purge.__doc__ = """FT_STATUS FT_Purge(FT_HANDLE ftHandle, ULONG Mask)
ftd2xx_linux.h:353"""
# ftd2xx_linux.h 360
FT_SetTimeouts = _libraries["libftd2xx.so"].FT_SetTimeouts
FT_SetTimeouts.restype = FT_STATUS
# FT_SetTimeouts(ftHandle, ReadTimeout, WriteTimeout)
FT_SetTimeouts.argtypes = [FT_HANDLE, ULONG, ULONG]
FT_SetTimeouts.__doc__ = """FT_STATUS FT_SetTimeouts(FT_HANDLE ftHandle, ULONG ReadTimeout, ULONG WriteTimeout)
ftd2xx_linux.h:360"""
# ftd2xx_linux.h 366
FT_GetQueueStatus = _libraries["libftd2xx.so"].FT_GetQueueStatus
FT_GetQueueStatus.restype = FT_STATUS
# FT_GetQueueStatus(ftHandle, dwRxBytes)
FT_GetQueueStatus.argtypes = [FT_HANDLE, POINTER(DWORD)]
FT_GetQueueStatus.__doc__ = """FT_STATUS FT_GetQueueStatus(FT_HANDLE ftHandle, DWORD * dwRxBytes)
ftd2xx_linux.h:366"""
# ftd2xx_linux.h 373
FT_SetEventNotification = _libraries["libftd2xx.so"].FT_SetEventNotification
FT_SetEventNotification.restype = FT_STATUS
# FT_SetEventNotification(ftHandle, Mask, Param)
FT_SetEventNotification.argtypes = [FT_HANDLE, DWORD, PVOID]
FT_SetEventNotification.__doc__ = """FT_STATUS FT_SetEventNotification(FT_HANDLE ftHandle, DWORD Mask, PVOID Param)
ftd2xx_linux.h:373"""
# ftd2xx_linux.h 381
FT_GetStatus = _libraries["libftd2xx.so"].FT_GetStatus
FT_GetStatus.restype = FT_STATUS
# FT_GetStatus(ftHandle, dwRxBytes, dwTxBytes, dwEventDWord)
FT_GetStatus.argtypes = [FT_HANDLE, POINTER(DWORD), POINTER(DWORD), POINTER(DWORD)]
FT_GetStatus.__doc__ = """FT_STATUS FT_GetStatus(FT_HANDLE ftHandle, DWORD * dwRxBytes, DWORD * dwTxBytes, DWORD * dwEventDWord)
ftd2xx_linux.h:381"""
# ftd2xx_linux.h 386
FT_SetBreakOn = _libraries["libftd2xx.so"].FT_SetBreakOn
FT_SetBreakOn.restype = FT_STATUS
# FT_SetBreakOn(ftHandle)
FT_SetBreakOn.argtypes = [FT_HANDLE]
FT_SetBreakOn.__doc__ = """FT_STATUS FT_SetBreakOn(FT_HANDLE ftHandle)
ftd2xx_linux.h:386"""
# ftd2xx_linux.h 391
FT_SetBreakOff = _libraries["libftd2xx.so"].FT_SetBreakOff
FT_SetBreakOff.restype = FT_STATUS
# FT_SetBreakOff(ftHandle)
FT_SetBreakOff.argtypes = [FT_HANDLE]
FT_SetBreakOff.__doc__ = """FT_STATUS FT_SetBreakOff(FT_HANDLE ftHandle)
ftd2xx_linux.h:391"""
# ftd2xx_linux.h 397
FT_SetWaitMask = _libraries["libftd2xx.so"].FT_SetWaitMask
FT_SetWaitMask.restype = FT_STATUS
# FT_SetWaitMask(ftHandle, Mask)
FT_SetWaitMask.argtypes = [FT_HANDLE, DWORD]
FT_SetWaitMask.__doc__ = """FT_STATUS FT_SetWaitMask(FT_HANDLE ftHandle, DWORD Mask)
ftd2xx_linux.h:397"""
# ftd2xx_linux.h 403
FT_WaitOnMask = _libraries["libftd2xx.so"].FT_WaitOnMask
FT_WaitOnMask.restype = FT_STATUS
# FT_WaitOnMask(ftHandle, Mask)
FT_WaitOnMask.argtypes = [FT_HANDLE, POINTER(DWORD)]
FT_WaitOnMask.__doc__ = """FT_STATUS FT_WaitOnMask(FT_HANDLE ftHandle, DWORD * Mask)
ftd2xx_linux.h:403"""
# ftd2xx_linux.h 409
FT_GetEventStatus = _libraries["libftd2xx.so"].FT_GetEventStatus
FT_GetEventStatus.restype = FT_STATUS
# FT_GetEventStatus(ftHandle, dwEventDWord)
FT_GetEventStatus.argtypes = [FT_HANDLE, POINTER(DWORD)]
FT_GetEventStatus.__doc__ = """FT_STATUS FT_GetEventStatus(FT_HANDLE ftHandle, DWORD * dwEventDWord)
ftd2xx_linux.h:409"""
# ftd2xx_linux.h 416
FT_ReadEE = _libraries["libftd2xx.so"].FT_ReadEE
FT_ReadEE.restype = FT_STATUS
# FT_ReadEE(ftHandle, dwWordOffset, lpwValue)
FT_ReadEE.argtypes = [FT_HANDLE, DWORD, LPWORD]
FT_ReadEE.__doc__ = """FT_STATUS FT_ReadEE(FT_HANDLE ftHandle, DWORD dwWordOffset, LPWORD lpwValue)
ftd2xx_linux.h:416"""
# ftd2xx_linux.h 423
FT_WriteEE = _libraries["libftd2xx.so"].FT_WriteEE
FT_WriteEE.restype = FT_STATUS
# FT_WriteEE(ftHandle, dwWordOffset, wValue)
FT_WriteEE.argtypes = [FT_HANDLE, DWORD, WORD]
FT_WriteEE.__doc__ = """FT_STATUS FT_WriteEE(FT_HANDLE ftHandle, DWORD dwWordOffset, WORD wValue)
ftd2xx_linux.h:423"""
# ftd2xx_linux.h 428
FT_EraseEE = _libraries["libftd2xx.so"].FT_EraseEE
FT_EraseEE.restype = FT_STATUS
# FT_EraseEE(ftHandle)
FT_EraseEE.argtypes = [FT_HANDLE]
FT_EraseEE.__doc__ = """FT_STATUS FT_EraseEE(FT_HANDLE ftHandle)
ftd2xx_linux.h:428"""
# ftd2xx_linux.h 433


class ft_program_data(Structure):
    _fields_ = [
        # ftd2xx_linux.h 433
        ("Signature1", DWORD),
        ("Signature2", DWORD),
        ("Version", DWORD),
        ("VendorId", WORD),
        ("ProductId", WORD),
        ("Manufacturer", STRING),
        ("ManufacturerId", STRING),
        ("Description", STRING),
        ("SerialNumber", STRING),
        ("MaxPower", WORD),
        ("PnP", WORD),
        ("SelfPowered", WORD),
        ("RemoteWakeup", WORD),
        ("Rev4", UCHAR),
        ("IsoIn", UCHAR),
        ("IsoOut", UCHAR),
        ("PullDownEnable", UCHAR),
        ("SerNumEnable", UCHAR),
        ("USBVersionEnable", UCHAR),
        ("USBVersion", WORD),
        ("Rev5", UCHAR),
        ("IsoInA", UCHAR),
        ("IsoInB", UCHAR),
        ("IsoOutA", UCHAR),
        ("IsoOutB", UCHAR),
        ("PullDownEnable5", UCHAR),
        ("SerNumEnable5", UCHAR),
        ("USBVersionEnable5", UCHAR),
        ("USBVersion5", WORD),
        ("AIsHighCurrent", UCHAR),
        ("BIsHighCurrent", UCHAR),
        ("IFAIsFifo", UCHAR),
        ("IFAIsFifoTar", UCHAR),
        ("IFAIsFastSer", UCHAR),
        ("AIsVCP", UCHAR),
        ("IFBIsFifo", UCHAR),
        ("IFBIsFifoTar", UCHAR),
        ("IFBIsFastSer", UCHAR),
        ("BIsVCP", UCHAR),
        ("UseExtOsc", UCHAR),
        ("HighDriveIOs", UCHAR),
        ("EndpointSize", UCHAR),
        ("PullDownEnableR", UCHAR),
        ("SerNumEnableR", UCHAR),
        ("InvertTXD", UCHAR),
        ("InvertRXD", UCHAR),
        ("InvertRTS", UCHAR),
        ("InvertCTS", UCHAR),
        ("InvertDTR", UCHAR),
        ("InvertDSR", UCHAR),
        ("InvertDCD", UCHAR),
        ("InvertRI", UCHAR),
        ("Cbus0", UCHAR),
        ("Cbus1", UCHAR),
        ("Cbus2", UCHAR),
        ("Cbus3", UCHAR),
        ("Cbus4", UCHAR),
        ("RIsVCP", UCHAR),
    ]


PFT_PROGRAM_DATA = POINTER(ft_program_data)
FT_PROGRAM_DATA = ft_program_data
# ftd2xx_linux.h 518
FT_EE_Program = _libraries["libftd2xx.so"].FT_EE_Program
FT_EE_Program.restype = FT_STATUS
# FT_EE_Program(ftHandle, pData)
FT_EE_Program.argtypes = [FT_HANDLE, PFT_PROGRAM_DATA]
FT_EE_Program.__doc__ = """FT_STATUS FT_EE_Program(FT_HANDLE ftHandle, PFT_PROGRAM_DATA pData)
ftd2xx_linux.h:518"""
# ftd2xx_linux.h 528
FT_EE_ProgramEx = _libraries["libftd2xx.so"].FT_EE_ProgramEx
FT_EE_ProgramEx.restype = FT_STATUS
# FT_EE_ProgramEx(ftHandle, lpData, Manufacturer, ManufacturerId, Description, SerialNumber)
FT_EE_ProgramEx.argtypes = [FT_HANDLE, PFT_PROGRAM_DATA, STRING, STRING, STRING, STRING]
FT_EE_ProgramEx.__doc__ = """FT_STATUS FT_EE_ProgramEx(FT_HANDLE ftHandle, PFT_PROGRAM_DATA lpData, char * Manufacturer, char * ManufacturerId, char * Description, char * SerialNumber)
ftd2xx_linux.h:528"""
# ftd2xx_linux.h 534
FT_EE_Read = _libraries["libftd2xx.so"].FT_EE_Read
FT_EE_Read.restype = FT_STATUS
# FT_EE_Read(ftHandle, pData)
FT_EE_Read.argtypes = [FT_HANDLE, PFT_PROGRAM_DATA]
FT_EE_Read.__doc__ = """FT_STATUS FT_EE_Read(FT_HANDLE ftHandle, PFT_PROGRAM_DATA pData)
ftd2xx_linux.h:534"""
# ftd2xx_linux.h 544
FT_EE_ReadEx = _libraries["libftd2xx.so"].FT_EE_ReadEx
FT_EE_ReadEx.restype = FT_STATUS
# FT_EE_ReadEx(ftHandle, lpData, Manufacturer, ManufacturerId, Description, SerialNumber)
FT_EE_ReadEx.argtypes = [FT_HANDLE, PFT_PROGRAM_DATA, STRING, STRING, STRING, STRING]
FT_EE_ReadEx.__doc__ = """FT_STATUS FT_EE_ReadEx(FT_HANDLE ftHandle, PFT_PROGRAM_DATA lpData, char * Manufacturer, char * ManufacturerId, char * Description, char * SerialNumber)
ftd2xx_linux.h:544"""
# ftd2xx_linux.h 550
FT_EE_UASize = _libraries["libftd2xx.so"].FT_EE_UASize
FT_EE_UASize.restype = FT_STATUS
# FT_EE_UASize(ftHandle, lpdwSize)
FT_EE_UASize.argtypes = [FT_HANDLE, LPDWORD]
FT_EE_UASize.__doc__ = """FT_STATUS FT_EE_UASize(FT_HANDLE ftHandle, LPDWORD lpdwSize)
ftd2xx_linux.h:550"""
# ftd2xx_linux.h 557
FT_EE_UAWrite = _libraries["libftd2xx.so"].FT_EE_UAWrite
FT_EE_UAWrite.restype = FT_STATUS
# FT_EE_UAWrite(ftHandle, pucData, dwDataLen)
FT_EE_UAWrite.argtypes = [FT_HANDLE, PUCHAR, DWORD]
FT_EE_UAWrite.__doc__ = """FT_STATUS FT_EE_UAWrite(FT_HANDLE ftHandle, PUCHAR pucData, DWORD dwDataLen)
ftd2xx_linux.h:557"""
# ftd2xx_linux.h 565
FT_EE_UARead = _libraries["libftd2xx.so"].FT_EE_UARead
FT_EE_UARead.restype = FT_STATUS
# FT_EE_UARead(ftHandle, pucData, dwDataLen, lpdwBytesRead)
FT_EE_UARead.argtypes = [FT_HANDLE, PUCHAR, DWORD, LPDWORD]
FT_EE_UARead.__doc__ = """FT_STATUS FT_EE_UARead(FT_HANDLE ftHandle, PUCHAR pucData, DWORD dwDataLen, LPDWORD lpdwBytesRead)
ftd2xx_linux.h:565"""
# ftd2xx_linux.h 571
FT_SetLatencyTimer = _libraries["libftd2xx.so"].FT_SetLatencyTimer
FT_SetLatencyTimer.restype = FT_STATUS
# FT_SetLatencyTimer(ftHandle, ucLatency)
FT_SetLatencyTimer.argtypes = [FT_HANDLE, UCHAR]
FT_SetLatencyTimer.__doc__ = """FT_STATUS FT_SetLatencyTimer(FT_HANDLE ftHandle, UCHAR ucLatency)
ftd2xx_linux.h:571"""
# ftd2xx_linux.h 577
FT_GetLatencyTimer = _libraries["libftd2xx.so"].FT_GetLatencyTimer
FT_GetLatencyTimer.restype = FT_STATUS
# FT_GetLatencyTimer(ftHandle, pucLatency)
FT_GetLatencyTimer.argtypes = [FT_HANDLE, PUCHAR]
FT_GetLatencyTimer.__doc__ = """FT_STATUS FT_GetLatencyTimer(FT_HANDLE ftHandle, PUCHAR pucLatency)
ftd2xx_linux.h:577"""
# ftd2xx_linux.h 584
FT_SetBitMode = _libraries["libftd2xx.so"].FT_SetBitMode
FT_SetBitMode.restype = FT_STATUS
# FT_SetBitMode(ftHandle, ucMask, ucEnable)
FT_SetBitMode.argtypes = [FT_HANDLE, UCHAR, UCHAR]
FT_SetBitMode.__doc__ = """FT_STATUS FT_SetBitMode(FT_HANDLE ftHandle, UCHAR ucMask, UCHAR ucEnable)
ftd2xx_linux.h:584"""
# ftd2xx_linux.h 590
FT_GetBitMode = _libraries["libftd2xx.so"].FT_GetBitMode
FT_GetBitMode.restype = FT_STATUS
# FT_GetBitMode(ftHandle, pucMode)
FT_GetBitMode.argtypes = [FT_HANDLE, PUCHAR]
FT_GetBitMode.__doc__ = """FT_STATUS FT_GetBitMode(FT_HANDLE ftHandle, PUCHAR pucMode)
ftd2xx_linux.h:590"""
# ftd2xx_linux.h 597
FT_SetUSBParameters = _libraries["libftd2xx.so"].FT_SetUSBParameters
FT_SetUSBParameters.restype = FT_STATUS
# FT_SetUSBParameters(ftHandle, ulInTransferSize, ulOutTransferSize)
FT_SetUSBParameters.argtypes = [FT_HANDLE, ULONG, ULONG]
FT_SetUSBParameters.__doc__ = """FT_STATUS FT_SetUSBParameters(FT_HANDLE ftHandle, ULONG ulInTransferSize, ULONG ulOutTransferSize)
ftd2xx_linux.h:597"""
# ftd2xx_linux.h 603
FT_SetDeadmanTimeout = _libraries["libftd2xx.so"].FT_SetDeadmanTimeout
FT_SetDeadmanTimeout.restype = FT_STATUS
# FT_SetDeadmanTimeout(ftHandle, ulDeadmanTimeout)
FT_SetDeadmanTimeout.argtypes = [FT_HANDLE, ULONG]
FT_SetDeadmanTimeout.__doc__ = """FT_STATUS FT_SetDeadmanTimeout(FT_HANDLE ftHandle, ULONG ulDeadmanTimeout)
ftd2xx_linux.h:603"""
# ftd2xx_linux.h 613
FT_GetDeviceInfo = _libraries["libftd2xx.so"].FT_GetDeviceInfo
FT_GetDeviceInfo.restype = FT_STATUS
# FT_GetDeviceInfo(ftHandle, lpftDevice, lpdwID, SerialNumber, Description, Dummy)
FT_GetDeviceInfo.argtypes = [
    FT_HANDLE,
    POINTER(FT_DEVICE),
    LPDWORD,
    PCHAR,
    PCHAR,
    LPVOID,
]
FT_GetDeviceInfo.__doc__ = """FT_STATUS FT_GetDeviceInfo(FT_HANDLE ftHandle, FT_DEVICE * lpftDevice, LPDWORD lpdwID, PCHAR SerialNumber, PCHAR Description, LPVOID Dummy)
ftd2xx_linux.h:613"""
# ftd2xx_linux.h 618
FT_StopInTask = _libraries["libftd2xx.so"].FT_StopInTask
FT_StopInTask.restype = FT_STATUS
# FT_StopInTask(ftHandle)
FT_StopInTask.argtypes = [FT_HANDLE]
FT_StopInTask.__doc__ = """FT_STATUS FT_StopInTask(FT_HANDLE ftHandle)
ftd2xx_linux.h:618"""
# ftd2xx_linux.h 623
FT_RestartInTask = _libraries["libftd2xx.so"].FT_RestartInTask
FT_RestartInTask.restype = FT_STATUS
# FT_RestartInTask(ftHandle)
FT_RestartInTask.argtypes = [FT_HANDLE]
FT_RestartInTask.__doc__ = """FT_STATUS FT_RestartInTask(FT_HANDLE ftHandle)
ftd2xx_linux.h:623"""
# ftd2xx_linux.h 629
FT_SetResetPipeRetryCount = _libraries["libftd2xx.so"].FT_SetResetPipeRetryCount
FT_SetResetPipeRetryCount.restype = FT_STATUS
# FT_SetResetPipeRetryCount(ftHandle, dwCount)
FT_SetResetPipeRetryCount.argtypes = [FT_HANDLE, DWORD]
FT_SetResetPipeRetryCount.__doc__ = """FT_STATUS FT_SetResetPipeRetryCount(FT_HANDLE ftHandle, DWORD dwCount)
ftd2xx_linux.h:629"""
# ftd2xx_linux.h 634
FT_ResetPort = _libraries["libftd2xx.so"].FT_ResetPort
FT_ResetPort.restype = FT_STATUS
# FT_ResetPort(ftHandle)
FT_ResetPort.argtypes = [FT_HANDLE]
FT_ResetPort.__doc__ = """FT_STATUS FT_ResetPort(FT_HANDLE ftHandle)
ftd2xx_linux.h:634"""
# ftd2xx_linux.h 639
FT_CyclePort = _libraries["libftd2xx.so"].FT_CyclePort
FT_CyclePort.restype = FT_STATUS
# FT_CyclePort(ftHandle)
FT_CyclePort.argtypes = [FT_HANDLE]
FT_CyclePort.__doc__ = """FT_STATUS FT_CyclePort(FT_HANDLE ftHandle)
ftd2xx_linux.h:639"""
# ftd2xx_linux.h 655
FT_W32_CreateFile = _libraries["libftd2xx.so"].FT_W32_CreateFile
FT_W32_CreateFile.restype = FT_HANDLE
# FT_W32_CreateFile(lpszName, dwAccess, dwShareMode, lpSecurityAttributes, dwCreate, dwAttrsAndFlags, hTemplate)
FT_W32_CreateFile.argtypes = [
    LPCSTR,
    DWORD,
    DWORD,
    LPSECURITY_ATTRIBUTES,
    DWORD,
    DWORD,
    HANDLE,
]
FT_W32_CreateFile.__doc__ = """FT_HANDLE FT_W32_CreateFile(LPCSTR lpszName, DWORD dwAccess, DWORD dwShareMode, LPSECURITY_ATTRIBUTES lpSecurityAttributes, DWORD dwCreate, DWORD dwAttrsAndFlags, HANDLE hTemplate)
ftd2xx_linux.h:655"""
# ftd2xx_linux.h 660
FT_W32_CloseHandle = _libraries["libftd2xx.so"].FT_W32_CloseHandle
FT_W32_CloseHandle.restype = BOOL
# FT_W32_CloseHandle(ftHandle)
FT_W32_CloseHandle.argtypes = [FT_HANDLE]
FT_W32_CloseHandle.__doc__ = """BOOL FT_W32_CloseHandle(FT_HANDLE ftHandle)
ftd2xx_linux.h:660"""
# ftd2xx_linux.h 669
FT_W32_ReadFile = _libraries["libftd2xx.so"].FT_W32_ReadFile
FT_W32_ReadFile.restype = BOOL
# FT_W32_ReadFile(ftHandle, lpBuffer, nBufferSize, lpBytesReturned, lpOverlapped)
FT_W32_ReadFile.argtypes = [FT_HANDLE, LPVOID, DWORD, LPDWORD, LPOVERLAPPED]
FT_W32_ReadFile.__doc__ = """BOOL FT_W32_ReadFile(FT_HANDLE ftHandle, LPVOID lpBuffer, DWORD nBufferSize, LPDWORD lpBytesReturned, LPOVERLAPPED lpOverlapped)
ftd2xx_linux.h:669"""
# ftd2xx_linux.h 678
FT_W32_WriteFile = _libraries["libftd2xx.so"].FT_W32_WriteFile
FT_W32_WriteFile.restype = BOOL
# FT_W32_WriteFile(ftHandle, lpBuffer, nBufferSize, lpBytesWritten, lpOverlapped)
FT_W32_WriteFile.argtypes = [FT_HANDLE, LPVOID, DWORD, LPDWORD, LPOVERLAPPED]
FT_W32_WriteFile.__doc__ = """BOOL FT_W32_WriteFile(FT_HANDLE ftHandle, LPVOID lpBuffer, DWORD nBufferSize, LPDWORD lpBytesWritten, LPOVERLAPPED lpOverlapped)
ftd2xx_linux.h:678"""
# ftd2xx_linux.h 683
FT_W32_GetLastError = _libraries["libftd2xx.so"].FT_W32_GetLastError
FT_W32_GetLastError.restype = DWORD
# FT_W32_GetLastError(ftHandle)
FT_W32_GetLastError.argtypes = [FT_HANDLE]
FT_W32_GetLastError.__doc__ = """DWORD FT_W32_GetLastError(FT_HANDLE ftHandle)
ftd2xx_linux.h:683"""
# ftd2xx_linux.h 691
FT_W32_GetOverlappedResult = _libraries["libftd2xx.so"].FT_W32_GetOverlappedResult
FT_W32_GetOverlappedResult.restype = BOOL
# FT_W32_GetOverlappedResult(ftHandle, lpOverlapped, lpdwBytesTransferred, bWait)
FT_W32_GetOverlappedResult.argtypes = [FT_HANDLE, LPOVERLAPPED, LPDWORD, BOOL]
FT_W32_GetOverlappedResult.__doc__ = """BOOL FT_W32_GetOverlappedResult(FT_HANDLE ftHandle, LPOVERLAPPED lpOverlapped, LPDWORD lpdwBytesTransferred, BOOL bWait)
ftd2xx_linux.h:691"""
# ftd2xx_linux.h 696
FT_W32_CancelIo = _libraries["libftd2xx.so"].FT_W32_CancelIo
FT_W32_CancelIo.restype = BOOL
# FT_W32_CancelIo(ftHandle)
FT_W32_CancelIo.argtypes = [FT_HANDLE]
FT_W32_CancelIo.__doc__ = """BOOL FT_W32_CancelIo(FT_HANDLE ftHandle)
ftd2xx_linux.h:696"""
# ftd2xx_linux.h 702


class _FTCOMSTAT(Structure):
    _fields_ = [
        # ftd2xx_linux.h 702
        ("fCtsHold", DWORD, 1),
        ("fDsrHold", DWORD, 1),
        ("fRlsdHold", DWORD, 1),
        ("fXoffHold", DWORD, 1),
        ("fXoffSent", DWORD, 1),
        ("fEof", DWORD, 1),
        ("fTxim", DWORD, 1),
        ("fReserved", DWORD, 25),
        ("cbInQue", DWORD),
        ("cbOutQue", DWORD),
    ]


LPFTCOMSTAT = POINTER(_FTCOMSTAT)
FTCOMSTAT = _FTCOMSTAT
# ftd2xx_linux.h 715


class _FTDCB(Structure):
    _fields_ = [
        # ftd2xx_linux.h 715
        ("DCBlength", DWORD),
        ("BaudRate", DWORD),
        ("fBinary", DWORD, 1),
        ("fParity", DWORD, 1),
        ("fOutxCtsFlow", DWORD, 1),
        ("fOutxDsrFlow", DWORD, 1),
        ("fDtrControl", DWORD, 2),
        ("fDsrSensitivity", DWORD, 1),
        ("fTXContinueOnXoff", DWORD, 1),
        ("fOutX", DWORD, 1),
        ("fInX", DWORD, 1),
        ("fErrorChar", DWORD, 1),
        ("fNull", DWORD, 1),
        ("fRtsControl", DWORD, 2),
        ("fAbortOnError", DWORD, 1),
        ("fDummy2", DWORD, 17),
        ("wReserved", WORD),
        ("XonLim", WORD),
        ("XoffLim", WORD),
        ("ByteSize", BYTE),
        ("Parity", BYTE),
        ("StopBits", BYTE),
        ("XonChar", c_char),
        ("XoffChar", c_char),
        ("ErrorChar", c_char),
        ("EofChar", c_char),
        ("EvtChar", c_char),
        ("wReserved1", WORD),
    ]


LPFTDCB = POINTER(_FTDCB)
FTDCB = _FTDCB
# ftd2xx_linux.h 746


class _FTTIMEOUTS(Structure):
    _fields_ = [
        # ftd2xx_linux.h 746
        ("ReadIntervalTimeout", DWORD),
        ("ReadTotalTimeoutMultiplier", DWORD),
        ("ReadTotalTimeoutConstant", DWORD),
        ("WriteTotalTimeoutMultiplier", DWORD),
        ("WriteTotalTimeoutConstant", DWORD),
    ]


FTTIMEOUTS = _FTTIMEOUTS
LPFTTIMEOUTS = POINTER(_FTTIMEOUTS)
# ftd2xx_linux.h 758
FT_W32_ClearCommBreak = _libraries["libftd2xx.so"].FT_W32_ClearCommBreak
FT_W32_ClearCommBreak.restype = BOOL
# FT_W32_ClearCommBreak(ftHandle)
FT_W32_ClearCommBreak.argtypes = [FT_HANDLE]
FT_W32_ClearCommBreak.__doc__ = """BOOL FT_W32_ClearCommBreak(FT_HANDLE ftHandle)
ftd2xx_linux.h:758"""
# ftd2xx_linux.h 765
FT_W32_ClearCommError = _libraries["libftd2xx.so"].FT_W32_ClearCommError
FT_W32_ClearCommError.restype = BOOL
# FT_W32_ClearCommError(ftHandle, lpdwErrors, lpftComstat)
FT_W32_ClearCommError.argtypes = [FT_HANDLE, LPDWORD, LPFTCOMSTAT]
FT_W32_ClearCommError.__doc__ = """BOOL FT_W32_ClearCommError(FT_HANDLE ftHandle, LPDWORD lpdwErrors, LPFTCOMSTAT lpftComstat)
ftd2xx_linux.h:765"""
# ftd2xx_linux.h 771
FT_W32_EscapeCommFunction = _libraries["libftd2xx.so"].FT_W32_EscapeCommFunction
FT_W32_EscapeCommFunction.restype = BOOL
# FT_W32_EscapeCommFunction(ftHandle, dwFunc)
FT_W32_EscapeCommFunction.argtypes = [FT_HANDLE, DWORD]
FT_W32_EscapeCommFunction.__doc__ = """BOOL FT_W32_EscapeCommFunction(FT_HANDLE ftHandle, DWORD dwFunc)
ftd2xx_linux.h:771"""
# ftd2xx_linux.h 777
FT_W32_GetCommModemStatus = _libraries["libftd2xx.so"].FT_W32_GetCommModemStatus
FT_W32_GetCommModemStatus.restype = BOOL
# FT_W32_GetCommModemStatus(ftHandle, lpdwModemStatus)
FT_W32_GetCommModemStatus.argtypes = [FT_HANDLE, LPDWORD]
FT_W32_GetCommModemStatus.__doc__ = """BOOL FT_W32_GetCommModemStatus(FT_HANDLE ftHandle, LPDWORD lpdwModemStatus)
ftd2xx_linux.h:777"""
# ftd2xx_linux.h 783
FT_W32_GetCommState = _libraries["libftd2xx.so"].FT_W32_GetCommState
FT_W32_GetCommState.restype = BOOL
# FT_W32_GetCommState(ftHandle, lpftDcb)
FT_W32_GetCommState.argtypes = [FT_HANDLE, LPFTDCB]
FT_W32_GetCommState.__doc__ = """BOOL FT_W32_GetCommState(FT_HANDLE ftHandle, LPFTDCB lpftDcb)
ftd2xx_linux.h:783"""
# ftd2xx_linux.h 789
FT_W32_GetCommTimeouts = _libraries["libftd2xx.so"].FT_W32_GetCommTimeouts
FT_W32_GetCommTimeouts.restype = BOOL
# FT_W32_GetCommTimeouts(ftHandle, pTimeouts)
FT_W32_GetCommTimeouts.argtypes = [FT_HANDLE, POINTER(FTTIMEOUTS)]
FT_W32_GetCommTimeouts.__doc__ = """BOOL FT_W32_GetCommTimeouts(FT_HANDLE ftHandle, FTTIMEOUTS * pTimeouts)
ftd2xx_linux.h:789"""
# ftd2xx_linux.h 795
FT_W32_PurgeComm = _libraries["libftd2xx.so"].FT_W32_PurgeComm
FT_W32_PurgeComm.restype = BOOL
# FT_W32_PurgeComm(ftHandle, dwMask)
FT_W32_PurgeComm.argtypes = [FT_HANDLE, DWORD]
FT_W32_PurgeComm.__doc__ = """BOOL FT_W32_PurgeComm(FT_HANDLE ftHandle, DWORD dwMask)
ftd2xx_linux.h:795"""
# ftd2xx_linux.h 800
FT_W32_SetCommBreak = _libraries["libftd2xx.so"].FT_W32_SetCommBreak
FT_W32_SetCommBreak.restype = BOOL
# FT_W32_SetCommBreak(ftHandle)
FT_W32_SetCommBreak.argtypes = [FT_HANDLE]
FT_W32_SetCommBreak.__doc__ = """BOOL FT_W32_SetCommBreak(FT_HANDLE ftHandle)
ftd2xx_linux.h:800"""
# ftd2xx_linux.h 806
FT_W32_SetCommMask = _libraries["libftd2xx.so"].FT_W32_SetCommMask
FT_W32_SetCommMask.restype = BOOL
# FT_W32_SetCommMask(ftHandle, ulEventMask)
FT_W32_SetCommMask.argtypes = [FT_HANDLE, ULONG]
FT_W32_SetCommMask.__doc__ = """BOOL FT_W32_SetCommMask(FT_HANDLE ftHandle, ULONG ulEventMask)
ftd2xx_linux.h:806"""
# ftd2xx_linux.h 812
FT_W32_SetCommState = _libraries["libftd2xx.so"].FT_W32_SetCommState
FT_W32_SetCommState.restype = BOOL
# FT_W32_SetCommState(ftHandle, lpftDcb)
FT_W32_SetCommState.argtypes = [FT_HANDLE, LPFTDCB]
FT_W32_SetCommState.__doc__ = """BOOL FT_W32_SetCommState(FT_HANDLE ftHandle, LPFTDCB lpftDcb)
ftd2xx_linux.h:812"""
# ftd2xx_linux.h 818
FT_W32_SetCommTimeouts = _libraries["libftd2xx.so"].FT_W32_SetCommTimeouts
FT_W32_SetCommTimeouts.restype = BOOL
# FT_W32_SetCommTimeouts(ftHandle, pTimeouts)
FT_W32_SetCommTimeouts.argtypes = [FT_HANDLE, POINTER(FTTIMEOUTS)]
FT_W32_SetCommTimeouts.__doc__ = """BOOL FT_W32_SetCommTimeouts(FT_HANDLE ftHandle, FTTIMEOUTS * pTimeouts)
ftd2xx_linux.h:818"""
# ftd2xx_linux.h 825
FT_W32_SetupComm = _libraries["libftd2xx.so"].FT_W32_SetupComm
FT_W32_SetupComm.restype = BOOL
# FT_W32_SetupComm(ftHandle, dwReadBufferSize, dwWriteBufferSize)
FT_W32_SetupComm.argtypes = [FT_HANDLE, DWORD, DWORD]
FT_W32_SetupComm.__doc__ = """BOOL FT_W32_SetupComm(FT_HANDLE ftHandle, DWORD dwReadBufferSize, DWORD dwWriteBufferSize)
ftd2xx_linux.h:825"""
# ftd2xx_linux.h 832
FT_W32_WaitCommEvent = _libraries["libftd2xx.so"].FT_W32_WaitCommEvent
FT_W32_WaitCommEvent.restype = BOOL
# FT_W32_WaitCommEvent(ftHandle, pulEvent, lpOverlapped)
FT_W32_WaitCommEvent.argtypes = [FT_HANDLE, PULONG, LPOVERLAPPED]
FT_W32_WaitCommEvent.__doc__ = """BOOL FT_W32_WaitCommEvent(FT_HANDLE ftHandle, PULONG pulEvent, LPOVERLAPPED lpOverlapped)
ftd2xx_linux.h:832"""
# ftd2xx_linux.h 838


class _ft_device_list_info_node(Structure):
    _fields_ = [
        # ftd2xx_linux.h 838
        ("Flags", ULONG),
        ("Type", ULONG),
        ("ID", ULONG),
        ("LocId", DWORD),
        ("SerialNumber", c_char * 16),
        ("Description", c_char * 64),
        ("ftHandle", FT_HANDLE),
    ]


FT_DEVICE_LIST_INFO_NODE = _ft_device_list_info_node
# ftd2xx_linux.h 851
FT_CreateDeviceInfoList = _libraries["libftd2xx.so"].FT_CreateDeviceInfoList
FT_CreateDeviceInfoList.restype = FT_STATUS
# FT_CreateDeviceInfoList(lpdwNumDevs)
FT_CreateDeviceInfoList.argtypes = [LPDWORD]
FT_CreateDeviceInfoList.__doc__ = """FT_STATUS FT_CreateDeviceInfoList(LPDWORD lpdwNumDevs)
ftd2xx_linux.h:851"""
# ftd2xx_linux.h 857
FT_GetDeviceInfoList = _libraries["libftd2xx.so"].FT_GetDeviceInfoList
FT_GetDeviceInfoList.restype = FT_STATUS
# FT_GetDeviceInfoList(pDest, lpdwNumDevs)
FT_GetDeviceInfoList.argtypes = [POINTER(FT_DEVICE_LIST_INFO_NODE), LPDWORD]
FT_GetDeviceInfoList.__doc__ = """FT_STATUS FT_GetDeviceInfoList(FT_DEVICE_LIST_INFO_NODE * pDest, LPDWORD lpdwNumDevs)
ftd2xx_linux.h:857"""
# ftd2xx_linux.h 869
FT_GetDeviceInfoDetail = _libraries["libftd2xx.so"].FT_GetDeviceInfoDetail
FT_GetDeviceInfoDetail.restype = FT_STATUS
# FT_GetDeviceInfoDetail(dwIndex, lpdwFlags, lpdwType, lpdwID, lpdwLocId, lpSerialNumber, lpDescription, pftHandle)
FT_GetDeviceInfoDetail.argtypes = [
    DWORD,
    LPDWORD,
    LPDWORD,
    LPDWORD,
    LPDWORD,
    LPVOID,
    LPVOID,
    POINTER(FT_HANDLE),
]
FT_GetDeviceInfoDetail.__doc__ = """FT_STATUS FT_GetDeviceInfoDetail(DWORD dwIndex, LPDWORD lpdwFlags, LPDWORD lpdwType, LPDWORD lpdwID, LPDWORD lpdwLocId, LPVOID lpSerialNumber, LPVOID lpDescription, FT_HANDLE * pftHandle)
ftd2xx_linux.h:869"""
# ftd2xx_linux.h 875
FT_GetDriverVersion = _libraries["libftd2xx.so"].FT_GetDriverVersion
FT_GetDriverVersion.restype = FT_STATUS
# FT_GetDriverVersion(ftHandle, lpdwVersion)
FT_GetDriverVersion.argtypes = [FT_HANDLE, LPDWORD]
FT_GetDriverVersion.__doc__ = """FT_STATUS FT_GetDriverVersion(FT_HANDLE ftHandle, LPDWORD lpdwVersion)
ftd2xx_linux.h:875"""
# ftd2xx_linux.h 880
FT_GetLibraryVersion = _libraries["libftd2xx.so"].FT_GetLibraryVersion
FT_GetLibraryVersion.restype = FT_STATUS
# FT_GetLibraryVersion(lpdwVersion)
FT_GetLibraryVersion.argtypes = [LPDWORD]
FT_GetLibraryVersion.__doc__ = """FT_STATUS FT_GetLibraryVersion(LPDWORD lpdwVersion)
ftd2xx_linux.h:880"""

__all__ = [
    "FT_SetVIDPID",  # Linux/Darwin only
    "FT_GetVIDPID",  # Linux/Darwin only
    "FT_CreateDeviceInfoList",
    "FT_GetDeviceInfoList",
    "FT_GetDeviceInfoDetail",
    "FT_ListDevices",
    "FT_Open",
    "FT_OpenEx",
    "FT_Close",
    "FT_Read",
    "FT_Write",
    "FT_SetBaudRate",
    "FT_SetDivisor",
    "FT_SetDataCharacteristics",
    "FT_SetTimeouts",
    "FT_SetFlowControl",
    "FT_SetDtr",
    "FT_ClrDtr",
    "FT_SetRts",
    "FT_ClrRts",
    "FT_GetModemStatus",
    "FT_GetQueueStatus",
    "FT_GetDeviceInfo",
    # "FT_GetDriverVersion",  # Windows only
    # "FT_GetLibraryVersion",  # Windows only
    # "FT_GetComPortNumber",  # Windows only
    "FT_GetStatus",
    "FT_SetEventNotification",
    "FT_SetChars",
    "FT_SetBreakOn",
    "FT_SetBreakOff",
    "FT_Purge",
    "FT_ResetDevice",
    # "FT_ResetPort",  # Windows only
    # "FT_CyclePort",  # Windows only
    # "FT_Rescan", # Windows only, not implimented yet
    # "FT_Reload",  # Windows only, not implimented yet
    "FT_SetResetPipeRetryCount",  # Windows only
    "FT_StopInTask",
    "FT_RestartInTask",
    "FT_SetDeadmanTimeout",
    "FT_IoCtl",  # Undocumented
    "FT_SetWaitMask",  # Undocumented
    "FT_WaitOnMask",  # Undocumented
    "FT_ReadEE",
    "FT_WriteEE",
    "FT_EraseEE",
    "FT_EE_Read",
    "FT_EE_ReadEx",
    "FT_EE_Program",
    "FT_EE_ProgramEx",
    "FT_EE_UASize",
    "FT_EE_UARead",
    "FT_EE_UAWrite",
    # "FT_EEPROM_Read",  # Windows XP or later, not implimented
    # "FT_EEPROM_Program",  # Windows XP or later, not implimented
]

# Extended API (does not apply to FT8U232AM or FT8U245AM devices)
__all__ += [
    "FT_SetLatencyTimer",
    "FT_GetLatencyTimer",
    "FT_SetBitMode",
    "FT_GetBitMode",
    "FT_SetUSBParameters",
]

# Win32 API (cross-platform)
__all__ += [
    "FT_W32_CreateFile",
    "FT_W32_CloseHandle",
    "FT_W32_ReadFile",
    "FT_W32_WriteFile",
    "FT_W32_GetOverlappedResult",
    "FT_W32_EscapeCommFunction",
    "FT_W32_GetCommModemStatus",
    "FT_W32_SetupComm",
    "FT_W32_SetCommState",
    "FT_W32_GetCommState",
    "FT_W32_SetCommTimeouts",
    "FT_W32_GetCommTimeouts",
    "FT_W32_SetCommBreak",
    "FT_W32_ClearCommBreak",
    "FT_W32_SetCommMask",
    # "FT_W32_GetCommMask",  # Not implimented yet
    "FT_W32_WaitCommEvent",
    "FT_W32_PurgeComm",
    "FT_W32_GetLastError",
    "FT_W32_ClearCommError",
]

# Data types
__all__ += [
    "FT_HANDLE",
    "ft_program_data",
    "BOOL",
    "BYTE",
    "DWORD",
    "HANDLE",
    "LPCSTR",
    "ULONG",
    "WORD",
    "USHORT",
    "PCHAR",
    "LPWORD",
    "PULONG",
    "LPVOID",
    "STRING",
    "UCHAR",
    "PUCHAR",
    "PVOID",
    "LPTSTR",
    "LPDWORD",
    "VOID",
    "ULONGLONG",
]

# What are these?
__all__ += [
    "FT_W32_CancelIo",
    "FT_GetEventStatus",
]
