<div align="center">
<img src="https://github.com/sepandhaghighi/nafas/raw/master/otherfiles/logo.png" height=320px width=320px>
<hr/>
<h1>Nafas</h1>

<a href="https://badge.fury.io/py/nafas"><img src="https://badge.fury.io/py/nafas.svg" alt="PyPI version" height="18"></a>
<a href="https://codecov.io/gh/sepandhaghighi/nafas">
  <img src="https://codecov.io/gh/sepandhaghighi/nafas/branch/master/graph/badge.svg" alt="Codecov" /></a>
<a href="https://www.python.org/"><img src="https://img.shields.io/badge/built%20with-Python3-green.svg" alt="built with Python3" /></a>

</div>	

----------
## Table of contents					
   * [Overview](https://github.com/sepandhaghighi/nafas#overview)
   * [Installation](https://github.com/sepandhaghighi/nafas#installation)
   * [Usage](https://github.com/sepandhaghighi/nafas#usage)
   * [Issues & Bug Reports](https://github.com/sepandhaghighi/nafas#issues--bug-reports)
   * [Dependencies](https://github.com/sepandhaghighi/nafas#dependencies)
   * [Contribution](https://github.com/sepandhaghighi/nafas/blob/master/.github/CONTRIBUTING.md)
   * [References](https://github.com/sepandhaghighi/nafas#references)
   * [Authors](https://github.com/sepandhaghighi/nafas/blob/master/AUTHORS.md)
   * [License](https://github.com/sepandhaghighi/nafas/blob/master/LICENSE)
   * [Donate](https://github.com/sepandhaghighi/nafas#donate-to-our-project)
   * [Changelog](https://github.com/sepandhaghighi/nafas/blob/master/CHANGELOG.md)
   * [Code of Conduct](https://github.com/sepandhaghighi/nafas/blob/master/.github/CODE_OF_CONDUCT.md)			
				
## Overview						
Breathing gymnastics is a system of breathing exercises that focuses on the treatment of various diseases and general health promotion.
Nafas is a collection of breathing gymnastics designed to reduce the exhaustion of long working hours.
With multiple breathing patterns, Nafas helps you find your way to a detoxified energetic workday and also improves your concentration by increasing the oxygen level.
No need to walk away to take a break, just sit comfortably, run Nafas and let the journey begin.
**Nafas** means breath in Persian.

<table>
	<tr> 
		<td align="center">Open Hub</td>
		<td align="center"><a href="https://www.openhub.net/p/nafas"><img src="https://www.openhub.net/p/nafas/widgets/project_thin_badge.gif"></a></td>	
	</tr>
	<tr>
		<td align="center">PyPI Counter</td>
		<td align="center"><a href="http://pepy.tech/count/nafas"><img src="http://pepy.tech/badge/nafas"></a></td>
	</tr>
	<tr>
		<td align="center">Github Stars</td>
		<td align="center"><a href="https://github.com/sepandhaghighi/nafas"><img src="https://img.shields.io/github/stars/sepandhaghighi/nafas.svg?style=social&label=Stars"></a></td>
	</tr>
</table>



<table>
	<tr> 
		<td align="center">Branch</td>
		<td align="center">master</td>	
		<td align="center">dev</td>	
	</tr>
	<tr>
		<td align="center">CI</td>
		<td align="center"><img src="https://github.com/sepandhaghighi/nafas/workflows/CI/badge.svg?branch=master"></td>
		<td align="center"><img src="https://github.com/sepandhaghighi/nafas/workflows/CI/badge.svg?branch=dev"></td>
	</tr>
</table>


<table>
	<tr> 
		<td align="center">Code Quality</td>
		<td align="center"><a href="https://www.codacy.com/manual/sepand-haghighi/nafas?utm_source=github.com&amp;utm_medium=referral&amp;utm_content=sepandhaghighi/nafas&amp;utm_campaign=Badge_Grade"><img src="https://app.codacy.com/project/badge/Grade/b2be5ce052bc43a89713ac4aec6f8d11"/></a></td>	
		<td align="center"><a href="https://codebeat.co/projects/github-com-sepandhaghighi-nafas-dev"><img alt="codebeat badge" src="https://codebeat.co/badges/8b698b49-aa54-4419-a2ba-1367e8c6c08c" /></a></td>	
		<td align="center"><a href="https://www.codefactor.io/repository/github/sepandhaghighi/nafas"><img src="https://www.codefactor.io/repository/github/sepandhaghighi/nafas/badge" alt="CodeFactor" /></a></td>		
	</tr>
</table>


## Installation		

### Source Code
- Download [Version 0.3](https://github.com/sepandhaghighi/nafas/archive/v0.3.zip) or [Latest Source ](https://github.com/sepandhaghighi/nafas/archive/dev.zip)
- `pip install -r requirements.txt` or `pip3 install -r requirements.txt` (Need root access)
- `python3 setup.py install` or `python setup.py install` (Need root access)				

### PyPI

- Check [Python Packaging User Guide](https://packaging.python.org/installing/)     
- `pip install nafas==0.3` or `pip3 install nafas==0.3` (Need root access)							
	

### Exe Version (Only Windows)
- Download [Exe-Version 0.3](https://github.com/sepandhaghighi/nafas/releases/download/v0.3/NAFAS-0.3.exe)
- Run `NAFAS-0.3.exe`


## Usage			

<div align="center">

<img src="https://github.com/sepandhaghighi/nafas/raw/master/otherfiles/help.gif">
<p>Screen Record</p>

</div>


## Issues & Bug Reports			

Just fill an issue and describe it. I'll check it ASAP!							
or send an email to [sepand@pyrgg.ir](mailto:sepand@pyrgg.ir "sepand@pyrgg.ir"). 


## Dependencies

<table>
	<tr> 
		<td align="center">master</td>	
		<td align="center">dev</td>	
	</tr>
	<tr>
		<td align="center"><a href="https://requires.io/github/sepandhaghighi/nafas/requirements/?branch=master"><img src="https://requires.io/github/sepandhaghighi/nafas/requirements.svg?branch=master" alt="Requirements Status" /></a></td>
		<td align="center"><a href="https://requires.io/github/sepandhaghighi/nafas/requirements/?branch=dev"><img src="https://requires.io/github/sepandhaghighi/nafas/requirements.svg?branch=dev" alt="Requirements Status" /></a></td>
	</tr>
</table>
 			

## References

<blockquote>1- <a href="https://pranabreath.info">Prana Breath</a> </blockquote>

<blockquote>2- Rickard, Kathleen Benjamin, Dorothy J. Dunn, and Virginia M. Brouch. "Breathing techniques associated with improved health outcomes." (2015). </blockquote>

<blockquote>3- Zaccaro, Andrea, Andrea Piarulli, Marco Laurino, Erika Garbella, Danilo Menicucci, Bruno Neri, and Angelo Gemignani. "How breath-control can change your life: a systematic review on psycho-physiological correlates of slow breathing." Frontiers in human neuroscience 12 (2018): 353. </blockquote>

<blockquote>4- Brook, Robert D., Lawrence J. Appel, Melvyn Rubenfire, Gbenga Ogedegbe, John D. Bisognano, William J. Elliott, Flavio D. Fuchs et al. "Beyond medications and diet: alternative approaches to lowering blood pressure: a scientific statement from the American Heart Association." Hypertension 61, no. 6 (2013): 1360-1383. </blockquote>	

<blockquote>5- Russo, Marc A., Danielle M. Santarelli, and Dean O’Rourke. "The physiological effects of slow breathing in the healthy human." Breathe 13, no. 4 (2017): 298-309. </blockquote>	

<blockquote>6- Bujatti, M., and P. Biederer. "Serotonin, noradrenaline, dopamine metabolites in transcendental meditation-technique." Journal of Neural Transmission 39, no. 3 (1976): 257-267. </blockquote>

<blockquote>7- Martarelli, Daniele, Mario Cocchioni, Stefania Scuri, and Pierluigi Pompei. "Diaphragmatic breathing reduces exercise-induced oxidative stress." Evidence-Based Complementary and Alternative Medicine 2011 (2011). </blockquote>				
  						
<blockquote>8- <a href="https://ttsmp3.com/">Free Text-To-Speech and Text-to-MP3 for US English</a> </blockquote>


## Donate to our project		
							

<h3>Bitcoin :</h3>					

```1XGr9qbZjBpUQJJSB6WtgBQbDTgrhPLPA```			



<h3>Payping (For Iranian citizens) :</h3>

<a href="http://www.payping.net/sepandhaghighi" target="__blank"><img src="http://www.qpage.ir/images/payping.png" height=100px width=100px></a>	