import requests

def get_user_reports(auth_client, license_uuid, limit=100, page=0):
    """
    Get the list of reports generated by the current user in the specified license.

    :param license_uuid: The UUID of the license.
    :param token: The bearer token for authorization.
    :param limit: The number of reports on a page (default is 100).
    :param page: The page number (default is 0).
    :return: A JSON object with the response data.
    """
    url = f"https://api.{auth_client.region}.revizto.com/v5/departure/license/{license_uuid}"
    headers = {
        'Authorization': f'Bearer {auth_client.access_token}',
        'Accept': 'application/json'
    }
    params = {
        'limit': limit,
        'page': page
    }

    response = requests.get(url, headers=headers, params=params, verify=auth_client.verification_bool, cert=auth_client.certificate)
    
    if response.status_code != 200:
        response.raise_for_status()

    data = response.json()
    
    if data['result'] != 0:
        raise Exception(data)

    return data
