PEP: 1 Title: PEP Purpose and Guidelines Author: Barry Warsaw, Jeremy
Hylton, David Goodger, Nick Coghlan Status: Active Type: Process
Content-Type: text/x-rst Created: 13-Jun-2000 Post-History: 21-Mar-2001,
29-Jul-2002, 03-May-2003, 05-May-2012, 07-Apr-2013

What is a PEP?
==============

PEP stands for Python Enhancement Proposal. A PEP is a design document
providing information to the Python community, or describing a new
feature for Python or its processes or environment. The PEP should
provide a concise technical specification of the feature and a rationale
for the feature.

We intend PEPs to be the primary mechanisms for proposing major new
features, for collecting community input on an issue, and for
documenting the design decisions that have gone into Python. The PEP
author is responsible for building consensus within the community and
documenting dissenting opinions.

Because the PEPs are maintained as text files in a versioned repository,
their revision history is the historical record of the feature proposal
\[1\]\_.

PEP Audience
============

The typical primary audience for PEPs are the core developers of the
CPython reference interpreter and their elected Steering Council, as
well as developers of other implementations of the Python language
specification.

However, other parts of the Python community may also choose to use the
process (particularly for Informational PEPs) to document expected API
conventions and to manage complex design coordination problems that
require collaboration across multiple projects.

PEP Types
=========

There are three kinds of PEP:

1.  A **Standards Track** PEP describes a new feature or implementation
    for Python. It may also describe an interoperability standard that
    will be supported outside the standard library for current Python
    versions before a subsequent PEP adds standard library support in a
    future version.

2.  An **Informational** PEP describes a Python design issue, or
    provides general guidelines or information to the Python community,
    but does not propose a new feature. Informational PEPs do not
    necessarily represent a Python community consensus or
    recommendation, so users and implementers are free to ignore
    Informational PEPs or follow their advice.

3.  A **Process** PEP describes a process surrounding Python, or
    proposes a change to (or an event in) a process. Process PEPs are
    like Standards Track PEPs but apply to areas other than the Python
    language itself. They may propose an implementation, but not to
    Python's codebase; they often require community consensus; unlike
    Informational PEPs, they are more than recommendations, and users
    are typically not free to ignore them. Examples include procedures,
    guidelines, changes to the decision-making process, and changes to
    the tools or environment used in Python development. Any meta-PEP is
    also considered a Process PEP.

PEP Workflow
============

Python's Steering Council
-------------------------

There are several references in this PEP to the "Steering Council" or
"Council". This refers to the current members of the elected Steering
Council described in PEP 13 \[5\]\_, in their role as the final
authorities on whether or not PEPs will be accepted or rejected.

Python's Core Developers
------------------------

There are several references in this PEP to "core developers". This
refers to the currently active Python core team members described in PEP
13 \[5\]\_.

Python's BDFL
-------------

This PEP still uses the title "BDFL-Delegate" for PEP decision makers.
This is a historical reference to Python's previous governance model,
where all design authority ultimately derived from Guido van Rossum, the
original creator of the Python programming language. By contrast, the
Steering Council's design authority derives from their election by the
currently active core developers.

PEP Editors
-----------

The PEP editors are individuals responsible for managing the
administrative and editorial aspects of the PEP workflow (e.g. assigning
PEP numbers and changing their status). See
`PEP Editor Responsibilities & Workflow`\_ for details.

PEP editorship is by invitation of the current editors, and they can be
contacted by mentioning `@python/pep-editors` on GitHub. All of the PEP
workflow can be conducted via the GitHub `PEP repository`\_ issues and
pull requests.

Start with an idea for Python
-----------------------------

The PEP process begins with a new idea for Python. It is highly
recommended that a single PEP contain a single key proposal or new idea.
Small enhancements or patches often don't need a PEP and can be injected
into the Python development workflow with a patch submission to the
Python `issue tracker`\_. The more focused the PEP, the more successful
it tends to be. The PEP editors reserve the right to reject PEP
proposals if they appear too unfocused or too broad. If in doubt, split
your PEP into several well-focused ones.

Each PEP must have a champion -- someone who writes the PEP using the
style and format described below, shepherds the discussions in the
appropriate forums, and attempts to build community consensus around the
idea. The PEP champion (a.k.a. Author) should first attempt to ascertain
whether the idea is PEP-able. Posting to the comp.lang.python newsgroup
(a.k.a. python-list\@python.org mailing list) or the
python-ideas\@python.org mailing list is the best way to go about this.

Vetting an idea publicly before going as far as writing a PEP is meant
to save the potential author time. Many ideas have been brought forward
for changing Python that have been rejected for various reasons. Asking
the Python community first if an idea is original helps prevent too much
time being spent on something that is guaranteed to be rejected based on
prior discussions (searching the internet does not always do the trick).
It also helps to make sure the idea is applicable to the entire
community and not just the author. Just because an idea sounds good to
the author does not mean it will work for most people in most areas
where Python is used.

Once the champion has asked the Python community as to whether an idea
has any chance of acceptance, a draft PEP should be presented to
python-ideas. This gives the author a chance to flesh out the draft PEP
to make properly formatted, of high quality, and to address initial
concerns about the proposal.

Submitting a PEP
----------------

Following a discussion on python-ideas, the workflow varies based on
whether any of the PEP's co-authors are core developers. If one or more
of the PEP's co-authors are core developers, they are responsible for
following the process outlined below. Otherwise (i.e. none of the
co-authors are core developers), then the PEP author(s) will need to
find a sponsor for the PEP.

Ideally, a core developer sponsor is identified, but non-core sponsors
may also be selected with the approval of the Steering Council. The
sponsor's job is to provide guidance to the PEP author to help them
through the logistics of the PEP process (somewhat acting like a
mentor). Being a sponsor does **not** disqualify that person from
becoming a co-author or BDFL-Delegate later on (but not both). The
sponsor of a PEP is recorded in the "Sponsor:" field of the header.

Once the sponsor or the core developer(s) co-authoring the PEP deem the
PEP ready for submission, the proposal should be submitted as a draft
PEP via a `GitHub pull request`\_. The draft must be written in PEP
style as described below, else it will fail review immediately (although
minor errors may be corrected by the editors).

The standard PEP workflow is:

-   You, the PEP author, fork the `PEP repository`\_, and create a file
    named `pep-9999.rst` that contains your new PEP. Use "9999" as your
    draft PEP number.

-   In the "Type:" header field, enter "Standards Track",
    "Informational", or "Process" as appropriate, and for the "Status:"
    field enter "Draft". For full details, see `PEP Header Preamble`\_.

-   Push this to your GitHub fork and submit a pull request.

-   The PEP editors review your PR for structure, formatting, and other
    errors. For a reST-formatted PEP, PEP 12 is provided as a template.
    It also provides a complete introduction to reST markup that is used
    in PEPs. Approval criteria are:

    -   It sound and complete. The ideas must make technical sense. The
        editors do not consider whether they seem likely to be accepted.
    -   The title accurately describes the content.
    -   The PEP's language (spelling, grammar, sentence structure, etc.)
        and code style (examples should match PEP 8 & PEP 7) should be
        correct and conformant. The PEP will be checked for formatting
        (plain text or reStructuredText) by Travis CI, and will not be
        approved until this passes.

    Editors are generally quite lenient about this initial review,
    expecting that problems will be corrected by the reviewing process.
    **Note:** Approval of the PEP is no guarantee that there are no
    embarrassing mistakes! Correctness is the responsibility of authors
    and reviewers, not the editors.

    If the PEP isn't ready for approval, an editor will send it back to
    the author for revision, with specific instructions.

-   Once approved, they will assign your PEP a number.

Once the review process is complete, and the PEP editors approve it
(note that this is *not* the same as accepting your PEP!), they will
squash commit your pull request onto master.

The PEP editors will not unreasonably deny publication of a PEP. Reasons
for denying PEP status include duplication of effort, being technically
unsound, not providing proper motivation or addressing backwards
compatibility, or not in keeping with the Python philosophy. The
Steering Council can be consulted during the approval phase, and are the
final arbiter of a draft's PEP-ability.

Developers with git push privileges for the `PEP repository`\_ may claim
PEP numbers directly by creating and committing a new PEP. When doing
so, the developer must handle the tasks that would normally be taken
care of by the PEP editors (see
`PEP Editor Responsibilities & Workflow`\_). This includes ensuring the
initial version meets the expected standards for submitting a PEP.
Alternately, even developers should submit PEPs via pull request. When
doing so, you are generally expected to handle the process yourself; if
you need assistance from PEP editors, mention `@python/pep-editors` on
GitHub.

As updates are necessary, the PEP author can check in new versions if
they (or a collaborating developer) have git push privileges.

After a PEP number has been assigned, a draft PEP may be discussed
further on python-ideas (getting a PEP number assigned early can be
useful for ease of reference, especially when multiple draft PEPs are
being considered at the same time). Eventually, all Standards Track PEPs
must be sent to the `python-dev list <mailto:python-dev@python.org>`\_\_
for review as described in the next section.

Standards Track PEPs consist of two parts, a design document and a
reference implementation. It is generally recommended that at least a
prototype implementation be co-developed with the PEP, as ideas that
sound good in principle sometimes turn out to be impractical when
subjected to the test of implementation.

PEP authors are responsible for collecting community feedback on a PEP
before submitting it for review. However, wherever possible, long
open-ended discussions on public mailing lists should be avoided.
Strategies to keep the discussions efficient include: setting up a
separate SIG mailing list for the topic, having the PEP author accept
private comments in the early design phases, setting up a wiki page,
etc. PEP authors should use their discretion here.

PEP Review & Resolution
-----------------------

Once the authors have completed a PEP, they may request a review for
style and consistency from the PEP editors.

However, content review and final acceptance of the PEP must be
requested of the core developers, usually via an email to the python-dev
mailing list.

To expedite the process in selected cases (e.g. when a change is clearly
beneficial and ready to be accepted, but the PEP hasn't been formally
submitted for review yet), the Steering Council may also initiate a PEP
review, first notifying the PEP author(s) and giving them a chance to
make revisions.

The final authority for PEP approval is the Steering Council. However,
whenever a new PEP is put forward, any core developer that believes they
are suitably experienced to make the final decision on that PEP may
offer to serve as the BDFL-Delegate for that PEP, and they will then
have the authority to approve (or reject) that PEP. Individuals taking
on this responsibility are free to seek additional guidance from the
Steering Council at any time, and are also expected to take the advice
and perspectives of other core developers into account.

The designated decision maker for each PEP is recorded in the
"BDFL-Delegate" header in the PEP.

Such self-nominations are accepted by default, but may be explicitly
declined by the Steering Council. Possible reasons for the Steering
Council declining a self-nomination as BDFL-Delegate include, but are
not limited to, perceptions of a potential conflict of interest
(e.g. working for the same organisation as the PEP submitter), or simply
considering another potential BDFL-Delegate to be more appropriate. If
core developers (or other community members) have concerns regarding the
suitability of a BDFL-Delegate for any given PEP, they may ask the
Steering Council to review the delegation.

If no volunteer steps forward, then the Steering Council will approach
core developers (and potentially other Python community members) with
relevant expertise, in an attempt to identify a candidate that is
willing to serve as BDFL-Delegate for that PEP. If no suitable candidate
can be found, then the PEP will be marked as Deferred until one is
available.

Previously appointed BDFL-Delegates may choose to step down, or be asked
to step down by the Council, in which case a new BDFL-Delegate will be
appointed in the same manner as for a new PEP (including deferral of the
PEP if no suitable replacement can be found). In the event that a
BDFL-Delegate is asked to step down, this will overrule any prior
acceptance or rejection of the PEP, and it will revert to Draft status.

With the approval of the Steering Council, PEP review and resolution may
also occur on a list other than python-dev (for example, distutils-sig
for packaging related PEPs that don't immediately affect the standard
library). In these cases, the "Discussions-To" heading in the PEP will
identify the appropriate alternative list where discussion, review and
pronouncement on the PEP will occur.

When such standing delegations are put in place, the Steering Council
will maintain sufficient public records to allow subsequent Councils,
the core developers, and the wider Python community to understand the
delegations that currently exist, why they were put in place, and the
circumstances under which they may no longer be needed.

For a PEP to be accepted it must meet certain minimum criteria. It must
be a clear and complete description of the proposed enhancement. The
enhancement must represent a net improvement. The proposed
implementation, if applicable, must be solid and must not complicate the
interpreter unduly. Finally, a proposed enhancement must be "pythonic"
in order to be accepted by the Steering Council. (However, "pythonic" is
an imprecise term; it may be defined as whatever is acceptable to the
Steering Council. This logic is intentionally circular.) See PEP 2
\[2\]\_ for standard library module acceptance criteria.

Once a PEP has been accepted, the reference implementation must be
completed. When the reference implementation is complete and
incorporated into the main source code repository, the status will be
changed to "Final".

To allow gathering of additional design and interface feedback before
committing to long term stability for a language feature or standard
library API, a PEP may also be marked as "Provisional". This is short
for "Provisionally Accepted", and indicates that the proposal has been
accepted for inclusion in the reference implementation, but additional
user feedback is needed before the full design can be considered
"Final". Unlike regular accepted PEPs, provisionally accepted PEPs may
still be Rejected or Withdrawn *even after the related changes have been
included in a Python release*.

Wherever possible, it is considered preferable to reduce the scope of a
proposal to avoid the need to rely on the "Provisional" status (e.g. by
deferring some features to later PEPs), as this status can lead to
version compatibility challenges in the wider Python ecosystem. PEP 411
provides additional details on potential use cases for the Provisional
status.

A PEP can also be assigned the status "Deferred". The PEP author or an
editor can assign the PEP this status when no progress is being made on
the PEP. Once a PEP is deferred, a PEP editor can re-assign it to draft
status.

A PEP can also be "Rejected". Perhaps after all is said and done it was
not a good idea. It is still important to have a record of this fact.
The "Withdrawn" status is similar - it means that the PEP author
themselves has decided that the PEP is actually a bad idea, or has
accepted that a competing proposal is a better alternative.

When a PEP is Accepted, Rejected or Withdrawn, the PEP should be updated
accordingly. In addition to updating the status field, at the very least
the Resolution header should be added with a link to the relevant post
in the python-dev mailing list archives.

PEPs can also be superseded by a different PEP, rendering the original
obsolete. This is intended for Informational PEPs, where version 2 of an
API can replace version 1.

The possible paths of the status of PEPs are as follows:

.. image:: pep-0001-process\_flow.png :alt: PEP process flow diagram

While not shown in the diagram, "Accepted" PEPs may technically move to
"Rejected" or "Withdrawn" even after acceptance. This will only occur if
the implementation process reveals fundamental flaws in the design that
were not noticed prior to acceptance of the PEP. Unlike Provisional
PEPs, these transitions are only permitted if the accepted proposal has
*not* been included in a Python release - released changes must instead
go through the regular deprecation process (which may require a new PEP
providing the rationale for the deprecation).

Some Informational and Process PEPs may also have a status of "Active"
if they are never meant to be completed. E.g. PEP 1 (this PEP).

PEP Maintenance
---------------

In general, Standards track PEPs are no longer modified after they have
reached the Final state. Once a PEP has been completed, the Language and
Standard Library References become the formal documentation of the
expected behavior.

If changes based on implementation experience and user feedback are made
to Standards track PEPs while in the Accepted or Provisional State,
those changes should be noted in the PEP, such that the PEP accurately
describes the state of the implementation at the point where it is
marked Final.

Informational and Process PEPs may be updated over time to reflect
changes to development practices and other details. The precise process
followed in these cases will depend on the nature and purpose of the PEP
being updated.

What belongs in a successful PEP?
=================================

Each PEP should have the following parts/sections:

1.  Preamble -- RFC 822 style headers containing meta-data about the
    PEP, including the PEP number, a short descriptive title (limited to
    a maximum of 44 characters), the names, and optionally the contact
    info for each author, etc.

2.  Abstract -- a short (\~200 word) description of the technical issue
    being addressed.

3.  Motivation -- The motivation is critical for PEPs that want to
    change the Python language, library, or ecosystem. It should clearly
    explain why the existing language specification is inadequate to
    address the problem that the PEP solves. PEP submissions without
    sufficient motivation may be rejected outright.

4.  Rationale -- The rationale fleshes out the specification by
    describing why particular design decisions were made. It should
    describe alternate designs that were considered and related work,
    e.g. how the feature is supported in other languages.

    The rationale should provide evidence of consensus within the
    community and discuss important objections or concerns raised during
    discussion.

5.  Specification -- The technical specification should describe the
    syntax and semantics of any new language feature. The specification
    should be detailed enough to allow competing, interoperable
    implementations for at least the current major Python platforms
    (CPython, Jython, IronPython, PyPy).

6.  Backwards Compatibility -- All PEPs that introduce backwards
    incompatibilities must include a section describing these
    incompatibilities and their severity. The PEP must explain how the
    author proposes to deal with these incompatibilities. PEP
    submissions without a sufficient backwards compatibility treatise
    may be rejected outright.

7.  Security Implications -- If there are security concerns in relation
    to the PEP, those concerns should be explicitly written out to make
    sure reviewers of the PEP are aware of them.

8.  How to Teach This -- For a PEP that adds new functionality or
    changes language behavior, it is helpful to include a section on how
    to teach users, new and experienced, how to apply the PEP to their
    work.

    This section may include key points and recommended documentation
    changes that would help users adopt a new feature or migrate their
    code to use a language change.

9.  Reference Implementation -- The reference implementation must be
    completed before any PEP is given status "Final", but it need not be
    completed before the PEP is accepted. While there is merit to the
    approach of reaching consensus on the specification and rationale
    before writing code, the principle of "rough consensus and running
    code" is still useful when it comes to resolving many discussions of
    API details.

    The final implementation must include test code and documentation
    appropriate for either the Python language reference or the standard
    library reference.

10. Rejected Ideas -- Throughout the discussion of a PEP, various ideas
    will be proposed which are not accepted. Those rejected ideas should
    be recorded along with the reasoning as to why they were rejected.
    This both helps record the thought process behind the final version
    of the PEP as well as preventing people from bringing up the same
    rejected idea again in subsequent discussions.

    In a way this section can be thought of as a breakout section of the
    Rationale section that is focused specifically on why certain ideas
    were not ultimately pursued.

11. Open Issues -- While a PEP is in draft, ideas can come up which
    warrant further discussion. Those ideas should be recorded so people
    know that they are being thought about but do not have a concrete
    resolution. This helps make sure all issues required for the PEP to
    be ready for consideration are complete complete and reduces people
    duplicating prior discussion.

12. References -- A collection of URLs used as references through the
    PEP.

13. Copyright/license -- Each new PEP must be placed under a dual
    license of public domain and CC0-1.0-Universal\_ (see this PEP for
    an example).

PEP Formats and Templates
=========================

PEPs are UTF-8 encoded text files using the reStructuredText\_ format.
ReStructuredText\_ allows for rich markup that is still quite easy to
read, but also results in good-looking and functional HTML. PEP 12
contains instructions and a template \[4\]\_ for reStructuredText PEPs.

The PEP text files are automatically converted to HTML \[6\]\_ for
easier `online reading <https://www.python.org/dev/peps/>`\_\_.

PEP Header Preamble
===================

Each PEP must begin with an RFC 822 style header preamble. The headers
must appear in the following order. Headers marked with \"\*\" are
optional and are described below. All other headers are required. ::

    PEP: <pep number>
    Title: <pep title>
    Author: <list of authors' real names and optionally, email addrs>

-   Sponsor: <real name of sponsor>
-   BDFL-Delegate: \<PEP czar's real name\>
-   Discussions-To: <email address> Status: \<Draft \| Active \|
    Accepted \| Provisional \| Deferred \| Rejected \| Withdrawn \|
    Final \| Superseded\> Type: \<Standards Track \| Informational \|
    Process\>
-   Content-Type: \<text/x-rst \| text/plain\>
-   Requires: <pep numbers> Created: \<date created on, in dd-mmm-yyyy
    format\>
-   Python-Version: <version number> Post-History:
    <dates of postings to python-ideas and/or python-dev>
-   Replaces: <pep number>
-   Superseded-By: <pep number>
-   Resolution: <url>

The Author header lists the names, and optionally the email addresses of
all the authors/owners of the PEP. The format of the Author header value
must be

    Random J. User <address@dom.ain>

if the email address is included, and just

    Random J. User

if the address is not given. For historical reasons the format
"address\@dom.ain (Random J. User)" may appear in a PEP, however new
PEPs must use the mandated format above, and it is acceptable to change
to this format when PEPs are updated.

If there are multiple authors, each should be on a separate line
following RFC 2822 continuation line conventions. Note that personal
email addresses in PEPs will be obscured as a defense against spam
harvesters.

The Sponsor field records which developer (core, or otherwise approved
by the Steering Council) is sponsoring the PEP. If one of the authors of
the PEP is a core developer then no sponsor is necessary and thus this
field should be left out.

The BDFL-Delegate field is used to record the individual appointed by
the Steering Council to make the final decision on whether or not to
approve or reject a PEP. (The delegate's email address is currently
omitted due to a limitation in the email address masking for
reStructuredText PEPs)

*Note: The Resolution header is required for Standards Track PEPs only.
It contains a URL that should point to an email message or other web
resource where the pronouncement about the PEP is made.*

For a PEP where final pronouncement will be made on a list other than
python-dev, a Discussions-To header will indicate the mailing list or
URL where the pronouncement will occur. A temporary Discussions-To
header may also be used when a draft PEP is being discussed prior to
submission for pronouncement. No Discussions-To header is necessary if
the PEP is being discussed privately with the author, or on the
python-list, python-ideas or python-dev mailing lists. Note that email
addresses in the Discussions-To header will not be obscured.

The Type header specifies the type of PEP: Standards Track,
Informational, or Process.

The format of a PEP is specified with a Content-Type header. The
acceptable values are "text/plain" for plaintext PEPs (see PEP 9 \[3\]*)
and "text/x-rst" for reStructuredText PEPs (see PEP 12 \[4\]*).
reStructuredText is strongly preferred, but for backwards compatibility
plain text is currently still the default if no Content-Type header is
present.

The Created header records the date that the PEP was assigned a number,
while Post-History is used to record the dates of when new versions of
the PEP are posted to python-ideas and/or python-dev. Both headers
should be in dd-mmm-yyyy format, e.g. 14-Aug-2001.

Standards Track PEPs will typically have a Python-Version header which
indicates the version of Python that the feature will be released with.
Standards Track PEPs without a Python-Version header indicate
interoperability standards that will initially be supported through
external libraries and tools, and then potentially supplemented by a
later PEP to add support to the standard library. Informational and
Process PEPs do not need a Python-Version header.

PEPs may have a Requires header, indicating the PEP numbers that this
PEP depends on.

PEPs may also have a Superseded-By header indicating that a PEP has been
rendered obsolete by a later document; the value is the number of the
PEP that replaces the current document. The newer PEP must have a
Replaces header containing the number of the PEP that it rendered
obsolete.

Auxiliary Files
===============

PEPs may include auxiliary files such as diagrams. Such files should be
named `pep-XXXX-Y.ext`, where "XXXX" is the PEP number, "Y" is a serial
number (starting at 1), and "ext" is replaced by the actual file
extension (e.g. "png").

Alternatively, all support files may be placed in a subdirectory called
`pep-XXXX`, where "XXXX" is the PEP number. When using a subdirectory,
there are no constraints on the names used in files.

Reporting PEP Bugs, or Submitting PEP Updates
=============================================

How you report a bug, or submit a PEP update depends on several factors,
such as the maturity of the PEP, the preferences of the PEP author, and
the nature of your comments. For the early draft stages of the PEP, it's
probably best to send your comments and changes directly to the PEP
author. For more mature, or finished PEPs you may want to submit
corrections as a `GitHub issue`\_ or `GitHub pull request`\_ so that
your changes don't get lost.

When in doubt about where to send your changes, please check first with
the PEP author and/or a PEP editor.

PEP authors with git push privileges for the PEP repository can update
the PEPs themselves by using "git push" or the GitHub PR interface to
submit their changes.

Transferring PEP Ownership
==========================

It occasionally becomes necessary to transfer ownership of PEPs to a new
champion. In general, it is preferable to retain the original author as
a co-author of the transferred PEP, but that's really up to the original
author. A good reason to transfer ownership is because the original
author no longer has the time or interest in updating it or following
through with the PEP process, or has fallen off the face of the 'net
(i.e. is unreachable or not responding to email). A bad reason to
transfer ownership is because the author doesn't agree with the
direction of the PEP. One aim of the PEP process is to try to build
consensus around a PEP, but if that's not possible, an author can always
submit a competing PEP.

If you are interested in assuming ownership of a PEP, you can also do
this via pull request. Fork the `PEP repository`\_, make your ownership
modification, and submit a pull request. You should mention both the
original author and `@python/pep-editors` in a comment on the pull
request. (If the original author's GitHub username is unknown, use
email.) If the original author doesn't respond in a timely manner, the
PEP editors will make a unilateral decision (it's not like such
decisions can't be reversed :).

PEP Editor Responsibilities & Workflow
======================================

A PEP editor must be added to the `@python/pep-editors` group on GitHub
and must watch the `PEP repository`\_.

Note that developers with git push privileges for the `PEP repository`\_
may handle the tasks that would normally be taken care of by the PEP
editors. Alternately, even developers may request assistance from PEP
editors by mentioning `@python/pep-editors` on GitHub.

For each new PEP that comes in an editor does the following:

-   Make sure that the PEP is either co-authored by a core developer,
    has a core developer as a sponsor, or has a sponsor specifically
    approved for this PEP by the Steering Council.

-   Read the PEP to check if it is ready: sound and complete. The ideas
    must make technical sense, even if they don't seem likely to be
    accepted.

-   The title should accurately describe the content.

-   The file name extension is correct (i.e. `.rst`).

-   Skim the PEP for obvious defects in language (spelling, grammar,
    sentence structure, etc.), and code style (examples should conform
    to PEP 8 & PEP 7). Editors may correct problems themselves, but are
    not required to do so. (Text format is checked by Travis CI.)

If the PEP isn't ready, an editor will send it back to the author for
revision, with specific instructions. If reST formatting is a problem,
ask the author(s) to use PEP 12 as a template and resubmit.

Once the PEP is ready for the repository, a PEP editor will:

-   Assign a PEP number (almost always just the next available number,
    but sometimes it's a special/joke number, like 666 or 3141).
    (Clarification: For Python 3, numbers in the 3000s were used for
    Py3k-specific proposals. But now that all new features go into
    Python 3 only, the process is back to using numbers in the 100s
    again. Remember that numbers below 100 are meta-PEPs.)

-   Check that the author has correctly labeled the PEP's type
    ("Standards Track", "Informational", or "Process"), and marked its
    status as "Draft".

-   Add the PEP to a local fork of the PEP repository. For workflow
    instructions, follow
    `The Python Developers Guide <http://docs.python.org/devguide>`\_

    The git repo for the peps is::

    https://github.com/python/peps

-   Run `./genpepindex.py` and `./pep2html.py <PEP Number>` to ensure
    they are generated without errors. If either triggers errors, then
    the web site will not be updated to reflect the PEP changes.

-   Commit and push the new (or updated) PEP

-   Monitor python.org to make sure the PEP gets added to the site
    properly. If it fails to appear, running `make` will build all of
    the current PEPs. If any of these are triggering errors, they must
    be corrected before any PEP will update on the site.

-   Send email back to the PEP author with next steps (post to
    python-list & -dev).

Updates to existing PEPs should be submitted as a
`GitHub pull request`\_.

Many PEPs are written and maintained by developers with write access to
the Python codebase. The PEP editors monitor the PEP repository for
changes, and correct any structure, grammar, spelling, or markup
mistakes they see.

PEP editors don't pass judgment on PEPs. They merely do the
administrative & editorial part (which is generally a low volume task).

Resources:

-   `Index of Python Enhancement Proposals <http://www.python.org/dev/peps/>`\_

-   `Following Python's Development <http://docs.python.org/devguide/communication.html>`\_

-   `Python Developer's Guide <http://docs.python.org/devguide/>`\_

-   `Frequently Asked Questions for Developers <http://docs.python.org/devguide/faq.html>`\_

References and Footnotes
========================

.. \[1\] This historical record is available by the normal git commands
for retrieving older revisions, and can also be browsed via HTTP here:
https://github.com/python/peps

.. \[2\] PEP 2, Procedure for Adding New Modules
(http://www.python.org/dev/peps/pep-0002)

.. \[3\] PEP 9, Sample Plaintext PEP Template
(http://www.python.org/dev/peps/pep-0009)

.. \[4\] PEP 12, Sample reStructuredText PEP Template
(http://www.python.org/dev/peps/pep-0012)

.. \[5\] PEP 13, Python Language Governance
(http://www.python.org/dev/peps/pep-0013)

.. \[6\] More details on the PEP rendering and publication process can
be found in the PEPs repo README at
https://github.com/python/peps/blob/master/README.rst

.. \_issue tracker: http://bugs.python.org/

.. \_CC0-1.0-Universal: https://choosealicense.com/licenses/cc0-1.0/

.. \_reStructuredText: http://docutils.sourceforge.net/rst.html

.. \_Docutils: http://docutils.sourceforge.net/

.. \_PEP repository: https://github.com/python/peps

.. \_`GitHub pull request`: https://github.com/python/peps/pulls

.. \_`GitHub issue`: https://github.com/python/peps/issues

Copyright
=========

This document is placed in the public domain or under the
CC0-1.0-Universal license, whichever is more permissive.

.. Local Variables: mode: indented-text indent-tabs-mode: nil
sentence-end-double-space: t fill-column: 70 coding: utf-8 End:
