PEP: 3 Title: Guidelines for Handling Bug Reports Version: $Revision$
Last-Modified: $Date$ Author: jeremy\@alum.mit.edu (Jeremy Hylton)
Status: Withdrawn Type: Process Content-Type: text/x-rst Created:
25-Sep-2000 Post-History:

Introduction
============

This PEP contained guidelines for handling bug reports in the Python bug
tracker. It has been replaced by the Developer's Guide description of
issue triaging at

::

    https://docs.python.org/devguide/triaging.html

Guidelines for people submitting Python bugs are at

::

    http://docs.python.org/bugs.html

Original Guidelines
===================

1.  Make sure the bug category and bug group are correct. If they are
    correct, it is easier for someone interested in helping to find out,
    say, what all the open Tkinter bugs are.

2.  If it's a minor feature request that you don't plan to address right
    away, add it to PEP 42 or ask the owner to add it for you. If you
    add the bug to PEP 42, mark the bug as "feature request", "later",
    and "closed"; and add a comment to the bug saying that this is the
    case (mentioning the PEP explicitly).

    ::

         XXX do we prefer the tracker or PEP 42?

3.  Assign the bug a reasonable priority. We don't yet have a clear
    sense of what each priority should mean. One rule, however, is that
    bugs with priority "urgent" or higher must be fixed before the next
    release.

4.  If a bug report doesn't have enough information to allow you to
    reproduce or diagnose it, ask the original submitter for more
    information. If the original report is really thin and your email
    doesn't get a response after a reasonable waiting period, you can
    close the bug.

5.  If you fix a bug, mark the status as "Fixed" and close it. In the
    comments, include the SVN revision numbers of the commit(s). In the
    SVN checkin message, include the issue number **and** a normal
    description of the change, mentioning the contributor if a patch was
    applied.

6.  If you are assigned a bug that you are unable to deal with, assign
    it to someone else if you think they will be able to deal with it,
    otherwise it's probably best to unassign it.

References
==========

.. \[1\] http://bugs.python.org/
