PEP: 6 Title: Bug Fix Releases Version: $Revision$ Last-Modified: $Date$
Author: aahz\@pythoncraft.com (Aahz), anthony\@interlink.com.au (Anthony
Baxter) Status: Active Type: Process Content-Type: text/x-rst Created:
15-Mar-2001 Post-History: 15-Mar-2001 18-Apr-2001 19-Aug-2004

Abstract
========

Python has historically had only a single fork of development, with
releases having the combined purpose of adding new features and
delivering bug fixes (these kinds of releases will be referred to as
"major releases"). This PEP describes how to fork off maintenance, or
bug fix, releases of old versions for the primary purpose of fixing
bugs.

This PEP is not, repeat NOT, a guarantee of the existence of bug fix
releases; it only specifies a procedure to be followed if bug fix
releases are desired by enough of the Python community willing to do the
work.

Motivation
==========

With the move to SourceForge, Python development has accelerated. There
is a sentiment among part of the community that there was too much
acceleration, and many people are uncomfortable with upgrading to new
versions to get bug fixes when so many features have been added,
sometimes late in the development cycle.

One solution for this issue is to maintain the previous major release,
providing bug fixes until the next major release. This should make
Python more attractive for enterprise development, where Python may need
to be installed on hundreds or thousands of machines.

Prohibitions
============

Bug fix releases are required to adhere to the following restrictions:

1.  There must be zero syntax changes. All `.pyc` and `.pyo` files must
    work (no regeneration needed) with all bugfix releases forked off
    from a major release.

2.  There must be zero pickle changes.

3.  There must be no incompatible C API changes. All extensions must
    continue to work without recompiling in all bugfix releases in the
    same fork as a major release.

Breaking any of these prohibitions requires a BDFL proclamation (and a
prominent warning in the release notes).

Not-Quite-Prohibitions
======================

Where possible, bug fix releases should also:

1.  Have no new features. The purpose of a bug fix release is to fix
    bugs, not add the latest and greatest whizzo feature from the HEAD
    of the CVS root.

2.  Be a painless upgrade. Users should feel confident that an upgrade
    from 2.x.y to 2.x.(y+1) will not break their running systems. This
    means that, unless it is necessary to fix a bug, the standard
    library should not change behavior, or worse yet, APIs.

Applicability of Prohibitions
=============================

The above prohibitions and not-quite-prohibitions apply both for a final
release to a bugfix release (for instance, 2.4 to 2.4.1) and for one
bugfix release to the next in a series (for instance 2.4.1 to 2.4.2).

Following the prohibitions listed in this PEP should help keep the
community happy that a bug fix release is a painless and safe upgrade.

Helping the Bug Fix Releases Happen
===================================

Here's a few pointers on helping the bug fix release process along.

1.  Backport bug fixes. If you fix a bug, and it seems appropriate, port
    it to the CVS branch for the current bug fix release. If you're
    unwilling or unable to backport it yourself, make a note in the
    commit message, with words like 'Bugfix candidate' or 'Backport
    candidate'.

2.  If you're not sure, ask. Ask the person managing the current bug fix
    releases if they think a particular fix is appropriate.

3.  If there's a particular bug you'd particularly like fixed in a bug
    fix release, jump up and down and try to get it done. Do not wait
    until 48 hours before a bug fix release is due, and then start
    asking for bug fixes to be included.

Version Numbers
===============

Starting with Python 2.0, all major releases are required to have a
version number of the form X.Y; bugfix releases will always be of the
form X.Y.Z.

The current major release under development is referred to as release N;
the just-released major version is referred to as N-1.

In CVS, the bug fix releases happen on a branch. For release 2.x, the
branch is named 'release2x-maint'. For example, the branch for the 2.3
maintenance releases is release23-maint

Procedure
=========

The process for managing bugfix releases is modeled in part on the Tcl
system \[1\]\_.

The Patch Czar is the counterpart to the BDFL for bugfix releases.
However, the BDFL and designated appointees retain veto power over
individual patches. A Patch Czar might only be looking after a single
branch of development - it's quite possible that a different person
might be maintaining the 2.3.x and the 2.4.x releases.

As individual patches get contributed to the current trunk of CVS, each
patch committer is requested to consider whether the patch is a bug fix
suitable for inclusion in a bugfix release. If the patch is considered
suitable, the committer can either commit the release to the maintenance
branch, or else mark the patch in the commit message.

In addition, anyone from the Python community is free to suggest patches
for inclusion. Patches may be submitted specifically for bugfix
releases; they should follow the guidelines in PEP 3 \[2\]\_. In
general, though, it's probably better that a bug in a specific release
also be fixed on the HEAD as well as the branch.

The Patch Czar decides when there are a sufficient number of patches to
warrant a release. The release gets packaged up, including a Windows
installer, and made public. If any new bugs are found, they must be
fixed immediately and a new bugfix release publicized (with an
incremented version number). For the 2.3.x cycle, the Patch Czar
(Anthony) has been trying for a release approximately every six months,
but this should not be considered binding in any way on any future
releases.

Bug fix releases are expected to occur at an interval of roughly six
months. This is only a guideline, however - obviously, if a major bug is
found, a bugfix release may be appropriate sooner. In general, only the
N-1 release will be under active maintenance at any time. That is,
during Python 2.4's development, Python 2.3 gets bugfix releases. If,
however, someone qualified wishes to continue the work to maintain an
older release, they should be encouraged.

Patch Czar History
==================

Anthony Baxter is the Patch Czar for 2.3.1 through 2.3.4.

Barry Warsaw is the Patch Czar for 2.2.3.

Guido van Rossum is the Patch Czar for 2.2.2.

Michael Hudson is the Patch Czar for 2.2.1.

Anthony Baxter is the Patch Czar for 2.1.2 and 2.1.3.

Thomas Wouters is the Patch Czar for 2.1.1.

Moshe Zadka is the Patch Czar for 2.0.1.

History
=======

This PEP started life as a proposal on comp.lang.python. The original
version suggested a single patch for the N-1 release to be released
concurrently with the N release. The original version also argued for
sticking with a strict bug fix policy.

Following feedback from the BDFL and others, the draft PEP was written
containing an expanded bugfix release cycle that permitted any previous
major release to obtain patches and also relaxed the strict bug fix
requirement (mainly due to the example of PEP 235 \[3\]\_, which could
be argued as either a bug fix or a feature).

Discussion then mostly moved to python-dev, where BDFL finally issued a
proclamation basing the Python bugfix release process on Tcl's, which
essentially returned to the original proposal in terms of being only the
N-1 release and only bug fixes, but allowing multiple bugfix releases
until release N is published.

Anthony Baxter then took this PEP and revised it, based on lessons from
the 2.3 release cycle.

References
==========

.. \[1\] http://www.tcl.tk/cgi-bin/tct/tip/28.html

.. \[2\] PEP 3, Guidelines for Handling Bug Reports, Hylton
(http://www.python.org/dev/peps/pep-0003/)

.. \[3\] PEP 235, Import on Case-Insensitive Platforms, Peters
(http://www.python.org/dev/peps/pep-0235/)

Copyright
=========

This document has been placed in the public domain.

.. Local Variables: mode: indented-text indent-tabs-mode: nil End:
