PEP: 13 Title: Python Language Governance Author: The Python core team
and community Status: Active Type: Informational Content-Type:
text/x-rst Created: 2018-12-16

Abstract
========

This PEP defines the formal governance process for Python, and records
how this has changed over time. Currently, governance is based around a
steering council. The council has broad authority, which they seek to
exercise as rarely as possible.

Current steering council
========================

The current steering council consists of:

-   Barry Warsaw
-   Brett Cannon
-   Carol Willing
-   Thomas Wouters
-   Victor Stinner

Per the results of the vote tracked in PEP 8101.

The core team consists of those listed in the private
<https://github.com/python/voters/> repository which is publicly shared
via <https://devguide.python.org/developers/>.

Specification
=============

The steering council
--------------------

### Composition

The steering council is a 5-person committee.

### Mandate

The steering council shall work to:

-   Maintain the quality and stability of the Python language and
    CPython interpreter,
-   Make contributing as accessible, inclusive, and sustainable as
    possible,
-   Formalize and maintain the relationship between the core team and
    the PSF,
-   Establish appropriate decision-making processes for PEPs,
-   Seek consensus among contributors and the core team before acting in
    a formal capacity,
-   Act as a \"court of final appeal\" for decisions where all other
    methods have failed.

### Powers

The council has broad authority to make decisions about the project. For
example, they can:

-   Accept or reject PEPs
-   Enforce or update the project\'s code of conduct
-   Work with the PSF to manage any project assets
-   Delegate parts of their authority to other subcommittees or
    processes

However, they cannot modify this PEP, or affect the membership of the
core team, except via the mechanisms specified in this PEP.

The council should look for ways to use these powers as little as
possible. Instead of voting, it\'s better to seek consensus. Instead of
ruling on individual PEPs, it\'s better to define a standard process for
PEP decision making (for example, by accepting one of the other 801x
series of PEPs). It\'s better to establish a Code of Conduct committee
than to rule on individual cases. And so on.

To use its powers, the council votes. Every council member must either
vote or explicitly abstain. Members with conflicts of interest on a
particular vote must abstain. Passing requires a strict majority of
non-abstaining council members.

Whenever possible, the council\'s deliberations and votes shall be held
in public.

### Electing the council

A council election consists of two phases:

-   Phase 1: Candidates advertise their interest in serving. Candidates
    must be nominated by a core team member. Self-nominations are
    allowed.
-   Phase 2: Each core team member can vote for zero or more of the
    candidates. Voting is performed anonymously. Candidates are ranked
    by the total number of votes they receive. If a tie occurs, it may
    be resolved by mutual agreement among the candidates, or else the
    winner will be chosen at random.

Each phase lasts one to two weeks, at the outgoing council\'s
discretion. For the initial election, both phases will last two weeks.

The election process is managed by a returns officer nominated by the
outgoing steering council. For the initial election, the returns officer
will be nominated by the PSF Executive Director.

The council should ideally reflect the diversity of Python contributors
and users, and core team members are encouraged to vote accordingly.

### Term

A new council is elected after each feature release. Each council\'s
term runs from when their election results are finalized until the next
council\'s term starts. There are no term limits.

### Vacancies

Council members may resign their position at any time.

Whenever there is a vacancy during the regular council term, the council
may vote to appoint a replacement to serve out the rest of the term.

If a council member drops out of touch and cannot be contacted for a
month or longer, then the rest of the council may vote to replace them.

### Conflicts of interest

While we trust council members to act in the best interests of Python
rather than themselves or their employers, the mere appearance of any
one company dominating Python development could itself be harmful and
erode trust. In order to avoid any appearance of conflict of interest,
at most 2 members of the council can work for any single employer.

In a council election, if 3 of the top 5 vote-getters work for the same
employer, then whichever of them ranked lowest is disqualified and the
6th-ranking candidate moves up into 5th place; this is repeated until a
valid council is formed.

During a council term, if changing circumstances cause this rule to be
broken (for instance, due to a council member changing employment), then
one or more council members must resign to remedy the issue, and the
resulting vacancies can then be filled as normal.

### Ejecting core team members

In exceptional circumstances, it may be necessary to remove someone from
the core team against their will. (For example: egregious and ongoing
code of conduct violations.) This can be accomplished by a steering
council vote, but unlike other steering council votes, this requires at
least a two-thirds majority. With 5 members voting, this means that a
3:2 vote is insufficient; 4:1 in favor is the minimum required for such
a vote to succeed. In addition, this is the one power of the steering
council which cannot be delegated, and this power cannot be used while a
vote of no confidence is in process.

If the ejected core team member is also on the steering council, then
they are removed from the steering council as well.

### Vote of no confidence

In exceptional circumstances, the core team may remove a sitting council
member, or the entire council, via a vote of no confidence.

A no-confidence vote is triggered when a core team member calls for one
publically on an appropriate project communication channel, and another
core team member seconds the proposal.

The vote lasts for two weeks. Core team members vote for or against. If
at least two thirds of voters express a lack of confidence, then the
vote succeeds.

There are two forms of no-confidence votes: those targeting a single
member, and those targeting the council as a whole. The initial call for
a no-confidence vote must specify which type is intended. If a
single-member vote succeeds, then that member is removed from the
council and the resulting vacancy can be handled in the usual way. If a
whole-council vote succeeds, the council is dissolved and a new council
election is triggered immediately.

The core team
-------------

### Role

The core team is the group of trusted volunteers who manage Python. They
assume many roles required to achieve the project\'s goals, especially
those that require a high level of trust. They make the decisions that
shape the future of the project.

Core team members are expected to act as role models for the community
and custodians of the project, on behalf of the community and all those
who rely on Python.

They will intervene, where necessary, in online discussions or at
official Python events on the rare occasions that a situation arises
that requires intervention.

They have authority over the Python Project infrastructure, including
the Python Project website itself, the Python GitHub organization and
repositories, the bug tracker, the mailing lists, IRC channels, etc.

### Prerogatives

Core team members may participate in formal votes, typically to nominate
new team members and to elect the steering council.

### Membership

Python core team members demonstrate:

-   a good grasp of the philosophy of the Python Project
-   a solid track record of being constructive and helpful
-   significant contributions to the project\'s goals, in any form
-   willingness to dedicate some time to improving Python

As the project matures, contributions go beyond code. Here\'s an
incomplete list of areas where contributions may be considered for
joining the core team, in no particular order:

-   Working on community management and outreach
-   Providing support on the mailing lists and on IRC
-   Triaging tickets
-   Writing patches (code, docs, or tests)
-   Reviewing patches (code, docs, or tests)
-   Participating in design decisions
-   Providing expertise in a particular domain (security, i18n, etc.)
-   Managing the continuous integration infrastructure
-   Managing the servers (website, tracker, documentation, etc.)
-   Maintaining related projects (alternative interpreters, core
    infrastructure like packaging, etc.)
-   Creating visual designs

Core team membership acknowledges sustained and valuable efforts that
align well with the philosophy and the goals of the Python project.

It is granted by receiving at least two-thirds positive votes in a core
team vote that is open for one week and with no veto by the steering
council.

Core team members are always looking for promising contributors,
teaching them how the project is managed, and submitting their names to
the core team\'s vote when they\'re ready.

There\'s no time limit on core team membership. However, in order to
provide the general public with a reasonable idea of how many people
maintain Python, core team members who have stopped contributing are
encouraged to declare themselves as \"inactive\". Those who haven\'t
made any non-trivial contribution in two years may be asked to move
themselves to this category, and moved there if they don\'t respond. To
record and honor their contributions, inactive team members will
continue to be listed alongside active core team members; and, if they
later resume contributing, they can switch back to active status at
will. While someone is in inactive status, though, they lose their
active privileges like voting or nominating for the steering council,
and commit access.

The initial active core team members will consist of everyone currently
listed in the [\"Python core\" team on
Github](https://github.com/orgs/python/teams/python-core/members)
(access granted for core members only), and the initial inactive members
will consist of everyone else who has been a committer in the past.

Changing this document
----------------------

Changes to this document require at least a two-thirds majority of votes
cast in a core team vote which should be open for two weeks.

History
=======

Creation of this document
-------------------------

The Python project was started by Guido van Rossum, who served as its
Benevolent Dictator for Life (BDFL) from inception until July 2018, when
he [stepped
down](https://mail.python.org/pipermail/python-committers/2018-July/005664.html).

After discussion, a number of proposals were put forward for a new
governance model, and the core devs voted to choose between them. The
overall process is described in PEP 8000 and PEP 8001, a review of other
projects was performed in PEP 8002, and the proposals themselves were
written up as the 801x series of PEPs. Eventually the proposal in PEP
8016 was
[selected](https://discuss.python.org/t/python-governance-vote-december-2018-results/546)
as the new governance model, and was used to create the initial version
of this PEP. The 8000-series PEPs are preserved for historical reference
(and in particular, PEP 8016 contains additional rationale and links to
contemporary discussions), but this PEP is now the official reference,
and will evolve following the rules described herein.

History of council elections
----------------------------

-   January 2019: PEP 8100
-   December 2019: PEP 8101

History of amendments
---------------------

2019-04-17: Added the vote length for core devs and changes to this
document.

Acknowledgements
================

This PEP began as PEP 8016, which was written by Nathaniel J. Smith and
Donald Stufft, based on a Django governance document written by Aymeric
Augustin, and incorporated feedback and assistance from numerous others.

Copyright
=========

This document has been placed in the public domain.

#### 

> Local Variables: mode: indented-text indent-tabs-mode: nil
> sentence-end-double-space: t fill-column: 70 coding: utf-8 End:
