PEP: 20 Title: The Zen of Python Version: $Revision$ Last-Modified:
$Date$ Author: tim.peters\@gmail.com (Tim Peters) Status: Active Type:
Informational Content-Type: text/x-rst Created: 19-Aug-2004
Post-History: 22-Aug-2004

Abstract
========

Long time Pythoneer Tim Peters succinctly channels the BDFL's guiding
principles for Python's design into 20 aphorisms, only 19 of which have
been written down.

The Zen of Python
=================

::

    Beautiful is better than ugly.
    Explicit is better than implicit.
    Simple is better than complex.
    Complex is better than complicated.
    Flat is better than nested.
    Sparse is better than dense.
    Readability counts.
    Special cases aren't special enough to break the rules.
    Although practicality beats purity.
    Errors should never pass silently.
    Unless explicitly silenced.
    In the face of ambiguity, refuse the temptation to guess.
    There should be one-- and preferably only one --obvious way to do it.
    Although that way may not be obvious at first unless you're Dutch.
    Now is better than never.
    Although never is often better than *right* now.
    If the implementation is hard to explain, it's a bad idea.
    If the implementation is easy to explain, it may be a good idea.
    Namespaces are one honking great idea -- let's do more of those!

Easter Egg
==========

::

> > > import this

References
==========

-   Originally posted to comp.lang.python/python-list\@python.org under
    a thread called "The Way of Python"
    https://groups.google.com/d/msg/comp.lang.python/B\_VxeTBClM0/L8W9KlsiriUJ

Copyright
=========

This document has been placed in the public domain.

.. Local Variables: mode: indented-text indent-tabs-mode: nil
sentence-end-double-space: t fill-column: 70 End:
