PEP: 101 Title: Doing Python Releases 101 Version: $Revision$
Last-Modified: $Date$ Author: Barry Warsaw <barry@python.org>, Guido van
Rossum <guido@python.org> Status: Active Type: Informational
Content-Type: text/x-rst Created: 22-Aug-2001 Post-History: Replaces:
102

Abstract
========

Making a Python release is a thrilling and crazy process. You've heard
the expression "herding cats"? Imagine trying to also saddle those
purring little creatures up, and ride them into town, with some of their
buddies firmly attached to your bare back, anchored by newly sharpened
claws. At least they're cute, you remind yourself.

Actually, no that's a slight exaggeration <wink>. The Python release
process has steadily improved over the years and now, with the help of
our amazing community, is really not too difficult. This PEP attempts to
collect, in one place, all the steps needed to make a Python release. It
is organized as a recipe and you can actually print this out and check
items off as you complete them.

Things You'll Need
==================

As a release manager there are a lot of resources you'll need to access.
Here's a hopefully-complete list.

-   A GPG key.

    Python releases are digitally signed with GPG; you'll need a key,
    which hopefully will be on the "web of trust" with at least one of
    the other release managers.

-   A bunch of software:

    -   "release.py", the Python release manager's friend. It's in the
        python/release-tools repo on GitHub. It doesn't pip install or
        have any sort of install process--you'll have to put it on your
        path yourself, or just run it with a relative path, or whatever.

    -   "blurb", the Misc/NEWS management tool. The release process
        currently uses three blurb subcommands: release, merge, and
        export. Installable via pip3.

    -   "virtualenv". The release script installs Sphinx in a virtualenv
        when building the docs (for 2.7 and 3.5+).

    -   A fairly complete installation of a recent TeX distribution,
        such as texlive. You need that for building the PDF docs.

-   Access to `downloads.nyc1.psf.io`, the server that hosts download
    files, and `docs.nyc1.psf.io`, the server that hosts the
    documentation. You'll be uploading files directly here.

-   Administrator access to `https://github.com/python/cpython`.

-   An administrator account on www.python.org, including an "API key".

-   Write access to the PEP repository.

    If you're reading this, you probably already have this--the first
    task of any release manager is to draft the release schedule. But in
    case you just signed up... sucker! I mean, uh, congratulations!

-   Posting access to http://blog.python.org, a Blogger-hosted weblog.
    The RSS feed from this blog is used for the 'Python News' section on
    www.python.org.

-   A subscription to the super secret release manager mailing list,
    which may or may not be called `python-cabal`. Bug Barry about this.

Types of Releases
=================

There are several types of releases you will need to make. These
include:

-   `alpha`
-   `beta`
-   `release candidate 1`
-   `release candidate 2+`
-   `final`
-   `new branch`
-   `begin bugfix mode`
-   `begin security-only mode`
-   `end-of-life`

Some of these release types actually involve more than one release
branch. In particular, a **new branch** is that point in the release
cycle when a new feature release cycle begins. Under the current
organization of the cpython git repository, the *master* branch is
always the target for new features. At some point in the release cycle
of the next feature release, a **new branch** release is made which
creates a new separate branch for stabilization and later maintenance of
the current in-progress feature release (x.y.0) and the *master* branch
is modified to build a new version (which will eventually be released as
x.y+1.0). While the **new branch** release step could occur at one of
several points in the release cycle, current practice is for it to occur
at feature code cutoff for the release which is scheduled for the first
beta release.

In the descriptions that follow, steps specific to release types are
labeled accordingly, for now, **new branch** and **final**.

How to Make A Release
=====================

Here are the steps taken to make a Python release. Some steps are more
fuzzy than others because there's little that can be automated (e.g.
writing the NEWS entries). Where a step is usually performed by An
Expert, the role of that expert is given. Otherwise, assume the step is
done by the Release Manager (RM), the designated person performing the
release. The roles and their current experts are:

-   RM = Release Manager

    -   Łukasz Langa <lukasz@python.org> (Central Europe)
    -   Ned Deily <nad@python.org> (US)
    -   Larry Hastings <larry@hastings.org> (US)
    -   Benjamin Peterson <benjamin@python.org> (US)

-   WE = Windows - Steve Dower <steve.dower@python.org>
-   ME = Mac - Ned Deily <nad@python.org> (US)
-   DE = Docs - Julien Palard <julien@python.org> (Central Europe)
-   IE = Idle Expert - Terry Reedy <tjreedy@udel.edu> (US)

    .. note:: It is highly recommended that the RM contact the Experts
    the day before the release. Because the world is round and everyone
    lives in different timezones, the RM must ensure that the release
    tag is created in enough time for the Experts to cut binary
    releases.

         You should not make the release public (by updating the website and
         sending announcements) before all experts have updated their bits.
         In rare cases where the expert for Windows or Mac is MIA, you may add
         a message "(Platform) binaries will be provided shortly" and proceed.

XXX: We should include a dependency graph to illustrate the steps that
can be taken in parallel, or those that depend on other steps.

As much as possible, the release steps are automated and guided by the
release script, which is available in a separate repository:

    https://github.com/python/release-tools

We use the following conventions in the examples below. Where a release
number is given, it is of the form `X.Y.ZaN`, e.g. 3.3.0a3 for Python
3.3.0 alpha 3, where "a" == alpha, "b" == beta, "rc" == release
candidate.

Release tags are named `vX.Y.ZaN`. The branch name for minor release
maintenance branches is `X.Y`.

This helps by performing several automatic editing steps, and guides you
to perform some manual editing steps.

-   Log into irc.freenode.net and join the \#python-dev channel.

    You probably need to coordinate with other people around the world.
    This IRC channel is where we've arranged to meet.

-   Check to see if there are any showstopper bugs.

    Go to https://bugs.python.org and look for any open bugs that can
    block this release. You're looking at the Priority of the open bugs
    for the release you're making; here are the relevant definitions:

    release blocker Stops the release dead in its tracks. You may not
    make any release with any open release blocker bugs.

    deferred blocker Doesn't block this release, but it will block a
    future release. You may not make a final or candidate release with
    any open deferred blocker bugs.

    critical Important bugs that should be fixed, but which does not
    block a release.

    Review the release blockers and either resolve them, bump them down
    to deferred, or stop the release and ask for community assistance.
    If you're making a final or candidate release, do the same with any
    open deferred.

-   Check the stable buildbots.

    Go to https://buildbot.python.org/all/\#/release\_status

    Look at the buildbots for the release you're making. Ignore any that
    are offline (or inform the community so they can be restarted). If
    what remains are (mostly) green buildbots, you're good to go. If you
    have non-offline red buildbots, you may want to hold up the release
    until they are fixed. Review the problems and use your judgement,
    taking into account whether you are making an alpha, beta, or final
    release.

-   Make a release clone.

    On a fork of the cpython repository on GitHub, create a release
    branch within it (called the "release clone" from now on). You can
    use the same GitHub fork you use for cpython development. Using the
    standard setup recommended in the Python Developer's Guide, your
    fork would be referred to as `origin` and the standard cpython repo
    as `upstream`. You will use the branch on your fork to do the
    release engineering work, including tagging the release, and you
    will use it to share with the other experts for making the binaries.

    For a **final** or **release candidate 2+** release, if you are
    going to cherry-pick a subset of changes for the next rc or final
    from all those merged since the last rc, you should create a release
    engineering branch starting from the most recent release candidate
    tag, i.e. `v3.8.0rc1`. You will then cherry-pick changes from the
    standard release branch as necessary into the release engineering
    branch and then proceed as usual. If you are going to take all of
    the changes since the previous rc, you can proceed as normal.

-   Notify all committers by sending email to
    python-committers\@python.org.

    Since we're now working with a distributed version control system,
    there is no need to stop everyone from pushing to the main repo;
    you'll just work in your own clone. Therefore, there won't be any
    checkin freezes.

    However, all committers should know the point at which your release
    clone was made, as later commits won't make it into the release
    without extra effort.

-   Make sure the current branch of your release clone is the branch you
    want to release from. (`git status`)

-   Run `blurb release <version>` specifying the version number
    (e.g. `blurb release 3.4.7rc1`). This merges all the recent news
    blurbs into a single file marked with this release's version number.

-   Check the docs for markup errors.

    cd to the Doc directory and run `make suspicious`. If any markup
    errors are found, fix them.

-   Regenerate Lib/pydoc-topics.py.

    While still in the Doc directory, run `make pydoc-topics`. Then copy
    `build/pydoc-topics/topics.py` to `../Lib/pydoc_data/topics.py`.

-   Commit your changes to `pydoc_topics.py` (and any fixes you made in
    the docs).

-   Consider running `autoconf` using the currently accepted standard
    version in case `configure` or other autoconf-generated files were
    last committed with a newer or older version and may contain
    spurious or harmful differences. Currently, autoconf 2.69 is our
    de-facto standard. if there are differences, commit them.

-   Make sure the `SOURCE_URI` in `Doc/tools/extensions/pyspecific.py`
    points to the right branch in the git repository (`master` or
    `X.Y`). For a **new branch** release, change the branch in the file
    from *master* to the new release branch you are about to create
    (`X.Y`).

-   Bump version numbers via the release script::

        $ .../release-tools/release.py --bump X.Y.ZaN

    Reminder: X, Y, Z, and N should be integers. a should be one of "a",
    "b", or "rc" (e.g. "3.4.3rc1"). For **final** releases omit the aN
    ("3.4.3"). For the first release of a new version Z should be 0
    ("3.6.0").

    This automates updating various release numbers, but you will have
    to modify a few files manually. If your \$EDITOR environment
    variable is set up correctly, release.py will pop up editor windows
    with the files you need to edit.

    Review the blurb-generated Misc/NEWS file and edit as necessary.

-   Make sure all changes have been committed. (`release.py --bump`
    doesn't check in its changes for you.)

-   Check the years on the copyright notice. If the last release was
    some time last year, add the current year to the copyright notice in
    several places:

    -   README
    -   LICENSE (make sure to change on trunk and the branch)
    -   Python/getcopyright.c
    -   Doc/copyright.rst
    -   Doc/license.rst
    -   PC/python\_ver\_rc.h sets up the DLL version resource for
        Windows (displayed when you right-click on the DLL and select
        Properties). This isn't a C include file, it's a Windows
        "resource file" include file.

-   Check with the IE (if there is one <wink>) to be sure that
    Lib/idlelib/NEWS.txt has been similarly updated.

-   For a **final** major release, edit the first paragraph of
    Doc/whatsnew/X.Y.rst to include the actual release date;
    e.g. "Python 2.5 was released on August 1, 2003." There's no need to
    edit this for alpha or beta releases.

-   Do a "git status" in this directory.

    You should not see any files. I.e. you better not have any
    uncommitted changes in your working directory.

-   Tag the release for X.Y.ZaN::

        $ .../release-tools/release.py --tag X.Y.ZaN

    This executes a `git tag` command with the `-s` option so that the
    release tag in the repo is signed with your gpg key. When prompted
    choose the private key you use for signing release tarballs etc.

-   For a **new branch** release, `Doc/tools/static/switchers.js` must
    be updated in all maintained branches, so that the new maintenance
    branch is now `pre` (for `pre-release`) and add the new "dev"
    version. Also, update `Doc/tools/templates/indexsidebar.html` to
    increment the version number of the `in development` version and add
    an entry under it for the new release branch with `pre-release`
    status. Review the remaining branch entires and consider removing
    the oldest `security-fixes` branch. Also, similar changes must be
    made and committed to these files in all of the other active
    branches. Or ask the DE to do this.

-   For a **final** major release, `Doc/tools/static/switchers.js` and
    `Doc/tools/templates/indexsidebar.html` must be updated in all
    maintained branches, changing the release branch from `pre-release`
    to `stable`.

-   For **begin security-only mode** and **end-of-life** releases,
    review the two files and update the versions accordingly in all
    active branches.

-   Time to build the source tarball. Use the release script to create
    the source gzip and xz tarballs, documentation tar and zip files,
    and gpg signature files::

        $ .../release-tools/release.py --export X.Y.ZaN

    This can take a while for **final** releases, and it will leave all
    the tarballs and signatures in a subdirectory called `X.Y.ZaN/src`,
    and the built docs in `X.Y.ZaN/docs` (for **final** releases).

-   Now you want to perform the very important step of checking the
    tarball you just created, to make sure a completely clean, virgin
    build passes the regression test. Here are the best steps to take::

    \$ cd /tmp \$ tar xvf
    /path/to/your/release/clone/<version>//Python-3.2rc2.tgz \$ cd
    Python-3.2rc2 \$ ls (Do things look reasonable?) \$ ls Lib (Are
    there stray .pyc files?) \$ ./configure (Loads of configure output)
    \$ make test (Do all the expected tests pass?)

    If you're feeling lucky and have some time to kill, or if you are
    making a release candidate or **final** release, run the full test
    suite::

        $ make testall

    If the tests pass, then you can feel good that the tarball is fine.
    If some of the tests fail, or anything else about the freshly
    unpacked directory looks weird, you better stop now and figure out
    what the problem is.

-   Push your commits to the remote release branch in your GitHub
    fork.::

    \# Do a dry run first. \$ git push --dry-run --tags origin \# Make
    sure you are pushing to your GitHub fork, *not* to the main \#
    python/cpython repo! \$ git push --tags origin

-   Notify the experts that they can start building binaries.

-   STOP STOP STOP STOP STOP STOP STOP STOP

    At this point you must receive the "green light" from other experts
    in order to create the release. There are things you can do while
    you wait though, so keep reading until you hit the next STOP.

-   The WE builds the Windows helpfile, using (in Doc/)::

        % make.bat htmlhelp   (on Windows)

    to create suitable input for HTML Help Workshop in build/htmlhelp.
    HTML Help Workshop is then fired up on the created python33.hhp
    file, finally resulting in an python33.chm file.

-   The WE then generates Windows installer files for each Windows
    target architecture (for Python 3.3, this means x86 and AMD64).

    -   The WE has one checkout tree per target architecture, and builds
        the pcbuild.sln project for the appropriate architecture.

    -   PC\icons.mak must have been run with nmake.

    -   The cmd.exe window in which this is run must have Cygwin/bin in
        its path (at least for x86).

    -   The cmd.exe window must have MS compiler tools for the target
        architecture in its path (VS 2010 for Python 3.3).

    -   The WE then edits Tools/msi/config.py (a file only present
        locally) to update full\_current\_version and sets snapshot to
        false. Currently for a release config.py looks like::

        snapshot=0 full\_current\_version="3.3.5rc2" certname=\"Python
        Software Foundation PCBUILD='PCbuild\\amd64'

        The last line is only present for the amd64 checkout.

    -   Now the WE runs msi.py with ActivePython or Python with pywin32.

    The WE checksums the files (`*.msi`, `*.chm`, `*-pdb.zip`), uploads
    them to downloads.nyc1.psf.io together with gpg signature files, and
    emails you the location and md5sums.

-   The ME builds Mac installer packages and uploads them to
    downloads.nyc1.psf.io together with gpg signature files.

-   scp or rsync all the files built by `release.py --export` to your
    home directory on downloads.nyc1.psf.io.

    While you're waiting for the files to finish uploading, you can
    continue on with the remaining tasks. You can also ask folks on
    \#python-dev and/or python-committers to download the files as they
    finish uploading so that they can test them on their platforms as
    well.

-   Now you need to go to downloads.nyc1.psf.io and move all the files
    in place over there. Our policy is that every Python version gets
    its own directory, but each directory contains all releases of that
    version.

    -   On downloads.nyc1.psf.io, cd
        /srv/www.python.org/ftp/python/X.Y.Z creating it if necessary.
        Make sure it is owned by group 'downloads' and group-writable.

    -   Move the release .tgz, and .tar.xz files into place, as well as
        the .asc GPG signature files. The Win/Mac binaries are usually
        put there by the experts themselves.

        Make sure they are world readable. They should also be group
        writable, and group-owned by downloads.

    -   Use `gpg --verify` to make sure they got uploaded intact.

    -   If this is a **final** or rc release: Move the doc zips and
        tarballs to `/srv/www.python.org/ftp/python/doc/X.Y.Z[rcA]`,
        creating the directory if necessary, and adapt the "current"
        symlink in `.../doc` to point to that directory. Note though
        that if you're releasing a maintenance release for an older
        version, don't change the current link.

    -   If this is a **final** or rc release (even a maintenance
        release), also unpack the HTML docs to
        `/srv/docs.python.org/release/X.Y.Z[rcA]` on docs.nyc1.psf.io.
        Make sure the files are in group `docs` and are group-writeable.
        If it is a release of a security-fix-only version, tell the DE
        to build a version with the "version switcher" and put it there.

    -   Let the DE check if the docs are built and work all right.

    -   If this is a **final** major release: Tell the DE to adapt
        redirects for docs.python.org/X.Y in the nginx config for
        docs.python.org, update the
        `docsbuild-scripts <https://github.com/python/docsbuild-scripts>`\_
        to point to the right stable/development branches, and to
        install it and make the initial checkout. The Doc's
        `version_switcher.js` script also needs to be updated. In
        general, please don't touch things in the toplevel
        `/srv/docs.python.org/` directory unless you know what you're
        doing.

    -   Note both the documentation and downloads are behind a caching
        CDN. If you change archives after downloading them through the
        website, you'll need to purge the stale data in the CDN like
        this::

            $ curl -X PURGE https://www.python.org/ftp/python/2.7.5/Python-2.7.5.tar.xz

        You should always purge the cache of the directory listing as
        people use that to browse the release files::

            $ curl -X PURGE https://www.python.org/ftp/python/2.7.5/

-   For the extra paranoid, do a completely clean test of the release.
    This includes downloading the tarball from www.python.org.

    Make sure the md5 checksums match. Then unpack the tarball, and do a
    clean make test.::

    \$ make distclean \$ ./configure \$ make test

    To ensure that the regression test suite passes. If not, you screwed
    up somewhere!

-   STOP STOP STOP STOP STOP STOP STOP STOP

    -   Have you gotten the green light from the WE?

    -   Have you gotten the green light from the ME?

    -   Have you gotten the green light from the DE?

If green, it's time to merge the release engineering branch back into
the main repo.

-   In order to push your changes to Github, you'll have to temporarily
    disable branch protection for administrators. Go to the
    `Settings | Branches` page:

    https://github.com/python/cpython/settings/branches/

    "Edit" the settings for the branch you're releasing on. This will
    load the settings page for that branch. Uncheck the "Include
    administrators" box and press the "Save changes" button at the
    bottom.

-   Merge your release clone into the main development repo::

    \# Pristine copy of the upstream repo branch \$ git clone
    git\@github.com:python/cpython.git merge \$ cd merge

    \# Checkout the correct branch: \# 1. For feature pre-releases up to
    and including a \# **new branch** release, i.e. alphas and first
    beta \# do a checkout of the master branch \$ git checkout master

    \# 2. Else, for all other releases, checkout the \# appropriate
    release branch. \$ git checkout X.Y

    \# Fetch the newly created and signed tag from your clone repo \$
    git fetch --tags git\@github.com:your-github-id/cpython.git vX.Y.ZaN
    \# Merge the temporary release engineering branch back into \$ git
    merge --no-squash vX.Y.ZaN \$ git commit -m 'Merge release
    engineering branch'

-   If this is a **new branch** release, i.e. first beta, now create the
    new release branch::

    \$ git checkout -b X.Y

    Do any steps needed to setup the new release branch, including:

          * In README.rst, change all references from ``master`` to
            the new branch, in particular, GitHub repo URLs.

-   For *all* releases, do the guided post-release steps with the
    release script.::

    \$ .../release-tools/release.py --done X.Y.ZaN

-   For a **final** or **release candidate 2+** release, you may need to
    do some post-merge cleanup. Check the top-level `README.rst` and
    `include/patchlevel.h` files to ensure they now reflect the desired
    post-release values for on-going development. The patchlevel should
    be the release tag with a `+`. Also, if you cherry-picked changes
    from the standard release branch into the release engineering branch
    for this release, you will now need to manual remove each blurb
    entry from the `Misc/NEWS.d/next` directory that was cherry-picked
    into the release you are working on since that blurb entry is now
    captured in the merged x.y.z.rst fils for the new release.
    Otherwise, the blurb entry will appear twice in the `changelog.html`
    file, once under `Python next` and again under `x.y.z`.

-   Review and commit these changes::

    \$ git commit -m 'Post release updates'

-   If this is a **new branch** release (e.g. the first beta), update
    the master branch to start development for the following feature
    release. When finished, the `master` branch will now build Python
    `X.Y+1`.

    -   First, set master up to be the next release, i.e.X.Y+1.a0::

        \$ git checkout master \$ .../release-tools/release.py --bump
        3.9.0a0

    -   Edit all version references in README.rst

    -   Move any historical "what's new" entries from `Misc/NEWS` to
        `Misc/HISTORY`.

    -   Edit `Doc/tutorial/interpreter.rst` (2 references to
        '\[Pp\]ython3x', one to 'Python 3.x', also make the date in the
        banner consistent).

    -   Edit `Doc/tutorial/stdlib.rst` and `Doc/tutorial/stdlib2.rst`,
        which have each one reference to '\[Pp\]ython3x'.

    -   Add a new `whatsnew/3.x.rst` file (with the comment near the top
        and the toplevel sections copied from the previous file) and add
        it to the toctree in `whatsnew/index.rst`. But beware that the
        initial `whatsnew/3.x.rst` checkin from previous releases may be
        incorrect due to the initial midstream change to `blurb` that
        propagates from release to release! Help break the cycle: if
        necessary make the following change::

            - For full details, see the :source:`Misc/NEWS` file.
            + For full details, see the :ref:`changelog <changelog>`.

    -   Update the version number in `configure.ac` and re-run
        `autoconf`.

    -   Make sure the `SOURCE_URI` in
        `Doc/tools/extensions/pyspecific.py` points to `master`.

    -   Update the version numbers for the Windows builds in PC/ and
        PCbuild/, which have references to python38. NOTE, check with
        Steve Dower about this step, it is probably obsolete.::

            $ find PC/ PCbuild/ -type f | xargs sed -i 's/python38/python39/g'
            $ git mv -f PC/os2emx/python38.def PC/os2emx/python39.def
            $ git mv -f PC/python38stub.def PC/python39stub.def
            $ git mv -f PC/python38gen.py PC/python39gen.py

    -   Commit these changes to the master branch::

            $ git status
            $ git add ...
            $ git commit -m 'Bump to 3.9.0a0'

-   Do another `git status` in this directory.

    You should not see any files. I.e. you better not have any
    uncommitted changes in your working directory.

-   Commit and push to the main repo.::

    \# Do a dry run first.

    \# For feature pre-releases prior to a **new branch** release, \#
    i.e. a feature alpha release: \$ git push --dry-run --tags
    git\@github.com:python/cpython.git master \# If it looks OK, take
    the plunge. There's no going back! \$ git push --tags
    git\@github.com:python/cpython.git master

    \# For a **new branch** release, i.e. first beta: \$ git push
    --dry-run --tags git\@github.com:python/cpython.git X.Y \$ git push
    --dry-run --tags git\@github.com:python/cpython.git master \# If it
    looks OK, take the plunge. There's no going back! \$ git push --tags
    git\@github.com:python/cpython.git X.Y \$ git push --tags
    git\@github.com:python/cpython.git master

    \# For all other releases: \$ git push --dry-run --tags
    git\@github.com:python/cpython.git X.Y \# If it looks OK, take the
    plunge. There's no going back! \$ git push --tags
    git\@github.com:python/cpython.git X.Y

-   If this is a **new branch** release, add a `Branch protection rule`
    for the newly created branch (X.Y). Look at the values for the
    previous release branch (X.Y-1) and use them as a template.
    https://github.com/python/cpython/settings/branches/

    Also, add a `needs backport to X.Y` label to the Github repo.
    https://github.com/python/cpython/labels

-   You can now re-enable enforcement of branch settings against
    administrators on Github. Go back to the `Settings | Branch` page:

    https://github.com/python/cpython/settings/branches/

    "Edit" the settings for the branch you're releasing on. Re-check the
    "Include administrators" box and press the "Save changes" button at
    the bottom.

Now it's time to twiddle the web site. Almost none of this is automated,
sorry.

To do these steps, you must have the permission to edit the website. If
you don't have that, ask someone on pydotorg\@python.org for the proper
permissions. (Or ask Ewa, who coordinated the effort for the new website
with RevSys.)

-   Log in to https://www.python.org/admin .

-   Create a new "release" for the release. Currently "Releases" are
    sorted under "Downloads".

    The easiest thing is probably to copy fields from an existing Python
    release "page", editing as you go.

    You can use
    `Markdown <https://daringfireball.net/projects/markdown/syntax>`\_
    or
    `ReStructured Text <http://docutils.sourceforge.net/docs/user/rst/quickref.html>`\_
    to describe your release. The former is less verbose, while the
    latter has nifty integration for things like referencing PEPs.

    Leave the "Release page" field on the form empty.

-   "Save" the release.

-   Populate the release with the downloadable files.

    Your friend and mine, Georg Brandl, made a lovely tool called
    "add-to-pydotorg.py". You can find it in the "release" tree (next to
    "release.py"). You run the tool on downloads.nyc1.psf.io, like
    this::

        $ AUTH_INFO=<username>:<python.org-api-key> python add-to-pydotorg.py <version>

    This walks the correct download directory for <version>, looks for
    files marked with <version>, and populates the "Release Files" for
    the correct "release" on the web site with these files. Note that
    clears the "Release Files" for the relevant version each time it's
    run. You may run it from any directory you like, and you can run it
    as many times as you like if the files happen to change. Keep a copy
    in your home directory on dl-files and keep it fresh.

    If new types of files are added to the release (e.g. the web-based
    installers or redistributable zip files added to Python 3.5) someone
    will need to update add-to-pydotorg.py so it recognizes these new
    files. (It's best to update add-to-pydotorg.py when file types are
    removed, too.)

-   If this is a **final** release:

    -   Add the new version to the *Python Documentation by Version*
        page `https://www.python.org/doc/versions/` and remove the
        current version from any 'in development' section.

    -   For X.Y.Z, edit all the previous X.Y releases' page(s) to point
        to the new release. This includes the content field of the
        `Downloads -> Releases` entry for the release::

        Note: Python x.y.m has been superseded by
        `Python x.y.n </downloads/release/python-xyn/>`\_.

        And, for those releases having separate release page entries
        (phasing these out?), update those pages as well,
        e.g. `download/releases/x.y.z`::

        Note: Python x.y.m has been superseded by
        `Python x.y.n </download/releases/x.y.n/>`\_.

    -   Update the "Current Pre-release Testing Versions web page".

        There's a page that lists all the currently-in-testing versions
        of Python:

            https://www.python.org/download/pre-releases/

        Every time you make a release, one way or another you'll have to
        update this page:

        -   If you're releasing a version before *x.y.0*, or *x.y.z
            release candidate N,* you should add it to this page,
            removing the previous pre-release of version *x.y* as
            needed.

        -   If you're releasing *x.y.z final*, you need to remove the
            pre-release version from this page.

        This is in the "Pages" category on the Django-based website, and
        finding it through that UI is kind of a chore. However! If
        you're already logged in to the admin interface (which, at this
        point, you should be), Django will helpfully add a convenient
        "Edit this page" link to the top of the page itself. So you can
        simply follow the link above, click on the "Edit this page"
        link, and make your changes as needed. How convenient!

    -   If appropriate, update the "Python Documentation by Version"
        page:

        https://www.python.org/doc/versions/

        This lists all releases of Python by version number and links to
        their static (not built daily) online documentation. There's a
        list at the bottom of in-development versions, which is where
        all alphas/betas/RCs should go. And yes you should be able to
        click on the link above then press the shiny, exciting "Edit
        this page" button.

    -   Other steps (other update for new web site)??

-   Write the announcement for the mailing lists. This is the fuzzy bit
    because not much can be automated. You can use an earlier
    announcement as a template, but edit it for content!

-   Once the announcement is ready, send it to the following addresses:

    python-list\@python.org python-announce\@python.org
    python-dev\@python.org

-   Also post the announcement to
    `The Python Insider blog <http://blog.python.org>`*. To add a new
    entry, go to
    `your Blogger home page, here. <https://www.blogger.com/home>`*

-   Send email to python-committers informing them that the release has
    been published and a reminder about any relevant changes in policy
    based on the phase of the release cycle. In particular, if this is a
    **new branch** release, remind everyone that the new release branch
    exists and that they need to start considering whether to backport
    to it when merging changes to master.

-   Update any release PEPs (e.g. 361) with the release dates.

-   Update the tracker at https://bugs.python.org:

    -   Flip all the deferred blocker issues back to release blocker for
        the next release.

    -   Add version X.Y+1 as when version X.Y enters alpha.

    -   Change non-doc RFEs to version X.Y+1 when version X.Y enters
        beta.

    -   Add `X.Yregression` keyword (https://bugs.python.org/keyword)
        when version X.Y enters beta.

    -   Update 'behavior' issues from versions that your release make
        unsupported to the next supported version.

    -   Review open issues, as this might find lurking showstopper bugs,
        besides reminding people to fix the easy ones they forgot about.

-   You can delete the remote release clone branch from your repo clone.

-   If this is a **new branch** release, you will need to ensure various
    pieces of the development infrastructure are updated for the new
    branch. These include:

    -   Update the issue tracker for the new branch.

        -   Add the new version to the versions list (contact the
            tracker admins?).

        -   Add a
            `regressions keyword <https://bugs.python.org/keyword>`\_
            for the release

    -   Update the devguide to reflect the new branches and versions.

    -   Create a PR to update the supported releases table on the
        `downloads page <https://www.python.org/downloads/>`\_. (See
        https://github.com/python/pythondotorg/issues/1302)

    -   Ensure buildbots are defined for the new branch (contact zware).

    -   Ensure the daily docs build scripts are updated to include the
        new branch (contact DE).

    -   Ensure the various Github bots are updated, as needed, for the
        new branch, in particular, make sure backporting to the new
        branch works (contact core-workflow team)
        https://github.com/python/core-workflow/issues

    -   Review the most recent commit history for the master and new
        release branches to identify and backport any merges that might
        have been made to the master branch during the release
        engineering phase and that should be in the release branch.

    -   Verify that CI is working for new PRs for the master and new
        release branches and that the release branch is properly
        protected (no direct pushes, etc).

    -   Verify that the on-line docs are building properly (this may
        take up to 24 hours for a complete build on the web site).

What Next?
==========

-   Verify! Pretend you're a user: download the files from python.org,
    and make Python from it. This step is too easy to overlook, and on
    several occasions we've had useless release files. Once a general
    server problem caused mysterious corruption of all files; once the
    source tarball got built incorrectly; more than once the file upload
    process on SF truncated files; and so on.

-   Rejoice. Drink. Be Merry. Write a PEP like this one. Or be like unto
    Guido and take A Vacation.

You've just made a Python release!

Moving to End-of-life
=====================

Under current policy, a release branch normally reaches end-of-life
status 5 years after its initial release. The policy is discussed in
more detail in
`the Python Developer's Guide <https://devguide.python.org/devcycle/>`\_.
When end-of-life is reached, there are a number of tasks that need to be
performed either directly by you as release manager or by ensuring
someone else does them. Some of those tasks include:

-   Optionally making a final release to publish any remaining
    unreleased changes.

-   Check the
    `docsbuild server script <https://github.com/python/docsbuild-scripts/blob/master/build_docs.py>`\_
    to ensure that the docs set for the branch is no longer being built.
    If still present, ask the DE to remove this branch from the BRANCHES
    list.

-   On the docs download server (docs.nyc1.psf.io), ensure the top-level
    symlink points to the upload of unpacked html docs from final
    release::

          cd /srv/docs.python.org
          ls -l 3.3
          lrwxrwxrwx 1 nad docs 13 Sep  6 21:38 3.3 -> release/3.3.7

-   In each unretired cpython branch, remove any remaining references to
    the retired branch in the Doc version switcher and side bar
    templates (file names may vary between branches) \[DE\]::

          Doc/tools/static/version_switch.js
          Doc/tools/templates/indexsidebar.html

-   Freeze the state of the release branch by creating a tag of its
    current HEAD and then deleting the branch from the cpython repo. The
    current HEAD should be at or beyond the final security release for
    the branch::

          git fetch upstream
          git tag --sign -m 'Final head of the former 3.3 branch' 3.3 upstream/3.3
          git push upstream refs/tags/3.3

-   If all looks good, delete the branch. This may require the
    assistance of someone with repo administrator privileges::

          git push upstream --delete 3.3  # or perform from Github Settings page

-   Add retired notice to each release page on python.org for the
    retired branch. For example:

        https://www.python.org/downloads/release/python-337/

        https://www.python.org/downloads/release/python-336/

-   In the developer's guide, add the branch to the recent end-of-life
    branches list
    (https://devguide.python.org/devcycle/\#end-of-life-branches) and
    update or remove references to the branch elsewhere in the devguide.

-   If necessary, create a PR to update the supported releases table on
    the `downloads page <https://www.python.org/downloads/>`\_. (See
    https://github.com/python/pythondotorg/issues/1302)

-   Retire the release from the bugs.python.org issue tracker. Tasks
    include:

    -   remove branch from tracker list of versions

    -   remove any release-release keywords (3.3regressions)

    -   review and dispose of open issues marked for this branch

    Note, with the likely future migration of bug tracking from the
    current Roundup bugs.python.org to Github issues and with the
    impending end-of-life of Python 2.7, it probably makes sense to
    avoid unnecessary churn for currently and about-to-be retired 3.x
    branches by deferring any major wholesale changes to existing issues
    until the migration process is clarified.

-   Announce the branch retirement in the usual places:

    -   mailing lists (python-committers, python-dev, python-list,
        python-announcements)

    -   discuss.python.org and Zulip

    -   Python Dev blog

-   Enjoy your retirement and bask in the glow of a job well done!

Windows Notes
=============

NOTE, have Steve Dower review; probably obsolete.

Windows has a MSI installer, various flavors of Windows have "special
limitations", and the Windows installer also packs precompiled "foreign"
binaries (Tcl/Tk, expat, etc). So Windows testing is tiresome but very
necessary.

Concurrent with uploading the installer, the WE installs Python from it
twice: once into the default directory suggested by the installer, and
later into a directory with embedded spaces in its name. For each
installation, the WE runs the full regression suite from a DOS box, and
both with and without -0. For maintenance release, the WE also tests
whether upgrade installations succeed.

The WE also tries *every* shortcut created under Start -\> Menu -\> the
Python group. When trying IDLE this way, you need to verify that Help
-\> Python Documentation works. When trying pydoc this way (the "Module
Docs" Start menu entry), make sure the "Start Browser" button works, and
make sure you can search for a random module (like "random" <wink>) and
then that the "go to selected" button works.

It's amazing how much can go wrong here -- and even more amazing how
often last-second checkins break one of these things. If you're "the
Windows geek", keep in mind that you're likely the only person routinely
testing on Windows, and that Windows is simply a mess.

Repeat the testing for each target architecture. Try both an Admin and a
plain User (not Power User) account.

Copyright
=========

This document has been placed in the public domain.

.. Local Variables: mode: indented-text indent-tabs-mode: nil End:
