PEP: 223 Title: Change the Meaning of `\x` Escapes Version: $Revision$
Last-Modified: $Date$ Author: tim.peters\@gmail.com (Tim Peters) Status:
Final Type: Standards Track Content-Type: text/x-rst Created:
20-Aug-2000 Python-Version: 2.0 Post-History: 23-Aug-2000

Abstract
========

Change `\x` escapes, in both 8-bit and Unicode strings, to consume
exactly the two hex digits following. The proposal views this as
correcting an original design flaw, leading to clearer expression in all
flavors of string, a cleaner Unicode story, better compatibility with
Perl regular expressions, and with minimal risk to existing code.

Syntax
======

The syntax of `\x` escapes, in all flavors of non-raw strings, becomes
::

\xhh

where h is a hex digit (0-9, a-f, A-F). The exact syntax in 1.5.2 is not
clearly specified in the Reference Manual; it says ::

\xhh...

implying "two or more" hex digits, but one-digit forms are also accepted
by the 1.5.2 compiler, and a plain `\x` is "expanded" to itself (i.e., a
backslash followed by the letter x). It's unclear whether the Reference
Manual intended either of the 1-digit or 0-digit behaviors.

Semantics
=========

In an 8-bit non-raw string, ::

\xij

expands to the character ::

chr(int(ij, 16))

Note that this is the same as in 1.6 and before.

In a Unicode string, ::

\xij

acts the same as ::

\u00ij
