PEP: 241 Title: Metadata for Python Software Packages Version:
$Revision$ Last-Modified: $Date$ Author: A.M. Kuchling <amk@amk.ca>
Status: Final Type: Standards Track Content-Type: text/x-rst Created:
12-Mar-2001 Post-History: 19-Mar-2001

Introduction
============

This PEP describes a mechanism for adding metadata to Python packages.
It includes specifics of the field names, and their semantics and usage.

Including Metadata in Packages
==============================

The Distutils 'sdist' command will be modified to extract the metadata
fields from the arguments and write them to a file in the generated
zipfile or tarball. This file will be named PKG-INFO and will be placed
in the top directory of the source distribution (where the README,
INSTALL, and other files usually go).

Developers may not provide their own PKG-INFO file. The "sdist" command
will, if it detects an existing PKG-INFO file, terminate with an
appropriate error message. This should prevent confusion caused by the
PKG-INFO and setup.py files being out of sync.

The PKG-INFO file format is a single set of RFC-822 headers parseable by
the rfc822.py module. The field names listed in the following section
are used as the header names. There's no extension mechanism in this
simple format; the Catalog and Distutils SIGs will aim at getting a more
flexible format ready for Python 2.2.

Fields
======

This section specifies the names and semantics of each of the supported
metadata fields.

Fields marked with "(Multiple use)" may be specified multiple times in a
single PKG-INFO file. Other fields may only occur once in a PKG-INFO
file. Fields marked with "(optional)" are not required to appear in a
valid PKG-INFO file, all other fields must be present.

Metadata-Version
----------------

Version of the file format; currently "1.0" is the only legal value
here.

Example::

    Metadata-Version: 1.0

Name
----

The name of the package.

Example::

    Name: BeagleVote

Version
-------

A string containing the package's version number. This field should be
parseable by one of the Version classes (StrictVersion or LooseVersion)
in the distutils.version module.

Example::

    Version: 1.0a2

Platform (multiple use)
-----------------------

A comma-separated list of platform specifications, summarizing the
operating systems supported by the package. The major supported
platforms are listed below, but this list is necessarily incomplete.

::

    POSIX, MacOS, Windows, BeOS, PalmOS.

Binary distributions will use the Supported-Platform field in their
metadata to specify the OS and CPU for which the binary package was
compiled. The semantics of the Supported-Platform are not specified in
this PEP.

Example::

    Platform: POSIX, Windows

Summary
-------

A one-line summary of what the package does.

Example::

    Summary: A module for collecting votes from beagles.

Description (optional)
----------------------

A longer description of the package that can run to several paragraphs.
(Software that deals with metadata should not assume any maximum size
for this field, though one hopes that people won't include their
instruction manual as the long-description.)

Example::

    Description: This module collects votes from beagles
                 in order to determine their electoral wishes.
                 Do NOT try to use this module with basset hounds;
                 it makes them grumpy.

Keywords (optional)
-------------------

A list of additional keywords to be used to assist searching for the
package in a larger catalog.

Example::

    Keywords: dog puppy voting election

Home-page (optional)
--------------------

A string containing the URL for the package's home page.

Example::

    Home-page: http://www.example.com/~cschultz/bvote/

Author (optional)
-----------------

A string containing at a minimum the author's name. Contact information
can also be added, separating each line with newlines.

Example::

    Author: C. Schultz
            Universal Features Syndicate
            Los Angeles, CA

Author-email
------------

A string containing the author's e-mail address. It can contain a name
and e-mail address in the legal forms for a RFC-822 'From:' header. It's
not optional because cataloging systems can use the e-mail portion of
this field as a unique key representing the author. A catalog might
provide authors the ability to store their GPG key, personal home page,
and other additional metadata *about the author*, and optionally the
ability to associate several e-mail addresses with the same person.
Author-related metadata fields are not covered by this PEP.

Example::

    Author-email: "C. Schultz" <cschultz@example.com>

License
-------

A string selected from a short list of choices, specifying the license
covering the package. Some licenses result in the software being freely
redistributable, so packagers and resellers can automatically know that
they're free to redistribute the software. Other licenses will require a
careful reading by a human to determine how the software can be
repackaged and resold.

The choices are::

    Artistic, BSD, DFSG, GNU GPL, GNU LGPL, "MIT",
    Mozilla PL, "public domain", Python, Qt PL, Zope PL, unknown,
    nocommercial, nosell, nosource, shareware, other

Definitions of some of the licenses are:

============= =================================================== DFSG
The license conforms to the Debian Free Software Guidelines, but does
not use one of the other DFSG conforming licenses listed here. More
information is available at:
http://www.debian.org/social\_contract\#guidelines

Python Python 1.6 or higher license. Version 1.5.2 and earlier are under
the MIT license.

public domain Software is public domain, not copyrighted.

unknown Status is not known

nocommercial Free private use but commercial use not permitted

nosell Free use but distribution for profit by arrangement

nosource Freely distributable but no source code

shareware Payment is requested if software is used

other General category for other non-DFSG licenses =============
===================================================

Some of these licenses can be interpreted to mean the software is freely
redistributable. The list of redistributable licenses is::

    Artistic, BSD, DFSG, GNU GPL, GNU LGPL, "MIT",
    Mozilla PL, "public domain", Python, Qt PL, Zope PL,
    nosource, shareware

Note that being redistributable does not mean a package qualifies as
free software, 'nosource' and 'shareware' being examples.

Example::

    License: MIT

Acknowledgements
================

Many changes and rewrites to this document were suggested by the readers
of the Distutils SIG. In particular, Sean Reifschneider often
contributed actual text for inclusion in this PEP.

The list of licenses was compiled using the SourceForge license list and
the CTAN license list compiled by Graham Williams; Carey Evans also
offered several useful suggestions on this list.

Copyright
=========

This document has been placed in the public domain.

.. Local Variables: mode: indented-text indent-tabs-mode: nil End:
