PEP: 313 Title: Adding Roman Numeral Literals to Python Version:
$Revision$ Last-Modified: $Date$ Author: Mike Meyer <mwm@mired.org>
Status: Rejected Type: Standards Track Content-Type: text/x-rst Created:
01-Apr-2003 Python-Version: 2.4 Post-History:

Abstract
========

This PEP (also known as PEP CCCXIII) proposes adding Roman numerals as a
literal type. It also proposes the new built-in function "roman", which
converts an object to an integer, then converts the integer to a string
that is the Roman numeral literal equivalent to the integer.

BDFL Pronouncement
==================

This PEP is rejected. While the majority of Python users deemed this to
be a nice-to-have feature, the community was unable to reach a consensus
on whether nine should be represented as IX, the modern form, or VIIII,
the classic form. Likewise, no agreement was reached on whether MXM or
MCMXC would be considered a well-formed representation of 1990. A vocal
minority of users has also requested support for lower-cased numerals
for use in (i) powerpoint slides, (ii) academic work, and (iii) Perl
documentation.

Rationale
=========

Roman numerals are used in a number of areas, and adding them to Python
as literals would make computations in those areas easier. For instance,
Super Bowls are counted with Roman numerals, and many older movies have
copyright dates in Roman numerals. Further, LISP provides a Roman
numerals literal package, so adding Roman numerals to Python will help
ease the LISP-envy sometimes seen in comp.lang.python. Besides, the
author thinks this is the easiest way to get his name on a PEP.

Syntax for Roman literals
=========================

Roman numeral literals will consist of the characters M, D, C, L, X, V
and I, and only those characters. They must be in upper case, and
represent an integer with the following rules:

1.  Except as noted below, they must appear in the order M, D, C, L, X,
    V then I. Each occurrence of each character adds 1000, 500, 100, 50,
    10, 5 and 1 to the value of the literal, respectively.

2.  Only one D, V or L may appear in any given literal.

3.  At most three each of Is, Xs and Cs may appear consecutively in any
    given literal.

4.  A single I may appear immediately to the left of the single V,
    followed by no Is, and adds 4 to the value of the literal.

5.  A single I may likewise appear before the last X, followed by no Is
    or Vs, and adds 9 to the value.

6.  X is to L and C as I is to V and X, except the values are 40 and 90,
    respectively.

7.  C is to D and M as I is to V and X, except the values are 400 and
    900, respectively.

Any literal composed entirely of M, D, C, L, X, V and I characters that
does not follow this format will raise a syntax error, because explicit
is better than implicit.

Built-In "roman" Function
=========================

The new built-in function "roman" will aide the translation from
integers to Roman numeral literals. It will accept a single object as an
argument, and return a string containing the literal of the same value.
If the argument is not an integer or a rational (see PEP 239 \[1\]*) it
will passed through the existing built-in "int" to obtain the value.
This may cause a loss of information if the object was a float. If the
object is a rational, then the result will be formatted as a rational
literal (see PEP 240 \[2\]*) with the integers in the string being Roman
numeral literals.

Compatibility Issues
====================

No new keywords are introduced by this proposal. Programs that use
variable names that are all upper case and contain only the characters
M, D, C, L, X, V and I will be affected by the new literals. These
programs will now have syntax errors when those variables are assigned,
and either syntax errors or subtle bugs when those variables are
referenced in expressions. Since such variable names violate PEP 8
\[3\]\_, the code is already broken, it just wasn't generating
exceptions. This proposal corrects that oversight in the language.

References
==========

.. \[1\] PEP 239, Adding a Rational Type to Python
http://www.python.org/dev/peps/pep-0239/

.. \[2\] PEP 240, Adding a Rational Literal to Python
http://www.python.org/dev/peps/pep-0240/

.. \[3\] PEP 8, Style Guide for Python Code
http://www.python.org/dev/peps/pep-0008/

Copyright
=========

This document has been placed in the public domain.

.. Local Variables: mode: indented-text indent-tabs-mode: nil
sentence-end-double-space: t fill-column: 70 End:
