PEP: 321 Title: Date/Time Parsing and Formatting Version: $Revision$
Last-Modified: $Date$ Author: A.M. Kuchling <amk@amk.ca> Status:
Withdrawn Type: Standards Track Content-Type: text/x-rst Created:
16-Sep-2003 Python-Version: 2.4 Post-History:

Abstract
========

Python 2.3 added a number of simple date and time types in the
`datetime` module. There's no support for parsing strings in various
formats and returning a corresponding instance of one of the types. This
PEP proposes adding a family of predefined parsing function for several
commonly used date and time formats, and a facility for generic parsing.

The types provided by the `datetime` module all have `.isoformat()` and
`.ctime()` methods that return string representations of a time, and the
`.strftime()` method can be used to construct new formats. There are a
number of additional commonly-used formats that would be useful to have
as part of the standard library; this PEP also suggests how to add them.

Input Formats
=============

Useful formats to support include:

-   `ISO8601`\_
-   ARPA/`RFC2822`\_
-   `ctime`\_
-   Formats commonly written by humans such as the American
    "MM/DD/YYYY", the European "YYYY/MM/DD", and variants such as
    "DD-Month-YYYY".
-   CVS-style or tar-style dates ("tomorrow", "12 hours ago", etc.)

XXX The Perl `ParseDate.pm`\_ module supports many different input
formats, both absolute and relative. Should we try to support them all?

Options:

1)  Add functions to the `datetime` module::

         import datetime
         d = datetime.parse_iso8601("2003-09-15T10:34:54")

2)  Add class methods to the various types. There are already various
    class methods such as `.now()`, so this would be pretty natural.::

         import datetime
         d = datetime.date.parse_iso8601("2003-09-15T10:34:54")

3)  Add a separate module (possible names: date, date\_parse,
    parse\_date) or subpackage (possible names: datetime.parser)
    containing parsing functions::

         import datetime
         d = datetime.parser.parse_iso8601("2003-09-15T10:34:54")

Unresolved questions:

-   Naming convention to use.
-   What exception to raise on errors? ValueError, or a specialized
    exception?
-   Should you know what type you're expecting, or should the parsing
    figure it out? (e.g. `parse_iso8601("yyyy-mm-dd")` returns a `date`
    instance, but parsing "yyyy-mm-ddThh:mm:ss" returns a `datetime`.)
    Should there be an option to signal an error if a time is provided
    where none is expected, or if no time is provided?
-   Anything special required for I18N? For time zones?

Generic Input Parsing
=====================

Is a strptime() implementation that returns `datetime` types sufficient?

XXX if yes, describe strptime here. Can the existing pure-Python
implementation be easily retargeted?

Output Formats
==============

Not all input formats need to be supported as output formats, because
it's pretty trivial to get the `strftime()` argument right for simple
things such as YYYY/MM/DD. Only complicated formats need to be
supported; RFC2822 is currently the only one I can think of.

Options:

1)  Provide predefined format strings, so you could write this::

         import datetime
         d = datetime.datetime(...)
         print d.strftime(d.RFC2822_FORMAT) # or datetime.RFC2822_FORMAT?

2)  Provide new methods on all the objects::

         d = datetime.datetime(...)
         print d.rfc822_time()

Relevant functionality in other languages includes the `PHP date`\_
function (Python implementation by Simon Willison at
http://simon.incutio.com/archive/2003/10/07/dateInPython)

References
==========

.. \_RFC2822: http://rfc2822.x42.com

.. \_ISO8601: http://www.cl.cam.ac.uk/\~mgk25/iso-time.html

.. \_ParseDate.pm:
http://search.cpan.org/author/MUIR/Time-modules-2003.0211/lib/Time/ParseDate.pm

.. \_ctime:
http://www.opengroup.org/onlinepubs/007908799/xsh/asctime.html

.. \_PHP date: http://www.php.net/date

Other useful links:

http://www.egenix.com/files/python/mxDateTime.html
http://ringmaster.arc.nasa.gov/tools/time\_formats.html
http://www.thinkage.ca/english/gcos/expl/b/lib/0tosec.html
https://moin.conectiva.com.br/DateUtil

Copyright
=========

This document has been placed in the public domain.

 .. Local Variables: mode: indented-text indent-tabs-mode: nil
sentence-end-double-space: t fill-column: 70 End:
