PEP: 559 Title: Built-in noop() Author: Barry Warsaw
\<<barry@python.org>\> Status: Rejected Type: Standards Track
Content-Type: text/x-rst Created: 2017-09-08 Python-Version: 3.7
Post-History: 2017-09-09 Resolution:
<https://mail.python.org/pipermail/python-dev/2017-September/149438.html>

Abstract
========

This PEP proposes adding a new built-in function called `noop()` which
does nothing but return `None`.

Rationale
=========

It is trivial to implement a no-op function in Python. It\'s so easy in
fact that many people do it many times over and over again. It would be
useful in many cases to have a common built-in function that does
nothing.

One use case would be for PEP 553, where you could set the breakpoint
environment variable to the following in order to effectively disable
it:

    $ setenv PYTHONBREAKPOINT=noop

Implementation
==============

The Python equivalent of the `noop()` function is exactly:

    def noop(*args, **kws):
        return None

The C built-in implementation is available as a pull request[^1].

Rejected alternatives
=====================

`noop()` returns something
--------------------------

YAGNI.

This is rejected because it complicates the semantics. For example, if
you always return both `*args` and `**kws`, what do you return when none
of those are given? Returning a tuple of `((), {})` is kind of ugly, but
provides consistency. But you might also want to just return `None`
since that\'s also conceptually what the function was passed.

Or, what if you pass in exactly one positional argument, e.g. `noop(7)`.
Do you return `7` or `((7,), {})`? And so on.

The author claims that you won\'t ever need the return value of `noop()`
so it will always return `None`.

Coghlan\'s Dialogs (edited for formatting):

> My counterargument to this would be `map(noop, iterable)`,
> `sorted(iterable, key=noop)`, etc. (`filter`, `max`, and `min` all
> accept callables that accept a single argument, as do many of the
> itertools operations).
>
> Making `noop()` a useful default function in those cases just needs
> the definition to be:
>
>     def noop(*args, **kwds):
>         return args[0] if args else None
>
> The counterargument to the counterargument is that using `None` as the
> default in all these cases is going to be faster, since it lets the
> algorithm skip the callback entirely, rather than calling it and
> having it do nothing useful.

References
==========

Copyright
=========

This document has been placed in the public domain.

### 

> Local Variables: mode: indented-text indent-tabs-mode: nil
> sentence-end-double-space: t fill-column: 70 coding: utf-8 End:

[^1]: <https://github.com/python/cpython/pull/3480>
