PEP: 595 Title: Improving bugs.python.org Author: Ezio Melotti
\<<ezio.melotti@gmail.com>\>, Berker Peksag
\<<berker.peksag@gmail.com>\> BDFL-Delegate: Barry Warsaw
\<<barry@python.org>\> Status: Withdrawn Type: Informational
Content-Type: text/x-rst Created: 12-May-2019

Abstract
========

This PEP proposes a list of improvements to make bugs.python.org more
usable for contributors and core developers. This PEP also discusses why
remaining on Roundup should be preferred over switching to GitHub
Issues, as proposed by `581`{.interpreted-text role="pep"}.

Resolution
==========

2020-06-25: With the acceptance of PEP 581, the move to GitHub for
issues is proceeding, this PEP is being marked as a withdrawn
informational PEP.

Motivation
==========

On May 14th, 2019 `581`{.interpreted-text role="pep"} has been
accepted[^1] without much public discussion and without a clear
consensus[^2]. The PEP contains factual errors and doesn\'t address some
of the issues that the migration to GitHub Issues might present.

Given the scope of the migration, the amount of work required, and how
it will negatively affect the workflow during the transition phase, this
decision should be re-evaluated.

Roundup advantages over GitHub Issues
=====================================

This section discusses reasons why Roundup should be preferred over
GitHub Issues and Roundup features that are not available on GitHub
Issues.

-   **Roundup is the status quo.** Roundup has been an integral part of
    the CPython workflow for years. It is a stable product that has been
    tested and customized to adapt to our needs as the workflow evolved.

    It is possible to gradually improve it and avoid the disruption that
    a switch to a different system would inevitably bring to the
    workflow.

-   **Open-source and Python powered.** Roundup is an open-source
    project and is written in Python. By using it and supporting it, we
    also support the Python ecosystem. Several features developed for
    bpo have also been ported to upstream Roundup over the years.
-   **Fully customizable.** Roundup can be (and has been) fully
    customized to fit our needs.
-   **Finer-grained access control.** Roundup allows the creation of
    different roles with different permissions (e.g. create, view, edit,
    etc.) for each individual property, and users can have multiple
    roles.
-   **Flexible UI.** While Roundup UI might look dated, it is convenient
    and flexible.

    For example, on the issue page, each field (e.g. title, type,
    versions, status, linked files and PRs, etc.) have appropriate UI
    elements (input boxes, dropdowns, tables, etc.) that are easy to set
    and also provide a convenient way to get info about the issue at a
    glance. The number of fields, their values, and the UI element they
    use is also fully customizable. GitHub only provides labels.

    The issue list page presents the issues in a compact and easy to
    read table with separate columns for different fields. For
    comparison, Roundup lists 50 issues in a screen, whereas GitHub
    takes two screens to shows 25 issues.

-   **Advanced search.** Roundup provides an accurate way to search and
    filter by using any combination of issue fields. It is also possible
    to customize the number of results and the fields displayed in the
    table, and the sorting and grouping (up to two levels).

    bpo also provides predefined summaries (e.g. \"Created by you\",
    \"Assigned to you\", etc.) and allows the creation of custom search
    queries that can be conveniently accessed from the sidebar.

-   **Nosy list autocomplete.** The nosy list has an autocomplete
    feature that suggests maintainers and experts. The suggestions are
    automatically updated when the experts index[^3] changes.
-   **Dependencies and Superseders.** Roundup allows to specify
    dependencies that must be addressed before the current issues can be
    closed and a superseder issue to easily mark duplicates [^4]. The
    list of dependencies can also be used to create meta-issues that
    references several other sub-issues[^5].

Improving Roundup
=================

This section lists some of the issues mentioned by
`581`{.interpreted-text role="pep"} and other desired features and
discusses how they can be implemented by improving Roundup and/or our
instance.

-   **REST API support.** A REST API will make integration with other
    services and the development of new tools and applications easiers.

    Upstream Roundup now supports a REST API. Updating the tracker will
    make the REST API available.

-   **GitHub login support.** This will allow users to login to
    bugs.python.org (bpo) without having to create a new account. It
    will also solve issues with confirmation emails being marked as
    spam, and provide two-factor authentication.

    A patch to add this functionality is already available and is being
    integrated at the time of writing[^6].

-   **Markdown support and message preview and editing.** This feature
    will allow the use of Markdown in messages and the ability to
    preview the message before the submission and edit it afterward.

    This can be done, but it will take some work. Possible solutions
    have been proposed on the roundup-devel mailing list[^7].

-   **\"Remove me from nosy list\" button.** Add a button on issue pages
    to remove self from the nosy list.

    This feature will be added during GSoC 2019.

-   **Mobile friendly theme.** Current theme of bugs.python.org looks
    dated and it doesn\'t work well with mobile browsers.

    A mobile-friendly theme that is more modern but still familiar will
    be added.

-   **Move reply box close to the last message.** The reply box is
    located at the top of the page, whereas the last message is at the
    bottom.

    The reply box can be moved or duplicated after the last message.

-   **Real-time updates.** When another users submits changes to an
    issue, they should show up in real time.

    This can be accomplished by using the REST API.

-   **Add PR link to BPO emails.** Currently bpo emails don\'t include
    links to the corresponding PRs.

    A patch[^8] is available to change the content of the bpo emails
    from:

        components: +Tkinter
        versions: +Python 3.4
        pull_requests: +42

    to:

        components: +Tkinter
        versions: +Python 3.4
        pull_request: https://github.com/python/cpython/pull/341

-   **Python 3 support.** Using Python 3 will make maintenance easier.

    Upstream Roundup now supports Python 3. Updating the tracker will
    allow us to switch to Python 3. The instances will need to be
    updated as well.

-   **Use upstream Roundup.** We currently use a fork of Roundup with a
    few modifications, most notably the GitHub integration. If this is
    ported upstream, we can start using upstream Roundup without having
    to maintain our fork.

PEP 581 issues
==============

This section addresses some errors and inaccuracies found in
`581`{.interpreted-text role="pep"}.

The \"Why GitHub?\" section of PEP 581 lists features currently
available on GitHub Issues but not on Roundup. Some of this features are
currently supported:

-   \"Ability to reply to issue and pull request conversations via
    email.\"
    -   Being able to reply by email has been one of the core features
        of Roundup since the beginning. It is also possible to create
        new issues or close existing ones, set or modify fields, and add
        attachments.
-   \"Email notifications containing metadata, integrated with Gmail,
    allowing systematic filtering of emails.\"
    -   Emails sent by Roundup contains metadata that can be used for
        filtering.
-   \"Additional privacy, such as offering the user a choice to hide an
    email address, while still allowing communication with the user
    through @-mentions.\"
    -   Email addresses are hidden by default to users that are not
        registered. Registered users can see other users\' addresses
        because we configured the tracker to show them. It can easily be
        changed if desired. Users can still be added to the nosy list by
        using their username even if their address is hidden.
-   \"Ability to automatically close issues when a PR has been merged.\"
    -   The GitHub integration of Roundup automatically closes issues
        when a commit that contains \"fixes issue \<id\>\" is merged.
        (Alternative spellings such as \"closes\" or \"bug\" are also
        supported.) See[^9] for a recent example of this feature.
-   \"Support for permalinks, allowing easy quoting and copying &
    pasting of source code.\"
    -   Roundup has permalinks for issues, messages, attachments, etc.
        In addition, Roundup allows to easily rewrite broken URLs in
        messages (e.g. if the code hosting changes).
-   \"Core developers, volunteers, and the PSF don\'t have to maintain
    the issue infrastructure/site, giving us more time and resources to
    focus on the development of Python.\"
    -   While this is partially true, additional resources are required
        to write and maintain bots.

        In some cases, bots are required to workaround GitHub\'s lack of
        features rather than expanding.[^10] was written specifically to
        workaround GitHub\'s email integration.

        Updating our bots to stay up-to-date with changes in the GitHub
        API has also maintenance cost.[^11] took two days to be fixed.

        In addition, we will still need to maintain Roundup for bpo
        (even if it becomes read-only) and for the other trackers we
        currently host/maintain (Jython[^12] and Roundup[^13]).

The \"Issues with Roundup / bpo\" section of `581`{.interpreted-text
role="pep"} lists some issues that have already been fixed:

-   \"The upstream Roundup code is in Mercurial. Without any CI
    available, it puts heavy burden on the few existing maintainers in
    terms of reviewing, testing, and applying patches.\"
    -   While Roundup uses Mercurial by default, there is a git clone
        available on GitHub[^14]. Roundup also has CI
        available[^15][^16].
-   \"There is no REST API available. There is an open issue in Roundup
    for adding REST API. Last activity was in 2016.\"
    -   The REST API has been integrated and it\'s now available in
        Roundup.
-   \"Users email addresses are exposed. There is no option to mask
    it.\"
    -   Exposing addresses to registered and logged in users was a
        decision taken when our instance was set up.

        This has now been changed to make the email addresses hidden for
        regular users too (Developers and Coordinators can still see
        them). The \"Email address\" column from the user listing
        page[^17] has been removed too.

-   \"It sends a number of unnecessary emails and notifications, and it
    is difficult, if not impossible, to configure.\"
    -   This can be configured.
-   \"Creating an account has been a hassle. There have been reports of
    people having trouble creating accounts or logging in.\"
    -   The main issue is confirmation emails being marked as spam. Work
        has been done to resolve the issue.

Migration considerations
========================

This section describes issues with the migrations that might not have
been addressed by `581`{.interpreted-text role="pep"} and
`588`{.interpreted-text role="pep"}.

`588`{.interpreted-text role="pep"} suggests to add a button to migrate
issues to GitHub only when someone wants to keep working on them. This
approach has several issues, but there are also other issues that will
need to be addressed regardless of the approach used:

-   **Vendor lock-in.** GitHub is proprietary and there is risk of
    vendor lock-in. Their business model might change and they could
    shut down altogether. For example, several projects decided to move
    away from GitHub after Microsoft acquisition.

    If/when the repository is no longer available on GitHub, we will be
    forced to migrate again and all the links to the issues won\'t work
    anymore.

-   **Required bpo updates.** bpo will need to be updated in order to
    add a button that, once pressed, creates a new issue on GitHub,
    copies over all the messages, attachments, and creates/adds labels
    for the existing fields. Permissions will also need to be tweaked to
    make individual issues read-only once they are migrated, and to
    prevent users to create new accounts. It might be necessary to set
    up redirects (see below).
-   **Two trackers.** If issues are migrated on demand, the issues will
    be split between two trackers. Referencing and searching issues will
    take significant more effort.
-   **Lossy conversion.** GitHub only mechanism to add custom metadata
    is through labels. bpo uses a number of fields to specify several
    different metadata. Preserving all fields and values will result in
    too many labels. If only some fields and values are preserved the
    others will be lost (unless there is a way to preserve them
    elsewhere).
-   **Issue IDs preservation.** GitHub doesn\'t provide a way to set and
    preserve the ID of migrated issues. Some projects managed to
    preserve the IDs by contacting the GitHub staff and migrating the
    issues *en masse*. However, this is no longer possible, since PRs
    and issues share the same namespace and PRs already use existing bpo
    issue IDs.
-   **Internal issue links preservation.** Existing issues might contain
    references to other issues in messages and fields (e.g. dependencies
    or superseder). Since the issue ID will change during the migration,
    these will need to be updated. If the issues are migrated on demand,
    all the existing internal references to the migrated issues (on both
    bpo and GitHub issues) will have to be updated.

    Setting up a redirect for each migrated issue on bpo might mitigate
    the issue, however \-- if references in migrated messages are not
    updated \-- it will cause confusion (e.g. if bpo issue `#1234`
    becomes GitHub issue `#4321`, a reference to `#1234` in a migrated
    message could link to bpo `#1234` and bpo can redirect to GitHub
    issue `#4321`, but new references to `#1234` will link to GitHub PR
    `#1234` rather than GitHub issue `#4321`). Manually having to
    specify a `bpo-` or `gh-` prefix is error prone.

-   **External issue links preservation.** A number of websites, mails,
    etc. link to bpo issues. If bpo is shut down, these links will
    break. If we don\'t want to break the links, we will have to keep
    bpo alive and set up a redirect system that links to the
    corresponding GitHub issue.

    In addition, if GitHub shuts down, we won\'t have any way to setup
    redirects and preserve external links to GitHub issues.

-   **References preservation and updating.** In addition to issue
    references, bpo converts a number of other references into links,
    including message and PR IDs, changeset numbers, legacy SVN revision
    numbers, paths to files in the repo, files in tracebacks (detecting
    the correct branch), and links to devguide pages and sections[^18].

    Since Roundup converts references to links when messages are
    requested, it is possible to update the target and generate the
    correct link. This need already arose several times, for example:
    files and HG changesets moved from `hg.python.org` to GitHub and the
    devguide moved from `docs.python.org/devguide` to
    `devguide.python.org`.

    Since messages on GitHub are static, the links will need to be
    generated and hardcoded during the migration or they will be lost.
    In order to update them, a tool to find all references and
    regenerate the links will need to be written.

-   **Roundup and bpo maintenance.** On top of the aforementioned
    changes to bpo and development of tools required to migrate to
    GitHub issues, we will still need to keep running and maintaining
    Roundup, both for our bpo instance (read-only) and for the Jython
    and Roundup trackers (read-write).

    Even if eventually we migrate all bpo issues to GitHub and we stop
    maintaining Jython and Roundup, bpo will need to be maintained and
    redirect to the corresponding GitHub issues.

-   **Bots maintenance.** Since it\'s not possible to customize GitHub
    directly, it\'s also necessary to write, maintain, and host bots.
    Even if eventually we stop maintaining Roundup, the maintenance
    burden simply shifted from Roundup to the bots. Hosting each
    different bot also has a monetary cost.
-   **Using issue templates.** Manually editing issue templates to
    \"remove texts that don\'t apply to \[the\] issue\" is cumbersome
    and error-prone.
-   **Signal to noise ratio.** Switching to GitHub Issues will likely
    increase the number of invalid reports and increase the triaging
    effort. This concern has been raised in the past in a Zulip
    topic[^19].

    There have been already cases where people posted comments on PRs
    that required moderators to mark them as off-topic or disruptive,
    delete them altogether, and even lock the conversation[^20].

-   **Weekly tracker reports and stats.** Roundup sends weekly reports
    to python-dev with a summary that includes new issues, recent issues
    with no replies, recent issues waiting for review, most discussed
    issues, closed issues, and deltas for open/closed/total issue
    counts[^21]. The report provides an easy way to keep track of the
    tracker activity and to make sure that issues that require attention
    are noticed.

    The data collect by the weekly report is also use to generate
    statistics and graphs that can be used to gain new insights[^22].

-   **bpo-related MLs.** There are currently two mailing lists where bpo
    posts new tracker issues and all messages respectively:
    `new-bugs-announce`[^23] and `python-bugs-list`[^24]. A new system
    will need to be developed to preserve this functionality. These MLs
    offer additional ways to keep track of the tracker activity.

References
==========

> <https://mail.python.org/pipermail/tracker-discuss/2018-June/004547.html>

Copyright
=========

This document has been placed in the public domain.

[^1]: \[Python-Dev\] PEP 581 (Using GitHub issues for CPython) is
    accepted

    <https://mail.python.org/pipermail/python-dev/2019-May/157399.html>

[^2]: \[python-committers\] \[Python-Dev\] PEP 581 (Using GitHub issues
    for CPython) is accepted

    <https://mail.python.org/pipermail/python-committers/2019-May/006755.html>

[^3]: Experts Index \-- Python Devguide

    <https://devguide.python.org/experts/>

[^4]: An example of superseded issues: \"re.sub() replaces only several
    matches\"

    <https://bugs.python.org/issue12078>

[^5]: An example of meta issue using dependencies to track sub-issues:
    \"Meta-issue: support of the android platform\"\"

    <https://bugs.python.org/issue26865>

[^6]: Support logging in with GitHub

    <https://github.com/python/bugs.python.org/issues/7>

[^7]: Re: \[Roundup-devel\] PEP 581 and Google Summer of Code

    <https://sourceforge.net/p/roundup/mailman/message/36667828/>

[^8]: \[Tracker-discuss\] \[issue624\] bpo emails contain useless
    non-github pull\_request number - users want a link to actual github
    PR

[^9]: The commit reported in msg342882 closes the issue (see the history
    below)

    <https://bugs.python.org/issue36951#msg342882>

[^10]: The cpython-emailer-webhook project

    <https://github.com/berkerpeksag/cpython-emailer-webhook>

[^11]: A recent incident caused by GitHub

    <https://github.com/python/bedevere/pull/163>

[^12]: Jython issue tracker

    <https://bugs.jython.org/>

[^13]: Roundup issue tracker

    <https://issues.roundup-tracker.org/>

[^14]: GitHub clone of Roundup

    <https://github.com/roundup-tracker/roundup>

[^15]: Travis-CI for Roundup

    <https://travis-ci.org/roundup-tracker/roundup>) and codecov

[^16]: Codecov for Roundup

    <https://codecov.io/gh/roundup-tracker/roundup/commits>

[^17]: User listing \-- Python tracker

    <https://bugs.python.org/user?@sort=username>

[^18]: Generating Special Links in a Comment \-- Python Devguide

    <https://devguide.python.org/triaging/#generating-special-links-in-a-comment>

[^19]: The New-bugs-announce mailing list

    <https://mail.python.org/mailman/listinfo/new-bugs-announce>

[^20]: The Python-bugs-list mailing list

    <https://mail.python.org/mailman/listinfo/python-bugs-list>

[^21]: An example of \[Python-Dev\] Summary of Python tracker Issues

    <https://mail.python.org/pipermail/python-dev/2019-May/157483.html>

[^22]: Issues stats \-- Python tracker

    <https://bugs.python.org/issue?@template=stats>

[^23]: s/n ratio \-- Python \-- Zulip

    <https://python.zulipchat.com/#narrow/stream/130206-pep581/topic/s.2Fn.20ratio>

[^24]: For example this and other related PRs:

    <https://github.com/python/cpython/pull/9099>
