PEP: 3003 Title: Python Language Moratorium Version: $Revision$
Last-Modified: $Date$ Author: Brett Cannon, Jesse Noller, Guido van
Rossum Status: Final Type: Process Content-Type: text/x-rst Created:
21-Oct-2009 Post-History: 03-Nov-2009

Abstract
========

This PEP proposes a temporary moratorium (suspension) of all changes to
the Python language syntax, semantics, and built-ins for a period of at
least two years from the release of Python 3.1. In particular, the
moratorium would include Python 3.2 (to be released 18-24 months after
3.1) but allow Python 3.3 (assuming it is not released prematurely) to
once again include language changes.

This suspension of features is designed to allow non-CPython
implementations to "catch up" to the core implementation of the
language, help ease adoption of Python 3.x, and provide a more stable
base for the community.

Rationale
=========

This idea was proposed by Guido van Rossum on the python-ideas \[1\]\_
mailing list. The premise of his email was to slow the alteration of the
Python core syntax, builtins and semantics to allow non-CPython
implementations to catch up to the current state of Python, both 2.x and
3.x.

Python, as a language is more than the core implementation -- CPython --
with a rich, mature and vibrant community of implementations, such as
Jython \[2\]*, IronPython \[3\]* and PyPy \[4\]\_ that are a benefit not
only to the community, but to the language itself.

Still others, such as Unladen Swallow \[5\]\_ (a branch of CPython) seek
not to create an alternative implementation, but rather they seek to
enhance the performance and implementation of CPython itself.

Python 3.x was a large part of the last several years of Python's
development. Its release, as well as a bevy of changes to the language
introduced by it and the previous 2.6.x releases, puts alternative
implementations at a severe disadvantage in "keeping pace" with core
python development.

Additionally, many of the changes put into the recent releases of the
language as implemented by CPython have not yet seen widespread usage by
the general user population. For example, most users are limited to the
version of the interpreter (typically CPython) which comes pre-installed
with their operating system. Most OS vendors are just barely beginning
to ship Python 2.6 -- even fewer are shipping Python 3.x.

As it is expected that Python 2.7 be the effective "end of life" of the
Python 2.x code line, with Python 3.x being the future, it is in the
best interest of Python core development to temporarily suspend the
alteration of the language itself to allow all of these external
entities to catch up and to assist in the adoption of, and migration to,
Python 3.x

Finally, the moratorium is intended to free up cycles within core
development to focus on other issues, such as the CPython interpreter
and improvements therein, the standard library, etc.

This moratorium does not allow for exceptions -- once accepted, any
pending changes to the syntax or semantics of the language will be
postponed until the moratorium is lifted.

This moratorium does not attempt to apply to any other Python
implementation meaning that if desired other implementations may add
features which deviate from the standard implementation.

Details
=======

Cannot Change
-------------

-   New built-ins
-   Language syntax The grammar file essentially becomes immutable apart
    from ambiguity fixes.
-   General language semantics The language operates as-is with only
    specific exemptions (see below).
-   New **future** imports These are explicitly forbidden, as they
    effectively change the language syntax and/or semantics (albeit
    using a compiler directive).

Case-by-Case Exemptions
-----------------------

-   New methods on built-ins The case for adding a method to a built-in
    object can be made.
-   Incorrect language semantics If the language semantics turn out to
    be ambiguous or improperly implemented based on the intention of the
    original design then the semantics may change.
-   Language semantics that are difficult to implement Because other VMs
    have not begun implementing Python 3.x semantics there is a
    possibility that certain semantics are too difficult to replicate.
    In those cases they can be changed to ease adoption of Python 3.x by
    the other VMs.

Allowed to Change
-----------------

-   C API It is entirely acceptable to change the underlying C code of
    CPython as long as other restrictions of this moratorium are not
    broken. E.g. removing the GIL would be fine assuming certain
    operations that are currently atomic remain atomic.
-   The standard library As the standard library is not directly tied to
    the language definition it is not covered by this moratorium.
-   Backports of 3.x features to 2.x The moratorium only affects
    features that would be new in 3.x.
-   Import semantics For example, PEP 382. After all, import semantics
    vary between Python implementations anyway.

Retroactive
===========

It is important to note that the moratorium covers all changes since the
release of Python 3.1. This rule is intended to avoid features being
rushed or smuggled into the CPython source tree while the moratorium is
being discussed. A review of the NEWS file for the py3k development
branch showed no commits would need to be rolled back in order to meet
this goal.

Extensions
==========

The time period of the moratorium can only be extended through a new
PEP.

Copyright
=========

This document has been placed in the public domain.

References
==========

.. \[1\]
https://mail.python.org/pipermail/python-ideas/2009-October/006305.html
.. \[2\] http://www.jython.org/ .. \[3\]
http://www.codeplex.com/IronPython .. \[4\] http://codespeak.net/pypy/
.. \[5\] http://code.google.com/p/unladen-swallow/

.. Local Variables: mode: indented-text indent-tabs-mode: nil
sentence-end-double-space: t fill-column: 80 coding: utf-8 End:
