PEP: 3099 Title: Things that will Not Change in Python 3000 Version:
$Revision$ Last-Modified: $Date$ Author: Georg Brandl <georg@python.org>
Status: Final Type: Process Content-Type: text/x-rst Created:
04-Apr-2006 Post-History:

Abstract
========

Some ideas are just bad. While some thoughts on Python evolution are
constructive, some go against the basic tenets of Python so egregiously
that it would be like asking someone to run in a circle: it gets you
nowhere, even for Python 3000, where extraordinary proposals are
allowed. This PEP tries to list all BDFL pronouncements on Python 3000
that refer to changes that will not happen and new features that will
not be introduced, sorted by topics, along with a short explanation or a
reference to the relevant thread on the python-3000 mailing list.

If you think you should suggest any of the listed ideas it would be
better to just step away from the computer, go outside, and enjoy
yourself. Being active outdoors by napping in a nice patch of grass is
more productive than bringing up a beating-a-dead-horse idea and having
people tell you how dead the idea is. Consider yourself warned.

Core language
=============

-   Python 3000 will not be case-insensitive.

-   Python 3000 will not be a rewrite from scratch.

    It will also not use C++ or another language different from C as
    implementation language. Rather, there will be a gradual
    transmogrification of the codebase. There's an excellent essay by
    Joel Spolsky explaining why:
    http://www.joelonsoftware.com/articles/fog0000000069.html

-   `self` will not become implicit.

    Having `self` be explicit is a *good thing*. It makes the code clear
    by removing ambiguity about how a variable resolves. It also makes
    the difference between functions and methods small.

    Thread: "Draft proposal: Implicit self in Python 3.0"
    https://mail.python.org/pipermail/python-dev/2006-January/059468.html

-   `lambda` will not be renamed.

    At one point lambda was slated for removal in Python 3000.
    Unfortunately no one was able to come up with a better way of
    providing anonymous functions. And so lambda is here to stay.

    But it is here to stay as-is. Adding support for statements is a
    non-starter. It would require allowing multi-line lambda expressions
    which would mean a multi-line expression could suddenly exist. That
    would allow for multi-line arguments to function calls, for
    instance. That is just plain ugly.

    Thread: "genexp syntax / lambda",
    https://mail.python.org/pipermail/python-3000/2006-April/001042.html

-   Python will not have programmable syntax.

    Thread: "It's a statement! It's a function! It's BOTH!",
    https://mail.python.org/pipermail/python-3000/2006-April/000286.html

-   There won't be a syntax for `zip()`-style parallel iteration.

    Thread: "Parallel iteration syntax",
    https://mail.python.org/pipermail/python-3000/2006-March/000210.html

-   Strings will stay iterable.

    Thread: "Making strings non-iterable",
    https://mail.python.org/pipermail/python-3000/2006-April/000759.html

-   There will be no syntax to sort the result of a generator expression
    or list comprehension. `sorted()` covers all use cases.

    Thread: "Adding sorting to generator comprehension",
    https://mail.python.org/pipermail/python-3000/2006-April/001295.html

-   Slices and extended slices won't go away (even if the **getslice**
    and **setslice** APIs may be replaced) nor will they return views
    for the standard object types.

    Thread: Future of slices
    https://mail.python.org/pipermail/python-3000/2006-May/001563.html

-   It will not be forbidden to reuse a loop variable inside the loop's
    suite.

    Thread: elimination of scope bleeding of iteration variables
    https://mail.python.org/pipermail/python-dev/2006-May/064761.html

-   The parser won't be more complex than LL(1).

    Simple is better than complex. This idea extends to the parser.
    Restricting Python's grammar to an LL(1) parser is a blessing, not a
    curse. It puts us in handcuffs that prevent us from going overboard
    and ending up with funky grammar rules like some other dynamic
    languages that will go unnamed, such as Perl.

-   No braces.

    This is so obvious that it doesn't need a reference to a mailing
    list. Do `from __future__ import braces` to get a definitive answer
    on this subject.

-   No more backticks.

    Backticks (\`) will no longer be used as shorthand for `repr` -- but
    that doesn't mean they are available for other uses. Even ignoring
    the backwards compatibility confusion, the character itself causes
    too many problems (in some fonts, on some keyboards, when
    typesetting a book, etc).

    Thread: "new operators via backquoting",
    https://mail.python.org/pipermail/python-ideas/2007-January/000054.html

-   Referencing the global name `foo` will not be spelled `globals.foo`.
    The `global` statement will stay.

    Threads: "replace globals() and global statement with global builtin
    object",
    https://mail.python.org/pipermail/python-3000/2006-July/002485.html,
    "Explicit Lexical Scoping (pre-PEP?)",
    https://mail.python.org/pipermail/python-dev/2006-July/067111.html

-   There will be no alternative binding operators such as `:=`.

    Thread: "Explicit Lexical Scoping (pre-PEP?)",
    https://mail.python.org/pipermail/python-dev/2006-July/066995.html

-   We won't be removing container literals. That is, {expr: expr, ...},
    \[expr, ...\] and (expr, ...) will stay.

    Thread: "No Container Literals",
    https://mail.python.org/pipermail/python-3000/2006-July/002550.html

-   The `else` clause in `while` and `for` loops will not change
    semantics, or be removed.

    Thread: "for/except/else syntax"
    https://mail.python.org/pipermail/python-ideas/2009-October/006083.html

Builtins
========

-   `zip()` won't grow keyword arguments or other mechanisms to prevent
    it from stopping at the end of the shortest sequence.

    Thread: "have zip() raise exception for sequences of different
    lengths",
    https://mail.python.org/pipermail/python-3000/2006-August/003338.html

-   `hash()` won't become an attribute since attributes should be cheap
    to compute, which isn't necessarily the case for a hash.

    Thread: "hash as attribute/property",
    https://mail.python.org/pipermail/python-3000/2006-April/000362.html

Standard types
==============

-   Iterating over a dictionary will continue to yield the keys.

    Thread: "Iterating over a dict",
    https://mail.python.org/pipermail/python-3000/2006-April/000283.html

    Thread: have iter(mapping) generate (key, value) pairs
    https://mail.python.org/pipermail/python-3000/2006-June/002368.html

-   There will be no `frozenlist` type.

    Thread: "Immutable lists",
    https://mail.python.org/pipermail/python-3000/2006-May/002219.html

-   `int` will not support subscripts yielding a range.

    Thread: \"xrange vs. int.\_\_getslice\_\_\",
    https://mail.python.org/pipermail/python-3000/2006-June/002450.html

Coding style
============

-   The (recommended) maximum line width will remain 80 characters, for
    both C and Python code.

    Thread: "C style guide",
    https://mail.python.org/pipermail/python-3000/2006-March/000131.html

Interactive Interpreter
=======================

-   The interpreter prompt (`>>>`) will not change. It gives Guido warm
    fuzzy feelings.

    Thread: "Low-hanging fruit: change interpreter prompt?",
    https://mail.python.org/pipermail/python-3000/2006-November/004891.html

Copyright
=========

This document has been placed in the public domain.

.. Local Variables: mode: indented-text indent-tabs-mode: nil
sentence-end-double-space: t fill-column: 70 coding: utf-8 End:
