PEP: 3108 Title: Standard Library Reorganization Version: $Revision$
Last-Modified: $Date$ Author: Brett Cannon <brett@python.org> Status:
Final Type: Standards Track Content-Type: text/x-rst Created:
01-Jan-2007 Python-Version: 3.0 Post-History: 28-Apr-2008

.. note:: The merging of profile/cProfile as of Python 3.3 did not
occur, and thus is considered abandoned (although it would be acceptable
to do in the future).

Abstract
========

Just like the language itself, Python's standard library (stdlib) has
grown over the years to be very rich. But over time some modules have
lost their need to be included with Python. There has also been an
introduction of a naming convention for modules since Python's inception
that not all modules follow.

Python 3.0 presents a chance to remove modules that do not have long
term usefulness. This chance also allows for the renaming of modules so
that they follow the Python style guide \[\#pep-0008\]\_. This PEP lists
modules that should not be included in Python 3.0 or which need to be
renamed.

Modules to Remove
=================

Guido pronounced that "silly old stuff" is to be deleted from the stdlib
for Py3K \[\#silly-old-stuff\]\_. This is open-ended on purpose. Each
module to be removed needs to have a justification as to why it should
no longer be distributed with Python. This can range from the module
being deprecated in Python 2.x to being for a platform that is no longer
widely used.

This section of the PEP lists the various modules to be removed. Each
subsection represents a different reason for modules to be removed. Each
module must have a specific justification on top of being listed in a
specific subsection so as to make sure only modules that truly deserve
to be removed are in fact removed.

When a reason mentions how long it has been since a module has been
"uniquely edited", it is in reference to how long it has been since a
checkin was done specifically for the module and not for a change that
applied universally across the entire stdlib. If an edit time is not
denoted as "unique" then it is the last time the file was edited,
period.

Previously deprecated \[done\]
------------------------------

PEP 4 lists all modules that have been deprecated in the stdlib
\[\#pep-0004\]\_. The specified motivations mirror those listed in PEP
4. All modules listed in the PEP at the time of the first alpha release
of Python 3.0 will be removed.

The entire contents of lib-old will also be removed. These modules have
already been removed from being imported but are kept in the
distribution for Python for users that rely upon the code.

-   cfmfile

    -   Documented as deprecated since Python 2.4 without an explicit
        reason.

-   cl

    -   Documented as obsolete since Python 2.0 or earlier.
    -   Interface to SGI hardware.

-   md5

    -   Supplanted by the `hashlib` module.

-   mimetools

    -   Documented as obsolete in a previous version.
    -   Supplanted by the `email` package.

-   MimeWriter

    -   Supplanted by the `email` package.

-   mimify

    -   Supplanted by the `email` package.

-   multifile

    -   Supplanted by the `email` package.

-   posixfile

    -   Locking is better done by `fcntl.lockf()`.

-   rfc822

    -   Supplanted by the `email` package.

-   sha

    -   Supplanted by the `hashlib` package.

-   sv

    -   Documented as obsolete since Python 2.0 or earlier.
    -   Interface to obsolete SGI Indigo hardware.

-   timing

    -   Documented as obsolete since Python 2.0 or earlier.
    -   `time.clock()` gives better time resolution.

Platform-specific with minimal use \[done\]
-------------------------------------------

Python supports many platforms, some of which are not widely used or
maintained. And on some of these platforms there are modules that have
limited use to people on those platforms. Because of their limited
usefulness it would be better to no longer burden the Python development
team with their maintenance.

The modules mentioned below are documented. All undocumented modules for
the specified platforms will also be removed.

IRIX ////

The IRIX operating system is no longer produced \[\#irix-retirement\]\_.
Removing all modules from the plat-irix\[56\] directory has been deemed
reasonable because of this fact.

-   AL/al

    -   Provides sound support on Indy and Indigo workstations.
    -   Both workstations are no longer available.
    -   Code has not been uniquely edited in three years.

-   cd/CD

    -   CD drive control for SGI systems.
    -   SGI no longer sells machines with IRIX on them.
    -   Code has not been uniquely edited in 14 years.

-   cddb

    -   Undocumented.

-   cdplayer

    -   Undocumented.

-   cl/CL/CL\_old

    -   Compression library for SGI systems.
    -   SGI no longer sells machines with IRIX on them.
    -   Code has not been uniquely edited in 14 years.

-   DEVICE/GL/gl/cgen/cgensuport

    -   GL access, which is the predecessor to OpenGL.
    -   Has not been edited in at least eight years.
    -   Third-party libraries provide better support (PyOpenGL
        \[\#pyopengl\]\_).

-   ERRNO

    -   Undocumented.

-   FILE

    -   Undocumented.

-   FL/fl/flp

    -   Wrapper for the FORMS library \[\#irix-forms\]\_
    -   FORMS has not been edited in 12 years.
    -   Library is not widely used.
    -   First eight hits on Google are for Python docs for fl.

-   fm

    -   Wrapper to the IRIS Font Manager library.
    -   Only available on SGI machines which no longer come with IRIX.

-   GET

    -   Undocumented.

-   GLWS

    -   Undocumented.

-   imgfile

    -   Wrapper for SGI libimage library for imglib image files (`.rgb`
        files).
    -   Python Imaging Library provides read-only support \[\#pil\]\_.
    -   Not uniquely edited in 13 years.

-   IN

    -   Undocumented.

-   IOCTL

    -   Undocumented.

-   jpeg

    -   Wrapper for JPEG (de)compressor.
    -   Code not uniquely edited in nine years.
    -   Third-party libraries provide better support (Python Imaging
        Library \[\#pil\]\_).

-   panel

    -   Undocumented.

-   panelparser

    -   Undocumented.

-   readcd

    -   Undocumented.

-   SV

    -   Undocumented.

-   torgb

    -   Undocumented.

-   WAIT

    -   Undocumented.

Mac-specific modules ////////////////////

The Mac-specific modules are not well-maintained (e.g., the bgen tool
used to auto-generate many of the modules has never been updated to
support UCS-4). It is also not Python's place to maintain such a large
amount of OS-specific modules. Thus all modules under `Lib/plat-mac` and
`Mac` are to be removed.

A stub module for proxy access will be provided for use by urllib.

-   \_builtinSuites

    -   Undocumented.
    -   Package under lib-scriptpackages.

-   Audio\_mac

    -   Undocumented.

-   aepack

    -   OSA support is better through third-party modules.

        -   Appscript \[\#appscript\]\_.

    -   Hard-coded endianness which breaks on Intel Macs.
    -   Might need to rename if Carbon package dependent.

-   aetools

    -   See aepack.

-   aetypes

    -   See aepack.

-   applesingle

    -   Undocumented.
    -   AppleSingle is a binary file format for A/UX.
    -   A/UX no longer distributed.

-   appletrawmain

    -   Undocumented.

-   appletrunner

    -   Undocumented.

-   argvemulator

    -   Undocumented.

-   autoGIL

    -   Very bad model for using Python with the CFRunLoop.

-   bgenlocations

    -   Undocumented.

-   buildtools

    -   Documented as deprecated since Python 2.3 without an explicit
        reason.

-   bundlebuilder

    -   Undocumented.

-   Carbon

    -   Carbon development has stopped.
    -   Does not support 64-bit systems completely.
    -   Dependent on bgen which has never been updated to support UCS-4
        Unicode builds of Python.

-   CodeWarrior

    -   Undocumented.
    -   Package under lib-scriptpackages.

-   ColorPicker

    -   Better to use Cocoa for GUIs.

-   EasyDialogs

    -   Better to use Cocoa for GUIs.

-   Explorer

    -   Undocumented.
    -   Package under lib-scriptpackages.

-   Finder

    -   Undocumented.
    -   Package under lib-scriptpackages.

-   findertools

    -   No longer useful.

-   FrameWork

    -   Poorly documented.
    -   Not updated to support Carbon Events.

-   gensuitemodule

    -   See aepack.

-   ic

-   icglue

-   icopen

    -   Not needed on OS X.
    -   Meant to replace 'open' which is usually a bad thing to do.

-   macerrors

    -   Undocumented.

-   MacOS

    -   Would also mean the removal of binhex.

-   macostools

-   macresource

    -   Undocumented.

-   MiniAEFrame

    -   See aepack.

-   Nav

    -   Undocumented.

-   Netscape

    -   Undocumented.
    -   Package under lib-scriptpackages.

-   OSATerminology

-   pimp

    -   Undocumented.

-   PixMapWrapper

    -   Undocumented.

-   StdSuites

    -   Undocumented.
    -   Package under lib-scriptpackages.

-   SystemEvents

    -   Undocumented.
    -   Package under lib-scriptpackages.

-   Terminal

    -   Undocumented.
    -   Package under lib-scriptpackages.

-   terminalcommand

    -   Undocumented.

-   videoreader

    -   No longer used.

-   W

    -   No longer distributed with Python.

.. \_PyObjC: http://pyobjc.sourceforge.net/

Solaris ///////

-   SUNAUDIODEV/sunaudiodev

    -   Access to the sound card on Sun machines.
    -   Code not uniquely edited in over eight years.

Hardly used \[done\]
--------------------

Some platform-independent modules are rarely used. There are a number of
possible explanations for this, including, ease of reimplementation,
very small audience or lack of adherence to more modern standards.

-   audiodev

    -   Undocumented.
    -   Not edited in five years.

-   imputil

    -   Undocumented.
    -   Never updated to support absolute imports.

-   mutex

    -   Easy to implement using a semaphore and a queue.
    -   Cannot block on a lock attempt.
    -   Not uniquely edited since its addition 15 years ago.
    -   Only useful with the 'sched' module.
    -   Not thread-safe.

-   stringold

    -   Function versions of the methods on string objects.
    -   Obsolete since Python 1.6.
    -   Any functionality not in the string object or module will be
        moved to the string module (mostly constants).

-   sunaudio

    -   Undocumented.
    -   Not edited in over seven years.
    -   The `sunau` module provides similar abilities.

-   toaiff

    -   Undocumented.
    -   Requires `sox` library to be installed on the system.

-   user

    -   Easily handled by allowing the application specify its own
        module name, check for existence, and import if found.

-   new

    -   Just a rebinding of names from the 'types' module.
    -   Can also call `type` built-in to get most types easily.
    -   Docstring states the module is no longer useful as of revision
        27241 (2002-06-15).

-   pure

    -   Written before Pure Atria was bought by Rational which was then
        bought by IBM (in other words, very old).

-   test.testall

    -   From the days before regrtest.

Obsolete
--------

Becoming obsolete signifies that either another module in the stdlib or
a widely distributed third-party library provides a better solution for
what the module is meant for.

-   Bastion/rexec \[done\]

    -   Restricted execution / security.
    -   Turned off in Python 2.3.
    -   Modules deemed unsafe.

-   bsddb185 \[done\]

    -   Superseded by bsddb3
    -   Not built by default.
    -   Documentation specifies that the "module should never be used
        directly in new code".
    -   Available externally from PyPI\_.

-   Canvas \[done\]

    -   Marked as obsolete in a comment by Guido since 2000 (see
        http://bugs.python.org/issue210677).
    -   Better to use the `Tkinter.Canvas` class.

-   commands \[done\]

    -   subprocess module replaces it \[\#pep-0324\]\_.
    -   Remove getstatus(), move rest to subprocess.

-   compiler \[done\]

    -   Having to maintain both the built-in compiler and the stdlib
        package is redundant \[\#ast-removal\]\_.
    -   The AST created by the compiler is available \[\#ast\]\_.
    -   Mechanism to compile from an AST needs to be added.

-   dircache \[done\]

    -   Negligible use.
    -   Easily replicated.

-   dl \[done\]

    -   ctypes provides better support for same functionality.

-   fpformat \[done\]

    -   All functionality is supported by string interpolation.

-   htmllib \[done\]

    -   Superseded by HTMLParser.

-   ihooks \[done\]

    -   Undocumented.
    -   For use with rexec which has been turned off since Python 2.3.

-   imageop \[done\]

    -   Better support by third-party libraries (Python Imaging Library
        \[\#pil\]\_).
    -   Unit tests relied on rgbimg and imgfile. - rgbimg was removed in
        Python 2.6. - imgfile slated for removal in this PEP.

-   linuxaudiodev \[done\]

    -   Replaced by ossaudiodev.

-   mhlib \[done\]

    -   Should be removed as an individual module; use `mailbox`
        instead.

-   popen2 \[done\]

    -   subprocess module replaces it \[\#pep-0324\]\_.

-   sgmllib \[done\]

    -   Does not fully parse SGML.
    -   In the stdlib for support to htmllib which is slated for
        removal.

-   sre \[done\]

    -   Previously deprecated; import `re` instead.

-   stat \[TODO need to move all uses over to `os.stat()`\]

    -   `os.stat()` now returns a tuple with attributes.
    -   Functions in the module should be made into methods for the
        object returned by os.stat.

-   statvfs \[done\]

    -   `os.statvfs` now returns a tuple with attributes.

-   thread \[done\]

    -   People should use 'threading' instead.

        -   Rename 'thread' to \_thread.
        -   Deprecate dummy\_thread and rename \_dummy\_thread.
        -   Move thread.get\_ident over to threading.

    -   Guido has previously supported the deprecation
        \[\#thread-deprecation\]\_.

-   urllib \[done\]

    -   Superseded by urllib2.
    -   Functionality unique to urllib will be kept in the urllib
        package.

-   UserDict \[done: 3.0\] \[TODO handle 2.6\]

    -   Not as useful since types can be a superclass.
    -   Useful bits moved to the 'collections' module.

-   UserList/UserString \[done\]

    -   Not useful since types can be a superclass.
    -   Moved to the 'collections' module.

Maintenance Burden
------------------

Over the years, certain modules have become a heavy burden upon
python-dev to maintain. In situations like this, it is better for the
module to be given to the community to maintain to free python-dev to
focus more on language support and other modules in the standard library
that do not take up an undue amount of time and effort.

-   bsddb3

    -   Externally maintained at
        http://www.jcea.es/programacion/pybsddb.htm .
    -   Consistent testing instability.
    -   Berkeley DB follows a different release schedule than Python,
        leading to the bindings not necessarily being in sync with what
        is available.

Modules to Rename
=================

Many modules existed in the stdlib before PEP 8 came into existence
\[\#pep-0008\]\_. This has led to some naming inconsistencies and
namespace bloat that should be addressed.

PEP 8 violations \[done\]
-------------------------

PEP 8 specifies that modules "should have short, all-lowercase names"
where "underscores can be used ... if it improves readability"
\[\#pep-0008\]\_. The use of underscores is discouraged in package
names. The following modules violate PEP 8 and are not somehow being
renamed by being moved to a package.

================== ==================================================
Current Name Replacement Name ==================
================================================== \_winreg winreg
ConfigParser configparser copy\_reg copyreg Queue queue SocketServer
socketserver ==================
==================================================

Merging C and Python implementations of the same interface
----------------------------------------------------------

Several interfaces have both a Python and C implementation. While it is
great to have a C implementation for speed with a Python implementation
as fallback, there is no need to expose the two implementations
independently in the stdlib. For Python 3.0 all interfaces with two
implementations will be merged into a single public interface.

The C module is to be given a leading underscore to delineate the fact
that it is not the reference implementation (the Python implementation
is). This means that any semantic difference between the C and Python
versions must be dealt with before Python 3.0 or else the C
implementation will be removed until it can be fixed.

One interface that is not listed below is xml.etree.ElementTree. This is
an externally maintained module and thus is not under the direct control
of the Python development team for renaming. See `Open Issues`\_ for a
discussion on this.

-   pickle/cPickle \[done\]

    -   Rename cPickle to \_pickle.
    -   Semantic completeness of C implementation *not* verified.

-   profile/cProfile \[TODO\]

    -   Rename cProfile to \_profile.
    -   Semantic completeness of C implementation *not* verified.

-   StringIO/cStringIO \[done\]

    -   Add the class to the 'io' module.

No public, documented interface \[done\]
----------------------------------------

There are several modules in the stdlib that have no defined public
interface. These modules exist as support code for other modules that
are exposed. Because they are not meant to be used directly they should
be renamed to reflect this fact.

============ =============================== Current Name Replacement
Name ============ =============================== markupbase
\_markupbase ============ ===============================

Poorly chosen names \[done\]
----------------------------

A few modules have names that were poorly chosen in hindsight. They
should be renamed so as to prevent their bad name from perpetuating
beyond the 2.x series.

================= =============================== Current Name
Replacement Name ================= =============================== repr
reprlib test.test\_support test.support =================
===============================

Grouping of modules \[done\]
----------------------------

As the stdlib has grown, several areas within it have expanded to
include multiple modules (e.g., support for database files). It thus
makes sense to group related modules into packages.

dbm package ///////////

================= =============================== Current Name
Replacement Name ================= ===============================
anydbm dbm.\_\_init\_\_ \[1\]* dbhash dbm.bsd dbm dbm.ndbm dumbdm
dbm.dumb gdbm dbm.gnu whichdb dbm.**init** \[1\]* =================
===============================

.. \[1\] `dbm.__init__` can combine `anybdbm` and `whichdb` since the
public API for both modules has no name conflict and the two modules
have closely related usage.

html package ////////////

================== =============================== Current Name
Replacement Name ================== ===============================
HTMLParser html.parser htmlentitydefs html.entities ==================
===============================

http package ////////////

================= =============================== Current Name
Replacement Name ================= ===============================
httplib http.client BaseHTTPServer http.server \[2\]* CGIHTTPServer
http.server \[2\]* SimpleHTTPServer http.server \[2\]\_ Cookie
http.cookies cookielib http.cookiejar =================
===============================

.. \[2\] The `http.server` module can combine the specified modules
safely as they have no naming conflicts.

tkinter package ///////////////

================== =============================== Current Name
Replacement Name ================== ===============================
Dialog tkinter.dialog FileDialog tkinter.filedialog \[4\]* FixTk
tkinter.\_fix ScrolledText tkinter.scrolledtext SimpleDialog
tkinter.simpledialog \[5\]* Tix tkinter.tix Tkconstants
tkinter.constants Tkdnd tkinter.dnd Tkinter tkinter.\_\_init\_\_
tkColorChooser tkinter.colorchooser tkCommonDialog tkinter.commondialog
tkFileDialog tkinter.filedialog \[4\]* tkFont tkinter.font tkMessageBox
tkinter.messagebox tkSimpleDialog tkinter.simpledialog \[5\]* turtle
tkinter.turtle ================== ===============================

.. \[4\] `tkinter.filedialog` can safely combine `FileDialog` and
`tkFileDialog` as there are no naming conflicts.

.. \[5\] `tkinter.simpledialog` can safely combine `SimpleDialog` and
`tkSimpleDialog` have no naming conflicts.

urllib package //////////////

Originally this new package was to be named `url`, but because of the
common use of the name as a variable, it has been deemed better to keep
the name `urllib` and instead shift existing modules around into a new
package.

================== ================================================
Current Name Replacement Name ==================
================================================ urllib2 urllib.request,
urllib.error urlparse urllib.parse urllib urllib.parse, urllib.request,
urllib.error \[6\]\_ robotparser urllib.robotparser ==================
================================================

.. \[6\] The quoting-related functions from `urllib` will be added to
`urllib.parse`. `urllib.URLOpener` and `urllib.FancyUrlOpener` will be
added to `urllib.request` as long as the documentation for both modules
is updated.

xmlrpc package //////////////

================== =============================== Current Name
Replacement Name ================== ===============================
xmlrpclib xmlrpc.client DocXMLRPCServer xmlrpc.server \[3\]*
SimpleXMLRPCServer xmlrpc.server \[3\]* ==================
===============================

.. \[3\] The modules being combined into `xmlrpc.server` have no naming
conflicts and thus can safely be merged.

Transition Plan
===============

Issues
------

Issues related to this PEP:

-   `Issue 2775`\_: Master tracking issue
-   `Issue 2828`\_: clean up undoc.rst

.. \_Issue 2775: http://bugs.python.org/issue2775 .. \_Issue 2828:
http://bugs.python.org/issue2828

For modules to be removed
-------------------------

For module removals, it is easiest to remove the module first in Python
3.0 to see where dependencies exist. This makes finding code that
(possibly) requires the suppression of the DeprecationWarning easier.

In Python 3.0 /////////////

1.  Remove the module.

2.  Remove related tests.

3.  Remove all documentation (typically the module's documentation file
    and its entry in a file for the Library Reference).

4.  Edit `Modules/Setup.dist` and `setup.py` if needed.

5.  Run the regression test suite (using `-uall`); watch out for tests
    that are skipped because an import failed for the removed module.

6.  Check in the change (with an appropriate `Misc/NEWS` entry).

7.  Update this PEP noting that the 3.0 step is done.

In Python 2.6 /////////////

1.  Add the following code to the deprecated module if it is implemented
    in Python as the first piece of executed code (adjusting the module
    name and the `warnings` import and needed)::

    from warnings import warnpy3k warnpy3k("the XXX module has been
    removed in Python 3.0", stacklevel=2) del warnpy3k

    or the following if it is an extension module::

    if (PyErr\_WarnPy3k("the XXX module has been removed in" "Python
    3.0", 2) \< 0) return;

    (the Python-Dev TextMate bundle, available from `Misc/TextMate`,
    contains a command that will generate all of this for you).

2.  Update the documentation. For modules with their own documentation
    file, use the `:deprecated:` option with the `module` directive
    along with the `deprecated` directive, stating the deprecation is
    occurring in 2.6, but is for the module's removal in 3.0.::

    .. deprecated:: 2.6 The :mod:`XXX` module has been removed in Python
    3.0.

    For modules simply listed in a file (e.g., `undoc.rst`), use the
    `warning` directive.

3.  Add the module to the module deletion test in `test_py3kwarn`.

4.  Suppress the warning in the module's test code using
    `test.test_support.import_module(name, deprecated=True)`.

5.  Check in the change w/ appropriate `Misc/NEWS` entry (**block** this
    checkin in `py3k`!).

6.  Update this PEP noting that the 2.6 step is done.

Renaming of modules
-------------------

Support in the 2to3 refactoring tool for renames will be used to help
people transition to new module names \[\#2to3\]\_. Import statements
will be rewritten so that only the import statement and none of the rest
of the code needs to be touched. This will be accomplished by using the
`as` keyword in import statements to bind in the module namespace to the
old name while importing based on the new name (when the keyword is not
already used, otherwise the reassigned name should be left alone and
only the module that is imported needs to be changed). The `fix_imports`
fixer is an example of how to approach this.

Python 3.0 //////////

1.  Update 2to3 in the sandbox to support the rename.

2.  Use `svn move` to rename the module.

3.  Update all import statements in the stdlib to use the new name (use
    2to3's `fix_imports` fixer for the easiest solution).

4.  Rename the module in its own documentation.

5.  Update all references in the documentation from the old name to the
    new name.

6.  Run `regrtest.py -uall` to verify the rename worked.

7.  Add an entry in `Misc/NEWS`.

8.  Commit the changes.

Python 2.6 //////////

1.  In the module's documentation, add a note mentioning that the module
    is renamed in Python 3.0::

    .. note:: The :mod:`OLDNAME` module has been renamed to
    :mod:`NEWNAME` in Python 3.0.

2.  Commit the documentation change.

3.  Block the revision in py3k.

Open Issues
===========

Renaming of modules maintained outside of the stdlib
----------------------------------------------------

xml.etree.ElementTree not only does not meet PEP 8 naming standards but
it also has an exposed C implementation \[\#pep-0008\]*. It is an
externally maintained package, though \[\#pep-0360\]*. A request will be
made for the maintainer to change the name so that it matches PEP 8 and
hides the C implementation.

Rejected Ideas
==============

Modules that were originally suggested for removal
--------------------------------------------------

-   asynchat/asyncore

    -   Josiah Carlson has said he will maintain the modules.

-   audioop/sunau/aifc

    -   Audio modules where the formats are still used.

-   base64/quopri/uu

    -   All still widely used.
    -   'codecs' module does not provide as nice of an API for basic
        usage.

-   fileinput

    -   Useful when having to work with stdin.

-   linecache

    -   Used internally in several places.

-   nis

    -   Testimonials from people that new installations of NIS are still
        occurring

-   getopt

    -   Simpler than optparse.

-   repr

    -   Useful as a basis for overriding.
    -   Used internally.

-   sched

    -   Useful for simulations.

-   symtable/\_symtable

    -   Docs were written.

-   telnetlib

    -   Really handy for quick-and-dirty remote access.
    -   Some hardware supports using telnet for configuration and
        querying.

-   Tkinter

    -   Would prevent IDLE from existing.
    -   No GUI toolkit would be available out of the box.

Introducing a new top-level package
-----------------------------------

It has been suggested that the entire stdlib be placed within its own
package. This PEP will not address this issue as it has its own design
issues (naming, does it deserve special consideration in import
semantics, etc.). Everything within this PEP can easily be handled if a
new top-level package is introduced.

Introducing new packages to contain theme-related modules
---------------------------------------------------------

During the writing of this PEP it was noticed that certain themes
appeared in the stdlib. In the past people have suggested introducing
new packages to help collect modules that share a similar theme (e.g.,
audio). An Open Issue was created to suggest some new packages to
introduce.

In the end, though, not enough support could be pulled together to
warrant moving forward with the idea. Instead name simplification has
been chosen as the guiding force for PEPs to create.

References
==========

.. \[\#pep-0004\] PEP 4: Deprecation of Standard Modules
(http://www.python.org/dev/peps/pep-0004/)

.. \[\#pep-0008\] PEP 8: Style Guide for Python Code
(http://www.python.org/dev/peps/pep-0008/)

.. \[\#pep-0324\] PEP 324: subprocess -- New process module
(http://www.python.org/dev/peps/pep-0324/)

.. \[\#pep-0360\] PEP 360: Externally Maintained Packages
(http://www.python.org/dev/peps/pep-0360/)

.. \[\#module-index\] Python Documentation: Global Module Index
(http://docs.python.org/modindex.html)

.. \[\#silly-old-stuff\] Python-Dev email: "Py3k release schedule
worries"
(https://mail.python.org/pipermail/python-3000/2006-December/005130.html)

.. \[\#thread-deprecation\] Python-Dev email: Autoloading?
(https://mail.python.org/pipermail/python-dev/2005-October/057244.html)

.. \[\#py-dev-summary-2004-11-01\] Python-Dev Summary: 2004-11-01
(http://www.python.org/dev/summary/2004-11-01\_2004-11-15/\#id10)

.. \[\#2to3\] 2to3 refactoring tool
(http://svn.python.org/view/sandbox/trunk/2to3/)

.. \[\#pyopengl\] PyOpenGL (http://pyopengl.sourceforge.net/)

.. \[\#pil\] Python Imaging Library (PIL)
(http://www.pythonware.com/products/pil/)

.. \[\#twisted\] Twisted (http://twistedmatrix.com/trac/)

.. \[\#irix-retirement\] SGI Press Release: End of General Availability
for MIPS IRIX Products -- December 2006
(http://www.sgi.com/support/mips\_irix.html)

.. \[\#irix-forms\] FORMS Library by Mark Overmars
(ftp://ftp.cs.ruu.nl/pub/SGI/FORMS)

.. \[\#sun-au\] Wikipedia: Au file format
(http://en.wikipedia.org/wiki/Au\_file\_format)

.. \[\#appscript\] appscript (http://appscript.sourceforge.net/)

.. \[\#ast\] \_ast module (http://docs.python.org/library/ast.html)

.. \[\#ast-removal\] python-dev email: getting compiler package failures
(https://mail.python.org/pipermail/python-3000/2007-May/007615.html)

.. \_PyPI: http://pypi.python.org/

Copyright
=========

This document has been placed in the public domain.

 .. Local Variables: mode: indented-text indent-tabs-mode: nil
sentence-end-double-space: t fill-column: 70 coding: utf-8 End:
