PEP: 8000 Title: Python Language Governance Proposal Overview Author:
Barry Warsaw \<<barry@python.org>\> Status: Active Type: Informational
Content-Type: text/x-rst Created: 2018-08-24

Abstract
========

This PEP provides an overview of the selection process for a new model
of Python language governance in the wake of [Guido\'s
retirement](https://mail.python.org/pipermail/python-committers/2018-July/005664.html).
Once the governance model is selected, it will be codified in PEP 13.

Here is a list of PEPs related to the governance model selection
process. PEPs in the lower 8000s describe the general process for
selecting a governance model.

-   PEP 8001 - Python Governance Voting Process

    This PEP describes how the vote for the new governance model will be
    conducted. It outlines the voting method, timeline, criteria for
    participation, and explicit list of eligible voters.

-   PEP 8002 - Open Source Governance Survey

    Surveys will be conducted of governance models for similar open
    source and free software projects, and summaries of these models
    will be outlined in this PEP. These surveys will serve as useful
    barometers for how such projects can be successfully governed, and
    may serve as inspiration for Python\'s own governance model. Python
    is unique, so it\'s expected that it will have its own spin on
    governance, rather than directly adopting any of those surveyed.

PEPs in the 801Xs describe the actual proposals for Python governance.
It is expected that these PEPs will cover the broad scope of governance,
and that differences in details (such as the size of a governing
council) will be covered in the same PEP, rather than in potentially
vote-splitting individual PEPs.

-   PEP 8010 - The Technical Leader Governance Model

    This PEP proposes a continuation of the singular technical project
    leader model. Also within scope is whether an advisory council aids
    or supports the BDFL. This PEP does *not* name either the next BDFL,
    nor members of such an advisory council. For that, see PEP 13.

-   PEP 8011 - Python Governance Model Lead by Trio of Pythonistas

    This PEP describes a new model of Python governance lead by a Trio
    of Pythonistas (TOP). It describes the role and responsibilities of
    the Trio. This PEP does *not* name members of the Trio. For that,
    see PEP 13.

-   PEP 8012 - The Community Governance Model

    This is a placeholder PEP for a new model of Python governance based
    on consensus and voting, without the role of a centralized singular
    leader or a governing council. It describes how, when, and why votes
    are conducted for decisions affecting the Python language. It also
    describes the criteria for voting eligibility.

-   PEP 8013 - The External Governance Model

    This PEP describes a new model of Python governance based on an
    external council who are responsible for ensuring good process.
    Elected by the core development team, this council may reject
    proposals that are not sufficiently detailed, do not consider all
    affected users, or are not appropriate for the upcoming release.
    This PEP does *not* name members of such a council. For that, see
    PEP 13.

-   PEP 8014 - The Commons Governance Model

    This PEP describes a new model of Python governance based on a
    council of elders who are responsible for ensuring a PEP is
    supported by a sufficient majority of the Python community before
    being accepted. Unlike some of the other governance PEPs it
    explicitly does *not* specify who has voting rights and what a
    majority vote consists of. In stead this is determined by the
    council of elders on a case by case basis.

-   PEP 8015 - Organization of the Python community

    This PEP formalizes the current organization of the Python community
    and proposes 3 main changes: formalize the existing concept of
    \"Python teams\"; give more autonomy to Python teams; replace the
    BDFL (Guido van Rossum) with a new \"Python board\" of 3 members
    which has limited roles, mostly decide how a PEP is approved (or
    rejected).

-   PEP 8016 - The Steering Council Model

    This PEP proposes a model of Python governance based around a
    steering council. The council has broad authority, which they seek
    to exercise as rarely as possible; instead, they use this power to
    establish standard processes, like those proposed in the other
    801x-series PEPs. This follows the general philosophy that it\'s
    better to split up large changes into a series of small changes that
    can be reviewed independently: instead of trying to do everything in
    one PEP, we focus on providing a minimal-but-solid foundation for
    further governance decisions.

Additional governance models may be added before the final selection.

Copyright
=========

This document has been placed in the public domain.


-

> Local Variables: mode: indented-text indent-tabs-mode: nil
> sentence-end-double-space: t fill-column: 70 coding: utf-8 End:
