PEP: 8001 Title: Python Governance Voting Process Author: Brett Cannon
\<<brett@python.org>\>, Christian Heimes \<<christian@python.org>\>,
Donald Stufft \<<donald@stufft.io>\>, Eric Snow
\<<ericsnowcurrently@gmail.com>\>, Gregory P. Smith
\<<greg@krypto.org>\>, Łukasz Langa \<<lukasz@python.org>\> Mariatta
\<<mariatta@python.org>\>, Nathaniel J. Smith \<<njs@pobox.com>\>, Pablo
Galindo Salgado \<<pablogsal@python.org>\>, Raymond Hettinger
\<<python@rcn.com>\>, Tal Einat \<<taleinat@gmail.com>\>, Tim Peters
\<<tim.peters@gmail.com>\>, Zachary Ware \<<zachary.ware@gmail.com>\>
Status: Accepted Type: Process Content-Type: text/x-rst Created:
2018-08-24

Abstract
========

This PEP outlines the process for how the new model of Python governance
is selected, in the wake of [Guido\'s
retirement](https://mail.python.org/pipermail/python-committers/2018-July/005664.html).
Once the model is chosen by the procedures outlined here, it will be
codified in PEP 13.

Motivation and Rationale
========================

Guido\'s stepping down from the BDFL role left us with a meta-problem of
having to choose *how we will choose* how the Python project should be
governed from now on.

This document presents a concrete proposal how this choice can be made.
It summarizes discussion and conclusions of the proceedings of a working
group at the core sprint in Redmond in September 2018 (names of all
attendees are listed as authors). This PEP also summarizes a [subsequent
thread](https://discuss.python.org/t/python-governance-electoral-system/290)
that took place on discuss.python.org .

The governance situation should be resolved in a timely fashion. Ideally
that should happen by the end of the 2018 which unblocks substantial
improvements to be merged in time for Python 3.8. At the latest, the
governance situation needs to be resolved by PyCon US 2019 to avoid a PR
crisis.

Implementation
==============

What are we voting for?
-----------------------

We are voting to choose which governance PEP should be implemented by
the Python project. The list of candidate PEPs is listed in PEP 8000 and
consists of all PEPs numbered in the 801X range.

To ensure the vote is legitimate, the aforementioned PEPs must not be
modified during the voting period.

Who gets to vote?
-----------------

Every CPython core developer is invited to vote. In the interest of
transparency and fairness, we are asking core developers to self-select
based on whether the governance situation will affect them directly. In
other words, we are recommending for inactive core developers *who
intend to remain inactive* to abstain from voting.

When is the vote?
-----------------

November 16th, 2018 to November 30th, 2018 is the official governance
PEP review period. We discourage the PEP authors from making major
substantive changes during this period, although it is expected that
minor tweaks may occur, as the result of this discussion period.

The vote will happen in a 2-week-long window from December 1st, 2018 to
December 16th, 2018 ([Anywhere on
Earth](https://en.wikipedia.org/wiki/Anywhere_on_Earth)).

Where is the vote?
------------------

The vote will happen using a \"private\" poll on the [Condorcet Internet
Voting Service](https://civs.cs.cornell.edu/). Every committer will
receive an email with a link allowing them to rank the PEPs in their
order of preference.

The election will be supervised by Ernest W. Durbin III, The PSF
Director of Infrastructure.

The results of the election, including anonymized ballots, will be made
public on December 17th, after the election has closed.

The following settings will be used for the vote in the CIVS system:

Name of the poll: `Python governance vote (December 2018)`

Description of the poll:

    This is the vote to choose how the CPython project will govern
    itself, now that Guido has announced his retirement as BDFL. For
    full details, see <a
    href="https://www.python.org/dev/peps/pep-8001/">PEP
    8001</a>. Many discussions have occurred under <a
    href="https://discuss.python.org/tags/governance">the "governance"
    tag</a> on discuss.python.org.
    <p>
    All votes must be received <b>by the end of December 16th, 2018, <a
    href="https://en.wikipedia.org/wiki/Anywhere_on_Earth">Anywhere on
    Earth</a></b>. All CPython core developers are <a
    href="https://github.com/python/voters">eligible to vote</a>.
    It is asked that inactive core developers <i>who intend to remain
    inactive</i> abstain from voting.
    <p>
    <b>Note: You can only vote once, and all votes are final.</b> Once
    you click "Submit ranking", it's too late to change your mind.
    <p>
    All ballots will be published at the end of voting, but <b>without
    any names attached</b>. No-one associated with the Python project or
    the PSF will know how you voted, or even whether you voted.
    <p>
    If you have any questions, you can post in <a
    href="https://discuss.python.org/c/committers">the Committers
    topic</a>, on <a href="mailto:python-committers@python.org">the
    python-committers list</a>, or <a
    href="mailto:ewdurbin@gmail.com">contact the vote administrator
    directly</a>.
    <p>
    <h1>Options</h1>
    <p>
    We're selecting between seven PEPs, each proposing a different
    governance model.
    <p>
    The options below include links to the text of each PEP, as well
    as their complete change history. The text of these PEPs was
    frozen on December 1, when the vote started. But if you looked at
    the PEPs before that, they might have changed. Please take the
    time to check the current text of the PEPs if you read an older
    draft.
    <p>
    A "Further discussion" option is also included. It represents the
    option of not making a choice at all at this time, and continuing
    the discussion instead. Including this option lets us demonstrate
    the core team's readiness to move forward.
    <p>
    If you think a proposal is a particularly bad idea, you can
    express that by ranking it below "Further discussion". If you
    think all of the proposals are better than further discussion,
    then you should rank "Further discussion" last.

Candidates (note: linebreaks are significant here):

    <a href="https://www.python.org/dev/peps/pep-8010/">PEP 8010: The Technical Leader Governance Model</a> (Warsaw) (<a href="https://github.com/python/peps/commits/master/pep-8010.rst">changelog</a>)
    <a href="https://www.python.org/dev/peps/pep-8011/">PEP 8011: Python Governance Model Lead by Trio of Pythonistas</a> (Mariatta, Warsaw) (<a href="https://github.com/python/peps/commits/master/pep-8011.rst">changelog</a>)
    <a href="https://www.python.org/dev/peps/pep-8012/">PEP 8012: The Community Governance Model</a> (Langa) (<a href="https://github.com/python/peps/commits/master/pep-8012.rst">changelog</a>)
    <a href="https://www.python.org/dev/peps/pep-8013/">PEP 8013: The External Council Governance Model</a> (Dower) (<a href="https://github.com/python/peps/commits/master/pep-8013.rst">changelog</a>)
    <a href="https://www.python.org/dev/peps/pep-8014/">PEP 8014: The Commons Governance Model</a> (Jansen) (<a href="https://github.com/python/peps/commits/master/pep-8014.rst">changelog</a>)
    <a href="https://www.python.org/dev/peps/pep-8015/">PEP 8015: Organization of the Python community</a> (Stinner) (<a href="https://github.com/python/peps/commits/master/pep-8015.rst">changelog</a>)
    <a href="https://www.python.org/dev/peps/pep-8016/">PEP 8016: The Steering Council Model</a> (Smith, Stufft) (<a href="https://github.com/python/peps/commits/master/pep-8016.rst">changelog</a>)
    Further discussion

Options:

    [x] Private
    [ ] Make this a test poll: read all votes from a file.
    [ ] Do not release results to all voters.
    [x] Enable detailed ballot reporting.
        [ ] In detailed ballot report, also reveal the identity of the voter with each ballot.
    [ ] Allow voters to write in new choices.
    [ ] Present choices on voting page in exactly the given order.
    [ ] Allow voters to select “no opinion” for some choices.
    [ ] Enforce proportional representation

These options will have the effect of:

-   Making the election \"private\", or in other words, invite only.
-   The results of the election will be released to all voters.
-   The contents of every ballot will be released to the public, along
    with a detailed report going over how the winner was elected.
-   The detailed ballots will *not* include any identifying information
    and the email addresses of the voters will be thrown away by the
    CIVS system as soon as the email with their voting link has been
    sent.
-   Voters will *not* be able to write in new choices, meaning they will
    be limited only to the options specified in the election.
-   Voters will *not* have the ability to change their vote after
    casting a ballot. [\[no-changes\]](#no-changes){.citation}
-   The default ordering for each ballot will be randomized to remove
    any influence that the order of the ballot may have on the election.
-   Voters will have to rank all choices somehow, but may rank multiple
    choices as equal.

Voting mechanics
----------------

The vote will be by ranked ballot. Every voter orders all candidate PEPs
from the most preferred to the least preferred. The vote will be tallied
and a winner chosen using the [Condorcet
method](https://en.wikipedia.org/wiki/Condorcet_method).

Note: each voter can only cast a single vote with no ability to revise
their vote later. [\[no-changes\]](#no-changes){.citation} If you are
not absolutely sure of your choices, hold off casting your ballot until
later in the voting period. Votes cast on the last day of the election
are just as valid as the ones cast on the first day.

While the CIVS system does not provide an option for a \"Pure\"
Condorcet election, any Condorcet method will select the \"Pure\"
Condorcet winner if one exists and otherwise only vary if one doesn\'t
exist. The CIVS system differentiates between a Condorcet winner and a
non Condorcet winner by stating if the winner was a Condorcet winner, or
if it merely wasn\'t defeated versus any other option. So a winner in
the CIVS system will only be accepted if it states it was a Condorcet
winner.

In the unlikely case of a tie (or cycle as is possible under the
Condorcet method), a new election will be opened, limited to the options
involved in the tie or cycle, to select a new winner from amongst the
tied options. This new election will be open for a week, and will be
repeated until a single winner is determined.

Questions and Answers
=====================

Why the Condorcet method?
-------------------------

1.  It allows voters to express preference by ranking PEPs
2.  It is [consensus
    decision-making](https://en.wikipedia.org/wiki/Consensus_decision-making#Condorcet_consensus)
3.  In a
    [poll](https://discuss.python.org/t/python-governance-electoral-system/290/26)
    open to only core developers and run using Approval voting, it was
    the clear preference

Is omitting any candidate PEPs in the ranking allowed?
------------------------------------------------------

A vote which omits candidates in the ranking is invalid. This is because
such votes are incompatible with the desired properties listed above,
namely:

-   Making voters consider alternatives, as well as
-   Doing everything possible to reach a conclusion in a single
    election.

Why recommend for dormant core developers to not vote?
------------------------------------------------------

The choice of the governance model will have far reaching and long-term
consequences for Python and its community. We are inviting core
developers to assess their skin in the game.

Note: this is not an edict and will not be policed. We trust all members
of the core team to act in the best interest of Python.

Why should the vote be private?
-------------------------------

When discussing the election system, a number of core developers
expressed concerns with the idea of having public ballots, with at least
one core developer stating that they were planning on abstaining from
voting altogether due to the use of a public ballot. A poll ran on
Discourse identified the overwhelming majority of voters prefer private
ballots. [\[private-vote\]](#private-vote){.citation}

A secret ballot is considered by many to be a requirement for a free and
fair election, allowing members to vote their true preferences without
worry about social pressure or possible fallout for how they may have
voted.

Why the use of CIVS?
--------------------

In the resulting discussion of this PEP, it was determined that core
developers wished to have a secret ballot.
[\[private-vote\]](#private-vote){.citation} Unfortunately a secret
ballot requires either novel cryptography or a trusted party to
anonymize the ballots. Since there is not known to be any existing novel
cryptographic systems for Condorcet ballots, the CIVS system was chosen
to act as a trusted party.

More information about the security and privacy afforded by CIVS,
including how a malicious voter, election supervisor, or CIVS
administrator can influence the election can be be found
[here](https://civs.cs.cornell.edu/sec_priv.html).

Why cannot voters change their vote?
------------------------------------

CIVS does not allow voters to update their vote and as part of its goal
to prevent the election supervisor from being able to influence the
votes.

Are there any deficiencies in the Condorcet method?
---------------------------------------------------

There is no perfect voting method. It has been shown by the
[Gibbard-Satterthwaite
theorem](https://en.wikipedia.org/wiki/Gibbard%E2%80%93Satterthwaite_theorem)
that any single-winner ranked voting method which is not dictatorial
must be susceptible to so-called \"tactical voting\". This can lead to
people not voting as they truly believe in order to influence the
outcome.

The Condorcet method also has the possibility of having cycles (known as
the [Condorcet
paradox](https://en.wikipedia.org/wiki/Condorcet_paradox)). Due to the
fact that the Condorcet method chooses a winner based on whether they
would win against the other options in a 1-on-1 race, there is a
possibility that PEP A \> PEP B \> PEP C \> PEP A (or in terms of the
game rock-paper-scissors, imagine a three-player game where someone
played rock, another played paper, and the last person played scissors;
no one wins that game as everyone is defeated by someone). For one
analyzed set of real-world elections with 21 voters or more, a cycle
occurred [less than 1.5% of the
time.](https://www.accuratedemocracy.com/l_cycles.htm).

References
==========

Copyright
=========

This document has been placed in the public domain.

### 

> Local Variables: mode: indented-text indent-tabs-mode: nil
> sentence-end-double-space: t fill-column: 70 coding: utf-8 End:

::: {#citations}

[no-changes]{#no-changes .citation-label}

:   <https://discuss.python.org/t/pep-8001-public-or-private-ballots/374/20>

[private-vote]{#private-vote .citation-label}

:   <https://discuss.python.org/t/pep-8001-public-or-private-ballots/374/4>
:::
