PEP: 8010 Title: The Technical Leader Governance Model Author: Barry
Warsaw \<<barry@python.org>\> Status: Rejected Type: Informational
Content-Type: text/x-rst Created: 2018-08-24

Abstract
========

This PEP proposes a continuation of the singular technical project
leader model, euphemistically called the [Benevolent Dictator For
Life](https://en.wikipedia.org/wiki/Benevolent_dictator_for_life) (BDFL)
model of Python governance, to be henceforth called in this PEP the
Gracious Umpire Influencing Decisions Officer (GUIDO). This change in
name reflects both the expanded view of the GUIDO as final arbiter for
the Python language decision making process in consultation with the
wider development community, and the recognition that \"for life\" while
perhaps aspirational, is not necessarily in the best interest of the
well-being of either the language or the GUIDO themselves.

This PEP describes:

-   The rationale for maintaining the singular technical leader model
-   The process for how the GUIDO will be selected, elected, retained,
    recalled, and succeeded;
-   The roles of the GUIDO in the Python language evolution process;
-   The term length of service;
-   The relationship of the GUIDO with a Council of Pythonistas (CoP)
    that advise the GUIDO on technical matters;
-   The size, election, and roles of the CoP;
-   The decision delegation process;
-   Any changes to the PEP process to fit the new governance model;

This PEP does *not* name a new BDFL. Should this model be adopted, it
will be codified in PEP 13 along with the names of all officeholders
described in this PEP.

PEP Rejection
=============

PEP 8010 was rejected [by a core developer
vote](https://discuss.python.org/t/python-governance-vote-december-2018-results/546/)
described in PEP 8001 on Monday, December 17, 2018.

PEP 8016 and the governance model it describes were chosen instead.

Open discussion points
======================

Various tweaks to the parameters of this PEP are allowed during the
governance discussion process, such as the exact size of the CoP, term
lengths of service, and voting procedures. These will be codified by the
time the PEP is ready to be voted on.

The voting procedures and events described in this PEP will default to
the voting method specified in PEP 8001, although as that PEP is still
in discussion at the time of this writing, this is subject to change.

It is allowed, and perhaps even expected, that as experience is gained
with this model, these parameters may be tweaked as future GUIDOs are
named, in order to provide for a smoother governing process.

Why a singular technical leader?
================================

Why this model rather than any other? It comes down to \"vision\".
[Design by committee](https://en.wikipedia.org/wiki/Design_by_committee)
has many known downsides, leading to a language that accretes new
features based on the varied interests of the contributors at the time.
A famous aphorism is \"a camel is a horse designed by committee\". Can a
language that is designed by committee \"hang together\"? Does it feel
like a coherent, self-consistent language where the rules make sense and
are easily remembered?

A singular technical leader can promote that vision more than a
committee can, whether that committee is small (e.g. 3 or 5 persons) or
spans the entire Python community. Every participant will have their own
vision of what \"Python\" is, and this can lead to indecision or
illogical choices when those individual visions are in conflict. Should
CPython be 3x faster or should we preserve the C API? That\'s a very
difficult question to get consensus on, since neither choice is right or
wrong. But worse than making the wrong decision might be accepting the
status quo because no consensus could be found.

Flexibility
===========

Degrees of flexibility are given to both the GUIDO and CoP by way of
underspecification. This PEP describes how conflicts will be resolved,
but expects all participants, including core developers, community
members, and office holders, to always have the best interest of Python
and its users at heart. The PEP assumes that mutual respect and the best
intentions will always lead to consensus, and that the Code of Conduct
governs all interactions and discussions.

The role of the GUIDO
=====================

One of the most important roles of the GUIDO is to provide an
overarching, broad, coherent vision for the evolution of the Python
language, spanning multiple releases. This is especially important when
decision have lasting impact and competing benefits. For example, if
backward incompatible changes to the C API leads to a 2x improvement in
Python performance, different community members will likely advocate
convincingly on both sides of the debate, and a clear consensus may not
emerge. Either choice is equally valid. In consultation with the CoP, it
will be the GUIDO\'s vision that guides the ultimate decision.

The GUIDO is the ultimate authority for decisions on PEPs and other
issues, including whether any particular change is PEP-worthy. As is the
case today, many \--in fact perhaps most\-- decisions are handled by
discussion and resolution on the issue tracker, merge requests, and
discussion forums, usually with input or lead by experts in the
particular field. Where this operating procedure works perfectly well,
it can continue unchanged. This also helps reduce the workload on the
CoP and GUIDO, leaving only the most important decisions and broadest
view of the landscape to the central authority.

Similarly, should a particular change be deemed to require a PEP, but
the GUIDO, in consultation with the CoP, identifies experts that have
the full confidence to make the final decision, the GUIDO can name a
Delegate for the PEP. While the GUIDO remains the ultimate authority, it
is expected that the GUIDO will not undermine, and in fact will support
the authority of the Delegate as the final arbiter of the PEP.

The GUIDO has full authority to shut down unproductive discussions,
ideas, and proposals, when it is clear that the proposal runs counter to
the long term vision for Python. This is done with compassion for the
advocates of the change, but with the health and well-being of all
community members in mind. A toxic discussion on a dead-end proposal
does no one any good, and they can be terminated by fiat.

To sum up: the GUIDO has the authority to make a final pronouncement on
any topic, technical or non-technical, except for changing to the
governance PEP itself.

Authority comes from the community
==================================

The GUIDO\'s authority ultimately resides with the community. A rogue
GUIDO that loses the confidence of the majority of the community can be
recalled and a new vote conducted. This is an exceedingly rare and
unlikely event. This is a sufficient stopgap for the worst case
scenario, so it should not be undertaken lightly. The GUIDO should not
fear being deposed because of one decision, even if that decision isn\'t
favored by the majority of Python developers. Recall should be reserved
for actions severely detrimental to the Python language or community.

The Council of Pythonistas (see below) has the responsibility to
initiate a vote of no-confidence.

Length of service and term limits
=================================

The GUIDO shall serve for three Python releases, approximately 4.5 years
given the current release cadence. If Python's release cadence changes,
the length of GUIDO's term should change to 4.5 years rounded to whole
releases. How the rounding is done is left to the potential release
cadence PEP. After this time, a new election is held according to the
procedures outlined below. There are no term limits, so the GUIDO may
run for re-election for as long as they like.

We expect GUIDOs to serve out their entire term of office, but of
course, Life Happens. Should the GUIDO need to step down before their
term ends, the vacancy will be filled by the process outlined below as
per choosing a new GUIDO. However, the new GUIDO will only serve for the
remainder of the original GUIDO\'s term, at which time a new election is
conducted. The GUIDO stepping down may continue to serve until their
replacement is selected.

During the transition period, the CoP (see below) may carry out the
GUIDO\'s duties, however they may also prefer to leave substantive
decisions (such as technical PEP approvals) to the incoming GUIDO.

Choosing a GUIDO
================

The selection process is triggered whenever a vacancy exists for a new
GUIDO, or when the GUIDO is up for re-election in the normal course of
events. When the selection process is triggered, either by the GUIDO
stepping down, or two months before the end of the GUIDO\'s regular
term, a new election process begins.

For three weeks prior to the vote, nominations are open. Candidates must
be chosen from the current list of core Python developers. Non-core
developers are ineligible to serve as the GUIDO. Candidates may
self-nominate, but all nominations must be seconded. Nominations and
seconds are conducted as merge requests on a private repository.

Once they accept their nomination, nominees may post short position
statements using the same private repository, and may also post them to
the committers discussion forum. Maybe we\'ll even have debates! This
phase of the election runs for two weeks.

Core developers then have three weeks to vote, using the process
described in PEP 8001.

The Council of Pythonistas (CoP)
================================

Assisting the GUIDO is a small team of elected Python experts. They
serve on a team of technical committee members. They provide insight and
offer discussion of the choices before the GUIDO. Consultation can be
triggered from either side. For example, if the GUIDO is still undecided
about any particular choice, discussions with the CoP can help clarify
the remaining issues, identify the right questions to ask, and provide
insight into the impact on other users of Python that the GUIDO may not
be as familiar with. The CoP are the GUIDO\'s trusted advisers, and a
close working relationship is expected.

The CoP shall consist of 3 members, elected from among the core
developers. Their term runs for 3 years and members may run for
re-election as many times as they want. To ensure continuity, CoP
members are elected on a rotating basis; every year, one CoP member is
up for re-election.

In order to bootstrap the stagger for the initial election, the CoP
member with the most votes shall serve for 3 years, the second most
popular vote getter shall serve for 2 years, and CoP member with the
least number of votes shall serve initially for 1 year.

All ties in voting will be broken with a procedure to be determined in
PEP 8001.

The nomination and voting process is similar as with the GUIDO. There is
a three week nomination period, where self-nominations are allowed and
must be seconded, followed by a period of time for posting position
statements, followed by a vote.

By unanimous decision, the CoP may begin a no-confidence vote on the
GUIDO, triggering the procedure in that section.

No confidence votes
===================

As mentioned above, the CoP may, by unanimous decision, initiate a vote
of no-confidence in the GUIDO. This process should not be undertaken
lightly, but once begun, it triggers up to two votes. In both cases,
voting is done by the same procedure as in PEP 8001, and all core
developers may participate in no confidence votes.

The first vote is whether to recall the current GUIDO or not. Should a
super majority of Python developers vote \"no confidence\", the GUIDO is
recalled. A second vote is then conducted to select the new GUIDO, in
accordance with the procedures for initial section of this office
holder. During the time in which there is no GUIDO, major decisions are
put on hold, but normal Python operations may of course continue.

Day to day operations
=====================

The GUIDO is not needed for all \-- or even most \-- decisions. Python
developers already have plenty of opportunity for delegation,
responsibility, and self-direction. The issue tracker and pull requests
serve exactly the same function as they did before this governance model
was chosen. Most discussions of bug fixes and minor improvements can
just happen on these forums, as they always have.

PEP considerations
==================

The GUIDO, members of the CoP, and anyone else in the Python community
may propose a PEP. Treatment of the prospective PEP is handled the same
regardless of the author of the PEP.

However, in the case of the GUIDO authoring a PEP, an impartial PEP
Delegate should be selected, and given the authority to accept or reject
the PEP. The GUIDO should recuse themselves from the decision making
process. In the case of controversial PEPs where a clear consensus does
not arrive, ultimate authority on PEPs authored by the GUIDO rests with
the CoP.

The PEP propose is further enhanced such that a core developer must
always be chose as the PEP Shepherd. This person ensure that proper
procedure is maintained. The Shepherd must be chosen from among the core
developers. This means that while anyone can author a PEP, all PEPs must
have some level of sponsorship from at least one core developer.

Version History
===============

Version 2

> -   Renamed to \"The Technical Leader Governance Model\"
> -   \"singular leader\" -\> \"singular technical leader\"
> -   The adoption of PEP 8001 voting procedures is tentative until that
>     PEP is approved
> -   Describe what happens if the GUIDO steps down
> -   Recall votes require a super majority of core devs to succeed

Copyright
=========

This document has been placed in the public domain.


-

> Local Variables: mode: indented-text indent-tabs-mode: nil
> sentence-end-double-space: t fill-column: 70 coding: utf-8 End:
