PEP: 8012 Title: The Community Governance Model Author: Łukasz Langa
\<<lukasz@python.org>\> Status: Rejected Type: Informational
Content-Type: text/x-rst Created: 2018-10-03

PEP Rejection
=============

PEP 8012 was rejected [by a core developer
vote](https://discuss.python.org/t/python-governance-vote-december-2018-results/546/)
described in PEP 8001 on Monday, December 17, 2018.

PEP 8016 and the governance model it describes were chosen instead.

Abstract
========

This PEP proposes a new model of Python governance based on consensus
and voting by the Python community. This model relies on workgroups to
carry out the governance of the Python language. This governance model
works without the role of a centralized singular leader or a governing
council.

It describes how, when, and why votes are conducted for decisions
affecting the Python language. It also describes the criteria for voting
eligibility.

Should this model be adopted, it will be codified in PEP 13.

This model can be affectionately called \"The Least Worst Governance
Model\" by its property that while far from ideal, it\'s still the most
robust one compared to the others. Since avoiding issues inherent to the
other models is a paramount feature of the Community Governance Model,
we start the discussion a bit unusually: by rejecting the other models.

Rejected Models
===============

Let\'s have another BDFL
------------------------

This seems like a very attractive idea because it\'s a model we know.
One Dictator to rule us all.

### Challenge: There is no other Guido

There is no other single person with the unique skillset of Guido van
Rossum. Such a person would need to have the technical, communication,
and organizational experience to lead the project successfully.
Specifically, the person would need to:

-   set and articulate a cohesive long-term vision for the project;
-   possess deep technical understanding of the runtime, the standard
    library, and the wider third-party library context;
-   negotiate and resolve contentious issues in ways acceptable to all
    parties involved;
-   have free time and possess the energy to sustain continuous
    involvement over periods of years.

### Risk: Malevolent Dictator For Life

What if we got somebody who is not as well suited for the position as
our first Dictator? There are possible scenarios in which this could
lead to severe consequences.

The Dictator could gather insufficient trust due to missing technical
depth, a \"close\" election, inconsistent vision, poor ability to deal
with conflict or burnout, and so on. Given a controversial decision
decided by the Dictator in a specific way, a Dictator with insufficient
trust may cause a split within the project.

The Dictator setup invites lobbying concentrated on a single person.
Unless that person is immune to leverage due to wealth, health, and a
stable life situation, this poses risk of malicious actors steering the
project from behind the curtain.

Finally, the Dictator coming from a particular part of the community may
put more weight on the needs and interests of that particular part of
the user base, alienating others.

### Observation: We don\'t actually need a Dictator

The irony of the Dictator model is that it requires an election. Better
yet, we need an election to even decide on which governance model to
use.

If we are already able solve two problems of this gravity via the
community process, why not keep using it for all subsequent decisions?

### Risk: The warm and fuzzy feeling of a vague proposal

One last thing worth mentioning is that when a BDFL model is suggested,
it\'s easy to bypass the criticism above by not mentioning *who* the
BDFL should be. That way the hopeful reader can project their best
expectations and wants onto the abstract BDFL, making the idea appear
more attractive. This is a mistake.

Without naming the BDFL in the model proposal we are not talking about a
concrete model. We can avoid asking and answering the hard questions. We
can imagine our best-case scenario, a candidate we\'d like to serve the
role.

Omitting a name for the BDFL also puts the Community Model at an unfair
disadvantage. We already know the good, the bad, and the ugly of our
core developer group. It\'s no platonic ideal, no perfect sphere with no
friction. In fact, we expect there to be a fair amount of friction and
imperfections.

Thus, to fairly assess the BDFL model proposal, dear reader, you should
imagine the worst possible person within our team as that BDFL. A
concrete human being. Imagine it\'s me.

**Conclusion** While this has been our history, without Guido, this
model does not serve the best interests of the language into the future.

Let\'s have a Council
---------------------

This group of people roughly shares the responsibilities of a Dictator.
The group can also be called a Triumvirate, a Quorum, Elders, Steering
Committee, and so on.

### Risk: Dilution and confusion

This model favors a small group, between three to five people. That way
it shares most of the criticism with the Dictator model, amplified.
Having not one but, say, three people in position of power dilutes
responsibility while still providing high risk of lobbying, insufficient
trust, or alienating parts of the community.

### Risk: Internal Conflict

Additionally, having multiple people share the responsibility of
governance creates ample opportunity for internal conflict, inconsistent
long-term vision of the project, and multiplies the required continuous
time involvement by its members (it\'s no Quorum if they can\'t \"reach
quorum\" due to other time commitments).

Just like with a frictionless spherical BDFL, reject ideas of Councils
without considering how would it work for you if that Council consisted
of three people you find inadequate for the role. Imagine if I had two
friends.

Most importantly, just like with a Dictator, we don\'t need a Council.
By the time we had one, we would have already had two successful
elections. Why not keep voting?

**Conclusion** This model has similar risks like a Dictator, only worse.

Motivation
==========

Now that we rejected the basics of other governance models, let\'s talk
why we even need a governance model on top of a loosely defined group of
committers.

**Stability and Reliability** We want to prevent single committers from
making wide-reaching changes that impact the future of the language or
its usability. Coherent vision and backwards compatibility are important
in any programming language, but they are doubly important for Python
which is very dynamic (e.g. has very complex backwards compatibility
implications).

**Diverse Uses of Python** Moreover, Python is used by a diverse group
of users, from school children through scientists to corporations with
multi-million line codebases. We want to include all our varied
audiences.

**Vitality** We want to avoid stagnation. Python is a mature project but
it needs to keep evolving to stay relevant, both the runtime and the
programming language. To do that, people interested in improving a
particular part of the project should be able to do so without needless
friction. But for substantial changes, we want some discourse and
reflection to ensure the changes are wise.

Rationale
=========

**Inclusive** The Community Model is the most inclusive model. No single
person or a small group of people is in a distinguished position of
power over others. Contributors and any workgroups in this model are
self-selecting.

**Pragmatic** This model ensures no user group is put at a disadvantage
due to the interests of a single person or a small group of people.

**Proven** This model works. There is a number of large open-source
projects run this way (two of which, Rust and Django, are described in
PEP 8002). ECMAScript and C++ are similarly developed.

Specification
=============

Key people and their functions
------------------------------

### The core team

The Python project is developed by a team of core developers. While
membership is determined by presence in the \"Python core\" team in the
\"python\" organization on GitHub, contribution takes many forms:

-   committing changes to the repository;
-   reviewing pull requests by others;
-   triaging bug reports on the issue tracker;
-   discussing topics on official Python communication channels.

Some contributors are may be considered dormant, in other words they did
not contribute to the last two releases of CPython. Any dormant
contributor can at any time resume contribution.

### Experts

The Python Developer\'s Guide lists a number of interest areas along
with names of core developers who are recognized as experts in the given
area. An expert or a sub-team of experts has the following
responsibilities:

-   responding to issues on the bug tracker triaged to the given
    interest area on a timely basis;
-   reviewing pull requests identified as belonging to the given
    interest area on a timely basis;
-   overviewing cohesive design in the evolution of the given interest
    area.

A core developer can assign and unassign themselves at will to a given
interest area. Existing experts listed for the given interest area must
be made aware of this change and have to unanimously agree to it.

If a given interest area lists multiple experts, they form a sub-team
within the core team. They are responsible for the given interest area
together.

A core developer should avoid membership as an expert in too many
interest areas at the same time. This document deliberately doesn\'t
specify a maximum number, it simply signals that overexertion leads to
burnout and is a risk to the project\'s ability to function without a
given contributor.

### Moderators

There is a group of people, some of which are not core developers,
responsible for ensuring that discussions on official communication
channels adhere to the Code of Conduct. They take action in view of
violations.

Regular decision process
------------------------

Primary work happens through bug tracker issues and pull requests. Core
developers should avoind pushing their changes directly to the cpython
repository, instead relying on pull requests. Approving a pull request
by a core developer allows it to be merged without further process.

Notifying relevant experts about a bug tracker issue or a pull request
is important. Reviews from experts in the given interest area are
strongly preferred, especially on pull request approvals. Failure to do
so might end up with the change being reverted by the relevant expert.

Experts are not required to listen to the firehose of GitHub and bug
tracker activity at all times. Notifying an expert explicitly during
triage or bug/pull request creation may be necessary to get their
attention.

Controversial decision process
------------------------------

Substantial changes in a given interest area require a PEP. This
includes:

-   Any semantic or syntactic change to the language.
-   Backwards-incompatible changes to the standard library or the C API.
-   Additions to the standard library, including substantial new
    functionality within an existing library.
-   Removing language, standard library, or C API features.

Failure to get a substantial change through the PEP process might result
with the change being reverted.

Changes that are bug fixes can be exempt from the PEP requirement. Use
your best judgement.

### PEP, Enhanced

The PEP process is augmented with the following changes and
clarifications over information already present in PEP 1:

-   PEPs are not merged until the final decision is made on them; they
    are open pull requests on GitHub until that moment;
    -   to make review easier, all changes to the PEP under review
        should be made as separate commits, allowing for granular
        comparison;
-   a submitted PEP needs to identify the area of interest and relevant
    experts as the body that makes the final decision on it;
-   if the PEP author is one of the experts of the relevant area of
    interest, they must name another person from outside of that
    interest area to contribute to the final decision in their place;
-   the PEP author is responsible for gathering and integrating feedback
    on the PEP using the official communication channels, with the goal
    of building consensus;
-   all community members must be enabled to give feedback;
-   at some point, one of the named experts posts a \"summary comment\"
    that lays out the current state of discussion, especially major
    points of disagreement and tradeoffs; at the same time the expert
    proposes a \"motion for final comment period\" (**FCP**), along with
    a proposed disposition to either:
    -   accept;
    -   accept provisionally;
    -   reject; or
    -   defer the PEP.
-   to enter the FCP, the PEP must be signed off by all experts of the
    relevant area of interest;
-   the FCP lasts for fourteen calendar days to allow stakeholders to
    file any final objections before a decision is reached.

### Very controversial PEPs

If a core contributor feels strongly against a particular PEP, during
its FCP they may raise a motion to reject it by vote. Voting details are
described below in \"Voting Mechanics\".

This should be a last resort and thus a rare occurrence. It splits the
core team and is a stressful event for all involved. However, the
experts filing for a FCP for a PEP should have a good sense whether a
motion to reject it by vote is likely. In such a case, care should be
taken to avoid prematurely filing for a FCP.

There is no recourse for the opposite situation, i.e. when the experts
want to reject a PEP but others would like it accepted. This ensures
that the relevant experts have the last say on what goes in. If you
really want that change, find a way to convince them.

Moderators on official communication channels enforce the Code of
Conduct first and foremost, to ensure healthy interaction between all
interested parties. Enforcement can result in a given participant being
excluded from further discussion and thus the decision process.

### Revisiting deferred and rejected PEPs

If a PEP is deferred or rejected, the relevant experts should be
contacted first before another attempt at the same idea is made. If the
experts agree there is substantial evidence to justify revisiting the
idea, a pull request editing the deferred or rejected PEP can be opened.

Failure to get proper expert buy-in beforehand will likely result in
immediate rejection of a pull request on a deferred or rejected PEP.

Other Voting Situations
-----------------------

### Nominating a new core developer

A champion nominates a person to become a new core developer by posting
on official communication channels. A vote is opened.

If any existing core developer does not feel comfortable with the
nominee receiving the commit bit, they should preferably address this
concern in the nomination thread. If there is no satisfactory
resolution, they can cast a negative vote.

In practice, nominating a person for a core developer should often meet
with surprise by others that this person is not a core developer yet. In
other words, it should be done when the candidate is already known and
trusted well enough by others. We should avoid nominations based on
*potential*.

### Votes of no confidence

-   Removing a core developer from the core team;
-   Disbanding the experts team for a given area of interest.

Those describe a situation where a core developer is forcefully removed
from the core team or an experts team is forcefully disbanded. Hopefully
those will never have to be exercised but they are explicitly mentioned
to demonstrate how a dysfunctional area of interest can be healed.

If a core developer is removed by vote from the core team, they lose the
ability to interact with the project. It\'s up to the Moderators\'
discretion to remove their ability to post on the bug tracker and GitHub
or just moderate their future behavior on a case-by-case basis.

If the experts team for an area of interest is disbanded, other core
developers can step up to fill the void at will. Members of the
disbanded experts team cannot self-nominate to return.

Voting Mechanics
----------------

All votes described in this document are +1/-1/0
(\"Yea\"/\"Nay\"/\"Present\") recorded votes. There are no other vote
values, in particular values out of range or fractions (like +0.5) are
invalid.

Votes take fourteen calendar days. The starting date is taken looking at
the timezone of the person who filed for the motion to vote. The end
date is fourteen days later Anywhere-On-Earth.

Dormant core developers as defined in \"Key people and their functions\"
above are not counted towards the totals if they abstain. However, they
can vote if they choose to do so and that way they count as active.
Voting is a form of contribution.

Voting is done by a commit to a private repository in the \"python\"
organization on GitHub. The repository is archived and publicized after
the voting period is over. The repository\'s name should start with
\"vote-\".

Changes to one\'s vote during the voting period is allowed. Peeking at
other developers\' cast votes during the time of the vote is possible.

Every situation requires a different vote percentage:

-   PEP rejection by vote requires over 1/3rd of the non-dormant core
    developer population to explicitly vote to reject. Note that if more
    than 1/3rd of core developers decide against a PEP, this means there
    exists no super-majority of core developers who are in favor of the
    change. This strongly suggests the change should not be made in the
    shape described by the PEP.
-   New core developer nomination requires there to be no votes cast
    against it.
-   Votes of no confidence require a super-majority of at least 2/3rds
    of the non-dormant core developer population to explicitly vote in
    favor of the motion.

Omissions
=========

This document deliberately omits listing possible areas of interest
within the project. It also does not address election and management of
Moderators which are done by the Python Software Foundation and its Code
of Conduct Working Group which can be contacted by mailing
<conduct-wg@python.org>.

Acknowledgements
================

Thank you to the authors of PEP 8002 which was a helpful resource in
shaping this document.

Thank you to Alex Crichton and the Rust team for a governance model that
was a major inspiration for this document.

Copyright
=========

This document has been placed in the public domain.

#### 

> Local Variables: mode: indented-text indent-tabs-mode: nil
> sentence-end-double-space: t fill-column: 70 coding: utf-8 End:
